<?php

//--------------------------------------------------------------------------------------------------
function pager_link($link_text, $url, $icon=false)
{
	global $path_to_root;
	
	if (user_graphic_links() && $icon)
		$link_text = set_icon($icon, $link_text);

	$href = $path_to_root . $url;
	return "<a href='$href'>" . $link_text . "</a>";
}

function navi_button($name, $value, $enabled=true, $icon = false) {
	global $path_to_root;
  	return "<button ". ($enabled ? '':'disabled')
  		." class=\"navibutton\" type=\"submit\" style=\"background: #f2f2f2; color: black; border-color:#f9f9f9; border:none;\""
	    ." name=\"$name\"  id=\"$name\" value=\"$value\">"
	  	.($icon ? "<img src='$path_to_root/themes/".user_theme()."/images/".$icon."'>":'')
		."<span>$value</span></button>\n";
}

function navi_button_cell($name, $value, $enabled=true, $align='left') {
	label_cell(navi_button($name, $value, $enabled), "align='$align'");
}

//pk
function navi_button2($name, $value, $enabled=true, $icon = false) {
	global $path_to_root;
  	return "<button ". ($enabled ? '':'disabled')
  		." class=\"navibutton\" type=\"submit\" style=\"background: #f2f2f2; color: black; border-color:#f9f9f9; border:none;\""
	    ." name=\"$name\"  id=\"$name\" value=\"$value\">"
	  	.($icon ? "<img src='$path_to_root/themes/".user_theme()."/images/".$icon."'>":'')
		."<span>$value</span></button>\n";
}

function navi_button_cell2($name, $value, $enabled=true, $align='left') {
	label_cell(navi_button($name, $value, $enabled), "align='$align'");
}

//pk
//-----------------------------------------------------------------------------
//
//    Sql paged table view. Call this function inside form.
//
function display_db_pager(&$pager) {
    global	$path_to_root;

	$pager->select_records();

	div_start("_{$pager->name}_span");
    $headers = array();

	foreach($pager->columns as $num_col=>$col) {
		// record status control column is displayed only when control checkbox is on
    	if (isset($col['head']) && ($col['type']!='inactive' || get_post('show_inactive'))) {
			if (!isset($col['ord']))
				$headers[] = $col['head'];
			else {
	  			$icon = (($col['ord'] == 'desc') ? 'sort_desc.gif' : 
					($col['ord'] == 'asc' ? 'sort_asc.gif' : 'sort_none.gif'));
				$headers[] = navi_button($pager->name.'_sort_'.$num_col, 
					$col['head'], true, $icon);
			}
 		}
	}
    /* show a table of records returned by the sql */
    // display_error($pager->width);
    echo '<div class="table-responsive">';
       start_table(TABLESTYLE3, 'width:'.$pager->width.';border:1px solid #dee2e6;', '2', '0', 0, null,  null, null, $pager->fixed_header);
   
    // table_header($headers,null,'#f2f2f2');
    db_table_header($headers,'font-weight: normal;font-size:15px;background:#f2f2f2;border:1px solid #dee2e6;');

	if($pager->header_fun) {	// if set header handler
		start_row("class='{$pager->header_class}'");
		$fun = $pager->header_fun;
		if (method_exists($pager, $fun)) { 
			$h = $pager->$fun($pager);
  		} elseif (function_exists($fun)) {
			$h = $fun($pager);
		}
		
		foreach($h as $c) {	 // draw header columns
			$pars = isset($c[1]) ? $c[1] : '';
			label_cell($c[0], $pars);
		}
		end_row();
	}

	$cc = 0; //row colour counter
   	foreach($pager->data as $line_no => $row) {	

        if ($pager->row_fun) {
            if (function_exists($pager->row_fun)) {
                $fn = $pager->row_fun;
                $row = $fn($row);
            }
        }


        $marker = $pager->marker;
		$ClassName = $pager->marker_class;
		if($marker && !$marker($row)){
			$marker = $pager->sec_marker;
			$ClassName = $pager->sec_marker_class;
		}
		if($marker && !$marker($row)){
			$marker = $pager->trice_marker;
			$ClassName = $pager->trice_marker_class;
		} 		
	    if ($marker && $marker($row)) 
        	start_row("class='$ClassName'");
	    else	
			alt_table_row_color($cc);
	    foreach ($pager->columns as $k=>$col) {
		   $coltype = $col['type'];
		   $cell = isset($col['name']) ? $row[$col['name']] : '';

		   if (isset($col['fun'])) { // use data input function if defined
		    $fun = $col['fun']; 
		    if (method_exists($pager, $fun)) { 
				$cell = $pager->$fun($row, $cell);
  			} elseif (function_exists($fun)) {
				$cell = $fun($row, $cell);
			} else
				$cell = '';
		   }
		   switch($coltype) { // format column
		    case 'time':
		  	  label_cell($cell, "style='width:40; border: 1px solid #dee2e6;'"); break;
	  	   case 'nocell':
		  	  echo $cell; break;
		    case 'date':
		  	  label_cell(sql2date($cell), "style = 'border: 1px solid #dee2e6;align:center' nowrap"); break;
		    case 'dstamp':	// time stamp displayed as date
		  	  label_cell(sql2date(substr($cell, 0, 10)), "style='border: 1px solid #dee2e6; align:center' nowrap"); break;
		    case 'tstamp':	// time stamp - FIX user format
		  	  label_cell(sql2date(substr($cell, 0, 10)).
			  ' '. substr($cell, 10), "style='border: 1px solid #dee2e6; align:center'"); break;
		    case 'percent':
		  	  percent_cell($cell,false,null,false,'style="border: 1px solid #dee2e6;"'); break;
		    case 'amount':
			  if ($cell=='')
			  	label_cell('');
			  else
		  	  	amount_cell($cell, false,'style="border: 1px solid #dee2e6;"'); break;
		    case 'qty':
			  if ($cell=='')
			  	label_cell('');
			  else
		  	  	qty_cell($cell, false, isset($col['dec']) ? $col['dec'] : null,null,false,false,'style="border: 1px solid #dee2e6;"'); break;
			case 'email':
				email_cell($cell,isset( $col['align']) ? "align='" . $col['align'] . "'" : null);
				break;
		    case 'rate':
				label_cell(number_format2($cell, user_exrate_dec()), "style='border: 1px solid #dee2e6;align:center'"); break;
			case 'collapse':
				label_cell(chunk_split($cell, 30), "style ='width:20%; border: 1px solid #dee2e6;align:center'"); break;
			case 'inactive':
				if(get_post('show_inactive'))
					$pager->inactive_control_cell($row); break;
		    default:
			  if (isset( $col['align']))
			  	  label_cell($cell, "style='border: 1px solid #dee2e6; align:" . $col['align'] . "'");
			  else
			  	  label_cell($cell,"style='border: 1px solid #dee2e6;'");
		    case 'skip':	// column not displayed
	  	  }
	  }
	    end_row();
	}
	//end of while loop

	if($pager->footer_fun) {	// if set footer handler
		start_row("class='{$pager->footer_class}'");
		$fun = $pager->footer_fun;
		if (method_exists($pager, $fun)) { 
			$h = $pager->$fun($pager);
  		} elseif (function_exists($fun)) {
			$h = $fun($pager);
		}
		
		foreach($h as $c) {	 // draw footer columns
			$pars = isset($c[1]) ? $c[1] : '';
			label_cell($c[0], $pars);
		}
		end_row();
	}

	start_row("class='navibar'");
	$colspan = count($pager->columns);
		$inact = @$pager->inactive_ctrl==true 
			? '&nbsp;&nbsp; '.checkbox(null, 'show_inactive', null, true). _("Show also Inactive") : '';
	 if($pager->rec_count) {
		echo "<td colspan=$colspan class='navibar' style='border:none;padding:3px; background:#f2f2f2'>";
		echo "<div style='float:right;'>";
		$but_pref = $pager->name.'_page_';
	    start_table();
		start_row();
		/*
		echo navi_button_cell_2($but_pref.'first', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/first.png >"), $pager->first_page, 'right');
		echo navi_button_cell_2($but_pref.'next', _("<img style='width:18px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/next.png >"), $pager->next_page,'right');
		echo navi_button_cell_2($but_pref.'last', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/last.png >"), $pager->last_page, 'right');
		*/

		if (@$pager->inactive_ctrl) 
				// submit('Update', _('Update'), true, '', null); // inactive update
		echo navi_button_cell2($but_pref.'first', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/first.png >"), $pager->first_page, 'right');
		echo navi_button_cell2($but_pref.'prev', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/first.png >"), $pager->prev_page,'right');
		echo navi_button_cell2($but_pref.'next', _("<img style='width:18px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/next.png >"), $pager->next_page,'right');
		echo navi_button_cell2($but_pref.'last', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/last.png >"), $pager->last_page, 'right');
		end_row(); 
		end_table();
		echo "</div>";
		$from = ($pager->curr_page-1)*$pager->page_len+1;
		$to = $from + $pager->page_len - 1;
		if ($to > $pager->rec_count)
		  $to = $pager->rec_count;
		$all = $pager->rec_count;
		echo "<div style='font-weight: normal !important; float:left; padding-top:0%; font-size:15px; font-weight: bold;'>";
        		echo sprintf( _('Showing %d-%d of %d entries'), $from, $to, $all);
		echo $inact;
		echo "</td>";
		echo "</div>";
	} else {
	  	label_cell( _('No records') . $inact, "colspan=$colspan class='navibar'");
	}

	end_row();

	end_table();

   if (isset($pager->marker_txt))
   		display_note($pager->marker_txt."&nbsp".$pager->sec_marker_txt."&nbsp".$pager->trice_marker_txt, 0, 1, "class='$pager->notice_class'");

echo '</div>';
  div_end();
  return true;
}

function display_db_pager_2(&$pager) {
    global	$path_to_root;

	$pager->select_records();

	div_start("_{$pager->name}_span");
    $headers = array();

	foreach($pager->columns as $num_col=>$col) {
		// record status control column is displayed only when control checkbox is on
    	if (isset($col['head']) && ($col['type']!='inactive' || get_post('show_inactive'))) {
			if (!isset($col['ord']))
				$headers[] = $col['head'];
			else {
	  			$icon = (($col['ord'] == 'desc') ? 'sort_desc.gif' : 
					($col['ord'] == 'asc' ? 'sort_asc.gif' : 'sort_none.gif'));
				$headers[] = navi_button($pager->name.'_sort_'.$num_col, 
					$col['head'], true, $icon);
			}
 		}
	}
    /* show a table of records returned by the sql */
    // display_error($pager->width);
    echo '<div class="table-responsive">';
       start_table(TABLESTYLE2, 'width:'.$pager->width.';border:1px solid #dee2e6;');
   
    // table_header($headers,null,'#f2f2f2');#859694
    db_table_header($headers,'font-weight: bolder;font-size:15px;background:#f2f2f2;border:2px solid #dee2e6;');

	if($pager->header_fun) {	// if set header handler
		start_row("class='{$pager->header_class}'");
		$fun = $pager->header_fun;
		if (method_exists($pager, $fun)) { 
			$h = $pager->$fun($pager);
  		} elseif (function_exists($fun)) {
			$h = $fun($pager);
		}
		
		foreach($h as $c) {	 // draw header columns
			$pars = isset($c[1]) ? $c[1] : '';
			label_cell($c[0], $pars);
		}
		end_row();
	}

	$cc = 0; //row colour counter
   	foreach($pager->data as $line_no => $row) {	

        if ($pager->row_fun) {
            if (function_exists($pager->row_fun)) {
                $fn = $pager->row_fun;
                $row = $fn($row);
            }
        }

		$marker = $pager->marker;
		$ClassName = $pager->marker_class;
		if($marker && !$marker($row)){
			$marker = $pager->sec_marker;
			$ClassName = $pager->sec_marker_class;
		}
		if($marker && !$marker($row)){
			$marker = $pager->trice_marker;
			$ClassName = $pager->trice_marker_class;
		} 		
	    if ($marker && $marker($row)) 
        	start_row("class='$ClassName'");
	    else	
			alt_table_row_color($cc);
	    foreach ($pager->columns as $k=>$col) {
		   $coltype = $col['type'];
		   $cell = isset($col['name']) ? $row[$col['name']] : '';

		   if (isset($col['fun'])) { // use data input function if defined
		    $fun = $col['fun']; 
		    if (method_exists($pager, $fun)) { 
				$cell = $pager->$fun($row, $cell);
  			} elseif (function_exists($fun)) {
				$cell = $fun($row, $cell);
			} else
				$cell = '';
		   }
		   switch($coltype) { // format column
		    case 'time':
		  	  label_cell($cell, "style='width:40; border: 1px solid #dee2e6;'"); break;
		    case 'date':
		  	  label_cell(sql2date($cell), "style = 'border: 1px solid #dee2e6;align:center' nowrap"); break;
		    case 'dstamp':	// time stamp displayed as date
		  	  label_cell(sql2date(substr($cell, 0, 10)), "style='border: 1px solid #dee2e6; align:center' nowrap"); break;
		    case 'tstamp':	// time stamp - FIX user format
		  	  label_cell(sql2date(substr($cell, 0, 10)).
			  ' '. substr($cell, 10), "style='border: 1px solid #dee2e6; align:center'"); break;
		    case 'percent':
		  	  percent_cell($cell,false,null,false,'style="border: 1px solid #dee2e6;"'); break;
		    case 'amount':
			  if ($cell=='')
			  	label_cell('');
			  else
		  	  	amount_cell($cell, false,'style="border: 1px solid #dee2e6;"'); break;
		    case 'qty':
			  if ($cell=='')
			  	label_cell('');
			  else
		  	  	qty_cell($cell, false, isset($col['dec']) ? $col['dec'] : null,null,false,false,'style="border: 1px solid #dee2e6;"'); break;
			case 'email':
				email_cell($cell,isset( $col['align']) ? "align='" . $col['align'] . "'" : null);
				break;
		    case 'rate':
				label_cell(number_format2($cell, user_exrate_dec()), "style='border: 1px solid #dee2e6;align:center'"); break;
			case 'inactive':
				if(get_post('show_inactive'))
					$pager->inactive_control_cell($row); break;
		    default:
			  if (isset( $col['align']))
			  	  label_cell($cell, "style='border: 1px solid #dee2e6; align:" . $col['align'] . "'");
			  else
			  	  label_cell($cell,"style='border: 1px solid #dee2e6;'");
		    case 'skip':	// column not displayed
	  	  }
	  }
	    end_row();
	}
	//end of while loop

	if($pager->footer_fun) {	// if set footer handler
		start_row("class='{$pager->footer_class}'");
		$fun = $pager->footer_fun;
		if (method_exists($pager, $fun)) { 
			$h = $pager->$fun($pager);
  		} elseif (function_exists($fun)) {
			$h = $fun($pager);
		}
		
		foreach($h as $c) {	 // draw footer columns
			$pars = isset($c[1]) ? $c[1] : '';
			label_cell($c[0], $pars);
		}
		end_row();
	}

	start_row("class='navibar'");
	$colspan = count($pager->columns);
		$inact = @$pager->inactive_ctrl==true 
			? '&nbsp;&nbsp; '.checkbox(null, 'show_inactive', null, true). _("Show also Inactive") : '';
	 if($pager->rec_count) {
		echo "<td colspan=$colspan class='navibar' style='border:none;padding:3px; background:#f2f2f2'>";
		echo "<div style='float:right;'>";
		$but_pref = $pager->name.'_page_';
	    start_table();
		start_row();
		/*
		echo navi_button_cell_2($but_pref.'first', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/first.png >"), $pager->first_page, 'right');
		echo navi_button_cell_2($but_pref.'next', _("<img style='width:18px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/next.png >"), $pager->next_page,'right');
		echo navi_button_cell_2($but_pref.'last', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/last.png >"), $pager->last_page, 'right');
		*/

		if (@$pager->inactive_ctrl) 
				// submit('Update', _('Update'), true, '', null); // inactive update
		echo navi_button_cell2($but_pref.'first', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/first.png >"), $pager->first_page, 'right');
		echo navi_button_cell2($but_pref.'prev', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/first.png >"), $pager->prev_page,'right');
		echo navi_button_cell2($but_pref.'next', _("<img style='width:18px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/next.png >"), $pager->next_page,'right');
		echo navi_button_cell2($but_pref.'last', _("<img style='width:15px;margin-bottom: 10px' src =  ".$path_to_root."/themes/".user_theme()."/images/last.png >"), $pager->last_page, 'right');
		end_row(); 
		end_table();
		echo "</div>";
		$from = ($pager->curr_page-1)*$pager->page_len+1;
		$to = $from + $pager->page_len - 1;
		if ($to > $pager->rec_count)
		  $to = $pager->rec_count;
		$all = $pager->rec_count;
		echo "<div style='font-weight: normal !important; float:left; padding-top:0%; font-size:15px; font-weight: bold;'>";
        		echo sprintf( _('Showing %d-%d of %d entries'), $from, $to, $all);
		echo $inact;
		echo "</td>";
		echo "</div>";
	} else {
	  	label_cell( _('No records') . $inact, "colspan=$colspan class='navibar'");
	}

	end_row();

	end_table();

   if (isset($pager->marker_txt))
   		display_note($pager->marker_txt."&nbsp".$pager->sec_marker_txt."&nbsp".$pager->trice_marker_txt, 0, 1, "class='$pager->notice_class'");

echo '</div>';
  div_end();
  return true;
}
