<?php

/*
	Class for supplier/customer payment/credit allocations edition
	and related helpers.
*/
//-----------------------------------------------------------------------------------

class allocation 
{

	var $trans_no; 
	var $type;
	var $person_id = '';
	var $person_name = '';
	var $person_type;	// PT_SUPPLIER/PT_CUSTOMER
	var $person_curr;
	var $date_;
	var $amount = 0; /*Total amount of the transaction in FX */
	var $currency;
	var $reference;
	var $from_date;
	var $to_date;

	var $allocs; /*array of transactions allocated to */
	var $allocated_amount;  /*  payment for payroll allocated amount  */

	function __construct($type, $trans_no, $person_id = null, $person_type_id=null)
	{
		$this->allocs = array();
		
		$this->trans_no = $trans_no;
		$this->type = $type;
		if ($person_id)
			$this->set_person($person_id, $person_type_id);

		$this->read($type, $trans_no, $person_id, $person_type_id); // read payment or credit
	}

	function set_person($person_id, $person_type)
	{
		$this->person_id = $person_id;
		$this->person_type = $person_type;
		// $this->person_curr = $person_type == PT_SUPPLIER ?
		// 	get_supplier_currency($person_id) : get_customer_currency($person_id);
		// return $this->person_curr;
	}

	function add_item($type, $type_no, $date_, $due_date, $amount, $amount_allocated, 
		$current_allocated, $ref ,$prep_amount=0)
	{
		if (floatcmp($amount, 0))
		{
			$this->allocs[count($this->allocs)] = new allocation_item($type, $type_no, 
				$date_, $due_date, $amount, $amount_allocated, $current_allocated, $ref,$prep_amount);
			return true;
		} 
		else 
		{
			return false;
		}
	}
	function add_payslip_item($id ,$emp_id ,$basic_salary ,$allowance ,$deduction ,$gross_salary,$overtime_hrs ,$ot_salary ,$normal_days  ,$nd_salary  ,$upl ,$pl ,$pl_amount,
        $month_id , $year_id ,$total_salary ,$alloc_amount)
	{
		
	// display_error(floatcmp($amount, 0) ." == ".$amount);
   if (floatcmp($total_salary, 0))
		{

			$this->allocs[count($this->allocs)] = new allocation_payslip_item($id ,$emp_id ,$basic_salary ,$allowance ,$deduction ,$gross_salary ,$overtime_hrs ,$ot_salary ,$normal_days  ,$nd_salary  ,$upl, $pl , $pl_amount ,
        $month_id , $year_id ,$total_salary ,$alloc_amount);
			return true;
		} 
		else 
		{
			return false;
		}


	}
	
	function update_item($index, $type, $type_no, $date_, $due_date, 
		$amount, $amount_allocated, $current_allocated, $ref)
	{
		if (floatcmp($amount, 0))
		{
			$this->allocs[$index] = new allocation_item($type, $type_no, 
				$date_, $due_date, $amount, $amount_allocated, $current_allocated, $ref);
			return true;
		} 
		else 
		{
			return false;
		}
	}
	
	function add_or_update_item($type, $type_no, $date_, $due_date, 
		$amount, $amount_allocated, $current_allocated, $ref)
	{
		for ($i = 0; $i < count($this->allocs); $i++) 
		{
			$item = $this->allocs[$i];
			if (($item->type == $type) && ($item->type_no == $type_no)) 
			{
				return $this->update_item($i, $type, $type_no, $date_, $due_date, 
					$amount, $amount_allocated, $current_allocated, $ref);
			}
		}
        return $this->add_item($type, $type_no, $date_, $due_date, 
        	$amount, $amount_allocated, $current_allocated, $ref);
	}

	//
	//	Read payment or credit current/available allocations to cart.
	//
	// FIXME - read all transactions below twice seems to be suboptimal
	//
	function read($type = null, $trans_no = 0, $person_id=null, $person_type_id=null)
	{
		if ($type !== null) {	// otherwise re-read
			$type = $this->type;
			$trans_no = $this->trans_no;

			if (isset($person_type_id))
			{
				$this->person_type = $person_type_id;
				$this->person_id = $person_id;
			} 
			

			if ($trans_no) {

             $result= get_bank_trans($type, $trans_no, $person_type_id, $person_id);
               if (db_num_rows($result) > 1)
				display_db_error("duplicate payment bank transaction found", "");

				$from_trans = db_fetch($result);
                     echo '<pre>';
                  // print_r($from_trans);
				// $this->person_id = $trans[$this->person_type == PT_SUPPLIER ? 'supplier_id':'debtor_no'];
				// $this->person_name = $trans[$this->person_type == PT_SUPPLIER ? "supplier_name":"DebtorName"];
                     $this->person_name=get_employees($this->person_id)['name'];
				$this->date_ = sql2date($from_trans["trans_date"]);
				// $this->person_curr = $trans['curr_code'];
				$this->currency = isset($from_trans['bank_curr_code']) ? $from_trans['bank_curr_code'] : $from_trans['curr_code'];
				// $this->bank_amount = isset($trans["bank_amount"]) ? $trans["bank_amount"] : $trans["Total"]; // not set for journal entry
				  $res=get_all_payroll_alloc_from($type,$trans_no,1);
				  $alloc_row=db_fetch($res);
				$this->allocated_amount=$alloc_row['amount'];
				// display_error($from_trans["amount"] ." ==  ".$type ."    =====   ".$trans_no);
				$this->amount = ABS($from_trans["amount"])-$this->allocated_amount;
				// display_error($this->amount);
			}
		}
		else
		{
         	display_db_error("type not fond", "");
         	exit();

		}	
	/* Now populate the array of possible (and previous actual) allocations 
		for this customer/supplier. First get the transactions that have 
		outstanding balances ie Total-alloc >0 */

		$this->allocs = array();
            $trans_items= get_alloc_payslip($person_id);
		 		// display_error(db_num_rows($trans_items));
		 		if(db_num_rows($trans_items)==0)
		 		{
		 			display_notification(_("no payslip available for sattle paymint"));

		 		}
		 		else
		 		{

			while ($myrow = db_fetch($trans_items))
			{
				// print_r($myrow);
				$this->add_payslip_item($myrow["id"], $myrow["emp_id"],
					$myrow["basic_salary"],
					$myrow["allowance"],
					$myrow["deduction"], // trans total
					$myrow["gross_salary"],
					$myrow["overtime_hrs"],
					$myrow["ot_salary"],
					$myrow["normal_days"],
					$myrow["nd_salary"],
					$myrow["upl"],
					$myrow["pl"],
					$myrow["pl_amount"],
					$myrow["month_id"],
					$myrow["year_id"], // trans total allocated
					$myrow["total_salary"],$myrow["alloc_amount"]); // this allocation
			}
		 		}	
		
		
	}
	//
	//	Update allocations in database.
	//
	function write()
	{
		global 	$no_exchange_variations;

		begin_transaction();

		// if ($this->person_type == PT_SUPPLIER)
		// 	clear_supp_alloctions($this->type, $this->trans_no, $this->person_id, $this->date_);
		// else
		//  	clear_cust_alloctions($this->type, $this->trans_no, $this->person_id, $this->date_);

		// now add the new allocations
		$total_allocated = 0;
		$dec = user_price_dec();
		foreach ($this->allocs as $alloc_item)
		{
			if ($alloc_item->current_allocated > 0)
			{
				$amount = round($alloc_item->current_allocated, $dec);

				
	 				add_payroll_allocation($amount,
						$this->type, $this->trans_no,
 			     		ST_PAYSLIP, $alloc_item->id, $alloc_item->emp_id, $this->date_);

                  update_payroll_trans_allocation($alloc_item->id,$amount);
	 			

				//////////////////////////////////////////////////////////////
				$total_allocated += $alloc_item->current_allocated;
			}

		}
// $this->trans_no
// $this->type
		 $sql=" UPDATE ".TB_PREF."bank_trans SET alloc= alloc+".$total_allocated."  WHERE trans_no=".db_escape($this->trans_no)." AND type=".db_escape($this->type) ;
	   db_query($sql);
		  /*end of the loop through the array of allocations made */
		// if ($this->person_type == PT_SUPPLIER)
		// 	update_supp_trans_allocation($this->type, $this->trans_no, $this->person_id);
		// else
		//  	update_debtor_trans_allocation($this->type,	$this->trans_no, $this->person_id);

		commit_transaction();

	}

} 

//-----------------------------------------------------------------------------------

class allocation_item 
{

	var $type;
	var $type_no;
	
	var $date_;
	var $due_date;
	
	var $amount_allocated;
	var $amount;
	var $ref;
	
	var $current_allocated;
	var $prep_amount;
	
	function __construct($type, $type_no, $date_, $due_date, $amount, 
		$amount_allocated, $current_allocated, $ref, $prep_amount=0)
	{

		$this->type = $type;
		$this->type_no = $type_no;

		$this->ref = $ref;
        $this->prep_amount = $prep_amount;
		$this->date_ = $date_;
		$this->due_date = $due_date;
		
		$this->amount = $amount;
		$this->amount_allocated = $amount_allocated;
		$this->current_allocated = $current_allocated;
	}
}

class allocation_payslip_item 
{

	
	var $id;
	var $emp_id;
	var $basic_salary;
	var $allowance;
	var $deduction;
	var $gross_salary ;
	var $normal_days ;
	var $nd_salary ;
	var $upl;  
	var $pl;
	var $pl_amount;      
	var $month_id; 
	var $year_id;
	var $total_salary;
	var $alloc_amount;

	var $overtime_hrs ;
	var $ot_salary;
	
	function __construct($id ,$emp_id ,$basic_salary ,$allowance ,$deduction ,$gross_salary ,$overtime_hrs ,$ot_salary ,$normal_days  ,$nd_salary  ,$upl,$pl ,$pl_amount ,
        $month_id , $year_id ,$total_salary ,$alloc_amount)
	{
		// display_error($id ." == ".$emp_id ." == ".$basic_salary ." == ".$allowance ." == ".$deduction ." == ".$gross_salary  ." == ".$normal_days  ." == ".$nd_salary  ." == ".$upl." == ".
  //       $month_id ." == ". $year_id ." == ".$total_salary ." == ".$alloc_amount);

	 $this->id     = $id;    
	 $this->emp_id =  $emp_id;      
	 $this->basic_salary =$basic_salary;        
	 $this->allowance    =$allowance;     
	 $this->deduction    = $deduction;      
	 $this->gross_salary = $gross_salary;         
	 $this->overtime_hrs = $overtime_hrs;         
	 $this->ot_salary = $ot_salary;         
	 $this->normal_days  = $normal_days;        
	 $this->nd_salary    = $nd_salary;      
	 $this->upl          = $upl;       
	 $this->pl           = $pl;  
	 $this->pl_amount    = $pl_amount;  
	 $this->month_id     = $month_id;     
	 $this->year_id      = $year_id;   
	 $this->total_salary = $total_salary;       
	 $this->alloc_amount = $alloc_amount;         

	}
}
//--------------------------------------------------------------------------------

function show_allocatable($show_totals) {

	global $systypes_array;
	
    $k = $total_allocated = 0;

	$cart = $_SESSION['alloc'];
	$supp_ref = in_array($cart->type, array(ST_SUPPCREDIT, ST_SUPPAYMENT, ST_BANKPAYMENT));
// display_error(count($cart->allocs));
	if (count($cart->allocs)) 
	{
		// display_heading(sprintf(_("Allocated amounts in %s:"), $cart->person_curr));
		start_table(TABLESTYLE2, 'width:100% !important;');
   		$th = array( _("#"),_("Emp Name"), _("Basic Salary"), _("Month"), _("Year"), _("Allowance"), _("Deduction"), _("G.Salary"), _("OT Hrs"),	_("OT Salary"),
   			_("N.Days"),_("ND Salary") ,_("UPL"),_("PL"),_("PL Amount"), _("Left to Allo"), _("This Alloc"),'','');

	   	table_header($th);
        // print_r($cart->allocs);
		foreach ($cart->allocs as $id => $alloc_item)
		{
		    if (floatcmp(abs($alloc_item->total_salary), $alloc_item->alloc_amount))
		    {
				alt_table_row_color($k);
				label_cell(viewer_link($alloc_item->id,$path_to_root . "modules/FrontHrm/view/view_payslip.php?trans_no=".$alloc_item->emp_id."&year=".$alloc_item->year_id."&month=".$alloc_item->month_id));
    		  
		   		label_cell(get_employees($alloc_item->emp_id)['name']);
    			label_cell(price_format($alloc_item->basic_salary), "align=right");
    			$month_num = $alloc_item->month_id;
				$month_name = date("F", mktime(0, 0, 0, $month_num, 10));
				// echo $month_name."\n"; 
    			label_cell($month_name);
    			label_cell(get_selected_years($alloc_item->year_id));
    			label_cell(price_format($alloc_item->allowance), "align=right");
    			label_cell(price_format($alloc_item->deduction));

    			label_cell(price_format($alloc_item->gross_salary));

               // display_error($alloc_item->normal_days);

  label_cell($alloc_item->overtime_hrs);
  label_cell(price_format($alloc_item->ot_salary));
      			label_cell($alloc_item->normal_days);
    			label_cell(price_format($alloc_item->nd_salary));

    			label_cell($alloc_item->upl);
    				label_cell($alloc_item->pl);
    					label_cell($alloc_item->pl_amount);

	    		// amount_cell(abs($alloc_item->amount));
	    		// label_cell(get_user(get_customer_trans($alloc_item->type_no, ST_SALESINVOICE)['collected_by'])['real_name']);
	   //  		  		amount_cell( $alloc_item->total_salary);	
				// amount_cell($alloc_item->alloc_amount);


	    		$un_allocated = round((abs($alloc_item->total_salary) - $alloc_item->alloc_amount), 6);
	    		amount_cell($un_allocated, false,'', 'maxval'.$id);
    			amount_cells(null, "amount" . $id);//, input_num('amount' . $id));
		    	// $_POST['amount' . $id] = price_format($alloc_item->alloc_amount);
				label_cell("<a href='#' name=Alloc$id onclick='allocate_all(this.name.substr(5));return true;'>"
					 . _("All") . "</a>");
				label_cell("<a href='#' name=DeAll$id onclick='allocate_none(this.name.substr(5));return true;'>"
					 . _("None") . "</a>".hidden("un_allocated" . $id, 
					 price_format($un_allocated), false));
				end_row();

   	    		$total_allocated += input_num('amount' . $id);
		   	}
		}
		if ($show_totals) {
    	   	label_row(_("Total Allocated"), price_format($total_allocated),
	    		"colspan=11 align=right", "align=right id='total_allocated'", 3);

			$amount = abs($cart->amount);

			if (floatcmp($amount, $total_allocated) < 0)
	        {
        		$font1 = "<font color=red>";
        		$font2 = "</font>";
    	    }
	        else
        		$font1 = $font2 = "";
			$left_to_allocate = price_format($amount - $total_allocated);
	        label_row(_("Left to Allocate"), $font1 . $left_to_allocate . $font2, 
				"colspan=11 align=right", "nowrap align=right id='left_to_allocate'",
				 3);
		}
		end_table(1);
	}
	hidden('TotalNumberOfAllocs', count($cart->allocs));
}
//--------------------------------------------------------------------------------

function check_allocations()
{
	global $SysPrefs;

	$total_allocated = 0;

	for ($counter = 0; $counter < get_post("TotalNumberOfAllocs"); $counter++)
	{
		if (!isset($_POST['amount'.$counter])) continue;
		if (!check_num('amount' . $counter, 0))
		{
			display_error(_("The entry for one or more amounts is invalid or negative."));
			set_focus('amount'.$counter);
			return false;
		 }

		  /* Now check to see that the AllocAmt is no greater than the
		 amount left to be allocated against the transaction under review;
		 skip check if no allocation is set to avoid deadlock on mistakenly overallocated transactions*/
		 $allocated = input_num('amount' . $counter);
		 if ($allocated && ($allocated > input_num('un_allocated' . $counter)))
		 {
			display_error(_("At least one transaction is overallocated."));
			set_focus('amount'.$counter);
			return false;
		 }

		 $_SESSION['alloc']->allocs[$counter]->current_allocated = input_num('amount' . $counter);

		 $total_allocated += input_num('amount' . $counter);
	}

	$amount = abs($_SESSION['alloc']->amount);

	if ($total_allocated - ($amount + input_num('discount'))  > $SysPrefs->allocation_settled_allowance())
	{
		display_error(_("These allocations cannot be processed because the amount allocated is more than the total amount left to allocate."));
		return false;
	}

	return true;
}

//----------------------------------------------------------------------------------------
//
//	Returns sales or purchase invoice allocations to be reallocated after invoice edition.
//
function get_inv_allocations($trans_no, $trans_type, $person_id)
{
	$allocs = array();
	if ($trans_type == ST_SUPPINVOICE || $trans_type == ST_SUPPCREDIT)
		$result = get_allocatable_from_supp_transactions($person_id, $trans_no, $trans_type);
	else
		$result = get_allocatable_from_cust_transactions($person_id, $trans_no, $trans_type);

	while($dat = db_fetch($result))
	{
		$allocs[] = array('type'=> $dat['type'], 'trans_no'=> $dat['trans_no'], 'amount'=>$dat['alloc']);
	}
	return $allocs;
}
