
<?php

function textarea_cells_readonly($label, $name, $value, $cols, $rows, $title = null, $params="")
{
  	global $Ajax;

	default_focus($name);
	if ($label != null)
		echo "<td $params>$label</td>\n";
	if ($value == null)
		$value = (!isset($_POST[$name]) ? "" : $_POST[$name]);
	echo "<td><textarea $params name='$name' cols='$cols' rows='$rows'"
	.($title ? " title='$title'" : '')
	.">$value</textarea></td>\n";
	$Ajax->addUpdate($name, $name, $value);
}

function textarea_row_readonly($label, $name, $value, $cols, $rows, $title=null, $params="")
{
	echo "<tr><td class='label'>$label</td>";
	textarea_cells_readonly(null, $name, $value, $cols, $rows, $title, $params);
	echo "</tr>\n";
}

// Sets local POST value and adds Value to ajax posting if needed
//
/*function set_post($name, $value, $ajax_trigger=true) {
    global $Ajax;

    $_POST[$name] = $value;
    if ($ajax_trigger) $Ajax->activate($name);
}
*/
//------------------------------------------------------------------------------
//    Seek for _POST variable with $prefix.
//    If var is found returns variable name with prefix stripped,
//    and null or -1 otherwise.
//
function find_submit_new($prefix, $numeric=true)
{

    foreach($_POST as $postkey=>$postval )
    {
		if (strpos($postkey, $prefix) === 0)
		{
			$id = substr($postkey, strlen($prefix));
			return $numeric ? $id : $id;
		}
    }
    return $numeric ? -1 : null;
}


function find_submit($prefix, $numeric=true)
{

    foreach($_POST as $postkey=>$postval )
    {
		if (strpos($postkey, $prefix) === 0)
		{
			$id = substr($postkey, strlen($prefix));
			return $numeric ? (int)$id : $id;
		}
    }
    return $numeric ? -1 : null;
}
/*
	Helper function.
	Returns true if input $name with $submit_on_change option set is subject to update.
*/
function input_changed($name)
{
	return isset($_POST['_'.$name.'_changed']);
}

//------------------------------------------------------------------------------
//
// Helper function for simple db table editor pages
//
function simple_page_mode($numeric_id = true)
{
	global $Ajax, $Mode, $selected_id;

	$default = $numeric_id ? -1 : '';
	$selected_id = get_post('selected_id', $default);
	foreach (array('ADD_ITEM', 'UPDATE_ITEM', 'RESET', 'CLONE') as $m) {
		if (isset($_POST[$m])) {
			$Ajax->activate('_page_body');
			if ($m == 'RESET'  || $m == 'CLONE') 
				$selected_id = $default;
			unset($_POST['_focus']);
			$Mode = $m; return;
		}
	}
	foreach (array('Edit', 'Delete') as $m) {
		foreach ($_POST as $p => $pvar) {
			if (strpos($p, $m) === 0) {
//				$selected_id = strtr(substr($p, strlen($m)), array('%2E'=>'.'));
				unset($_POST['_focus']); // focus on first form entry
				$selected_id = quoted_printable_decode(substr($p, strlen($m)));
				$Ajax->activate('_page_body');
				$Mode = $m;
				return;
			}
		}
	}
	$Mode = '';
}

//------------------------------------------------------------------------------
//
//	Read numeric value from user formatted input
//
function input_num($postname=null, $dflt=0)
{
	if (!isset($_POST[$postname]) || $_POST[$postname] == "")
	  	return $dflt;

    return user_numeric($_POST[$postname]);
}

//---------------------------------------------------------------------------------
//
//	Thanks to hidden fields buffering hidden() helper can be used in arbitrary places and 
//  proper html structure is still preserved. Buffered hidden fields are output on the nearest 
//  table or form closing tag (see output_hidden()).
//
$hidden_fields = array();

function hidden($name, $value=null, $echo=true)
{
  	global $Ajax, $hidden_fields;
	
	if ($value === null) 
		$value = get_post($name);
	
  	$ret = "<input type=\"hidden\" name=\"$name\" value=\"$value\">";
	$Ajax->addUpdate($name, $name, $value);
	if ($echo)
			$hidden_fields[] = $ret;
	else
		return $ret;
}
/*
	Universal submit form button.
	$atype - type of submit:
	 Normal submit:
		false - normal button; optional icon
		null  - button visible only in fallback mode; optional icon
	 Ajax submit:
		true	  - standard button; optional icon

		'default' - default form submit on Ctrl-Enter press; dflt ICON_OK icon
		'selector' - ditto with closing current popup editor window
		'cancel'  - cancel form entry on Escape press; dflt ICON_CANCEL
		'process' - displays progress bar during call; optional icon
		'nonajax' - ditto, non-ajax submit

	$atype can contain also multiply type selectors separated by space, 
	however make sense only combination of 'process' and one of defualt/selector/cancel
*/
function submit($name, $value, $echo=true, $title=false, $atype=false, $icon=false,$script=null,$margin=0,$float='',$background='',$margin_bottom=0,$width=0,$data_dismiss="")
{
	global $path_to_root;
	$buttonClass = array(
		'EnterLine' => 'btn btn-sm btn-info btn-flat', 
		'AddItem' => 'btn btn-sm btn-info btn-flat', 
		'SearchOrders' => 'btn btn-sm btn-info btn-flat', 
		'update'  => 'btn btn-sm btn-success btn-flat', 
		'ADD_ITEM'  => 'btn btn-sm btn-success btn-flat', 
		'ProcessCredit'  => 'btn btn-sm btn-success btn-flat', 
		'AddPaymentItem'  => 'btn btn-sm btn-success btn-flat', 
		'UPDATE_ITEM'  => 'btn btn-sm btn-success btn-flat', 
		'ModifySpecification'  => 'btn btn-sm btn-success btn-flat', 
		'Update'  => 'btn btn-sm btn-info btn-flat', 
		'contactsNEW'  => 'btn btn-sm btn-success btn-flat', 
		'ProcessOrder'  => 'btn btn-sm btn-success btn-flat', 
		'submit'  => 'btn btn-sm btn-success btn-flat', 
		'CancelOrder'  => 'btn btn-sm btn-danger btn-flat', 
		'delete'  => 'btn btn-sm btn-danger btn-flat', 
		'DelteSpec'  => 'btn btn-sm btn-danger btn-flat', 
		'RESET'  => 'btn btn-sm btn-danger btn-flat', 
		'default'  =>   'btn btn-sm btn-info btn-flat',      //'btn btn-sm btn-default btn-flat',  
		'process_attendance' =>'process_attendance',
		'imp_attendance'=>'imp_attendance',

	);

	if($data_dismiss!="")
		$data = 'data-dismiss="modal"';
	else
		$data = '';

	if (array_key_exists($name, $buttonClass))
	    $set =  $buttonClass[$name];					
	else
	    $set =  $buttonClass['default'];

	if (strpos($name, 'Rep') !== false) {
	    $set = 'btn btn-sm btn-success btn-flat pull-right';
	}

    if($width==0)
    $width="";
    
	$aspect='';
	if ($atype === null) {
		$aspect = fallback_mode() ? " aspect='fallback'" : " style='display:none;'";

	} elseif (!is_bool($atype)) { // necessary: switch uses '=='

		$aspect = " aspect='$atype' ";
		$types = explode(' ', $atype);

		foreach ($types as $type) {
			switch($type) {
				case 'selector':
					$aspect = " aspect='selector' rel = '$value'"; 
					$value = _("Select");
					if ($icon===false) $icon=ICON_SUBMIT; break;

				case 'default':
					if ($icon===false) $icon=ICON_SUBMIT; break;

				case 'cancel':
					if ($icon===false) $icon=ICON_ESCAPE; break;

				case 'nonajax':
				case 'download':
					$atype = false;
			}
		}
	}
	$icon = '';
		if($margin != 0){
		$margin = $margin;
	}
	if($float != ''){
		$float = $float;
	}
	if($background != ''){
		$background = $background;
	}
	$submit_str = "<button $script class=\""
	    .($atype ? 'ajaxsubmit '.$set : 'inputsubmit'.$set)
		."\" type=\"submit\""
		."style='margin-top:$margin;  margin-bottom:$margin_bottom; width:$width;  float:$float; background:$background; border:none;'"
		.$aspect
	    ." name=\"$name\"  id=\"$name\" value=\"$value\""
	    .($title ? " title='$title'" : '')."".($data ?"$data":" '' ")
	    .">"
		.($icon ? "<img src='$path_to_root/themes/".user_theme()."/images/$icon' height='12' alt=''>" : '')
		."<span>$value</span>"
		."</button>\n";
	if ($echo)
		echo $submit_str;
	else
		return $submit_str;
}

function submit_center($name, $value, $echo=true, $title=false, $async=false, $icon=false,$data_dismiss="")
{
	if ($echo) echo "<center>";
	submit($name, $value, $echo, $title, $async, $icon,null,0,'','',0,0,$data_dismiss);
	if ($echo) echo "</center>";
}

function submit_center_first($name, $value, $title=false, $async=false, $icon=false,$script=null, $margin=null)
{
	echo "<center>";
	submit($name, $value, true, $title, $async, $icon,$script, $margin);
	echo "&nbsp;";
}

function submit_center_last($name, $value, $title=false, $async=false, $icon=false, $script=null, $margin=null)
{
	echo "&nbsp;";
	submit($name, $value, true, $title, $async, $icon, $script, $margin);
	echo "</center>";
}
/*
	For following controls:
	'both' - use both Ctrl-Enter and Escape hotkeys 
	'upgrade' - use Ctrl-Enter with progress ajax indicator and Escape hotkeys. Nonajax request for OK option is performed.
	'cancel' - apply to 'RESET' button
*/
function submit_add_or_update($add=true, $title=false, $async=false, $clone=false,$buttontext='Cancel')
{
	$cancel = $async;

	if ($async === 'both') {
		$async = 'default'; $cancel = 'cancel';
	}
	// elseif ($async === 'upgrade') {
	// 	$async = 'default nonajax process'; $cancel = 'cancel';
	// }
	elseif ($async === 'default')
		$cancel = true;
	elseif ($async === 'cancel')
		$async = true;
	
	if ($add)
		submit('ADD_ITEM', _("Add new"), true, $title, $async);
	else {
		submit('UPDATE_ITEM', _("Update"), true, _('Submit changes'), $async);
		if ($clone) submit('CLONE', _("Clone"), true, 
			_('Edit new record with current data'), $async);
		submit('RESET', _($buttontext), true, _('Cancel edition'), $cancel);
	}
}

function submit_add_or_update_center($add=true, $title=false, $async=false, $clone=false,$buttontext='Cancel')
{
	echo "<center>";
	submit_add_or_update($add, $title, $async, $clone,$buttontext);
	echo "</center>";
}

//----------------------------------------------------------------------------------

// function submit_add_or_update2($add=true, $title=false, $async=false, $clone=false)
// {
// 	$delete = $async;

// 	if ($async === 'both') {
// 		$async = 'default'; $delete = 'delete';
// 	}
// 	// elseif ($async === 'upgrade') {
// 	// 	$async = 'default nonajax process'; $delete = 'delete';
// 	// }
// 	elseif ($async === 'default')
// 		$delete = true;
// 	elseif ($async === 'delete')
// 		$async = true;
	
// 	if ($add)
// 		submit('ADD_ITEM', _("Add new"), true, $title, $async);
// 	else {
// 		submit('UPDATE_ITEM', _("Update"), true, _('Submit changes'), $async);
// 		if ($clone) submit('CLONE', _("Clone"), true, 
// 			_('Edit new record with current data'), $async);
// 		submit('delete', _("Delete"), true, _('Delete edition'), $delete);
// 	}
// }

// function submit_add_or_update_center2($add=true, $title=false, $async=false, $clone=false)
// {
// 	echo "<center>";
// 	submit_add_or_update2($add, $title, $async, $clone);
// 	echo "</center>";
// }

function submit_add_or_update_row($add=true, $right=true, $extra="", $title=false, $async=false, $clone = false)
{
	echo "<tr>";
	if ($right)
		echo "<td>&nbsp;</td>\n";
	echo "<td $extra>";
	submit_add_or_update($add, $title, $async, $clone);
	echo "</td></tr>\n";
}

function submit_cells($name, $value, $extra="", $title=false, $async=false,$margin_bottom=0,$width=0)
{
	
	echo "<td $extra>";
	submit($name, $value, true, $title, $async,false,null,0,'','',$margin_bottom,$width);
	echo "</td>\n";
}

function submit_row($name, $value, $right=true, $extra="", $title=false, $async=false,$margin_bottom=0,$width=0)
{
	echo "<tr>";
	if ($right)
		echo "<td>&nbsp;</td>\n";
	submit_cells($name, $value, $extra, $title, $async,$margin_bottom,$width);
	echo "</tr>\n";
}

function submit_return($name, $value, $title=false)
{
	if (@$_REQUEST['popup']) {
		submit($name, $value, true, $title, 'selector');
	}
}

function submit_js_confirm($name, $msg, $set = true) {
	global $Ajax;
	$js = "_validate.$name=".($set ? "function(){ return confirm('"
				. strtr($msg, array("\n"=>'\\n')) . "');};"
				: 'null;');
	if (in_ajax()) {
		$Ajax->addScript(true, $js);
	} else
		add_js_source($js);
}
//-----------------------------------------------------------------------------------

function set_icon($icon, $title=false)
{
	global $path_to_root;
	if (basename($icon) === $icon) // standard icons does not contain path separator
		$icon = "$path_to_root/themes/".user_theme()."/images/$icon";
	return "<img src='$icon' style='vertical-align:middle;width:16px;height:16px;border:0;'".($title ? " title='$title'" : "")." >\n";	
}

function button($name, $value, $title=false, $icon=false,  $aspect='',$data_dismiss="")
{
	// php silently changes dots,spaces,'[' and characters 128-159
	// to underscore in POST names, to maintain compatibility with register_globals
	$rel = '';
	if ($aspect == 'selector') {
		$rel = " rel='$value'";
		$value = _("Select");
	}

	if($data_dismiss!="")
			$data = 'data-dismiss="modal"';
		else
			$data = '';

	if (user_graphic_links() && $icon)
	{
		if ($value == _("Delete")) // Helper during implementation
			$icon = ICON_DELETE;
		return "<button type='submit' class='btn editbutton' name='"
			.html_specials_encode(strtr($name, array('.'=>'=2E', '='=>'=3D',// ' '=>'=20','['=>'=5B'
			)))
			."' value='1'" . ($title ? " title='$title'":" title='$value'")."".($data ?"$data":" '' ")
			. ($aspect ? " aspect='$aspect'" : '')
			. $rel
			." >".set_icon($icon)."</button>\n";
	}
	else
		return "<input type='submit' class='editbutton' name='"
			.htmlentities(strtr($name, array('.'=>'=2E', '='=>'=3D',// ' '=>'=20','['=>'=5B'
			)))
			."' value='$value'"
			.($title ? " title='$title'":'')
			. ($aspect ? " aspect='$aspect'" : '')."".($data ?"$data":" '' ")
			. $rel
			." >\n";
}

function button_new($name, $value, $title=false, $icon=false,  $aspect='', $center=false)
{
	// php silently changes dots,spaces,'[' and characters 128-159
	// to underscore in POST names, to maintain compatibility with register_globals
	// $center_start = "" ;
	// $center_end = "";
	$rel = '';
	if ($aspect == 'selector') {
		$rel = " rel='$value'";
		$value = _("Select");
	}
	// if ($center!= false)
	// {
	// 	$center_start = "<center>";
	// 	$center_end = "</center>";
	// }

	if (user_graphic_links() && $icon)
	{
		if ($value == _("Delete")) // Helper during implementation
			$icon = ICON_DELETE;
		return " <button type='submit' class='btn editbutton' name='"
			.htmlentities(strtr($name, array('.'=>'=2E', '='=>'=3D',// ' '=>'=20','['=>'=5B'
			)))
			."' value='1'" . ($title ? " title='$title'":" title='$value'")
			. ($aspect ? " aspect='$aspect'" : '' )
			. $rel
			." >".set_icon($icon)."</button>\n";
	}
	else
		return "<input type='submit' class='editbutton' name='"
			.htmlentities(strtr($name, array('.'=>'=2E', '='=>'=3D',// ' '=>'=20','['=>'=5B'
			)))
			."' value='$value'"
			.($title ? " title='$title'":'')
			. ($aspect ? " aspect='$aspect'" : '')
			. $rel
			." >\n";
}

function button_cell($name, $value, $title=false, $icon=false, $aspect='',$data_dismiss="", $align='center')
{
	echo "<td align='$align'>";
	echo button($name, $value, $title, $icon, $aspect,$data_dismiss);
	echo "</td>";
}
function remove_button_cell($name, $value, $title=false)
{
	button_cell($name, $value, $title, ICON_REMOVE1);
}

function delete_button_cell($name, $value, $title=false, $align='center')
{
	button_cell($name, $value, $title, ICON_DELETE, '', '', $align);
}

function edit_button_cell($name, $value, $title=false, $align='center')
{
	button_cell($name, $value, $title, ICON_EDIT, '', '', $align);
}

function select_button_cell($name, $value, $title=false)
{
	button_cell($name, $value, $title, ICON_ADD, 'selector');
}
//-----------------------------------------------------------------------------------

function check_value($name)
{
    return (empty($_POST[$name]) ? 0 : 1);
}


function checkbox($label, $name, $value=null, $submit_on_change=false, $title=false ,$class=null)
{
  	global $Ajax;

	$str = '';	

	if ($label)
		$str .= $label . "  ";
	if ($submit_on_change !== false) {
		if ($submit_on_change === true)
			$submit_on_change = 
				"JsHttpRequest.request(\"_{$name}_update\", this.form);";
	}
	if ($value === null)
		$value = get_post($name,0);

	$str .= "<input"
	    .($value == 1 ? ' checked':'')
	    ." type='checkbox' name='$name' $class value='1'"
	    .($submit_on_change ? "  onclick='$submit_on_change'" : '')
	    .($title ? " title='$title'" : '')
	    ." >\n";

	$Ajax->addUpdate($name, $name, $value);
	return $str;
}

function check($label, $name, $value=null, $submit_on_change=false, $title=false,$class=null)
{
	echo checkbox($label, $name, $value, $submit_on_change, $title , $class);
}

function check_cells($label, $name, $value=null, $submit_on_change=false, $title=false,
	$params='', $icon=null ,$class=null)
{
	if ($label != null)
		echo "<td>$icon$label</td>\n";
	echo "<td $params>";
	echo check(null, $name, $value, $submit_on_change, $title , $class);
	echo "</td>";
}

function check_row($label, $name, $value=null, $submit_on_change=false, $title=false,$class=null)
{
	echo "<tr><td class=''>$label</td>";
	echo check_cells(NULL, $name, $value, $submit_on_change, $title ,'',null,$class);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------
function radio($label, $name, $value, $selected=null, $submit_on_change=false)
{
	if (!isset($selected))
		$selected = get_post($name) === (string)$value;

	if ($submit_on_change === true)
		$submit_on_change = 
			"JsHttpRequest.request(\"_{$name}_update\", this.form);";

	return "<input type='radio' name=$name value='$value' ".($selected ? "checked":'')
	    .($submit_on_change ? " onclick='$submit_on_change'" : '')
		.">".($label ? $label : '');
}

//-----------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------
function labelheader_cell($label, $params="",$extra=null, $bgcolor=null)
{
	if($extra==null){
		if($bgcolor!=null){
		echo "<th style='background-color: $bgcolor;    color: black;' >$label</th>\n";
		}
		else
		{
		echo "<th style='background-color: #505b67e0;    color: white;' >$label</th>\n";
		}
	}
	else{
		echo "<th $params>$label</th>\n";
	}
}

function label_cell($label=null, $params=" ", $id=null)
{
    global $Ajax;

	if(isset($id))
	{
	    $params .= " id='$id'";
	    $Ajax->addUpdate($id, $id, $label);
	}
	echo "<td $params>$label</td>\n";

	return $label;
}

function email_cell($label, $params="", $id=null)
{
	label_cell("<a href='mailto:$label'>$label</a>", $params, $id);
}

function amount_decimal_cell($label, $params="", $id=null)
{
	$dec = 0;
	label_cell(price_decimal_format($label, $dec), "nowrap align=left ".$params, $id);
}

function amount_cell($label, $bold=false, $params="", $id=null,$right=false)
{
	if ($bold)
		label_cell("<b>".price_format($label)."</b>", "nowrap align=left ".$params, $id);
	elseif($right==true)
		label_cell(price_format($label), "nowrap align=right ".$params, $id);
	else
		label_cell(price_format($label), "nowrap align=left ".$params, $id);

}
function amount_cell2($label, $bold=false, $params="", $id=null)
{
	if ($bold)
		label_cell("<b>".price_format($label)."</b>", "nowrap align=right ".$params, $id);
	else
		label_cell(price_format($label), "nowrap align=right ".$params, $id);
}

//JAM  Allow entered unit prices to be fractional
function unit_amount_cell($label, $bold=false, $params="", $id=null)
{
	if ($bold)
		label_cell("<b>".unit_price_format($label)."</b>", "nowrap align=right ".$params, $id);
	else
		label_cell(unit_price_format($label), "nowrap align=right ".$params, $id);
}


function percent_cell($label, $bold=false, $id=null,$left=false,$border=null)
{
	if ($bold)
		label_cell("<b>".percent_format($label)."</b>", $border."nowrap align=right", $id);
	elseif($left==true)
		label_cell(percent_format($label), $border."nowrap align=left", $id);
	else
		label_cell(percent_format($label), $border."nowrap align=center", $id);

}
// 2008-06-15. Changed
function qty_cell($label, $bold=false, $dec=null, $id=null,$center=false,$left=false,$border=null)
{
	if (!isset($dec))
		$dec = get_qty_dec();
	if ($bold)
		label_cell("<b>".number_format2($label, $dec)."</b>", $border."nowrap align=left", $id);
	elseif($center==true)
		label_cell(number_format2($label, $dec), $border."nowrap align=center", $id);
	elseif($left ==true)
		label_cell(number_format2($label, $dec), $border."nowrap align=left", $id);
	else
		label_cell(number_format2($label, $dec), $border."nowrap align=left", $id);


}

function label_cells($label, $value, $params="", $params2="", $id=null)
{
	
	if ($label != null)
		echo "<td $params>$label</td>\n";
	label_cell($value, $params2, $id);
}
function label1($label, $value, $params2="", $id=null)
{

	if ($label != null)
		echo '<td style="background-color:#ec0c0c2b;">$label</td>\n';
	label_cell($value, $params2, $id);
}
function label_row($label, $value, $params="", $params2="", $leftfill=0, $id=null, $style=null)
{
	echo "<tr $style>";
	if ($params == "")
	{
		echo "<td class=''>$label</td>";
		$label = null;
	}	
	label_cells($label, $value, $params, $params2, $id);
	if ($leftfill!=0)
	  	echo "<td colspan=$leftfill></td>";
	echo "</tr>\n";
}

function text_input($name, $value=null, $size='', $max='', $title='', $params='',$readonly=null,$submit_on_change)
{
	if ($value === null)
		$value = get_post($name);
	if ($size =='')
		$size = 25;
	
	$icon = '';
	if($name == 'salesman_phone')
		$icon = 'fa fa-phone';
	if($name == 'phone')
		$icon = 'fa fa-phone';
	else if($name == 'phone2')
		$icon = 'fa fa-phone';	
	else if($name == 'email')
		$icon = 'fa fa-envelope';
	else if($name == 'fax')
		$icon = 'fa fa-fax';
	else if($name == 'bank_account')
		$icon = 'fa fa-bank';
	else
		$icon = '';
// display_error($readonly);
//$readonly!=null?'readonly':'';
	if($icon != ''){

		$str = '<div class="input-group">';
		$str .= "<input id=\"$name\"  class=\"form-control\" $params ".($icon== 'fa fa-phone' ? 'placeholder="(+971) 55 xxxxxxx" ' :'')."  type=\"text\" name=\"$name\" size=\"$size\" maxlength=\"$max\" value=\"$value\""
		.($title ? " title='$title'" : '')
		. "".($readonly==1?'readonly':'')
		    .">";
		$str .= '<span class="input-group-addon"><i class="'.$icon.'"></i></span>
		</div>';
		return $str;
	}
	else{

		//$readonly!=null?'readonly':'';
	        $searclass = @$submit_on_change ? "searchbox" : '';
		return "<input id=\"$name\"  class=\" $searclass form-control\" $params type=\"text\" name=\"$name\" size=\"$size\" maxlength=\"$max\" value=\"$value\""
		    .($title ? " title='$title'" : '')
		    ."".($readonly==1?'readonly':'')
		    . " >";			
	}
	
}
//-----------------------------------------------------------------------------------

function text_cells($label, $name, $value=null, $size="", $max="", $title=false, 
	$labparams="", $post_label="", $inparams="",$readonly=null,$hide_td=0)
{
  	global $Ajax;

	default_focus($name);
	if ($label != null)
		label_cell($label, $labparams);
	if($hide_td ==0)
		echo "<td>";

	echo text_input($name, $value, $size, $max, $title, $inparams,$readonly,'');

	if ($post_label != "")
		echo " " . $post_label;
	if($hide_td ==0)
		echo "</td>\n";
	$Ajax->addUpdate($name, $name, $value);
}

function text_cells_ex($label, $name, $size, $max=null, $init=null, $title=null,
	$labparams=null, $post_label=null, $submit_on_change=false,$inparams=null,$colspan=1)
{
  	global $Ajax;

	default_focus($name);
	if (!isset($_POST[$name]) || $_POST[$name] == "")
	{
		if ($init)
			$_POST[$name] = $init;
		else
			$_POST[$name] = "";
	}
	if ($label != null)
		label_cell($label, $labparams);

	if (!isset($max))
		$max = $size;

	echo "<td colspan = '$colspan'>";
	echo text_input($name, @$value, $size, $max, $title, @$inparams,@$readonly,$submit_on_change);

	if ($post_label)
		echo " " . $post_label;
	
		echo "</td>\n";
	$Ajax->addUpdate($name, $name, $_POST[$name]);
}

function text_row($label, $name, $value=null, $size=null, $max=null, $title=null, $params="", $post_label="", $readonly=null)
{

	echo "<tr><td class=''>$label</td>";
	text_cells(null, $name, $value, $size, $max, $title, $params, $post_label,@$inparams,$readonly);

	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------

function text_row_ex($label, $name, $size, $max=null, $title=null, $value=null, $params=null, $post_label=null, $compulsary = false)
{
	if($compulsary == true)
		$compulsary = '<span style="color:red;font-size:20px;">*</span>';
	else
		$compulsary = '';
	echo "<tr><td class=''>$label $compulsary</td>";
	text_cells_ex(null, $name, $size, $max, $value, $title, $params, $post_label);

	echo "</tr>\n";
}
//-------------------------------Arabic Text Input--------------------------------------------------
function text_cells_arbic($label, $name, $size, $max=null, $init=null, $title=null,
    $labparams=null, $post_label=null, $submit_on_change=false, $arabic=null)
{
    global $Ajax;

    default_focus($name);
    if (!isset($_POST[$name]) || $_POST[$name] == "")
    {
        if ($init)
            $_POST[$name] = $init;
        else
            $_POST[$name] = "";
    }
    if ($label != null)
        label_cell($label, $labparams);

    if (!isset($max))
        $max = $size;

    echo "<td>";
    $class = $submit_on_change ? 'class="searchbox"' : '';
    if($arabic == 1){
        echo "
        
   <div  class='input-group $img_class '>


        <input  onfocus='bigImg()' onfocusout='normalImg()'   class=\"$class form-control \" id=\"arabic_keyboard\" onkeyup='arabicValue($name)' dir='rtl' type=\"text\" name=\"$name\" size=\"$size\" maxlength=\"$max\" value=\"" . $_POST[$name]. "\""
        .($title ? " title='$title'": '')." >


        </div>";

        if ($post_label)
          echo " " . $post_label;

    }
    // else{
    //     echo "<input $class type=\"text\" name=\"$name\" size=\"$size\" maxlength=\"$max\" value=\"" . $_POST[$name]. "\""
    //     .($title ? " title='$title'": '')." >";

    //     if ($post_label)
    //          echo " " . $post_label;

    // }
 echo "</td>\n";
    $Ajax->addUpdate($name, $name, $_POST[$name]);
}




// function text_cells_arbic($label, $name, $size, $max=null, $init=null, $title=null,
//     $labparams=null, $post_label=null, $submit_on_change=false, $arabic=null)
// {
//     global $Ajax;

//     default_focus($name);
//     if (!isset($_POST[$name]) || $_POST[$name] == "")
//     {
//         if ($init)
//             $_POST[$name] = $init;
//         else
//             $_POST[$name] = "";
//     }
//     if ($label != null)
//         label_cell($label, $labparams);

//     if (!isset($max))
//         $max = $size;

//     echo "<td>";
//     $class = $submit_on_change ? 'class="searchbox"' : '';
//     if($arabic == 1){
//         echo "<input class=\"$class form-control\" onkeyup='arabicValue($name)' dir='rtl' type=\"text\" name=\"$name\" size=\"$size\" maxlength=\"$max\" value=\"" . $_POST[$name]. "\""
//         .($title ? " title='$title'": '')." >";
//         if ($post_label)
//           echo " " . $post_label;

//     }
//     // else{
//     //     echo "<input $class type=\"text\" name=\"$name\" size=\"$size\" maxlength=\"$max\" value=\"" . $_POST[$name]. "\""
//     //     .($title ? " title='$title'": '')." >";

//     //     if ($post_label)
//     //          echo " " . $post_label;

//     // }
//  echo "</td>\n";
//     $Ajax->addUpdate($name, $name, $_POST[$name]);
// }

function text_row_arabic($label, $name, $size, $max=null, $title=null, $value=null, $params=null, $post_label=null, $arabic=0)
{
    echo "<tr><td class=''>$label</td>";
    text_cells_arbic(null, $name, $size, $max, $value, $title, $params, $post_label, false, $arabic);

    echo "</tr>\n";
}

//-----------------------------------------------------------------------------------
function email_row($label, $name, $value, $size, $max, $title=null, $params="", $post_label="")
{
	if (get_post($name)) 
		$label = "<a href='Mailto:".$_POST[$name]."'>$label</a>";
	text_row($label, $name, $value, $size, $max, $title, $params, $post_label);
}

function email_row_ex($label, $name, $size, $max=null, $title=null, $value=null, $params=null, $post_label=null)
{
	if (get_post($name)) 
		$label = "<a href='Mailto:".$_POST[$name]."'>$label</a>";
	text_row_ex($label, $name, $size, $max, $title, $value, $params, $post_label);
}

function link_row($label, $name, $value, $size, $max, $title=null, $params="", $post_label="")
{
	$val = get_post($name);
	if ($val) {
		if (strpos($val,'http://')===false)
			$val = 'http://'.$val;
		$label = "<a href='$val' target='_blank'>$label</a>";
	}
	text_row($label, $name, $value, $size, $max, $title, $params, $post_label);
}

function link_row_ex($label, $name, $size, $max=null, $title=null, $value=null, $params=null, $post_label=null)
{
	$val = get_post($name);
	if ($val) {
		if (strpos($val,'http://')===false)
			$val = 'http://'.$val;
		$label = "<a href='$val' target='_blank'>$label</a>";
	}
	text_row_ex($label, $name, $size, $max, $title, $value, $params, $post_label);
}

//-----------------------------------------------------------------------------------
//
//	Since FA 2.2  $init parameter is superseded by $check. 
//  When $check!=null current date is displayed in red when set to other 
//	than current date.
//
//-------------------------------------------PK----------------------------------------
function date_cells2($label, $name, $title = null, $check=null, $inc_days=0, 
	$inc_months=0, $inc_years=0, $params=null, $submit_on_change=false,$by_default=0)
{
	global $path_to_root, $Ajax;

	
	if (user_use_date_picker())
	{
		
	}	
	else
		$post_label = "";

	if ($label != null)
		label_cell($label, $params);

	echo "<td>";
	
	$class = $submit_on_change ? 'date active' : 'date';

	$aspect = $check ? 'aspect="cdate"' : '';
	if ($check && (get_post($name) != Today()))
		$aspect .= ' style="color:#FF0000"';
	if($by_default==0)
	default_focus($name);
	$size = (user_date_format()>3)?11:10; 
echo '<div class="input-group field-width">';
	echo "<input  type=\"text\" id=\"$name\" name=\"$name\" class=\"$class form-control\" $aspect size=\"$size\" maxlength=\"12\" value=\"" 
	 . $_POST[$name]. "\""
	 .($title ? " title='$title'": '')." > <span class='input-group-addon'><i class='fa fa-calendar'></i></span>";
echo '</div>';
	echo "</td>\n";

	$Ajax->addUpdate($name, $name, $_POST[$name]);
}

//-----------------------------------------PK------------------------------------------


function date_cells($label, $name, $title = null, $check=null, $inc_days=0, 
	$inc_months=0, $inc_years=0, $params=null, $submit_on_change=false,$by_default=0, $disabled=0)
{
	global $path_to_root, $Ajax;

	if (!isset($_POST[$name]) || $_POST[$name] == "")
	{
		if ($inc_years == 1001)
			$_POST[$name] = null;
		else
		{
			if ($by_default == 0) {                                  //by default input feild is empty
				$dd = Today();
			if ($inc_days != 0)
				$dd = add_days($dd, $inc_days);
			if ($inc_months != 0)
				$dd = add_months($dd, $inc_months);
			if ($inc_years != 0)
				$dd = add_years($dd, $inc_years);
			$_POST[$name] = $dd;
			}
			
			
		}
	}
	if (user_use_date_picker())
	{
		// $calc_image = (file_exists("$path_to_root/themes/".user_theme()."/images/cal.gif")) ? 
		// 	"$path_to_root/themes/".user_theme()."/images/cal.gif" : "$path_to_root/themes/default/images/cal.gif";
		// $post_label = "<a tabindex='-1' href=\"javascript:date_picker(document.getElementsByName('$name')[0]);\">"
		// . "	<img src='$calc_image' style='vertical-align:middle;padding-bottom:4px;width:16px;height:16px;border:0;' alt='"._('Click Here to Pick up the date')."'></a>\n";
	}	
	else
		$post_label = "";

	if($disabled){
		$disabled = "disabled";
	}
	else
		$disabled = "";

	if ($label != null)
		label_cell($label, $params);

	echo "<td>";
	
	$class = $submit_on_change ? 'date active' : 'date';

	$aspect = $check ? 'aspect="cdate"' : '';
	if ($check && (get_post($name) != Today()))
		$aspect .= ' style="color:#FF0000"';

	default_focus($name);
	$size = (user_date_format()>3)?11:10; 
echo '<div class="input-group field-width">';
	echo "<input type=\"text\" name=\"$name\" class=\"$class form-control\" $aspect size=\"$size\" maxlength=\"12\" $disabled value=\"" 
	 . $_POST[$name]. "\""
	 .($title ? " title='$title'": '')." > <span class='input-group-addon'><i class='fa fa-calendar'></i></span>";
echo '</div>';
	echo "</td>\n";

	$Ajax->addUpdate($name, $name, $_POST[$name]);
}

function date_row($label, $name, $title=null, $check=null, $inc_days=0, $inc_months=0, 
	$inc_years=0, $params=null, $submit_on_change=false,$by_default=0)
{
	echo "<tr><td class=''>$label</td>";
	date_cells(null, $name, $title, $check, $inc_days, $inc_months, 
		$inc_years, $params, $submit_on_change, $by_default);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------
function password_row($label, $name, $value)
{
	echo "<tr><td class=''>$label</td>";
	label_cell("<input type='password' name='$name' size=20 maxlength=20 value='$value' >");
	echo "</tr>\n";
}	

function password_row_readonly($label, $name, $value)
{
	echo "<tr><td class=''>$label</td>";
	label_cell("<input type='password' name='$name' size=20 maxlength=20 value='$value' readonly >");
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------
function file_cells($label, $name, $id="", $class=null, $style=null)
{
	

	if ($id != "")
		$id = "id='$id'";
	label_cells($label, "<input type='file' name='$name' $id  class='$class' style='$style'>");
}		
function file_row($label, $name, $id = "", $class=null, $style=null)
{
	echo "<tr><td class=''>$label</td>";
	file_cells(null, $name, $id, $class, $style);
	echo "</tr>\n";
}	

/*-----------------------------------------------------------------------------------

 Reference number input.

 Optional  $context array contains transaction data used in number parsing:
 	'data' - data used for month/year codes
	'location' - location code
 	'customer' - debtor_no
 	'supplier' - supplier id
 	'branch' - branch_code
*/
function ref_cells($label, $name, $title=null, $init=null, $params=null, $submit_on_change=false, $type=null, $context=null,$size='',$in_param=null)
{
	global $Ajax, $Refs;

if ($size=='')
	$size=16;

	if (isset($type)) {
		if (empty($_POST[$name.'_list'])) // restore refline id
			$_POST[$name.'_list'] = $Refs->reflines->find_refline_id(empty($_POST[$name]) ? $init : $_POST[$name], $type);

		if (empty($_POST[$name])) // initialization
		{
			if (isset($init))
			{
				$_POST[$name] = $init;
			} else {
				$_POST[$name] = $Refs->get_next($type, $_POST[$name.'_list'], $context);
			}
			$Ajax->addUpdate(true, $name, $_POST[$name]);
		}

		if (check_ui_refresh($name)) { // call context changed
			$_POST[$name] = $Refs->normalize($_POST[$name], $type, $context, $_POST[$name.'_list']);
			$Ajax->addUpdate(true, $name, $_POST[$name]);
		}

		if ($Refs->reflines->count($type)>1) {
			if (list_updated($name.'_list')) {
				$_POST[$name] = $Refs->get_next($type, $_POST[$name.'_list'], $context);
				$Ajax->addUpdate(true, $name, $_POST[$name]);
			}
			$list = refline_list($name.'_list', $type);
		} else {
			$list = '';
		}

		if (isset($label))
			label_cell($label, $params);

		label_cell($list."<input class='form-control' name='".$name."' "
			.(check_edit_access($name) ? '' : 'disabled ')
			."value='".@$_POST[$name]."' size=10 maxlength=35>");
	}
	else // just wildcard ref field (e.g. for global inquires)
	{
		text_cells_ex($label, $name, $size, 35, $init, $title, $params, null, $submit_on_change,$in_param);
	}
}

//-----------------------------------------------------------------------------------

function ref_row($label, $name, $title=null, $init=null, $submit_on_change=false, $type=null, $context = null)
{
	echo "<tr><td class=''>$label</td>";
	ref_cells(null, $name, $title, $init, null, $submit_on_change, $type, $context);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------

function ref_cells1($label, $name, $title=null, $init=null, $params=null, $submit_on_change=false, $type=null, $context=null,$size='',$placeholder=null)
{
	global $Ajax, $Refs;

if ($size=='')
	$size=16;
		text_cells_ex1($label, $name, $size, 35, $init, $title, $params, null, $submit_on_change,$placeholder);
}

function text_cells_ex1($label, $name, $size, $max=null, $init=null, $title=null,
	$labparams=null, $post_label=null, $submit_on_change=false,$placeholder=null)
{
  	global $Ajax;

	default_focus($name);
	if (!isset($_POST[$name]) || $_POST[$name] == "")
	{
		if ($init)
			$_POST[$name] = $init;
		else
			$_POST[$name] = "";
	}
	if ($label != null)
		label_cell($label, $labparams);

	if (!isset($max))
		$max = $size;

		echo "<ul style='padding:0;'>";
	echo text_input($name, @$value, $size, $max, $title, @$inparams,@$readonly,$submit_on_change,$placeholder);

	if ($post_label)
		echo " " . $post_label;
	
		echo "</ul>\n";
	$Ajax->addUpdate($name, $name, $_POST[$name]);
}



//-----------------------------------------------------------------------------------

function percent_row($label, $name, $init=null)
{

	if (!isset($_POST[$name]) || $_POST[$name]=="")
	{
		$_POST[$name] = $init == null ? '' : $init;
	}

	small_amount_row($label, $name, $_POST[$name], null, "%", user_percent_dec());
}
function number_cells_ex($label, $name, $size, $max=null, $init=null, $params=null, $post_label=null, $dec=null,$readonly=false)
{
	global $Ajax;

	// if (!isset($dec))
	//   	$dec = user_price_dec();
	if (!isset($_POST[$name]) || $_POST[$name] == "")
	{
		if ($init !== null)
			$_POST[$name] = $init;
		else
			$_POST[$name] = '';
	}
	if ($label != null)
	{
		if ($params == null)
			$params = "class=''";
		label_cell($label, $params);
	}
	if (!isset($max))
		$max = $size;

	if ($label != null)
		echo "<td>";
	else
		echo "<td align='left'>";

	if($readonly != false)
		$readonly = 'readonly';
	else
		$readonly = '';

    echo "<div class='input-group field-width'>";
	echo "<input $readonly class='number form-control' type=\"text\" name=\"$name\" size=\"$size\" maxlength=\"$max\" dec=\"$dec\" value=\"" . $_POST[$name]. "\">";
	if ($post_label) {
		echo "<span class='input-group-addon' id='_{$name}_label'><b>$post_label</b></span>";
		$Ajax->addUpdate($name, '_'.$name.'_label', $post_label);
	}
	else{
	     if($name!=0)
	     {
		      if($name=="price" || $name=="_ex_rate" ||  $name=="base_amount" ||  $name=="material_cost")
		       echo "<span class='input-group-addon'><b>AED</b></span>";
	          }
	}
       echo " </div>";


	echo "</td>\n";
	$Ajax->addUpdate($name, $name, $_POST[$name]);
	$Ajax->addAssign($name, $name, 'dec', $dec);
}

function amount_cells_ex($label, $name, $size, $max=null, $init=null, $params=null, $post_label=null, $dec=null,$readonly=false)
{
	global $Ajax;

	if (!isset($dec))
	  	$dec = user_price_dec();
	if (!isset($_POST[$name]) || $_POST[$name] == "")
	{
		if ($init !== null)
			$_POST[$name] = $init;
		else
			$_POST[$name] = '';
	}
	if ($label != null)
	{
		if ($params == null)
			$params = "class=''";
		label_cell($label, $params);
	}
	if (!isset($max))
		$max = $size;

	if ($label != null)
		echo "<td>";
	else
		echo "<td align='left'>";

	if($readonly != false)
		$readonly = 'readonly';
	else
		$readonly = '';

    echo "<div class='input-group field-width'>";
	echo "<input $readonly class='amount form-control' type=\"text\" name=\"$name\" size=\"$size\" maxlength=\"$max\" dec=\"$dec\" value=\"" . $_POST[$name]. "\">";
	if ($post_label) {
		echo "<span class='input-group-addon' id='_{$name}_label'><b>$post_label</b></span>";
		$Ajax->addUpdate($name, '_'.$name.'_label', $post_label);
	}
	else{
	     if($name!=0)
	     {
		      if($name=="price" || $name=="_ex_rate" ||  $name=="base_amount" ||  $name=="material_cost")
		       echo "<span class='input-group-addon'><b>AED</b></span>";
	          }
	}
       echo " </div>";


	echo "</td>\n";
	$Ajax->addUpdate($name, $name, $_POST[$name]);
	$Ajax->addAssign($name, $name, 'dec', $dec);
}


//-----------------------------------------------------------------------------------

function amount_cells($label, $name, $init=null, $params=null, $post_label=null, $dec=null, $readonly=false)
{
	amount_cells_ex($label, $name, 15, 15, $init, $params, $post_label, $dec, $readonly);
}

//JAM  Allow entered unit prices to be fractional
function unit_amount_cells($label, $name, $init=null, $params=null, $post_label=null, $dec=null)
{
	if (!isset($dec))
	  	$dec = user_price_dec()+2;

	amount_cells_ex($label, $name, 15, 15, $init, $params, $post_label, $dec+2);
}

function amount_row($label, $name, $init=null, $params=null, $post_label=null, $dec=null,$readonly=false)
{
	echo "<tr>";
	amount_cells($label, $name, $init, $params, $post_label, $dec,$readonly);
	echo "</tr>\n";
}

function small_amount_row($label, $name, $init=null, $params=null, $post_label=null, $dec=null)
{
	echo "<tr>";
	small_amount_cells($label, $name, $init, $params, $post_label, $dec);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------

function qty_cells($label, $name, $init=null, $params=null, $post_label=null, $dec=null)
{
	if (!isset($dec))
	  	$dec = user_qty_dec();

	amount_cells_ex($label, $name, 15, 15, $init, $params, $post_label, $dec);
}

function qty_row($label, $name, $init=null, $params=null, $post_label=null, $dec=null)
{
	if (!isset($dec))
	  	$dec = user_qty_dec();

	echo "<tr>";
	amount_cells($label, $name, $init, $params, $post_label, $dec);
	echo "</tr>\n";
}

function small_qty_row($label, $name, $init=null, $params=null, $post_label=null, $dec=null)
{
	if (!isset($dec))
	  	$dec = user_qty_dec();

	echo "<tr>";
	small_amount_cells($label, $name, $init, $params, $post_label, $dec);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------

function small_amount_cells($label, $name, $init=null, $params=null, $post_label=null, $dec=null)
{
	amount_cells_ex($label, $name, 7, 12, $init, $params, $post_label, $dec);
}

//-----------------------------------------------------------------------------------

function small_qty_cells($label, $name, $init=null, $params=null, $post_label=null, $dec=null)
{
  	if (!isset($dec))
	  	$dec = user_qty_dec();
	amount_cells_ex($label, $name, 7, 12, $init, $params, $post_label, $dec);
}

//-----------------------------------------------------------------------------------

function textarea_cells($label, $name, $value, $cols, $rows, $title = null, $params="")
{
  	global $Ajax;

	default_focus($name);
	if ($label != null)
		echo "<td $params>$label</td>\n";
	if ($value == null)
		$value = (!isset($_POST[$name]) ? "" : $_POST[$name]);
	echo "<td><textarea class='textarea form-control' name='$name' cols='$cols' rows='$rows'"
	.($title ? " title='$title'" : '')
	.">$value</textarea></td>\n";
	$Ajax->addUpdate($name, $name, $value);
}
function textarea_cells_ckeditor($label, $name, $value, $cols, $rows, $title = null, $params="")
{
  	global $Ajax;

	default_focus($name);
	if ($label != null)
		echo "<td $params>$label</td>\n";
	if ($value == null)
		$value = (!isset($_POST[$name]) ? "" : $_POST[$name]);
	echo "<td><textarea name='$name' id='editor1' cols='$cols' rows='$rows'"
	.($title ? " title='$title'" : '')
	.">$value</textarea></td>\n";
	$Ajax->addUpdate($name, $name, $value);
echo '<script>
  $(function () {
    // Replace the <textarea id="editor1"> with a CKEditor
    // instance, using default configuration.
    CKEDITOR.replace("editor1")
    //bootstrap WYSIHTML5 - text editor
    $(".textarea").wysihtml5()
  })
</script>';
}

function textarea_row_ckeditor($label, $name, $value, $cols, $rows, $title=null, $params="")
{
	echo "<tr><td class=''>$label</td>";
	textarea_cells_ckeditor(null, $name, $value, $cols, $rows, $title, $params);
	echo "</tr>\n";
}


function textarea_row($label, $name, $value, $cols, $rows, $title=null, $params="", $compulsary=false)
{
	if($compulsary == true)
		$compulsary = '<span style="color:red;font-size:20px;">*</span>';
	else
		$compulsary = '';

	echo "<tr><td class=''>$label $compulsary</td>";
	textarea_cells(null, $name, $value, $cols, $rows, $title, $params);
	echo "</tr>\n";
}
function textarea_cells_limit($label, $name, $value, $cols, $rows, $title = null, $params="",$maxlength)
{
  	global $Ajax;

	default_focus($name);
	if ($label != null)
		echo "<td $params>$label</td>\n";
	if ($value == null)
		$value = (!isset($_POST[$name]) ? "" : $_POST[$name]);
	echo "<td><textarea class='textarea form-control' name='$name' cols='$cols' rows='$rows' "
	.($title ? " title='$title'" : '')
	." ".($maxlength ? " maxlength='$maxlength'" : '')."  >$value</textarea></td>\n";
	$Ajax->addUpdate($name, $name, $value);
}
function textarea_row_limit($label, $name, $value, $cols, $rows, $title=null, $params="",$maxlength)
{
	echo "<tr><td class=''>$label</td>";
	textarea_cells_limit(null, $name, $value, $cols, $rows, $title, $params,$maxlength);
	echo "</tr>\n";
}
//-----------------------------------------------------------------------------------
//
//	When show_inactive page option is set 
//  displays value of inactive field as checkbox cell.
//  Also updates database record after status change.
//
function inactive_control_cell($id, $value, $table, $key)
{
	global	$Ajax;

	$name = "Inactive". $id;
	$value = $value ? 1:0;

	if (check_value('show_inactive')) {
		if (isset($_POST['LInact'][$id]) && (get_post('_Inactive'.$id.'_update') || 
			get_post('Update')) && (check_value('Inactive'.$id) != $value)) {
			update_record_status($id, !$value, $table, $key);
		}
		echo '<td align="center">'. checkbox(null, $name, $value, true, '')
 			. hidden("LInact[$id]", $value, false) . '</td>';	
	}
}
//
//	Displays controls for optional display of inactive records
//
function inactive_control_row($th) {
		echo  "<tr><td colspan=".(count($th)).">"
		."<div style='float:left;'>"
		. checkbox(null, 'show_inactive', null, true). _("Show also Inactive")
		 ."</div>";
		//<div style='float:right;'>"
		// . submit('Update', _('Update'), false, '', null)
		// ."</div></td></tr>";
}
//
//	Inserts additional column header when display of inactive records is on.
//
function inactive_control_column(&$th) {
	global $Ajax;
	
	if (check_value('show_inactive')) 
		array_insert($th, count($th)-2 , _("Inactive"));
	if (get_post('_show_inactive_update')) {
		$Ajax->activate('_page_body');
	}
}

function customer_credit_row($customer, $credit, $parms='')
{
	global $path_to_root;
	
	label_row( _("Current Credit:"),
		"<a target='_blank' " . ($credit<0 ? 'class="redfg"' : '')
		."href='$path_to_root/sales/inquiry/customer_inquiry.php?customer_id=".$customer."'"
		." onclick=\"javascript:openWindow(this.href,this.target); return false;\" >"
		. price_format($credit)
		."</a>", $parms);
}

function supplier_credit_row($supplier, $credit, $parms='')
{
	global $path_to_root;
	
	label_row( _("Current Credit:"),
		"<a target='_blank' " . ($credit<0 ? 'class="redfg"' : '')
		."href='$path_to_root/purchasing/inquiry/supplier_inquiry.php?supplier_id=".$supplier."'"
		." onclick=\"javascript:openWindow(this.href,this.target); return false;\" >"
		. price_format($credit)
		."</a>", $parms);
}

function bank_balance_row($bank_acc, $parms='')
{
	global $path_to_root;

	$to = add_days(Today(), 1);
	$bal = get_balance_before_for_bank_account($bank_acc, $to);
	label_row( _("Bank Balance:"),
		"<a target='_blank' " . ($bal<0 ? 'class="redfg"' : '')
		."href='$path_to_root/gl/inquiry/bank_inquiry.php?bank_account=".$bank_acc."'"
		." onclick=\"javascript:openWindow(this.href,this.target); return false;\" >&nbsp;"
		. price_format($bal)
		."</a>", $parms);
}

function ahref($label, $href, $target="", $onclick="") {
  echo "<a href='$href' target='$target' onclick='$onclick'>$label</a>";
}

function ahref_cell($label, $href, $target="", $onclick="") {
  echo "<td align='center'>&nbsp;&nbsp;";
  ahref($label, $href, $target, $onclick);
  echo "&nbsp;&nbsp;</td>";
}
function submit_add_or_update_ckeditor($add=true, $title=false, $async=false, $clone=false)
{
	$cancel = $async;

	if ($async === 'both') {
		$async = 'default'; $cancel = 'cancel';
	}
	elseif ($async === 'upgrade') {
		$async = 'default nonajax process'; $cancel = 'cancel';
	}
	elseif ($async === 'default')
		$cancel = true;
	elseif ($async === 'cancel')
		$async = true;
	
	if ($add)
		submit_ckeditor('ADD_ITEM', _("Add new"), true, $title, $async);
	else {
		submit_ckeditor('UPDATE_ITEM', _("Update"), true, _('Submit changes'), $async);
		if ($clone) submit_ckeditor('CLONE', _("Clone"), true, 
			_('Edit new record with current data'), $async);
		submit_ckeditor('RESET', _("Cancel"), true, _('Cancel edition'), $cancel);
	}
}


function submit_add_or_update_center_ckedito($add=true, $title=false, $async=false, $clone=false)
{
	echo "<center>";
	submit_add_or_update_ckeditor($add, $title, $async, $clone);
	echo "</center>";
}
function submit_ckeditor($name, $value, $echo=true, $title=false, $atype=false, $icon=false)
{
	global $path_to_root;
	$buttonClass = array(
		'AddItem' => 'btn btn-sm btn-info btn-flat', 
		'SearchOrders' => 'btn btn-sm btn-info btn-flat', 
		'update'  => 'btn btn-sm btn-success btn-flat', 
		'ADD_ITEM'  => 'btn btn-sm btn-success btn-flat', 
		'ProcessCredit'  => 'btn btn-sm btn-success btn-flat', 
		'AddPaymentItem'  => 'btn btn-sm btn-success btn-flat', 
		'UPDATE_ITEM'  => 'btn btn-sm btn-success btn-flat', 
		'Update'  => 'btn btn-sm btn-info btn-flat', 
		'contactsNEW'  => 'btn btn-sm btn-success btn-flat', 
		'ProcessOrder'  => 'btn btn-sm btn-success btn-flat', 
		'submit'  => 'btn btn-sm btn-success btn-flat', 
		'CancelOrder'  => 'btn btn-sm btn-danger btn-flat', 
		'delete'  => 'btn btn-sm btn-danger btn-flat', 
		'RESET'  => 'btn btn-sm btn-danger btn-flat', 
		'default'  => 'btn btn-sm btn-default btn-flat', 
	);

	if (array_key_exists($name, $buttonClass))
	    $set =  $buttonClass[$name];					
	else
	    $set =  $buttonClass['default'];

	$aspect='';
	if ($atype === null) {
		$aspect = fallback_mode() ? " aspect='fallback'" : " style='display:none;'";

	} elseif (!is_bool($atype)) { // necessary: switch uses '=='

		$aspect = " aspect='$atype' ";
		$types = explode(' ', $atype);

		foreach ($types as $type) {
			switch($type) {
				case 'selector':
					$aspect = " aspect='selector' rel = '$value'"; 
					$value = _("Select");
					if ($icon===false) $icon=ICON_SUBMIT; break;

				case 'default':
					if ($icon===false) $icon=ICON_SUBMIT; break;

				case 'cancel':
					if ($icon===false) $icon=ICON_ESCAPE; break;

				case 'nonajax':
				case 'download':
					$atype = false;
			}
		}
	}
	$icon = '';
	$submit_str = "<button onClick='myFunction()' class=\""
	   .($atype ? $set : 'inputsubmit'.$set)
		."\" type=\"submit\""
		.$aspect
	    ." name=\"$name\"  id=\"$name\" value=\"$value\""
	    .($title ? " title='$title'" : '')
	    .">"
		.($icon ? "<img src='$path_to_root/themes/".user_theme()."/images/$icon' height='12' alt=''>" : '')
		."<span>$value</span>"
		."</button>\n";
	if ($echo)
		echo $submit_str;
	else
		return $submit_str;
}

function submit_center_ckeditor($name, $value, $echo=true, $title=false, $async=false, $icon=false)
{
	if ($echo) echo "<center>";
	submit_ckeditor($name, $value, $echo, $title, $async, $icon);
	if ($echo) echo "</center>";
}

 function line_item_image($item_name=null , $price=null,$item_desc ,$price_type=0)
  {
    $item=$item_name;

     if (file_exists(company_path().'/images/'.item_img_name($item_name).".jpg")) 
					{
					 // 31/08/08 - rand() call is necessary here to avoid caching problems.
						// sssdisplay_error(company_path().'/images/'.item_img_name($item_name));
						$stock_img_link = "<img id='".$item_name."' alt = '[".$item_name.".jpg".
							"]'  class='img-thumbnail zoom'  src='".company_path().'/images/'.item_img_name($item_name).
							".jpg?nocache=".rand()."'"." style='      height: 50px;
				    width: 50px;  margin-left: 10px ' border='0' onclick='view_img(this)'>";
                             // display_error($price);
                              if($price_type)
                                 $price="<h4><b>Standard cost  :</b></h4>  ".price_format($price);
                             	else
                                 $price="<h4><b>Purchase Price : </b></h4> ".price_format($price);
				    echo "<input type='hidden' name='checkyear' id='stckId".$item_name."' value=' ".$item_name."'>";
				    echo "<input type='hidden' name='checkyear' id='cost".$item_name."' value='".$price."'>";
				    echo "<input type='hidden' name='checkyear' id='desc".$item_name."' value=' ".$item_desc."'>";

				    while ($myrow = db_fetch($loc_details))
					{
						$qoh = get_qoh_on_date($item, $myrow["loc_code"]).'.00';
				    echo "<input type='hidden' name='checkyear' id='qoh".$item_name."' value=' ".$qoh."'>";
					}
					//	$check_remove_image = true;
					label_cell($stock_img_link);
					} 
	        else
	         	label_cell("No image");

// echo 
// '
// <table>
// <th>
// Item
// </th>
// ITEM
// <tr>
// <td></td>
// </tr>
// </table>
// ';
  //   /*margin: 8px 8px -15px 0px;*/
	        	  echo '<div id="myModal" class="modal" style=" "  role="dialog">';
         //          echo '<span class="glyphicon glyphicon-remove close" style="     margin-top: -79px; color: red;
    					// opacity: 1;"  aria-label="Close" onclick="close_img()">	</span>';
                  echo '';
  				  echo '  <div class="panel panel-default " style=" box-shadow: 4px 9px 27px -4px #151516; height: auto; width: 840px; padding-bottom:14px;  ">
     			
      <div class="panel-heading col-md-12" style="width:262px; color: #333;  float: left; background:#ffffff; padding: 9px 9px 9px 9px;     margin-bottom: -15px;  border-color:white !important;  "><img class="modal-content" id="img01" style=" width: 225px;; height: 290px; border-radius: 44px solid;  " ></div>

      <div class="panel-body " style="color: black; background: #ffffff;   " >
      
      <div id="section1">
      <div class="col-md-12 ml-auto" style ="border-bottom: 1px solid #f2f2f2;">
      <h3><b>Item:</b></h3>
      </div>
      <div class="col-md-15">
      <div style="padding-left:12px; padding-top:69px; padding-bottom:2px;  ">
	      <div><h4 style="display:inline;"><b>Stock Id:</b> </h4><span style="font-size: 15px;" id="ItemCode"></span></div>
	      <div style=""><h4 ><b>Stock Description: </b></h4><span  style="font-size: 15px;" id="ItemName"></span></div>
	    
	      
	      <div style=""><span id="Itemcost"></span></div>
      </div>
      </div>
      </div>



      <div id="section2">
      </div>
      </div>
      </div>';


	echo '</div>';

  }

 // pk
  function line_item_image_for_mobile($item_name=null , $price=null,$item_desc ,$price_type=0)
  {
    $item=$item_name;

     if (file_exists(company_path().'/images/'.item_img_name($item_name).".jpg")) 
	{
					 // 31/08/08 - rand() call is necessary here to avoid caching problems.
						// sssdisplay_error(company_path().'/images/'.item_img_name($item_name));
		$stock_img_link = "<img id='".$item_name."' alt = '[".$item_name.".jpg".
							"]'  class='img-thumbnail zoom'  src='".company_path().'/images/'.item_img_name($item_name).
							".jpg?nocache=".rand()."'"." style=' width: 100px;  margin-left: 10px ' border='0' onclick='view_img(this)'>";
                             // display_error($price);
        if($price_type)
             $price="<h4><b>Standard cost  :</b></h4>  ".price_format($price);
        else
            $price="<h4><b>Purchase Price : </b></h4> ".price_format($price);
				    echo "<input type='hidden' name='checkyear' id='stckId".$item_name."' value=' ".$item_name."'>";
				    echo "<input type='hidden' name='checkyear' id='cost".$item_name."' value='".$price."'>";
				    echo "<input type='hidden' name='checkyear' id='desc".$item_name."' value=' ".$item_desc."'>";

				    while ($myrow = db_fetch($loc_details))
					{
						$qoh = get_qoh_on_date($item, $myrow["loc_code"]).'.00';
				    echo "<input type='hidden' name='checkyear' id='qoh".$item_name."' value=' ".$qoh."'>";
					}
					//	$check_remove_image = true;
					label_cell($stock_img_link, 'style="width: 140px;"');
					} 
	        else
	         	label_cell("No image", 'style="width: 120px;"');


	        	  echo '<div id="myModal" class="modal" style=" "  role="dialog">';
         //          echo '<span class="glyphicon glyphicon-remove close" style="     margin-top: -79px; color: red;
    					// opacity: 1;"  aria-label="Close" onclick="close_img()">	</span>';
                  echo '';
  				  echo '  <div class="panel panel-default " style=" box-shadow: 4px 9px 27px -4px #151516; height: auto; width: 840px; padding-bottom:14px;  ">
     			
      <div class="panel-heading col-md-12" style="width:262px; color: #333;  float: left; background:#ffffff; padding: 9px 9px 9px 9px;     margin-bottom: -15px;  border-color:white !important;  "><img class="modal-content" id="img01" style=" width: 225px;; height: 290px; border-radius: 44px solid;  " ></div>

      <div class="panel-body " style="color: black; background: #ffffff;   " >
      
      <div id="section1">
      <div class="col-md-12 ml-auto" style ="border-bottom: 1px solid #f2f2f2;">
      <h3><b>Item:</b></h3>
      </div>
      <div class="col-md-15">
      <div style="padding-left:12px; padding-top:69px; padding-bottom:2px;  ">
	      <div><h4 style="display:inline;"><b>Stock Id:</b> </h4><span style="font-size: 15px;" id="ItemCode"></span></div>
	      <div style=""><h4 ><b>Stock Description: </b></h4><span  style="font-size: 15px;" id="ItemName"></span></div>
	    
	      
	      <div style=""><span id="Itemcost"></span></div>
      </div>
      </div>
      </div>



      <div id="section2">
      </div>
      </div>
      </div>';


	echo '</div>';

  }
  
//   <image src="../iconssss/price-tag.png" style="margin: -1px 0px 11px -10px; width: 52px; height: 44px;" >

function long_text_cell($label = null,$value=null, $class = null, $params=" ", $id=null, $p_id=null,$end_range = 20)
{
	// display_error($value);
    global $Ajax;
    if($label != null)
    	echo "<td $class >".$label."</td>";

	if(isset($id))
	{
	    $params .= " id='$id'";
	    $Ajax->addUpdate($id, $id, $value);
	}
	if(strlen($value) > $end_range)
	{
	$less_label = substr($value,0,$end_range);
	$more_label = substr($value,$end_range);
	$href = "#".$p_id;
	// display_error($p_id);
	echo "<td $params>
	<p style='    display: inline;'>$less_label<span id='$p_id' style='display:none; margin-top: -11px;' >$more_label</span></p><a style='display:inline' href='$href' class='nav-toggle'> Read More... </a>
	
	</td>";
		
	}
	else
	{
	echo "<td $params>$value</td>\n";
		
	}

	return $value;
}
if(isset($_POST['ADD_ITEM_ITEM'])){
	include_once("../../inventory/includes/db/items_db.inc");
	add_item($_POST['NewStockID'], $_POST['description'],
				$_POST['long_description'], $_POST['category_id'], $_POST['tax_type_id'],
				$_POST['units'], get_post('fixed_asset') ? 'F' : get_post('mb_flag'), $_POST['sales_account'],
				$_POST['inventory_account'], $_POST['cogs_account'],
				$_POST['adjustment_account'], $_POST['wip_account'], 
				$_POST['dimension_id'], $_POST['dimension2_id'],
				check_value('no_sale'), check_value('editable'), check_value('no_purchase'),
				get_post('depreciation_method'), input_num('depreciation_rate'), input_num('depreciation_factor'), get_post('depreciation_start'),
				get_post('fa_class_id'),$_POST['description_arabic']);
}  

if($check == 1){
    
}else{
?>



<script type="text/javascript">

function view_img(imglink){
      document.getElementById('myModal').style.display ='block';
      $('#myModal').modal({backdrop: 'dynamic', keyboard: false})
      document.getElementById('img01').src = document.getElementById(imglink.id).src; 
      document.getElementById("ItemCode").innerHTML = document.getElementById('stckId'+imglink.id).value;
      document.getElementById("ItemName").innerHTML = document.getElementById('desc'+imglink.id).value;
      document.getElementById("Itemcost").innerHTML =document.getElementById('cost'+imglink.id).value;


      	//__________________ AJAX ________________________________//
// for append inside div section2

var stc_id = imglink.id;
  $.ajax({                                      
  url: "../sales/get_loc.php",
  data    :{
  stc_id: stc_id, },            //you can insert url argumnets here to    pass to api.php
  type    : "POST",
  dataType: 'json',                 
                                  
  success: function(data)          
  {
  		$("#section2").html(data);   

  }
});

      	//__________________ AJAX ________________________________//


     
}

// $('#myImg').click(function(){

// alert("ok");	
// });

// Get the <span> element that closes the modal
// var span = document.getElementsByClassName("close")[0];

// When the user clicks on <span> (x), close the modal
 function close_img() { 
    document.getElementById("myModal").style.display  = "none";
}

function add_new_item(){
		// $('#ADD_ITEM_ITEM').attr("disabled", true);
		$('#new_item_modal').show();
		$('#new_item_modal').modal('toggle');
	}

</script>

<!--<div style="display: none;" class="modal fade" id="new_item_modal" tabindex="-1" role="dialog" aria-labelledby="new_item_modalLabel">
    <div class="modal-dialog" role="document">
      <div class="modal-content" >
        <div class="modal-header">
          <a type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
          <h4 class="modal-title" id="new_item_modalLabel">Item</h4>
        </div>
        <div class="modal-body">
           <?php
           /*start_form();

           start_outer_table(TABLESTYLE2,"style='width:100% !important;'", 2,0,false,0,0);

           text_row(_("Item Code:"), 'NewStockID', null, 21, 20, null, "");
           echo "<tr id='item_code_tr' style='display:none;'><td></td><td>
           			<span>This item code is already assigned to stock item or sale kit.</td></span>
           		</tr>";

           text_row(_("Name:"), 'description', null, 52, 30);
           echo "<tr id='item_name_tr' style='display:none;'><td></td><td>
           			<span>The item name must be entered.</td></span>
           		</tr>";

           text_row_arabic(_("Name (In Arabic):"), 'description_arabic', 50, 50 ,null,null,null,null,1);

           textarea_row(_('Description:'), 'long_description', null, 42, 3);

			stock_categories_list_row(_("Category:"), 'category_id', null, false);

			item_tax_types_list_row(_("Item Tax Type:"), 'tax_type_id', null);

			stock_item_types_list_row(_("Item Type:"), 'mb_flag', null, $fresh_item);

			stock_units_list_row(_('Units of Measure:'), 'units', null, $fresh_item);

			check_row(_("Editable description:"), 'editable');

			check_row(_("Exclude from sales:"), 'no_sale');
			
			check_row(_("Exclude from purchases:"), 'no_purchase');
			
			gl_all_accounts_list_row(_("Sales Account:"), 'sales_account', $_POST['sales_account']);

			gl_all_accounts_list_row(_("Inventory Account:"), 'inventory_account', $_POST['inventory_account']);
			
			gl_all_accounts_list_row(_("C.O.G.S. Account:"), 'cogs_account', $_POST['cogs_account']);
			
			gl_all_accounts_list_row(_("Inventory Adjustments Account:"), 'adjustment_account', $_POST['adjustment_account']);

			gl_all_accounts_list_row(_("WIP Account:"), 'wip_account', $_POST['wip_account']);
			end_table();*/
			
           ?>

        </div>
        <div class="modal-footer">
          <?php #submit_center('ADD_ITEM_ITEM', _("Insert New Item"), true, '', 'default',false,"modal");
           ?>
        </div>
        <?php
        #end_form();
        ?>
      </div>
    </div>
  </div>
-->
<!-- -------------------------------POS Screen Work------------------------------------->

<?php 
}
?>