<?php

include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/includes/types.inc");
include_once($path_to_root . "/includes/current_user.inc");

define('SEARCH_BUTTON', "<input %s type='submit' class='combo_submit' style='border:0;background:url($path_to_root/themes/"
	."%s/images/locate.png) no-repeat;%s' aspect='fallback' name='%s' value=' ' title='"._("Set filter")."'> ");

define('SELECT_BUTTON', "<input %s type='submit' class='combo_select' style='border:0;background:url($path_to_root/themes/"
	."%s/images/button_ok.png) no-repeat;%s' aspect='fallback' name='%s' value=' ' title='"._("Select")."'> ");

//----------------------------------------------------------------------------
//	Universal sql combo generator
//	$sql must return selector values and selector texts in columns 0 & 1
//	Options are merged with defaults.

function combo_input($name, $selected_id, $sql, $valfield, $namefield,
	$options=null, $type=null)
{
	global $Ajax, $path_to_root, $SysPrefs;

$opts = array(		// default options
	'where'=> array(),		// additional constraints
	'order' => $namefield,	// list sort order
		// special option parameters
	'spec_option'=>false, 	// option text or false
	'spec_id' => 0,		// option id
		// submit on select parameters
	'default' => '', // default value when $_POST is not set
	'multi' => false,	// multiple select
	'select_submit' => false, //submit on select: true/false
	'async' => true,	// select update via ajax (true) vs _page_body reload
		// search box parameters
	'sel_hint' => null,
	'search_box' => false, 	// name or true/false
	'type' => 0,	// type of extended selector:
		// 0 - with (optional) visible search box, search by fragment inside id
		// 1 - with hidden search box, search by option text
		// 2 - with (optional) visible search box, search by fragment at the start of id
		// 3 - TODO reverse: box with hidden selector available via enter; this
		// would be convenient for optional ad hoc adding of new item
	'search_submit' => true, //search submit button: true/false
	'size' => 8,	// size and max of box tag
	'max' => 50,
	'height' => false,	// number of lines in select box
	'cells' => false,	// combo displayed as 2 <td></td> cells
	'search' => array(), // sql field names to search
	'format' => null, 	 // format functions for regular options
	'disabled' => false,
	'box_hint' => null, // box/selectors hints; null = std see below
	'category' => false, // category column name or false
	'show_inactive' => false, // show inactive records. 
	'editable' => false, // false, or length of editable entry field
	'editlink' => false	// link to entity entry/edit page (optional)
);
// ------ merge options with defaults ----------
	if($options != null)
		$opts = array_merge($opts, $options);
	if (!is_array($opts['where']))  $opts['where'] = array($opts['where']);

	$search_box = $opts['search_box']===true ? '_'.$name.'_edit' : $opts['search_box'];
	// select content filtered by search field:
	$search_submit = $opts['search_submit']===true ? '_'.$name.'_button' : $opts['search_submit'];
	// select set by select content field
	$search_button = $opts['editable'] ? '_'.$name.'_button' : ($search_box ? $search_submit : false);

	$select_submit =  $opts['select_submit'];
	$spec_id = $opts['spec_id'];
	$spec_option = $opts['spec_option'];
	if ($opts['type'] == 0) {
		$by_id = true;
		$class = 'combo';
	} elseif($opts['type'] == 1) {
		$by_id = false;
		$class = 'combo2';
	} else {
		$by_id = true;
		$class = 'combo3';
	}

	$disabled = $opts['disabled'] ? "disabled" : '';
	$multi = $opts['multi'];
	
	if(!count($opts['search'])) {
		$opts['search'] = array($by_id ? $valfield : $namefield);
	}
	if ($opts['sel_hint'] === null) 
		$opts['sel_hint'] = $by_id || $search_box==false ?
			'' : _('Press Space tab for search pattern entry');

	if ($opts['box_hint'] === null)
		$opts['box_hint'] = $search_box && $search_submit != false ?
			($by_id ? _('Enter code fragment to search or * for all')
			: _('Enter description fragment to search or * for all')) :'';

	if ($selected_id == null) {
		$selected_id = get_post($name, (string)$opts['default']);
	}
	if(!is_array($selected_id))
		$selected_id = array((string)$selected_id); // code is generalized for multiple selection support

	$txt = get_post($search_box);
	$rel = '';
	$limit = '';
	if (isset($_POST['_'.$name.'_update'])) { // select list or search box change
		if ($by_id) $txt = $_POST[$name];

		if (!$opts['async'])
			$Ajax->activate('_page_body');
		else
			$Ajax->activate($name);
	}
	if (isset($_POST[$search_button])) {
		if (!$opts['async'])
			$Ajax->activate('_page_body');
		else
			$Ajax->activate($name);
	}
	if ($search_box) {
		// search related sql modifications

		$rel = "rel='$search_box'"; // set relation to list
		if ($opts['search_submit']) {
			if (isset($_POST[$search_button])) {
				$selected_id = array(); // ignore selected_id while search
				if (!$opts['async'])
					$Ajax->activate('_page_body');
				else
					$Ajax->activate($name);
			}
			if ($txt == '') {
				if ($spec_option === false && $selected_id == array())
					$limit = ' LIMIT 1';
				else
					$opts['where'][] = $valfield . "=". db_escape(get_post($name, $spec_id));
			}
			else
				if ($txt != '*') {

					foreach($opts['search'] as $i=> $s)
						$opts['search'][$i] = $s . " LIKE "
							.db_escape(($class=='combo3' ? '' : '%').$txt.'%');
					$opts['where'][] = '('. implode($opts['search'], ' OR ') . ')';
				}
		}
	}

	// sql completion
	if (count($opts['where'])) {
		$where = strpos($sql, 'WHERE')==false ? ' WHERE ':' AND ';
		$where .= '('. implode($opts['where'], ' AND ') . ')';
		$group_pos = strpos($sql, 'GROUP BY');
		if ($group_pos) {
			$group = substr($sql, $group_pos);
			$sql = substr($sql, 0, $group_pos) . $where.' '.$group;
		} else {
			$sql .= $where;
		}
	}
	if ($opts['order'] != false) {
		if (!is_array($opts['order']))
			$opts['order'] = array($opts['order']);
		$sql .= ' ORDER BY '.implode(',',$opts['order']);
	}

	$sql .= $limit;
	// ------ make selector ----------
	$selector = $first_opt = '';
	$first_id = false;
	$found = false;
	$lastcat = null;
	$edit = false;
	$pname = false;
	if (($type === "customer" || $type === "supplier") && !empty($SysPrefs->prefs['shortname_name_in_list']))
		$pname = true;
	if($result = db_query($sql)) {
		while ($contact_row = db_fetch($result)) {
			$value = $contact_row[0];
			$descr = $opts['format']==null ?  $contact_row[1] :
				call_user_func($opts['format'], $contact_row, $pname);
			$sel = '';
 		 	if (get_post($search_button) && ($txt == $value)) {
 		 		$selected_id[] = $value;
 		 	}

 		 	if (in_array((string)$value, $selected_id, true)) {
				$sel = 'selected';
				$found = $value;
				$edit = $opts['editable'] && $contact_row['editable'] 
					&& (@$_POST[$search_box] == $value)
					? $contact_row[1] : false; // get non-formatted description
				if ($edit)
					break;	// selected field is editable - abandon list construction
			}
			// show selected option even if inactive 
			if (!$opts['show_inactive'] && @$contact_row['inactive'] && $sel==='') {
				continue;
			} else 
				$optclass = @$contact_row['inactive'] ? "class='inactive'" : '';

			if ($first_id === false) {
				$first_id = $value;
				$first_opt = $descr;
			}
			$cat = $contact_row[$opts['category']];
			if ($opts['category'] !== false && $cat != $lastcat){
				if ($lastcat!==null)
					$selector .= "</optgroup>";
				$selector .= "<optgroup label='".$cat."'>\n";
				$lastcat = $cat;
			}
			$selector .= "<option $sel $optclass value='$value'>$descr</option>\n";
		}
		if ($lastcat!==null)
			$selector .= "</optgroup>";
		db_free_result($result);
	}

	// Prepend special option.
	if ($spec_option !== false) { // if special option used - add it
		$first_id = $spec_id;
		$first_opt = $spec_option;
		$sel = $found===false ? 'selected' : '';
		$optclass = @$contact_row['inactive'] ? "class='inactive'" : '';
		$selector = "<option $sel value='$first_id'>$first_opt</option>\n"
			. $selector;
	}

	if ($found===false) {
		$selected_id = array($first_id);
	}
	
	$_POST[$name] = $multi ? $selected_id : $selected_id[0];

	if ($SysPrefs->use_popup_search)
		$selector = "<select id='$name' autocomplete='off' ".($multi ? "multiple" : '')
		. ($opts['height']!==false ? ' size="'.$opts['height'].'"' : '')
		. "$disabled name='$name".($multi ? '[]':'')."' class='$class form-control mbselect' title='"
		. $opts['sel_hint']."' $rel>".$selector."</select>\n";
	else
		$selector = "<select autocomplete='off' ".($multi ? "multiple" : '')
		. ($opts['height']!==false ? ' size="'.$opts['height'].'"' : '')
		. "$disabled name='$name".($multi ? '[]':'')."' class='$class form-control mbselect' title='"
		. $opts['sel_hint']."' $rel>".$selector."</select>\n";
	if ($by_id && ($search_box != false || $opts['editable']) ) {
		// on first display show selector list
		if (isset($_POST[$search_box]) && $opts['editable'] && $edit) {
			$selector = "<input type='hidden' name='$name' value='".$_POST[$name]."'>"
			."<input type='text' $disabled name='{$name}_text' id='{$name}_text' size='".
				$opts['editable']."' maxlength='".$opts['max']."' $rel value='$edit'>\n";
				set_focus($name.'_text'); // prevent lost focus
		} else if (get_post($search_submit ? $search_submit : "_{$name}_button"))
			set_focus($name); // prevent lost focus
		if (!$opts['editable'])
	 		$txt = $found;
		$Ajax->addUpdate($name, $search_box, $txt ? $txt : '');
	}

	$Ajax->addUpdate($name, "_{$name}_sel", $selector);

	// span for select list/input field update
	$selector = "<span id='_{$name}_sel' class='ar_padding'>".$selector."</span>\n";

	 // if selectable or editable list is used - add select button
	if ($select_submit != false || $search_button) {
	// button class selects form reload/ajax selector update
		$selector .= sprintf(SELECT_BUTTON, $disabled, user_theme(),
			(fallback_mode() ? '' : 'display:none;'),
			 '_'.$name.'_update')."\n";
	}
// ------ make combo ----------
	$edit_entry = '';
	if ($search_box != false) {
		$edit_entry = "<input $disabled type='text' name='$search_box' id='$search_box' size='".
			$opts['size']."' maxlength='".$opts['max'].
			"' value='$txt' class='$class' rel='$name' autocomplete='off' title='"
			.$opts['box_hint']."'"
			.(!fallback_mode() && !$by_id ? " style=display:none;":'')
			.">\n";
		if ($search_submit != false || $opts['editable']) {
			$edit_entry .= sprintf(SEARCH_BUTTON, $disabled, user_theme(),
				(fallback_mode() ? '' : 'display:none;'),
				$search_submit ? $search_submit : "_{$name}_button")."\n";
		}
	}
	default_focus(($search_box && $by_id) ? $search_box : $name);

	$img = "";
	if ($SysPrefs->use_popup_search && (!isset($opts['fixed_asset']) || !$opts['fixed_asset']))
	{
		$img_title = "";
		$link = "";
  		$id = $name;
  		if ($SysPrefs->use_popup_windows) {
    		switch (strtolower($type)) {
      			case "stock":
        			$link = $path_to_root . "/inventory/inquiry/stock_list.php?popup=1&type=all&client_id=" . $id;
        			$img_title = _("Search items");
        			break;
      			case "stock_manufactured":
        			$link = $path_to_root . "/inventory/inquiry/stock_list.php?popup=1&type=manufactured&client_id=" . $id;
        			$img_title = _("Search items");
        			break;
      			case "stock_purchased":
        			$link = $path_to_root . "/inventory/inquiry/stock_list.php?popup=1&type=purchasable&client_id=" . $id;
        			$img_title = _("Search items");
        			break;
      			case "stock_sales":
        			$link = $path_to_root . "/inventory/inquiry/stock_list.php?popup=1&type=sales&client_id=" . $id;
        			$img_title = _("Search items");
        			break;
      			case "stock_costable":
        			$link = $path_to_root . "/inventory/inquiry/stock_list.php?popup=1&type=costable&client_id=" . $id;
        			$img_title = _("Search items");
        			break;
      			case "component":
      				$parent = $opts['parent'];
        			$link = $path_to_root . "/inventory/inquiry/stock_list.php?popup=1&type=component&parent=".$parent."&client_id=" . $id;
        			$img_title = _("Search items");
        			break;
      			case "kits":
        			$link = $path_to_root . "/inventory/inquiry/stock_list.php?popup=1&type=kits&client_id=" . $id;
        			$img_title = _("Search items");
        			break;
      			case "customer":
        			$link = $path_to_root . "/sales/inquiry/customers_list.php?popup=1&client_id=" . $id;
        			$img_title = _("Search Customer");
        			break;
      			case "branch":
        			$link = $path_to_root . "/sales/inquiry/customer_branches_list.php?popup=1&client_id=" . $id . "#customer_id";
        			$img_title = _("Search branches");
        			break;
      			case "supplier":
        			$link = $path_to_root . "/purchasing/inquiry/suppliers_list.php?popup=1&client_id=" . $id;
        			$img_title = _("Search suppliers");
        			break;
      			case "account":
        			$link = $path_to_root . "/gl/inquiry/accounts_list.php?popup=1&client_id=" . $id;
        			$img_title = _("Search GL accounts");
        			break;
    		}
  		}

  		// if ($link !=="") {
    // 		$theme = user_theme();
    // 		$img = '<img src="'.$path_to_root.'/themes/'.$theme.'/images/'.ICON_VIEW.
    // 			'" style="vertical-align:middle;width:12px;height:12px;border:0;" onclick="javascript:lookupWindow(&quot;'.
    // 			$link.'&quot;, &quot;&quot;);" title="' . $img_title . '" style="cursor:pointer;" />';
  		// }
	}

	if ($opts['editlink'])
		$selector .= ' '.$opts['editlink'];

	if ($search_box && $opts['cells'])
		$str = ($edit_entry!='' ? "<td>$edit_entry</td>" : '')."<td>$selector$img</td>";
	else
		$str = $edit_entry.$selector.$img;
	return $str;
}

/*
	Helper function.
	Returns true if selector $name is subject to update.
*/
function list_updated($name)
{
	return isset($_POST['_'.$name.'_update']) || isset($_POST['_'.$name.'_button']);
}
//----------------------------------------------------------------------------------------------
//	Universal array combo generator
//	$items is array of options 'value' => 'description'
//	Options is reduced set of combo_selector options and is merged with defaults.

function array_selector($name, $selected_id, $items, $options=null,$multi_selector=null,$op=null)
{
	global $Ajax;



$opts = array(		// default options
	'spec_option'=>false, 	// option text or false
	'spec_id' => 0,		// option id
	'select_submit' => false, //submit on select: true/false
	'async' => true,	// select update via ajax (true) vs _page_body reload
	'default' => '', // default value when $_POST is not set
	'multi'=>false,	// multiple select
		// search box parameters
	'height' => false,	// number of lines in select box
	'sel_hint' => null,
	'disabled' => false
);
// ------ merge options with defaults ----------
	if($options != null)
		$opts = array_merge($opts, $options);
	$select_submit =  $opts['select_submit'];
	$spec_id = $opts['spec_id'];
	if($op == null)
	$spec_option = $opts['spec_option'];
	else
	$spec_option = $opts['spec_option'].$op;
	$disabled = $opts['disabled'] ? "disabled" : '';
	$multi = $opts['multi'];

	if ($selected_id == null) {
		$selected_id = get_post($name, $opts['default']);
	}
	if(!is_array($selected_id))
		$selected_id = array((string)$selected_id); // code is generalized for multiple selection support

	if (isset($_POST[ '_'.$name.'_update'])) {
		if (!$opts['async'])
			$Ajax->activate('_page_body');
		else
			$Ajax->activate($name);
	}

	// ------ make selector ----------
	$selector = $first_opt = '';
	$first_id = false;
	$found = false;
	foreach($items as $value=>$descr) {
		$sel = '';
		if (in_array((string)$value, $selected_id, true)) {
			$sel = 'selected';
			$found = $value;
		}
		if ($first_id === false) {
			$first_id = $value;
			$first_opt = $descr;
		}
		$selector .= "<option $sel value='$value'>$descr</option>\n";
		
	}



	if ($first_id!==false) {
		$sel = ($found===$first_id) || ($found===false && ($spec_option===false)) ? "selected='selected'" : '';
	}
	// Prepend special option.
	if ($spec_option !== false) { // if special option used - add it
		$first_id = $spec_id;
		$first_opt = $spec_option;
		$sel = $found===false ? 'selected' : '';
		$selector = "<option $sel value='$spec_id'>$spec_option</option>\n"
			. $selector;
	}

	if ($found===false) {
		$selected_id = array($first_id);
	}
	$_POST[$name] = $multi ? $selected_id : $selected_id[0];


	// $selector = "<select autocomplete='off' ".($multi  ? 'multiple="multiple"' : '')
	// 	. ($opts['height']!==false ? ' size="'.$opts['height'].'"' : '')
	// 	. "$disabled name='$name".($multi ? '[]' : '')."' class='combo select2 form-control mbselect' title='"
	// 	. $opts['sel_hint']."'>".$selector."</select>\n";

		// 	$selector = "<select autocomplete='off' ".($multi  ? 'multiple="multiple"' : '')
		// . ($opts['height']!==false ? ' size="'.$opts['height'].'"' : '')
		// . "$disabled name='$name".($multi ? '[]' : '')."' class='combo  form-control mbselect' title='"
		// . $opts['sel_hint']."'>".$selector."</select>\n";

if ($name=="PARAM_1" && $multi_selector == 1) {
	$name1=$name."[]";
			$selector = "<select multiple='multiple' placeholder='Select a filter' name= $name1
			class='combo form-control select222 ' title='Select filter'>".$selector."</select>\n";
	
	

}else if($multi_selector == 2){
    	$name1=$name."[]";
			$selector = "<select multiple='multiple' style='width:100%;' placeholder='Select a filter' name= $name1
			class='combo form-control select222 ' title='Select filter'>".$selector."</select>\n";
}	
else
{
		$selector = "<select autocomplete='off' ".($multi  ? 'multiple="multiple"' : '')
		. ($opts['height']!==false ? ' size="'.$opts['height'].'"' : '')
		. "$disabled name='$name".($multi ? '[]' : '')."' class='combo  form-control mbselect' title='"
		. $opts['sel_hint']."'>".$selector."</select>\n";
}

	$Ajax->addUpdate($name, "_{$name}_sel", $selector);

	$selector = "<span id='_{$name}_sel' class='ar_padding'>".$selector."</span>\n";

	if ($select_submit != false) { // if submit on change is used - add select button
		$selector .= sprintf(SELECT_BUTTON, $disabled, user_theme(),
			(fallback_mode() ? '' : 'display:none;'),
			 '_'.$name.'_update')."\n";
	}
	default_focus($name);

	return $selector;
}
//----------------------------------------------------------------------------------------------
function array_selector_row($label, $name, $selected_id, $items, $options=null)
{
	echo "<tr><td class=''>$label</td>\n<td>";
	echo array_selector($name, $selected_id, $items, $options);
	echo "</td></tr>\n";
}

//----------------------------------------------------------------------------------------------
function _format_add_curr($row, $pname=false)
{
	static $company_currency;

	if ($company_currency == null)
	{
		$company_currency = get_company_currency();
	}
	if (!$pname)
	{
		return $row[1] . ($row[2] == $company_currency ? '' : ("&nbsp;-&nbsp;" . $row[2]));
	}		
	else
	{
		return $row[1] . "&nbsp;-&nbsp;" . $row[2] . ($row[3] == $company_currency ? '' : ("&nbsp;-&nbsp;" . $row[3]));
	}		
}

function add_edit_combo($type)
{
	global $path_to_root, $popup_editors, $SysPrefs;

	if (!isset($SysPrefs->use_icon_for_editkey) || $SysPrefs->use_icon_for_editkey==0)
		return "";
	// Derive theme path
	$theme_path = $path_to_root . '/themes/' . user_theme();

	$key = $popup_editors[$type][1];
	$onclick = "onclick=\"javascript:callEditor($key); return false;\"";
	$img = "<img width='12' height='12' border='0' alt='Add/Edit' title='Add/Edit' src='$theme_path/images/".ICON_EDIT."'>";
	return "<a target = '_blank' href='#' $onclick tabindex='-1'>$img</a>"; 
}

function supplier_list($name, $selected_id=null, $spec_option=false, $submit_on_change=false,
	$all=false, $editkey = false)
{
	global $SysPrefs;
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English
	if (!empty($SysPrefs->prefs['shortname_name_in_list']))
		$sql = "SELECT supplier_id,
		IF(".$dropdown_language."='2',IF(s.supp_ref_arabic = '',s.supp_ref,s.supp_ref_arabic),s.supp_ref ) as supp_ref,
		s.supp_name, s.curr_code, s.inactive FROM ".TB_PREF."suppliers s";
	else		
		$sql = "SELECT supplier_id,
		IF(".$dropdown_language."='2',IF(s.supp_ref_arabic = '',s.supp_ref,s.supp_ref_arabic),s.supp_ref ) as supp_ref,
		s.curr_code, s.inactive FROM ".TB_PREF."suppliers s";


	// if (!empty($SysPrefs->prefs['shortname_name_in_list']))
	// 	$sql = "SELECT supplier_id, supp_ref, supp_name, curr_code, inactive FROM ".TB_PREF."suppliers ";
	// else	
	// 	$sql = "SELECT supplier_id, supp_ref, curr_code, inactive FROM ".TB_PREF."suppliers ";

	$mode = get_company_pref('no_supplier_list');

	if ($editkey)
		set_editor('supplier', $name, $editkey);

	$ret = combo_input($name, $selected_id, $sql, 'supplier_id', 'supp_name',
	array(
		'format' => '_format_add_curr',
	    'order' => array('supp_ref'),
		'search_box' => $mode!=0,
		'type' => 1,
        'search' => array("supp_ref","supp_name","gst_no"),        
		'spec_option' => $spec_option === true ? _("All Suppliers") : $spec_option,
		'spec_id' => ALL_TEXT,
		'select_submit'=> $submit_on_change,
		'async' => false,
		'sel_hint' => $mode ? _('Press Space tab to filter by name fragment') :
		_('Select supplier'),
		'show_inactive'=>$all,
		'editlink' => $editkey ? add_edit_combo('supplier') : false
		), "supplier");
	return $ret;
}

function supplier_list_cells($label, $name, $selected_id=null, $all_option=false, 
	$submit_on_change=false, $all=false, $editkey = false)
{
	if ($label != null)
		echo "<td>$label</td><td>\n";
		echo supplier_list($name, $selected_id, $all_option, $submit_on_change, 
		$all, $editkey);
		echo "</td>\n";
}

function supplier_list_row($label, $name, $selected_id=null, $all_option = false, 
	$submit_on_change=false, $all=false, $editkey = false)
{
	echo "<tr><td class=''>$label</td><td>";
	echo supplier_list($name, $selected_id, $all_option, $submit_on_change,
		$all, $editkey);
	echo "</td></tr>\n";
}
//----------------------------------------------------------------------------------------------

function customer_list($name, $selected_id=null, $spec_option=false, $submit_on_change=false, 
	$show_inactive=false, $editkey = false, $user_id=0)
{
	global $Ajax, $path_to_root, $SysPrefs;


	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English

	if (!empty($SysPrefs->prefs['shortname_name_in_list']))
		$sql = "SELECT debtor_no,
		IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,
		d.name, d.curr_code, d.inactive FROM ".TB_PREF."debtors_master d";
	else		
		$sql = "SELECT debtor_no,
		IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,
		d.curr_code, d.inactive FROM ".TB_PREF."debtors_master d";
	
	if($user_id != 0)
	    $sql .= " WHERE user_id = '$user_id' ";	

	$mode = get_company_pref('no_customer_list');

	if ($editkey)
		set_editor('customer', $name, $editkey);
	$ret = combo_input($name, $selected_id, $sql, 'debtor_no', 'debtor_ref',
	array(
	    'format' => '_format_add_curr',
	    'order' => array('debtor_ref'),
		'search_box' => $mode!=0,
		'type' => 1,
		'size' => 20,
        'search' => array("debtor_ref","name","tax_id"),        
		'spec_option' => $spec_option === true ? _("All Customer's") : $spec_option,
		'spec_id' => ALL_TEXT,
		'select_submit'=> $submit_on_change,
		'async' => false,
		'sel_hint' => $mode ? _('Press Space tab to filter by name fragment; F2 - entry new customer') :
		_('Select customer'),
		'show_inactive' => $show_inactive,
		'editlink' => $editkey ? add_edit_combo('customer') : false
	), "customer" );
	return $ret;
}

function customer_list_cells($label, $name, $selected_id=null, $all_option=false, 
	$submit_on_change=false, $show_inactive=false, $editkey = false, $user_id=0)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td nowrap>";
	echo customer_list($name, $selected_id, $all_option, $submit_on_change,
		$show_inactive, $editkey, $user_id);
	echo "</td>\n";
}

function customer_list_row($label, $name, $selected_id=null, $all_option = false, 
	$submit_on_change=false, $show_inactive=false, $editkey = false)
{

	echo "<tr><td class=''>$label</td><td nowrap>";
	echo customer_list($name, $selected_id, $all_option, $submit_on_change,
		$show_inactive, $editkey);
	echo "</td>\n</tr>\n";
}

//------------------------------------------------------------------------------------------------

function customer_branches_list($customer_id, $name, $selected_id=null,
	$spec_option = true, $enabled=true, $submit_on_change=false, $editkey = false)
{
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English

	$sql = "SELECT branch_code,
	 IF(".$dropdown_language."='2', IF(cb.br_ref_arabic = '',cb.branch_ref,cb.br_ref_arabic),cb.branch_ref ) as branch_ref
		 FROM ".TB_PREF."cust_branch cb
		 WHERE debtor_no=" . db_escape($customer_id)." ";

		// $sql = "SELECT branch_code, branch_ref FROM ".TB_PREF."cust_branch
		// WHERE debtor_no=" . db_escape($customer_id)." ";

	if ($editkey)
		set_editor('branch', $name, $editkey);

	$where = $enabled ? array("inactive = 0") : array();
	$ret = combo_input($name, $selected_id, $sql, 'branch_code', 'branch_ref',
	array(
		'where' => $where,
		'order' => array('branch_ref'),
		'spec_option' => $spec_option === true ? _('All branches') : $spec_option,
		'spec_id' => ALL_TEXT,
		'select_submit'=> $submit_on_change,
		'sel_hint' => _('Select customer branch'),
		'editlink' => $editkey ? add_edit_combo('branch') : false
	), "branch" );
	return $ret;
}
//------------------------------------------------------------------------------------------------

//=========================================Task#2390===========================================

function tech_list($name, $height, $multi=false, $all=false, $spec_opt = false)
{ 
	global $path_to_root;
	include_once($path_to_root . "/sales/includes/db/sales_groups_db.inc");
	$results = get_technicians($all);

	while ($tag = db_fetch($results))
		$tags[$tag['id']] = $tag['name'];
	
	if (!isset($tags)) {
		$tags[''] = $all ? _("No tags defined.") : _("No active tags defined.");
		$spec_opt = false;
	}
	return array_selector($name, null, $tags,
		array(
			'multi' => $multi,
			'height' => $height,
			'spec_option'=> $spec_opt,
			'spec_id' => -1,
		),2 );
}

function tech_list_cells($label, $name, $height, $mult=false, $all=false, $spec_opt = false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo tech_list($name, $height, $mult, $all, $spec_opt);
	echo "</td>\n";
	
}

function tech_list_row($label, $name, $height, $mult=false, $all=false, $spec_opt = false)
{
	echo "<tr><td class=''>$label</td>";
	tech_list_cells(null, $name, $height, $mult, $all, $spec_opt);
	echo "</tr>\n";	
}

//=========================================Task#2390===========================================

function customer_branches_list_cells($label,$customer_id, $name, $selected_id=null, 
	$all_option = true, $enabled=true, $submit_on_change=false, $editkey = false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo customer_branches_list($customer_id, $name, $selected_id, $all_option, $enabled, 
		$submit_on_change, $editkey);
	echo "</td>\n";
}

function customer_branches_list_row($label, $customer_id, $name, $selected_id=null, 
	$all_option = true, $enabled=true, $submit_on_change=false, $editkey = false)
{
	echo "<tr><td class=''>$label</td>";
	customer_branches_list_cells(null, $customer_id, $name, $selected_id, 
		$all_option, $enabled, $submit_on_change, $editkey);
	echo "</tr>";
}

//------------------------------------------------------------------------------------------------

function locations_list($name, $selected_id=null, $all_option=false, $submit_on_change=false, $fixed_asset=false)
{
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English
	// IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,
	// location_name_arabic

	$sql = "SELECT loc.loc_code,
IF(".$dropdown_language."='2',IF(loc.location_name_arabic = '',loc.location_name,loc.location_name_arabic),loc.location_name ) as location_name,
	 loc.inactive FROM ".TB_PREF."locations loc WHERE fixed_asset=".(int)$fixed_asset;

	return combo_input($name, $selected_id, $sql, 'loc_code', 'location_name',
		array(
			'spec_option' => $all_option === true ? _("All Locations") : $all_option,
			'spec_id' => ALL_TEXT,
			'select_submit'=> $submit_on_change
		) );
}

function locations_list_cells($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $fixed_asset=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo locations_list($name, $selected_id, $all_option, $submit_on_change, $fixed_asset);
	echo "</td>\n";
}

function locations_list_row($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $fixed_asset=false)
{
	echo "<tr><td class=''>$label</td>";
	locations_list_cells(null, $name, $selected_id, $all_option, $submit_on_change, $fixed_asset);
	echo "</tr>\n";
}
function report_sent_list_cells($label, $name, $selected_id=null, $submit_on_change=false)
{

    $data = array();
    $data[''] ='Select Setting';
    $data['Daily'] ='Daily';
	$data['Weekly'] ='Weekly';
	$data['Monthly'] ='Monthly';

		

 echo "<td>";

 echo array_selector($name,$selected_id, $data, 
  array( 
   'select_submit'=> $submit_on_change,
   'async' => false ) ); // FIX?
 echo "</td>";

}

function report_list_cells($label, $name, $selected=null)
{
	global $all_items;

	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	$allocs = array( 
		$all_items=>_("All Types"),
		'101-Customer Balance'=> _("101-Customer Balance"),
		'201-Supplier Balance'=> _("201-Supplier Balance"),
		'309-Items Sales Summary Report' => _("309-Items Sales Summary Report"),
		'114-Sales Summary Report' => _("114-Sales Summary Report"),
		'206-Purchase Summary Report' => _("206-Purchase Summary Report"),
		'303-Stock Check Sheets'=>_('303-Stock Check Sheets')
	);
	echo array_selector($name, $selected, $allocs);
	echo "</td>\n";
}

function weekend_list_cells($label, $name, $selected_id=null, $submit_on_change=false)
{

    $data = array();
    $data[''] ='Select Weekend';
    $data['Monday'] ='Monday';
	$data['Tuesday'] ='Tuesday';
	$data['Wednesday'] ='Wednesday';
	$data['Thursday'] ='Thursday';
	$data['Friday'] ='Friday';
	$data['Saturday'] ='Saturday';
	$data['Sunday'] ='Sunday';	

 echo "<td>";

 echo array_selector($name,$selected_id, $data, 
  array( 
   'select_submit'=> $submit_on_change,
   'async' => false ) ); // FIX?
 echo "</td>";

}

// 
function currencies_list($name, $selected_id=null, $submit_on_change=false, $exclude_home_curr=false)
{
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English

	$sql = "SELECT curr.curr_abrev, IF(".$dropdown_language."='2',IF(curr.CurrencyName_arabic = '',curr.currency,curr.CurrencyName_arabic),curr.currency ) as currency, curr.inactive FROM ".TB_PREF."currencies curr";
	if ($exclude_home_curr)
		$sql .= " WHERE curr_abrev!='".get_company_currency()."'";

	// default to the company currency
	return combo_input($name, $selected_id, $sql, 'curr_abrev', 'currency',
		array(
			'select_submit'=> $submit_on_change,
			'default' => get_company_currency(),
			'async' => false
		) );
}

function currencies_list_cells($label, $name, $selected_id=null, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo currencies_list($name, $selected_id, $submit_on_change);
	echo "</td>\n";
}

function currencies_list_row($label, $name, $selected_id=null, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	currencies_list_cells(null, $name, $selected_id, $submit_on_change);
	echo "</tr>\n";
}

//---------------------------------------------------------------------------------------------------

function fiscalyears_list($name, $selected_id=null, $submit_on_change=false)
{

	$sql = "SELECT * FROM ".TB_PREF."fiscal_year";

	// default to the company current fiscal year

	return combo_input($name, $selected_id, $sql, 'id', '',
		array(
			'order' => 'begin',
			'default' => get_company_pref('f_year'),
			'format' => '_format_fiscalyears',
			'select_submit'=> $submit_on_change,
			'async' => false
		) );
}

function _format_fiscalyears($row)
{
	return sql2date($row[1]) . "&nbsp;-&nbsp;" . sql2date($row[2])
	. "&nbsp;&nbsp;" . ($row[3] ? _('Closed') : _('Active'));
}

function fiscalyears_list_cells($label, $name, $selected_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo fiscalyears_list($name, $selected_id);
	echo "</td>\n";
}

function fiscalyears_list_row($label, $name, $selected_id=null)
{
	echo "<tr><td class=''>$label</td>";
	fiscalyears_list_cells(null, $name, $selected_id);
	echo "</tr>\n";
}
/// user for HRM module
function years_list($name, $selected_id=null, $submit_on_change=false, $spec_option=false)
{
	//	$current =null;
if($current == true)
		$sql = "SELECT f.id,f.end FROM ".TB_PREF."fiscal_year f WHERE YEAR(begin) >= ".date('Y')."";
	else
	$sql = "SELECT id,YEAR(end) FROM ".TB_PREF."fiscal_year";

// display_error(get_company_pref('f_year'));

// default to the company current fiscal year

return combo_input($name, $selected_id, $sql, 'id', '',
	array(
		// 'order' => 'begin',
		'default' => get_company_pref('f_year'),
		// 'format' => '_format_years',
		'select_submit'=> $submit_on_change,
		'spec_option' => $spec_option === true ? _("Select Year") : $spec_option,
		'async' => false
	) );
}



// function get_selected_years($year)
// {
// 	$sql = "SELECT * FROM ".TB_PREF."fiscal_year WHERE id = '$year' ";
//         $result = db_query($sql,"no year found");
//         $myrow = db_fetch($result);
// 		return date("Y" , strtotime($myrow['begin']));
// }
function get_selected_years_to_id($year)
{
	$sql = "SELECT * FROM ".TB_PREF."fiscal_year WHERE YEAR(begin) = '$year' ";
        $result = db_query($sql,"no year found");
        $myrow = db_fetch($result);
		// return date("Y" , strtotime($myrow['begin']));
		return $myrow['id'];
}
function years_list_cells($label, $name, $selected_id=null,$submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo years_list($name, $selected_id, $submit_on_change);
	echo "</td>\n";
}

//------------------------------------------------------------------------------------

function dimensions_list($name, $selected_id=null, $no_option=false, $showname=' ',
	$submit_on_change=false, $showclosed=false, $showtype=1,$dimension_id=0, $exclude_from_sales=null)
{
	$sql = "SELECT id, CONCAT(reference,'  ',name) as ref FROM ".TB_PREF."dimensions WHERE 1 ";

	if ($dimension_id != 0) {
		$sql .= " AND id = '$dimension_id'";
	}
	
	if($exclude_from_sales)
		$sql .= " AND exclude_from_sales = 0 ";

	$options = array(
		'order' => 'reference',
		'spec_option'=>$no_option ? "Select Site" : false,
		'spec_id' => 0,
		'select_submit'=> $submit_on_change,
		'async' => false,
	);

	if (!$showclosed)
		$options['where'][] = "closed=0";
	if($showtype)
		$options['where'][] = "type_=".db_escape($showtype);

	return combo_input($name, $selected_id, $sql, 'id', 'ref', $options);
}

function dimensions_list_cells($label, $name, $selected_id=null, $no_option=false, $showname=null,
	$showclosed=false, $showtype=0, $submit_on_change=false,$dimension_id=0, $exclude_from_sales=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo dimensions_list($name, $selected_id, $no_option, $showname, $submit_on_change, $showclosed, $showtype,$dimension_id, $exclude_from_sales);
	echo "</td>\n";
}


function dimensions_list_row($label, $name, $selected_id=null, $no_option=false, $showname=null,
	$showclosed=false, $showtype=0, $submit_on_change=false, $dimension_id=0, $exclude_from_sales=null)
{
	echo "<tr><td class=''>$label</td>";
	dimensions_list_cells(null, $name, $selected_id, $no_option, $showname,
		$showclosed, $showtype, $submit_on_change,$dimension_id, $exclude_from_sales);
	echo "</tr>\n";
}

//---------------------------------------------------------------------------------------------------
function get_factor_list1($name, $selected_id=null, $no_option=false, $showname=' ',$submit_on_change=false, $showclosed=false, $showtype=1)
{
	$sql = "SELECT id,factor FROM ".TB_PREF."factor";

	$options = array(
		'order' => 'id',
		'spec_option'=>$no_option ? "Select Factor" : true,
		'spec_id' => 0,
		'select_submit'=> $submit_on_change,
		'async' => false,
	);
	return combo_input($name, $selected_id, $sql, 'id', 'factor', $options);
}
function get_factor_cell($label, $name, $selected_id=null, $no_option=false, $showname=null,
	$showclosed=false, $showtype=0, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo get_factor_list1($name, $selected_id, $no_option, $showname, $submit_on_change, $showclosed, $showtype);
	echo "</td>\n";
}


//---------------------------------------------------------------------------------------------------

function stock_items_list($name, $selected_id=null, $all_option=false, 
	$submit_on_change=false, $opts=array(), $editkey = false, $type = "stock", $inc_crm = false)
{
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English

	$sql = "SELECT stock_id,
	IF(".$dropdown_language."='2',IF(s.description_arabic = '',s.description,s.description_arabic),s.description ) as description, c.description, s.inactive, s.editable FROM ".TB_PREF."stock_master s,".TB_PREF."stock_category c WHERE s.category_id=c.category_id";

	if (isset($opts['fixed_asset']) && $opts['fixed_asset'])
		$sql .= " AND mb_flag='F'";
	else
		$sql .= " AND mb_flag!='F'";

	if($inc_crm == true)
		$sql .= " AND inc_crm = 1";
	// else
	// 	$sql .= " AND inc_crm = 0";

	if ($editkey)
		set_editor('item', $name, $editkey);

	$ret = combo_input($name, $selected_id, $sql, 'stock_id', 's.description',
		array_merge(
		  array(
			'format' => '_format_stock_items',
			'spec_option' => $all_option===true ?  _("All Items") : $all_option,
			'spec_id' => ALL_TEXT,
			'search_box' => false,
			'search' => array("stock_id", "c.description","s.description"),
			'search_submit' => get_company_pref('no_item_list')!=0 && (!isset($opts['fixed_asset']) || !$opts['fixed_asset']),
			'size'=>10,
			'select_submit'=> $submit_on_change,
			'category' => 2,
			'order' => array('c.description','stock_id'),
			'editlink' => $editkey ? add_edit_combo('item') : false,
			'editable' => false,
			'max' => 255
		  ), $opts), $type );
	return $ret;
}

function _format_stock_items($row)
{
	return (user_show_codes() ?  ($row[0] . "&nbsp;-&nbsp;") : "") . $row[1];
}

function stock_items_list_cells($label, $name, $selected_id=null, $all_option=false, 
	$submit_on_change=false, $all=false, $editkey = false, $opts= array(),$inc_crm=false)
{
	if (isset($opts['fixed_asset']) && $opts['fixed_asset'])
		$editor_item = 'fa_item';
	else
		$editor_item = 'item';

// 	if ($editkey) ??
//		set_editor($editor_item, $name, $editkey);

	if ($label != null)
		echo "<td>$label</td>\n";

// ??
//  $opts = array_merge($options, array('cells'=>true, 'show_inactive'=>$all, 'new_icon' => $editkey ? 'item' : false));
//
//	echo stock_items_list($name, $selected_id, $all_option, $submit_on_change, $opts);

	echo "<td>";
	echo stock_items_list($name, $selected_id, $all_option, $submit_on_change,
		array_merge(array('cells'=>true, 'show_inactive'=>$all), $opts), $editkey , false , $inc_crm );


}

function stock_items_list_row($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $inc_crm=false)
{
	echo "<tr>\n";
	stock_items_list_cells($label, $name, $selected_id, $all_option, $submit_on_change,false,false,$opts= array(),$inc_crm);
	echo "</tr>\n";
}

//---------------------------------------------------------------------------------------------------
function pr_status_material($label, $name, $selected_id=null, $submit_on_change=false)
{
	$status = array(
                       
                           0 => 'Select',       
                           1 => 'Complete',
                           2 =>'Not Complete',
                           3 => 'Transfered');
	echo "<td class=''>$label</td><td>";
	echo array_selector($name, $selected_id, $status,
			array(
					'select_submit'=> $submit_on_change
			) );
	echo "</td>\n";
}


function user_list($name,$selected_id=null,$submit_on_change = false,  $all=false, $spec_opt = false, $user_id=0)
{
	$sql = "SELECT id, user_id, inactive FROM ".TB_PREF."users  ";
   if($user_id != 0)
   	$sql .= " WHERE id = '$user_id' ";


return combo_input($name, $selected_id, $sql, 'id', 'user_id',
	array(
        'spec_option'=> _("Select User"),
		'spec_id' => '',
		'select_submit'=> $submit_on_change,
		'show_inactive' => $show_inactive
	) );
}

function user_list_cells($label, $name,$selected_id,$submit_on_change , $all=false, $spec_opt = false, $user_id=0)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo user_list($name,$selected_id,$submit_on_change, $all, $spec_opt, $user_id);
	echo "</td>\n";
	
}

function user_list_row($label, $name,$selected_id,$submit_on_change, $height, $type, $mult=false, $all=false, $spec_opt = false)
{
	echo "<tr><td class=''>$label</td>";
	user_list_cells(null, $name,$selected_id, $submit_on_change,$height, $type, $mult, $all, $spec_opt);
	echo "</tr>\n";	
}
//---------------------------------------------------------------------------------------------------
//
// Select item via foreign code.
//
function sales_items_list($name, $selected_id=null, $all_option=false, 
	$submit_on_change=false, $type='', $opts=array(), $category_id=0)
{
	// all sales codes
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English

	$sql = "SELECT i.item_code, IF(".$dropdown_language."='2',IF(s.description_arabic = '',s.description,s.description_arabic),s.description ) as description,
		 c.description, count(*)>1 as kit,
			 i.inactive, if(count(*)>1, '0', s.editable) as editable
			FROM
			".TB_PREF."stock_master s,
			".TB_PREF."item_codes i
			LEFT JOIN
			".TB_PREF."stock_category c
			ON i.category_id=c.category_id
			WHERE i.stock_id=s.stock_id
      AND mb_flag != 'F'";

	
	if ($type == 'local')	{ // exclude foreign codes
		$sql .=	" AND !i.is_foreign"; 
	} elseif ($type == 'kits') { // sales kits
		$sql .=	" AND !i.is_foreign AND i.item_code!=i.stock_id";
	}
	$sql .= " AND !i.inactive AND !s.inactive AND !s.no_sale";
	if($category_id != 0)
		$sql .= " AND s.category_id = '$category_id' ";
	$sql .= " GROUP BY i.item_code";

	return combo_input($name, $selected_id, $sql, 'i.item_code', 'c.description',
		array_merge(
		  array(
			'format' => '_format_stock_items',
			'spec_option' => $all_option===true ?  _("All Items") : $all_option,
			'spec_id' => ALL_TEXT,
			'search_box' => false,
			'search' => array("i.item_code", "c.description", "s.description"),
			'search_submit' => get_company_pref('no_item_list')!=0,
			'size'=>15,
			'select_submit'=> $submit_on_change,
			'category' => 2,
			'order' => array('c.description','i.item_code'),
			'editable' => 30,
			'max' => 255
		  ), $opts), $type == 'kits' ? $type : "stock_sales" );
}

function sales_items_list_cells($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $editkey=false)
{
	if ($editkey)
		set_editor('item', $name, $editkey);

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo sales_items_list($name, $selected_id, $all_option, $submit_on_change,
		'', array('cells'=>true));
	echo "</td>";
}

function sales_kits_list_cells($label ,$name, $selected_id=null, $all_option=false, $submit_on_change=false)
{
		if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo sales_kits_list($name, $selected_id, $all_option, $submit_on_change);
	echo "</td>";
}

function sales_kits_list($name, $selected_id=null, $all_option=false, $submit_on_change=false)
{
	return sales_items_list($name, $selected_id, $all_option, $submit_on_change,
		'kits', array('cells'=>false, 'editable' => false));
}

function sales_local_items_list_row($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false)
{
	echo "<tr>";
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";
	echo sales_items_list($name, $selected_id, $all_option, $submit_on_change,
		'local', array('cells'=>false, 'editable' => false));
	echo "</td></tr>";
}
//------------------------------------------------------------------------------------

function stock_manufactured_items_list($name, $selected_id=null,
	$all_option=false, $submit_on_change=false)
{
	return stock_items_list($name, $selected_id, $all_option, $submit_on_change,
		array('where'=>array("mb_flag= 'M'")), false, "stock_manufactured");
}

function stock_manufactured_items_list_cells($label, $name, $selected_id=null,
				$all_option=false, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo stock_manufactured_items_list($name, $selected_id, $all_option, $submit_on_change);
	echo "</td>\n";
}

function stock_manufactured_items_list_row($label, $name, $selected_id=null,
		$all_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	stock_manufactured_items_list_cells(null, $name, $selected_id, $all_option, $submit_on_change);
	echo "</tr>\n";
}
//------------------------------------------------------------------------------------

function stock_component_items_list($name, $parent_stock_id, $selected_id=null,
	$all_option=false, $submit_on_change=false, $editkey = false)
{
	$parent = db_escape($parent_stock_id);
	return stock_items_list($name, $selected_id, $all_option, $submit_on_change,
		array('where'=>array("stock_id != $parent"), 'parent'=> $parent_stock_id), $editkey, "component");
}


function stock_component_items_list_cells($label, $name, $parent_stock_id, 
	$selected_id=null, $all_option=false, $submit_on_change=false, $editkey = false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	$parent = db_escape($parent_stock_id);
	echo "<td>";
	echo stock_items_list($name, $selected_id, $all_option, $submit_on_change,
		array('where'=>array("stock_id != '$parent_stock_id'"), 'cells'=>true, 'parent'=> $parent_stock_id), $editkey, "component");
	echo "</td>";
}
//------------------------------------------------------------------------------------

function stock_costable_items_list($name, $selected_id=null,
	$all_option=false, $submit_on_change=false)
{
	return stock_items_list($name, $selected_id, $all_option, $submit_on_change,
		array('where'=>array("mb_flag!='D'")), false, "stock_costable");
}

function stock_costable_items_list_cells($label, $name, $selected_id=null, 
	$all_option=false, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
		echo "<td>";
	echo stock_items_list($name, $selected_id, $all_option, $submit_on_change,
		array('where'=>array("mb_flag!='D'"), 'cells'=>true), false, "stock_costable");
		echo "</td>";
}

//------------------------------------------------------------------------------------
function stock_purchasable_items_list($name, $selected_id=null,	
	$all_option=false, $submit_on_change=false, $all=false, $editkey=false)
{
	return stock_items_list($name, $selected_id, $all_option, $submit_on_change,
		array('where'=>array("NOT no_purchase"), 
			'show_inactive'=>$all), $editkey, "stock_purchased");
}
//
//	This helper is used in PO/GRN/PI entry and supports editable descriptions.
//
function stock_purchasable_items_list_cells($label, $name, $selected_id=null,
			$all_option=false, $submit_on_change=false, $editkey=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo stock_items_list($name, $selected_id, $all_option, $submit_on_change,
		array('where'=>array("NOT no_purchase"), 
			 'editable' => 30,
			 'cells'=>true), $editkey);
}

//------------------------------------------------------------------------------------

function stock_item_types_list_row($label, $name, $selected_id=null, $enabled=true)
{
	global $stock_types;

	echo "<tr>";
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";

	echo array_selector($name, $selected_id, $stock_types, 
		array( 
			'select_submit'=> true, 
			'disabled' => !$enabled) );
	echo "</td></tr>\n";
}
//-------------------------------------------------------------------------------------

function specification_dropdown_label($name, $selected_id=null, $spec_opt=false, $submit_on_change=false)
{
	// $sql = "SELECT salesman_code, salesman_name, inactive FROM ".TB_PREF."salesman";
	$sql="SELECT id,specification_name from ".TB_PREF."specification where specification_status=1 and inactive=0 and deleted=0";
	// display_error($sql);

	return combo_input($name, $selected_id, $sql, 'id', 'specification_name', 
		array('order'=>array('id'),
			'select_submit'=> $submit_on_change,
			'spec_option' => $spec_opt,
			'spec_id' => ALL_NUMERIC));
}

function specification_dropdown_label_cells($label, $name, $selected_id=null, $spec_opt=false, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo specification_dropdown_label($name, $selected_id, $spec_opt,$submit_on_change);
	echo "</td>\n";
}

function specification_dropdown_label_row($label, $name, $selected_id=null, $spec_opt=false,$submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	specification_dropdown_label_cells(null, $name, $selected_id, $spec_opt,$submit_on_change);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

// function specification_dropdown_label($label, $name, $value=null, $enabled=true,$specification_id=null,$specification_name=null)
// {
// 	$sql="SELECT id,specification_name from ".TB_PREF."specification where specification_status=1 and inactive=0 and deleted=0";
// 	$result=db_query($sql,"");
// 	echo "<tr>";
// 	if ($label != null)
// 		echo "<td class=''>$label</td>\n";
// 	echo "<td>";
// $units[0] = "Select Specification";
// 	while($unit = db_fetch($result))
// 		$units[$unit['id']] = $unit['specification_name'];

// 	echo array_selector($name, $value, $units, array( 'disabled' => !$enabled) );

// 	echo "</td></tr>\n";
// }
function specification_dropdown($label, $name, $value=null, $enabled=true,$specification_id,$specification_name)
{
	$sql="SELECT id,drop_name from ".TB_PREF."specification_detail where specification_id='$specification_id' and specification_status=1 and inactive=0 and deleted=0";
	$result=db_query($sql,"");
	echo "<tr>";
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";
$units[0] = "Select ".$specification_name;
	while($unit = db_fetch($result))
		$units[$unit['id']] = $unit['drop_name'];

	echo array_selector($name, $value, $units, array( 'disabled' => !$enabled) );

	echo "</td></tr>\n";
}








function stock_units_list_row($label, $name, $value=null, $enabled=true)
{
	$result = get_all_item_units();
	echo "<tr>";
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";

	while($unit = db_fetch($result))
		$units[$unit['abbr']] = $unit['name'];

	echo array_selector($name, $value, $units, array( 'disabled' => !$enabled) );

	echo "</td></tr>\n";
}

//------------------------------------------------------------------------------------

function stock_purchasable_fa_list_cells($label, $name, $selected_id=null, $all_option=false,
	$submit_on_change=false, $all=false, $editkey = false, $exclude_items = array())
{
	// Check if a fixed asset has been bought.
	$where_opts[] = "stock_id NOT IN
    	( SELECT stock_id FROM ".TB_PREF."stock_moves WHERE type=".ST_SUPPRECEIVE." AND qty!=0 )";

	// exclude items currently on the order.
  	foreach($exclude_items as $item) {
    	$where_opts[] = "stock_id != ".db_escape($item->stock_id);
  	}
  	$where_opts[] = "mb_flag='F'";

	echo stock_items_list_cells($label, $name, $selected_id, $all_option, $submit_on_change, $all, $editkey, 
    array('fixed_asset' => true, 'where' => $where_opts));
}

function stock_disposable_fa_list($name, $selected_id=null,
	$all_option=false, $submit_on_change=false)
{
	// Check if a fixed asset has been bought....
	$where_opts[] = "stock_id IN
    	( SELECT stock_id FROM ".TB_PREF."stock_moves WHERE type=".ST_SUPPRECEIVE." AND qty!=0 )";
	// ...but has not been disposed or sold already.
  	$where_opts[] = "stock_id NOT IN
		( SELECT stock_id FROM ".TB_PREF."stock_moves WHERE (type=".ST_CUSTDELIVERY." OR type=".ST_INVADJUST.") AND qty!=0 )";

	$where_opts[] = "mb_flag='F'";

	echo stock_items_list($name, $selected_id, $all_option, $submit_on_change,
    array('fixed_asset' => true, 'where' => $where_opts));
}

function stock_disposable_fa_list_cells($label, $name, $selected_id=null,
	$all_option=false, $submit_on_change=false, $exclude_items = array())
{
	// Check if a fixed asset has been bought....
	$where_opts[] = "stock_id IN
    	( SELECT stock_id FROM ".TB_PREF."stock_moves WHERE type=".ST_SUPPRECEIVE." AND qty!=0 )";
	// ...but has not been disposed or sold already.
	$where_opts[] = "stock_id NOT IN
    	( SELECT stock_id FROM ".TB_PREF."stock_moves WHERE (type=".ST_CUSTDELIVERY." OR type=".ST_INVADJUST.") AND qty!=0 )";

	$where_opts[] = "mb_flag='F'";

	foreach($exclude_items as $item) {
    	$where_opts[] = "stock_id != ".db_escape($item->stock_id);
	}

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo stock_items_list($name, $selected_id, $all_option, $submit_on_change, 
    array('fixed_asset' => true, 'cells'=>true, 'where' => $where_opts));
}

function stock_depreciable_fa_list_cells($label, $name, $selected_id=null,
	$all_option=false, $submit_on_change=false)
{

	// Check if a fixed asset has been bought....
	$where_opts[] = "stock_id IN
    	( SELECT stock_id FROM ".TB_PREF."stock_moves WHERE type=".ST_SUPPRECEIVE." AND qty!=0 )";
	// ...but has not been disposed or sold already.
	$where_opts[] = "stock_id NOT IN
    	( SELECT stock_id FROM ".TB_PREF."stock_moves WHERE (type=".ST_CUSTDELIVERY." OR type=".ST_INVADJUST.") AND qty!=0 )";

	$year = get_current_fiscalyear();
	$y = date('Y', strtotime($year['end']));

	// check if current fiscal year
	$where_opts[] = "depreciation_date < '".$y."-12-01'";
	$where_opts[] = "depreciation_date >= '".($y-1)."-12-01'";

	$where_opts[] = "material_cost > 0";
	$where_opts[] = "mb_flag='F'";

	if ($label != null)
		echo "<td>$label</td>\n";
		echo "<td>\n";
    echo stock_items_list($name, $selected_id, $all_option, $submit_on_change,
		 array('fixed_asset' => true, 'where' => $where_opts, 'cells'=>true));
		echo "</td>\n";
}



//------------------------- ITem Specification list cells -----------------------------//

function specification_list($name, $selected_id=null, $all_option=false, 
	$submit_on_change=false, $type='', $opts=array(), $stock_id=null)
{
	// all sales codes
	$sql = "SELECT i.item_code, i.description, c.description, count(*)>1 as kit,
			 i.inactive, if(count(*)>1, '0', s.editable) as editable
			FROM
			".TB_PREF."stock_master s,
			".TB_PREF."item_codes i
			LEFT JOIN
			".TB_PREF."stock_category c
			ON i.category_id=c.category_id
			WHERE i.stock_id=s.stock_id
      AND mb_flag != 'F'";

	
	if ($type == 'local')	{ // exclude foreign codes
		$sql .=	" AND !i.is_foreign"; 
	} elseif ($type == 'kits') { // sales kits
		$sql .=	" AND !i.is_foreign AND i.item_code!=i.stock_id";
	}
	$sql .= " AND !i.inactive AND !s.inactive AND !s.no_sale";
	$sql .= " GROUP BY i.item_code";

	return combo_input($name, $selected_id, $sql, 'i.item_code', 'c.description',
		array_merge(
		  array(
			'format' => '_format_stock_items',
			'spec_option' => $all_option===true ?  _("All Items") : $all_option,
			'spec_id' => ALL_TEXT,
			'search_box' => false,
			'search' => array("i.item_code", "c.description", "i.description"),
			'search_submit' => get_company_pref('no_item_list')!=0,
			'size'=>15,
			'select_submit'=> $submit_on_change,
			'category' => 2,
			'order' => array('c.description','i.item_code'),
			'editable' => 30,
			'max' => 255
		  ), $opts), $type == 'kits' ? $type : "stock_sales" );
}

function specification_list_cells($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $editkey=false, $stock_id=null)
{
	if ($editkey)
		set_editor('item', $name, $editkey);

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo specification_list($name, $selected_id, $all_option, $submit_on_change,
		'', array('cells'=>true), $stock_id);
	echo "</td>";
}
//------------------------- ITem Specification list cells -----------------------------//


//------------------------------------------------------------------------------------

function tax_types_list($name, $selected_id=null, $none_option=false, $submit_on_change=false)
{
	$sql = "SELECT id, CONCAT(name, ' (',rate,'%)') as name FROM ".TB_PREF."tax_types";

	return combo_input($name, $selected_id, $sql, 'id', 'name',
		array(
			'spec_option' => $none_option,
			'spec_id' => ALL_NUMERIC,
			'select_submit'=> $submit_on_change,
			'async' => false,
		) );
}

function tax_types_list_cells($label, $name, $selected_id=null, $none_option=false,
	$submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo tax_types_list($name, $selected_id, $none_option, $submit_on_change);
	echo "</td>\n";
}

function tax_types_list_row($label, $name, $selected_id=null, $none_option=false,
	$submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	tax_types_list_cells(null, $name, $selected_id, $none_option, $submit_on_change);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

function tax_groups_list($name, $selected_id=null,
	$none_option=false, $submit_on_change=false)
{
	$sql = "SELECT id, name FROM ".TB_PREF."tax_groups";

	return combo_input($name, $selected_id, $sql, 'id', 'name',
		array(
			'order' => 'id',
			'spec_option' => $none_option,
			'spec_id' => ALL_NUMERIC,
			'select_submit'=> $submit_on_change,
			'async' => false,
		) );
}

function tax_groups_list_cells($label, $name, $selected_id=null, $none_option=false, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo tax_groups_list($name, $selected_id, $none_option, $submit_on_change);
	echo "</td>\n";
}

function tax_groups_list_row($label, $name, $selected_id=null, $none_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	tax_groups_list_cells(null, $name, $selected_id, $none_option, $submit_on_change);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

function item_tax_types_list($name, $selected_id=null, $show_inactive = false)
{
	$sql ="SELECT id, name FROM ".TB_PREF."item_tax_types";
	if (!$show_inactive)
		$sql .= " WHERE !inactive";

	return combo_input($name, $selected_id, $sql, 'id', 'name', array('order' => 'id') );
}

function item_tax_types_list_cells($label, $name, $selected_id=null, $show_inactive = false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo item_tax_types_list($name, $selected_id, $show_inactive);
	echo "</td>\n";
}

function item_tax_types_list_row($label, $name, $selected_id=null, $show_inactive = false)
{
	echo "<tr><td class=''>$label</td>";
	item_tax_types_list_cells(null, $name, $selected_id, $show_inactive);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

function shippers_list($name, $selected_id=null)
{
	$sql = "SELECT shipper_id, shipper_name, inactive FROM ".TB_PREF."shippers";
	return combo_input($name, $selected_id, $sql, 'shipper_id', 'shipper_name', 
		array('order'=>array('shipper_name')));
}

function shippers_list_cells($label, $name, $selected_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo shippers_list($name, $selected_id);
	echo "</td>\n";
}

function shippers_list_row($label, $name, $selected_id=null)
{
	echo "<tr><td class=''>$label</td>";
	shippers_list_cells(null, $name, $selected_id);
	echo "</tr>\n";
}

//-------------------------------------------------------------------------------------

function sales_persons_list($name, $selected_id=null, $spec_opt=false)
{
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English
	// IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,

	$sql = "SELECT sal.salesman_code, 
	IF(".$dropdown_language."='2',IF(sal.salesman_name_arabic = '',sal.salesman_name,sal.salesman_name_arabic),sal.salesman_name ) as salesman_name, sal.inactive FROM ".TB_PREF."salesman sal";


	return combo_input($name, $selected_id, $sql, 'salesman_code', 'salesman_name', 
		array('order'=>array('salesman_name'),
			'spec_option' => $spec_opt,
			'spec_id' => ALL_NUMERIC));
}

function sales_persons_list_cells($label, $name, $selected_id=null, $spec_opt=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo sales_persons_list($name, $selected_id, $spec_opt);
	echo "</td>\n";
}

function sales_persons_list_row($label, $name, $selected_id=null, $spec_opt=false)
{
	echo "<tr><td class=''>$label</td>";
	sales_persons_list_cells(null, $name, $selected_id, $spec_opt);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

function sales_areas_list($name, $selected_id=null)
{
	$sql = "SELECT area_code, description, inactive FROM ".TB_PREF."areas";
	return combo_input($name, $selected_id, $sql, 'area_code', 'description', array());
}

function sales_areas_list_cells($label, $name, $selected_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo sales_areas_list($name, $selected_id);
	echo "</td>\n";
}

function sales_areas_list_row($label, $name, $selected_id=null)
{
	echo "<tr><td class=''>$label</td>";
	sales_areas_list_cells(null, $name, $selected_id);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

function sales_groups_list($name, $selected_id=null, $special_option=false)
{
	$sql = "SELECT id, description, inactive FROM ".TB_PREF."groups";
	return combo_input($name, $selected_id, $sql, 'id', 'description', array(
		'spec_option' => $special_option===true ? ' ' : $special_option,
		'order' => 'description', 'spec_id' => 0,
	));
}

function sales_groups_list_cells($label, $name, $selected_id=null, $special_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo sales_groups_list($name, $selected_id, $special_option);
	echo "</td>\n";
}

function sales_groups_list_row($label, $name, $selected_id=null, $special_option=false)
{
	echo "<tr><td class=''>$label</td>";
	sales_groups_list_cells(null, $name, $selected_id, $special_option);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

function _format_template_items($row)
{
	return ($row[0] . "&nbsp;- &nbsp;" . _("Amount") . "&nbsp;".$row[1]);
}

function templates_list($name, $selected_id=null, $special_option=false)
{
    $sql = "SELECT sorder.order_no,	Sum((line.unit_price*line.quantity)-line.discount_percent) AS OrderValue
	 	FROM ".TB_PREF."sales_orders as sorder, ".TB_PREF."sales_order_details as line
	 	WHERE sorder.order_no = line.order_no AND sorder.type = 1 GROUP BY line.order_no";
// 	$sql = "SELECT sorder.order_no,	Sum(line.unit_price*line.quantity*(1-line.discount_percent)) AS OrderValue
// 		FROM ".TB_PREF."sales_orders as sorder, ".TB_PREF."sales_order_details as line
// 		WHERE sorder.order_no = line.order_no AND sorder.type = 1 GROUP BY line.order_no";
	return combo_input($name, $selected_id, $sql, 'order_no', 'OrderValue', array(
		'format' => '_format_template_items',
		'spec_option' => $special_option===true ? ' ' : $special_option,
		'order' => 'order_no', 'spec_id' => 0,
	));
}

function templates_list_cells($label, $name, $selected_id=null, $special_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo templates_list($name, $selected_id, $special_option);
	echo "</td>\n";
}

function templates_list_row($label, $name, $selected_id=null, $special_option=false)
{
	echo "<tr><td class=''>$label</td>";
	templates_list_cells(null, $name, $selected_id, $special_option);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

function workorders_list($name, $selected_id=null)
{
	$sql = "SELECT id, wo_ref FROM ".TB_PREF."workorders WHERE closed=0";
	return combo_input($name, $selected_id, $sql, 'id', 'wo_ref', array());
}

function workorders_list_cells($label, $name, $selected_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo workorders_list($name, $selected_id);
	echo "</td>\n";
}

function workorders_list_row($label, $name, $selected_id=null)
{
	echo "<tr><td class=''>$label</td>";
	workorders_list_cells(null, $name, $selected_id);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

function payment_terms_list($name, $selected_id=null)
{
	$sql = "SELECT terms_indicator, terms, inactive FROM ".TB_PREF."payment_terms";
	return combo_input($name, $selected_id, $sql, 'terms_indicator', 'terms', array());
}

function payment_terms_list_cells($label, $name, $selected_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo payment_terms_list($name, $selected_id);
	echo "</td>\n";
}

function payment_terms_list_row($label, $name, $selected_id=null)
{
	echo "<tr><td class=''>$label</td>";
	payment_terms_list_cells(null, $name, $selected_id);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------

function credit_status_list($name, $selected_id=null)
{
	$sql ="SELECT id, reason_description, inactive FROM ".TB_PREF."credit_status";
	return combo_input($name, $selected_id, $sql, 'id', 'reason_description', array());
}

function credit_status_list_cells($label, $name, $selected_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo credit_status_list($name, $selected_id);
	echo "</td>\n";
}

function credit_status_list_row($label, $name, $selected_id=null)
{
	echo "<tr><td class=''>$label</td>";
	credit_status_list_cells(null, $name, $selected_id);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------------------

function sales_types_list($name, $selected_id=null, $submit_on_change=false, $special_option=false)
{
	$sql = "SELECT id, sales_type, inactive FROM ".TB_PREF."sales_types";

	return combo_input($name, $selected_id, $sql, 'id', 'sales_type',
	array(
		'spec_option' => $special_option===true ? _("All Sales Types") : $special_option,
		'spec_id' => 0,
		'select_submit'=> $submit_on_change,
	) );
}

function sales_types_list_cells($label, $name, $selected_id=null, $submit_on_change=false, $special_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo sales_types_list($name, $selected_id, $submit_on_change, $special_option);
	echo "</td>\n";
}

function sales_types_list_row($label, $name, $selected_id=null, $submit_on_change=false, $special_option=false)
{
	echo "<tr><td class=''>$label</td>";
	sales_types_list_cells(null, $name, $selected_id, $submit_on_change, $special_option);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------------------

function _format_date($row)
{
	return sql2date($row['reconciled']);
}

function bank_reconciliation_list($account, $name, $selected_id=null, $submit_on_change=false, $special_option=false)
{
	$sql = "SELECT reconciled, reconciled FROM ".TB_PREF."bank_trans
		WHERE bank_act=".db_escape($account)." AND reconciled IS NOT NULL
		GROUP BY reconciled";
	return combo_input($name, $selected_id, $sql, 'id', 'reconciled',
		array(
			'spec_option' => $special_option,
			'format' => '_format_date',
			'spec_id' => '',
			'select_submit'=> $submit_on_change
		) );
}

function bank_reconciliation_list_cells($label,$account, $name, $selected_id=null, $submit_on_change=false, $special_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo bank_reconciliation_list($account, $name, $selected_id, $submit_on_change, $special_option);
	echo "</td>\n";
}
/*
function bank_reconciliation_list_row($label, $account, $name, $selected_id=null, $submit_on_change=false, $special_option=false)
{
	echo "<tr>\n";
	bank_reconciliation_list_cells($label, $account, $name, $selected_id, $submit_on_change, $special_option);
	echo "</tr>\n";
}
*/
//-----------------------------------------------------------------------------------------------

function workcenter_list($name, $selected_id=null, $all_option=false)
{

	$sql = "SELECT id, name, inactive FROM ".TB_PREF."workcentres";

	return combo_input($name, $selected_id, $sql, 'id', 'name',
		array(
			'spec_option' =>$all_option===true ? _("All Suppliers") : $all_option,
			'spec_id' => ALL_TEXT,
		) );
}

function workcenter_list_cells($label, $name, $selected_id=null, $all_option=false)
{
	default_focus($name);
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo workcenter_list($name, $selected_id, $all_option);
	echo "</td>\n";
}

function workcenter_list_row($label, $name, $selected_id=null, $all_option=false)
{
	echo "<tr><td class=''>$label</td>";
	workcenter_list_cells(null, $name, $selected_id, $all_option);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------------------

function bank_accounts_list($name, $selected_id=null, $submit_on_change=false, $spec_option=false, $pdc_recieve=null, $pdc_issue=null, $onlypdc=false
,$custBankCurr=null, $suppBankCurr=null)
{


	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English
	// IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,
	// bank_account_arabic
$myrow2 = get_company_prefs();
if($pdc_recieve==null)
	$pdc_recieve = $myrow2["debtors_pdc_act"];
if($pdc_issue==null)
	$pdc_issue = $myrow2["creditors_pdc_act"];


$sql = "SELECT ban.id, 
IF(".$dropdown_language."='2',IF(ban.bank_account_arabic = '',ban.bank_name,ban.bank_account_arabic),ban.bank_name ) as bank_account_name,
ban.bank_curr_code, ban.inactive
FROM ".TB_PREF."bank_accounts ban ";
if($onlypdc!=false)
$sql .=" WHERE (ban.account_code =".db_escape($pdc_recieve)." OR ban.account_code =".db_escape($pdc_issue).")  ";
else
$sql .=" WHERE ban.account_code !=".db_escape($pdc_recieve)." AND ban.account_code !=".db_escape($pdc_issue)."  ";
if($custBankCurr!=null)
$sql .=" AND ban.bank_curr_code =".db_escape($custBankCurr)." ";
if($suppBankCurr!=null)
$sql .=" AND ban.bank_curr_code =".db_escape($suppBankCurr)." ";


	return combo_input($name, $selected_id, $sql, 'id', 'bank_account_name',
			array(
			'format' => '_format_add_curr',
			'select_submit'=> $submit_on_change,
			'spec_option' => $spec_option,
			'spec_id' => '',
			'async' => false
			) );
}

function bank_accounts_list_cells($label, $name, $selected_id=null, $submit_on_change=false,$pdc_recieve=null, $pdc_issue=null, $onlypdc=false
	,$custBankCurr=null, $suppBankCurr=null)
{

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo bank_accounts_list($name, $selected_id, $submit_on_change, false,$pdc_recieve, $pdc_issue, $onlypdc, $custBankCurr, $suppBankCurr);
	echo "</td>\n";
}

function bank_accounts_list_row($label, $name, $selected_id=null, $submit_on_change=false, $pdc_recieve=null, $pdc_issue=null, $onlypdc=false,$custBankCurr=null, $suppBankCurr=null)
{
	echo "<tr><td class=''>$label</td>";
	bank_accounts_list_cells(null, $name, $selected_id, $submit_on_change, $pdc_recieve, $pdc_issue, $onlypdc, $custBankCurr, $suppBankCurr);
	echo "</tr>\n";
}
//-----------------------------------------------------------------------------------------------
function bank_accounts_list_all($name, $selected_id=null, $submit_on_change=false, $spec_option=false, $pdc_recieve=null, $pdc_issue=null, $onlypdc=false
,$custBankCurr=null, $suppBankCurr=null)
{


	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English
	// IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,
	// bank_account_arabic
$myrow2 = get_company_prefs();
if($pdc_recieve==null)
	$pdc_recieve = $myrow2["debtors_pdc_act"];
if($pdc_issue==null)
	$pdc_issue = $myrow2["creditors_pdc_act"];


$sql = "SELECT ban.id, 
IF(".$dropdown_language."='2',IF(ban.bank_account_arabic = '',ban.bank_name,ban.bank_account_arabic),ban.bank_name ) as bank_account_name,
ban.bank_curr_code, ban.inactive
FROM ".TB_PREF."bank_accounts ban ";
/*if($onlypdc!=false)
$sql .=" WHERE (ban.account_code =".db_escape($pdc_recieve)." OR ban.account_code =".db_escape($pdc_issue).")  ";
else
$sql .=" WHERE ban.account_code !=".db_escape($pdc_recieve)." AND ban.account_code !=".db_escape($pdc_issue)."  ";*/
if($custBankCurr!=null)
$sql .=" WHERE ban.bank_curr_code =".db_escape($custBankCurr)." ";
if($suppBankCurr!=null)
$sql .=" WHERE ban.bank_curr_code =".db_escape($suppBankCurr)." ";

// display_error($sql);
	return combo_input($name, $selected_id, $sql, 'id', 'bank_account_name',
			array(
			'format' => '_format_add_curr',
			'select_submit'=> $submit_on_change,
			'spec_option' => $spec_option,
			'spec_id' => '',
			'async' => false
			) );
}

function bank_accounts_list_cells_all($label, $name, $selected_id=null, $submit_on_change=false,$pdc_recieve=null, $pdc_issue=null, $onlypdc=false
	,$custBankCurr=null, $suppBankCurr=null)
{

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo bank_accounts_list_all($name, $selected_id, $submit_on_change, false,$pdc_recieve, $pdc_issue, $onlypdc, $custBankCurr, $suppBankCurr);
	echo "</td>\n";
}

function bank_accounts_list_row_all($label, $name, $selected_id=null, $submit_on_change=false, $pdc_recieve=null, $pdc_issue=null, $onlypdc=false,$custBankCurr=null, $suppBankCurr=null)
{
	echo "<tr><td class=''>$label</td>";
	bank_accounts_list_cells_all(null, $name, $selected_id, $submit_on_change, $pdc_recieve, $pdc_issue, $onlypdc, $custBankCurr, $suppBankCurr);
	echo "</tr>\n";
}
//-----------------------------------------------------------------------------------------------

function cash_accounts_list_row($label, $name, $selected_id=null, $submit_on_change=false, $all_option=false)
{

	$sql = "SELECT id, bank_account_name, bank_curr_code, inactive
		FROM ".TB_PREF."bank_accounts
		WHERE account_type=".BT_CASH;

	if ($label != null)
		echo "<tr><td class=''>$label</td>\n";
	echo "<td>";
	echo combo_input($name, $selected_id, $sql, 'id', 'bank_account_name',
		array(
			'spec_option' => $all_option,
			'spec_id' => ALL_TEXT,
			'format' => '_format_add_curr',
			'select_submit'=> $submit_on_change,
			'async' => true
		) );
	echo "</td></tr>\n";
}
//-----------------------------------------------------------------------------------------------

function pos_list_row($label, $name, $selected_id=null, $spec_option=false, $submit_on_change=false)
{
	$sql = "SELECT id, pos_name, inactive FROM ".TB_PREF."sales_pos";

	default_focus($name);
	echo '<tr>';
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";

	echo combo_input($name, $selected_id, $sql, 'id', 'pos_name',
		array(
			'select_submit'=> $submit_on_change,
			'async' => true,
			'spec_option' =>$spec_option,
			'spec_id' => -1,
			'order'=> array('pos_name')
		) );
	echo "</td></tr>\n";

}
//-----------------------------------------------------------------------------------------------
// Payment type selector for current user.
//
function sale_payment_list($name, $category, $selected_id=null, $submit_on_change=true, $prepayments=true)
{
	$sql = "SELECT terms_indicator, terms, inactive FROM ".TB_PREF."payment_terms";

	if ($category == PM_CASH) // only cash
			$sql .= " WHERE days_before_due=0 AND day_in_following_month=0";
	elseif ($category == PM_CREDIT) // only delayed payments
			$sql .= " WHERE days_before_due".($prepayments ? '!=': '>')."0 OR day_in_following_month!=0";
	elseif (!$prepayments)
			$sql .= " WHERE days_before_due>=0";

	return combo_input($name, $selected_id, $sql, 'terms_indicator', 'terms',
		array(
			'select_submit'=> $submit_on_change,
			'async' => true
		) );

}

function sale_payment_list_cells($label, $name, $category, $selected_id=null, $submit_on_change=true, $prepayments=true)
{
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";

	echo sale_payment_list($name, $category, $selected_id, $submit_on_change, $prepayments);

	echo "</td>\n";
}
//-----------------------------------------------------------------------------------------------

function class_list($name, $selected_id=null, $submit_on_change=false)
{
	$sql = "SELECT cid, class_name FROM ".TB_PREF."chart_class";

	return combo_input($name, $selected_id, $sql, 'cid', 'class_name',
		array(
			'select_submit'=> $submit_on_change,
			'async' => false
		) );

}

function class_list_cells($label, $name, $selected_id=null, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo class_list($name, $selected_id, $submit_on_change);
	echo "</td>\n";
}

function class_list_row($label, $name, $selected_id=null, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	class_list_cells(null, $name, $selected_id, $submit_on_change);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------------------
function stock_categories_list($name, $selected_id=null, $spec_opt=false, $submit_on_change=false, $fixed_asset=false)
{
$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English
	$where_opts = array();
	if ($fixed_asset)
		$where_opts[0] = "dflt_mb_flag='F'";
	else
		$where_opts[0] = "dflt_mb_flag!='F'";

	// IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,

	$sql = "SELECT sc.category_id, IF(".$dropdown_language."='2',IF(sc.description_arabic = '',sc.description,sc.description_arabic),sc.description ) as description, sc.inactive FROM ".TB_PREF."stock_category sc ";



	// $sql = "SELECT category_id, description, inactive FROM ".TB_PREF."stock_category";
	return combo_input($name, $selected_id, $sql, 'category_id', 'description',
 		array('order'=>'category_id',
			'spec_option' => $spec_opt,
			'spec_id' => -1,
 			'select_submit'=> $submit_on_change,
 			'async' => true,
			'where' => $where_opts,
 		));
}

function stock_categories_list_cells($label, $name, $selected_id=null, $spec_opt=false, $submit_on_change=false, $fixed_asset=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo stock_categories_list($name, $selected_id, $spec_opt, $submit_on_change, $fixed_asset);
	echo "</td>\n";
}

function stock_categories_list_row($label, $name, $selected_id=null, $spec_opt=false, $submit_on_change=false, $fixed_asset=false)
{
	echo "<tr><td class=''>$label</td>";
	stock_categories_list_cells(null, $name, $selected_id, $spec_opt, $submit_on_change, $fixed_asset);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------------------
function fixed_asset_classes_list($name, $selected_id=null, $spec_opt=false, $submit_on_change=false)
{
	$sql = "SELECT c.fa_class_id, CONCAT(c.fa_class_id,' - ',c.description) `desc`, CONCAT(p.fa_class_id,' - ',p.description) `class`, c.inactive FROM "
		.TB_PREF."stock_fa_class c LEFT JOIN ".TB_PREF."stock_fa_class p ON c.parent_id=p.fa_class_id";

	return combo_input($name, $selected_id, $sql, 'c.fa_class_id', 'desc',
		array('order'=>'c.fa_class_id',
			'spec_option' => $spec_opt,
			'spec_id' => '-1',
 			'select_submit'=> $submit_on_change,
 			'async' => true,
			'search_box' => false,
			'search' => array("c.fa_class_id"),
		    'search_submit' => false,
		    'spec_id' => '',
		    'size' => 3,
		    'max' => 3,
			'category' => 'class',
 		));
}

function fixed_asset_classes_list_row($label, $name, $selected_id=null, $spec_opt=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo "<td>";
	echo fixed_asset_classes_list($name, $selected_id, $spec_opt, $submit_on_change);
	echo "</td></tr>\n";
}

//-----------------------------------------------------------------------------------------------

function gl_account_types_list($name, $selected_id=null, $all_option=false, $all=true)
{
$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English
// IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,

	$sql = "SELECT ct.id, IF(".$dropdown_language."='2',IF(ct.name_arabic = '',ct.name,ct.name_arabic),ct.name ) as name FROM ".TB_PREF."chart_types ct";

	return combo_input($name, $selected_id, $sql, 'id', 'name',
		array(
			'format' => '_format_account',
			'order' => array('class_id', 'id', 'parent'),
			'spec_option' =>$all_option,
			'spec_id' => ALL_TEXT
		) );
}

function gl_account_types_list_cells($label, $name, $selected_id=null, $all_option=false, $all=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo gl_account_types_list($name, $selected_id, $all_option, $all);
	echo "</td>\n";
}

function gl_account_types_list_row($label, $name, $selected_id=null, $all_option=false,	$all=false)
{
	echo "<tr><td class=''>$label</td>";
	gl_account_types_list_cells(null, $name, $selected_id, $all_option,
		$all);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------------------
function gl_all_accounts_list($name, $selected_id=null, $skip_bank_accounts=false,
	$cells=false, $all_option=false, $submit_on_change=false, $all=false, $type_id=false,$not_tax_gl=0)
{
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English
	// IF(".$dropdown_language."='2',IF(chart.account_name_arabic = '',chart.account_name,chart.account_name_arabic),chart.account_name ) as account_name,


          if($not_tax_gl)
          	$sql="SELECT chart.account_code, 
			IF(".$dropdown_language."='2',IF(chart.account_name_arabic = '',chart.account_name,chart.account_name_arabic),chart.account_name ) as account_name,
          chart.account_name, type.name, chart.inactive, type.id FROM ".TB_PREF."chart_master chart,".TB_PREF."chart_types type  WHERE chart.account_code NOT IN (SELECT sales_gl_code FROM ".TB_PREF."tax_types) AND chart.account_code NOT IN (SELECT purchasing_gl_code FROM ".TB_PREF."tax_types) AND  chart.account_type=type.id";

         else
        {

				if ($skip_bank_accounts)
					$sql = "SELECT chart.account_code, IF(".$dropdown_language."='2',IF(chart.account_name_arabic = '',chart.account_name,chart.account_name_arabic),chart.account_name ) as account_name, type.name, chart.inactive, type.id
						FROM (".TB_PREF."chart_master chart,".TB_PREF."chart_types type) "
						."LEFT JOIN ".TB_PREF."bank_accounts acc "
						."ON chart.account_code=acc.account_code
							WHERE acc.account_code  IS NULL
						AND chart.account_type=type.id";
				else
					$sql = "SELECT chart.account_code, IF(".$dropdown_language."='2',IF(chart.account_name_arabic = '',chart.account_name,chart.account_name_arabic),chart.account_name ) as account_name, type.name, chart.inactive, type.id
						FROM ".TB_PREF."chart_master chart,".TB_PREF."chart_types type
						WHERE chart.account_type=type.id";
				if ($type_id ) $sql .= " AND chart.account_type=".db_escape($type_id);

         }
// display_error($sql);
	return combo_input($name, $selected_id, $sql, 'chart.account_code', 'chart.account_name',
		array(
			'format' => '_format_account',
			'spec_option' => $all_option===true ?  _("Use Item Sales Accounts") : $all_option,
			'spec_id' => '',
			'type' => 2,
			'order' => array('type.class_id','type.id','account_code'),
			'search_box' => $cells,
			'search_submit' => false,
			'size' => 12,
			'max' => 10,
			'cells' => true,
			'select_submit'=> $submit_on_change,
			'async' => false,
			'category' => 2,
			'show_inactive' => $all
		), "account" );
}

function _format_account($row)
{
	return $row[0] .  "&nbsp;&nbsp;&nbsp;&nbsp;" . $row[1];
}

function gl_all_accounts_list_cells($label, $name, $selected_id=null, 
	$skip_bank_accounts=false, $cells=false, $all_option=false, 
	$submit_on_change=false, $all=false, $type_id=false,$not_tax_gl=0,$colspan=0)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td colspan=$colspan>";
	echo gl_all_accounts_list($name, $selected_id, 
		$skip_bank_accounts, $cells, $all_option, $submit_on_change, $all, $type_id,$not_tax_gl);
	echo "</td>\n";
}

function gl_all_accounts_list_row($label, $name, $selected_id=null, 
	$skip_bank_accounts=false, $cells=false, $all_option=false, $type_id=false,$not_tax_gl=0)
{
	echo "<tr><td class=''>$label</td>";
	gl_all_accounts_list_cells(null, $name, $selected_id, 
		$skip_bank_accounts, $cells, $all_option, false,false , $type_id,$not_tax_gl);
	echo "</tr>\n";
}

// pk
function group_level_list($name, $selected_id=null, $submit_on_change=false)
{
	$items = array();
	$items['1'] = _("Account Level");
	$items['2'] = _("Group Level");
	$items['3'] = _("Class Level");

	return array_selector($name, $selected_id, $items, 
		array( 
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}

function yesno_list($name, $selected_id=null, $name_yes="", $name_no="", $submit_on_change=false)
{
	$items = array();
	$items['0'] = strlen($name_no) ? $name_no : _("No");
	$items['1'] = strlen($name_yes) ? $name_yes : _("Yes");

	return array_selector($name, $selected_id, $items, 
		array( 
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}

function yesno_list_cells($label, $name, $selected_id=null, $name_yes="", $name_no="", $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo yesno_list($name, $selected_id, $name_yes, $name_no, $submit_on_change);
	echo "</td>\n";
}

function yesno_list_row($label, $name, $selected_id=null, $name_yes="", $name_no="", $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	yesno_list_cells(null, $name, $selected_id, $name_yes, $name_no, $submit_on_change);
	echo "</tr>\n";
}



//------------------------------------------------------------------------------------------------

function languages_list($name, $selected_id=null, $all_option=false)
{
	global $installed_languages;

	$items = array();
	if ($all_option)
		$items[''] = $all_option;
	foreach ($installed_languages as $lang)
			$items[$lang['code']] = $lang['name'];
	return array_selector($name, $selected_id, $items);
}

function languages_list_cells($label, $name, $selected_id=null, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo languages_list($name, $selected_id, $all_option);
	echo "</td>\n";
}

function languages_list_row($label, $name, $selected_id=null, $all_option=false)
{
	echo "<tr><td class=''>$label</td>";
	languages_list_cells(null, $name, $selected_id, $all_option);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------------------

function bank_account_types_list($name, $selected_id=null)
{
	global $bank_account_types;

	return array_selector($name, $selected_id, $bank_account_types);
}

function bank_account_types_list_cells($label, $name, $selected_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo bank_account_types_list($name, $selected_id);
	echo "</td>\n";
}

function bank_account_types_list_row($label, $name, $selected_id=null)
{
	echo "<tr><td class=''>$label</td>";
	bank_account_types_list_cells(null, $name, $selected_id);
	echo "</tr>\n";
}

//pk
function get_forms_name($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false){
	$tabs = array(
	ST_BANKPAYMENT => _("Bank Payment"),
	ST_BANKDEPOSIT => _("Bank Deposit"),
	ST_BANKTRANSFER => _("Funds Transfer"),
	ST_SALESINVOICE => _("Sales Invoice"),
	ST_CUSTCREDIT => _("Customer Credit Note"),
	ST_CUSTPAYMENT => _("Customer Payment"),
	ST_CUSTDELIVERY => _("Delivery Note"),
	ST_LOCTRANSFER => _("Location Transfer"),
	ST_INVADJUST => _("Inventory Adjustment"),
	ST_PURCHORDER => _("Purchase Order"),
	ST_SUPPINVOICE => _("Supplier Invoice"),
	ST_SUPPCREDIT => _("Supplier Credit Note"),
	ST_SUPPAYMENT => _("Supplier Payment"),
	ST_SUPPRECEIVE => _("Purchase Order Delivery"),
	ST_WORKORDER => _("Work Order"),
	ST_MANUISSUE => _("Work Order Issue"),
	ST_MANURECEIVE => _("Work Order Production"),
	ST_SALESORDER => _("Sales Order"),
	ST_SALESQUOTE => _("Sales Quotation")
	);
	echo "<tr>\n";
	echo "<td class=''>$label</td><td>\n";
	echo array_selector($name, $selected_id, $tabs);
	echo "</td></tr>\n";
}

//------------------------------------------------------------------------------------------------
function payment_person_types_list($name, $selected_id=null, $submit_on_change=false)
{
	global $payment_person_types;

	$items = array();
	foreach ($payment_person_types as $key=>$type)
	{
		if ($key != PT_WORKORDER)
			 if($type!=null)
			$items[$key] = $type;
	}		
	return array_selector($name, $selected_id, $items, 
		array( 'select_submit'=> $submit_on_change ) );
}

function payment_person_types_list_cells($label, $name, $selected_id=null, $related=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo payment_person_types_list($name, $selected_id, $related);
	echo "</td>\n";
}

function payment_person_types_list_row($label, $name, $selected_id=null, $related=null)
{
	echo "<tr><td class=''>$label</td>";
	payment_person_types_list_cells(null, $name, $selected_id, $related);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------------------

function wo_types_list($name, $selected_id=null,$all_option=false,$submit=true)
{
	global $wo_types_array;
	$items = array();
	if ($all_option != false) {
		$items[''] = $all_option;
	}
	foreach ($wo_types_array as $key => $value) {
		$items[$key] = $value;
	}
	return array_selector($name, $selected_id, $items, 
		array( 'select_submit'=> $submit, 'async' => true ) );
}

function wo_types_list_row($label, $name, $selected_id=null,$all_option=false)
{
	echo "<tr><td class=''>$label</td><td>\n";
	echo wo_types_list($name, $selected_id,$all_option);
	echo "</td></tr>\n";
}
function wo_types_list_cells($label, $name, $selected_id=null,$all_option=false)
{
	echo "<td class=''>$label</td><td>\n";
	echo wo_types_list($name, $selected_id,$all_option);
	echo "</td>\n";
}
//------------------------------------------------------------------------------------------------

function dateformats_list_row($label, $name, $value=null)
{
	global $SysPrefs;

	echo "<tr><td class=''>$label</td>\n<td>";
	echo array_selector( $name, $value, $SysPrefs->dateformats );
	echo "</td></tr>\n";
}

function dateseps_list_row($label, $name, $value=null)
{
	global $SysPrefs;

	echo "<tr><td class=''>$label</td>\n<td>";
	echo array_selector( $name, $value, $SysPrefs->dateseps );
	echo "</td></tr>\n";
}

function thoseps_list_row($label, $name, $value=null)
{
	global $SysPrefs;

	echo "<tr><td class=''>$label</td>\n<td>";
	echo array_selector( $name, $value, $SysPrefs->thoseps );
	echo "</td></tr>\n";
}

function decseps_list_row($label, $name, $value=null)
{
	global $SysPrefs;

	echo "<tr><td class=''>$label</td>\n<td>";
	echo array_selector( $name, $value, $SysPrefs->decseps );
	echo "</td></tr>\n";
}

function themes_list_row($label, $name, $value=null)
{
	global $path_to_root;

	$path = $path_to_root.'/themes/';
	$themes = array();
	$themedir = opendir($path);
	while(false !== ($fname = readdir($themedir)))
	{
		if($fname!='.' && $fname!='..' && $fname!='CVS' && is_dir($path.$fname))
		{
			$themes[$fname] =  $fname;
		}
	}
	ksort($themes);

	echo "<tr><td class=''>$label</td>\n<td>";
	echo array_selector( $name, $value, $themes );
	echo "</td></tr>\n";
}

function pagesizes_list_row($label, $name, $value=null)
{
	global $SysPrefs;

	$items = array();
	foreach ($SysPrefs->pagesizes as $pz)
		$items[$pz] = $pz;

	echo "<tr><td class=''>$label</td>\n<td>";
	echo array_selector( $name, $value, $items );
	echo "</td></tr>\n";
}

function systypes_list($name, $value=null, $spec_opt=false, $submit_on_change=false, $exclude=array())
{
	global $systypes_array;

	// emove non-voidable transactions if needed
	$systypes = array_diff_key($systypes_array, array_flip($exclude));
	return array_selector($name, $value, $systypes, 
		array( 
			'spec_option'=> $spec_opt,
			'spec_id' => ALL_NUMERIC,
			'select_submit'=> $submit_on_change,
			'async' => false,
			)
	);
}

function systypes_list_cells($label, $name, $value=null, $submit_on_change=false, $exclude=array())
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo systypes_list($name, $value, false, $submit_on_change, $exclude);
	echo "</td>\n";
}

function systypes_list_row($label, $name, $value=null, $submit_on_change=false, $exclude=array())
{
	echo "<tr><td class=''>$label</td>";
	systypes_list_cells(null, $name, $value, $submit_on_change, $exclude);
	echo "</tr>\n";
}

	function journal_types_list_cells($label, $name, $value=null, $submit_on_change=false,$type_array=0, $selected_types=null)
   {
	global $systypes_array;

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";

	// $items = $systypes_array;

		if($type_array==1){

			$items[ST_BANKPAYMENT]= 'Bank Payment';
			$items[ST_BANKTRANSFER]='Fund Transfer';

		}
		elseif ($type_array==2)  //# type 2 is payrol allocation dashboard.
		{
			$items[6]= 'Employee Advance';
			$items[7]='Payroll';


		# code...
		}elseif($selected_types){
			$items = $selected_types;
		}else{
			$items = $systypes_array;

			// exclude quotes, orders and dimensions
			foreach (array(ST_PURCHORDER, ST_SALESORDER, ST_DIMENSION, ST_SALESQUOTE, ST_LOCTRANSFER) as $excl)
			unset($items[$excl]);

		}

	
	echo array_selector($name, $value, $items, 
		array( 
			'spec_option'=> _("All"),
			'spec_id' => -1,
			'select_submit'=> $submit_on_change,
			'async' => false
			)
	);
	echo "</td>\n";
    } 

function cust_allocations_list_cells($label, $name, $selected=null, $submit_on_change=false)
{

	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	$allocs = array( 
		ALL_TEXT=>_("All Types"),
		'1'=> _("Sales Invoices"),
		'2'=> _("Unsettled transactions"),
		'3' => _("Payments"),
		'4' => _("Credit Notes"),
		'5' => _("Delivery Notes")
	);
	echo array_selector($name, $selected, $allocs, array('select_submit'=> $submit_on_change));
	echo "</td>\n";
}

function inv_type_list_cells($label, $name, $selected=null, $submit_on_change=false)
{

	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	$allocs = array( 
		//ALL_TEXT=>_("All Types"),
		'16'=> _("Location Transfer"),
		'17'=> _("Inventory Adjustment")
		
	);
	echo array_selector($name, $selected, $allocs, array('select_submit'=> $submit_on_change));
	echo "</td>\n";
}


function supp_allocations_list_cell($name, $selected=null)
{

	echo "<td>\n";
	$allocs = array( 
		ALL_TEXT=>_("All Types"),
		'1'=> _("Invoices"),
		'2'=> _("Overdue Invoices"),
		'3' => _("Payments"),
		'4' => _("Credit Notes"),
		'5' => _("Overdue Credit Notes")
	);
	echo array_selector($name, $selected, $allocs);
	echo "</td>\n";
}

function supp_transactions_list_cell($name, $selected=null, $submit_on_change=false)
{

	echo "<td>\n";
	$allocs = array( 
		ALL_TEXT=>_("All Types"),
		'6'=>_("GRNs"),
		'1'=> _("Invoices"),
		'2'=> _("Unsettled transactions"),
		'3' => _("Payments"),
		'4' => _("Credit Notes"),
		'5' => _("Overdue Credit Notes")
	);

	echo array_selector($name, $selected, $allocs, array('select_submit'=> $submit_on_change));
	echo "</td>\n";
}

function policy_list_cells($label, $name, $selected=null)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo array_selector($name, $selected, 
				array( '' => _("Automatically put balance on back order"),
			 		'CAN' => _("Cancel any quantites not delivered")) );
	echo "</td>\n";
}

function policy_list_row($label, $name, $selected=null)
{
	echo "<tr><td class=''>$label</td>";
	policy_list_cells(null, $name, $selected);
	echo "</tr>\n";
}

function credit_type_list_cells($label, $name, $selected=null, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo array_selector($name, $selected, 
			array( 'Return' => _("Items Returned to Inventory Location"),
		 		'WriteOff' => _("Items Written Off")),
			array( 'select_submit'=> $submit_on_change ) );
	echo "</td>\n";
}

function credit_type_list_row($label, $name, $selected=null, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	credit_type_list_cells(null, $name, $selected, $submit_on_change);
	echo "</tr>\n";
}

function number_list($name, $selected, $from, $to, $no_option=false,  $submit_on_change=false)
{
	$items = array();
	for ($i = $from; $i <= $to; $i++)
		$items[$i] = "$i";

	return array_selector($name, $selected, $items,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $no_option,
					'spec_id' => ALL_NUMERIC) );
}

function number_list_cells($label, $name, $selected, $from, $to, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo number_list($name, $selected, $from, $to, $no_option, $submit_on_change);
	echo "</td>\n";
}

function number_list_row($label, $name, $selected, $from, $to, $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo number_list_cells(null, $name, $selected, $from, $to, $no_option, $submit_on_change);
	echo "</tr>\n";
}

function print_profiles_list_row($label, $name, $selected_id=null, $spec_opt=false,
	$submit_on_change=false)
{
	$sql = "SELECT profile FROM ".TB_PREF."print_profiles"
		." GROUP BY profile";
	$result = db_query($sql, 'cannot get all profile names');
	$profiles = array();
	while($myrow=db_fetch($result)) {
		$profiles[$myrow['profile']] = $myrow['profile'];
	}

	echo "<tr>";
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";

	echo array_selector($name, $selected_id, $profiles, 
		array( 'select_submit'=> $submit_on_change,
			'spec_option'=>$spec_opt,
			'spec_id' => ''
		 ));

	echo "</td></tr>\n";
}

function printers_list($name, $selected_id=null, $spec_opt=false, $submit_on_change=false)
{
	static $printers; // query only once for page display

	if (!$printers) {
		$sql = "SELECT id, name, description FROM ".TB_PREF."printers";	
		$result = db_query($sql, 'cannot get all printers');
		$printers = array();
		while($myrow=db_fetch($result)) {
			$printers[$myrow['id']] = $myrow['name'].'&nbsp;-&nbsp;'.$myrow['description'];
		}
	}
	return array_selector($name, $selected_id, $printers, 
		array( 'select_submit'=> $submit_on_change,
			'spec_option'=>$spec_opt,
			'spec_id' => ''
		 ));
}

//------------------------------------------------------------------------------------------------

function quick_entries_list($name, $selected_id=null, $type=null, $submit_on_change=false)
{
	$where = false;
	$sql = "SELECT id, description FROM ".TB_PREF."quick_entries";
	if ($type != null)
		$sql .= " WHERE type=$type";

	return combo_input($name, $selected_id, $sql, 'id', 'description',
		array(
			'spec_id' => '',
			'order' => 'description',
			'select_submit'=> $submit_on_change,
			'async' => false
		) );

}

function quick_entries_list_cells($label, $name, $selected_id=null, $type, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";	
	echo quick_entries_list($name, $selected_id, $type, $submit_on_change);
	echo "</td>";
}

function quick_entries_list_row($label, $name, $selected_id=null, $type, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	quick_entries_list_cells(null, $name, $selected_id, $type, $submit_on_change);
	echo "</tr>\n";
}


function quick_actions_list_row($label, $name, $selected_id=null, $submit_on_change=false)
{
	global $quick_actions;
	
	echo "<tr><td class=''>$label</td><td>";
	echo array_selector($name, $selected_id, $quick_actions, 
		array( 
			'select_submit'=> $submit_on_change
		) );
	echo "</td></tr>\n";
}

function quick_entry_types_list_row($label, $name, $selected_id=null, $submit_on_change=false)
{
	global $quick_entry_types;
		
	echo "<tr><td class=''>$label</td><td>";
	echo array_selector($name, $selected_id, $quick_entry_types, 
		array( 
			'select_submit'=> $submit_on_change
			) );
	echo "</td></tr>\n";
}

function record_status_list_row($label, $name) {
	return yesno_list_row($label, $name, null, 	_('Inactive'), _('Active'));
}

function class_types_list_row($label, $name, $selected_id=null, $submit_on_change=false)
{
	global $class_types;
	
	echo "<tr><td class=''>$label</td><td>";
	echo array_selector($name, $selected_id, $class_types, 
		array( 
			'select_submit'=> $submit_on_change
		) );
	echo "</td></tr>\n";
}




//------------------------------------------------------------------------------------------------

function security_roles_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{

	$sql = "SELECT id, role, inactive FROM ".TB_PREF."security_roles";

	return combo_input($name, $selected_id, $sql, 'id', 'description',
		array(
			'spec_option'=>$new_item ? _("New role") : false,
			'spec_id' => '',
			'select_submit'=> $submit_on_change,
			'show_inactive' => $show_inactive
		) );
}

function security_roles_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo security_roles_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</td>\n";
}

function security_roles_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	echo "<tr><td class=''>$label</td>";
	security_roles_list_cells(null, $name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</tr>\n";
}

function tab_list_row($label, $name, $selected_id=null)
{
	global $installed_extensions;
	
	$tabs = array();
	foreach ($_SESSION['App']->applications as $app) {
		$tabs[$app->id] = access_string($app->name, true);
	}
	echo "<tr>\n";
	echo "<td class=''>$label</td><td>\n";
	echo array_selector($name, $selected_id, $tabs);
	echo "</td></tr>\n";
}

//-----------------------------------------------------------------------------------------------

function tag_list($name, $height, $type, $multi=false, $all=false, $spec_opt = false)
{
	// Get tags
	global $path_to_root;
	include_once($path_to_root . "/admin/db/tags_db.inc");
	$results = get_tags($type, $all);

	while ($tag = db_fetch($results))
		$tags[$tag['id']] = $tag['name'];
	
	if (!isset($tags)) {
		$tags[''] = $all ? _("No tags defined.") : _("No active tags defined.");
		$spec_opt = false;
	}
	return array_selector($name, null, $tags,
		array(
			'multi' => $multi,
			'height' => $height,
			'spec_option'=> $spec_opt,
			'spec_id' => -1,
		),2 );
}

function tag_list_cells($label, $name, $height, $type, $mult=false, $all=false, $spec_opt = false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo tag_list($name, $height, $type, $mult, $all, $spec_opt);
	echo "</td>\n";
	
}

function tag_list_row($label, $name, $height, $type, $mult=false, $all=false, $spec_opt = false)
{
	echo "<tr><td class=''>$label</td>";
	tag_list_cells(null, $name, $height, $type, $mult, $all, $spec_opt);
	echo "</tr>\n";	
}

//---------------------------------------------------------------------------------------------
//	List of sets of active extensions 
//
function extset_list($name, $value=null, $submit_on_change=false)
{
	global $db_connections;

	$items = array();
	foreach ($db_connections as $comp)
		$items[] = sprintf(_("Activated for '%s'"), $comp['name']);
	return array_selector( $name, $value, $items,
		array(
			'spec_option'=> _("Available and/or installed"),
			'spec_id' => -1,
			'select_submit'=> $submit_on_change,
			'async' => true
		));
}

function crm_category_types_list($name, $selected_id=null, $filter=array(), $submit_on_change=true)
{

	$sql = "SELECT id, name, type, inactive FROM ".TB_PREF."crm_categories";

	$multi = false;
	$groups = false;
	$where = array();
	if (@$filter['class']) {
		$where[] = 'type='.db_escape($filter['class']);
	} else
		$groups = 'type';
	if (@$filter['subclass']) $where[] = 'action='.db_escape($filter['subclass']);
	if (@$filter['entity']) $where[] = 'entity_id='.db_escape($filter['entity']);
	if (@$filter['multi']) { // contact category selector for person
		$multi = true;
	}

	return combo_input($name, $selected_id, $sql, 'id', 'name',
	 	array(
	 		'multi' => $multi,
	 		'height' => $multi ? 5:1,
			'category' => $groups,
	 		'select_submit'=> $submit_on_change,
 			'async' => true,
 			'where' => $where
	 	));
}

function crm_category_types_list_row($label, $name, $selected_id=null, $filter=array(), $submit_on_change=true)
{
	echo "<tr><td class=''>$label</td><td>";
	echo crm_category_types_list($name, $selected_id, $filter, $submit_on_change);
	echo "</td></tr>\n";
}

function payment_type_list_row($label, $name, $selected_id=null, $submit_on_change=false)
{
	global $pterm_types;
	
	echo "<tr><td class=''>$label</td><td>";
	echo array_selector($name, $selected_id, $pterm_types, 
		array( 
			'select_submit'=> $submit_on_change
		) );
	echo "</td></tr>\n";
}

function coa_list_row($label, $name, $value=null)
{
	global $path_to_root, $installed_extensions;

	$path = $path_to_root.'/sql/';
	$coas = array();
	$sqldir = opendir($path);
	while (false !== ($fname = readdir($sqldir)))
	{
		if (is_file($path.$fname) && substr($fname,-4)=='.sql' && @($fname[2] == '_'))
		{
			$ext = array_search_value($fname, $installed_extensions, 'sql');
			if ($ext!=null) {
				$descr = $ext['name'];
			} elseif ($fname == 'en_US-new.sql') { // two standard COAs
				$descr = _("Standard new company American COA (4 digit)");
			} elseif ($fname == 'en_US-demo.sql') {
				$descr = _("Standard American COA (4 digit) with demo data");
			} else
				$descr = $fname;

			$coas[$fname] =  $descr;
		}
	}
	ksort($coas);

	echo "<tr><td class=''>$label</td>\n<td>";
	echo array_selector( $name, $value, $coas );
	echo "</td></tr>\n";
}

function payment_services($name)
{
	global $payment_services;

	$services = (object)array_combine(array_keys($payment_services), array_keys($payment_services));

	return array_selector($name, null, $services, array(
			'spec_option'=> _("No payment Link"),
			'spec_id' => '',
		));
}

function tax_algorithm_list($name, $value=null, $submit_on_change = false)
{
	global $tax_algorithms;
	
	return array_selector($name, $value, $tax_algorithms, 
		array( 
			'select_submit'=> $submit_on_change,
			'async' => true,
			)
	);
}

function tax_algorithm_list_cells($label, $name, $value=null, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo tax_algorithm_list($name, $value, $submit_on_change);
	echo "</td>\n";
}

function tax_algorithm_list_row($label, $name, $value=null, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	tax_algorithm_list_cells(null, $name, $value, $submit_on_change);
	echo "</tr>\n";
}

function refline_list($name, $type, $value=null, $spec_option=false)
{
	$sql = "SELECT id, prefix, inactive FROM ".TB_PREF."reflines";

	$where = array();

	if (isset($type))
		$where = array('`trans_type`='.db_escape($type));

	return combo_input($name, $value, $sql, 'id', 'prefix',
		array(
			'order'=>array('prefix'),
			'spec_option' => $spec_option,
			'spec_id' => '',
			'type' => 2,
			'where' => $where,
			'select_submit' => true,
			)
		);
}

function refline_list_row($label, $name, $type, $selected_id=null, $spec_option=false)
{
	echo "<tr>";
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";

	echo refline_list($name, $type, $selected_id, $spec_option);
	echo "</td></tr>\n";
}


//----------------------------------------------------------------------------------------------

function subledger_list($name, $account, $selected_id=null, $spec_option=false)
{

	$type = is_subledger_account($account);
	if (!$type)
		return '';

	if($type > 0)
		$sql = "SELECT DISTINCT d.debtor_no as id, debtor_ref as name 
		FROM "
		.TB_PREF."debtors_master d,"
		.TB_PREF."cust_branch c
		WHERE d.debtor_no=c.debtor_no AND c.receivables_account=".db_escape($account);
	else
		$sql = "SELECT supplier_id as id, supp_ref as name 
		FROM "
		.TB_PREF."suppliers s
		WHERE (s.payable_account=".db_escape($account)." OR (
              s.cp_acc1=".db_escape($account)." OR
              s.cp_acc2=".db_escape($account)." OR
              s.cp_acc3=".db_escape($account)." OR
              s.cp_acc4=".db_escape($account)." OR
              s.cp_acc5=".db_escape($account)." OR
              s.cp_acc6=".db_escape($account)." OR
              s.cp_acc7=".db_escape($account)." OR
              s.cp_acc8=".db_escape($account)." OR
              s.cp_acc9=".db_escape($account)." OR
              s.cp_acc10=".db_escape($account)."))";

	$mode = get_company_pref('no_customer_list');

	return combo_input($name, $selected_id, $sql, 'id', 'name',
	array(
		'type' => 1,
		'size' => 20,
		'spec_option' => $spec_option === true ? _("All Counter Party") : $spec_option,
		'spec_id' => 0,
		'async' => false,
	) );
}

function subledger_list_cells($label, $name, $account, $selected_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td nowrap>";
	echo subledger_list($name, $account, $selected_id);
	echo "</td>\n";
}

function subledger_list_row($label, $name, $selected_id=null, $all_option = false, 
	$submit_on_change=false, $show_inactive=false, $editkey = false)
{
	echo "<tr><td class=''>$label</td><td nowrap>";
	echo subledger_list($name, $account, $selected_id);
	echo "</td>\n</tr>\n";
}

function accounts_type_list_row($label, $name, $selected_id=null)
{
	echo "<tr>";
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";
	$sel = array(_("Numeric"), _("Alpha Numeric"), _("ALPHA NUMERIC"));
	echo array_selector($name, $selected_id, $sel); 
	echo "</td></tr>\n";
}

function users_list_cells($label, $name, $selected_id=null, $submit_on_change=false, $spec_opt=true)
{
    $where = false;
    $sql = " SELECT user_id, real_name FROM ".TB_PREF."users";

    if ($label != null)
        echo "<td>$label</td>\n";
    echo "<td>";

    echo combo_input($name, $selected_id, $sql, 'user_id', 'real_name',
        array(
            'spec_option' => $spec_opt===true ?_("All users") : $spec_opt,
            'spec_id' => '',
            'order' => 'real_name',
            'select_submit'=> $submit_on_change,
            'async' => false
        ) );
    echo "</td>";

}

function collations_list_row($label, $name, $selected_id=null)
{
	global $supported_collations;

	echo "<tr>";
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";

	echo array_selector($name, $selected_id, $supported_collations, 
		array('select_submit'=> false) );
	echo "</td></tr>\n";
}


function item_import_list($label, $name, $selected_id=null, $submit_on_change=false)
{
 $items = array();
    $items['1'] ='Item';
	$items['2'] ='Price List';
	$items['3'] ='Purchase Price';
	$items['4'] ='Units of Measure';
	$items['5'] ='Kit';
	$items['6'] ='Bill of Materials';
	$items['7'] ='Foreign Item Codes';

 

 echo "<td class=''>$label</td><td>";

 echo array_selector($name, $selected_id, $items, 
  array( 
   'select_submit'=> $submit_on_change,
   'async' => false ) ); // FIX?
 echo "</td>";

}
//----------------------------------------------------
function report_list($name, $selected_id=null,$label=null,$submit_on_change=false,$op=''){

global $path_to_root;

include_once($path_to_root . "/reporting/includes/reports_classes.inc");
add_js_file('reports.js');

$reports = new BoxReports;

$dim = get_company_pref('use_dimension');

$reports->addReportClass(_('Customer'), RC_CUSTOMER);
$reports->addReport(RC_CUSTOMER, 101, _('Customer Balances '),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Show PDC') => 'YES_NO',
			_('Show Item') => 'YES_NO',
			_('Show Balance') => 'YES_NO',
			_('Currency Filter') => 'CURRENCY',
			_('Suppress Zeros') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_CUSTOMER, 102, _('&Aged Customer Analysis'),
	array(	_('End Date') => 'DATE',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Currency Filter') => 'CURRENCY',
			_('Show Also Allocated') => 'YES_NO',
			_('Summary Only') => 'YES_NO',
			_('Suppress Zeros') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_CUSTOMER, 103, _('Customer Detail Listing'),
	array(	_('Activity Since') => 'DATEBEGIN',
			_('Sales Areas') => 'AREAS',
			_('Sales Folk') => 'SALESMEN',
			_('Activity Greater Than') => 'TEXT',
			_('Activity Less Than') => 'TEXT',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_CUSTOMER, 11011, _('Daily Closing  &Report'),
	array(	
			_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
// 			_("Branch") => 'BRANCH_NO_FILTER',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'
		));//pk
		
$reports->addReport(RC_CUSTOMER, 104, _('&Price Listing'),
	array(	_('Currency Filter') => 'CURRENCY',
			_('Inventory Category') => 'CATEGORIES',
			_('Sales Types') => 'SALESTYPES',
			_('Show Pictures') => 'YES_NO',
			_('Show GP %') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_CUSTOMER, 105, _('&Order Status Listing'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Stock Location') => 'LOCATIONS',
			_('Back Orders Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_CUSTOMER, 106, _('&Salesman Listing'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Summary Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_CUSTOMER, 107, _('Print &Invoices'),
	array(	_('From') => 'INVOICE',
			_('To') => 'INVOICE',
			_('Currency Filter') => 'CURRENCY',
			_('Email Customers') => 'YES_NO',
			_('Payment Link') => 'PAYMENT_LINK',
			_('Comments') => 'TEXTBOX',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Orientation') => 'ORIENTATION'
));
$reports->addReport(RC_CUSTOMER, 113, _('Print &Credit Notes'),
	array(	_('From') => 'CREDIT',
			_('To') => 'CREDIT',
			_('Currency Filter') => 'CURRENCY',
			_('Email Customers') => 'YES_NO',
			_('Payment Link') => 'PAYMENT_LINK',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'));
$reports->addReport(RC_CUSTOMER, 110, _('Print &Deliveries'),
	array(	_('From') => 'DELIVERY',
			_('To') => 'DELIVERY',
			_('Email Customers') => 'YES_NO',
			_('Print as Packing Slip') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'));
$reports->addReport(RC_CUSTOMER, 108, _('Print &Statements'),
	array(	_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Currency Filter') => 'CURRENCY',
			_('Show Also Allocated') => 'YES_NO',
			_('Email Customers') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'));
$reports->addReport(RC_CUSTOMER, 109, _('&Print Sales Orders'),
	array(	_('From') => 'ORDERS',
			_('To') => 'ORDERS',
			_('Currency Filter') => 'CURRENCY',
			_('Email Customers') => 'YES_NO',
			_('Print as Quote') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'));
$reports->addReport(RC_CUSTOMER, 111, _('&Print Sales Quotations'),
	array(	_('From') => 'QUOTATIONS',
			_('To') => 'QUOTATIONS',
			_('Currency Filter') => 'CURRENCY',
			_('Email Customers') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'));
$reports->addReport(RC_CUSTOMER, 112, _('Print Receipts'),
	array(	_('From') => 'RECEIPT',
			_('To') => 'RECEIPT',
			_('Currency Filter') => 'CURRENCY',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'));

$reports->addReportClass(_('Supplier'), RC_SUPPLIER);
$reports->addReport(RC_SUPPLIER, 201, _('Supplier &Balances'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Show PDC') => 'YES_NO',
			_('Show Item') => 'YES_NO',
			_('Show Balance') => 'YES_NO',
			_('Currency Filter') => 'CURRENCY',
			_('Suppress Zeros') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_SUPPLIER, 202, _('&Aged Supplier Analysis'),
	array(	_('End Date') => 'DATE',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Currency Filter') => 'CURRENCY',
			_('Show Also Allocated') => 'YES_NO',
			_('Summary Only') => 'YES_NO',
			_('Suppress Zeros') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
$reports->addReport(RC_SUPPLIER, 206, _('Purchase &Summary Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDTAX',
			_('Tax Id Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));			
$reports->addReport(RC_SUPPLIER, 203, _('&Payment Report'),
	array(	_('End Date') => 'DATE',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Currency Filter') => 'CURRENCY',
			_('Suppress Zeros') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_SUPPLIER, 204, _('Outstanding &GRNs Report'),
	array(	_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_SUPPLIER, 205, _('Supplier &Detail Listing'),
	array(	_('Activity Since') => 'DATEBEGIN',
			_('Activity Greater Than') => 'TEXT',
			_('Activity Less Than') => 'TEXT',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_SUPPLIER, 209, _('Print Purchase &Orders'),
	array(	_('From') => 'PO',
			_('To') => 'PO',
			_('Currency Filter') => 'CURRENCY',
			_('Email Suppliers') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'));
$reports->addReport(RC_SUPPLIER, 210, _('Print Remi&ttances'),
	array(	_('From') => 'REMITTANCE',
			_('To') => 'REMITTANCE',
			_('Currency Filter') => 'CURRENCY',
			_('Email Suppliers') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION'));

$reports->addReportClass(_('Inventory'), RC_INVENTORY);
$reports->addReport(RC_INVENTORY,  301, _('Inventory &Valuation Report'),
	array(	_('End Date') => 'DATE',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Summary Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_INVENTORY,  302, _('Inventory &Planning Report'),
	array(	_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_INVENTORY, 303, _('Stock &Check Sheets'),
	array(	_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Show Pictures') => 'YES_NO',
			_('Inventory Column') => 'YES_NO',
			_('Show Shortage') => 'YES_NO',
			_('Suppress Zeros') => 'YES_NO',
			_('Item Like') => 'TEXT',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_INVENTORY, 304, _('Inventory &Sales Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Customer') => 'CUSTOMERS_NO_FILTER',
			_('Show Service Items') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_INVENTORY, 305, _('&GRN Valuation Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_INVENTORY, 306, _('Inventory P&urchasing Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Items') => 'ITEMS_P',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
// pk
$reports->addReport(RC_INVENTORY, 3066, _('Inventory P&urchasing Summary Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Supplier') => 'SUPPLIERS_NO_FILTER',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Items') => 'ITEMS_P',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
$reports->addReport(RC_INVENTORY,"9000",_('Inventory History'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Summary Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_INVENTORY, 307, _('Inventory &Movement Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));				
$reports->addReport(RC_INVENTORY, 308, _('C&osted Inventory Movement Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Location') => 'LOCATIONS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));				
$reports->addReport(RC_INVENTORY, 309,_('Item &Sales Summary Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Inventory Category') => 'CATEGORIES',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));				
if (get_company_pref('use_manufacturing'))
{
	$reports->addReportClass(_('Manufacturing'), RC_MANUFACTURE);
	$reports->addReport(RC_MANUFACTURE, 401, _('&Bill of Material Listing'),
		array(	_('From product') => 'ITEMS',
				_('To product') => 'ITEMS',
				_('Comments') => 'TEXTBOX',
				_('Orientation') => 'ORIENTATION',
				_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_MANUFACTURE, 402, _('Work Order &Listing'),
		array(	_('Items') => 'ITEMS_ALL',
				_('Location') => 'LOCATIONS',
				_('Outstanding Only') => 'YES_NO',
				_('Comments') => 'TEXTBOX',
				_('Orientation') => 'ORIENTATION',
				_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_MANUFACTURE, 409, _('Print &Work Orders'),
		array(	_('From') => 'WORKORDER',
				_('To') => 'WORKORDER',
				_('Email Locations') => 'YES_NO',
				_('Comments') => 'TEXTBOX',
				_('Orientation') => 'ORIENTATION'));
}
if (get_company_pref('use_fixed_assets'))
{
	$reports->addReportClass(_('Fixed Assets'), RC_FIXEDASSETS);
	$reports->addReport(RC_FIXEDASSETS, 451, _('&Fixed Assets Valuation'),
		array(	_('End Date') => 'DATE',
				_('Fixed Assets Class') => 'FCLASS',
				_('Fixed Assets Location') => 'FLOCATIONS',
				_('Summary Only') => 'YES_NO',
				_('Comments') => 'TEXTBOX',
				_('Orientation') => 'ORIENTATION',
				_('Destination') => 'DESTINATION'));
}				
$reports->addReportClass(_('Dimensions'), RC_DIMENSIONS);
if ($dim > 0)
{
	$reports->addReport(RC_DIMENSIONS, 501, _('Dimension &Summary'),
	array(	_('From Dimension') => 'DIMENSION',
			_('To Dimension') => 'DIMENSION',
			_('Show Balance') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'), 'SA_DIMENSIONREP');
}
$reports->addReportClass(_('Banking'), RC_BANKING);
	$reports->addReport(RC_BANKING,  601, _('Bank &Statement'),
	array(	_('Bank Accounts') => 'BANK_ACCOUNTS',
			_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Zero values') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));

$reports->addReport(RC_BANKING,  6011, _('PDC Cheque'),
		array(	_('Bank Accounts') => 'BANK_ACCOUNTS_ONLY_PDC',
		_('Start Date') => 'DATEBEGINM',
		_('End Date') => 'DATEENDM',
		_('Cleared/Uncleared Cheque') => 'CLEARED_UNCLEARED',
		_('Comments') => 'TEXTBOX',
		_('Orientation') => 'ORIENTATION',
		_('Destination') => 'DESTINATION'));

	$reports->addReport(RC_BANKING,  602, _('Bank Statement w/ &Reconcile'),
	array(	_('Bank Accounts') => 'BANK_ACCOUNTS',
			_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Comments') => 'TEXTBOX',
			_('Destination') => 'DESTINATION'));
			
	$reports->addReport(RC_BANKING,"_cash_flow_statement", 
	_('Cash Flow Statement'),
    array(	_('Report Period') => 'DATEENDM',
        	_('Comments') => 'TEXTBOX',
            _('Destination') => 'DESTINATION'));
    
    $reports->addReport(RC_BANKING, 605, _('Cash Flow Statement (Imrpoved)'),
    array(  _('Report Period') => 'DATEENDM',
        	_('Comments') => 'TEXTBOX',
            _('Destination') => 'DESTINATION'));

$reports->addReportClass(_('General Ledger'), RC_GL);
$reports->addReport(RC_GL, 701, _('Chart of &Accounts'),
	array(	_('Show Balances') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_GL, 702, _('List of &Journal Entries'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Type') => 'SYS_TYPES',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));

if ($dim == 2)
{
	$reports->addReport(RC_GL, 704, _('GL Account &Transactions'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('From Account') => 'GL_ACCOUNTS',
			_('To Account') => 'GL_ACCOUNTS',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_GL, 705, _('Annual &Expense Breakdown'),
	array(	_('Year') => 'TRANS_YEARS',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_GL, 713, _('Annual &Expense Breakdown New'),
	array(  _("From Month") => 'STARTMONTHLIST',
			_("From Year") => 'FROM_YEAR',
			_("To Month") => 'STARTMONTHLIST',
			_("TO Year") => 'FROM_YEAR',
			// _('Year') => 'TRANS_YEARS',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));	
	$reports->addReport(RC_GL, 706, _('&Balance Sheet'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Dimension')." 1" => 'DIMENSIONS1',
			_('Dimension')." 2" => 'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	
	$reports->addReport(RC_GL, 717, _('&Balance Sheet By Group Level'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Group Level') => 'GROUP_LEVEL',  // 1 -> account, 2 -> group, 3 -> class;
			_('Dimension')." 1" => 'DIMENSIONS1',
			_('Dimension')." 2" => 'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
	$reports->addReport(RC_GL, 707, _('&Profit and Loss Statement'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Compare to') => 'COMPARE',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	
	$reports->addReport(RC_GL, 716, _('&Profit and Loss Statement By Group Level'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Group Level') => 'GROUP_LEVEL',  // 1 -> account, 2 -> group, 3 -> class;
			_('Compare to') => 'COMPARE',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
	$reports->addReport(RC_GL, 714, _('&Profit and Loss Statement New'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Compare to') => 'COMPARE',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_GL, 708, _('Trial &Balance'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Zero values') => 'YES_NO',
			_('Only balances') => 'YES_NO',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
	$reports->addReport(RC_GL, 715, _('Trial &Balance By Group Level'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Group Level') => 'GROUP_LEVEL',  // 1 -> account, 2 -> group, 3 -> class;
			_('Zero values') => 'YES_NO',
			_('Only balances') => 'YES_NO',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Dimension')." 2" =>  'DIMENSIONS2',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));		
}
elseif ($dim == 1)
{
	$reports->addReport(RC_GL, 704, _('GL Account &Transactions'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('From Account') => 'GL_ACCOUNTS',
			_('To Account') => 'GL_ACCOUNTS',
			_('Dimension') =>  'DIMENSIONS1',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_GL, 705, _('Annual &Expense Breakdown'),
	array(	_('Year') => 'TRANS_YEARS',
			_('Dimension') =>  'DIMENSIONS1',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
			
	
	$reports->addReport(RC_GL, 713, _('Annual &Expense Breakdown New'),
	array(  _("From Month") => 'STARTMONTHLIST',
			_("From Year") => 'FROM_YEAR',
			_("To Month") => 'STARTMONTHLIST',
			_("TO Year") => 'FROM_YEAR',
			// _('Year') => 'TRANS_YEARS',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));		
	$reports->addReport(RC_GL, 706, _('&Balance Sheet'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Dimension') => 'DIMENSIONS1',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
	$reports->addReport(RC_GL, 717, _('&Balance Sheet By Group Level'),
    	array(	_('Start Date') => 'DATEBEGIN',
    			_('End Date') => 'DATEENDM',
    			_('Group Level') => 'GROUP_LEVEL',  // 1 -> account, 2 -> group, 3 -> class;
    			_('Dimension') => 'DIMENSIONS1',
    			_('Account Tags') =>  'ACCOUNTTAGS',
    			_('Decimal values') => 'YES_NO',
    			_('Graphics') => 'GRAPHIC',
    			_('Comments') => 'TEXTBOX',
    			_('Orientation') => 'ORIENTATION',
    			_('Destination') => 'DESTINATION'));
			
	$reports->addReport(RC_GL, 707, _('&Profit and Loss Statement'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Compare to') => 'COMPARE',
			_('Dimension') => 'DIMENSIONS1',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
		
	$reports->addReport(RC_GL, 716, _('&Profit and Loss Statement By Group Level'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Group Level') => 'GROUP_LEVEL',  // 1 -> account, 2 -> group, 3 -> class;
			_('Compare to') => 'COMPARE',
			_('Dimension') => 'DIMENSIONS1',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
	$reports->addReport(RC_GL, 714, _('&Profit and Loss Statement New'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Compare to') => 'COMPARE',
			_('Dimension')." 1" =>  'DIMENSIONS1',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_GL, 708, _('Trial &Balance'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Zero values') => 'YES_NO',
			_('Only balances') => 'YES_NO',
			_('Dimension') => 'DIMENSIONS1',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	
	$reports->addReport(RC_GL, 715, _('Trial &Balance By Group Level'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Group Level') => 'GROUP_LEVEL',  // 1 -> account, 2 -> group, 3 -> class;
			_('Zero values') => 'YES_NO',
			_('Only balances') => 'YES_NO',
			_('Dimension') => 'DIMENSIONS1',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));		
}
else
{
	$reports->addReport(RC_GL, 704, _('GL Account &Transactions'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('From Account') => 'GL_ACCOUNTS',
			_('To Account') => 'GL_ACCOUNTS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_GL, 705, _('Annual &Expense Breakdown'),
	array(	_('Year') => 'TRANS_YEARS',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_GL, 713, _('Annual &Expense Breakdown New'),
	array(  _("From Month") => 'STARTMONTHLIST',
			_("From Year") => 'FROM_YEAR',
			_("To Month") => 'STARTMONTHLIST',
			_("TO Year") => 'FROM_YEAR',
			// _('Year') => 'TRANS_YEARS',
			
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));		
	$reports->addReport(RC_GL, 706, _('&Balance Sheet'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
	$reports->addReport(RC_GL, 717, _('&Balance Sheet By Group Level'),
	array(	_('Start Date') => 'DATEBEGIN',
			_('End Date') => 'DATEENDM',
			_('Group Level') => 'GROUP_LEVEL',  // 1 -> account, 2 -> group, 3 -> class;
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));		
	$reports->addReport(RC_GL, 707, _('&Profit and Loss Statement'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Compare to') => 'COMPARE',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	
	$reports->addReport(RC_GL, 716, _('&Profit and Loss Statement By Group Level'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Group Level') => 'GROUP_LEVEL',  // 1 -> account, 2 -> group, 3 -> class;
			_('Compare to') => 'COMPARE',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
	$reports->addReport(RC_GL, 714, _('&Profit and Loss Statement New'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Compare to') => 'COMPARE',
			_('Account Tags') =>  'ACCOUNTTAGS',
			_('Decimal values') => 'YES_NO',
			_('Graphics') => 'GRAPHIC',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	$reports->addReport(RC_GL, 708, _('Trial &Balance'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Zero values') => 'YES_NO',
			_('Only balances') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
	
	$reports->addReport(RC_GL, 715, _('Trial &Balance By Group Level'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Group Level') => 'GROUP_LEVEL',  // 1 -> account, 2 -> group, 3 -> class;
			_('Zero values') => 'YES_NO',
			_('Only balances') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));		
}
$reports->addReport(RC_GL, 709, _('Ta&x Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDTAX',
			_('Summary Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(RC_GL, 710, _('Audit Trail'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Type') => 'SYS_TYPES_ALL',
			_('User') => 'USERS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
// $reports->addReport(RC_GL, 1000, _('&Access Level'),
// 	array(
// // 	    _('Currency Filter') => 'CURRENCY',
// // 			_('Inventory Category') => 'CATEGORIES',
// // 			_('Sales Types') => 'SALESTYPES',
// // 			_('Show Pictures') => 'YES_NO',
// // 			_('Show GP %') => 'YES_NO',
// 			_('Security Roles') => 'SECURITYROLE',
// 			_('Active/Inactive')=> 'ACTIVE/INACTIVE',
// 			_('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION')
// 			);


$reports->addReport(RC_GL, 711, _('Void Transaction'),
	array(	_('Type') => 'SYS_TYPES_ALL',
			_('From #') => 'TEXT',
			_('To #') => 'TEXT',
	        _('FromDate') => 'DATEBEGIN',
			_('ToDate') => 'DATEEND',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));

$reports->addReport(SYS_REP, 1001, _('Users Listing'),
	array(
			_('Dimension 2') => 'DIMENSIONS2',
			_('Dimension 1') => 'DIMENSIONS1',
			_('User Login')=> 'USERS',
			_('Access Level') => 'SECURITYROLE2')
			);

// $reports->addReport(SYS_REP, 1000, _('System Rep'),
// 	array(	_('Type') => 'SYS_TYPES_ALL',
// 			_('From #') => 'TEXT',
// 			_('To #') => 'TEXT',
// 	        _('FromDate') => 'DATEBEGIN',
// 			_('ToDate') => 'DATEEND',
// 			_('Comments') => 'TEXTBOX',
// 			_('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION'));



//$reports->addReportClass(_('Payroll'), RC_PR_REP);




// $reports->addReport(RC_PR_REP, 802, _('List Of Employee'),
	
// array(	                _('Department') => 'DEPT',
// 			_('Fields Filter') =>'EMPLYMASTERLIST',
// 			_('Employee') => 'EMPLYLIST',
// 			_('Nationality') =>'NATIONAL',
// 			_('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION'));


// $reports->addReport(RC_PR_REP, 820, _('Expiry Reports'),
// array(
// 			_('Fields Filter') =>'EXPIRYREPORTSLIST',
//    	        _('Start Date') => 'DATEBEGIN',
// 			_('End Date') => 'DATEEND',
//             _('Department') => 'DEPT',
//             _('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION'));

/////////////////////////////////////////////////////////////////////////
// $reports->addReport(RC_PR_REP, 801, _('Time Sheet'),
	
// array(	  _('Employee') => 'EMPLYLIST',
// 			_('Month List') => 'MONTHLIST',
// 			_('Salary Year') => 'YEAR',
// 			_('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION'));
///////////////////////////////////////////////////////////////////////
// $reports->addReport(RC_PR_REP, 8011, _('Time Sheet Dimension Wise'),
	
// array(	  _('Employee') => 'EMPLYLIST',
// 			_('Project') => 'PROJECTLIST',
// 			_('Month List') => 'MONTHLIST',
// 			_('Salary Year') => 'YEAR',
// 			_('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION'));

//-----------------------------today work------------------------------------------//
// $reports->addReport(RC_PR_REP, 806, _(' Leave Management Report'),
	
// 	array(  _('Employee') => 'EMPLYLIST',
// 			_('Department') => 'DEPT',
// 			_('Start Date') => 'DATEBEGIN',
// 			_('End Date') => 'DATEEND',
// 			_('Status') => 'STATUS',
// 			_('Leave Type') => 'LEAVETYPE',
// 			_('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION'));
////////////////////////////////////////////////////////////////////////////////
// $reports->addReport(RC_PR_REP, 814, _('Leave History Report'),
	
// array( _('Employee') => 'EMPLYLIST',
//   _('Start Date') => 'DATEBEGIN',
// 			_('End Date') => 'DATEEND',
// 			_('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION'));
///////////////////////////////////////////////////////////////////////
// $reports->addReport(RC_PR_REP, 807, _('Audit Trail Payroll'),
// 	array(	_('Start Date') => 'DATEBEGINM',
// 			_('End Date') => 'DATEENDM',
// 			// _('Type') => 'SYS_TYPES_PR',
// 			_('Type') => 'SYS_TYPES_ALL',
// 			_('User') => 'USERS',
// 			_('Comments') => 'TEXTBOX',
// 			_('Orientation') => 'ORIENTATION',
// 			_('Destination') => 'DESTINATION'));
///////////////////////////////////////////////////////////////
// $reports->addReport(RC_PR_REP, 813, _('Salary Report'),
	
// array(
// _('Department') => 'DEPT',
// _('Employee') => 'EMPLYLIST',
// _('Status') => 'SALARYSTATUS',
// _('Month List') => 'MONTHLIST',
// _('Salary Year') => 'YEAR',
// _('Orientation') => 'ORIENTATION',
// _('Destination') => 'DESTINATION'));
/////////////////////////////////////////////////////////////////
$reports->addReport(RC_PR_REP, 815, _('WPS Report'),
	
array( _('Select Month & Payment') => 'SELECT_PAYMENT',
			_('Salary Year') => 'YEAR',

			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
//////////////////////////////////////////////////////////
       #  VAT Return Report :
       # Custamize By Abdus sami:
//////////////////////////////////////////////////////////
$reports->addReportClass(_('VAT Report'), FTA_VAT);
$reports->addReport(FTA_VAT, 901, _('VAT Return 201'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
		//	_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));

$reports->addReport(FTA_VAT, 902, _('FAF Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
		//	_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));

$reports->addReport(FTA_VAT, 904, _('Excise Tax Return Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
		//	_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
$reports->addReport(FTA_VAT, 905, _('FTA Excise Tax Audit File (FAF) Report'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
		//	_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
$reports->addReportClass(_('Sale'), RC_SALES);
$reports->addReport(RC_SALES, 114, _('Sales &Summary Report'),
	array(	_('Start Date') => 'DATEBEGINTAX',
			_('End Date') => 'DATEENDTAX',
			_('Tax Id Only') => 'YES_NO',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));

$reports->addReport(RC_SALES, 116, _('Sales By Customer'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Comparison') => 'COMPARISION',
			_('Summary') => 'YES_NO',
			_('Zero values') => 'YES_NO',			
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));

$reports->addReport(RC_SALES, 117, _('Sales By &Item'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Comparison') => 'COMPARISION',
			_('Summary') => 'YES_NO',
			_('Zero values') => 'YES_NO',			
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));
			
$reports->addReport(RC_SALES, 118, _('Open Sales Invoices'),
	array(	_('Customer') => 'CUSTOMERS_NO_FILTER',
			//_('Items') => 'ITEMS_P',
			_('Show Item') => 'YES_NO',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));	
$reports->addReport(SYS_REP, 1000, _('&Access Level'),
	array(
// 	    _('Currency Filter') => 'CURRENCY',
// 			_('Inventory Category') => 'CATEGORIES',
// 			_('Sales Types') => 'SALESTYPES',
// 			_('Show Pictures') => 'YES_NO',
// 			_('Show GP %') => 'YES_NO',
			_('Security Roles') => 'SECURITYROLE',
			_('Active/Inactive')=> 'ACTIVE/INACTIVE',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION')
			);		


$reports->addReport(SYS_REP, 1010, _('Audit Trail'),
	array(	_('Start Date') => 'DATEBEGINM',
			_('End Date') => 'DATEENDM',
			_('Type') => 'SYS_TYPES_ALL',
			_('User') => 'USERS',
			_('Comments') => 'TEXTBOX',
			_('Orientation') => 'ORIENTATION',
			_('Destination') => 'DESTINATION'));

// $reports->addReport(SYS_REP, 1001, _('Users Listing'),
// 	array(
// 			_(get_dimension_label(2)) => 'DIMENSIONS2',
// 			_(get_dimension_label(1)) => 'DIMENSIONS1',
// 			_('User Login')=> 'USERS',
// 			_('Access Level') => 'SECURITYROLE2'));
//////////////////////////////////////////////////////////

add_custom_reports($reports);

echo $reports->report_list_row($name,$selected_id,$label,$submit_on_change,$op);


}



//----------------------------------------------------



//-----------------------------------------------------------------------------------------
function spec_list($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $stock_id=null, $spec_detail_id=null)
{

//Conignmnt selected then color and spec should be auto
		$sql= "SELECT ".TB_PREF."item_specification.specification_detail_id, ".TB_PREF."specification_detail.drop_name 
		FROM ".TB_PREF."item_specification, ".TB_PREF."specification_detail 
		WHERE ".TB_PREF."item_specification.specification_detail_id = ".TB_PREF."specification_detail.id 
		AND ".TB_PREF."item_specification.stock_id= ".db_escape($stock_id)."
		AND ".TB_PREF."item_specification.specification_detail_id= ".db_escape($spec_detail_id)."

		";

     	return combo_input($name, $selected_id, $sql, 'g.id','g.spec',
		array(
			'spec_option' => $all_option === true ? _("All spec") : $all_option,
			'spec_id' => ALL_TEXT,
			'select_submit'=> $submit_on_change

		) );



}

function spec_list_cells($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $stock_id=null, $spec_detail_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo spec_list(null, $name, $selected_id, $all_option, $submit_on_change, $stock_id, $spec_detail_id);
	echo "</td>\n";
}

function spec_list_row($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $stock_id=null, $spec_detail_id=null)
{
	echo "<tr><td class=''>$label</td>";
	spec_list_cells(null, $name, $selected_id, $all_option, $submit_on_change, $stock_id, $spec_detail_id);
	echo "</tr>\n";
}

//-----------------------------------------------------------------------------------------------

// function specification_with_without($label, $name, $selected_id=null, $submit_on_change=false)
// {
//  $items = array();
//     $items['0'] ='Select Specification';
//     $items['1'] ='With';
// 	$items['2'] ='Without';

//  echo "<td class=''>$label</td><td>";
//  echo array_selector($name, $selected_id, $items, 
//   array( 
//    'select_submit'=> $submit_on_change,
//    'async' => false ) ); // FIX?
//  echo "</td>";
// }


//-------------------- 28 september specification work ------------------------------//

function specification_with_without($label, $name, $selected_id=null, $submit_on_change=false)
{
 $items = array();
    $items['0'] ='Select Specification';
    $items['1'] ='With';
	$items['2'] ='Without';

 echo "<td class=''>$label</td><td>";
 echo array_selector($name, $selected_id, $items, 
  array( 
   'select_submit'=> $submit_on_change,
   'async' => false ) ); // FIX?
 echo "</td>";
}

function get_specification_all($id=null)
{
	$sql="SELECT * from ".TB_PREF."specification where inactive =0 and deleted =0 AND id != -1 ";
	// display_error($sql);
$res = db_query($sql,"");
// $result=db_fetch($res);
return $res;
}

//-----------------------------------------------------------------------------------------
function specification_property_list($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $stock_id=null, $specification_id=null)
{
$sql="SELECT ".TB_PREF."item_specification.specification_detail_id, ".TB_PREF."specification_detail.drop_name
FROM ".TB_PREF."item_specification, ".TB_PREF."specification_detail
WHERE ".TB_PREF."item_specification.specification_id = ".db_escape($specification_id)."
AND ".TB_PREF."item_specification.stock_id = ".db_escape($stock_id)."
AND ".TB_PREF."item_specification.specification_detail_id = ".TB_PREF."specification_detail.id ";


		// // $sql= "SELECT ".TB_PREF."item_specification.specification_detail_id, ".TB_PREF."specification_detail.drop_name 
		// // FROM ".TB_PREF."item_specification, ".TB_PREF."specification_detail 
		// // WHERE ".TB_PREF."item_specification.specification_detail_id = ".TB_PREF."specification_detail.id 
		// // AND ".TB_PREF."item_specification.stock_id= ".db_escape($stock_id)."
		// // AND ".TB_PREF."item_specification.specification_detail_id= ".db_escape($spec_detail_id)."

		// ";

     	return combo_input($name, $selected_id, $sql, TB_PREF.'item_specification.specification_detail_id', TB_PREF.'specification_detail.drop_name',
		array(
			'spec_option' => $all_option === true ? _("All spec") : $all_option,
			'spec_id' => ALL_TEXT,
			'select_submit'=> $submit_on_change

		) );



}

function specification_property_list_cells($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $stock_id=null, $spec_detail_id=null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo specification_property_list(null, $name, $selected_id, $all_option, $submit_on_change, $stock_id, $spec_detail_id);
	echo "</td>\n";
}

function specification_property_list_row($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $stock_id=null, $spec_detail_id=null)
{
	echo "<tr><td class=''>$label</td>";
	specification_property_list_cells(null, $name, $selected_id, $all_option, $submit_on_change, $stock_id, $spec_detail_id);
	echo "</tr>\n";
}

function get_specification_name($id)
{
	$sql="SELECT drop_name from ".TB_PREF."specification_detail where id = ".db_escape($id)." ";
	$run=db_query($sql, "cannot get specification name from get_specification_name() function ");
	$res=db_fetch($run);
	return $res['drop_name'];
}
//-----------------------------------------------------------------------------------------------
function get_sec_roless($label, $name, $selected_id=null, $submit_on_change=fasle)
{
	global $security_areas, $security_sections;
// 
	// print_r(sort_areas(@$security_areas));
 $items = array();
 $cc=0;

		// @$security_sections='';
 	$k = $j = 0; //row colour counter
	$ext = $sec = $m = -1;
	// for($i=1;$i<=20;$i++)
	// {
	// 	display_error($i);
	// }
 	foreach(sort_areas($security_areas) as $area =>$parms ) {
		// system setup areas are accessable only for site admins i.e. 
		// admins of first registered company
		if (user_company() && (($parms[0]&0xff00) == SS_SADMIN)) continue;
		$newsec = ($parms[0]>>8)&0xff;
		$newext  = $parms[0]>>16;
		if ($newsec != $sec || (($newext != $ext) && ($newsec>99)))
		{ // features set selection
			$ext = $newext; 
			$sec = $newsec;
			$m = $parms[0] & ~0xff;

			// label_row(@$security_sections[$m].':', // name of drop down
    		$items['-1'] ='Select Module';
    		$items[$m] =@$security_sections[$m];
   //  		$items['1'] ='With';
			// $items['2'] ='Without';
				// checkbox( null, 'Section'.$m, null, true, 
			// 		_("On/off set of features")),
			// "class='tableheader2'", "class='tableheader'");
		}
	$cc++;}
	

 echo "<td class=''>$label</td><td>";
 echo array_selector($name, $selected_id, $items, 
  array( 
   'select_submit'=> $submit_on_change,
   'async' => false ) ); // FIX?
 echo "</td>";
}








//------------------------------------------------------------------------------------------------

function dropdown_languages_list($name, $selected_id=null, $all_option=false)
{
	 $items = array();
    $items['0'] ='Select Language';
    $items['1'] ='English';
	$items['2'] ='Arabic';

 echo array_selector($name, $selected_id, $items, 
  array( 
   'select_submit'=> $submit_on_change,
   'async' => false ) ); // FIX?
}

 //echo "<td class=''>$label</td><td>";
function dropdown_languages_list_cells($label, $name, $selected_id=null, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo dropdown_languages_list($name, $selected_id, $all_option);
	echo "</td>\n";
}

function dropdown_languages_list_row($label, $name, $selected_id=null, $all_option=false)
{
	echo "<tr><td class=''>$label</td>";
	dropdown_languages_list_cells(null, $name, $selected_id, $all_option);
	echo "</tr>\n";
}

//------------------------------------------------------------------------------------------------

function tax_label_list($name, $selected_id=null, $all_option=false)
{
	 $items = array();
    // $items['0'] ='Select Label';
    $items['VAT No'] ='VAT No';
	$items['GST No'] ='GST No';

 echo array_selector($name, $selected_id, $items, 
  array( 
   'select_submit'=> $submit_on_change,
   'async' => false ) ); // FIX?
}


function tax_label_list_cells($label, $name, $selected_id=null, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo tax_label_list($name, $selected_id, $all_option);
	echo "</td>\n";
}

function tax_label_list_row($label, $name, $selected_id=null, $all_option=false)
{
	echo "<tr><td class=''>$label</td>";
	tax_label_list_cells(null, $name, $selected_id, $all_option);
	echo "</tr>\n";
}


//zee
function clearedUnclearedCheque($name, $selected_id=null, $name_yes="", $name_no="", $submit_on_change=false)
{
	$items = array();
	$items['0'] = strlen($name_no) ? $name_no : _("Uncleared Cheque");
	$items['1'] = strlen($name_yes) ? $name_yes : _("Cleared Cheque");

	return array_selector($name, $selected_id, $items, 
		array( 
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}

function clearedUnclearedCheque_cells($label, $name, $selected_id=null, $name_yes="", $name_no="", $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo clearedUnclearedCheque($name, $selected_id, $name_yes, $name_no, $submit_on_change);
	echo "</td>\n";
}

function clearedUnclearedCheque_row($label, $name, $selected_id=null, $name_yes="", $name_no="", $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	clearedUnclearedCheque_cells(null, $name, $selected_id, $name_yes, $name_no, $submit_on_change);
	echo "</tr>\n";
}

function ChequeType($name, $selected_id=null, $name_yes="", $name_no="", $submit_on_change=false)
{
	$items = array();
	$items['0'] = strlen($name_no) ? $name_no : _("Uncleared Cheque");
	$items['1'] = strlen($name_yes) ? $name_yes : _("Cleared Cheque");
	$items['2'] = strlen($name_yes) ? $name_yes : _("Bounce Cheque");

	return array_selector($name, $selected_id, $items, 
	array( 
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}

function ChequeType_cells($label, $name, $selected_id=null, $name_yes="", $name_no="", $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo ChequeType($name, $selected_id, $name_yes, $name_no, $submit_on_change);
	echo "</td>\n";
}

function purchase_req_list_cells($label, $name, $selected_id=null, $all_option=false, 
	$submit_on_change=false, $all=false, $req_id)
{
	if ($label != null)
		echo "<td>$label</td>\n";
		echo "<td>";
		echo purchase_req_list($name, $selected_id, $all_option, $submit_on_change, 
		$all, $req_id);
		echo "</td>\n";
}

function purchase_req_list($name, $selected_id=null, $spec_option=false, $submit_on_change=false,
	$all=false, $req_id)
{
	$sql = " SELECT sm.stock_id, sm.description FROM ".TB_PREF."purchase_material_req_details AS pmr JOIN ".TB_PREF."stock_master AS sm WHERE sm.stock_id = pmr.item_code AND  pmr.material_req_id = '$req_id' ";

	// display_error($sql);
	$ret = combo_input($name, $selected_id, $sql, 'stock_id', 'description',
	array(
		'format' => '_format_add_curr',
	    'order' => array('stock_id'),
		'type' => 1,
        'search' => array("stock_id","description"),        
		'spec_option' => $spec_option === true ? _("All Items") : $spec_option,
		'spec_id' => ALL_TEXT,
		'select_submit'=> $submit_on_change,
		'async' => false,
		'sel_hint' => $mode ? _('Press Space tab to filter by name fragment') :
		_('Select supplier'),
		'show_inactive'=>$all,
		'editlink' => $editkey ? add_edit_combo('supplier') : false
		), "supplier");
	return $ret;
}

function pr_entry_list_cells($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $settled=0)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo pr_entry_list($name, $selected_id, $all_option, $submit_on_change, $settled);
	echo "</td>\n";
}

function pr_entry_list($name, $selected_id=null, $all_option=false, $submit_on_change=false, $settled=false)
{

	$sql = "SELECT pr_id, pr_id AS name FROM ".TB_PREF."rfq WHERE settle = '$settled' GROUP BY pr_id ";
	// display_error($sql);

	return combo_input($name, $selected_id, $sql, 'pr_id', 'name',
		array(
			'spec_option' => $all_option === true ? _("All PR") : $all_option,
			'spec_id' => ALL_TEXT,
			'select_submit'=> $submit_on_change
		) );
}


function pr_supplier_list_cells($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $pr_id=0)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo pr_supplier_list($name, $selected_id, $all_option, $submit_on_change, $pr_id);
	echo "</td>\n";
}

function pr_supplier_list($name, $selected_id=null, $all_option=false, $submit_on_change=false, $pr_id=false)
{

	$sql = "SELECT rfq.supplier_id, s.supp_name AS name FROM ".TB_PREF."rfq AS rfq JOIN ".TB_PREF."suppliers AS s WHERE s.supplier_id = rfq.supplier_id AND pr_id = '$pr_id' ";
	// display_error($sql);

	return combo_input($name, $selected_id, $sql, 'supplier_id', 'name',
		array(
			'spec_option' => $all_option === true ? _("All Supplier") : $all_option,
			'spec_id' => ALL_TEXT,
			'select_submit'=> $submit_on_change
		) );
}
function countries_list_cells($label, $name, $selected_id=null, $submit_on_change=false, $spec_opt=true,$user_id=0)
{
    $sql = " SELECT id,name FROM 0_countries ";
    if ($label != null)
        echo "<td>$label</td>\n";
    echo "<td>";

    echo combo_input($name, $selected_id, $sql, 'id', 'name',
        array(
            'spec_option' => $spec_opt===true ?_("Select Country") : $spec_opt,
            'spec_id' => '',
            'order' => 'name',
            'select_submit'=> $submit_on_change,
            'async' => false
        ) );
    echo "</td>";

}
function countries_list_row($label, $name, $selected_id=null, $submit_on_change=false, $spec_opt=true,$user_id=0)
{
	echo "<tr><td class=''>$label</td>";
	countries_list_cells(null, $name, $selected_id, $submit_on_change, $spec_opt,$user_id);
	echo "</tr>\n";
}
function ExciseTaxTypeList($name, $selected_id=null, $all_option, $submit_on_change=false)
{
	$items = array();
	$items['0'] = _('Select');
	// $items['1'] =  _("Stockpiling of Excise Goods in the UAE, including");
	$items['1'] =  _("A) Tobacco and tobacco products");
	$items['2'] =  _("B) Carbonated drinks");
	$items['3'] =  _("C) Energy drinks");
	// $items['5'] =  _("Total value of Excise Goods/Due Tax");
	$items['4'] =  _("Value of Tax declared in error and identified in the same month");
	$items['5'] =  _("Value of Deductible Tax for Tax paid in error (which is below AED 10,000)");
	$items['6'] =  _("Value of other Deductible Tax");
	$items['7'] =  _("Value of under declared Tax for the previous tax period (which is above AED 10,000)");
	// $items['10'] =  _("Total value of Payable Tax(Excess Refundable Tax)");

	return array_selector($name, $selected_id, $items, 
	array( 
		// 'spec_option' => $all_option === true ? _("Select") : $all_option,
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}
function ExciseTaxTypeListCell($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo ExciseTaxTypeList($name, $selected_id, $all_option, $submit_on_change);
	echo "</td>\n";
}

function VatTaxTypeList($name, $selected_id=null, $all_option, $submit_on_change=false)
{
	$items = array();
	$items['0'] = _('Select');
	$items['1'] =  _("Adjustments");
    $items['2'] =  _("Amendments or correction to Output figures.");
    $items['3'] =  _("Amendments or corrections to Input figures.");
    $items['4'] =  _("2-Supplies subject to the reverse charge provision ");
    $items['5'] =  _("Standard rated expenses");
    $items['6'] =  _("10-Supplies subject to the reverse charge provisions");
	return array_selector($name, $selected_id, $items, 
	array( 
		// 'spec_option' => $all_option === true ? _("Select") : $all_option,
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}
function VatTaxTypeListCell($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo VatTaxTypeList($name, $selected_id, $all_option, $submit_on_change);
	echo "</td>\n";
}
function active_inactive_list($name, $selected_id=null, $all_option, $submit_on_change=false)
{
	$items = array();
	$items['0'] = _('Select');
	$items['1'] =  _("Active");
    $items['2'] =  _("Inactive");
	return array_selector($name, $selected_id, $items, 
	array( 
		// 'spec_option' => $all_option === true ? _("Select") : $all_option,
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}
//======================================================================================================================
function all_trans_doc_list($name,$selected_id=null,$submit_on_change = false,  $all=false, $spec_opt = false, $type=null,$trans_date_from=null, $trans_date_to=null)
{
	// $sql = "SELECT id, reference FROM ".TB_PREF."refs  ";
	/*$sql = "SELECT ref.id,ref.reference FROM 0_refs AS ref LEFT JOIN 0_voided AS V ON v.id = ref.id AND v.type = ref.type WHERE  ISNULL(v.id)";*/
	// display_error($trans_date);
	$trans_date_from = date2sql($trans_date_from);
	$trans_date_to = date2sql($trans_date_to);
	$sql = "SELECT ref.id,CONCAT(ref.reference,' - ',( CASE 
        WHEN dt.debtor_no THEN cust.name
        WHEN st.supplier_id THEN supp.supp_ref
    	WHEN so.debtor_no THEN cust.name
    	WHEN po.supplier_id THEN supp.supp_ref
    	WHEN bt.person_type_id = 0 THEN 'Miscellaneous'
    	WHEN bt.person_type_id = 2 THEN cust.name
   		WHEN bt.person_type_id = 3 THEN supp.supp_ref
        ELSE ' '
    END)) AS ref_val
FROM 0_refs AS ref 
LEFT JOIN 0_voided AS v ON v.id = ref.id AND v.type = ref.type 
LEFT JOIN 0_sales_orders AS so ON ref.id = so.order_no AND ref.type = so.trans_type
LEFT JOIN 0_debtor_trans AS dt ON ref.id = dt.trans_no AND ref.type = dt.type
LEFT JOIN 0_supp_trans AS st ON ref.id = st.trans_no AND ref.type = st.type
LEFT JOIN 0_purch_orders AS po ON ref.id = po.order_no AND (ref.type = 25 OR ref.type = 18)
LEFT JOIN 0_journal AS j ON ref.id = j.trans_no AND ref.type = j.type
LEFT JOIN 0_stock_moves AS sm ON ref.id = sm.trans_no AND ref.type = sm.type
LEFT JOIN 0_bank_trans AS bt ON ref.id = bt.trans_no AND ref.type = bt.type
LEFT JOIN 0_debtors_master cust ON cust.debtor_no = dt.debtor_no OR cust.debtor_no = so.debtor_no OR ((bt.person_type_id=2) AND CAST(bt.person_type_id AS CHAR(10000) CHARACTER SET utf8) = cust.debtor_no)
LEFT JOIN 0_suppliers supp ON supp.supplier_id = st.supplier_id OR supp.supplier_id = po.supplier_id OR ((bt.person_type_id=3) AND CAST(bt.person_type_id AS CHAR(10000) CHARACTER SET utf8) = supp.supplier_id)
WHERE ISNULL(v.id)";

   if($type != null)
   	$sql .= " AND ref.type = '$type' ";

   if ($trans_date_from != null) {
   	$sql .= " AND ( CASE 
        WHEN dt.tran_date THEN dt.tran_date
        WHEN st.tran_date THEN st.tran_date
    	WHEN so.ord_date THEN so.ord_date
    	WHEN po.ord_date THEN po.ord_date
  		WHEN j.tran_date THEN j.tran_date
    	WHEN bt.trans_date THEN bt.trans_date
  		WHEN sm.tran_date THEN sm.tran_date
    END) >= '$trans_date_from'";
   }

   if ($trans_date_to != null) {
   	$sql .= " AND ( CASE 
        WHEN dt.tran_date THEN dt.tran_date
        WHEN st.tran_date THEN st.tran_date
    	WHEN so.ord_date THEN so.ord_date
    	WHEN po.ord_date THEN po.ord_date
  		WHEN j.tran_date THEN j.tran_date
    	WHEN bt.trans_date THEN bt.trans_date
  		WHEN sm.tran_date THEN sm.tran_date
    END) <= '$trans_date_to'";
   }

   $sql .= " GROUP by ref.reference,ref.id,ref.type";
// display_error($sql);

return combo_input($name, $selected_id, $sql, 'id', 'ref_val',
	array(
                'spec_option'=> _("Select Transaction"),
		'spec_id' => '',
		'select_submit'=> $submit_on_change,
		'show_inactive' => $show_inactive
	) );
}

function all_trans_doc_list_cells($label, $name,$selected_id,$submit_on_change , $all=false, $spec_opt = false, $type=0,$trans_date_from=null,$trans_date_to=null)
{
	// display_error($user_id);
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo all_trans_doc_list($name,$selected_id,$submit_on_change, $all, $spec_opt, $type, $trans_date_from,$trans_date_to);
	echo "</td>\n";
	
}

function all_trans_doc_list_row($label, $name,$selected_id,$submit_on_change , $all=false, $spec_opt = false, $type=0,$trans_date_from=null,$trans_date_to=null)
{
	echo "<tr><td>$label</td>";
	all_trans_doc_list_cells(null, $name,$selected_id, $submit_on_change,$all, $spec_opt,$type,$trans_date_from,$trans_date_to);
	echo "</tr>\n";	
}
//==============================================================================================================
function customer_list_multi($name, $selected_id=null, $spec_option=false, $submit_on_change=false, 
	$show_inactive=false, $editkey = false, $user_id=0)
{
	
	global $SysPrefs;
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English

	if (!empty($SysPrefs->prefs['shortname_name_in_list']))
		$sql = "SELECT debtor_no,
		IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,
		d.name, d.curr_code, d.inactive FROM ".TB_PREF."debtors_master d";
	else		
		$sql = "SELECT debtor_no,
		IF(".$dropdown_language."='2',IF(d.CustName_arabic = '',d.debtor_ref,d.CustName_arabic),d.debtor_ref ) as debtor_ref,
		d.curr_code, d.inactive FROM ".TB_PREF."debtors_master d";
	
	if($user_id != 0)
	    $sql .= " WHERE user_id = '$user_id' ";	

	$results = db_query($sql);

	while ($tag = db_fetch($results))
		$tags[$tag['debtor_no']] = $tag['debtor_ref'];
	
	// if (!isset($tags)) {
	// 	$tags[''] = $all ? _("No tags defined.") : _("No active tags defined.");
	// 	$spec_opt = false;
	// }
	return array_selector($name, null, $tags,
		array(
			'multi' => $multi,
			'height' => $height,
			'spec_option'=> $spec_option,
			'spec_id' => '',
		),2 );
}


function customer_list_multi_cells($label, $name, $selected_id=null, $all_option=false, 
	$submit_on_change=false, $show_inactive=false, $editkey = false, $user_id=0)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td nowrap>";
	echo customer_list_multi($name, $selected_id, $all_option, $submit_on_change,
		$show_inactive, $editkey, $user_id);
	echo "</td>\n";
}

function customer_list_multi_row($label, $name, $selected_id=null, $all_option = false, 
	$submit_on_change=false, $show_inactive=false, $editkey = false)
{

	echo "<tr><td>$label</td><td nowrap>";
	echo customer_list_multi($name, $selected_id, $all_option, $submit_on_change,
		$show_inactive, $editkey);
	echo "</td>\n</tr>\n";
}

function sales_order_list($name,$selected_id=null,$submit_on_change = false,  $all=false, $spec_opt = false)
{
	
	$sql = "SELECT `order_no`, CONCAT('Order # ',`order_no`,' - ',`reference`) AS info FROM `0_sales_orders` WHERE `trans_type` = '30'";

return combo_input($name, $selected_id, $sql, 'order_no', 'info',
	array(
                'spec_option'=> _("Select Transaction"),
		'spec_id' => '',
		'select_submit'=> $submit_on_change,
		'show_inactive' => $show_inactive
	) );
}

function sales_order_list_cells($label, $name,$selected_id,$submit_on_change , $all=false, $spec_opt = false)
{
	// display_error($user_id);
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo sales_order_list($name,$selected_id,$submit_on_change, $all, $spec_opt);
	echo "</td>\n";
	
}

function sales_order_list_row($label, $name,$selected_id,$submit_on_change , $all=false, $spec_opt = false)
{
	echo "<tr><td >$label</td>";
	sales_order_list_cells(null, $name,$selected_id, $submit_on_change,$all, $spec_opt);
	echo "</tr>\n";	
}

// //  # Hrm Ui list For employee and deduction and allowncess...
// function emp_trans_payment_list($name, $selected_id=null, $no_option=false, $showname=' ',
// 	$submit_on_change=false, $showclosed=false, $showtype=1,$bank_acc=0)
// {
// 	// $sql = "SELECT id, CONCAT(reference,'  ',name) as ref FROM ".TB_PREF."dimensions";
// 	  //, dt.debtor_no,dm.debtor_ref ,ba.bank_account_name
// 	$sql = "SELECT  bt.id, CONCAT(IF(bt.type=12,'CP' ,'FT' ) ,' - ',bt.trans_no ,' - ' , IF(bt.type=12, dm.debtor_ref , SUBSTRING_INDEX(CONVERT(bt.person_id USING utf8), 'To', 1) ) ,' - ', DATE_FORMAT(bt.trans_date,'%d/%m/%Y') ,' - Amt : ', (bt.amount - bt.alloc) ) as ref  FROM 0_bank_trans bt LEFT JOIN 0_debtor_trans dt on bt.type=dt.type AND bt.trans_no=dt.trans_no LEFT JOIN 0_debtors_master dm on dt.debtor_no=dm.debtor_no LEFT JOIN 0_bank_accounts ba on bt.bank_act=ba.id WHERE (bt.type = 12 OR bt.type = 4 AND bt.amount > 0) AND bt.bank_act=".db_escape($bank_acc)." AND bt.amount != bt.alloc";

// // display_error($sql);
// 	// display_error($selected_id);

// 	$options = array(
// 		'order' => 'id',
// 		'spec_option'=>$no_option ? $showname : true,
// 		'spec_id' => 0,
// 		'select_submit'=> $submit_on_change,
// 		// 'async' => false,
// 	);

// 	// if (!$showclosed)
// 	// 	$options['where'][] = "closed=0";
// 	// if($showtype)
// 	// 	$options['where'][] = "type_=".db_escape($showtype);

// 	return combo_input($name, $selected_id, $sql, 'id', 'ref', $options);
// }

// function emp_trans_payment_list_cells($label, $name, $selected_id=null, $no_option=false, $showname=null,
// 	$showclosed=false, $showtype=0, $submit_on_change=false,$bank_acc=0)
// {
// 	if ($label != null)
// 		echo "<td>$label</td>\n";
// 	echo "<td>";
// 	echo emp_trans_payment_list($name, $selected_id, $no_option, $showname, $submit_on_change, $showclosed, $showtype,$bank_acc);
// 	echo "</td>\n";
// }

// // function set_focus_for_dropdown($name){
// // 	return set_focus($name.'mselect');
// // }

// function allowance_list($label, $name, $selected_id=null, $submit_on_change=false)
// {
// 	$sql = "SELECT id,allowances FROM ".TB_PREF."payroll_allowances WHERE deleted = 0 and inactive = 0";
// 	$res = db_query($sql, '');
//         $vers["0"] = "Select Allowance";
// 	while($mysql=db_fetch($res)) {
// 		$vers[$mysql['id']] = $mysql['allowances'];
// 	}
// 	echo "<tr><td class=''>$label</td><td>";
// 	echo array_selector($name, $selected_id, $vers,
// 			array(
// 					'select_submit'=> $submit_on_change
// 			) );
// 	echo "</td></tr>\n";
// // // }

// // function deduction_list($label, $name, $selected_id=null, $submit_on_change=false)
// // {
// // 	$sql = "SELECT id,deductions FROM ".TB_PREF."payroll_deductions WHERE deleted = 0 AND inactive = 0";
// // 	$res = db_query($sql, '');
// //         $vers[0] = " Select deduction ";
// // 	while($mysql=db_fetch($res)) {
// // 		$vers[$mysql['id']] = $mysql['deductions'];
// // 	}
// // 	echo "<tr><td class=''>$label</td><td>";
// // 	echo array_selector($name, $selected_id, $vers,
// // 			array(
// // 					'select_submit'=> $submit_on_change
// // 			) );
// // 	echo "</td></tr>\n";
// // }


// function select_table_column($label, $name, $selected_id=null, $submit_on_change=false)
// {
// 	$status = array(0=>'Select Column','first_name'=>'First Name','last_name'=>'Last Name','designation'=>'Designation','department'=>'Department','dedcuations'=>'Dedcuations','allowances'=>'Allowances','temp_allowaances'=>'Temp Allowaances','temp_decuction'=> 'Temp Decuction','payment_days'=>'Payment Days','normal_hrs'=>'Normal Hrs','overtime'=>'OverTime','loan'=>'Loan');
// 	echo "<td class=''>$label</td><td>";
// 	echo array_selector($name, $selected_id, $status,
// 			array(
// 					'select_submit'=> $submit_on_change
// 			) );
// 	echo "</td></tr>\n";
// }

// function salary_month_report($label=null,$name, $selected_id=null, $submit_on_change=false)
// {
// $month = array ("Select Month", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
	
// 	return array_selector($name, $selected_id, $month,
// 			array(
// 					'select_submit'=> $submit_on_change
// 			) );

// }

// function salary_month($label=null,$name, $selected_id=null, $submit_on_change=false)
// {
// $month = array ("Select Month", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
// 	if ($label !=null) 
// 		echo "<td class=''>$label</td>";
// 	echo "<td>";
// 	echo array_selector($name, $selected_id, $month,
// 			array(
// 					'select_submit'=> $submit_on_change
// 			) );
// 	echo "</td>";
// }

// function leave_type_list_cells($label, $name, $selected=null, $submit_on_change=false)
// {

// 	if ($label != null)
// 		label_cell($label);
// 	echo "<td>\n";
// 	$allocs = array( 
// 		'-1'=>_("All Types"),
// 		'0'=> _("UPL"),
// 		'1'=> _("PL"),
		
// 	);
// 	echo array_selector($name, $selected, $allocs, array('select_submit'=> $submit_on_change));
// 	echo "</td>\n";
// }

// function ApprovedUnApproved_list_cells($label, $name, $selected=null, $submit_on_change=false)
// {

// 	if ($label != null)
// 		label_cell($label);
// 	echo "<td>\n";
// 	$allocs = array( 
// 		'-1'=>_("All"),
// 		'1'=> _("Approved"),
// 		'0'=> _("Un-Approved"),
		
// 	);
// 	echo array_selector($name, $selected, $allocs, array('select_submit'=> $submit_on_change));
// 	echo "</td>\n";
// }

// //----------------------------------------------------------------------------------------------

// function employee_security_roles_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
// 	$show_inactive = false,$role_id=0)
// {
// 	global $all_items;


// 	 if($role_id)
// 	 {
// 	   $sql = "SELECT id, role, inactive FROM ".TB_PREF."security_roles";
// 	 	$sql.=' WHERE id='.db_escape($role_id);
// 	 }
// // display_error($sql);
// return combo_input($name, $selected_id, $sql, 'id', 'description',
// 	array(
// 		'spec_option'=>$new_item ? _("New role") : false,
// 		'spec_id' => '',
// 		'select_submit'=> $submit_on_change,
// 		'show_inactive' => $show_inactive
// 	) );
// }

// function employee_security_roles_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
// 	$show_inactive = false,$role_id=0)
// {
// 	if ($label != null)
// 		echo "<td>$label</td>\n";
// 	echo "<td>";
// 	echo employee_security_roles_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive,$role_id);
// 	echo "</td>\n";
// }

// function employee_security_roles_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
// 	$show_inactive = false,$role_id)
// {
// 	echo "<tr><td class=''>$label</td>";
// 	employee_security_roles_list_cells(null, $name, $selected_id, $new_item, $submit_on_change, $show_inactive,$role_id);
// 	echo "</tr>\n";
// }
// //----------------------------------------------------------------//

// function employee_user_list($name,$selected_id=null,$submit_on_change = false,  $all=false, $spec_opt = false, $user_id=0)
// {
// 	$sql = "SELECT id, user_id, inactive FROM 0_users WHERE id NOT IN(SELECT user_id FROM 0_employee WHERE user_id>0) ";
//    // if($user_id != 0)
//    // 	$sql .= " WHERE u.id = '$user_id' ";

// // display_error($sql);

// return combo_input($name, $selected_id, $sql, 'id', 'user_id',
// 	array(
//                 'spec_option'=> _("Select User"),
// 		'spec_id' => '',
// 		'select_submit'=> $submit_on_change,
// 		'show_inactive' => $show_inactive
// 	) );
// }

// function employee_user_list_cells($label, $name,$selected_id,$submit_on_change , $all=false, $spec_opt = false, $user_id=0)
// {
// 	if ($label != null)
// 		echo "<td>$label</td>\n";
// 	echo "<td>\n";
// 	echo employee_user_list($name,$selected_id,$submit_on_change, $all, $spec_opt, $user_id);
// 	echo "</td>\n";
	
// }

// function employee_user_list_row($label, $name,$selected_id,$submit_on_change, $height, $type, $mult=false, $all=false, $spec_opt = false)
// {
// 	echo "<tr><td class=''>$label</td>";
// 	employee_user_list_cells(null, $name,$selected_id, $submit_on_change,$height, $type, $mult, $all, $spec_opt);
// 	echo "</tr>\n";	
// }

//------------------New File Attested-----------------------------------------------------------------------------

 //  # Hrm Ui list For employee and deduction and allowncess...
function emp_trans_payment_list($name, $selected_id=null, $no_option=false, $showname=' ',
	$submit_on_change=false, $showclosed=false, $showtype=1,$bank_acc=0)
{
	// $sql = "SELECT id, CONCAT(reference,'  ',name) as ref FROM ".TB_PREF."dimensions";
	  //, dt.debtor_no,dm.debtor_ref ,ba.bank_account_name
	$sql = "SELECT  bt.id, CONCAT(IF(bt.type=12,'CP' ,'FT' ) ,' - ',bt.trans_no ,' - ' , IF(bt.type=12, dm.debtor_ref , SUBSTRING_INDEX(CONVERT(bt.person_id USING utf8), 'To', 1) ) ,' - ', DATE_FORMAT(bt.trans_date,'%d/%m/%Y') ,' - Amt : ', (bt.amount - bt.alloc) ) as ref  FROM 0_bank_trans bt LEFT JOIN 0_debtor_trans dt on bt.type=dt.type AND bt.trans_no=dt.trans_no LEFT JOIN 0_debtors_master dm on dt.debtor_no=dm.debtor_no LEFT JOIN 0_bank_accounts ba on bt.bank_act=ba.id WHERE (bt.type = 12 OR bt.type = 4 AND bt.amount > 0) AND bt.bank_act=".db_escape($bank_acc)." AND bt.amount != bt.alloc";

// display_error($sql);
	// display_error($selected_id);

	$options = array(
		'order' => 'id',
		'spec_option'=>$no_option ? $showname : true,
		'spec_id' => 0,
		'select_submit'=> $submit_on_change,
		// 'async' => false,
	);

	// if (!$showclosed)
	// 	$options['where'][] = "closed=0";
	// if($showtype)
	// 	$options['where'][] = "type_=".db_escape($showtype);

	return combo_input($name, $selected_id, $sql, 'id', 'ref', $options);
}

function emp_trans_payment_list_cells($label, $name, $selected_id=null, $no_option=false, $showname=null,
	$showclosed=false, $showtype=0, $submit_on_change=false,$bank_acc=0)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo emp_trans_payment_list($name, $selected_id, $no_option, $showname, $submit_on_change, $showclosed, $showtype,$bank_acc);
	echo "</td>\n";
}

// function set_focus_for_dropdown($name){
// 	return set_focus($name.'mselect');
// }

function allowance_list($label, $name, $selected_id=null, $submit_on_change=false)
{
	$sql = "SELECT id,allowances FROM ".TB_PREF."payroll_allowances WHERE deleted = 0 and inactive = 0";
	$res = db_query($sql, '');
        $vers["0"] = "Select Allowance";
	while($mysql=db_fetch($res)) {
		$vers[$mysql['id']] = $mysql['allowances'];
	}
	echo "<tr><td class=''>$label</td><td>";
	echo array_selector($name, $selected_id, $vers,
			array(
					'select_submit'=> $submit_on_change
			) );
	echo "</td></tr>\n";
}

function deduction_list($label, $name, $selected_id=null, $submit_on_change=false)
{
	$sql = "SELECT id,deductions FROM ".TB_PREF."payroll_deductions WHERE deleted = 0 AND inactive = 0";
	$res = db_query($sql, '');
        $vers[0] = " Select deduction ";
	while($mysql=db_fetch($res)) {
		$vers[$mysql['id']] = $mysql['deductions'];
	}
	echo "<tr><td class=''>$label</td><td>";
	echo array_selector($name, $selected_id, $vers,
			array(
					'select_submit'=> $submit_on_change
			) );
	echo "</td></tr>\n";
}


function select_table_column($label, $name, $selected_id=null, $submit_on_change=false)
{
	$status = array(0=>'Select Column','first_name'=>'First Name','last_name'=>'Last Name','designation'=>'Designation','department'=>'Department','dedcuations'=>'Dedcuations','allowances'=>'Allowances','temp_allowaances'=>'Temp Allowaances','temp_decuction'=> 'Temp Decuction','payment_days'=>'Payment Days','normal_hrs'=>'Normal Hrs','overtime'=>'OverTime','loan'=>'Loan');
	echo "<td class=''>$label</td><td>";
	echo array_selector($name, $selected_id, $status,
			array(
					'select_submit'=> $submit_on_change
			) );
	echo "</td></tr>\n";
}

function salary_month_report($label=null,$name, $selected_id=null, $submit_on_change=false)
{
$month = array ("Select Month", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
	
	return array_selector($name, $selected_id, $month,
			array(
					'select_submit'=> $submit_on_change
			) );

}

function salary_month($label=null,$name, $selected_id=null, $submit_on_change=false)
{
$month = array ("Select Month", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December");
	if ($label !=null) 
		echo "<td class=''>$label</td>";
	echo "<td>";
	echo array_selector($name, $selected_id, $month,
			array(
					'select_submit'=> $submit_on_change
			) );
	echo "</td>";
}

function leave_type_list_cells($label, $name, $selected=null, $submit_on_change=false)
{

	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	$allocs = array( 
		'-1'=>_("All Types"),
		'0'=> _("UPL"),
		'1'=> _("PL"),
		
	);
	echo array_selector($name, $selected, $allocs, array('select_submit'=> $submit_on_change));
	echo "</td>\n";
}

function ApprovedUnApproved_list_cells($label, $name, $selected=null, $submit_on_change=false)
{

	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	$allocs = array( 
		'-1'=>_("All"),
		'1'=> _("Approved"),
		'0'=> _("Un-Approved"),
		
	);
	echo array_selector($name, $selected, $allocs, array('select_submit'=> $submit_on_change));
	echo "</td>\n";
}

//----------------------------------------------------------------------------------------------

function employee_security_roles_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false,$role_id=0)
{
	global $all_items;


	 if($role_id)
	 {
	   $sql = "SELECT id, role, inactive FROM ".TB_PREF."security_roles";
	 	$sql.=' WHERE id='.db_escape($role_id);
	 }
// display_error($sql);
return combo_input($name, $selected_id, $sql, 'id', 'description',
	array(
		'spec_option'=>$new_item ? _("New role") : false,
		'spec_id' => '',
		'select_submit'=> $submit_on_change,
		'show_inactive' => $show_inactive
	) );
}

function employee_security_roles_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false,$role_id=0)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo employee_security_roles_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive,$role_id);
	echo "</td>\n";
}

function employee_security_roles_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false,$role_id)
{
	echo "<tr><td class=''>$label</td>";
	employee_security_roles_list_cells(null, $name, $selected_id, $new_item, $submit_on_change, $show_inactive,$role_id);
	echo "</tr>\n";
}

 
       function employee_user_list($name,$selected_id=null,$submit_on_change = false,  $all=false, $spec_opt = false, $user_id=0)
{
	$sql = "SELECT id, user_id, inactive FROM 0_users WHERE id NOT IN(SELECT user_id FROM 0_employee WHERE user_id>0) ";
   // if($user_id != 0)
   // 	$sql .= " WHERE u.id = '$user_id' ";

// display_error($sql);

return combo_input($name, $selected_id, $sql, 'id', 'user_id',
	array(
                'spec_option'=> _("Select User"),
		'spec_id' => '',
		'select_submit'=> $submit_on_change,
		'show_inactive' => $show_inactive
	) );
}

function employee_user_list_cells($label, $name,$selected_id,$submit_on_change , $all=false, $spec_opt = false, $user_id=0)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo employee_user_list($name,$selected_id,$submit_on_change, $all, $spec_opt, $user_id);
	echo "</td>\n";
	
}

function employee_user_list_row($label, $name,$selected_id,$submit_on_change, $height, $type, $mult=false, $all=false, $spec_opt = false)
{
	echo "<tr><td class=''>$label</td>";
	employee_user_list_cells(null, $name,$selected_id, $submit_on_change,$height, $type, $mult, $all, $spec_opt);
	echo "</tr>\n";	
}

//==============
function payrol_process_list($name, $selected_id=null, $submit_on_change=false)
{
	$items = array();
	$items['0'] = _("All");
	$items['1'] =  _("Process");
	$items['2'] =  _("Un Process");
	$items['3'] =  _("Paid");
	$items['4'] =  _("Partial Paid");

	return array_selector($name, $selected_id, $items, 
		array( 
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}

function payrol_process_list_cells($label, $name, $selected_id=null, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo payrol_process_list($name, $selected_id, $submit_on_change);
	echo "</td>\n";
}

function payrol_process_list_row($label, $name, $selected_id=null, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	payrol_process_list_cells(null, $name, $selected_id, $submit_on_change);
	echo "</tr>\n";
}

// function payroll_payment_list($name, $selected_id=null, $type=null, $submit_on_change=false,$month=0,$year=0)
// {
// 	// $where = false;
// 	$sql = "SELECT trans_no, CONCAT(trans_no,'- ( ',ref,' ) -', DATE_FORMAT(trans_date,'%d %M %Y')) as description FROM ".TB_PREF."bank_trans WHERE (person_type_id=7 OR person_type_id=6)  AND type=1";
// 	if ($month)
// 		$sql .= " AND MONTH(trans_date)=".db_escape($month);
// 	if ($year)
// 		$sql .= " AND YEAR(trans_date)=".db_escape($year);



// 	return combo_input($name, $selected_id, $sql, 'trans_no', 'description',
// 		array(
// 			'spec_id' => '',
// 			'order' => 'description',
// 			'select_submit'=> $submit_on_change,
// 			'async' => false
// 		) );

// }

function salaryscale_list_rep($name, $id = null, $spec_option = false, $submit_on_change = false, $show_inactive = false) {
	$sql = "SELECT scale_id, scale_name, inactive FROM ".TB_PREF."salaryscale ";

	return combo_input($name, $id, $sql, 'scale_id', 'scale_name',
	array(       
		'spec_option' => $spec_option,
		'select_submit' => $submit_on_change,
		'async' => false,
		'show_inactive' => $show_inactive
	));
}

function leave_type_list_rep($name, $selected=null, $submit_on_change=false)
{

	
	$allocs = array( 
		'-1'=>_("All Types"),
		'0'=> _("UPL"),
		'1'=> _("PL"),
		
	);
	return array_selector($name, $selected, $allocs, array('select_submit'=> $submit_on_change));
	
} 

function ApprovedUnApproved_list_rep($name, $selected=null, $submit_on_change=false)
{

	
	$allocs = array( 
		'-1'=>_("All"),
		'1'=> _("Approved"),
		'0'=> _("Un-Approved"),
		
	);
	return array_selector($name, $selected, $allocs, array('select_submit'=> $submit_on_change));
	
}

/*Report FUnction SEcurity Role 2*/

function rep_security_roles_list2($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{

	$sql = "SELECT id, role, inactive FROM ".TB_PREF."security_roles";

	return combo_input($name, $selected_id, $sql, 'id', 'description',
		array(
			'spec_option' => $all_option===true ?  _("All Roles") : $all_option,
			'spec_id' => '',
			'select_submit'=> $submit_on_change,
			'show_inactive' => $show_inactive
		) );
}

function rep_ecurity_roles_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo rep_security_roles_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function rep_security_roles_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	echo "<tr><td class=''>$label</td>";
	rep_security_roles_list_cells(null, $name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</tr>\n";
}

// Lists For formula calculations created by HK
function arith_operator_list_cells($label, $name, $selected=null, $submit_on_change=false){
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	$arith = array( 
		'+'=>_("+"),
		'-'=>_("-"),
		'/'=> _("/"),
		'*'=> _("*"),
		'('=> _("("),
		')'=> _(")"),
	);
	echo array_selector($name, $selected, $arith, array('select_submit'=> $submit_on_change));
	echo "</td>\n";
}

function charge_list($name, $selected=null, $submit_on_change=false, $group_id=0){
	$sql = "SELECT description, description FROM ".TB_PREF."supp_charges WHERE inactive=0";
	if($group_id){
		$sql .= " AND group_id=".db_escape($group_id);
	}

	if ($label != null)
		label_cell($label);

	return combo_input($name, $selected_id, $sql, 'description', 'description',
	array(
		'select_submit'=> $submit_on_change
	));
}

function charge_list_cells($label, $name, $selected=null, $submit_on_change=false, $group_id=0){
	if ($label != null)
		label_cell($label);

	echo "<td>";
	echo charge_list($name, $selected, $submit_on_change, $group_id);
	echo "</td>\n";

}

function variable_list_cells($label, $name, $selected=null, $submit_on_change=false){
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	$arith = array( 
		'Qty'=>_("Qty."),
		'Price'=>_("Price")
	);
	echo array_selector($name, $selected, $arith, array('select_submit'=> $submit_on_change));
	echo "</td>\n";
}

function impact_list_cells($label, $name, $selected=null, $submit_on_change=false,$colspan = 1){
	if ($label != null)
		label_cell($label);
	echo "<td colspan = '$colspan'>\n";
	$arith = array( 
		'0'=>_("Subtract From Line Total"),
		'1'=>_("Add in Line Total")
	);
	echo array_selector($name, $selected, $arith, array('select_submit'=> $submit_on_change));
	echo "</td>\n";
}


function charge_group_list($name, $selected=null, $submit_on_change=false, $all=false, $spec_option=false){
	$sql = "SELECT id, description FROM ".TB_PREF."charge_group";
	if(!$all){
		$sql .= " WHERE inactive=0";
	}

	if ($label != null)
		label_cell($label);

	return combo_input($name, $selected_id, $sql, 'description', 'description',
	array(
		'select_submit'=> $submit_on_change,
		'spec_option'=> $spec_option
	));
}

function charge_group_list_cells($label, $name, $selected=null, $submit_on_change=false, $all=false, 
	$spec_option=false){
	if ($label != null)
		label_cell($label);

	echo "<td>";
	echo charge_group_list($name, $selected, $submit_on_change, $all, $spec_option);
	echo "</td>\n";

}



/*=========================================================================*/
/*Special Function To RemoveSpecial Character*/
	function clean_spec_char($string) {
		if(strpos($string,"&")>=1)
			$string = str_replace('&', '', $string); 

		return preg_replace('/[^A-Za-z0-9\-_ ]/', '', $string); // Removes special chars.
	}		
	/*===========================================*/

function module_list($name, $selected_id=null, $submit_on_change=false , $sub_module = false , $main_mod='' ,$sub_name='', $main_name ='')
{
	
	
	$applications =$_SESSION['App']->applications;
	$final_list = array();
	if(!$sub_module){
		$module_array = array(); 
		foreach ($applications as $app) {
			if (!in_array($app->parent_module, $module_array) && $app->parent_module != null && $app->parent_module != 'Company Setup') {
			 	$final_list[$app->parent_module] = $app->parent_module;
				}
		}
	}

	elseif($main_mod!=''){
		$final_list = array();
		foreach ($applications as $app) {
			if($main_mod != $app->parent_module || $main_mod == '')
				continue;
			if($app->name == 'System Configuration'){
				$final_list['System Configuration'] = 'System Configuration';
				$final_list['System Miscellaneous'] = 'System Miscellaneous';
				$final_list['System Maintenance'] = 'System Maintenance';
			}else{
				$final_list[$app->name] = $app->name;
			}
		}
	}

	if($sub_name!=''){
		if($sub_name == 'System Miscellaneous' || $sub_name == 'System Maintenance'){
			$sub_name = 'System Configuration';
		}
		foreach ($applications as $app) {
			if($app->parent_module == $main_name && $app->name == $sub_name ){
				foreach ($app->modules as $b) {
					foreach ($b->lappfunctions as $c) {
						$final_list[clean_spec_char($c->label)] = clean_spec_char($c->label);
					}	
				}

			}
				
		}
	}

return array_selector($name, $selected_id, $final_list, 
		array( 
			'spec_option'=> _("Select Module"),
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}

function module_list_cells($label, $name, $selected_id=null, $submit_on_change=false , $sub_module=false , $main_mod='' ,$sub_name='', $main_name='')
{

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo module_list($name, $selected_id, $submit_on_change, $sub_module , $main_mod ,$sub_name, $main_name);
	echo "</td>\n";
}

function module_list_row($label, $name, $selected_id=null, $submit_on_change=false, $sub_module=false, $main_mod='', $sub_name='' , $main_name='')
{


	echo "<tr><td class=''>$label</td>";
	module_list_cells(null, $name, $selected_id, $submit_on_change, $sub_module,  $main_mod ,$sub_name ,$main_name);
	echo "</tr>\n";
}
	

function get_page_name_db($module = "" , $sub_module="0", $scr_name="0"){
	$scr_name= clean($scr_name);
	$sql = "SELECT name FROM ".TB_PREF."modules WHERE module = '$module' AND submodule = '$sub_module' AND screen = '$scr_name'";
	$result  =  db_query($sql);
	return db_fetch($result)['name'];
}   




//====================================================================


function pro_module_name_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{

	$sql = "SELECT id, col_name FROM ".TB_PREF."project_module_name";

	return combo_input($name, $selected_id, $sql,'col_name','id', 
		array(
			'spec_option' => $all_option===true ?  _("All Inquiry Status") : $all_option,
			'spec_id' => '',
			'select_submit'=> $submit_on_change,
			'show_inactive' => $show_inactive
		) );
}

function pro_module_name_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo pro_module_name_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function pro_module_name_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	echo "<tr><td class=''>$label</td>";
	pro_module_name_list(null, $name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</tr>\n";
}


//===========================================================================




function project_color_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	$project_colors = array( 
		'1'=>_("Green"),
		'2'=>_("Yellow"),
		'3'=>_("Red"),
		'4'=>_("Purple")
	);
	return array_selector($name, $selected_id, $project_colors, 
		array( 
			'spec_option' =>  _("All Colors"),
			'select_submit'=> $submit_on_change,
			'async' => false ) ); 
}

function project_color_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo project_color_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function project_color_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	echo "<tr><td class=''>$label</td>";
	echo project_color_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</tr>\n";
}


//===========================================================================

function project_listing_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false, $upd_id=0)
{	
	$end = 10;
	$ser = 1;
	$final = array();
	$placements = array( 
		'1'=>_("1st Placement"),
		'2'=>_("2nd Placement"),
		'3'=>_("3rd Placement"),
		'4'=>_("4th Placement"),
		'5'=>_("5th Placement"),
		'6'=>_("6th Placement"),
		'7'=>_("7th Placement"),
		'8'=>_("8th Placement"),
		'9'=>_("9th Placement"),
		'10'=>_("10th Placement"));
	if($upd_id == -1){
		$sql = "SELECT placement FROM ".TB_PREF."project_module_name WHERE 1 ORDER BY placement ASC";
		$result = db_query($sql);
		while($row = db_fetch($result)){
			if($ser == $row['placement'])
				unset($placements[$row['placement']]);
			$ser++;
		}
		$final = $placements;
	}
	else{
		$final = $placements;
		// $sql = "SELECT placement FROM ".TB_PREF."project_module_name WHERE 1 ORDER BY placement ASC";
		// $result = db_query($sql);
		// while($row = db_fetch($result)){
		// 	$final[$row['placement']] = $placements[$row['placement']];
		// }

		}

	return array_selector($name, $selected_id, $final, 
		array( 
			'spec_option' =>  _("All Serials"),
			'select_submit'=> $submit_on_change,
			'async' => false ) ); 
}

function project_listing_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false, $upd_id=0)
{

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo project_listing_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option, $upd_id);
	echo "</td>\n";
}

function project_listing_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $upd_id=0)
{
	echo "<tr><td class=''>$label</td>";
	echo project_listing_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $upd_id);
	echo "</tr>\n";
}


//===========================================================================





function crm_status($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	global $crm_status;
	return array_selector($name, $selected_id, $crm_status, 
		array( 
			'spec_option' =>  _("All Status"),
			'select_submit'=> $submit_on_change,
			'async' => false ) ); 
}

function crm_status_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo crm_status($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function crm_status_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	echo "<tr><td class=''>$label</td><td>";
	echo crm_status($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</td></tr>\n";
}


//===========================================================================


//====================================================================


function crm_cont_person_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false){

	$current_user = $_SESSION['wa_current_user']->user;
	$allow = get_user($current_user)['all_contact_person'];

	if($allow == 1){
	$sql = "SELECT cust_id, cont_per FROM ".TB_PREF."crm_contact_form";
	}else{
	$sql = "SELECT cust_id, cont_per FROM ".TB_PREF."crm_contact_form WHERE user = ".$current_user;
	}


	return combo_input($name, $selected_id, $sql,'cont_per','cust_id', 
		array(
			'spec_option' => $all_option===true ?  _("All Contact Persons") : $all_option,
			'spec_id' => '',
			'select_submit'=> $submit_on_change,
			'show_inactive' => $show_inactive
		) );
}

function crm_cont_person_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo crm_cont_person_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function crm_cont_person_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,$show_inactive = false){
	echo "<tr><td class=''>$label</td>";
	crm_cont_person_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</tr>\n";
}


//===========================================================================


//====================================================================


function crm_company_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false){
	$current_user = $_SESSION['wa_current_user']->user;
	if(get_user($current_user)['owner'] == 1){
	$sql = "SELECT cust_id, comp_name FROM ".TB_PREF."crm_contact_form ";
	}else{
	$sql = "SELECT cust_id, comp_name FROM ".TB_PREF."crm_contact_form WHERE user = ".$current_user;
	}
	return combo_input($name, $selected_id, $sql,'comp_name','cust_id', 
		array(
			'spec_option' => $all_option===true ?  _("All Companies") : $all_option,
			'spec_id' => '',
			'select_submit'=> $submit_on_change,
			'show_inactive' => $show_inactive
		) );
}

function crm_company_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo crm_company_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function crm_company_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,$show_inactive = false){
	echo "<tr><td class=''>$label</td>";
	crm_company_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</tr>\n";
}


//===========================================================================




//====================================================================


function crm_email_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false){
	$current_user = $_SESSION['wa_current_user']->user;
	if(get_user($current_user)['owner'] == 1){
	$sql = "SELECT cust_id, email_addr FROM ".TB_PREF."crm_contact_form";
	}else{
	$sql = "SELECT cust_id, email_addr FROM ".TB_PREF."crm_contact_form WHERE user = ".$current_user;
	}
	return combo_input($name, $selected_id, $sql,'email_addr','cust_id', 
		array(
			'spec_option' => $all_option===true ?  _("Select Emails") : $all_option,
			'spec_id' => '',
			'select_submit'=> $submit_on_change,
			'show_inactive' => $show_inactive
		) );
}

function crm_email_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo crm_email_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function crm_email_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,$show_inactive = false){
	echo "<tr><td class=''>$label</td>";
	crm_email_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</tr>\n";
}


//===========================================================================




//====================================================================


function crm_porject_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false){
	$current_user = $_SESSION['wa_current_user']->user;
	if(get_user($current_user)['owner'] == 1){
	$sql = "SELECT proj_id, proj_name FROM ".TB_PREF."projects WHERE closed = 0";
	}else{
	$sql = "SELECT proj_id, proj_name FROM ".TB_PREF."projects WHERE owner_id = ".db_escape($current_user)." AND closed = 0";
	}
	
	return combo_input($name, $selected_id, $sql,'proj_name','proj_id', 
		array(
			'spec_option' => $all_option===true ?  _("All Projects") : $all_option,
			'spec_id' => '',
			'select_submit'=> $submit_on_change,
			'show_inactive' => $show_inactive
		) );
}

function crm_porject_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo crm_porject_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function crm_porject_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,$show_inactive = false, $all_option=false){
	echo "<tr><td class=''>$label</td><td>";
	echo crm_porject_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td></tr>\n";
}




//-----------------------------------------------------------------------------------------------


function sale_draft_order($name, $selected_id=null, $submit_on_change=true)
{
	$sql = "SELECT order_no, CONCAT(cust_name,'_',ROUND(total,2),'_',reference) as name FROM ".TB_PREF."sales_orders";
		$sql .= " WHERE draft_pos=1 AND ord_cancel = 0";

	return combo_input($name, $selected_id, $sql, 'order_no', 'name',
		array(
			  'spec_option'=> _("Select Draft Order"),
			'select_submit'=> $submit_on_change,
			'async' => true
		) );

}

function sale_draft_order_cells($label, $name, $selected_id=null, $submit_on_change=true)
{
	if ($label != null)
		echo "<td class=''>$label</td>\n";
	echo "<td>";

	echo sale_draft_order($name, $selected_id, $submit_on_change);

	echo "</td>\n";
}

//===========================================================================





function filter_dropdown($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	$search_filter = array( 
		'NAME'=>_("Name"),
		'MOBILE'=>_("Mobile"),
		'PHONE'=>_("Phone"),
		'EMAIL'=>_("Email"),
		'COMPANY'=>_("Company"),
		'USER'=>_("User")

	);
	return array_selector($name, $selected_id, $search_filter, 
		array( 
			'spec_option' =>  _("Search Filter"),
			'select_submit'=> $submit_on_change,
			'async' => false ) ); 
}

function filter_dropdown_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo filter_dropdown($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function filter_dropdown_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	echo "<tr><td class=''>$label</td><td>";
	echo filter_dropdown($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</td></tr>\n";
}





//===========================================================================



function elevation_dashboard($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	$elv_db = array( 
		'CMP_DASHB'=>_("Company Dashboard"),
		'CRM_DASHB'=>_("CRM Dashboard")
	);
	return array_selector($name, $selected_id, $elv_db, 
		array( 
			'spec_option' =>  false,
			'select_submit'=> $submit_on_change,
			'async' => false ) ); 
}

function elevation_dashboard_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo elevation_dashboard($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function elevation_dashboard_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	echo "<tr><td class=''>$label</td><td>";
	echo elevation_dashboard($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</td></tr>\n";
}

function customer_order_list($name, $selected_id=null, $customer=0, $submit_on_change=false,  
	$spec_opt=false){
	
	$sql = "SELECT order_no, CONCAT('REF: ', reference, ' Date: ', ord_date) AS name 
	FROM ".TB_PREF."sales_orders WHERE trans_type = ".ST_SALESORDER." AND debtor_no=".$customer;

	return combo_input($name, $selected_id, $sql, 'order_no', 'name',
		array(
            'spec_option'=> $spec_opt===true?_("Select Sales Order") : $spec_opt,
			'select_submit'=> $submit_on_change,
		));
}

function customer_order_list_cells($label, $name, $selected_id=null, $customer=0, 
	$submit_on_change=false, $spec_opt=false){
	
	if ($label != null)
		echo "<td>$label</td>\n";
	
	echo "<td>\n";
	echo customer_order_list($name, $selected_id, $customer, $submit_on_change, $spec_opt);
	echo "</td>\n";
}

function customer_order_list_row($label, $name, $selected_id=null, $customer=0, 
	$submit_on_change=false, $spec_opt=false){
	echo "<tr><td>$label</td>";
	customer_order_list_cells(null, $name, $selected_id, $customer, $submit_on_change, $spec_opt);
	echo "</tr>\n";	
}

function complaint_type_list($name, $selected_id=null, $inactive=false, $submit_on_change=false,  
	$spec_opt=false){
	
	$sql = "SELECT id, complaint_type AS name FROM ".TB_PREF."complaint_types";
	if(!$inactive)
		$sql .= " WHERE !inactive";

	return combo_input($name, $selected_id, $sql, 'id', 'name',
		array(
            'spec_option'=> $spec_opt===true?_("Select Complaint Type") : $spec_opt,
			'select_submit'=> $submit_on_change,
		));
}

function complaint_type_list_cells($label, $name, $selected_id=null, $inactive=false, 
	$submit_on_change=false, $spec_opt=false){
	
	if ($label != null)
		echo "<td>$label</td>\n";
	
	echo "<td>\n";
	echo complaint_type_list($name, $selected_id, $inactive, $submit_on_change, $spec_opt);
	echo "</td>\n";
}

function complaint_type_list_row($label, $name, $selected_id=null, $inactive=false, 
	$submit_on_change=false, $spec_opt=false){
	echo "<tr><td>$label</td>";
	complaint_type_list_cells(null, $name, $selected_id, $inactive, $submit_on_change, $spec_opt);
	echo "</tr>\n";	
}

function generic_list($name, $options=array(), $selected_id=null, $spec_opt=false, $submit_on_change=false){
	
	$items = array();
	if($spec_opt)
	    $items[0] = $spec_opt === true ? _("All") : $spec_opt;
	
	for($i=1; $i<=count($options); $i++){
	    $items[$i] = $options[$i-1];
	}

	return array_selector($name, $selected_id, $items, 
		array( 
			'select_submit'=> $submit_on_change,
			'async' => false ) ); // FIX?
}

function generic_list_cells($label, $name, $options=array(), 
    $selected_id=null, $spec_opt=false, $submit_on_change=false){
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo generic_list($name, $options, $selected_id, 
	$spec_opt, $submit_on_change);
	echo "</td>\n";
}

function generic_list_row($label, $name, $options=array(), 
    $selected_id=null, $spec_opt=false, $submit_on_change=false){
	echo "<tr><td class=''>$label</td>";
	generic_list_cells(null, $name, $options, $selected_id, 
	$spec_opt, $submit_on_change);
	echo "</tr>\n";
}

function branches_list($name, $selected_id=null, $inactive=false,$customer_id=0,
    $spec_option=true, $submit_on_change=false){
        
	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language;

	$sql = "SELECT branch_code, IF(".$dropdown_language."='2', 
	IF(cb.br_ref_arabic = '',cb.branch_ref,cb.br_ref_arabic),cb.branch_ref) AS
	branch_ref
	FROM ".TB_PREF."cust_branch cb WHERE branch_code <> ''";
	if($customer_id){
	    $sql .= " AND debtor_no=".db_escape($customer_id);
	}
	if(!$inactive){
	    $sql .= " AND inactive=0";
	}

	return combo_input($name, $selected_id, $sql, 'branch_code', 'branch_ref',
		array(
			'spec_option' => $spec_option === true ? _("All Branches") : $spec_option,
			'select_submit'=> $submit_on_change
		) );
}

function crm_real_estate_list($name, $selected,  $no_option=false,  $submit_on_change=false)
{
	$items = array();
	$items[ST_BUYER] = 'Buyer';
	$items[ST_SELLER] = 'Seller';

	return array_selector($name, $selected, $items,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $no_option) );
}

function crm_real_estate_cells($label, $name, $selected, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo crm_real_estate_list($name, $selected,  $no_option, $submit_on_change);
	echo "</td>\n";
}

function crm_real_estate_row($label, $name, $selected,  $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo crm_real_estate_cells(null, $name, $selected,  $no_option, $submit_on_change);
	echo "</tr>\n";
}

function crm_looking_for_list($name, $selected,  $no_option=false,  $submit_on_change=false)
{
	global $looking_for;

	return array_selector($name, $selected, $looking_for,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $no_option) );
}

function crm_looking_for_cells($label, $name, $selected, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo crm_looking_for_list($name, $selected,  $no_option, $submit_on_change);
	echo "</td>\n";
}

function crm_looking_for_row($label, $name, $selected,  $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo crm_looking_for_cells(null, $name, $selected,  $no_option, $submit_on_change);
	echo "</tr>\n";
}


function crm_property_type_list($name, $selected,  $no_option=false,  $submit_on_change=false)
{
	global $property_type;

	return array_selector($name, $selected, $property_type,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $no_option) );
}

function crm_property_type_cells($label, $name, $selected, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo crm_property_type_list($name, $selected,  $no_option, $submit_on_change);
	echo "</td>\n";
}

function crm_property_type_row($label, $name, $selected,  $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo crm_property_type_cells(null, $name, $selected,  $no_option, $submit_on_change);
	echo "</tr>\n";
}

function crm_availability_type_list($name, $selected,  $exclude="", $no_option=false, $submit_on_change=false)
{
	global $availability_type;

	$items = $availability_type;

	if($exclude)
		unset($items[$exclude]);

	return array_selector($name, $selected, $items,
			array(	 'select_submit'=> $submit_on_change,
		    'spec_option' => $no_option) );
}

function crm_availability_type_cells($label, $name, $selected, $exclude="", $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo crm_availability_type_list($name, $selected, $exclude, $no_option, $submit_on_change);
	echo "</td>\n";
}

function crm_availability_type_row($label, $name, $selected, $exclude="", $no_option=false, $submit_on_change=false)
{	
	echo "<tr><td class=''>$label</td>";
	echo crm_availability_type_cells(null, $name, $selected, $exclude, $no_option, $submit_on_change);
	echo "</tr>\n";
}


function crm_payment_reference_list($name, $selected,  $no_option=false,  $submit_on_change=false)
{
	global $payment_pref;

	return array_selector($name, $selected, $payment_pref,
			array(	 'select_submit'=> $submit_on_change,
					 'spec_option' => $no_option) );
}

function crm_payment_reference_cells($label, $name, $selected, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo crm_payment_reference_list($name, $selected,  $no_option, $submit_on_change);
	echo "</td>\n";
}

function crm_payment_reference_row($label, $name, $selected,  $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo crm_payment_reference_cells(null, $name, $selected,  $no_option, $submit_on_change);
	echo "</tr>\n";
}



function crm_offer_type_list($name, $selected,  $no_option=false,  $submit_on_change=false)
{
	global $offer_type;

	return array_selector($name, $selected, $offer_type,
			array(	 'select_submit'=> $submit_on_change,
					 'spec_option' => $no_option) );
}

function crm_offer_type_cells($label, $name, $selected, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo crm_offer_type_list($name, $selected,  $no_option, $submit_on_change);
	echo "</td>\n";
}

function crm_offer_type_row($label, $name, $selected,  $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo crm_offer_type_cells(null, $name, $selected,  $no_option, $submit_on_change);
	echo "</tr>\n";
}


function crm_financial_status_list($name, $selected,  $no_option=false,  $submit_on_change=false)
{
	global $financial_status;

	return array_selector($name, $selected, $financial_status,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $no_option) );
}

function crm_financial_status_cells($label, $name, $selected, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo crm_financial_status_list($name, $selected,  $no_option, $submit_on_change);
	echo "</td>\n";
}

function crm_financial_status_row($label, $name, $selected,  $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo crm_financial_status_cells(null, $name, $selected,  $no_option, $submit_on_change);
	echo "</tr>\n";
}

function get_agreements_list($name, $selected_id=null, $submit_on_change=false, $spec_opt=false){
	
	$sql = "SELECT id, title AS name FROM ".TB_PREF."agreements";

	return combo_input($name, $selected_id, $sql, 'id', 'name',
		array(
	        'spec_option'=> $spec_opt===true?_("Select Agreement") : $spec_opt,
			'select_submit'=> $submit_on_change,
		));
}

function get_agreements_list_cells($label, $name, $selected_id=null,  
	$submit_on_change=false, $spec_opt=false){
	
	if ($label != null)
		echo "<td>$label</td>\n";
	
	echo "<td>\n";
	echo get_agreements_list($name, $selected_id, $submit_on_change, $spec_opt);
	echo "</td>\n";
}

function get_agreements_list_row($label, $name, $selected_id=null,  
	$submit_on_change=false, $spec_opt=false){
	echo "<tr><td>$label</td>";
	get_agreements_list_cells(null, $name, $selected_id, $submit_on_change, $spec_opt);
	echo "</tr>\n";	
}

//------------------------------------------------------------------------------------------


function source_record_list($name, $selected_id=null, $submit_on_change=false, $spec_opt=''){
	$data = array();
	$sql = "SELECT id, source_record AS name FROM ".TB_PREF."source_record";
	$result = db_query($sql);

	while($row = db_fetch($result)){
			$data[$row['id']] =  $row['name'];
	}
	return array_selector($name, $selected, $data,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $spec_opt) );
}

function source_record_list_cells($label, $name, $selected_id=null,  
	$submit_on_change=false, $spec_opt=''){
	
	if ($label != null)
		echo "<td>$label</td>\n";
	
	echo "<td>\n";
	echo source_record_list($name, $selected_id, $submit_on_change, $spec_opt);
	echo "</td>\n";
}

function source_record_list_row($label, $name, $selected_id=null,  
	$submit_on_change=false, $spec_opt=''){
	echo "<tr><td>$label</td>";
	source_record_list_cells(null, $name, $selected_id, $submit_on_change, $spec_opt);
	echo "</tr>\n";	
}

//---------------------------------------------------------------------------------------------

function crm_looking_type_list($name, $selected,  $no_option=false,  $submit_on_change=false)
{
	global $looking_type;

	return array_selector($name, $selected, $looking_type,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $no_option) );
}

function crm_looking_type_cells($label, $name, $selected, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo crm_looking_type_list($name, $selected,  $no_option, $submit_on_change);
	echo "</td>\n";
}

function crm_looking_type_row($label, $name, $selected,  $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo crm_looking_type_cells(null, $name, $selected,  $no_option, $submit_on_change);
	echo "</tr>\n";
}


//---------------------------------------------------------------------------------------------

function crm_serious_client_list($name, $selected,  $no_option=false,  $submit_on_change=false)
{
	global $serious_client;

	return array_selector($name, $selected, $serious_client,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $no_option) );
}

function crm_serious_client_cells($label, $name, $selected, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo crm_serious_client_list($name, $selected,  $no_option, $submit_on_change);
	echo "</td>\n";
}

function crm_serious_client_row($label, $name, $selected,  $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo crm_serious_client_cells(null, $name, $selected,  $no_option, $submit_on_change);
	echo "</tr>\n";
}


//------------------------------------------------------------------------------------------------

function security_roles_agreements_list($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{

	$sql = "SELECT id, role, inactive FROM ".TB_PREF."agreements_modules";

	return combo_input($name, $selected_id, $sql, 'id', 'description',
		array(
			'spec_option'=>$new_item ? _("New role") : false,
			'spec_id' => '',
			'select_submit'=> $submit_on_change,
			'show_inactive' => $show_inactive
		) );
}

function security_roles_agreements_list_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo security_roles_agreements_list($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</td>\n";
}

function security_roles_agreements_list_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	echo "<tr><td class=''>$label</td>";
	security_roles_agreements_list_cells(null, $name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</tr>\n";
}

//--------------------------------------------------------------------------------------------------
function get_opportunity_list($name, $selected_id=null, $submit_on_change=false, $spec_opt=false){
	
	$sql = "SELECT proj_id, proj_name AS name FROM ".TB_PREF."projects WHERE status = 2" ;

	return combo_input($name, $selected_id, $sql, 'proj_id', 'proj_name',
		array(
	        'spec_option'=> $spec_opt===true?_("Select Opportunity") : $spec_opt,
			'select_submit'=> $submit_on_change,
		));
}

function get_opportunity_list_cells($label, $name, $selected_id=null,  
	$submit_on_change=false, $spec_opt=false){
	
	if ($label != null)
		echo "<td>$label</td>\n";
	
	echo "<td>\n";
	echo get_opportunity_list($name, $selected_id, $submit_on_change, $spec_opt);
	echo "</td>\n";
}

function get_opportunity_list_row($label, $name, $selected_id=null,  
	$submit_on_change=false, $spec_opt=false){
	echo "<tr><td>$label</td>";
	get_opportunity_list_cells(null, $name, $selected_id, $submit_on_change, $spec_opt);
	echo "</tr>\n";	
}


//================================================



function new_existing_person($name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	$return = array( 
		 _("New Contact Person"),
		 _("Existing Contact Person")
	);
	return array_selector($name, $selected_id, $return, 
		array( 
			'spec_option' =>  false,
			'select_submit'=> $submit_on_change,
			'async' => false ) ); 
}

function new_existing_person_cells($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false, $all_option=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo new_existing_person($name, $selected_id, $new_item, $submit_on_change, $show_inactive, $all_option);
	echo "</td>\n";
}

function new_existing_person_row($label, $name, $selected_id=null, $new_item=false, $submit_on_change=false,
	$show_inactive = false)
{
	echo "<tr><td class=''>$label</td><td>";
	echo new_existing_person($name, $selected_id, $new_item, $submit_on_change, $show_inactive);
	echo "</td></tr>\n";
}


//--------------------------------------------------------------------------------------------------crm_source_list

function contact_person($name, $selected_id=null, $submit_on_change=false){


	$sql = "SELECT  cust_id, cont_per FROM ".TB_PREF."crm_contact_form ";
	


	return combo_input($name, $selected_id, $sql,'cust_id','cont_per', 
		array(
			'select_submit'=> $submit_on_change,
			 
		) );
}

function contact_person_cells($label, $name, $selected_id=null, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo contact_person($name, $selected_id, $submit_on_change);
	echo "</td>\n";
}

function contact_person_row($label, $name, $selected_id=null, $submit_on_change=false ){
	echo "<tr><td class=''>$label</td><td>";
	echo contact_person($name, $selected_id, $submit_on_change);
	echo "</td></tr>\n";
}




//-----------------------------------------------------------------------------------------------

function item_multi($name, $all=false, $spec_opt = false, $item_type = null)
{
	$sql = "SELECT * FROM ".TB_PREF."stock_master 
	WHERE inc_crm = 1 
	AND inactive = 0 ";	
	if($item_type)
		$sql .= " AND inq_type LIKE '%".$item_type."%'";
	$result = db_query($sql);
	
	global $Ajax;
	$Ajax->activate($name);

	while ($row = db_fetch($result))
		$items[$row['stock_id']] = $row['description'];

	return array_selector($name, null, $items,
		array(
			'spec_option'=> $spec_opt,
			'spec_id' => -1,
		),2 );

}

function item_multi_cells($label, $name, $all=false, $spec_opt = false,  $item_type = null)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo item_multi($name, $all, $spec_opt, $item_type);
	echo "</td>\n";
	
}

function item_multi_row($label, $name, $all=false, $spec_opt = false, $item_type = null)
{
	echo "<tr><td class=''>$label</td>";
	item_multi_cells(null, $name, $all, $spec_opt, $item_type);
	echo "</tr>\n";	
}


//------------------------------------------------------------------------------------

function inquiry_type_list($name, $selected_id=null, $submit_on_change=false, $spec_opt=''){
	$data = array();
	$sql = "SELECT id, inquiry_type AS name FROM ".TB_PREF."inquiry_type";
	$result = db_query($sql);

	while($row = db_fetch($result)){
			$data[$row['id']] =  $row['name'];
	}
	return array_selector($name, $selected, $data,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $spec_opt) );
}

function inquiry_type_list_cells($label, $name, $selected_id=null,  
	$submit_on_change=false, $spec_opt=''){
	
	if ($label != null)
		echo "<td>$label</td>\n";
	
	echo "<td>\n";
	echo inquiry_type_list($name, $selected_id, $submit_on_change, $spec_opt);
	echo "</td>\n";
}

function inquiry_type_list_row($label, $name, $selected_id=null,  
	$submit_on_change=false, $spec_opt=''){
	echo "<tr><td>$label</td>";
	inquiry_type_list_cells(null, $name, $selected_id, $submit_on_change, $spec_opt);
	echo "</tr>\n";	
}

function multi_inquiry_type($name, $height, $type, $multi=false, $all=false, $spec_opt = false){
	
	$sql = "SELECT id, inquiry_type AS name FROM ".TB_PREF."inquiry_type";
	$result = db_query($sql);

	while($row = db_fetch($result)){
			$data[$row['id']] =  $row['name'];
	}

	return array_selector($name, null, $data,
		array(
			'multi' => $multi,
			'height' => $height,
			'spec_option'=> $spec_opt,
			'spec_id' => -1,
		),2 );
}

function multi_inquiry_cells($label, $name, $height, $type, $mult=false, $all=false, $spec_opt = false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>\n";
	echo multi_inquiry_type($name, $height, $type, $mult, $all, $spec_opt);
	echo "</td>\n";
	
}

function multi_inquiry_row($label, $name, $height, $type, $mult=false, $all=false, $spec_opt = false)
{
	echo "<tr><td class=''>$label</td>";
	multi_inquiry_cells(null, $name, $height, $type, $mult, $all, $spec_opt);
	echo "</tr>\n";	
}


function schedule_types_list($name, $selected_id=null, $submit_on_change=false, $spec_opt=false){
	global $schedule_type;

	return array_selector($name, null, $schedule_type, 
	array('spec_option' => $spec_option === true ? "Select Type" : $spec_opt, 'select_submit' => $submit_on_change));
}

function schedule_types_list_cells($label, $name, $selected_id=null, $submit_on_change=false, $spec_opt=false){
	
	if($label)
		echo "<td class=''>$label</td>";

	echo "<td>";
	echo schedule_types_list($name, $selected_id, $submit_on_change, $spec_opt);
	echo "</td>";
}
function schedule_types_list_row($label, $name, $selected_id=null, $submit_on_change=false, $spec_opt=false){
	echo "<tr>";
	schedule_types_list_cells($label, $name, $selected_id, $submit_on_change, $spec_opt);
	echo "</tr>\n";
}

function technician_list($name, $selected_id=null, $spec_opt=false, $submit_on_change=false, $filter_params = array()){

	$sql = "SELECT id, name, inactive FROM ".TB_PREF."technician";
	if(count($filter_params)){
		$sql_time = "SELECT technician FROM ".TB_PREF."schedules WHERE date=".db_escape(date2sql($filter_params['date']))." 
		AND ( (".db_escape($filter_params['start_time'])." BETWEEN start_time AND end_time) OR 
		(".db_escape($filter_params['end_time'])." BETWEEN start_time AND end_time) OR 
		(".db_escape($filter_params['start_time'])."<=start_time AND ".db_escape($filter_params['end_time']).">=end_time) )"; 

		if($filter_params['src_id'])
			$sql_time .= " AND id!=".$filter_params['src_id'];
		
		$sql .= " WHERE id NOT IN (".$sql_time.")";
	}
	return combo_input($name, $selected_id, $sql, 'id', 'name', 
	array('spec_option' => $spec_option === true ? "Select Type" : $spec_opt, 'select_submit' => $submit_on_change));
}

function technician_list_cells($label, $name, $selected_id=null, $spec_opt=false, $submit_on_change=false, $filter_params = array()){

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo technician_list($name, $selected_id, $spec_opt, $submit_on_change, $filter_params);
	echo "</td>\n";
}

function technician_list_row($label, $name, $selected_id=null, $spec_opt=false, $submit_on_change=false){

	echo "<tr><td class=''>$label</td>";
	technician_list_cells(null, $name, $selected_id, $spec_opt, $submit_on_change);
	echo "</tr>\n";
}

function frequency_list($name, $selected_id=null, $submit_on_change=false, $spec_opt=false){
	global $frequency_list;

	return array_selector($name, null, $frequency_list, 
	array('spec_option' => $spec_option === true ? "Select Type" : $spec_opt, 'select_submit' => $submit_on_change));
}

function frequency_list_cells($label, $name, $selected_id=null, $submit_on_change=false, $spec_opt=false){
	
	if($label)
		echo "<td class=''>$label</td>";

	echo "<td>";
	echo frequency_list($name, $selected_id, $submit_on_change, $spec_opt);
	echo "</td>";
}
function frequency_list_row($label, $name, $selected_id=null, $submit_on_change=false, $spec_opt=false){
	echo "<tr>";
	frequency_list_cells($label, $name, $selected_id, $submit_on_change, $spec_opt);
	echo "</tr>\n";
}

function kit_items_list($name, $selected_id=null, $all_option=false, 
	$submit_on_change=false, $main_item=""){
	    
	$sql = "SELECT s.stock_id, s.description as description, s.inactive 
	FROM ".TB_PREF."item_links AS il 
	LEFT JOIN ".TB_PREF."stock_master AS s ON s.stock_id=il.link_item 
	WHERE s.mb_flag != 'F' ";

	if($main_item)
			$sql .= " AND il.item=".db_escape($main_item); 
    
	$sql .= " AND !s.inactive AND !s.no_sale";

	return combo_input($name, $selected_id, $sql, 's.stock_id', 's.description',
	array(  'spec_option' => $all_option===true ?  _("All Items") : $all_option,
		    'spec_id' => ALL_TEXT,
			'select_submit'=> $submit_on_change));
}

function kit_items_list_cells($label, $name, $selected_id=null, $all_option=false, $submit_on_change=false, $main_item=""){

	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo kit_items_list($name, $selected_id, $all_option, $submit_on_change, $main_item);
	echo "</td>";
}

// -----------------------------------------------------------------------------

function item_spec_list_cells($label, $name, $selected_id=null, $item=""){

    $list = array();
    
    $sql = "SELECT * FROM ".TB_PREF."item_specs WHERE inactive=0 
    AND item_code=".db_escape($item);
    $res = db_query($sql);
    
    while($row = db_fetch($res)){
        $list[$row['id']] = $row['spec'].": ".$row['value'];
    }		
    
    if($label)
        label_cell($label);
        
    echo "<td>";
    echo "<textarea class='textarea form-control' name='spec_description' cols='10' rows='10'"
	.($title ? " title='$title'" : '')
	.">".$_POST['spec_description']."</textarea>";
    echo array_selector($name, $selected_id, $list, 
    array('async' => false ), 2);
    echo "</td>";
}



//---------------------------------------------------------------------------------------------

function item_specification_titles_list($name, $selected,  $no_option=false,  $submit_on_change=false)
{
	$return = array(
		'Filter Capacity' => 'Filter Capacity',
		'Filtration Stage' => 'Filtration Stage',
		'Stage 1' => 'Stage 1',
		'Stage 2' => 'Stage 2',
		'Stage 3' => 'Stage 3',
		'Stage 4' => 'Stage 4',
		'Stage 5' => 'Stage 5',
		'Stage 6' => 'Stage 6',
		'Stage 7' => 'Stage 7',
		'Stage 8' => 'Stage 8',
		'Storage Tank' => 'Storage Tank',
		'Cooling Capacity' => 'Cooling Capacity',
		'Taps' => 'Taps',
		'Water Temprature' => 'Water Temprature'
	);

	return array_selector($name, $selected, $return,
			array(	 'select_submit'=> $submit_on_change,
					'spec_option' => $no_option) );
}

function item_specification_titles_cells($label, $name, $selected, $no_option=false, $submit_on_change=false)
{
	if ($label != null)
		label_cell($label);
	echo "<td>\n";
	echo item_specification_titles_list($name, $selected,  $no_option, $submit_on_change);
	echo "</td>\n";
}

function item_specification_titles_row($label, $name, $selected,  $no_option=false, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	echo item_specification_titles_cells(null, $name, $selected,  $no_option, $submit_on_change);
	echo "</tr>\n";
}



//---------------------------------------------------------------------------------------------------

function order_line_list($name, $selected_id=null, $submit_on_change=false, $order_no=null, $exclude_lines=array())
{
 
	$sql = " SELECT line.id, so.reference as description FROM ".TB_PREF."sales_orders as so
			 LEFT JOIN ".TB_PREF."sales_order_details as line
			 ON so.order_no = line.order_no AND so.trans_type = line.trans_type 
			 WHERE so.trans_type = ".db_escape(ST_SALESORDER);
	if($order_no)
		$sql .= " AND so.order_no = ".db_escape($order_no);

	$sql .= " GROUP BY so.order_no ";
 
	return combo_input($name, $selected_id, $sql, 'id', 'description',
		array(
			'select_submit'=> $submit_on_change,
			'async' => false,
			'spec_id' => 0,
			'spec_option' => _("Select Order"),

		) );
}

function order_line_list_cells($label, $name, $selected_id=null, $submit_on_change=null, $order_no=null, $exclude_lines=array())
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo order_line_list($name, $selected_id, $submit_on_change, $order_no, $exclude_lines);
	echo "</td>\n";
}

function order_line_list_row($label, $name, $selected_id=null, $submit_on_change=null, $order_no=null, $exclude_lines=array())
{
	echo "<tr><td class=''>$label</td>";
	order_line_list_cells(null, $name, $selected_id, $submit_on_change, $order_no, $exclude_lines);
	echo "</tr>\n";
}


//-----------------------------------------------------------------------------------------------------------------
 
function trans_approval_list($name, $value=null, $spec_opt=false, $submit_on_change=false)
{
	global $trans_approval_status;
 
	return array_selector($name, $value, $trans_approval_status, 
		array( 
			'spec_option'=> $spec_opt,
			'spec_id' => ALL_NUMERIC,
			'select_submit'=> $submit_on_change,
			'async' => false,
			)
	);
}

function trans_approval_list_cells($label, $name, $value=null, $submit_on_change=false)
{
	if ($label != null)
		echo "<td>$label</td>\n";
	echo "<td>";
	echo trans_approval_list($name, $value, false, $submit_on_change);
	echo "</td>\n";
}

function trans_approval_list_row($label, $name, $value=null, $submit_on_change=false)
{
	echo "<tr><td class=''>$label</td>";
	trans_approval_list_cells(null, $name, $value, $submit_on_change);
	echo "</tr>\n";
}


?>




