<?php

function display_error($msg, $center=true)
{
	trigger_error($msg, E_USER_ERROR);
}

function display_notification($msg, $center=true)
{
	trigger_error($msg, E_USER_NOTICE);
}

function display_warning($msg, $center=true)
{
	trigger_error($msg, E_USER_WARNING);
}

function display_notification_centered($msg)
{
	display_notification($msg, true);
}

function display_caption($msg)
{
	echo "<caption>$msg</caption>\n";
}

function display_message($msg)
{
	echo "<div style='background: #efebeb;width: 40%;margin-left: 3px;position: absolute;top: 7px;padding-bottom: 4px;'>
	$msg
				</div>\n";
}

function display_heading($msg,$styling='')
{
	echo "<center><span $styling class='headingtext'>$msg</span></center>\n";	
}

function display_heading2($msg,$styling='')
{
	echo "<center><span $styling class='headingtext2'>$msg</span></center>\n";	
}

function display_note($msg, $br=0, $br2=0, $extra="")
{
	for ($i = 0; $i < $br; $i++)
		echo "<br>";
	if ($extra != "")	
		echo "<center><span $extra>$msg</span></center>\n";	
	else	
		echo "<center><span>$msg</span></center>\n";	
	for ($i = 0; $i < $br2; $i++)
		echo "<br>";
}

function stock_item_heading($stock_id)
{
	if ($stock_id != "") 
	{
		$result = db_query("SELECT description, units FROM ".TB_PREF."stock_master WHERE stock_id=".db_escape($stock_id));
        $myrow = db_fetch_row($result);
        
    	display_heading("$stock_id - $myrow[0]"); 
    	$units = $myrow[1];
    	display_heading2(_("in units of : ") . $units);        	
	}
}

// pk
function amount_row_new($label, $name, $init=null, $params=null, $post_label=null, $dec=null)
{
	echo "<tr>";
	amount_cells_new($label, $name, $init, $params, $post_label, $dec);
	echo "</tr>\n";
}
function amount_cells_new($label, $name, $init=null, $params=null, $post_label=null, $dec=null)
{
	amount_cells_ex_new($label, $name, 15, 15, $init, $params, $post_label, $dec);
}

function amount_cells_ex_new($label, $name, $size, $max=null, $init=null, $params=null, $post_label=null, $dec=null)
{
	global $Ajax;

	if (!isset($dec))
	  	$dec = user_price_dec();
	if (!isset($_POST[$name]) || $_POST[$name] == "")
	{
		if ($init !== null)
			$_POST[$name] = $init;
		else
			$_POST[$name] = '';
	}
	if ($label != null)
	{
		if ($params == null)
			$params = "class=''";
		label_cell($label, $params);
	}
	if (!isset($max))
		$max = $size;

	if ($label != null)
		echo "<td>";
	else
		echo "<td align='right'>";
	echo "<div class='input-group field-width'>";
	echo "<input class='amount form-control' type=\"text\" name=\"$name\" size=\"$size\" maxlength=\"$max\" dec=\"$dec\" value=\"" . $_POST[$name]. "\"readonly>";
	echo "</div>";

	if ($post_label) {
		echo "<span id='_{$name}_label'> $post_label</span>";
		$Ajax->addUpdate($name, '_'.$name.'_label', $post_label);
	}
	echo "</td>\n";
	$Ajax->addUpdate($name, $name, $_POST[$name]);
	$Ajax->addAssign($name, $name, 'dec', $dec);
}