<?php

//-------------------------------------------------------------------------------------------------------------
function getmaxID()
{
	$sql = "SELECT MAX(Id) as id FROM ".TB_PREF."payroll_transaction";
	$result = db_query($sql, "There is no record found");

	$data = db_fetch($result);

	return $data['id'];
}
function add_attendance_mark($Items, $emp_id, $memo_)
{
	
	global $SysPrefs, $path_to_root, $Refs;

	$transfer_id = getmaxID();
	foreach ($Items as $line_item)
	{

	if($line_item->ot==""){
	$ot=0;
	$ot_factor=0;
 		add_attendance_mark_item($line_item->hrs,$line_item->dim,$line_item->attn_date,$ot,$ot_factor,$emp_id,$memo_);

}
else{
add_attendance_mark_item($line_item->hrs,$line_item->dim,$line_item->attn_date,$line_item->ot,$line_item->ot_factor,$emp_id,$memo_);
}
	}


	
	
	

	return $transfer_id;
}


function add_stock_transfer_item($transfer_id, $stock_id, $location_from, $location_to,
	$date_, $reference, $quantity,$item_description, $item_color, $grading)
{
	// display_error($grading);
	// die;
	 // $std_cost, $price=0,$consignment_ref=null,$debtor_no=null,$branch_no=0,$description=null,
	add_stock_move(ST_LOCTRANSFER, $stock_id, $transfer_id, $location_from,
       	$date_, $reference, -$quantity, 0,null,null,null,null,$item_description);  

	add_stock_move(ST_LOCTRANSFER, $stock_id, $transfer_id, $location_to,
	   	$date_, $reference, $quantity, 0,null,null,null,null,$item_description);

}


function add_stock_transfer($Items, $location_from, $location_to, $date_, $reference, $memo_,$consignment_ref=null, $item_color=null, $grading=null,$fixed_asset=0)
{
	global $SysPrefs, $path_to_root, $Refs;
	begin_transaction();
	$args = func_get_args();
	$args = (object)array_combine(array('Items', 'location_from', 'location_to', 
	'date_', 'reference', 'memo_'), $args);
	$args->trans_no = 0;
	hook_db_prewrite($args, ST_LOCTRANSFER);

	$transfer_id = get_next_trans_no(ST_LOCTRANSFER);

	if ($SysPrefs->loc_notification() == 1)
	{
		include_once($path_to_root . "/inventory/includes/inventory_db.inc");
		$st_ids = array();
		$st_names = array();
		$st_num = array();
		$st_reorder = array();
	}
	foreach ($Items as $line_item)
	{

		if ($SysPrefs->loc_notification() == 1)
			$loc = calculate_reorder_level($location_from, $line_item, $st_ids, $st_names, $st_num, $st_reorder); 
		add_stock_transfer_item($transfer_id, $line_item->stock_id, $location_from,
			$location_to, $date_, $reference, $line_item->quantity,$line_item->item_description);
	}

	add_comments(ST_LOCTRANSFER, $transfer_id, $date_, $memo_);

	$Refs->save(ST_LOCTRANSFER, $transfer_id, $reference);
	if ($fixed_asset) {
	add_audit_trail(ST_INVADJUST, $transfer_id, $date_, 'FA Inventory Transfered');
	}else{	
	add_audit_trail(ST_INVADJUST, $transfer_id, $date_, 'Inventory Transfered');
	}

	$args->trans_no = $transfer_id;
	hook_db_postwrite($args, ST_LOCTRANSFER);

	commit_transaction();
	
	if ($SysPrefs->loc_notification() == 1 && count($st_ids) > 0)
		send_reorder_email($loc, $st_ids, $st_names, $st_num, $st_reorder);

	return $transfer_id;
}

//-------------------------------------------consignment transfer---------------------------------------------
//-------------------------------------------------------------------------------------------------------------


function add_attendance_mark_item($hrs,$dim,$attn_date,$ot,$ot_factor,$emp_id,$memo_)
{
	$doc_type = 107;
	insert_attendance_items($doc_type, $hrs,$dim,$attn_date,$ot,$ot_factor,$emp_id,$memo_);
}
function insert_attendance_items($doc_type, $hrs,$dim,$attn_date,$ot,$ot_factor,$emp_id,$memo_)
{
	$tdate = date('Y-m-d');
	$sql = "INSERT INTO ".TB_PREF."payroll_transaction (doc_type,hrs,dim,over_time,ot_factor_id,eid,att_ot_date,remarks,trans_date) 
	VALUES ("
		.db_escape($doc_type).", ".db_escape($hrs).",".db_escape($dim).",".db_escape($ot).",".db_escape($ot_factor).","
		.db_escape($emp_id).", ".db_escape(date2sql($attn_date)).",".db_escape($memo_).",".db_escape($tdate).")";

	db_query($sql, "The stock movement record cannot be inserted");

	 $id = db_insert_id();
	 if ($sql != null)
		add_audit_trail(ST_ATTENDANCE, $id,date('d/m/Y'), "Insert Mark Attendance");	
		commit_transaction();
	return db_insert_id();
}


//-------------------------------------------------------------------------------------------------------------
//
//	Get inventory transfer common data (currently this is still stored in stock_moves table).
//
function get_stock_transfer($trans_no)
{
	// retrieve common data from any two from/to move records
	$sql = "SELECT loc_from.*, loc_to.*
		FROM
			(SELECT trans_no, type, tran_date, reference, move.loc_code as from_loc, loc.location_name as from_name , move.stock_id
			FROM ".TB_PREF."stock_moves move
				LEFT JOIN ".TB_PREF."locations loc ON loc.loc_code=move.loc_code
			WHERE type=".ST_LOCTRANSFER." AND trans_no=".db_escape($trans_no). " AND qty<0 LIMIT 1) loc_from,

			(SELECT move.loc_code as to_loc, loc.location_name as to_name
			FROM ".TB_PREF."stock_moves move
				LEFT JOIN ".TB_PREF."locations loc ON loc.loc_code=move.loc_code
			WHERE type=".ST_LOCTRANSFER." AND trans_no=".db_escape($trans_no). " AND qty>0 LIMIT 1) loc_to";
// display_error($sql);
	$result = db_query($sql, "Could not get transfer common data");

	$data = db_fetch($result);

	return $data;
}

//-------------------------------------------------------------------------------------------------------------

function get_stock_transfer_items($trans_no)
{
	$result = get_stock_moves(ST_LOCTRANSFER, $trans_no);

	if (db_num_rows($result) == 0)
	{
		return null;
	}

	return $result;
}

//-------------------------------------------------------------------------------------------------------------

function void_stock_transfer($type_no)
{
	hook_db_prevoid(ST_LOCTRANSFER, $type_no);
	void_stock_move(ST_LOCTRANSFER, $type_no);
}