<?php

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/ui/items_cart.inc");

//--------------------------------------------------------------------------------

function add_to_order(&$order, $new_item, $new_item_qty, $standard_cost,
    $item_specs=array())
{
    if ($order->find_cart_item($new_item))
         display_error(_("For Part :") . $new_item . " " . "This item is already on this document. You can change the quantity on the existing line if necessary.");
	else
         $order->add_to_cart (count($order->line_items), $new_item, $new_item_qty, $standard_cost, null, $item_specs);
}

//--------------------------------------------------------------------------------

function display_order_header(&$order)
{
	global $Refs;

	start_outer_table(TABLESTYLE2, "width:70% !important;"); // outer table
	table_section(1);

	locations_list_row(_("Location:"), 'StockLocation', null, false, false, $order->fixed_asset);
    date_row(_("Date:"), 'AdjDate', '', true);

	table_section(2, "50%");

	ref_row(_("Reference:"), 'ref', '', $Refs->get_next(ST_INVADJUST, null, array('location'=>get_post('StockLocation'), 'date'=>get_post('AdjDate'))),
		 false, ST_INVADJUST);
	if (!isset($_POST['Increase']))
    	$_POST['Increase'] = 1;
	yesno_list_row(_("Type:"), 'Increase', $_POST['Increase'],
    	_("Positive Adjustment"), _("Negative Adjustment"));
	
	check_cells(_("Import Csv:"), 'csv_check', null, true);	 

	end_outer_table(1); // outer table
}

function display_csv_import(&$order){

	div_start('renew_table');
	start_table(TABLESTYLE5_BOX,"",0,0,0,null,"30%","1px solid #2CABE3;");
	$th = array("",_("Import CSV"));
    table_header($th);

    $filepath=$path_to_root."..\modules\import_items\import_file\items_adjustment.csv";
    label_row('Download CSV',_("<a href='$filepath'download style='font-size: 17;'><span><img style='width: 35px;' src='../themes/synergy-purple/images/excel.png'> &nbsp;&nbsp;  </span>             </a>"));
    $html ='<div class="file-upload"  >
                    <div class="file-select"  >
                      <div class="btn file-select-button" id="fileName" style="border-radius:2px solid;     color: white;  width:100%; font-size: 12;" ><span>   Choose   <span></div>
                          <input type="file" name="imp" id="imp">
                        </div>
                      <div class="file-select-name" id="noFile"></div> 
                      </div>';
    label_row("Import CSV File:", "$html");    
	end_table();
	br();
	echo "<center>";
	submit_center_first('import', "Import CSV File",'','default');
	echo "</center>";

    div_end();
    br();
}

//---------------------------------------------------------------------------------

function display_adjustment_items($title, &$order)
{
	global $path_to_root;

			// echo '<span style="float:left; margin-right:-80px">';
	display_heading($title);
			// echo '</span>';
    div_start('items_table');
	start_table(TABLESTYLE, "style='width:100% !important;");

	if ($order->fixed_asset) {
		$th = array(_("Item Code"), _("Item Description"), _("Specification"), _("Quantity"),
		_("Unit"), _("Unit Cost"), _("Initial Value"), "");
	} else {
		$th = array(_("Item Code"), _("Item Description"), _("Specification"), 
		_("Quantity"),
		_("Unit"), _("Unit Cost"), _("Total"), "");
		if ( count($order->line_items)) $th[] = '';
	}
 //	if ( count($order->line_items)) $th[] = '';

	table_header($th);
	$total = 0;
	$k = 0;  //row colour counter

	$low_stock = $order->check_qoh($_POST['StockLocation'], $_POST['AdjDate']);
	$id = find_submit('Edit');
	foreach ($order->line_items as $line_no=>$stock_item)
	{

		$total += ($stock_item->standard_cost * $stock_item->quantity);

		if ($id != $line_no)
		{
			if (in_array($stock_item->stock_id, $low_stock))
				start_row("class='stockmankobg'");	// notice low stock status
			else 
				alt_table_row_color($k);
 
                 

             #image function dispalat image
			 // line_item_image($stock_item->stock_id, get_item_edit_info($stock_item->stock_id)["material_cost"],$stock_item->item_description,0);


    		if ($order->fixed_asset) 
				label_cell($stock_item->stock_id);
      		else
				view_stock_status_cell($stock_item->stock_id);

			label_cell($stock_item->item_description);
			label_cell(get_specs_for_ids($stock_item->item_specs));
    		qty_cell($stock_item->quantity, false, get_qty_dec($stock_item->stock_id));
			label_cell($stock_item->units);
			amount_decimal_cell($stock_item->standard_cost);

			if ($order->fixed_asset) {
    	   		$price = get_purchase_value($stock_item->stock_id);
				amount_cell($price);
      		} else
				amount_cell($stock_item->standard_cost * $stock_item->quantity);

      		if (!$order->fixed_asset) {
        		edit_button_cell("Edit$line_no", _("Edit"),	_('Edit document line'));
      		}
			delete_button_cell("Delete$line_no", _("Delete"), _('Remove line from document'));
			end_row();
		}
		else
		{
			adjustment_edit_item_controls($order, $line_no);
		}
	}

	if ($id == -1)
		adjustment_edit_item_controls($order);

	label_row(_("Total"), number_format2($total,user_price_dec()), "align=right colspan=6", "align=right", 2);

    end_table();
	if ($low_stock)
		display_note(_("Marked items have insufficient quantities in stock as on day of adjustment."), 0, 1, "class='stockmankofg'");
	div_end();
}

//---------------------------------------------------------------------------------

function adjustment_edit_item_controls(&$order, $line_no=-1)
{
	global $Ajax;
	start_row();

	$dec2 = 0;
	$id = find_submit('Edit');
	if ($line_no != -1 && $line_no == $id)
	{
		$_POST['stock_id'] = $order->line_items[$id]->stock_id;
		$_POST['item_specs'] = $order->line_items[$id]->item_specs;
		$_POST['qty'] = qty_format($order->line_items[$id]->quantity, 
			$order->line_items[$id]->stock_id, $dec);
		//$_POST['std_cost'] = price_format($order->line_items[$id]->standard_cost);
		$_POST['std_cost'] = price_decimal_format($order->line_items[$id]->standard_cost, $dec2);
		$_POST['units'] = $order->line_items[$id]->units;
          
		label_cell("");

		hidden('stock_id', $_POST['stock_id']);
		label_cell($_POST['stock_id']);
		label_cell($order->line_items[$id]->item_description, 'nowrap');
		item_spec_list_cells("", 'item_specs', null, $_POST['stock_id']);
	    $Ajax->activate('items_table');
	}
	else
	{
        label_cell("");
		if ($order->fixed_asset){
			echo '<span style="float:right; width:80%;margin-top: 0px;">';
			
			stock_disposable_fa_list_cells(null, 'stock_id', null, false, true, $order->line_items);
	echo '</span></br>' ;

		}
		else{
			echo '<span style="float:right; width:80%;margin-top: 0px;">';
			
			stock_costable_items_list_cells(null, 'stock_id', null, false, true);
	echo '</span></br>' ;

		}
		item_spec_list_cells("", 'item_specs', null, $_POST['stock_id']);

		if (list_updated('stock_id')) {
			    $Ajax->activate('units');
			    $Ajax->activate('qty');
			    $Ajax->activate('std_cost');
			    $Ajax->activate('std_cost_view');
			    $Ajax->activate('initial_price');
		}
            
    	$item_info = get_item_edit_info($_POST['stock_id']);
		$dec = $item_info['decimals'];
   		$_POST['qty'] = number_format2(0, $dec);
		$_POST['std_cost'] = price_decimal_format($item_info["material_cost"], $dec2);
		$_POST['units'] = $item_info["units"];
	}

	if ($order->fixed_asset) {
		hidden('qty', -1);
		qty_cell(1, false, 0);
	} else
		qty_cells(null, 'qty', $_POST['qty'], null, null, $dec);

	label_cell($_POST['units'], '', 'units');

	if ($order->fixed_asset) {
		/* TODO: check if this is a correct way of creating a fixed item
			that still has to be submitted in the form */ 
		hidden('std_cost');
		label_cell($_POST['std_cost'], "nowrap align=right ", 'std_cost_view');
		$price = get_purchase_value($_POST['stock_id']);
		amount_cell($price, false, '', 'initial_price');
	} else {
		//amount_cells(null, 'std_cost', $_POST['std_cost']);
		amount_cells(null, 'std_cost', null, null, null, $dec2);
		label_cell("&nbsp;");
	}

	if ($id != -1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
 		set_focus('qty');
	}
	else
	{
		submit_cells('AddItem', _("Add Item"), "colspan=2",
		    _('Add new item to document'), true);
	}

	end_row();
}


//---------------------------------------------------------------------------------

function adjustment_options_controls()
{
	  echo "<br>";
	  start_table();

	  textarea_row(_("Memo:&nbsp;&nbsp;&nbsp;"), 'memo_', null, 50, 3);

	  end_table(1);
}

?>
<style>

#myImg {
    border-radius: 5px;
    cursor: pointer;
    transition: 0.3s;
}

#myImg:hover {opacity: 2;}

/* The Modal (background) */
.modal {
    /*display: block;*/

    display: none; /* Hidden by default */
    position: fixed; /* Stay in place */
    z-index: 2; /* Sit on top */
    padding-top: 100px; /* Location of the box */
    left: 0;
    top: 10px;
    width: 100%; /* Full width */
    height: 100%; /* Full height */
    overflow: auto; /* Enable scroll if needed */
    background-color: rgb(0,0,0); /* Fallback color */
    background-color: rgba(0,0,0,0.9); /* Black w/ opacity */
}

/* Modal Content (image) */
.modal-content .adjustment {

    margin: auto;
    display: block;
    width: 50%;
    max-width: 400px;
}

/* Caption of Modal Image */
#caption {
    margin: auto;
    display: block;
    width: 80%;
    max-width: 700px;
    text-align: center;
    color: #ccc;
    padding: 10px 0;
    height: 150px;
}

/* Add Animation */
.modal-content, #caption {    
    -webkit-animation-name: zoom;
    -webkit-animation-duration: 0.6s;
    animation-name: zoom;
    animation-duration: 0.6s;
}

@-webkit-keyframes zoom {
    from {-webkit-transform:scale(0)} 
    to {-webkit-transform:scale(1)}
}

@keyframes zoom {
    from {transform:scale(0)} 
    to {transform:scale(1)}
}

/* The Close Button */
.close {
    position: absolute;
    top: 15px;
    right: 35px;
    color: #f1f1f1;
    font-size: 40px;
    font-weight: bold;
    transition: 0.3s;
}

.close:hover,
.close:focus {
    color: #bbb;
    text-decoration: none;
    cursor: pointer;
}

/* 100% Image Width on Smaller Screens */
@media only screen and (max-width: 700px){
    .modal-content {
        width: 100%;
    }
}


.zoom {
    padding: 50px;
    background-color: green;
    transition: transform .2s;
    width: 200px;
    height: 200px;
    margin: 0 auto;
}

.zoom:hover {
    -ms-transform: scale(1.3);  IE 9 
    -webkit-transform: scale(1.3); /* Safari 3-8 */
    transform: scale(1.3); 
}

#section1{

width:213px;
    /*padding: 0px 0px 0px 4px;*/
    /*margin: -30px 0px 0px 0px;*/
    font-size: 12px !important;
    float: left;
    /*text-decoration: underline;*/
    text-align: -webkit-auto;
    line-height: 20px;

}
#section2{

	width: 348px;
	/*padding: 3px 40px 0px 0px;*/
    /*margin: -30px 0px 0px 0px;*/
    font-size: 12px !important;
    float: left;
    /*text-decoration: underline;*/
    text-align: -webkit-auto;
    line-height: 20px;
    /*box-shadow: -6px 4px 11px -9px*/
        border-left: 2px solid #0e909d;

}
.divider {
  width: 2px;
  margin: 6px 0;
      background: #464c54;
    box-shadow: -5px 0px 0px 1px;
}
.divider h3{
    color: #464c54;
    font-weight: 900;
/*    text-decoration-line: underline;
    text-decoration-style: double;*/

}

</style>
