<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_SALESPRICE';

if (@$_GET['page_level'] == 1)
	$path_to_root = "../..";
else	
	$path_to_root = "../..";

include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/includes/ui.inc");
include($path_to_root . "/payroll/includes/ui/payroll_ui_controls.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/sales/includes/db/sales_types_db.inc");
include_once($path_to_root . "/includes/data_checks.inc");

include_once($path_to_root . "/inventory/includes/inventory_db.inc");

$js = "";
if ($SysPrefs->use_popup_windows && $SysPrefs->use_popup_search)
	$js .= get_js_open_window(900, 500);
page(_($help_context = "Inventory Item Sales prices"), false, false, "", $js);

//---------------------------------------------------------------------------------------------------

check_db_has_stock_items(_("There are no items defined in the system."));

check_db_has_sales_types(_("There are no sales types in the system. Please set up sales types befor entering pricing."));

simple_page_mode(true);
//---------------------------------------------------------------------------------------------------
$input_error = 0;

function get_trans_item_specification($id){

$sql="SELECT * from ".TB_PREF."item_specification where id = ".db_escape($id)." ";
$res= db_query($sql,"");
return db_fetch($res);
}


function get_specification($id=null, $spec_id=null)
{
	$sql="SELECT * from ".TB_PREF."specification where inactive =0 and deleted =0  ";
	if($id!=null)
		$sql.="AND id = ".db_escape($id)." ";
	// if($spec_id!=null)
	// 	$sql.="AND specification_id = ".db_escape($spec_id)." ";
$res= db_query($sql,"");
return $res;
}


function get_specification_name($id)
{
	$sql="SELECT specification_name from ".TB_PREF."specification where inactive =0 and deleted =0 AND id = ".db_escape($id)." ";
	
$res= db_query($sql,"");
$result=db_fetch($res);
return $result['specification_name'];
}

function add_item_specification($stock_id, $specification_id, $specification_detail_id )
{
// $col1=$col1?','.$col1:',s1';
// $col2=$col2?','.$col2:',s2';
// $col3=$col3?','.$col3:',s3';
// $col4=$col4?','.$col4:',s4';
// $col5=$col5?','.$col5:',s5';

// $item_spec_id1=$item_spec_id1?','.$item_spec_id1:',0';
// $item_spec_id2=$item_spec_id2?','.$item_spec_id2:',0';
// $item_spec_id3=$item_spec_id3?','.$item_spec_id3:',0';
// $item_spec_id4=$item_spec_id4?','.$item_spec_id4:',0';
// $item_spec_id5=$item_spec_id5?','.$item_spec_id5:',0';

// display_error($stock_id.'-------'.$specification_id.'-------'.$specification_detail_id);



	$sql="INSERT INTO ".TB_PREF."item_specification (`stock_id`, `specification_id`, `specification_detail_id` ) 
	VALUES (".db_escape($stock_id).", ".db_escape($specification_id)." , ".db_escape($specification_detail_id).") " ;
	db_query($sql,"");
}

	// update_item_specification($selected_id, $_POST['stock_id'], $_POST['specification_id'], $specification_detail_id);

function update_item_specification($selected_id, $stock_id, $spec_id, $spec_detail_id )
{
// $col1=$col1?','.$col1:',s1';
// $col2=$col2?','.$col2:',s2';
// $col3=$col3?','.$col3:',s3';
// $col4=$col4?','.$col4:',s4';
// $col5=$col5?','.$col5:',s5';

// $item_spec_id1=$item_spec_id1?''.$item_spec_id1:'0';
// $item_spec_id2=$item_spec_id2?''.$item_spec_id2:'0';
// $item_spec_id3=$item_spec_id3?''.$item_spec_id3:'0';
// $item_spec_id4=$item_spec_id4?''.$item_spec_id4:'0';
// $item_spec_id5=$item_spec_id5?''.$item_spec_id5:'0';

	$sql="UPDATE ".TB_PREF."item_specification SET`stock_id`=".db_escape($stock_id).", `specification_id`=".db_escape($spec_id).", `specification_detail_id`=".db_escape($spec_detail_id)." WHERE `id`=".db_escape($selected_id)." " ;


// display_error($sql);
// die;
	db_query($sql,"");
}
function check_duplicate_spec($spec_detail_id, $stock_id)
{
	$sql="SELECT count(*) as count FROM ".TB_PREF."item_specification WHERE specification_detail_id= ".db_escape($spec_detail_id)."
	 AND stock_id=".db_escape($stock_id)." ";
	// display_error($sql);
	// die;
	$result= db_query($sql);
	$res= db_fetch($result);
	return $res['count'];
}





//---------------------------------------------------------------------------------------------------
$action = $_SERVER['PHP_SELF'];
if ($page_nested)
	$action .= "?stock_id=".get_post('stock_id');
start_form(false, false, $action);

if (!isset($_POST['stock_id']))
	$_POST['stock_id'] = get_global_stock_item();

if (!$page_nested)
{
	start_table(TABLESTYLE_NOBORDER);

	start_row();
	sales_items_list_cells(_('Item'),'stock_id', $_POST['stock_id'], false, true, '', array('editable' => false));
	
 end_table();

	end_row();
}
else
	br(2);
set_global_stock_item($_POST['stock_id']);

//----------------------------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$res=get_specification(get_post('specification_id'));
	$i=1;
while($myrow=db_fetch($res)){
			$specification_detail_id=$_POST['spec_dropdown'.$myrow['id']];


	// if($i==1)
	// {
	// 	$item_specification_id1=$_POST['spec_dropdown'.$myrow['id']];
	// 	$column1='s'.$i;
	// }
	// if($i==2)
	// {
	// 	$item_specification_id2=$_POST['spec_dropdown'.$myrow['id']];
	// 	$column2='s'.$i;
	// }
	// if($i==3)
	// {
	// 	$item_specification_id3=$_POST['spec_dropdown'.$myrow['id']];
	// 	$column3='s'.$i;
	// }
	// if($i==4)
	// {
	// 	$item_specification_id4=$_POST['spec_dropdown'.$myrow['id']];
	// 	$column4='s'.$i;
	// }
	// if($i==5)
	// {
	// 	$item_specification_id5=$_POST['spec_dropdown'.$myrow['id']];
	// 	$column5='s'.$i;
	// }
			$i++;  													// for increment of Insert column column 
	

}
	$res=get_specification(get_post('specification_id'));
while($myrow=db_fetch($res)){

	$duplicate_spec=check_duplicate_spec($_POST['spec_dropdown'.$myrow['id']], $_POST['stock_id']);
if($duplicate_spec>0)
{
 	$input_error = 1;
		display_error("Selected ".$myrow['specification_name']." has already linked with ".$_POST['stock_id']." Item");
		set_focus('spec_dropdown'.$myrow['id']);
}
	if ($_POST['spec_dropdown'.$myrow['id']] == 0 ) {
		$input_error = 1;
		display_error("Select ".$myrow['specification_name']." first then insert.");
		set_focus('spec_dropdown'.$myrow['id']);
	}

}
// if(key_in_foreign_table_multiple_column($spec_id, '', 'item_specification', 's1', 's2', 's3', 's4', 's5'))
// {
// 		// display_error(_("You Cannot delete this Specification because items have been used  using this Specification ."));
// $input_error=1;
// }

	if ($input_error != 1)
	{

    	if ($selected_id != -1) 
		{
			update_item_specification($selected_id, $_POST['stock_id'], $_POST['specification_id'], $specification_detail_id);

			$msg = _("The Specification has been Updated.");
		}
		else
		{

// display_error('one'.$item_specification_id1. 'two'.$item_specification_id2. 'thre'.$item_specification_id3. 'fr'.$item_specification_id4. 'fv'.$item_specification_id5);
			$specification_id=get_post('specification_id');
			add_item_specification($_POST['stock_id'], $specification_id, $specification_detail_id);

			$msg = _("The New Specification has been Added.");
		}
		display_notification($msg);
		$Mode = 'RESET';
	}


}

//------------------------------------------------------------------------------------------------------

if ($Mode == 'Delete')
{	$input_error=0;
	//the link to delete a selected record was clicked
	$myrow2=get_trans_item_specification($selected_id);
	// display_error($myrow2['stock_id']);
	// die;
	$stock_id=$myrow2['stock_id'];
	$val1=$myrow2['s1'];
	$val2=$myrow2['s2'];
	$val3=$myrow2['s3'];
	$val4=$myrow2['s4'];
	$val5=$myrow2['s5'];

	if(key_in_foreign_table_multiple_column2($stock_id,$val1,$val2,$val3,$val4,$val5, 'debtor_trans_details', 's1', 's2', 's3', 's4', 's5'))
{
		// display_error(_("You Cannot delete this Specification because items have been used  using this Specification ."));
// $input_error=1;
}
if($input_error!=1)
{
	delete_spec($selected_id);
	display_notification(_("The selected price has been deleted."));
}
else
{
	display_error(_("The selected Specification Can not be deleted used in transaction."));
	exit;
}
	$Mode = 'RESET';

}

if ($Mode == 'RESET')
{
	$selected_id = -1;
		$inact = get_post('show_inactive');
	// unset($_POST);
	$_POST['show_inactive'] = $inact;
	$Ajax->activate('_page_body');
}

if (list_updated('stock_id')) {
	$Ajax->activate('price_table');
	$Ajax->activate('price_details');
}
if (list_updated('stock_id') || isset($_POST['_curr_abrev_update']) || isset($_POST['_sales_type_id_update'])) {
	// after change of stock, currency or salestype selector
	// display default calculated price for new settings. 
	// If we have this price already in db it is overwritten later.
	unset($_POST['price']);
	$Ajax->activate('price_details');
}

//---------------------------------------------------------------------------------------------------

function get_item_specification($selected_id)
{
	$sql="SELECT * from  ".TB_PREF."item_specification where id='$selected_id'";
	$res= db_query($sql,"");
	$myrow=db_fetch($res);
	return $myrow;

}

function get_spec($id)
{
	$sql="SELECT * from  ".TB_PREF."specification where id='$id'";
	$res= db_query($sql,"");
	$myrow=db_fetch($res);
	return $myrow;

}
function spec_name1($id)
{
// var_dump('id=======>'.$id[s2]);
	$sql="SELECT drop_name from ".TB_PREF."specification_detail where id=".db_escape($id['specification_detail_id'])." ";
	$res= db_query($sql,"");
	$myrow=db_fetch($res);

	return $myrow['0'];
}
// function spec_name2($id)
// {
// 	$sql="SELECT drop_name from ".TB_PREF."specification_detail where id='$id[s2]'";
// 	$res= db_query($sql,"");
// 	$myrow=db_fetch($res);
// 	return $myrow['0'];
// }
// function spec_name3($id)
// {

// 	$sql="SELECT drop_name from ".TB_PREF."specification_detail where id='$id[s3]'";
// 	$res= db_query($sql,"");
// 	$myrow=db_fetch($res);
// 	return $myrow['0'];
// }

// function spec_name4($id)
// {
// 	$sql="SELECT drop_name from ".TB_PREF."specification_detail where id='$id[s4]'";
// 	$res= db_query($sql,"");
// 	$myrow=db_fetch($res);
// 	return $myrow['0'];
// }

// function spec_name5($id)
// {
// 	$sql="SELECT drop_name from ".TB_PREF."specification_detail where id='$id[s5]'";
// 	$res= db_query($sql,"");
// 	$myrow=db_fetch($res);
// 	return $myrow['0'];
// }
	
// function edit_link($row){
// 	return button("Edit".$row["id"],_("Edit"), '', ICON_EDIT);
// }



//------------------------------------------------------------------------------------------------

// if($Mode == 'Edit'){
// 	$sql = " UPDATE ".TB_PREF."item_specification set s1 =
// 	 1 WHERE id = '$selected_id' ";
// 	$res = db_query($sql,"");
// 	if($sql != null){
// 		meta_forward($_SERVER['PHP_SELF'],"delid=1");
// 	}
// }
function edit_link($row) {
	return button("Edit".$row["id"],_("Edit"), '', ICON_EDIT);
}

function delete_link($row){
	return button("Delete".$row["id"],_("Delete"), '', ICON_DELETE);
}

//------------------------------------------------------------------------------------------------
function delete_spec($selected_id){
	$sql = " DELETE FROM ".TB_PREF."item_specification WHERE id = '$selected_id' ";
	// display_error($sql);
	// die;
	$res = db_query($sql,"");
}

function get_table_headers()
{
$sql= "SELECT id,specification_name from ".TB_PREF."specification where specification_status=1 and inactive=0 and deleted=0";
$res=db_query($sql,'canot run get_table_header query');
return $res;
}

$th=get_specification_name(get_post('specification_id'));

div_start('price_details');
start_table(TABLESTYLE2, "style=''");

	if ($selected_id != -1)
	{
	 	if ($Mode == 'Edit') {
			$myrow = get_item_specification($selected_id);
	    	$specification_value = $myrow["specification_id"];
	    	$property_val = $myrow["specification_detail_id"];
	    
		    }

		}

specification_dropdown_label_cells(_('Select Specification'),'specification_id',$specification_value, 'Select Specification', true);
if(list_updated('specification_id'))
    $Ajax->activate('_page_body');
// $Ajax->activate("'spec_dropdown'.$myrow['id']");
$i=$j=1;
	$c=1;
$res=get_specification(get_post('specification_id'));
while($myrow=db_fetch($res)){

		if ($myrow['specification_status']==1) {
			// display_error($_POST['spec_dropdown'.$myrow['id']]."sDs" .$i);
					$required ="";
				if($myrow['required'] ==1)
					$required = " <b style='color:#ff5050;'>*</b>";
if(get_post('specification_id')!=-1)
{
			specification_dropdown(_($myrow['specification_name'].":".$required), 'spec_dropdown'.$myrow['id'], $property_val, $fresh_item,
				$myrow['id'],$myrow['specification_name']);
			// display_error($_POST['spec_dropdown'.$myrow['id']])
			// hidden('spec_dropdown'.$myrow['id'],1);
	$i++;
	$c++;
		}
		// else
		// {
		// 	text_row(_($myrow['specification_name'].":"), 'spec_textbox'.$j, null, 52, 7);
		// 	$j++;
		// }
}

}
end_table();
submit_add_or_update_center($selected_id == -1, '', 'both');
div_end();

function get_data_item_specification($spec_id)
{
$sql= "SELECT  id, id as idd ,specification_detail_id, inactive FROM ".TB_PREF."item_specification 
WHERE stock_id = ".db_escape($_POST['stock_id'])." AND specification_id = ".db_escape($spec_id)." ";
if (!get_post('show_inactive')) 
	$sql .= " AND !inactive";

if(get_post('specification_id')==-1 || get_post('specification_id')=='')
$sql.=" AND id=0";

return $sql;
}

$sql=get_data_item_specification(get_post('specification_id'));
$cols = array(
'id' => 'skip',
_("ID"),
_($th)=> array('fun' => 'spec_name1'),

_("Inactive") => 'inactive',	
	
    );


	// array_append($cols, array(array('insert'=>true, 'fun'=>'edit_link')));
	array_append($cols, array(array('insert'=>true, 'fun'=>'edit_link')));
	array_append($cols, array(array('insert'=>true, 'fun'=>'delete_link')));




$table =& new_db_pager('spec_tbl', $sql, $cols, 'item_specification');
$table->set_inactive_ctrl('item_specification', 'id');

// $table =& new_db_pager('spec_tbl', $sql, $cols);
// $table->set_marker('check_overdue', _(""));
$table->width = "80%";
br();
br();
display_db_pager($table);
start_table(TABLESTYLE);

echo "<br>";

$_POST['spec_dropdown5']=1;
hidden('selected_id', $selected_id);



if (!@$_GET['popup'])
{
	end_form();
	end_page(@$_GET['popup'], false, false);
}
?>
