<?php

$page_security = 'SA_ITEMSMOVEMENTS';
$path_to_root = "../..";
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/banking.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include($path_to_root . "/reporting/includes/reporting.inc");

include_once($path_to_root . "/includes/ui.inc");
$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(800, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

if (isset($_GET['FixedAsset'])) {
	$page_security = 'SA_FIXEDASSETMOVEMENT';
	$_POST['fixed_asset'] = 1;
	$_SESSION['page_title'] = _($help_context = "Fixed Assets Movement");
} else {
	$_SESSION['page_title'] = _($help_context = "Inventory Item Movement");
}

page($_SESSION['page_title'], isset($_GET['stock_id']), false, "", $js);
//------------------------------------------------------------------------------------------------

if (get_post('fixed_asset') == 1)
	check_db_has_fixed_assets(_("There are no fixed asset defined in the system."));
else
	check_db_has_stock_items(_("There are no items defined in the system."));

if(get_post('SearchOrders'))
{
	$Ajax->activate('doc_tbl');
}

if (isset($_GET['stock_id']))
{
	$_POST['stock_id'] = $_GET['stock_id'];
}


div_start('ext_tbl');
start_form();

hidden('fixed_asset');

if (!isset($_POST['stock_id']))
	$_POST['stock_id'] = get_global_stock_item();

start_table(TABLESTYLE_NOBORDER);
start_row();
if (!$page_nested)
{
	if (get_post('fixed_asset') == 1) {
		stock_items_list_cells(_("Item:"), 'stock_id', $_POST['stock_id'],
			false, false, check_value('show_inactive'), false, array('fixed_asset' => true));
		check_cells(_("Show inactive:"), 'show_inactive', null, true);

		if (get_post('_show_inactive_update')) {
			$Ajax->activate('stock_id');
			set_focus('stock_id');
		}
	} else
		stock_costable_items_list_cells(_("Item:"), 'stock_id', $_POST['stock_id']);
}

locations_list_cells(_("From Location:"), 'StockLocation', null, true, false, (get_post('fixed_asset') == 1));
end_row();
end_table();

start_table(TABLESTYLE_NOBORDER);
start_row();




date_cells(_("From:"), 'AfterDate', '', null, -user_transaction_days(),0,0,null,true);
date_cells(_("To:"), 'BeforeDate', '',null,0,0,0,null,true);

// submit_cells('ShowMoves',_("Show Movements"),'',_('Refresh Inquiry'), 'default');
submit_cells('SearchOrders', _("Show Movements"),'',_('Refresh Inquiry'), 'default');


//---------------zEESHAN BEG-----------------------------------------------------------------------//


if(isset($_POST['AfterDate']) || isset($_POST['BeforeDate']) || check_value('StockLocation')  ) {

$Ajax->activate('ext_tbl');
}

// display_Error($_POST['fixed_asset']);
if($_POST['fixed_asset'])
$trans_type=FIXEDMOV;
else
$trans_type=ITEMMOV;
	 

	echo  "<td>". print_stck_mov_dashboard_print( 0, _("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, $trans_type, null, '','',
	 $_POST['stock_id'],$_POST['AfterDate'],$_POST['BeforeDate'],$_POST['StockLocation'] ,$_POST['fixed_asset'] ) ."</td>"; 



	echo  "<td>". print_stck_mov_dashboard_print( 1, _("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, $trans_type, null, '','',
	 $_POST['stock_id'],$_POST['AfterDate'],$_POST['BeforeDate'],$_POST['StockLocation'] ,$_POST['fixed_asset'] ) ."</td>"; 



//---------------zEESHAN end-----------------------------------------------------------------------//


end_row();
end_table();
end_form();
div_end();

set_global_stock_item($_POST['stock_id']);

$before_date = date2sql($_POST['BeforeDate']);
$after_date = date2sql($_POST['AfterDate']);
$display_location = !$_POST['StockLocation'];

$result = get_stock_movements($_POST['stock_id'], $_POST['StockLocation'],
	$_POST['BeforeDate'], $_POST['AfterDate']);

div_start('doc_tbl');
start_table(TABLESTYLE4);
$th = array(_("Type"), _("#"), _("Reference"));

if ($display_location)
	array_push($th, _("Location"));

array_push($th, _("Date"), _("Detail"), _("Quantity In"), _("Quantity Out"), _("Quantity On Hand"),'');

table_header($th,'font-weight:normal;');

$before_qty = get_qoh_on_date($_POST['stock_id'], $_POST['StockLocation'], add_days($_POST['AfterDate'], -1));

$after_qty = $before_qty;

start_row("class='inquirybg'");
$header_span = $display_location ? 6 : 5;
label_cell("<b>"._("Quantity on hand before") . " " . $_POST['AfterDate']."</b>", "align=center colspan=$header_span");
label_cell("&nbsp;", "colspan=2");
$dec = get_qty_dec($_POST['stock_id']);
qty_cell($before_qty, false, $dec);
label_cell("&nbsp;", "colspan=2");
end_row();

$j = 1;
$k = 0; //row colour counter

$total_in = 0;
$total_out = 0;

while ($myrow = db_fetch($result))
{

	alt_table_row_color($k);

	$trandate = sql2date($myrow["tran_date"]);

	if (get_post('fixed_asset') == 1 && isset($fa_systypes_array[$myrow["type"]]))
		$type_name = $fa_systypes_array[$myrow["type"]];
	else
		$type_name = $systypes_array[$myrow["type"]];

	if ($myrow["qty"] > 0)
	{
		$quantity_formatted = number_format2($myrow["qty"], $dec);
		$total_in += $myrow["qty"];
	}
	else
	{
		$quantity_formatted = number_format2(-$myrow["qty"], $dec);
		$total_out += -$myrow["qty"];
	}
	$after_qty += $myrow["qty"];

	label_cell($type_name);

	label_cell(get_trans_view_str($myrow["type"], $myrow["trans_no"], "", false, '', '', $path_to_root), "nowrap align='left'");

	label_cell(get_trans_view_str($myrow["type"], $myrow["trans_no"], $myrow["reference"],  false, '', '', $path_to_root));

	if($display_location) {
		label_cell($myrow['loc_code']);
	}
	label_cell($trandate);

	$gl_posting = "";

	label_cell($myrow['name']);

	label_cell((($myrow["qty"] >= 0) ? $quantity_formatted : ""), "nowrap align=left");
	label_cell((($myrow["qty"] < 0) ? $quantity_formatted : ""), "nowrap align=left");
	qty_cell($after_qty, false, $dec);
			label_cell( print_document_link($myrow['trans_no']."-".$myrow['type'], _("Print"), true, $myrow['type'], ICON_PRINT));	

	end_row();

	$j++;
	if ($j == 12)
	{
		$j = 1;
		table_header($th);
	}
}

start_row("class='inquirybg'");
label_cell("<b>"._("Quantity on hand after") . " " . $_POST['BeforeDate']."</b>", "align=center colspan=$header_span");
qty_cell($total_in, false, $dec);
qty_cell($total_out, false, $dec);
qty_cell($after_qty, false, $dec);
label_cell("&nbsp;", "colspan=2");
end_row();

end_table(1);
div_end();
end_page();

