<?php
/**********************************************************************
    Copyright (C) FrontAccounting, LLC.
	Released under the terms of the GNU General Public License, GPL, 
	as published by the Free Software Foundation, either version 3 
	of the License, or (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
    See the License here <http://www.gnu.org/licenses/gpl-3.0.html>.
***********************************************************************/
$page_security = 'SA_LINKITEMS';

if (@$_GET['page_level'] == 1)
	$path_to_root = "../..";
else	
	$path_to_root = "..";

include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/inventory/includes/db/link_items_db.inc");
include_once($path_to_root . "/includes/ui.inc");

$js = "";
if ($SysPrefs->use_popup_windows && $SysPrefs->use_popup_search)
	$js .= get_js_open_window(900, 500);
page(_($help_context = "Inventory Item Sales prices"), false, false, "", $js);

//---------------------------------------------------------------------------------------------------

check_db_has_stock_items(_("There are no items defined in the system."));

check_db_has_sales_types(_("There are no sales types in the system. Please set up sales types befor entering pricing."));

simple_page_mode(true);
//---------------------------------------------------------------------------------------------------
$input_error = 0;

if (isset($_GET['stock_id']))
{
	$_POST['stock_id'] = $_GET['stock_id'];
}
if (isset($_GET['Item']))
{
	$_POST['stock_id'] = $_GET['Item'];
}


//---------------------------------------------------------------------------------------------------
$action = $_SERVER['PHP_SELF'];
if ($page_nested)
	$action .= "?stock_id=".get_post('stock_id');
start_form(false, false, $action);

if (!isset($_POST['stock_id']))
	$_POST['stock_id'] = get_global_stock_item();

if (!$page_nested)
{
	start_table(TABLESTYLE_NOBORDER);
	start_row();
	sales_items_list_cells(_('Item'),'stock_id', $_POST['stock_id'], false, true, '', array('editable' => false));
	end_table();

	end_row();
}
else
	br(2);
set_global_stock_item($_POST['stock_id']);



//----------------------------------------------------------------------------------------------------




if ($Mode=='ADD_ITEM') 
{
		if($_POST['stock_id'] ==  $_POST['link_item_id']){

			display_error("You already have this item");
			$input_error = 1;			
		}

		if ($input_error != 1)
	{
		if ($selected_id != -1) 
		{	
			display_error("Link items cannot be updated");
		}
		else
		{	
			$new_item = $_POST['stock_id'];
			$link_item = $_POST['link_item_id'];
			add_item_links($new_item,$link_item );
			$msg = _("The new item has been added.");
		}
				
		display_notification($msg);
		$Mode = 'RESET';
	}


}

//------------------------------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	//the link to delete a selected record was clicked
	delete_item_links($selected_id);
	display_notification(_("The selected item links has been deleted."));
	$Mode = 'RESET';
}


if (list_updated('stock_id')) {
$Mode ='RESET';
	$Ajax->activate('item_links_table');
	$Ajax->activate('newitem');
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	
}
if (list_updated('stock_id') || isset($_POST['_link_item_id_update']) ) {
	// after change of stock, currency or salestype selector
	// display default calculated price for new settings. 
	// If we have this price already in db it is overwritten later.
	
	$Ajax->activate('newitem');
}





//---------------------------------------------------------------------------------------------------


$item_list = get_item_links($_POST['stock_id']);

div_start('item_links_table');
//start_table(TABLESTYLE4, "width='30%'");
start_table(TABLESTYLE5_BOX,"",0,0,0,null,"20%","1px solid #656E79;");


$th = array(_("Added Items"), "");

table_header($th);

while ($myrow = db_fetch($item_list))
{

	alt_table_row_color($k);	
	label_cell(get_items_name_description($myrow["link_item"])["description"]);
 	delete_button_cell("Delete".$myrow['id'], _("Delete"));
    end_row();

}
end_table();

div_end();
//------------------------------------------------------------------------------------------------

echo "<br>";


hidden('selected_id', $selected_id);

div_start('newitem');
start_table(TABLESTYLE5_BOX,"",0,0,0,null,"25%","3px solid #656E79;");
	 stock_items_list_cells(_("Select an item:"), 'link_item_id', null,
	   _('Select item'), true, check_value('show_inactive'), false, array('fixed_asset' => get_post('fixed_asset')));
end_table(1);

submit_add_or_update_center(true, '', 'both');


div_end();

end_form();




end_page();
