<?php

$page_security = 'SA_ITEMCATEGORY';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");

if (isset($_GET['FixedAsset'])) {
  $page_security = 'SA_ASSETCATEGORY';
  $help_context = "Fixed Assets Categories";
  $_POST['mb_flag'] = 'F';
}
else {
  $help_context = "Item Categories";
}

$js = "";
if ($SysPrefs->use_popup_windows && $SysPrefs->use_popup_search)
	$js .= get_js_open_window(900, 500);

page(_($help_context), false, false, "", $js);

include_once($path_to_root . "/includes/ui.inc");

include_once($path_to_root . "/inventory/includes/inventory_db.inc");

simple_page_mode(true);
//----------------------------------------------------------------------------------

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	//initialise no input errors assumed initially before we test
	$input_error = 0;

	if (strlen($_POST['description']) == 0) 
	{
		$input_error = 1;
		display_error(_("The item category description cannot be empty."));
		set_focus('description');
	}

	if ($input_error !=1)
	{
    	if ($selected_id != -1) 
    	{
		    update_item_category($selected_id, $_POST['description'],
				$_POST['tax_type_id'],	$_POST['sales_account'], 
				$_POST['cogs_account'], $_POST['inventory_account'], 
				$_POST['adjustment_account'], $_POST['wip_account'],
				$_POST['units'], $_POST['mb_flag'],	$_POST['dim1'],	$_POST['dim2'],
				check_value('no_sale'), check_value('no_purchase'),$_POST['description_arabic']);
			display_notification(_('Selected item category has been updated'));
    	} 
    	else 
    	{
		    $selected_id=add_item_category($_POST['description'],
				$_POST['tax_type_id'],	$_POST['sales_account'], 
				$_POST['cogs_account'], $_POST['inventory_account'], 
				$_POST['adjustment_account'], $_POST['wip_account'], 
				$_POST['units'], $_POST['mb_flag'],	$_POST['dim1'],	
				$_POST['dim2'],	check_value('no_sale'), check_value('no_purchase'),$_POST['description_arabic']);
				display_notification(_('New item category has been added'));
    	}

  		$upload_file = "";
			if (isset($_FILES['pic']) && $_FILES['pic']['name'] != ''){
				$stock_id = $selected_id;
				$result = $_FILES['pic']['error'];
				$upload_file = 'Yes'; //Assume all is well to start off with
				$filename = company_path().'/images/category';
				if(!file_exists($filename)){
					mkdir($filename);
				}

				$filename .= "/".item_img_name($stock_id).".jpg";

				if($_FILES['pic']['error'] == UPLOAD_ERR_INI_SIZE) {
					display_error(_('The file size is over the maximum allowed.'));
					$upload_file ='No';
				}
				elseif ($_FILES['pic']['error'] > 0){
					display_error(_('Error uploading file.'));
					$upload_file ='No';
				}

				//But check for the worst 
				if ((list($width, $height, $type, $attr) = getimagesize($_FILES['pic']['tmp_name'])) !== false)
				  $imagetype = $type;
				else
				  $imagetype = false;

				if($imagetype != IMAGETYPE_GIF && $imagetype != IMAGETYPE_JPEG && $imagetype != IMAGETYPE_PNG){	
					//File type Check
					display_warning( _('Only graphics files can be uploaded'));
					$upload_file ='No';
				}
				elseif (!in_array(strtoupper(substr(trim($_FILES['pic']['name']), strlen($_FILES['pic']['name']) - 3)), array('JPG','PNG','GIF')))
				{
					display_warning(_('Only graphics files are supported - a file extension of .jpg, .png or .gif is expected'));
					$upload_file ='No';
				} 
				elseif ( $_FILES['pic']['size'] > ($SysPrefs->max_image_size * 1024)) 
				{ //File Size Check
					display_warning(_('The file size is over the maximum allowed. The maximum size allowed in KB is') . ' ' . $SysPrefs->max_image_size);
					$upload_file ='No';
				} 
				elseif ( $_FILES['pic']['type'] == "text/plain" ) 
				{  //File type Check
					display_warning( _('Only graphics files can be uploaded'));
					$upload_file ='No';
				} 
				elseif (file_exists($filename))
				{
				     $result = unlink($filename);
					if (!$result) 
					{
						display_error(_('The existing image could not be removed'));
						$upload_file ='No';
					}
				}

				if ($upload_file == 'Yes')
				{
				   $result  =  move_uploaded_file($_FILES['pic']['tmp_name'], $filename);
				}
				$Ajax->activate('details');
				/* EOF Add Image upload for New Item  - by Ori */
			}

		$Mode = 'RESET';
	}
}

//---------------------------------------------------------------------------------- 

if ($Mode == 'Delete')
{

	// PREVENT DELETES IF DEPENDENT RECORDS IN 'stock_master'
	if (key_in_foreign_table($selected_id, 'stock_master', 'category_id'))
	{
		display_error(_("Cannot delete this item category because items have been created using this item category."));
	} 
	else 
	{
		delete_item_category($selected_id);
		display_notification(_('Selected item category has been deleted'));
	}
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
    $mb_flag = get_post('mb_flag');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
	if (is_fixed_asset($mb_flag))
		$_POST['mb_flag'] = 'F';
}
if (list_updated('mb_flag')) {
	$Ajax->activate('details');
}

//----------------------------------------------------------------------------------
$fixed_asset = is_fixed_asset(get_post('mb_flag'));

$result = get_item_categories(check_value('show_inactive'), $fixed_asset);

start_form(true);
//start_table(TABLESTYLE4, "width='80%'");
start_table(TABLESTYLE5_BOX,"",0,0,0,null,"90%","2px solid #656E79;");
if ($fixed_asset) {
	$th = array(_("Name"),_("Name(In Arabic)"), _("Tax type"), _("Units"), _("Sales Act"),
		_("Asset Account"), _("Deprecation Cost Account"),
		_("Depreciation/Disposal Account"), "", "");
} else {
	$th = array(_("Name"),_("Name(In Arabic)"), _("Tax type"), _("Units"), _("Type"), _("Sales Act"),
		_("Inventory Account"), _("COGS Account"), _("Adjustment Account"),
		_("Assembly Account"), "", "");
}
inactive_control_column($th);

table_header($th);
$k = 0; //row colour counter

while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);

	label_cell($myrow["description"]);
	label_cell($myrow["description_arabic"]);
	label_cell($myrow["tax_name"]);
	label_cell($myrow["dflt_units"], "align=center");
	if (!$fixed_asset)
		label_cell(@$stock_types[$myrow["dflt_mb_flag"]]);
	label_cell($myrow["dflt_sales_act"], "align=center");
	label_cell($myrow["dflt_inventory_act"], "align=center");
	label_cell($myrow["dflt_cogs_act"], "align=center");
	label_cell($myrow["dflt_adjustment_act"], "align=center");
	if (!$fixed_asset)
		label_cell($myrow["dflt_wip_act"], "align=center");
	inactive_control_cell($myrow["category_id"], $myrow["inactive"], 'stock_category', 'category_id');
 	edit_button_cell("Edit".$myrow["category_id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["category_id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table();
echo '<br>';
//----------------------------------------------------------------------------------

div_start('details');
//start_table(TABLESTYLE2,"style=''");
start_table(TABLESTYLE6_BOX,"",0,0,0,null,"60%","2px solid #656E79;");



if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing item category
		$myrow = get_item_category($selected_id);

		$_POST['category_id'] = $myrow["category_id"];
		$_POST['description_arabic'] = $myrow["description_arabic"];
		$_POST['description']  = $myrow["description"];
		$_POST['tax_type_id']  = $myrow["dflt_tax_type"];
		$_POST['sales_account']  = $myrow["dflt_sales_act"];
		$_POST['cogs_account']  = $myrow["dflt_cogs_act"];
		$_POST['inventory_account']  = $myrow["dflt_inventory_act"];
		$_POST['adjustment_account']  = $myrow["dflt_adjustment_act"];
		$_POST['wip_account']  = $myrow["dflt_wip_act"];
		$_POST['units']  = $myrow["dflt_units"];
		$_POST['mb_flag']  = $myrow["dflt_mb_flag"];
		$_POST['dim1']  = $myrow["dflt_dim1"];
		$_POST['dim2']  = $myrow["dflt_dim2"];
		$_POST['no_sale']  = $myrow["dflt_no_sale"];
		$_POST['no_purchase']  = $myrow["dflt_no_purchase"];
		$_POST['description_arabic']  = $myrow["description_arabic"];
	} 
	hidden('selected_id', $selected_id);
	hidden('category_id');
} else if ($Mode != 'CLONE') {
		$_POST['long_description'] = '';
				$_POST["description_arabic"]='';
		$_POST['description'] = '';
		$_POST['no_sale']  = 0;
		$_POST['no_purchase']  = 0;

		$company_record = get_company_prefs();

    if (get_post('inventory_account') == "")
    	$_POST['inventory_account'] = $company_record["default_inventory_act"];

    if (get_post('cogs_account') == "")
    	$_POST['cogs_account'] = $company_record["default_cogs_act"];

	if (get_post('sales_account') == "")
		$_POST['sales_account'] = $company_record["default_inv_sales_act"];

	if (get_post('adjustment_account') == "")
		$_POST['adjustment_account'] = $company_record["default_adj_act"];

	if (get_post('wip_account') == "")
		$_POST['wip_account'] = $company_record["default_wip_act"];

}

text_row(_("Category Name:"), 'description', null, 30, 45);  
text_row_arabic(_("Category Name (In Arabic):"), 'description_arabic', 50, 50 ,null,null,null,null,1);
table_section_title(_("Default values for new items"));

item_tax_types_list_row(_("Item Tax Type:"), 'tax_type_id', null);

if (is_fixed_asset(get_post('mb_flag')))
	hidden('mb_flag', 'F');
else
	stock_item_types_list_row(_("Item Type:"), 'mb_flag', null, true);

stock_units_list_row(_("Units of Measure:"), 'units', null);

if (is_fixed_asset($_POST['mb_flag'])) 
	hidden('no_sale', 0);
else
	check_row(_("Exclude from sales:"), 'no_sale');

check_row(_("Exclude from purchases:"), 'no_purchase');

gl_all_accounts_list_row(_("Sales Account:"), 'sales_account', $_POST['sales_account']);

if (is_service($_POST['mb_flag']))
{
	gl_all_accounts_list_row(_("C.O.G.S. Account:"), 'cogs_account', $_POST['cogs_account']);
	hidden('inventory_account', $_POST['inventory_account']);
	hidden('adjustment_account', $_POST['adjustment_account']);
}
elseif (is_fixed_asset($_POST['mb_flag'])) 
{
	gl_all_accounts_list_row(_("Asset account:"), 'inventory_account', $_POST['inventory_account']);
	gl_all_accounts_list_row(_("Depreciation cost account:"), 'cogs_account', $_POST['cogs_account']);
	gl_all_accounts_list_row(_("Depreciation/Disposal account:"), 'adjustment_account', $_POST['adjustment_account']);
}
else
{
	gl_all_accounts_list_row(_("Inventory Account:"), 'inventory_account', $_POST['inventory_account']);

	gl_all_accounts_list_row(_("C.O.G.S. Account:"), 'cogs_account', $_POST['cogs_account']);
	gl_all_accounts_list_row(_("Inventory Adjustments Account:"), 'adjustment_account', $_POST['adjustment_account']);
}

if (is_manufactured($_POST['mb_flag']))
	gl_all_accounts_list_row(_("Item Assembly Costs Account:"), 'wip_account', $_POST['wip_account']);
else
	hidden('wip_account', $_POST['wip_account']);

$dim = get_company_pref('use_dimension');
if ($dim >= 1)
{
	dimensions_list_row(_("Dimension")." 1", 'dim1', null, true, " ", false, 1);
	if ($dim > 1)
		dimensions_list_row(_("Dimension")." 2", 'dim2', null, true, " ", false, 2);
}
if ($dim < 1)
	hidden('dim1', 0);
if ($dim < 2)
	hidden('dim2', 0);





table_section_title(_("Other"));

// Add image upload for New Item  - by Joe
file_row(_("Image File (.jpg)") . ":", 'pic', 'pic');
// Add Image upload for New Item  - by Joe
$stock_img_link = "";
$check_remove_image = false;
if (isset($selected_id) && file_exists(company_path().'/images/category/'
	.item_img_name($selected_id).".jpg")) 
{
 // 31/08/08 - rand() call is necessary here to avoid caching problems.
	$stock_img_link .= "<img id='item_img' alt = '[".$selected_id.".jpg".
		"]' src='".company_path().'/images/category/'.item_img_name($selected_id).
		".jpg?nocache=".rand()."'"." height='".$SysPrefs->pic_height."' border='0'>";
	$check_remove_image = true;
} 
else 
{
	$stock_img_link .= _("No image");
}

label_row("&nbsp;", $stock_img_link);


end_table(1);
div_end();
submit_add_or_update_center($selected_id == -1, '', 'both', true);

end_form();

end_page();

