<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

function time_to_float($time) {
    if(strpos($time,':') != false) {
        sscanf($time, "%d:%d", $hours, $minutes);
        $time_in_float = $hours + $minutes/60;
        $time_in_float=round($time_in_float,1);
    }
    else
        $time_in_float = $time;
	
	return $time_in_float;
}

//--------------------------------------------------------------------------

function check_attended($emp_id, $overtime_id, $att_date,$in_out=0) {
    $sql = "SELECT * FROM ".TB_PREF."attendance WHERE emp_id = ".db_escape($emp_id)." AND overtime_id = ".db_escape($overtime_id)." AND att_date = '".date2sql($att_date)."'";
    if($in_out>0)
        $sql.=" AND in_out=".db_escape($in_out);
    // display_error($sql);
    // display_error(check_empty_result($sql));
    return check_empty_result($sql);
}


function get_attended($emp_id, $overtime_id, $att_date,$in_out=0) {
    $sql = "SELECT * ,time(".TB_PREF."attendance.time) as time_in , time(".TB_PREF."attendance.time_out) as time_out , TIME_FORMAT(".TB_PREF."attendance.time,'%H:%i') as t_in , TIME_FORMAT(".TB_PREF."attendance.time_out,'%H:%i') as t_out
      FROM ".TB_PREF."attendance  WHERE emp_id = ".db_escape($emp_id)." AND overtime_id = ".db_escape($overtime_id)." AND att_date = '".date2sql($att_date)."'";
    if($in_out>0)
        $sql.=" AND in_out=".db_escape($in_out);
    // display_error($sql);

    $res=db_query($sql);
    $row=db_fetch($res);
    if($row)
    return $row;
   else
    return '';
    // display_error(check_empty_result($sql));
    return check_empty_result($sql);
}
//--------------------------------------------------------------------------

function write_attendance($emp_id, $overtime_id, $hours_no=null, $rate=1, $att_date,$in_out) {
    // display_error($emp_id);exit;

    if(isset($hours_no) && $hours_no != '') {

    	if(check_leave_added($emp_id, $att_date) > 0){
            display_error("Attendance can not be marked on date ".$att_date." because leave is already marked");
        }

        if(check_leave_added($emp_id, $att_date) == 0){
            if(check_attended($emp_id, $overtime_id, $att_date)){ //,$in_out

                   // if($in_out==2)
        		$sql = "UPDATE ".TB_PREF."attendance SET
                 hours_no = ".db_escape($hours_no).",
                 rate = ".db_escape($rate).",
                 time_out = '".date('Y-m-d h:i:s')."' 
                   WHERE att_date = '".date2sql($att_date)."' AND emp_id = ".db_escape($emp_id)." AND overtime_id = ".db_escape($overtime_id);
                $msg = "Updated Attendance";
            }
        	else{

        		$sql = "INSERT INTO ".TB_PREF."attendance(emp_id, overtime_id, hours_no, rate, att_date,time,in_out) VALUES(".db_escape($emp_id).",".db_escape($overtime_id).",".db_escape($hours_no).",".db_escape($rate).",'".date2sql($att_date)."','".date('Y-m-d h:i:s')."',".db_escape($in_out).")";
                $msg = "Added Attendance";
            }
        
        // display_error($sql);
            db_query($sql, _('Could not add time clock'));
            if ($emp_id) {
             $id = $emp_id;
            }
    // add_audit_trail(SA_HRMATTENDANCE, $id, Today(),$msg);
        }
    }
}
//==========================================================================
function write_attendance_all($emp_id, $overtime_id, $hours_no=null, $rate=1, $att_date,$in_out,$time_in,$time_out) {
    // display_error($emp_id);exit;

// display_error($emp_id."  --- ".$hours_no."   ===  ".check_leave_added($emp_id, $att_date));
    if(isset($hours_no) && $hours_no != '') {

        if(check_leave_added($emp_id, $att_date) > 0){
            display_error("Attendance can not be marked on date ".$att_date." because leave is already marked");
        }

        if(check_leave_added($emp_id, $att_date) == 0){
            if(check_attended($emp_id, $overtime_id, $att_date)){ //,$in_out

                   // if($in_out==2)
                $sql = "UPDATE ".TB_PREF."attendance SET
                 hours_no = ".db_escape($hours_no).",
                 rate = ".db_escape($rate).",
                 time = '".$time_in."',
                 time_out = '".$time_out."' 
                   WHERE att_date = '".date2sql($att_date)."' AND emp_id = ".db_escape($emp_id)." AND overtime_id = ".db_escape($overtime_id);
                $msg = "Updated Attendance";
            }
            else{

                $sql = "INSERT INTO ".TB_PREF."attendance(emp_id, overtime_id, hours_no, rate, att_date,time,in_out,time_out) VALUES(".db_escape($emp_id).",".db_escape($overtime_id).",".db_escape($hours_no).",".db_escape($rate).",'".date2sql($att_date)."','".$time_in."',".db_escape($in_out).",'".$time_out."')";
                $msg = "Added Attendance";
            }
        
        // display_error($sql);
            db_query($sql, _('Could not add time clock'));
            if ($emp_id) {
             $id = $emp_id;
            }
    add_audit_trail(SA_HRMATTENDANCE, $id, Today(),$msg);
        }
    }
}

//--------------------------------------------------------------------------

function check_date_paid($person_id, $att_date) {
	return check_empty_result("SELECT payslip_no, emp_id, from_date, to_date FROM ".TB_PREF."payslip WHERE emp_id = ".db_escape($person_id)." AND '".date2sql($att_date)."' BETWEEN from_date AND to_date");
}

//--------------------------------------------------------------------------

function get_attendance($from, $to, $emp_id = 0, $department = 0, $ot_id = 0) {

    $from = DateTime::createFromFormat('Y-m-d', date2sql($from));
    $to = DateTime::createFromFormat('Y-m-d', date2sql($to));

	$sql = "SELECT emp.emp_id, CONCAT(emp_first_name,' ',emp_last_name)";

	if($emp_id == 0 && $department == 0) {
	    while(sql_date_comp($from->format('Y-m-d'),$to->format('Y-m-d')) <= 0) {
	        $sql .= ",MAX(CASE WHEN att.att_date = '".$from->format('Y-m-d')."' AND emp.emp_id = att.emp_id AND att.overtime_id = ".$ot_id." ";
         if($ot_id)
         $sql.= "THEN CASE att.hours_no WHEN '0' THEN '<a href=#><span style=color:red>x</span></a>'
                   ELSE CASE att.is_leave WHEN '1' THEN '<a href=#><span style=color:red>LF</span></a>'
                   ELSE  att.hours_no END END END)";
         else
           $sql.=" THEN CASE att.hours_no WHEN '0' THEN '<a href=#><span style=color:red>x</span></a>' 
                     ELSE  CASE (SELECT COUNT(*) FROM 0_attendance ott WHERE ott.is_leave='1' AND ott.emp_id = att.emp_id AND   ott.from_leave<='".$from->format('Y-m-d')."'  AND ott.to_leave>='".$from->format('Y-m-d')."' )  WHEN '1' THEN 'LF'
                     ELSE  time_format(timediff(att.time_out,att.time),'%H:%i') END END END) ";


// display_error($sql);

	        $from->modify('+1 day');  //date=".$from->format('Y-m-d')."
	    }
	    $sql .= " FROM ".TB_PREF."employee emp, ".TB_PREF."attendance att WHERE !emp.inactive GROUP BY emp.emp_id";
	}
	else if($emp_id != 0) {
	    while(sql_date_comp($from->format('Y-m-d'),$to->format('Y-m-d')) <= 0) {
	        $sql .= ",MAX(CASE WHEN emp.emp_id = ".$emp_id." AND att.att_date = '".$from->format('Y-m-d')."' AND emp.emp_id = att.emp_id AND att.overtime_id = ".$ot_id."";

            if($ot_id)
              $sql.=" THEN CASE att.is_leave WHEN '1' THEN '<a href=#><span style=color:red>LF</span></a>'
                     ELSE  att.hours_no END END) ";
              else
            $sql.=" THEN 
                       CASE att.is_leave WHEN '1' THEN '<a href=#><span style=color:red>LF</span></a>'
                     ELSE 
                       CONCAT( time_format(timediff(att.time_out,att.time),'%H:%i') , '  ','<a href=../../FrontHrm/manage/check_in_update.php?emp_id=".$emp_id."&&date=".$from->format('Y-m-d')." ><img src=../../../themes/synergy/images/edit2.gif style=vertical-align:middle;width:16px;height:16px;border:0;></a>') END END)  ";

	        $from->modify('+1 day');
	    }
	    $sql .= " FROM ".TB_PREF."employee emp, ".TB_PREF."attendance att WHERE emp.emp_id = '".$emp_id."' GROUP BY emp.emp_id";
	}
	else {
        while(sql_date_comp($from->format('Y-m-d'),$to->format('Y-m-d')) <= 0) {
            $sql .= ",MAX(CASE WHEN att.att_date = '".$from->format('Y-m-d')."' AND emp.emp_id = att.emp_id AND att.overtime_id = ".$ot_id."";
            if($ot_id)
             $sql.=" THEN
                        CASE att.is_leave WHEN '1' THEN '<a href=#><span style=color:red>LF</span></a>'
                     ELSE att.hours_no END)";
             else
            $sql.=" THEN
                     CASE att.is_leave WHEN '1' THEN '<a href=#><span style=color:red>LF</span></a>'
                      ELSE
                     time_format(timediff(att.time_out,att.time),'%H:%i') END)";
            $from->modify('+1 day');
        }
        $sql .= " FROM ".TB_PREF."employee emp, ".TB_PREF."attendance att WHERE emp.department_id = ".$department." AND !emp.inactive GROUP BY emp.emp_id";
	}

    display_error($sql);
	return $sql;
}
// pk for leave
function check_attended_added($emp_id, $overtime_id, $from_date, $to_date){
    $sql = "SELECT * FROM ".TB_PREF."attendance WHERE emp_id = ".db_escape($emp_id)." AND is_leave=0 AND overtime_id = ".db_escape($overtime_id)." AND att_date BETWEEN  '".date2sql($from_date)."' AND '".date2sql($to_date)."' ";
    $res = db_query($sql ," check_attended_added ");
    return db_num_rows($res);
}

function check_leave_befor_hire_date($emp_id, $from_date){
    $sql = "SELECT * FROM ".TB_PREF."attendance WHERE emp_id = ".db_escape($emp_id)." AND is_leave=0  AND att_date < '".date2sql($from_date)."' ";
    // display_error($sql);
    $res = db_query($sql ," check_attended_added ");
    return db_num_rows($res);
}

function add_leave_of_employee($emp_id, $from_date, $to_date, $memo_,$paid_leave=0,$approved=0,$paid_gross_amount=0){
    $overtime_id = 0;
    $rate = 1;
    $hours_no = get_company_pref('payroll_work_hours');
    $from_date = date2sql($from_date);
    $to_date = date2sql($to_date);

    // getting no days leave applied for
    $from_period = strtotime($from_date);
    $to_period = strtotime($to_date);
    $datediff = $to_period - $from_period;
    $no_of_days = round($datediff / (60 * 60 * 24))+1;

    // for($i=1; $i<= $no_of_days; $i++){
        $sql = " INSERT INTO ".TB_PREF."attendance (emp_id,overtime_id,hours_no,rate,att_date,is_leave,from_leave,to_leave,reason,leave_type,approved,paid_gross_amount)
                VALUES ('$emp_id', '$overtime_id', '$hours_no', '$rate', '$from_date', '1','$from_date','$to_date', '$memo_','$paid_leave', '$approved','$paid_gross_amount') ";
        $res = db_query($sql);
        add_audit_trail(SA_HRMLEAVE, $emp_id, Today(),'Leave Added');
        // $stop_date = new DateTime($from_date); 
        // $stop_date->modify('+1 day');
        // $from_date = $stop_date->format('Y-m-d');

    // }
    
}

function check_leave_added($emp_id, $att_date){
    $sql = " SELECT * FROM ".TB_PREF."attendance WHERE emp_id = ".db_escape($emp_id)." AND att_date = '".date2sql($att_date)."' AND is_leave = '1' ";
    $res = db_query($sql , " check_leave_added ");
    return db_num_rows($res);

}

function get_leave_sql($emp_id=0, $from,$to,$leave_type=-1,$status=-1){
  $sql = "SELECT at.emp_id, at.from_leave, at.to_leave, at.reason, at.leave_type, at.approved, at.id,DATEDIFF(at.to_leave, at.from_leave)+1 AS days ,at.paid_gross_amount
          FROM ".TB_PREF."attendance as at  
          LEFT JOIN ".TB_PREF."employee as emp ON emp.emp_id=at.emp_id 
          WHERE at.is_leave = '1'";
  if($emp_id)
    $sql.=" AND at.emp_id = ".db_escape($emp_id)."  "; 
  if($leave_type!=-1)
    $sql.=" AND at.leave_type = ".db_escape($leave_type)."  "; 
  if($status!=-1)
    $sql.=" AND at.approved = ".db_escape($status)."  "; 
  
  $from=date2sql($from);
  $to=date2sql($to);

   // display_error($sql);

      // $sql.=" AND  from_leave>='".date2sql($from)."' AND from_leave<='"  . date2sql($to) . "'";
    
  $sql .= "  AND (('$from' BETWEEN from_leave 
                     AND LAST_DAY(to_leave)) OR from_leave >= '$from') AND (('$to' BETWEEN from_leave 
                     AND LAST_DAY(to_leave)) OR to_leave <= '$to')";
  

  return $sql;
}

function get_engineeer_alloc_sql($emp_id=0, $from,$to){
   //  $sql = "SELECT att.emp_id,att.att_date,time_format(timediff(att.time_out,att.time),'%H:%i') as total_hr
   //         , alloc.order_no FROM ".TB_PREF."attendance att LEFT JOIN ".TB_PREF."allocation alloc on att.att_date=DATE(alloc.time) WHERE";
  
   // $sql.=" att.att_date BETWEEN '".date2sql($from)."' AND '" . date2sql($to) . "' AND time_format(timediff(att.time_out,att.time),'%H')>00";
  

$sql = "SELECT att.emp_id,att.att_date,time_format(timediff(att.time,att.time_out),'%H:%i') as total_hr
            FROM ".TB_PREF."attendance att  WHERE";
  
   $sql.=" att.att_date BETWEEN '".date2sql($from)."' AND '" . date2sql($to) . "' AND time_format(timediff(att.time,att.time_out),'%H')>00";
  


     if($emp_id)
    $sql.=" AND att.emp_id = ".db_escape($emp_id)."  "; 
    // $res = db_query($sql , " check_leave_added ");
// display_error($sql);
    // return db_num_rows($res);
return $sql;
}


function get_job_allocation($emp_id,$date){
    $sql="SELECT *
            FROM ".TB_PREF."allocation WHERE emp_id=".db_escape($emp_id)." AND DATE(time)=".db_escape($date);
        // display_error($sql);
            return db_query($sql);

}

function get_allocation_details($emp_id,$date)
{
    $sql="SELECT * FROM ".TB_PREF."site_report_master srm JOIN ".TB_PREF."allocation alloc ON srm.sales_order=alloc.order_no AND srm.sales_order_detail=alloc.order_detail_id
        WHERE alloc.emp_id=".db_escape($emp_id)." AND DATE(alloc.time)=".db_escape($date)."";

   return db_query($sql); 

    // if()
}


function check_leave($emp_id,$date,$updated=0,$leave_type=-1)
{
  $sql = "SELECT * FROM ".TB_PREF."attendance where  emp_id = ".db_escape($emp_id)." and ('$date' BETWEEN from_leave and to_leave ) and  is_leave = 1";
  if($updated)
    $sql.=" AND id!=".db_escape($updated);
   if($leave_type==0 || $leave_type==1)
        $sql.=" AND leave_type=".db_escape($leave_type);



    $res = db_query($sql,'no record');
    $row = db_fetch($res);
    // display_error($sql);
   return $row;
   //  if($row)
   //    return 'PL';
   // else     
   //     return '--';
 
}

function check_emp_leave_this_month($emp_id,$month,$year,$leave_type){

  $sql = "SELECT * FROM ".TB_PREF."attendance where  emp_id = ".db_escape($emp_id)." AND   is_leave = 1  AND approved=1 AND leave_type=".db_escape($leave_type)."  AND  
    ( MONTH(from_leave)=".db_escape($month)."  AND YEAR(from_leave)=".db_escape($year)." ) OR
    ( MONTH(to_leave)=".db_escape($month)." AND YEAR(to_leave)=".db_escape($year)."   ) " ;
  
    $res = db_query($sql,'no record');
    $row = db_fetch($res);
    // display_error($sql);
   return $row;

}

function get_leave($id)
{
  $sql = "SELECT * FROM ".TB_PREF."attendance where id = ".db_escape($id)."";
    $res = db_query($sql,'no record');
    $row = db_fetch($res);
    // display_error($sql);
   return $row;
 
}

function get_month_days($emp_id,$month,$year)
{
  // $sql = "SELECT * FROM ".TB_PREF."attendance where emp_id = ".db_escape($emp_id)."
  //          AND MONTH(att_date)=".db_escape($month)."  AND YEAR(att_date)=".db_escape($year)." 
  //          AND overtime_id=0 AND is_leave=0 AND time_out!='' ";
  //   $res = db_query($sql,'no record');
    
    // $row = db_fetch($res);
    // display_error($sql);
   // return db_num_rows($res);
    $emp_hire_date=get_employees($emp_id)['emp_hiredate']; 
   
  $limit = days_in_month($month, $year);
   $days=0;
    for($d=1; $d<=$limit; $d++)
    {
      $time=mktime(12, 0, 0, $month, $d, $year);   
      
        if(strtotime($emp_hire_date)>strtotime(date('Y-m-d', $time)))
                 continue;      
      // if (date('m', $time)==$month)       
      //     $list[]=date('D', $time);
      $date=date('Y-m-d', $time);
       if(check_weekend(date('l', $time)))
             continue;
           
    //   if(check_holiday($date))
    //          continue;
      
     if(check_attended_added($emp_id, 0, sql2date($date), sql2date($date) ) )
          $days +=1  ;
    // display_error(date('Y-m-d', $time));
    }
// exit();
   // return db_num_rows($res);
    return $days;
 

}

function get_OverTime_hrs($emp_id,$month,$year, $factor=0)
{
  $sql = "SELECT SUM(hours_no) as hours_no , FORMAT(SUM(hours_no * rate),2) as hours_factor  FROM ".TB_PREF."attendance where emp_id = ".db_escape($emp_id)."
           AND MONTH(att_date)=".db_escape($month)."  AND YEAR(att_date)=".db_escape($year)." 
           AND overtime_id=1 AND is_leave=0 ";
    $res = db_query($sql,'no record');
    $row = db_fetch($res);
    // display_error($sql);
    if($factor)
   return $row['hours_factor'];
    else
   return $row['hours_no'];
 
}

function check_weekend($day)
{
  $sql = " SELECT * FROM ".TB_PREF."overtime_weekend WHERE UPPER(days) = ".db_escape(strtoupper($day))." ";
  // display_error($sql);
  $res = db_query($sql);
  $row = db_fetch($res);
  if($row['is_weekend']==1)
    return 1;
  else
    return 0;

}

function get_ot_weekend($day)
{
 $sql = " SELECT * FROM ".TB_PREF."overtime_weekend WHERE UPPER(days) = ".db_escape(strtoupper($day))." ";
 // display_error()
  $res = db_query($sql);
  $row = db_fetch($res);
 return $row;

}
function get_weekend(){
    $sql="SELECT * FROM ".TB_PREF."overtime_weekend WHERE is_weekend=1";

    return db_query($sql);

}

function check_holiday($date)
{
    $sql = "SELECT * FROM ".TB_PREF."payroll_holidays WHERE deleted = 0 ";
    if($date != null)
    $sql .= " AND date = '$date' ";
    $result = db_query($sql,"could not get holiday");
    return db_num_rows($result);
}

function get_weekends_in_month($month,$year,$emp_id=null)
{
  
    $res=get_weekend();
        $weekends=0;  
         $emp_hire_date=get_employees($emp_id)['emp_hiredate'];                 
    while ($row=db_fetch($res)) {


        $limit = days_in_month($month,$year);

       

        for($d=1; $d<=$limit; $d++)
        {

           $time=mktime(12, 0, 0, $month, $d, $year);  

          if(strtotime($emp_hire_date)>strtotime(date('Y-m-d', $time)))
            continue;      
          if(check_hiliday_by_date(date('Y-m-d', $time)))
            continue;



          if(check_leave($emp_id,date('Y-m-d', $time)))
          {
             continue;
          } 



         if(date('l', $time)==$row['days'])
           {
            // display_error(date('Y-m-d', $time)." == ".date('l', $time) ) ;     
              $weekends++;
           }

        }


       
        # code...
    }
        // display_error( "Total Count is: ".$weekends);

    return $weekends;

}

function get_holiday_in_month($month,$year,$emp_id=0){

    $sql = "SELECT * FROM ".TB_PREF."payroll_holidays WHERE deleted = 0 AND inactive=0 
            AND  MONTH(date)=".db_escape($month)."  AND YEAR(date)=".db_escape($year);
  $res = db_query($sql,'no get holidays');
  $holi_days=0;
 $emp_hire_date=get_employees($emp_id)['emp_hiredate']; 
while ($row=db_fetch($res)) {


  // display_error($row['date']);
        $time=mktime(12, 0, 0, $month, $d, $year); 
        
        
        if(strtotime($emp_hire_date)>strtotime(date('Y-m-d', $time)))
            continue;    

        // display_error(date('l', $time) ." ".date('l',strtotime($row['date'])));
        // if(date('l', $time)==date('l',strtotime($row['date'])))
        //           continue;
                  
                  

    if(check_leave($emp_id,$row['date']))
               continue;
               
        $holi_days++;         

  # code...
}

    // $row = db_fetch($res);
    // display_error($sql);
   return $holi_days;  //db_num_rows($res);
 
}

function check_hiliday_by_date($date){

    $sql = "SELECT * FROM ".TB_PREF."payroll_holidays WHERE deleted = 0 AND inactive=0 
              AND date=".db_escape($date);
   // $sql .= "  !inactive";
    // $sql .= " ORDER BY holidays ASC";
   $res = db_query($sql,'no get holidays');
    
    // $row = db_fetch($res);
    // display_error($sql);
   return db_num_rows($res);
 
}
function check_attended_this_date($att_date) {
    $sql = "SELECT * FROM ".TB_PREF."attendance WHERE att_date = '".date2sql($att_date)."'";
 
    // display_error($sql);
    // display_error(check_empty_result($sql));
    return check_empty_result($sql);
}
function delete_attendance($emp_id,$date)
{
 
 $sql="DELETE FROM ".TB_PREF."attendance WHERE emp_id = ".db_escape($emp_id)." AND att_date=".db_escape(date2sql($date))." AND is_leave=0" ;
 // display_error($sql);
 db_query($sql,'no delete attendance');
}