<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

function db_has_employee() {
	return check_empty_result("SELECT COUNT(*) FROM ".TB_PREF."employee");
}
function get_employee_max_id(){
	$sql = "SELECT MAX(emp_id) From ".TB_PREF."employee";
	$run= db_query($sql);
	// return $sql;
	return db_fetch($run)[0];
}
//--------------------------------------------------------------------------
function users_update($id){
    $sql = " UPDATE ".TB_PREF."users SET date_format = 1 , theme = 'synergy', show_codes = 1, show_hints = 1, startup_tab = 'dashboard', save_report_selections = 1 WHERE id = '$id' ";
    $result = db_query($sql);
}




function write_employee($id=false, $first_name, $last_name, $gender, $adrs, $mobile, $mail, $birth, $notes, $hire_date, $department, $salary, $release, $active,$role,$user_id,$emp_salary,$work_permit='' , $bank_name='' , $bank_account='' ,$iban='') {


	db_query("SET sql_mode = ''");
	if(!$id) {
		$sql = "INSERT INTO ".TB_PREF."employee VALUES ("
		.db_escape($id).", "
		.db_escape($first_name).", "
		.db_escape($last_name).", "
		.db_escape($gender).", "
		.db_escape($adrs).", "
		.db_escape($mobile).", "
		.db_escape($mail).", '"
		.date2sql($birth)."', "
		.db_escape($notes).", '"
		.date2sql($hire_date)."', "
		.db_escape($department).", "
		.db_escape($salary).", "
		.db_escape($emp_salary)	.",'"
		.date2sql($release)."', "
		.db_escape($active).", "
		.db_escape($user_id).", "
		.db_escape($role).","
		.db_escape($work_permit).","
		.db_escape($bank_name).","
		.db_escape($bank_account).","
		.db_escape($iban)."
		)"; 

		// display_error($sql);
		// exit;
		$msg = "Add Employee";
		db_query($sql, _('Could not write employee data'));
		$emp_id = get_employee_max_id();
		$employee_name = $first_name." ".$last_name;
		// if ($role == '15') {
		// 	add_user($employee_name, $employee_name, md5('1234'), $mobile, $mail, $role, 
	 // 'C', null, 1, 1, 0, 0,null, null,'','','','','',1,0,0,$emp_id);
  //           $user_id = db_insert_id();
		// 	users_update($user_id);
		// }

	}
	else {
		$sql = "UPDATE ".TB_PREF."employee SET 
		emp_first_name = ".db_escape($first_name).", 
		emp_last_name = ".db_escape($last_name).", 
		gender = ".db_escape($gender).", 
		emp_address = ".db_escape($adrs).", 
		emp_mobile = ".db_escape($mobile).", 
		emp_email = ".db_escape($mail).", 
		emp_birthdate = '".date2sql($birth)."', 
		emp_notes = ".db_escape($notes).", 
		emp_hiredate = '".date2sql($hire_date)."', 
		department_id = ".db_escape($department).", 
		salary_scale_id = ".db_escape($salary).", 
		emp_releasedate = '".date2sql($release)."', 
		user_id = ".db_escape($user_id).", 
		inactive = ".db_escape($active)." ,
		emp_salary = ".db_escape($emp_salary)." ,
		work_permit = ".db_escape($work_permit).",
		bank_name = ".db_escape($bank_name).",
		bank_account = ".db_escape($bank_account).",
		iban = ".db_escape($iban)." 

		WHERE emp_id = ".db_escape($id);
		$msg = "Edit Employee";
		$emp_id = $id;
		db_query($sql, _('Could not write employee data'));
	}

	add_audit_trail(SA_HRMEMP, $emp_id, Today(),$msg);
}

//--------------------------------------------------------------------------

function get_employees($id = false, $all = false, $department = false,$user_id=0) {
	
	$sql = "SELECT *, CONCAT(emp_first_name, ' ', emp_last_name) AS name FROM ".TB_PREF."employee";
	$where = array();
	
	if(!$all)
		$where[] = "!inactive";
	if($id)
		$where[] = "emp_id=".db_escape($id);
	if($department)
		$where[] = "department_id = ".db_escape($department);
		if($user_id)
		$where[] = "user_id = ".db_escape($user_id);
		
	if(count($where))
		$sql .= ' WHERE '.implode(' AND ', $where);
	else
		$sql .= ' WHERE 1';

	$result = db_query($sql, _('Could not get employee data.'));
	
	if($id)
		return db_fetch($result);
	else
		return $sql;
}



//--------------------------------------------------------------------------

function delete_employee($id) {
	$sql = "DELETE FROM ".TB_PREF."employee WHERE emp_id = ".db_escape($id);
	db_query($sql, _('Could not delete employee data.'));
	add_audit_trail(SA_HRMEMP, $id, Today(),"Deleted Employee");
}

//--------------------------------------------------------------------------

function emp_img_name($emp_id) {

	$emp_id = strtr($emp_id, "><\\/:|*?", '________');
	return clean_file_name($emp_id);
}

//--------------------------------------------------------------------------

function check_employee_hired($id, $date) {

    $sql = "SELECT emp_hiredate FROM ".TB_PREF."employee WHERE emp_id = ".db_escape($id);
    $result = db_query($sql, _('could not get employee data'));
    $check = db_fetch($result);
    
    if(sql_date_comp(date2sql($date), $check[0]) < 0)
        return false;
    else
        return true;
}

//--------------------------------------------------------------------------

function employee_has_salary_scale($id) {
	return check_empty_result("SELECT salary_scale_id FROM ".TB_PREF."employee WHERE salary_scale_id != 0 AND emp_id = ".db_escape($id));
}

//--------------------------------------------------------------------------

function emp_salaryscale_has_structure($id) {
	return check_empty_result("SELECT e.salary_scale_id, s.* FROM ".TB_PREF."employee e, ".TB_PREF."salary_structure s WHERE e.salary_scale_id = s.salary_scale_id AND e.emp_id = ".db_escape($id));
}

function get_allowances_name($allow_id)
{
	$sql = " SELECT allowances FROM ".TB_PREF."payroll_allowances WHERE deleted = 0 and id=".db_escape($allow_id);
	$result = db_query($sql, "could not get allowance name");
	return db_fetch($result);
	//return $row[0];
        
}
/*function get_allowances($selected_id)
{
	$sql = " SELECT * FROM ".TB_PREF."payroll_allowances_deductions WHERE  is_allowances = 1 AND employee_id=".db_escape($selected_id);
       $result = db_query($sql , "no allowances returned");
	return db_fetch($result);
}
*/
function get_allowance($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."payroll_allowances_deductions WHERE deleted = 0 AND is_allowances = 1 AND id=".db_escape($selected_id);
	$result = db_query($sql, "could not get allowances");
	return db_fetch($result);
}

function add_allowance($employee_id,$allowance,$amount,$remarks)
{	
	$sql = "INSERT INTO ".TB_PREF."payroll_allowances_deductions (employee_id,allow_deduct_id,amount,remarks,is_allowances) VALUES (".db_escape($employee_id).",".db_escape($allowance).",$amount,".db_escape($remarks).",1)";
	db_query($sql,"The allownaces could not be added");
	if ($sql != null)
add_audit_trail(ST_PAYROLL_IMP_EMPLOYEE_ALL_DEDUCT, db_insert_id(), date('d/m/Y'), "Allownaces Added",$amount,date('Y-m-d'));  

}

function update_allowance($id,$employee_id,$allowance_deduction,$amount,$remarks)
{
	$sql = "UPDATE ".TB_PREF."payroll_allowances_deductions SET employee_id=".db_escape($employee_id).", 
		allow_deduct_id=".db_escape($allowance_deduction).",
		amount=".db_escape($amount).", 
		remarks=".db_escape($remarks)." 		
		WHERE id = ".db_escape($id);
	db_query($sql,"The allownaces could not be updated");
	if ($sql != null)
add_audit_trail(ST_PAYROLL_IMP_EMPLOYEE_ALL_DEDUCT, $id, date('d/m/Y'), "Allownaces Updated",$amount,date('Y-m-d'));  

}

function delete_allowance($selected_id)
{
	$query = "SELECT amount from ".TB_PREF."payroll_allowances_deductions WHERE id=".db_escape($selected_id);	
	$res = db_query($query,"");
	$row = db_fetch($res);
	$amount = $row['amount'];
	$sql = "UPDATE ".TB_PREF."payroll_allowances_deductions SET deleted = 1 WHERE is_allowances = 1 AND id=".db_escape($selected_id);
	db_query($sql,"cannot delete allowances");


if ($sql != null)
add_audit_trail(ST_PAYROLL_IMP_EMPLOYEE_ALL_DEDUCT, $selected_id, date('d/m/Y'), "Allownaces Deleted",$amount,date('Y-m-d'));  
}

function get_deductions_name($allow_id)
{
	$sql = "SELECT deductions FROM ".TB_PREF."payroll_deductions WHERE deleted = 0 AND id=".db_escape($allow_id);
	$result = db_query($sql, "could not get deductions name");
	return db_fetch($result);
}

/*function get_deductions($employee_id){
	$sql = "SELECT * FROM ".TB_PREF."payroll_allowances_deductions WHERE is_allowances = 2 AND employee_id=".db_escape($employee_id);
	$result = db_query($sql,"could not get allowances");
	return db_fetch($result);
}*/

function get_deduction($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."payroll_allowances_deductions WHERE  deleted = 0 AND is_allowances = 2 AND id=".db_escape($selected_id);
	$result = db_query($sql, "could not get allowances");
	return db_fetch($result);
}

function add_deductions($employee_id,$allowance,$amount,$remarks)
{
	$sql = "INSERT INTO ".TB_PREF."payroll_allowances_deductions (employee_id,allow_deduct_id,amount,remarks,is_allowances) VALUES (".db_escape($employee_id).",".db_escape($allowance).",".db_escape($amount).",".db_escape($remarks).",2)";
	db_query($sql,"The allownaces could not be added");
	if ($sql != null)
add_audit_trail(ST_PAYROLL_IMP_EMPLOYEE_ALL_DEDUCT, db_insert_id(), date('d/m/Y'), "Deductions Added",$amount,date('Y-m-d'));  

}

function update_deductions($id,$employee_id,$allowance_deduction,$amount,$remarks)
{
	$sql = "UPDATE ".TB_PREF."payroll_allowances_deductions SET employee_id=".db_escape($employee_id).",
		allow_deduct_id=".db_escape($allowance_deduction).",
		amount=".db_escape($amount).",
		remarks=".db_escape($remarks)."
		WHERE id = ".db_escape($id);
	db_query($sql,"The allownaces could not be updated");
	if ($sql != null)
add_audit_trail(ST_PAYROLL_IMP_EMPLOYEE_ALL_DEDUCT, $id, date('d/m/Y'), "Deduction Update",$amount,date('Y-m-d'));  

}

function delete_deductions($selected_id)
{
	$query = "SELECT amount from ".TB_PREF."payroll_allowances_deductions WHERE id=".db_escape($selected_id);
	
	$res = db_query($query,"");
	$row = db_fetch($res);
	$amount = $row['amount'];
	
	$sql = "UPDATE ".TB_PREF."payroll_allowances_deductions SET deleted = 1 WHERE is_allowances = 2 AND id=".db_escape($selected_id);
	// $sql = "UPDATE ".TB_PREF."payroll_allowances_deductions SET deleted = 1 WHERE is_allowances = 1 AND id=".db_escape($selected_id);

	db_query($sql,"cannot delete allowances");
	if ($sql != null)
add_audit_trail(ST_PAYROLL_IMP_EMPLOYEE_ALL_DEDUCT, $selected_id, date('d/m/Y'), "Deduction Deleted",$amount, date('Y-m-d'));  

}

function check_deductions_from($employee_id,$allow_deduct_id){
	$sql = "SELECT id FROM ".TB_PREF."payroll_allowances_deductions WHERE   deleted = 0 AND  is_allowances = 2 AND allow_deduct_id = ".db_escape($allow_deduct_id)." AND employee_id = ".db_escape($employee_id);
	$result = db_query($sql, "Cannot retreive a deductions");
	return (db_num_rows($result) > 0);
}

function check_allowance($employee_id,$allow_deduct_id){
	$sql = "SELECT id FROM ".TB_PREF."payroll_allowances_deductions WHERE  deleted = 0 AND  is_allowances = '1' AND allow_deduct_id = ".db_escape($allow_deduct_id)." AND employee_id = ".db_escape($employee_id);	
	$result = db_query($sql, "Cannot retreive a allowance");
	return (db_num_rows($result) > 0);
}
function check_employee($employee_id){
	$sql = "SELECT id FROM ".TB_PREF."payroll_employee WHERE  deleted = 0 AND employee_id = ".db_escape($employee_id);	
	$result = db_query($sql, "Cannot retreive a employee");
	return (db_num_rows($result) > 0);
}

function getsum_allowances($employee_id,$no_sum){
$sql = "SELECT ";
  $sql.= ($no_sum) ? "ded_all.*" :"SUM(ded_all.amount) AS amounts "; 
  $sql.="FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
WHERE   deleted = 0 AND  is_allowances = 1 AND employee_id = ".db_escape($employee_id)."";
return db_query($sql , "no");

}
function getsum_deductions($employee_id,$no_sum=0){
$sql = "SELECT " ;

$sql .= ($no_sum) ? "ded_all.*" :"SUM(ded_all.amount) AS amounts "; 

$sql.= " FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
WHERE   deleted = 0 AND  is_allowances = 2 AND employee_id = ".db_escape($employee_id)." ";
// display_error($sql);
return db_query($sql , "no");
}
function check_payslip($emp_id=0,$month,$year){
	
    $sql="SELECT * FROM ".TB_PREF."emp_payslip_trans WHERE  
         month_id=".db_escape($month)." AND year_id=".db_escape($year)." ";
	if($emp_id)
	$sql.=" AND emp_id=".db_escape($emp_id)." ";

	  $sql.=" AND generate_payroll=".db_escape(1)." AND process_payroll=".db_escape(1)." ";
	

    $res=db_query($sql);
    $row = db_fetch($res);      

  return $row;
}

function check_generate_payslip($emp_id=0,$month,$year){
	
    $sql="SELECT * FROM ".TB_PREF."emp_payslip_trans WHERE  
         month_id=".db_escape($month)." AND year_id=".db_escape($year)." ";
	if($emp_id)
	$sql.=" AND emp_id=".db_escape($emp_id)." ";

	
	  $sql.=" AND generate_payroll=".db_escape(1)."  "; //AND process_payroll=".db_escape(0)."

    $res=db_query($sql);
    $row = db_fetch($res);      

  return $row;
}


function add_payroll_allocation($amount, $trans_type_from, $trans_no_from,
	$trans_type_to, $trans_no_to, $person_id, $date_)
{
	$date = date2sql($date_);
	$sql = "INSERT INTO ".TB_PREF."payroll_allocations (
		amt, date_alloc,
		trans_type_from, trans_no_from, trans_no_to, trans_type_to, person_id)
		VALUES ($amount, '$date', ".db_escape($trans_type_from).", ".db_escape($trans_no_from).", ".db_escape($trans_no_to)
		.", ".db_escape($trans_type_to).", ".db_escape($person_id).")";
     add_audit_trail($trans_type_from, $person_id, Today(), _("Create payslip Allocation"));
	db_query($sql, "A payslip allocation could not be added to the database");
}

function get_all_payroll_alloc_to($trans_type_to,$trans_no_to)
{
	$sql="SELECT payroll_alloc.*,bt.id as bt_id  FROM ".TB_PREF."payroll_allocations payroll_alloc LEFT JOIN 
	  ".TB_PREF."bank_trans bt on payroll_alloc.trans_type_from=bt.type AND payroll_alloc.trans_no_from=bt.trans_no AND bt.amount>0  WHERE payroll_alloc.trans_type_to=".db_escape($trans_type_to)." AND payroll_alloc.trans_no_to=".db_escape($trans_no_to)." GROUP BY trans_no_from";

		$result = db_query($sql, "Cannot fount receipt allocation");
	// $row = db_fetch($result);
	// display_error($sql);
    return $result;
}

function get_all_payroll_alloc_from($trans_type_to,$trans_no_to,$is_amount=0)
{
	if($is_amount)
	$sql.="SELECT SUM(payroll_alloc.amt) as amount,bt.id as bt_id ";
    else
    $sql.="SELECT payroll_alloc.*,bt.id as bt_id ,abs(bt.amount) as paymrnt_amt ";	
	              //SELECT payroll_alloc.*,bt.id as bt_id
	$sql.="  FROM ".TB_PREF."payroll_allocations payroll_alloc LEFT JOIN 
	  ".TB_PREF."bank_trans bt on payroll_alloc.trans_type_from=bt.type AND payroll_alloc.trans_no_from=bt.trans_no AND abs(bt.amount)>0  WHERE payroll_alloc.trans_type_from=".db_escape($trans_type_to)." AND payroll_alloc.trans_no_from=".db_escape($trans_no_to)."";

		$result = db_query($sql, "Cannot fount receipt allocation");
	// $row = db_fetch($result);

    return $result;

}

function get_payrol_alloc_id($id){

	$sql="SELECT * FROM ".TB_PREF."payroll_allocations  WHERE id=".db_escape($id);
	// display_error($sql);
    $result = db_query($sql, "Cannot fount receipt allocation");
   return db_fetch($result);

}
function check_allowances($employee_id){
$sql = " SELECT  COUNT(id) FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
WHERE   deleted = 0 AND  is_allowances = 1 AND employee_id = ".db_escape($employee_id)." ";
$trans = db_query($sql,"no returned");
$myrow = db_fetch($trans);
return $myrow[0];
}