<?php


include_once($path_to_root . "/payroll/includes/ui_lists/ui_lists.inc");

// Standard report classess
define('RC_CUSTOMER', 0);
define('RC_SUPPLIER', 1);
define('RC_INVENTORY', 2);
define('RC_MANUFACTURE', 3);
define('RC_DIMENSIONS', 4);
define('RC_BANKING', 5);
define('RC_GL', 6);
define('RC_FIXEDASSETS', 7);

define('RC_PR_REP', 8); //zaid
define('RC_PR',9);
define('FTA_VAT', 10);

class BoxReports
{
	var $ar_classes; // report class names
	var $ar_reports;
	var $reporting;
	var $ctrl_handlers = array();

	function ReportClasses()
	{
		$this->ar_classes = array();
	}

	function addReportClass($class_name, $class_id=null)
	{
		if (!$class_id)
			$class_id = count($this->ar_classes);
		$this->ar_classes[$class_id] = $class_name;

		return $class_id;
	}

	function addReport($class, $id, $rep_name, $params=null)
	{
		unset($this->ar_reports[$class][$id]); // unset std report if any
		$this->ar_reports[$class][$id] = new Report($id, $rep_name, $params);
	}
//pk__________________________________________________________________________________
function report_list_row($name,$selected_id =null,$label = null,$submit_on_change= false)
	{
		global $path_to_root, $SysPrefs, $Ajax;

		if (find_submit('Rep') != -1) {
			include($path_to_root.'/reporting/prn_redirect.php');
			return;
		}

		$temp = array_values($this->ar_classes);
		$display_class = @$class==null ? $temp[0] : $this->ar_classes[$class];
		$st_reports = "";
		$st_params = "";
	//	$st_classes = "<b>" . _("Report Classes:") . "</b><br>";

		if (isset($_GET['Class']))
			set_focus('class'.$_GET['Class']);

		$cur_class = @$_REQUEST['Class'];

		foreach($this->ar_classes as $class_id => $name)
		{
			if (!isset($this->ar_reports[$class_id]))
				continue; // e.g. no dimensions

		//	$acc = access_string($name);
		/*	$st_classes .= "<a href='"
				.$_SERVER['PHP_SELF']."?Class=$class_id'"
				." style='font-weight:". ($cur_class == $class_id ? 'bold' : 'normal')."'"
				." class='repclass_link' id='".'class'.$class_id."'"
				."$acc[1]>$acc[0]</a> <br>";*/

			$style = $class_id==$cur_class ? '' : "style='display:none'";
			$st_reports .= "<table class='repclass' id='TAB_" . $class_id ."' $style cellpadding='0' cellspacing='0' border='0' width='100%'><tr><td><b>" . _("Reports For Class: ") . "&nbsp;$name</b></td></tr>\n";

			$rep['0'] ='All Signatures';
			foreach($this->ar_reports[$class_id] as $rep_id => $report)
			{
				$acc = access_string($report->name);
				// $rep[$rep_id] = $report->id ."==".$report->name;
				$rep[$report->id] = $rep_id."-".access_string($report->name,true);
				// $report_array[] = $rep_id.";".$report->name;
			/*	$st_reports .= "<tr><td><a class='repopts_link'"
					." href='".$_SERVER['PHP_SELF']."?Class=$class_id&REP_ID=$report->id'"
					." style='font-weight:". (@$_REQUEST['REP_ID'] == $report->id ? 'bold' : 'normal')."'"
					." id='".$id = default_focus()."'"
					."$acc[1]>$acc[0]</a><tr><td>\n";*/

				// if (@$_REQUEST['REP_ID'] == $report->id) {
				// 	$Ajax->activate($id);
				// }

			/*	if (isset($_REQUEST['REP_ID']) && $_REQUEST['REP_ID']==$report->id) {
					// parameters form
					$action = $_SERVER['PHP_SELF'];
					$st_params = "<table><tr><td>\n"
						. "<form method='POST' action='$action' target='_blank' style=' padding-right: 17px;padding-bottom:5px; padding-left: 10px;' >\n";
					$st_params .= submit('Rep'.$report->id,  
						_("Display: ") . access_string($report->name, true),
						false, '', $SysPrefs->pdf_debug ? false : 'default process') . hidden('REP_ID', $report->id, false).'<br><br>';
					$st_params .= $this->getOptions($report->get_controls(), $report->id);
					$st_params .= "\n<input type=hidden name='Class' value=".$cur_class.">"
						."\n</form></td></tr></table>\n";
					set_focus('Rep'.$report->id);
					$Ajax->addUpdate(true, 'rep_form', $st_params);
				}*/
			}
			$st_reports .= "</table>";
			
			/*foreach ($report_array as  $value) {
				$postion = strrpos($value, ";");
				$id = substr($value, 0, $postion);
				$report_name = substr($value, $postion+1);
				$Report_name = str_replace('&', '', $report_name);

				$Report_array[$id] = $Report_name;
			}*/
			
		}
// print_r($rep);
if($label != null)
	echo "<td>".$label."<td>";

 echo "<td>";
 echo array_selector($name, $selected_id, $rep, 
  array( 
   'select_submit'=> @$submit_on_change,
   'async' => false ) ); // FIX?
 echo "</td>";
	}
//pk--------------------------------------------------------------------------		

    
	function getDisplay($class=null)
	{
		global $path_to_root, $SysPrefs, $Ajax;
		
		if(isset($_GET['Class'])){
			$_POST['form_class'] = $_GET['Class'];
		}

		
		start_form();
		// echo '<div style="float:left">';
		start_table(TABLESTYLE2, "style='width:100% !important'",'','',1);
		// table_section(1);
		get_form_class(_(""), 'form_class', null,  true) ;

		end_outer_table(1);
		// echo '</div>';
		end_form();



		if(list_updated('form_class')){
			$Ajax->activate('_page_body');
		}
		if (find_submit('Rep') != -1) {
			include($path_to_root.'/reporting/prn_redirect.php');
			return;
		}

		$temp = array_values($this->ar_classes);
		$display_class = $class==null ? $temp[0] : $this->ar_classes[$class];
		$st_reports = "";
		$st_params = "";
		$st_classes = "<b>" . _("Report Classes:") . "</b><br>";

		if (isset($_GET['Class']))
			set_focus('class'.$_GET['Class']);

		$cur_class = $_REQUEST['Class'];

		foreach($this->ar_classes as $class_id => $name)
		{

			if($_POST['form_class'] == 0){
				$name = 'Customer';
			}if($_POST['form_class'] == 1){
				$name = 'Supplier';
			}if($_POST['form_class'] == 2){
				$name = 'Inventory';
			}if($_POST['form_class'] == 3){
				$name = 'Manufacturing';
			}if($_POST['form_class'] == 4){
				$name = 'Dimensions';
			}if($_POST['form_class'] == 5){
				$name = 'Banking';
			}if($_POST['form_class'] == 6){
				$name = 'General Ledger';
			}if($_POST['form_class'] == 7){
				$name = 'Fixed Assets';
			}if($_POST['form_class'] == 8){
				$name = 'Payroll';
			}if($_POST['form_class'] == 10){
				$name = 'VAT';
			}

			if($_POST['form_class'] != 'ALL_TEXT'){
				$form = $_POST['form_class'];

			


			if (!isset($this->ar_reports[$form]))
				continue; // e.g. no dimensions

				// if($report_name == $name){
				$acc = access_string($name);

			$st_classes .= "<a href='"
				.$_SERVER['PHP_SELF']."?Class=$class_id'"
				." style='font-weight:". ($cur_class == $class_id ? 'bold' : 'normal')."'"
				." class='repclass_link' id='".'class'.$class_id."'"
				."$acc[1]>$acc[0]</a> <br>";


			$style = $class_id==$cur_class ? '' : "style='display:none'";
			$st_reports .= "<table class='table table-hover' id='TAB_" . $class_id ."' $style cellpadding='0' cellspacing='0' border='0' ><tr><td><div class='progress' style='margin-top: -2%; margin-top: -2%;height: 30px;width: 100%;'><div class='progress-bar' role='progressbar' aria-valuenow='70' aria-valuemin='0' aria-valuemax='100' style='width:198px; background:#00ace6; padding-top: 5px;'>" . _("Reports For Class: ") . "&nbsp;$name</div></div></td></tr>\n";
			foreach($this->ar_reports[$form] as $rep_id => $report)
			{
				 // diplay_error($rep_id);
				$acc = access_string($report->name);
				$post = $_POST['form_class'];				
				$st_reports .= "<tr><td><i class='fa fa-angle-double-right' style = 'color:black'></i><a class='repopts_link'"
					." href='".$_SERVER['PHP_SELF']."?Class=$post&REP_ID=$report->id'"
					." style='color:black; font-weight:". (@$_REQUEST['REP_ID'] == $report->id ? 'bold' : 'normal')."'"
					." id='".$id = default_focus()."'"
					."$acc[1]> $acc[0]</a><tr></td>\n";


				if (@$_REQUEST['REP_ID'] == $report->id) {
					$Ajax->activate($id);
				}
//background:#959fa108; width: 150%; margin-top: 2%; box-shadow:  -1px 2px 4px 4px;
				if (isset($_REQUEST['REP_ID']) && $_REQUEST['REP_ID']==$report->id) {
					// parameters form
					$action = $_SERVER['PHP_SELF'];
					$st_params = "<table><tr><td>\n"
						. "<div class = 'container' style='background: #ffffff;width: 150%;box-shadow: 1px 1px 10px 0px;border: #00ace6 4px solid;border-radius: 10px;'><div class = 'row' style='float:center;'><div class='col-sm-10'><form method='POST' action='$action' target='_blank' style=' padding-right: 17px;padding-bottom:5px; padding-left: 10px;' >\n";
					$st_params .= submit('Rep'.$report->id,  
						_("Display: ") . access_string($report->name, true),
						false, '', $SysPrefs->pdf_debug ? false : 'default process',false,null,'8px','left ! important','#00ace6') . hidden('REP_ID', $report->id, false).'<br><br><div class="form-group">';

					$st_params .= $this->getOptions($report->get_controls(), $report->id);
					// echo '</div>';
					$st_params .= "\n<input type=hidden name='Class' value=".$cur_class.">"
						."\n</form></div></div></div></div></div><br></td></tr></table>\n";
					set_focus('Rep'.$report->id);
					$Ajax->addUpdate(true, 'rep_form', $st_params);
				}
			}
			$st_reports .= "</table>";
			//}
			}
		}

		$st_params = "<div id='rep_form'>".
			"$st_params</div>";
		if($_POST['form_class'] != 'ALL_TEXT'){

		$st = "<div class ='row'><div class='col-sm-10 col-md-10'><div class = 'table-responsive'><table align='' class='.table-striped' style='width: 100% !important; border none;'><tr valign='top'>";
		// $st .= "<td width='30%'style='padding-left: 10px; >$st_classes</td>";<div class='container'>
		$st .= "<td  style='width:12%; #cccccc;padding-left:10px; padding-right: 10px;'>$st_reports</td>";
		$st .= "<td style='width:17%; float:center;'>$st_params</td>";

		$st .= "</tr></table></div></div></div><br>";//</div>
		}
		return $st;
	}


/*	function getDisplay($class=null)
	{
		global $path_to_root, $SysPrefs, $Ajax;

		if (find_submit('Rep') != -1) {
			include($path_to_root.'/reporting/prn_redirect.php');
			return;
		}

		$temp = array_values($this->ar_classes);
		$display_class = $class==null ? $temp[0] : $this->ar_classes[$class];
		$st_reports = "";
		$st_params = "";
		$st_classes = "<b>" . _("Report Classes:") . "</b><br>";

		if (isset($_GET['Class']))
			set_focus('class'.$_GET['Class']);

		$cur_class = $_REQUEST['Class'];

		foreach($this->ar_classes as $class_id => $name)
		{
			if (!isset($this->ar_reports[$class_id]))
				continue; // e.g. no dimensions

			$acc = access_string($name);
			$st_classes .= "<a href='"
				.$_SERVER['PHP_SELF']."?Class=$class_id'"
				." style='font-weight:". ($cur_class == $class_id ? 'bold' : 'normal')."'"
				." class='repclass_link' id='".'class'.$class_id."'"
				."$acc[1]>$acc[0]</a> <br>";

			$style = $class_id==$cur_class ? '' : "style='display:none'";
			$st_reports .= "<table class='repclass' id='TAB_" . $class_id ."' $style cellpadding='0' cellspacing='0' border='0' width='100%'><tr><td><b>" . _("Reports For Class: ") . "&nbsp;$name</b></td></tr>\n";
			foreach($this->ar_reports[$class_id] as $rep_id => $report)
			{
				$acc = access_string($report->name);
				$_SESSION['report_array_id'][] = $report->name.";".$rep_id;
				
				$st_reports .= "<tr><td><a class='repopts_link'"
					." href='".$_SERVER['PHP_SELF']."?Class=$class_id&REP_ID=$report->id'"
					." style='font-weight:". (@$_REQUEST['REP_ID'] == $report->id ? 'bold' : 'normal')."'"
					." id='".$id = default_focus()."'"
					."$acc[1]>$acc[0]</a><tr><td>\n";

				if (@$_REQUEST['REP_ID'] == $report->id) {
					$Ajax->activate($id);
				}

				if (isset($_REQUEST['REP_ID']) && $_REQUEST['REP_ID']==$report->id) {
					// parameters form
					$action = $_SERVER['PHP_SELF'];
					$st_params = "<table><tr><td>\n"
						. "<form method='POST' action='$action' target='_blank' style=' padding-right: 17px;padding-bottom:5px; padding-left: 10px;' >\n";
					$st_params .= submit('Rep'.$report->id,  
						_("Display: ") . access_string($report->name, true),
						false, '', $SysPrefs->pdf_debug ? false : 'default process') . hidden('REP_ID', $report->id, false).'<br><br>';
					$st_params .= $this->getOptions($report->get_controls(), $report->id);
					$st_params .= "\n<input type=hidden name='Class' value=".$cur_class.">"
						."\n</form></td></tr></table>\n";
					set_focus('Rep'.$report->id);
					$Ajax->addUpdate(true, 'rep_form', $st_params);
				}
			}
			$st_reports .= "</table>";
		}

		$st_params = "<div id='rep_form'>".
			"$st_params</div>";
		
		$st = "<table align='center' width='80%' style='border:1px solid #cccccc;'><tr valign='top'>";
		$st .= "<td width='30%'style='padding-left: 10px; >$st_classes</td>";
		$st .= "<td width='35%' style='border-left:1px solid #cccccc;border-right:1px solid #cccccc;padding-left:10px; padding-right: 10px;;'>$st_reports</td>";
		$st .= "<td width='35%'>$st_params</td>";
		$st .= "</tr></table><br>";

		return $st;
	}
*/
	function getOptions($controls, $id = 0)
	{
		$st = '';
		if ($controls == null)
			return "";

		$cnt = 0;
		foreach($controls as $title => $type)
		{
			$ctrl = '';
			foreach($this->ctrl_handlers as $fun) { // first check for non-standard controls
				$ctrl = $fun('PARAM_'.$cnt, $type);
				if ($ctrl) break;
			}
			if ($ctrl == '') {
				if (($id == 102 || $id == 202) && $cnt == 3) // set default Show Also Allocated to Yes in aged reports 2014-09-19 Joe Hunt
					$_POST['PARAM_'.$cnt] = 1;
				
				if (isset($_COOKIE['select'][$id][$cnt])) // saved parameters 2010-10-06 Joe Hunt
					$_POST['PARAM_'.$cnt] = $_COOKIE['select'][$id][$cnt];
				$ctrl = $this->get_ctrl('PARAM_'.$cnt, $type);
			}
			if ($ctrl != '')  {
				$st .= $title . ':<br>';
				$st .= $ctrl;
				$st .= "";
			} else {
				display_error(_('Unknown report parameter type:').$type);
			}
			$cnt++;
		}
		return $st;
	}

	//
	//	Register additional control handler
	// $handle - name of global function f($name, $type) returning html code for control
	function register_controls($handler) {
		$this->ctrl_handlers[] = $handler;
	}
	//
	//	Returns html code for input control $name of type $type 
	//
	
	function get_ctrl($name, $type)
	{
		global $path_to_root, $SysPrefs,
			$type_shortcuts;

		$st = '';
			switch ($type)
			{
				case 'CURRENCY':
					$sql = "SELECT curr_abrev, concat(curr_abrev,' - ', currency) AS name FROM ".TB_PREF."currencies";
					return combo_input($name, '', $sql, 'curr_abrev', 'name',array('spec_option'=>_("No Currency Filter"),'spec_id'=>ALL_TEXT,'order'=>false));

				case 'DATE':
				case 'DATEBEGIN':
				case 'DATEEND':
				case 'DATEBEGINM':
				case 'DATEENDM':
				case 'DATEBEGINTAX':
				case 'DATEENDTAX':
					if (!isset($_POST[$name]))
					{
						if ($type == 'DATEBEGIN')
							$date = begin_fiscalyear();
						elseif ($type == 'DATEEND')
							$date = end_fiscalyear();
						else
							$date = Today();
						if ($type == 'DATEBEGINM')
							$date = begin_month($date);
						elseif ($type == 'DATEENDM')
							$date = end_month($date);
						elseif ($type == 'DATEBEGINTAX' || $type == 'DATEENDTAX')
						{
							$row = get_company_prefs();
							$edate = add_months($date, -$row['tax_last']);
							$edate = end_month($edate);
							if ($type == 'DATEENDTAX')
								$date = $edate;
							else
							{
								$bdate = begin_month($edate);
								$bdate = add_months($bdate, -$row['tax_prd'] + 1);
								$date = $bdate;
							}
						}
					}
					else // saved parameters
						$date = $_POST[$name];
					$st = "<div class='input-group field-width'><input type='text' name='$name' class='date acitve form-control' value='$date'><span class='input-group-addon'><i class='fa fa-calendar'></i></span></div>";
					// if (user_use_date_picker())
					// {
						// $calc_image = (file_exists("$path_to_root/themes/".user_theme()."/images/cal.gif")) ? 
						// 	"$path_to_root/themes/".user_theme()."/images/cal.gif" : "$path_to_root/themes/default/images/cal.gif";
						// $st .= "<a href=\"javascript:date_picker(document.forms[0].$name);\">"
						// . "	<img src='$calc_image' style='vertical-align:middle;padding-bottom:4px;width:16px;height:16px;border:0;' alt='"._('Click Here to Pick up the date')."'></a>\n";
//					}	
					return $st;
					break;

				case 'YES_NO':
					return yesno_list($name);

				case 'CLEARED_UNCLEARED':
					return clearedUnclearedCheque($name);

				case 'PAYMENT_LINK':
					return payment_services($name, null);

				case 'DESTINATION':
					$sel = array(_("PDF/Printer"), "Excel");
					$def = 0;
					if (user_def_print_destination() == 1)
						$def = 1;
					return array_selector($name, $def, $sel);

				case 'ORIENTATION':
					$sel = array(_("Portrait"), _("Landscape"));
					$def = 0;
					if (user_def_print_orientation() == 1)
						$def = 1;
					return array_selector($name, $def, $sel);

				case 'COMPARE':
					$sel = array(_("Accumulated"), _("Period Y-1"), _("Budget"));
					return array_selector($name, null, $sel);

				case 'GRAPHIC':
					$sel = array(_("No Graphics"), _("Vertical bars"), _("Horizontal bars"), 
								_("Dots"), _("Lines"), _("Pie"), _("Donut"));
					return array_selector($name, null, $sel);

				case 'SYS_TYPES':
					return gl_systypes_list($name, null, _("No Type Filter"));

				case 'SYS_TYPES_ALL':
					return systypes_list($name, null, _("No Type Filter"));

				case 'TEXT':
					return "<input type='text' class='form-control' name='$name'>";

				case 'TEXTBOX':
					$value = (isset($_POST[$name]) ? $_POST[$name] : "");
					return "<textarea rows=4 cols=30 class='form-control' maxlength=130 name='$name'>$value</textarea>";

				case 'ACCOUNTS': // not used
					return gl_account_types_list($name, null, _("No Account Group Filter"), true);

				case 'ACCOUNTS_NO_FILTER': // not used
					return gl_account_types_list($name);

				case 'GL_ACCOUNTS':
					return gl_all_accounts_list($name);

// function bank_accounts_list($name, $selected_id=null, $submit_on_change=false, $spec_option=false, $pdc_recieve=null, $pdc_issue=null, $onlypdc=false)
				case 'BANK_ACCOUNTS':
					return bank_accounts_list($name, null, false, false, null, null, true);

						case 'BANK_ACCOUNTS_ONLY_PDC':
					return bank_accounts_list($name, null, false, false, null, null, true);
					
				case 'DIMENSION':
					return dimensions_list($name, null, false, ' ', false, true, 0);
					
				case 'DIMENSIONS':
					return dimensions_list($name, null, true, _("No Dimension Filter"), false, true, 0);
                case 'DIMENSIONS_DCR':
					$user = get_user($_SESSION["wa_current_user"]->user);
					if($user['role_id'] == 2){
						return dimensions_list($name, null, true, _("No Dimension Filter"), false, true, 0);
					}else{
						return label_cell(get_dimension($user['dimension_id'])['name'])
							   .'<input type="hidden" value="'.$user['dimension_id'].'" name='.$name.'">';
					}                        
				case 'DIMENSION1':
					return dimensions_list($name, null, false, ' ', false, true, 1);

				case 'DIMENSIONS1':
					return dimensions_list($name, null, true, _("No Dimension Filter"), false, true, 1);

				case 'DIMENSION2':
					return dimensions_list($name, null, false, ' ', false, true, 2);

				case 'DIMENSIONS2':
					return dimensions_list($name, null, true, _("No Dimension Filter"), false, true, 2);
/////////////////////////////////////////////////
				case 'MONTHLIST':
					return  month_cell($name, null, $fiscal_year, false);

				case 'PROJECTLIST':
				
					return  project_cell($name, null, true, false,false, false);

				case 'YEAR':
					return years_list($name, null, false);
				case 'SALARYSTATUS':
					return employee_status($name,null, false, false, false);

				case 'SELECT_PAYMENT':
					return payment_cheq_list($name, $null, true, false,true, false);

				case 'SYS_TYPES_PR':
					return pr_systypes_list($name, null, false);
////////////////////////////////////////////////////////

				case 'CUSTOMERS_NO_FILTER':
				case 'CUSTOMERS':
					$sql = "SELECT debtor_no, name FROM ".TB_PREF."debtors_master";
					if ($type == 'CUSTOMERS_NO_FILTER')
						return customer_list($name, null, _("No Customer Filter"), true);
					else
						return customer_list($name);
                               case 'BRANCH_NO_FILTER':
					if ($type == 'BRANCH_NO_FILTER')
						return customer_branches_list($_POST['PARAM_2'],$name, null, _("No Branch Filter"), true);
					else
						return customer_branches_list($_POST['PARAM_2'],$name);
				case 'SUPPLIERS_NO_FILTER':
				case 'SUPPLIERS':
					$sql = "SELECT supplier_id, supp_name FROM ".TB_PREF."suppliers";
					if ($type == 'SUPPLIERS_NO_FILTER')
						return supplier_list($name, null, _("No Supplier Filter"));
					else
						return supplier_list($name);

				case 'INVOICE':
					$IV = $type_shortcuts[ST_SALESINVOICE];
					$ref = ($SysPrefs->print_invoice_no() == 1 ? "trans_no" : "reference");
					$sql = "SELECT concat(debtor_trans.trans_no, '-', debtor_trans.type) AS TNO,
								concat('$IV ', debtor_trans.$ref,' ', debtor.name) as IName
						FROM ".TB_PREF."debtors_master debtor,"
							.TB_PREF."debtor_trans debtor_trans
						WHERE type=".ST_SALESINVOICE." AND debtor.debtor_no=debtor_trans.debtor_no
						ORDER BY debtor_trans.trans_no DESC";
					return combo_input($name, '', $sql, 'TNO', 'IName',array('order'=>false));

				case 'CREDIT':
					$CN = $type_shortcuts[ST_CUSTCREDIT];
					$ref = ($SysPrefs->print_invoice_no() == 1 ? "trans_no" : "reference");
					$sql = "SELECT concat(debtor_trans.trans_no, '-', debtor_trans.type) AS TNO,
								concat('$CN ', debtor_trans.$ref,' ', debtor.name) as IName
						FROM ".TB_PREF."debtors_master debtor,"
							.TB_PREF."debtor_trans debtor_trans
						WHERE type=".ST_CUSTCREDIT." AND debtor.debtor_no=debtor_trans.debtor_no
						ORDER BY debtor_trans.trans_no DESC";
					return combo_input($name, '', $sql, 'TNO', 'IName',array('order'=>false));

				case 'DELIVERY':
					$DN = $type_shortcuts[ST_CUSTDELIVERY];
					$sql = "SELECT	concat(debtor_trans.trans_no, '-', debtor_trans.type) AS TNO,
								concat(debtor_trans.trans_no, ' $DN ', debtor.name) as IName
						FROM ".TB_PREF."debtors_master debtor,"
							.TB_PREF."debtor_trans debtor_trans
						WHERE type=".ST_CUSTDELIVERY." AND debtor.debtor_no=debtor_trans.debtor_no
						ORDER BY debtor_trans.trans_no DESC";
					return combo_input($name, '', $sql, 'TNO', 'IName',array('order'=>false));

					case 'STATUS':
					return approve_list_report($name,null, false, false, false);
					case 'LEAVETYPE':
					return leave_list($name, null, true, false,false, false);
				case 'ORDERS':
					$ref = ($SysPrefs->print_invoice_no() == 1 ? "order_no" : "reference");
					$sql = "SELECT sorder.order_no, concat(sorder.$ref, '-', debtor.name) as IName
						FROM ".TB_PREF."debtors_master debtor,"
							.TB_PREF."sales_orders sorder
						WHERE debtor.debtor_no=sorder.debtor_no	AND sorder.trans_type=".ST_SALESORDER
						." ORDER BY sorder.order_no DESC";
					return combo_input($name, '', $sql, 'order_no', 'IName',array('order'=>false));

				case 'QUOTATIONS':
					$ref = ($SysPrefs->print_invoice_no() == 1 ? "order_no" : "reference");
					$sql = "SELECT sorder.order_no, concat(sorder.$ref, '-', debtor.name) as IName
						FROM ".TB_PREF."debtors_master debtor,"
							.TB_PREF."sales_orders sorder
						WHERE debtor.debtor_no=sorder.debtor_no	AND sorder.trans_type=".ST_SALESQUOTE
							." ORDER BY sorder.order_no DESC";
					return combo_input($name, '', $sql, 'order_no', 'IName',array('order'=>false));

				case 'PO':
					$ref = ($SysPrefs->print_invoice_no() == 1 ? "order_no" : "reference");
					$sql = "SELECT po.order_no, concat(po.$ref, '-', supplier.supp_name) as IName
						FROM ".TB_PREF."suppliers supplier,"
							.TB_PREF."purch_orders po
						WHERE supplier.supplier_id=po.supplier_id
						ORDER BY po.order_no DESC";
					return combo_input($name, '', $sql, 'order_no', 'IName',array('order'=>false));

				case 'REMITTANCE':
					$BP = $type_shortcuts[ST_BANKPAYMENT];
					$SP = $type_shortcuts[ST_SUPPAYMENT];
					$CN = $type_shortcuts[ST_SUPPCREDIT];
					$ref = ($SysPrefs->print_invoice_no() == 1 ? "trans_no" : "reference");
					$sql = "SELECT concat(trans.trans_no, '-',trans.type) AS TNO,
								concat(trans.$ref, IF(type=".ST_BANKPAYMENT.", ' $BP ', IF(type=".ST_SUPPAYMENT.", ' $SP ', ' $CN ')), supplier.supp_name) as IName
							FROM ".TB_PREF."suppliers supplier, "
								.TB_PREF."supp_trans trans
							WHERE type IN(".ST_BANKPAYMENT.",".ST_SUPPAYMENT.",".ST_SUPPCREDIT.")
								AND supplier.supplier_id=trans.supplier_id
							ORDER BY trans.trans_no DESC";
					return combo_input($name, '', $sql, 'TNO', 'IName',array('order'=>false));

				case 'RECEIPT':
					$BD = $type_shortcuts[ST_BANKDEPOSIT];
					$CP = $type_shortcuts[ST_CUSTPAYMENT];
					$ref = ($SysPrefs->print_invoice_no() == 1 ? "trans_no" : "reference");
					$sql = "SELECT concat(trans.trans_no, '-', trans.type) AS TNO,
								concat(trans.$ref, IF(type=".ST_BANKDEPOSIT.", ' $BD ', ' $CP '), debtor.name) as IName
						FROM ".TB_PREF."debtors_master debtor,"
							.TB_PREF."debtor_trans trans
						WHERE type IN(".ST_BANKDEPOSIT.",".ST_CUSTPAYMENT.",".ST_CUSTCREDIT.") AND debtor.debtor_no=trans.debtor_no
						ORDER BY trans.trans_no DESC";
					return combo_input($name, '', $sql, 'TNO', 'IName',array('order'=>false));

				case 'ITEMS':
					return stock_costable_items_list($name,null,true);

				case 'ITEMS_ALL':
					return stock_manufactured_items_list($name, null, true);

				case 'ITEMS_P':
					return stock_purchasable_items_list($name, null, true);
				
				case 'WORKORDER':
					$sql = "SELECT wo.id, concat(wo.id, '-', item.description) as IName
						FROM ".TB_PREF."stock_master item,"
							.TB_PREF."workorders wo
						WHERE item.stock_id=wo.stock_id
						ORDER BY wo.id DESC";
					return combo_input($name, '', $sql, 'id', 'IName',array('order'=>false));

				case 'LOCATIONS':
					return  locations_list($name, null, _("No Location Filter"));
				case 'FLOCATIONS':
					return  locations_list($name, null, _("No Location Filter"), false, true);

				case 'CATEGORIES':
					return stock_categories_list($name, null, _("No Category Filter"));
				case 'FCATEGORIES':
					return stock_categories_list($name, null, _("No Category Filter"), false, true);
				case 'FCLASS':
					return fixed_asset_classes_list($name, null, _("No Class Filter"), false);
				case 'SALESTYPES':
					return sales_types_list($name);

				case 'AREAS':
					return sales_areas_list($name);

				case 'SALESMEN':
					return sales_persons_list($name, null, _("No Sales Folk Filter"));
					
				case 'TRANS_YEARS':
					return fiscalyears_list($name);

				case 'USERS':
					$sql = "SELECT id, user_id FROM ".TB_PREF."users";
					return combo_input($name, '', $sql, 'id', 'user_id',array('spec_option'=>_("No Users Filter"),'spec_id'=>ALL_NUMERIC));

				case 'ACCOUNTTAGS':
				case 'DIMENSIONTAGS':
					if ($type == 'ACCOUNTTAGS')
						$tag_type = TAG_ACCOUNT;
					else
						$tag_type = TAG_DIMENSION;
					return tag_list($name, 5, $tag_type, true);

case 'DEPT':
return  emp_dept($name, null, true, false,false, false);
case 'EMPLYMASTERLIST':
return emp_master_list($name, 5, '', true);
case 'EMPLYLIST':
// return emp_row_list(null,$name, null,false,0,1,1); 
return employee_list($name, null, true, false,false, false);
case 'NATIONAL':
return countries_list($name, null, false);
case 'EXPIRYREPORTSLIST':
return expiry_report_list($name, null, true, false,false, false);
case 'DEPT':
return emp_dept($name, null, true, false,false, false);
$dept = $ret[0];




			}
		return '';
	}
}

class Report
{
	var $id;
	var $name;
	var $ar_params;
	var $controls;
	
	function Report($id, $name, $ar_params = null)
	{
		$this->id = $id;
		$this->name = $name;
		if ($ar_params) $this->set_controls($ar_params);
	}
	
	function set_controls($ar_params) {
		$this->controls = $ar_params;
	}
	
	function get_controls() {
		return $this->controls;
	}
	
}

//------------------------------------------------------------------------------------------------
function gl_systypes_list($name, $value=null, $spec_opt=false)
{
	global $systypes_array;
	
	$types = $systypes_array;
	
	foreach(array(ST_LOCTRANSFER, ST_PURCHORDER, ST_SUPPRECEIVE, ST_MANUISSUE,
				ST_MANURECEIVE, ST_SALESORDER, ST_SALESQUOTE, ST_DIMENSION) as $type)
		unset($types[$type]);

	return array_selector($name, $value, $types, 
		array( 
			'spec_option'=> $spec_opt,
			'spec_id' => ALL_NUMERIC,
			'async' => false,
			)
	);
}
/*
	Add extension/custom reports to report manager.
*/
function add_custom_reports(&$reports)
{
	global $installed_extensions, $path_to_root;
	
	// include reports installed inside extension modules
	if (count($installed_extensions) > 0)
	{
		$extensions = $installed_extensions;
		foreach ($extensions as $ext)
			if (($ext['active'] && $ext['type'] == 'extension')) {
				$file = $path_to_root.'/'.$ext['path']."/reporting/reports_custom.php";
				if (file_exists($file)) {
					set_ext_domain($ext['path']);
					include_once($file);
					set_ext_domain();
				}
			}
	}
	$file = company_path()."/reporting/reports_custom.php";
	if (file_exists($file))
		include_once($file);
}