<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

$page_security = 'SA_LEAVR_INQUIRY';
$path_to_root  = '../../..';

include_once($path_to_root . '/includes/db_pager.inc');
include_once($path_to_root . '/includes/session.inc');
add_access_extensions();

include_once($path_to_root . '/includes/ui.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');
include_once($path_to_root . '/reporting/includes/reporting.inc');

$js = '';
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

//--------------------------------------------------------------------------

page(_($help_context = 'Leave Inquiry '), isset($_GET['EmpId']), false, '', $js);

if (isset($_GET['EmpId']))
	$_POST['EmpId'] = $_GET['EmpId'];

$days_no = date_diff2(begin_fiscalyear(), Today(), 'd');

start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();
leave_type_list_cells(_("Leave Type"), 'leave_type', null, true);
ApprovedUnApproved_list_cells(_("Status"), 'status', null, true);
// yesno_list_cells(_("Leave Type"), 'leave_type', null, _("PL"), _("UPL"), true);
// yesno_list_cells(_("Status"), 'status', null, _("Approved"), _("Un-Approved"), true);
// display_error($_POST['status']." ".$_POST['leave_type']);
// ref_cells(_('Reference').':', 'Ref', _('Enter reference fragment or leave empty'), null, null, true);
// ref_cells(_('Memo').':', 'Memo', _('Enter memo fragment or leave empty'), null, null, true);
date_cells(_('From').':', 'FromDate', '', null, $days_no, 0, 0, null, true);
date_cells(_('To').':', 'ToDate', '', null, 0, 0, 0, null, true);

// end_row();
// end_table();

// start_table(TABLESTYLE_NOBORDER);
// start_row();

// department_list_cells(null, 'DeptId', null, _('All departments'), true);
employee_list_cells(null, "EmpId", null, _('All employees'), true, false, get_post('DeptId'));
// check_cells(_('Only unpaid:'), 'OnlyUnpaid', null, true);
submit_cells('Search', _('Search'), '', '', 'default');

end_row();
end_table(1);
    
//--------------------------------------------------------------------------

function check_overdue($row) {

}
function trans_type($row) {

	if($row['Type'] == 0)
		return _('Payslip');
	elseif ($row['payslip_no'] == 0)
		return _('Employee advance');
	else
		return _('Payment advice');
}
function view_link($row) { 
	global $path_to_root;
	if($row['trans_no'] != 0)
	    return get_trans_view_str($row['Type'], $row['trans_no'],"", false,'', '', $path_to_root);
}
function prt_link($row) {


	$month_no = date('n',strtotime($row['from_leave']));
	$from_date = $row['from_leave'];
	if (check_payslip($row['emp_id'],$month_no,get_selected_years_to_id(date("Y", strtotime($from_date))) ))
	  return '';

	$month_no = date('n',strtotime($row['to_leave']));
	$to_date = $row['to_leave'];
	if (check_payslip($row['emp_id'],$month_no,get_selected_years_to_id(date("Y", strtotime($to_date))) ))
		  return '';
	
return '<a href="../../FrontHrm/manage/leave_update.php?id='.$row['id'].'" ><img src=../../../themes/synergy/images/edit2.gif style=vertical-align:middle;width:16px;height:16px;border:0;></a>';

	// if($row['Type'] == 1 && $row['payslip_no'] != 0)
	//     return hrm_print_link($row['payslip_no'], _('Print this Payslip'), true, ST_PAYSLIP, ICON_PRINT, '', '', 0);
}
function get_emp_name($row){
	return get_employees($row['emp_id'])['emp_first_name'];
}
function payslip_no($row) {
	return $row['payslip_no'] == 0 ? null : $row['payslip_no'];
}

function leave_type($row) {
	return $row['leave_type'] == 1 ? '<spam style="color:green;">PL<spam>'  : '<spam style="color:red;">UPL<spam>';
}
function get_status($row) {
	return $row['approved'] == 1 ? '<spam style="color:green;">Approved<spam>' : '<spam style="color:red;">Un-Approved<spam>';
}
$sql = get_leave_sql(get_post('EmpId'), get_post('FromDate'), get_post('ToDate'),get_post('leave_type'), get_post('status'));



$cols = array (
	// _('Trans #') => array('fun'=>'view_link'),
	// _('Type') => array('fun'=>'trans_type'),
	_('Employee Name ') => array('fun'=>'get_emp_name'),
	_('From Date') => array('type'=>'date'),
	_('To Date') => array('type'=>'date'),

	_('Description'),
	 _('Leave Type') => array('fun'=>'leave_type'),
	  _('Status') => array('fun'=>'get_status'),

	// _('Payslip No') => array('fun'=>'payslip_no'),
	// _('Pay from') => array('type'=>'date'),
	// _('Pay to') => array('type'=>'date'),
	// _('Amount') => array('type'=>'amount'),
	'' => array('align'=>'center', 'fun'=>'prt_link')
);

$table =& new_db_pager('trans_tbl', $sql, $cols, null, null, 15);
$table->set_marker('check_overdue', _('Marked items are overdue.'));

$table->width = '80%';

display_db_pager($table);

end_form();
end_page();