<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

$page_security = 'SA_PAYROLL_DADHBOARD';
$path_to_root  = '../../..';

include_once($path_to_root . '/includes/db_pager.inc');
include_once($path_to_root . '/includes/session.inc');
add_access_extensions();

include_once($path_to_root . '/includes/ui.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');
include_once($path_to_root . '/reporting/includes/reporting.inc');
include_once($path_to_root . "/admin/db/tags_db.inc");

$js = '';
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

$user_id=($_SESSION['wa_current_user']->user);
$myrow_user=get_user($user_id);

//--------------------------------------------------------------------------

page(_($help_context = 'Payroll Dashboard '), false, false, '', $js);

if (isset($_GET['EmpId']))
	$_POST['EmpId'] = $_GET['EmpId'];

$days_no = date_diff2(begin_fiscalyear(), Today(), 'd');



start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();


if(list_updated('month') || list_updated('EmpId') ||  list_updated('status')  || isset($_POST['payment_no']))
{
	global $Ajax;
	$Ajax->activate('_page_body');
}


if(!check_generate_payslip(0,$_POST['month'],$_POST['year']))
{
		salary_month(_("Month"),'month', null, true);
		years_list_cells(_('Year'), 'year', null,true);
		submit_cells('generate_payroll', _('Generate Payroll'),'', '', 'default');	
}	
else
{

		ref_cells(_("Payment No #"), 'payment_no', '',null, '', true);
		// if()
		salary_month(_("Month"),'month', null, true);
		years_list_cells(_('Year'), 'year', null,true);

		echo "<td>";
		echo "<center>". Print_site_report_link($_POST['EmpId']."-".$_POST['DeptId']."-".$_POST['month']."-".$_POST['year']."-".$_POST['payment_no']."-".$_POST['status'], _("<span > <img class='' src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT."> "._("Print Report")." </span>"), true, ST_PAYROLL_DASHBOARD, false,'btn btn-sm btn-info','',2)."</center>";

		echo "</td>";
		echo "<td>";
		echo "<center>". Print_site_report_link($_POST['EmpId']."-".$_POST['DeptId']."-".$_POST['month']."-".$_POST['year']."-".$_POST['payment_no']."-".$_POST['status'], _("<span > <img class='' src =".$path_to_root."/themes/".user_theme()."/images/".ICON_EXCEL." style='width: 21px;
		    height: 20px;'> "._("Excel Report")." </span>"), true, ST_PAYROLL_DASHBOARD, false,'btn btn-sm btn-info','',2,0,'A4',1)."</center>";		
		echo "</td>";

		end_row();
		start_row();
		
		department_list_cells(_('Department').':', 'DeptId', null, _('All departments'), true );
		employee_list_cells(_("Employe"), "EmpId", null, _('All employees'), true, false, get_post('DeptId'));
		payrol_process_list_cells(_("Status"), 'status', $_POST['status'], true);
		echo "<td>";
		echo '<button class="ajaxsubmit btn btn-success" type="submit" style="margin-top:0; float:; background:; border:none;" aspect="default" name="RefreshInquiry" id="RefreshInquiry" value="'._("Search").'" title="Refresh Inquiry"><span>'._("Search").'</span></button> &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp';
		// echo "</td>";

		if($_POST['month'])
		echo  "<a style=' font-size:13px;' class='btn btn-success' target='_blank' href='generate_payroll.php?emp_id=".$_POST['EmpId']."&dept_id=".$_POST['DeptId']."&trans_type=ST_PAYSLIP&month=".$_POST['month']."&year=".$_POST["year"]."&page=1&status=".$_POST['status']."'>"._("Process Payroll")."</a>";
        submit_cells('generate_payroll', _('Generate Again Payroll'),'', '', 'default');
		// submit_cells('Search', _('Search'), '', '', 'default');
		echo "</td>";


		end_row();
}




end_table();


//     start_table(TABLESTYLE, "style='width:100% !important;''  ");
    
//--------------------------------------------------------------------------

function check_overdue($row) {

}



function write_process_payslip($emp_id,$row,$month,$year){

		$basic_salary=$row['emp_salary'];
		$allow_res = getsum_allowances($emp_id);
		$allowance=db_fetch($allow_res)['amounts'];
		$deb_res = getsum_deductions($row['emp_id']);
		$deduction= db_fetch($deb_res)['amounts'];
		    //- $deduction
		$gross_salary=  ( $basic_salary + $allowance ) ;

		$weekends=get_weekends_in_month($_POST['month'],get_selected_years($_POST['year']),$row['emp_id']);
		$holiday=get_holiday_in_month($_POST['month'],get_selected_years($_POST['year']),$row['emp_id']);
		$normal_days=get_month_days($emp_id,$_POST['month'],get_selected_years($_POST['year'])) + $weekends + $holiday;
// display_error(	$normal_days." == ".$emp_id." == ".$weekends ."  +  ". $holiday);
         // display_error(get_month_days($emp_id,$_POST['month'],get_selected_years($_POST['year']))." == ".$weekends." ==".$holiday);
                // get normal days updated salary . send parameter 1;
		$nd_salary = str_replace(',','',get_normal_days_salary($row,1));

		    // get unpdaid leave updated, send 1 parameter
		$upl= get_unpaid_leave($row,1);
	  //	display_error($upl." = ".$emp_id);
		   // get paid leave updated, send 1 parameter
		$pl=  get_paid_leave($row,1);
	      // get paid leave salary, send 1 parameter
		$pl_amount=str_replace(',','',get_paid_leave_salary($row,1));
		// display_error($pl_amount);
		// exit();

		$overtime_hrs=get_OverTime_hrs($row['emp_id'],$_POST['month'],get_selected_years($_POST['year']) );

		$Work_days = get_company_pref('payroll_month_work_days');
		$Work_hours = get_company_pref('payroll_work_hours');
		$ot_salary=( get_employees($row['emp_id'])['emp_salary'] / $Work_days / $Work_hours ) * get_OverTime_hrs($row['emp_id'],$_POST['month'],get_selected_years($_POST['year']),1 );
		$ot_salary=round($ot_salary,2);

		// ( str_replace(',','',get_normal_days_salary($row) ) + $ot_salary + $allowance ) - $deduction  
		$total_salary= round (( $nd_salary + $ot_salary  + $pl_amount - $deduction ) , 2 );

              if(check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']))

              {
							$sql="UPDATE ".TB_PREF."emp_payslip_trans
							SET 
							basic_salary = ".db_escape($basic_salary).",
							allowance = ".db_escape($allowance).",
							deduction = ".db_escape($deduction).",
							gross_salary = ".db_escape($gross_salary).",
							overtime_hrs = ".db_escape($overtime_hrs).",
							ot_salary = ".db_escape($ot_salary).",
							normal_days = ".db_escape($normal_days).",
							nd_salary = ".db_escape($nd_salary).",
							upl = ".db_escape($upl).",
							pl = ".db_escape($pl).",
							pl_amount = ".db_escape($pl_amount).",
							total_salary = ".db_escape($total_salary)."
							
							WHERE emp_id=".db_escape($emp_id)." 
							AND month_id=".db_escape($_POST['month'])." 
							AND year_id=".db_escape($_POST['year'])." 
							";  //AND  total_salary!=0
              	           // display_error($sql);   
              	            db_query($sql,"The  could not again generate payslip");


					// $sql2 = "SELECT MAX(id) AS id FROM ".TB_PREF."emp_payslip_trans";
					// $result2 = db_query($sql2);
					$max_row = check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']);
					$trans_id=$max_row['id'];
					add_audit_trail(ST_PAYSLIP, $trans_id, Today(),'Again Generate payslip');

              }
              else
              {

					$sql = "INSERT INTO ".TB_PREF."emp_payslip_trans (emp_id, basic_salary, allowance, deduction, gross_salary,overtime_hrs,ot_salary,normal_days, nd_salary, upl,pl,pl_amount, total_salary,month_id,year_id,generate_payroll) VALUES (
					".db_escape($emp_id) . ",
					".db_escape($basic_salary) . ",
					".db_escape($allowance) . ",
					".db_escape($deduction) . ",
					".db_escape($gross_salary) . ",
					".db_escape($overtime_hrs) . ",
					".db_escape($ot_salary) . ",
					".db_escape($normal_days) . ",
					".db_escape($nd_salary) . ",
					".db_escape($upl) . ",
					".db_escape($pl) . ",
					".db_escape($pl_amount) . ",
					".db_escape($total_salary) . ",
					".db_escape($_POST['month']) . ",
					".db_escape($_POST['year']) . ",
					".db_escape(1) . ")";

		   // display_error($sql);
		   // exit();

					db_query($sql,"The could not process payslip");

					$sql2 = "SELECT MAX(id) AS id FROM ".TB_PREF."emp_payslip_trans";
					$result2 = db_query($sql2);
					$max_row = db_fetch($result2);

					$trans_id=$max_row['id'];
					add_audit_trail(ST_PAYSLIP, $trans_id, Today(),'Generate new payslip');

              }




}

function trans_type($row) {

	if($row['Type'] == 0)
		return _('Payslip');
	elseif ($row['payslip_no'] == 0)
		return _('Employee advance');
	else
		return _('Payment advice');
}
function view_link($row) { 
	global $path_to_root;

		   return viewer_link($row['emp_id'],  "modules/FrontHrm/view/view_payslip.php?trans_no=".$row['emp_id']."&year=".$_POST['year']."&month=".$_POST['month']);

	  
}
function emp_approved_payslip($row) { 
	global $path_to_root;
	// if($row['trans_no'] != 0)
$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 

   if(!$row2['emp_approved'] && isset($row2['id']))
	  return pager_link( _("employee approved payslip"),
	"/modules/FrontHrm/manage/emp_payslip_approved.php?id=".$row2['id']."&month=".$_POST['month']."&year=".$_POST['year'], ICON_DOC);
	elseif ($row2['emp_approved'])              
	     return  "<span style='color:green;'><strong>  Approved </strong> </span>" ;

}
function prt_link($row) {
	

$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
	
	    return hrm_print_link($row['emp_id']."-".$_POST['month']."-".$_POST['year'], _('Print this Payslip'), true, ST_PAYSLIP, ICON_PRINT, '', '', 0);
}
function get_emp_name($row){
	return get_employees($row['emp_id'])['name'];
}
function get_payment_id($row){

global $path_to_root;
	//
	$row2=check_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
	$result=get_all_payroll_alloc_to(ST_PAYSLIP,$row2['id']) ;
	$view='';
	
	while ($alloc_row=db_fetch($result)) {
		if($view=='')
		$view.=viewer_link($alloc_row["trans_no_from"],"gl/view/gl_payment_view.php?trans_no=".$alloc_row["trans_no_from"]);
		else
		$view.=' , '.viewer_link($alloc_row["trans_no_from"], "gl/view/gl_payment_view.php?trans_no=".$alloc_row["trans_no_from"]);

	# code...
	} 

		if($_SESSION['wa_current_user']->access !=2)
			return strip_tags($view);
			else
	return $view;

}
function get_status($row) {

		 if(check_payslip($row['emp_id'],$_POST['month'],$_POST['year']))
		 {
				$row2=check_payslip($row['emp_id'],$_POST['month'],$_POST['year']);  


				if($row2['alloc_amount']>0)
				{
					$res=get_all_payroll_alloc_to(ST_PAYSLIP,$row2['id']) ; 
					$alloc_row=db_fetch($res);
					// echo "<pre>";
					// print_r($alloc_row);
					// get_trans_view_str($alloc_row["trans_type_from"], $alloc_row["trans_no_from"])
					// display_error($row2['total_salary']." != ".round($row2['alloc_amount'],2));
					if(round($row2['total_salary'],2)!=round($row2['alloc_amount'],2))  
					   return "<span style='color:green;'> <strong> ".viewer_link(_('Partial Paid'), "modules/FrontHrm/view/view_payroll_allocation_detail.php?id=".$row2['id'])." </strong></span>";
			       	elseif ($row2['total_salary']==0 && $row2['alloc_amount']==0) 
			        	return "<span style='color:green;'> <strong> "._("Processed")." </strong></span>";
					else 
					    return "<span style='color:green;'> <strong> ".viewer_link(_('Paid'), "modules/FrontHrm/view/view_payroll_allocation_detail.php?id=".$row2['id'])." </strong></span>";
				}
			
			    else
                  return  "<span style='color:green;'>   "._("Processed")." </span>" ;
             
          
		 }
         else
         return  "<span style='color:red;'>  "._("Un Process")."</span>" ;
}

function get_emp_salary($row) {

	$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
	if($row2)
    return number_format($row2['basic_salary']) ;

	
	return   get_employees($row['emp_id'])['emp_salary'];
		
}

function get_allowances_data($row,$is_updated)  
{
		$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
		if(!$is_updated)
		if($row2)
		{
		  return number_format($row2['allowance'],2);
		}

		$result = getsum_allowances($row['emp_id']);
		$row1 = db_fetch($result);
		return number_format($row1["amounts"],2);

	
}
function get_deduction_data($row,$is_updated)  
{
		$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
		if(!$is_updated)
		if($row2)
		{
		  return number_format($row2['deduction'],2);
		}
		
		$result = getsum_deductions($row['emp_id']);
		$row = db_fetch($result);
		return number_format($row["amounts"],2);
		
}
function get_gross_salary($row,$is_updated){
        if(!$is_updated)
          {
          	$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
			if($row2)
			return number_format($row2['gross_salary'],2);
          }	
       //- str_replace(',','', get_deduction_data($row,$is_updated))
		$gross_salary=(get_employees($row['emp_id'])['emp_salary'] + str_replace(',','', get_allowances_data($row,$is_updated))  ) ;
		return number_format($gross_salary,2) ;
}

function get_normal_days($row,$is_updated=0){
		if(!$is_updated)
		{
			$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
			if($row2)
			return number_format($row2['normal_days'],2);
		}

		$weekends=get_weekends_in_month($_POST['month'],get_selected_years($_POST['year']),$row['emp_id']);
		$holiday=get_holiday_in_month($_POST['month'],get_selected_years($_POST['year']),$row['emp_id']);



		
		return get_month_days($row['emp_id'],$_POST['month'],get_selected_years($_POST['year']) ) +$weekends+$holiday;
}
function get_total_salary($row)
{

		$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
		if($row2)
		return number_format($row2['total_salary'],2);

		return price_format(  str_replace(',','',get_normal_days_salary($row) ) + str_replace(',','',get_ot_salary($row) )  + str_replace(',','',get_paid_leave_salary($row))   -str_replace(',','', get_deduction_data($row,$is_updated)) );
}

function get_overtime_hr($row)
{
		$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
		if($row2)
		return number_format($row2['overtime_hrs'],2);

		return number_format(get_OverTime_hrs($row['emp_id'],$_POST['month'],get_selected_years($_POST['year']) ),2 );
}

function get_allocated($row)
{
		$res= get_alloc_payslip($row['emp_id'],$_POST['month'],$_POST['year']);
		$payslip_row=db_fetch($res);
		// print_r($payslip_row);
		return price_format($payslip_row['alloc_amount']);
		

  
}
function get_left_to_allocate($row)
{
		$res= get_alloc_payslip($row['emp_id'],$_POST['month'],$_POST['year']);
		$payslip_row=db_fetch($res);
		
		return price_format($payslip_row['total_salary']-$payslip_row['alloc_amount']);
		

  
}
function  get_ot_salary($row){
	$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
		if($row2)
		return number_format($row2['ot_salary'],2);


		$Work_days = get_company_pref('payroll_month_work_days');
		$Work_hours = get_company_pref('payroll_work_hours');

		
		$value=( get_employees($row['emp_id'])['emp_salary'] / $Work_days / $Work_hours ) * get_OverTime_hrs($row['emp_id'],$_POST['month'],get_selected_years($_POST['year']) ,1);

		return number_format($value,2);
}

function get_normal_days_salary($row,$is_updated=0){
        
        if(!$is_updated)
        {
			$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
			if($row2)
			return number_format($row2['nd_salary'],2);

        }	


		$Work_days = get_company_pref('payroll_month_work_days'); 
		$paid_un_paid_leave=get_unpaid_leave($row,$is_updated) + get_paid_leave($row,$is_updated) ;

		# standard calculation formula 30 days count every mount 

		$month_days = days_in_month($_POST['month'],get_selected_years($_POST['year']));

		if($paid_un_paid_leave==$month_days) 
		  $normal_days=0;
	    else if($month_days==31)  //$paid_un_paid_leave+get_normal_days($row,$is_updated)<$month_days &&
          {
          	if(get_normal_days($row,$is_updated)<$month_days)
          	   $normal_days=get_normal_days($row,$is_updated);
	         else
	           $normal_days=30;	
	      }
	    else
          $normal_days=(30-$month_days)+get_normal_days($row,$is_updated);
		return  number_format( ( str_replace(',','',get_gross_salary($row,$is_updated)) / $Work_days) * $normal_days,2 );
}


function get_unpaid_leave($row,$is_updated=0){

       if(!$is_updated)
       {

		$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
		if($row2)
		return number_format($row2['upl'],2);
       }

        if(!check_emp_leave_this_month($row["emp_id"],$_POST['month'],get_selected_years($_POST['year']),0))
        	return 0;

		$limit = days_in_month($_POST['month'],get_selected_years($_POST['year']));
		$leave_days=0;
		for($d=1; $d<=$limit; $d++)
		{
		$time=mktime(12, 0, 0, $_POST['month'], $d, get_selected_years($_POST['year']));          
		$is_leave =   check_leave($row["emp_id"],date('Y-m-d', $time));
		if($is_leave)
		if($is_leave['leave_type']==0  && $is_leave['approved']==1)
		$leave_days++;
		
		}

		// if($actual_days)
		//   return $leave_days;
		// else
		// {
			if($limit==$leave_days)
			return 30	;
			else
			return $leave_days;
		// }
}



function get_paid_leave($row,$is_updated=0,$paid_gross_amount_leave=0){
       
        if(!$is_updated)
        {
			$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
			if($row2)
			return number_format($row2['pl'],2);    	
        }	

         if(!check_emp_leave_this_month($row["emp_id"],$_POST['month'],get_selected_years($_POST['year']),1))
        	return 0;

		$limit = days_in_month($_POST['month'],get_selected_years($_POST['year']));
		$leave_days=0;
		for($d=1; $d<=$limit; $d++)
		{
			$time=mktime(12, 0, 0, $_POST['month'], $d, get_selected_years($_POST['year']));          
			$is_leave =   check_leave($row["emp_id"],date('Y-m-d', $time));
			// print_r($is_leave);
			if($is_leave)
			{
				if($is_leave['leave_type']==1 && $is_leave['approved']==1)
				   {
				   	// display_error($paid_gross_amount_leave." ==1 && ".$is_leave['paid_gross_amount']);
						if($paid_gross_amount_leave==1 && $is_leave['paid_gross_amount']==1)
						$leave_days++;
						if($paid_gross_amount_leave==2 && $is_leave['paid_gross_amount']==0 )   
						$leave_days++;
						if($paid_gross_amount_leave==0)
						$leave_days++;

				   }

			}	
		}

		
			if($limit==$leave_days)
			return 30	;
			else
			return $leave_days;
	


}

function get_paid_leave_salary($row,$is_updated=0){
	

	// display_error($row2['pl_amount']);
	if(!$is_updated)
	{

		$row2=check_generate_payslip($row['emp_id'],$_POST['month'],$_POST['year']); 
	    if($row2)
	    return number_format($row2['pl_amount'],2);
	}

	$Work_days = get_company_pref('payroll_month_work_days');

    $basic_amount=(get_employees($row['emp_id'])['emp_salary'] /  $Work_days ) * get_paid_leave($row,$is_updated,2);
    $gross_amount=( str_replace(',','',get_gross_salary($row,$is_updated)) /  $Work_days ) * get_paid_leave($row,$is_updated,1);

		// display_error( $basic_amount." +  ". $gross_amount."   == ".$is_updated);

		// display_error( get_paid_leave($row,$is_updated,1) ."   ----- " .get_paid_leave($row,$is_updated,2));
    return  number_format( $basic_amount+$gross_amount ,2);

	// return  number_format( (get_employees($row['emp_id'])['emp_salary'] /  $Work_days )*get_paid_leave($row,$is_updated) ,2);

}

if ($_POST['month'] != 0) {

	$select_date=date("Y-m-t",mktime(0,0,0,$_POST['month'],1,get_selected_years($_POST['year'])));

// $select_date=get_selected_years($_POST['year'])."-".$_POST['month']."-01";

	// display_error($_POST['month']."  == ".$_POST['year']);

$sql = "SELECT em.emp_id,'' as emt1,'' as empty,'' as empty2 ,em.emp_salary,'' as empty3,'' as empty4,
       '' as empty5,'' as empty6 ,'' as empty7,'' as empty8,'' as empty9,'' as empty10,'' as empty13, 
       '' as empty11, CONCAT(em.emp_first_name, ' ', em.emp_last_name) AS name,'' as empty12
       FROM ".TB_PREF."employee  em "; 


if($_POST['payment_no'])
$sql.=" ,0_emp_payslip_trans ept ,0_payroll_allocations pa WHERE em.emp_id=ept.emp_id AND pa.trans_no_to=ept.id AND pa.trans_no_from = ".db_escape($_POST['payment_no'])." AND MONTH(em.emp_hiredate)<=".db_escape($_POST['month'])."  AND em.emp_hiredate!='0000-00-00' ";
elseif ($_POST['status']==1) {
	# code...
	$sql.=" ,0_emp_payslip_trans ept WHERE em.emp_id=ept.emp_id AND ept.month_id=".db_escape($_POST['month'])." AND ept.year_id=".db_escape($_POST['year'])." AND ept.generate_payroll=1 AND ept.process_payroll=1";
}
elseif ($_POST['status']==2) {
	# code...
	$sql.=" ,0_emp_payslip_trans ept WHERE em.emp_id=ept.emp_id AND ept.month_id=".db_escape($_POST['month'])." AND ept.year_id=".db_escape($_POST['year'])." AND ept.generate_payroll=1 AND ept.process_payroll=0";
}
elseif ($_POST['status']==3) {
	# code...
	$sql.=" ,0_emp_payslip_trans ept WHERE em.emp_id=ept.emp_id AND ept.month_id=".db_escape($_POST['month'])." AND ept.year_id=".db_escape($_POST['year'])." AND ept.generate_payroll=1 AND ept.process_payroll=1 AND ept.total_salary>0  AND ept.total_salary=ept.alloc_amount";
}
elseif ($_POST['status']==4) {
	# code...
	$sql.=" ,0_emp_payslip_trans ept WHERE em.emp_id=ept.emp_id AND ept.month_id=".db_escape($_POST['month'])." AND ept.year_id=".db_escape($_POST['year'])." AND ept.generate_payroll=1 AND ept.process_payroll=1 AND ept.total_salary>ept.alloc_amount AND ept.alloc_amount>0";
}
else
$sql.= " WHERE em.inactive=0 AND em.emp_hiredate<=".db_escape($select_date)."  AND em.emp_hiredate!='0000-00-00' ";

     
    // $sql.= " WHERE em.inactive=0 AND em.emp_hiredate<=".db_escape($todate);


if($_POST['DeptId'])
	$sql.=" AND em.department_id=".db_escape($_POST['DeptId']);
if($_POST['EmpId'])
	$sql.=" AND em.emp_id=".db_escape($_POST['EmpId']);




// display_error($sql);
// exit();
    $gen_emp=0;
    if(isset($_POST['generate_payroll']) && $_POST['generate_payroll']!=null){
		$res = db_query($sql);
		while ($gen_row= db_fetch($res)) {
		# code...
		  if(!check_payslip($gen_row['emp_id'],$_POST['month'],$_POST['year']))
		  {
		    write_process_payslip($gen_row['emp_id'], $gen_row, $_POST['month'],$_POST['year']);
		    $gen_emp++;
		  }
		}
		// display_error($_POST['generate_payroll']);
		unset($_POST['generate_payroll']);

		global $Ajax;
		$Ajax->activate('_page_body');
      display_notification("Payroll has  been generate. Total  ".$gen_emp." employees");

  }

if(!check_generate_payslip(0,$_POST['month'],$_POST['year']))
  {
		display_error(_("first generate payroll. for ".db_num_rows(db_query($sql))." employees" ));
		end_form();
		end_page();
		exit();
  }


// display_error($sql);




		// display_error($sql);
		$cols = array (
		// _('Trans #') => array('fun'=>'view_link'),
		// _('Type') => array('fun'=>'trans_type'),
		_('Id') => array('fun'=>'view_link'),
		_('Payment ID')=> array('fun'=>'get_payment_id'),
		_('Status')=> array('fun'=>'get_status'),
		_('Employee Name ') => array('fun'=>'get_emp_name'),
		_('Basic Salary') => array('type'=>'amount'),
		_('Allowance')=> array('fun'=>'get_allowances_data'),
		_('Deduction')=> array('fun'=>'get_deduction_data'),
		_('Gross Salary')=> array('fun'=>'get_gross_salary'),
		_('OverTime Hrs')=> array('fun'=>'get_overtime_hr'),
		_('OT Salary')=> array('fun'=>'get_ot_salary'),
		_('Working Days')=> array('fun'=>'get_normal_days'),
		_('WD Salary')=> array('fun'=>'get_normal_days_salary'),
		_('UPL')=> array('fun'=>'get_unpaid_leave'),
		_('PL')=> array('fun'=>'get_paid_leave'),
		_('PL Salary')=> array('fun'=>'get_paid_leave_salary'),
		_('Total Salary')=>array('fun'=>'get_total_salary'),
		_('Allocated')=>array('fun'=>'get_allocated'),
		_('Left to Allocate')=>array('fun'=>'get_left_to_allocate'),
    	// _('Approved') => array('align'=>'center', 'fun'=>'emp_approved_payslip'),
		'' => array('align'=>'center', 'fun'=>'prt_link'),
	
		);

	

		$table =& new_db_pager('trans_tbl', $sql, $cols, null, null, 15);
		// $table->set_marker('check_overdue', _('Marked items are overdue.'));

		// $table->row_fun = "check_emp_attedance";

		$table->width = '80%';

		display_db_pager($table);
}
else
{
	display_error('Select month');
	// exit();
}


end_form();
end_page();