<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

$page_security = 'SA_HRMATTENDANCE_ALLOCATION';
$path_to_root  = '../../..';

include_once($path_to_root . '/includes/session.inc');
add_access_extensions();

include_once($path_to_root . '/includes/ui.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');

//--------------------------------------------------------------------------

page(_($help_context = 'Allocation'));
simple_page_mode(false);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') {

	if(strlen($_POST['name']) == 0 || $_POST['name'] == '') {
		display_error( _('The Department name cannot be empty.'));
		set_focus('name');
	}
	elseif(empty($_POST['basic_acc']) && !empty($USE_DEPT_ACC)) {
		display_error( _('Please select basic account'));
		set_focus('basic_acc');
	}
	else {
		write_department($selected_id, $_POST['name'], $_POST['basic_acc']);

    	if ($selected_id != '')
			display_notification(_('Selected department has been updated'));
    	else
			display_notification(_('New department has been added'));
		
		$Mode = 'RESET';
	}
}

if ($Mode == 'Delete') {

	if(department_has_employees($selected_id))
		display_error( _('The Department cannot be deleted.'));
	else {
		delete_department($selected_id);
		display_notification(_('Selected department has been deleted'));
	}
	$Mode = 'RESET';
}

if($Mode == 'RESET')
	$selected_id = $_POST['selected_id'] = $_POST['name'] = $_POST['basic_acc'] = '';

function complete_allocation($id)
{   $val=1;
	$sql=get_employees( false,  false, false,$_SESSION['wa_current_user']->user);
    $result = db_query($sql, _('Could not get employee data.'));
    $emp_row=db_fetch($result);
// print_r($emp_row['emp_id']);

	$sql=" UPDATE ".TB_PREF."site_report_master SET complete=".db_escape($val)."  WHERE sales_order_detail=".db_escape($id);
	// display_error($sql);
	db_query($sql);
	$row=get_order_line_item($id);
	$sql="INSERT INTO ".TB_PREF."allocation ( emp_id,order_no, order_detail_id, complete) 
	VALUES (".db_escape($emp_row['emp_id']).",".db_escape($row['order_no']).", ".db_escape($id).", ".db_escape($val).")";
	db_query($sql);
	// display_errosr($sql);
}
function approved_check_box($row)
{


	  	$name = "_complete" .$row['id'];
	    $value = $row_alloc['complete'] ? 1:0;
	    return  checkbox(null, $name, $value, true,
	 	_('Set this order as a template for direct deliveries/invoices'))
		. hidden('last['.$row['id'].']', $value, false)."<span style='color:green;'> <strong>Complete</strong></span>";

}

$id = find_submit('_complete');
if ($id != -1){
	// ApprovedBankPayment($id,1);
	complete_allocation($id);
	// display_error($id);
	$Ajax->activate('_page_body');
display_notification(_("Job has been complete"));		
}

if(isset($_POST['SearchOrders']) || isset($_POST['OrderNumber']))
{
	global $Ajax;
		$Ajax->activate('_page_body');


}
//--------------------------------------------------------------------------

start_form();
start_table(TABLESTYLE_NOBORDER);

ref_cells(_("Job No#:"), 'OrderNumber', '',null, '', true);

date_cells(_("from:"), 'OrdersAfterDate', '', null, -user_transaction_days()-120,0,0,null,true);
  	date_cells(_("to:"), 'OrdersToDate', '', null, 1);
submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
end_table(1);

br(2);

start_table(TABLESTYLE2);
// if(!empty($USE_DEPT_ACC))
//     $th = array(_('Id'), _('Department Name'), _('Salary Basic Account'), '', '');
// else
$th = array(_('Sno#'),_("Job No #"), _("Customer Name") ,_('Inspection Name'),_("date"), '');
// inactive_control_column($th);
table_header($th);
$sql= "SELECT sod.order_no as job_no ,srm.cartificate_no,sod.description as inspection_name,so.debtor_no,sod.engineer_id as eng_id,sod.* ,so.ord_date,srm.complete FROM ".TB_PREF."sales_orders so LEFT JOIN ".TB_PREF."sales_order_details sod on so.order_no=sod.order_no AND so.trans_type=sod.trans_type JOIN ".TB_PREF."site_report_master srm on srm.sales_order=sod.order_no AND srm.sales_order_detail=sod.id
        WHERE so.trans_type=30  AND sod.approved=0 AND srm.submit=1  AND sod.engineer_id=".db_escape($_SESSION['wa_current_user']->user);


$date_after = date2sql($_POST['OrdersAfterDate']);
			$date_before = date2sql($_POST['OrdersToDate']);

// $sql .=  " AND so.ord_date >= '$date_after'"
// 					." AND so.ord_date <= '$date_before'";

	$sql .=  " AND srm.submit_date >= '$date_after'"
					." AND srm.submit_date <= '$date_before'";
					
if($_POST['OrderNumber'])
	$sql.=" AND so.order_no=".db_escape($_POST['OrderNumber']);

// display_error($sql);
$result = db_query($sql);

$k = 0;
$sno=1;
while ($myrow = db_fetch($result)) {

   if($myrow['complete'])
    	continue;
	alt_table_row_color($k);
 
	label_cell($sno++);

	label_cell($myrow['job_no']);
	label_cell(get_customer_name($myrow['debtor_no']));
	// if(!empty($USE_DEPT_ACC))
		label_cell($myrow['inspection_name']);
		label_cell($myrow['ord_date']);

  label_cell(approved_check_box($myrow) );
	// inactive_control_cell($myrow['dept_id'], $myrow['inactive'], 'department', 'dept_id');
	// edit_button_cell('Edit'.$myrow['dept_id'], _('Edit'));
	// delete_button_cell('Delete'.$myrow['dept_id'], _('Delete'));
	end_row();
}
// inactive_control_row($th);
end_table(1);

start_table(TABLESTYLE2);

// if($selected_id != '') {
	
//  	if ($Mode == 'Edit') {
		
// 		$myrow = get_departments($selected_id);
// 		$_POST['name']  = $myrow['dept_name'];
// 		$_POST['basic_acc'] = $myrow['basic_account'];
//  	}
//  	hidden('selected_id', $selected_id);
// }

// text_row_ex(_('Department Name').':', 'name', 50, 60);

// if(!empty($USE_DEPT_ACC))
//     gl_all_accounts_list_row(_('Salary Basic Account'), 'basic_acc', null, true, false, _('Select basic account'));
// else
// 	hidden('basic_acc');

end_table(1);

// submit_add_or_update_center($selected_id == '', '', 'both');

end_form();
end_page();
