<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Abdus Sami                                  |
|   Date :   04-Aug-2020                                 |
|   Description:  Payroll & Hrm Module                   |
|   Form: Import Attendance                              |
|                                                        |
\=======================================================*/

$page_security = 'SA_HRMDOCTYPE';
$path_to_root  = '../../..';

include_once($path_to_root . '/includes/session.inc');
add_access_extensions();

include_once($path_to_root . '/includes/ui.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');

//--------------------------------------------------------------------------

page(_($help_context = ' Imports Attandance'));
simple_page_mode(false);
global $SysPrefs;
// print_r($_SESSION['wa_current_user']);
// display_error($SysPrefs->dateseps[user_date_sep()]);
// # imports Function 
function write_attendance_range($emp_id, $time_type, $value, $rate, $from, $to,$time_in='',$time_out='') {


    $day = $from;

    if($time_type==0)
    {

     $time_in=  ($time_in) ? date2sql($day)." ". date("H:i:s",strtotime($time_in)) : '';
     $time_out= ($time_out)? date2sql($day)." ". date("H:i:s",strtotime($time_out)) : '';

    
    }
    // exit();
    write_attendance_all($emp_id, $time_type, $value, $rate, $day,0,$time_in,$time_out);
  // }
}


if (isset($_POST['import'])) {
// print_r($_FILES['imp']);
  if (isset($_FILES['imp'])      && $_FILES['imp']['name'] != '') {
    $filename = $_FILES['imp']['tmp_name'];
    $sep = ",";




    $fp = @fopen($filename, "r");
    if (!$fp)
      die("can not open file $filename");


$error=0;
$lines=0;
 while ($data = fgetcsv($fp, 4096, $sep)) {
      if ($lines++ == 0) continue;

      $error=0;
      $allow_ot_hrs=0;
      $i++;
  


			list($emp_id , $attend_date, $time_in ,$time_out ,$ot_hrs)=$data;
         

          if(date_comp($attend_date, Today()) > 0) {
            display_error(_('Cannot mark attendance for the date in the future. on line no # :'.$lines));
            $error++;
            // continue;
          }

             if(!is_date($attend_date))

           {
                   $sep=$SysPrefs->dateseps[user_date_sep()];
               display_error(_('Invalid attendance date format on line no # :'.$lines ." date format is dd".$sep."mm".$sep."yyyy"));
               $error++;
               // continue;

           }

            $str_time_in=strtotime($time_in);
            $str_time_out=strtotime($time_out);
            $diff_hours= ($str_time_out - $str_time_in)/(60*60);
            // display_error($diff_hours." - ".$emp_id." - ".$attend_date);
       
            if($diff_hours<0)
            {
              display_error( _("invalid TimeIn and TimeOut for Employee : ".$emp_id." Line no #").$lines);         
              continue;
              $error++;
            } 







        $emp_row=get_employees($emp_id);
        // display_error( $emp_row['emp_hiredate']." = ".date2sql($attend_date)." ".$lines  ."   ====  ".date('d/m/Y', strtotime($attend_date)));

        // exit();

            if( $emp_row['emp_hiredate']>date2sql($attend_date) )
            {
                  // display_error( $emp_row['emp_hiredate']." > ".date2sql($attend_date) ." == ".$attend_date);

                  display_error(_('Cannot mark attendance before hire date. on line no # :'.$lines));
                  $error++;
            // exit();
            }
               // #change again format
             // $attend_date=date('d/m/Y', strtotime($attend_date));


           if(check_payslip($emp_id,date('m',strtotime(date2sql($attend_date))), get_selected_years_to_id(date('Y',strtotime(date2sql($attend_date))))) )
           
           {
            display_error(_('The selected  date  has been process payslip. can not add attendance for Employee ').$emp_id." on line no # :".$lines);
               $error++;
                          // continue;

           }

// display_error(date2sql($attend_date));
           if(check_leave($emp_id,date2sql($attend_date)))
           {
             display_error(_('The selected  date  has been leave mark. can not add attendance for Employee ').$emp_id." on line no # :".$lines);
                      continue;
                     $error++;
          }

           if (check_holiday(date2sql($attend_date)))
           {
              $msg=_('The selected  date holiday mark . can not add attendance for Employee ').$emp_id." on line no # :".$lines;
              if($ot_hrs)
              {

                write_attendance_range($emp_id, 1, time_to_float($ot_hrs), $rate, $attend_date, $attend_date);
                  $msg.=' <br> &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp           OT has been added ';
              }
               display_error($msg);
              continue;
              $error++;

           }
 // display_error(date('l', strtotime(date2sql($attend_date)))." ".$lines);
           if(check_weekend(date('l', strtotime(date2sql($attend_date)))))
           {
             $msg=_('The selected  date  weekend . can not add attendance for Employee ').$emp_id." on line no # :".$lines;
              if($ot_hrs)
               {
                 $msg.=' <br>  &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp    OT has been added ';
                  write_attendance_range($emp_id, 1, time_to_float($ot_hrs), $rate, $attend_date, $attend_date);
               }
              display_error($msg);

              continue;
              $error++;
           }
           
                



          if($error==0)
          {

              write_attendance_range($emp_id, 0, time_to_float($Work_hours), 1, $attend_date, $attend_date,$time_in,$time_out);


              $rate = get_ot_weekend(date('l', strtotime(date2sql($attend_date))))['ot_factor'];

              // display_error($_POST[$emp_id.'-0']."  == ".$emp_id);
              if($ot_hrs)
              write_attendance_range($emp_id, 1, time_to_float($ot_hrs), $rate, $attend_date, $attend_date);
          }





  }
                     @fclose($fp);
          
         }    
                       if($error==0)
                    display_notification(_(" Total Attandance : ".$lines ." Days"));     
   

               }
  


if ($Mode == 'RESET') {
	$selected_id = '';
	$_POST['selected_id'] = '';
	$_POST['name'] = '';
	$_POST['days'] = '';
}

//--------------------------------------------------------------------------

// $result = db_query(get_doc_types(false, check_value('show_inactive')));

start_form(true);
start_outer_table(TABLESTYLE2);

	table_section(1);
	table_section_title(_('Import Attandance'));
  $filepath=$path_to_root."/modules/FrontHrm/file/import_attandance.csv";
  label_row(_('Download CSV'),_("<a href='$filepath'download style='font-size: 17;'><span><img style='width: 35px;' src='../../../themes/synergy-purple/images/excel.png'> &nbsp;&nbsp;  </span>  </a>"));
	file_row(_('Import CSV File').':', 'imp', 'imp');


// inactive_control_row($th);
	end_outer_table(1);

start_table(TABLESTYLE2);



end_table(1);

   submit_center_first('import', _("Import CSV File"),'','default');

 echo "</center>";



end_form();
end_page();