<?php
/*=======================================================\
|                      Wayz Consulting	                 |
|--------------------------------------------------------|
|   Creator: Prem                                        |
|   Date :   24-May-2019                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/

$page_security = 'SA_HRMLEAVE';
$path_to_root  = '../../..';

include_once($path_to_root . '/includes/session.inc');
add_access_extensions();

$js = '';
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

include_once($path_to_root . '/includes/ui.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');

page(_($help_context = 'Apply Leave'), false, false, '', $js);
global $Ajax;
//--------------------------------------------------------------------------
function can_process(){

	if($_POST['FromDate'] == ''){
		display_error("From date can not be empty");
		return false;
	}
	if($_POST['ToDate'] == ''){
		display_error("To date can not be empty");
		return false;
	}
	if($_POST['memo_'] == ''){
		display_error("Description can not empty");
		return false;
	}
	if(date('Y-m-d',strtotime(date2sql($_POST['FromDate']))) > date('Y-m-d',strtotime(date2sql($_POST['ToDate'])))){
		display_error("Enter a correct date Please");
		return false;	
	}
	if(check_attended_added($_POST['emp_id'], 0, $_POST['FromDate'], $_POST['ToDate']) > 0){
		display_error("Leave Can not be marked because attendence is already marked");
		return false;
	}

          	$month_no = date('n',strtotime(date2sql($_POST['FromDate'])));
      		$to_date = date2sql($_POST['FromDate']);
   if (check_payslip($_POST['emp_id'],$month_no,get_selected_years_to_id(date("Y", strtotime($to_date))) ))
   {
   	display_error(_(' employee payslip is process for selected month'));
        set_focus('emp_id');
        return false;

   }

   $month_no = date('n',strtotime(date2sql($_POST['ToDate'])));
      		$to_date = date2sql($_POST['ToDate']);
   if (check_payslip($_POST['emp_id'],$month_no,get_selected_years_to_id(date("Y", strtotime($to_date))) ))
   {
   	display_error(_(' employee payslip is process for selected month'));
        set_focus('emp_id');
        return false;

   }



   

    $from = date2sql($_POST['FromDate']);
	$to = date2sql($_POST['ToDate']);
	$begin = new DateTime($from);
	$end = new DateTime($to);
	$end = $end->modify('+1 day');
	$interval = DateInterval::createFromDateString('1 day');
	$period = new DatePeriod($begin, $interval, $end);
   $is_leave=0;
	foreach ($period as $dt) {
       // display_error($dt->format("Y-m-d"));
       if(check_leave($_POST['emp_id'],$dt->format("Y-m-d")))
       {
       	display_error(sql2date($dt->format("Y-m-d"))." has  already marked leave for this person" );
       	$is_leave=1;
       }
		// $day = $dt->format("Y-m-d");
		// $day = sql2date($day);
		// if(check_date_paid($emp_id, $day))
		// 	return true;
	}
	if($is_leave)
	return false;



// exit();
	
	return true;
}

if (isset($_POST['Process']) && can_process()){
	add_leave_of_employee($_POST['emp_id'],$_POST['FromDate'],$_POST['ToDate'],$_POST['memo_']);
	display_notification("Leave Has been Added");
	unset($_POST['FromDate']);
	unset($_POST['ToDate']);
	unset($_POST['memo_']);
	
}

start_form();

display_leave_header();

br();
display_leave_summary();

if ($_POST['emp_id'] != ""){
	leave_remarks_footer();
	br();
	echo "<center>";
	submit_cells('Process', _("Process Leave"), '',  'default');
	echo "</center>";
}





end_form();
end_page();