<?php
$page_security = 'EMP_LISTING_REPORT';

// ----------------------------------------------------------------
//
// Creator:	Hamza Parwani
// date_:	2020-10-23
// Title:	Employee Setup Listing
// ----------------------------------------------------------------
$path_to_root="..";

include_once($path_to_root . "/includes/session.inc");

add_access_extensions();

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/gl/includes/gl_db.inc");
include_once($path_to_root . "/sales/includes/sales_db.inc");
include_once($path_to_root . "/fixed_assets/includes/fa_classes_db.inc");
include_once($path_to_root . "/admin/db/tags_db.inc");

$user_id=($_SESSION['wa_current_user']->user);
$myrow_user=get_user($user_id);

//----------------------------------------------------------------------------------------------------

print_employee_detail_listing();
//----------------------------------------------------------------------------------------------------
//pk
function checking_report($id){
	$sql = " SELECT * FROM `0_report_sign` WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

//----------------------------------------------------------------------------------------------------
function get_department_name($id){
	$sql= "SELECT dept_name from ".TB_PREF."department WHERE dept_id=".db_escape($id);
	$result= db_query($sql);
	return db_fetch($result)['dept_name'];
}
// -----------------------------------------------------------------------------------
function get_designation_name($id){
	$sql= "SELECT scale_name from ".TB_PREF."salaryscale WHERE scale_id=".db_escape($id);
	$result= db_query($sql);
	return db_fetch($result)['scale_name'];
}
//----------------------------------------------------------------------------------------------------

function get_role_name($id){
	$sql= "SELECT description from ".TB_PREF."security_roles WHERE id=".db_escape($id);
	$result= db_query($sql);
	return db_fetch($result)['description'];
}
// ---------------------------------------------------------------------------------------------------
function get_gender_label($id){
	
	if ($id == -1)
		$gender  = null;
	elseif($id == 0)
		$gender = _("Female");
	elseif($id == 1)
		$gender = _("Male");
	else
		$gender = _("Other");

	return $gender;

}
// ---------------------------------------------------------------------------------------------------
function get_emp_name($id){
	$sql = "SELECT emp_first_name, emp_last_name from ".TB_PREF."employee WHERE emp_id=".db_escape($id);
	$result= db_query($sql);
	$row = db_fetch($result);
	$name = $row['emp_first_name']." ".$row['emp_last_name'];
}
//----------------------------------------------------------------------------------------------------

function print_employee_detail_listing()
{
    global $path_to_root , $depreciation_methods;


    $depart_id = $_POST['PARAM_0'];
    $emp_id = $_POST['PARAM_1'];
    $designation_id = $_POST['PARAM_2'];
    $role_id = $_POST['PARAM_3'];
    $gender_id = $_POST['PARAM_4'];
	$destination = $_POST['PARAM_5'];

	$serial_no=1;

	$REPORT_ID = 821;
	if ($destination)
		include_once($path_to_root . "/reporting/includes/excel_report.inc");
	else
		include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	$orientation = 'P';//($orientation ? 'L' : 'P');
    $dec = 0;


	if ($depart_id == 0)
		$depart = null;
	else
		$depart = get_department_name($depart_id);

	if ($gender_id == -1)
		$gender  = null;
	elseif($gender_id == 0)
		$gender = _("Female");
	elseif($gender_id == 1)
		$gender = _("Male");
	else
		$gender = _("Other");

	if($role_id== null)
		$role = null;
	else
		$role = get_role_name($role_id);

	if($designation_id == 0)
		$designation = null;
	else
		$designation = get_designation_name($designation_id);

	if($emp_id == 0)
		$emp = null;
	else
		$emp = get_emp_name($emp_id);


	$cols = array(0, 60,120 , 185, 235, 310,380, 480, 540);

	$headers = array(('Ser. #'),_('Emp. ID'),_('Name'), _('Gender'), _('Mobile'), 
				    _('Salary'),_('Hired Date'),_('Department'));

	$aligns = array('left','left', 'left','left', 'left', 'left', 'left','left','left');

    $params =   array( 	0 => $comments,
    				    1 => array('text' => _('Employee'), 'from' => $emp, 'to' => ''),
    				    2 => array('text' => _('Department'), 'from' => $depart, 'to' => ''),
    				    3 => array('text' => _('Designation'), 'from' => $designation, 'to' => ''),
    				    4 => array('text' => _('Role'), 'from' => $role, 'to' => ''),
    				    5 => array('text' => _('Gender'),'from' => $gender,'to' => '' ) );

    $rep = new FrontReport(_('Employee Setup Listings'), "EmployeeSetupListing",'A4_REP', 9, $orientation);
    
    if ($orientation == 'L')
    	recalculate_cols($cols);

    $rep->Font();
    $rep->Info($params, $cols, $headers, $aligns);
    $rep->NewPage();
    $summary_start_row = $rep->bottomMargin + (7 * $rep->lineHeight);

    

      $sql = "SELECT *, curdate() AS tran_date FROM ".TB_PREF."employee WHERE emp_id>0 ";
	if ($depart_id != 0)
		$sql .= " AND  department_id = ".db_escape($depart_id);
	if ($role_id != null)
		$sql .= " AND role = ".db_escape($role_id);
	if ($designation_id != 0){
		$sql .= " AND salary_scale_id=".db_escape($designation_id);
	}
	if ($gender_id != -1){
		$sql .= " AND gender=".db_escape($gender_id);
	}
	if($emp_id != 0){
		$sql .= " AND emp_id=".db_escape($emp_id);
	}

	$sql .= " ORDER by emp_id";

// display_error($sql);
	$result = db_query($sql, "Employees could not be retrieved");

	$newrow=array();

	while ($myrow=db_fetch($result)){ 

		$c=0;

       if($destination){

       		$rep->TextCol($c++, $c,	trim(($serial_no++).".") , -2);
	    	$rep->TextCol($c++, $c,	trim($myrow['emp_id']) , -2);    	
	    	$rep->TextCol($c++, $c,	trim($myrow['emp_first_name']." ".$myrow['emp_last_name']) , -2);
	    	$rep->TextCol($c++, $c,	get_gender_label($myrow['gender']) , -2);
		}
	    else{

	    	$rep->TextCol($c++, $c,	trim(($serial_no++).".") , -2);
			$oldrow = $rep->row;
			$rep->TextColLines($c++, $c, trim($myrow['emp_id']) , -2);
			$newrow[] = $rep->row;
			$rep->row = $oldrow;

			$rep->SetFont('dejavusans', '', '','', true);

			$oldrow = $rep->row;
			$rep->TextColLines($c++, $c,trim($myrow['emp_first_name']." ".$myrow['emp_last_name']), -2);
			$newrow[] = $rep->row;
			$rep->row = $oldrow;

			$rep->SetFont('dejavusans', '', '','', true);

			$oldrow = $rep->row;
			$rep->TextColLines($c++, $c, get_gender_label($myrow['gender']), -2);
			$newrow[] = $rep->row;
			$rep->row = $oldrow;
	    }			

		if($destination){

			$rep->TextCol($c++, $c, $myrow['emp_mobile'], -2);
			$rep->TextCol($c++, $c, $myrow['emp_salary'], -2);
		}	
		else{

			$oldrow = $rep->row;
			$rep->TextColLines($c++, $c, $myrow['emp_mobile'], -2);
			$newrow[] = $rep->row;
			$rep->row = $oldrow;

			$oldrow = $rep->row;
			$rep->TextColLines($c++, $c, $myrow['emp_salary'], -2);
			$newrow[] = $rep->row;
			$rep->row = $oldrow;
		}		

		$rep->TextCol($c++, $c,sql2date($myrow['emp_hiredate']), -2);

		if($destination)
			$rep->TextCol($c++, $c,	get_department_name($myrow['department_id']) , -2);

		else{
			$oldrow = $rep->row;
			$rep->TextColLines($c++, $c, trim(get_department_name($myrow['department_id'])), -2);
			$newrow[] = $rep->row;
			$rep->row = $oldrow;
		}

	
		// $rep->SetFont('dejavusans', '', '','', true);


		if($destination)
			$rep->NewLine();
		else
			$rep->row=min($newrow);

		unset($newrow);

		if ($rep->row < $summary_start_row)
			$rep->NewPage();

		// display_error($show_detail);

       $rep->NewLine(2);

       if ($rep->row < $summary_start_row)
			$rep->NewPage();

	}

    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,8,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }

    $rep->End();
}

