<?php
/*=======================================================\
|                        FrontHrm                        |
|--------------------------------------------------------|
|   Creator: Phương                                      |
|   Date :   09-Jul-2017                                 |
|   Description: Frontaccounting Payroll & Hrm Module    |
|   Free software under GNU GPL                          |
|                                                        |
\=======================================================*/
$page_security =  'EMP_LEAVE_MANAGEMENT_REPORT'; // 'SA_CUSTBULKREP';

$path_to_root = "..";
include_once($path_to_root . "/includes/session.inc");

add_access_extensions();

include_once($path_to_root . "/dimensions/includes/dimensions_db.inc");
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_db.inc');
include_once($path_to_root . '/modules/FrontHrm/includes/frontHrm_ui.inc');
include_once($path_to_root . "/admin/db/tags_db.inc");

print_time_sheet_list();

function checking_report($id){
	$sql = " SELECT * FROM ".TB_PREF."report_sign WHERE rep_id = '$id' ";
	 // display_error($sql);
	$result = db_query($sql,"Did not Executed");
	return $result;
}

function get_employees_list($gender, $dep, $from, $to) {
    $dep = empty($dep) ? false : $dep;
	$sql = get_employees(false, false, $dep);

    if($gender != -1)
    	$sql .= " AND gender = ".db_escape($gender);
    if(!empty($from))
    	$sql .= " AND emp_id >= ".db_escape($from);
	if(!empty($to))
		$sql .= " AND emp_id <= ".db_escape($to);

	$sql .= " AND emp_hiredate!='0000-00-00' ";

	return db_query($sql, _('could not get employee'));
}

// function get_allowances_data($row)  
// {
//    $result = getsum_allowances($row['emp_id']);
//                                 $row1 = db_fetch($result);
//                                return number_format($row1["amounts"],2);
// }

// function get_deduction_data($row)  
// {
//   $result = getsum_deductions($row['emp_id']);
//     $row = db_fetch($result);
//    return number_format($row["amounts"],2);
// }
function display_department_employees($dep_id, $dep_name, $gender, $from, $to, $rep) {

	$rep->Font('bold');
	$rep->TextCol(0, 1, $dep_id);
	$rep->TextCol(1, 4, $dep_name);
	$rep->Font();
	$rep->row -= 4;
	$rep->Line($rep->row);
	$rep->NewLine();

	$emps = get_employees_list($gender, $dep_id, $from, $to);
	while($emp = db_fetch($emps)) {
        $rep->TextCol(0, 1, $emp['emp_id']);
		$rep->TextCol(1, 2, $emp['name']);
		$rep->TextCol(2, 3, $emp['gender'] == 1 ? _('Male') : ($emp['gender'] == 0 ? _('Female') : 'Other'));
		$rep->TextCol(3, 4, $emp['emp_mobile']);
		$rep->TextCol(4, 5, $emp['emp_email']);
		$rep->DateCol(5, 6, $emp['emp_birthdate'], true);
		$rep->DateCol(6, 7, $emp['emp_hiredate'], true);
		$rep->TextCol(7, 8, get_salary_scale($emp['salary_scale_id'])['scale_name']);
		$rep->NewLine();
    }
    $rep->NewLine();
}

function get_attendance_log_month_year_wise($emp_id,$month,$year){
  $sql = "SELECT * FROM ".TB_PREF."attendance WHERE is_leave = 0";
  if ($month) {
  	$sql .= " AND MONTH(att_date)= '$month'";
  }
  if ($year) {
  	$sql .= " AND YEAR(att_date)= '$year'";
  }
  if ($emp_id) {
  	$sql .= " AND emp_id= '$emp_id'";
  }
  // display_error($sql);
  $result = db_query($sql);
  return $result;
}
function get_status_name($status_id){
	if ($status_id == 0) {
		return 'Normal Hrs';
	}elseif ($status_id == 1) {
		return 'Overtime Hrs';
	}
}
function  get_salary_hr($row,$hr,$month,$year){
 
 
	$Work_days = get_company_pref('payroll_month_work_days');
	$Work_hours = get_company_pref('payroll_work_hours');


	$gross_salary = str_replace(',','',get_gross_salary($row['emp_id'],$month,$year)) ;

	if ($row['overtime_id']==0) {
		$hr=$Work_hours; // set one day hr.		
		 $value= ($gross_salary / $Work_days / $Work_hours) * $hr;
	}elseif ($row['overtime_id'] == 1) {
		$value= (get_employees($row['emp_id'])['emp_salary'] / $Work_days / $Work_hours) * $hr * $row['rate'];

         return $value;
	}
	else
	 $value= ( $gross_salary / $Work_days / $Work_hours) * $hr;
 
  return number_format($value,2);
}
function get_paid_leave($emp_id,$month,$year,$gross_paid_leave=0){

	$limit = days_in_month($month,$year);
	$leave_days=0;
		for($d=1; $d<=$limit; $d++)
		{
			$time=mktime(12, 0, 0, $month, $d, $year);          
			$is_leave =   check_leave($emp_id,date('Y-m-d', $time));
             if($is_leave)
			{
				if($is_leave['leave_type']==1)
				{
					if($gross_paid_leave==1 &&  $is_leave['paid_gross_amount']==1)
					$leave_days++;
					if($gross_paid_leave==2 && $is_leave['paid_gross_amount']==0)   
					$leave_days++;
					if($gross_paid_leave==0)
					$leave_days++;
				} 
		// }
     //            echo "<pre>";
			  // print_r($is_leave);
			}	
		}
	return $leave_days;

}

function get_un_paid_leave($emp_id,$month,$year){

	$limit = days_in_month($month,$year);
	$leave_days=0;
		for($d=1; $d<=$limit; $d++)
		{
			$time=mktime(12, 0, 0, $month, $d, $year);          
			$is_leave =   check_leave($emp_id,date('Y-m-d', $time));
             if($is_leave)
			{
			if($is_leave['leave_type']==0 && $is_leave['approved']==1)
			  $leave_days++;
		// }
     //            echo "<pre>";
			  // print_r($is_leave);
			}	
		}
	return $leave_days;

}
function get_allowances_data($emp_id,$month,$year)  
{

		$row2=check_payslip($emp_id,$month,$year); 
		if($row2)
		{
			return number_format($row2['allowance'],2);
		}
		else 
		{
			$result = getsum_allowances($emp_id);
			$row1 = db_fetch($result);
			return number_format($row1["amounts"],2);
		} 
}
function get_deduction_data($emp_id,$month,$year)  
{
	$row2=check_payslip($emp_id,$month,$year); 
	if($row2)
	{
	     return number_format($row2['deduction'],2);
	}
	else 
	{
		$result = getsum_deductions($emp_id);
		$row = db_fetch($result);
		return number_format($row["amounts"],2);
	}
}
function get_gross_salary($emp_id,$month,$year){

		$row2=check_payslip($emp_id,$month,$year);
		if($row2)
		return number_format($row2['gross_salary'],2);

		
  
  $gross_salary=(get_employees($emp_id)['emp_salary'] + str_replace(',','', get_allowances_data($emp_id,$month,$year))  ) - str_replace(',','', get_deduction_data($emp_id,$month,$year));
	return number_format($gross_salary,2) ;
}
function get_paid_leave_salary($emp_id,$month,$year){
	$Work_days = get_company_pref('payroll_month_work_days');
	$limit = days_in_month($month,$year);
	$leave_days=0;
		for($d=1; $d<=$limit; $d++)
		{
			$time=mktime(12, 0, 0, $month, $d, $year);          
			$is_leave =   check_leave($emp_id,date('Y-m-d', $time));
             if($is_leave)
			{
			if($is_leave['leave_type']==1)
			  $leave_days++;
			}	
		}

		// display_error(get_gross_salary($row)." / ".$Work_days."  * ".$leave_days);
		// display_error((str_replace(',','',get_gross_salary($row)) /  $Work_days )*$leave_days);

	return  number_format( (get_employees($emp_id)['emp_salary'] /  $Work_days )*$leave_days ,2);

}

function get_sql_record($date, $emp_id, $status){
	if($status == 0 || $status == 1){
		$status1 = 0;
		$status2 = 1;
	}
	elseif($status == 4 || $status == 5){
		$status1 = 4;
		$status2 = 5;
	}
	$sql = "SELECT * FROM ".TB_PREF."attendance WHERE att_date=".db_escape($date)." 
			AND emp_id=".db_escape($emp_id)." AND (status = '$status1' OR status = '$status2') 
			ORDER BY time";
	return $sql;
}

function get_time_string($time){
	$time = date('h:i A',strtotime($time));
	return $time;
}
function print_time_sheet_list() {
	global $path_to_root;
    
	// $dimensions2 = $_POST['PARAM_0'];
	// $dimensions1 = $_POST['PARAM_1'];
	// $d1_tag=$_POST['PARAM_2'];
	$department = $_POST['PARAM_0'];
	$employee_id=$_POST['PARAM_1'];
	$month=$_POST['PARAM_2'];
	$year=$_POST['PARAM_3'];
		$year_id=$year;
		$REPORT_ID = 8903;
	$year = get_selected_years($year);
	// display_error($year);
	include_once($path_to_root . "/reporting/includes/pdf_report.inc");

	if ($month == 0) {
		display_error("Select Month.");
		exit;
	}elseif ($year == 0) {
		display_error("Select Year.");
		exit;
	}elseif ($employee_id == 0) {
		display_error("Select Employee.");
		exit;
	}

	$orientation = ($orientation ? 'L' : 'P');

	$cols = array(0, 20, 80, 150,220, 270, 360,  450,  530);
	// $cols = array(0, 40, ,160, 210, 280,  410,  530);

	$headers = array(_('Id'),('In'), _('Out'),_('Date'), _('Hrs'), _('Overtime factor'), _('Type'), _('Values'));
	
	$aligns = array('left',	'left',	'left',	'left', 'left','left', 'left', 'left');


	$params = array(
		0 => $comments,
		1 => array('text' => _('Month'), 'from' =>date('F', mktime(0, 0, 0, $month, 10)), 		'to' => $to),
		2 => array('text' => _('Year'), 'from' => $year, 		'to' => $to),		
		3 => array('text' => _('Employee'), 'from' => get_employees($employee_id)['name'], 		'to' => $to),
		4 => array('text' => _('emp_hiredate'), 'from' => sql2date(get_employees($employee_id)['emp_hiredate']) , 		'to' => $to),
// 		5 =>  array('text' => _('Note'), 'from' => 'Calculate days of the month 30 days', 		'to' => $to),
	);


	$rep = new FrontReport(_('Time Sheet'), "TimeSheet", user_pagesize(), 9, $orientation);
    if ($orientation == 'L')
    	recalculate_cols($cols);
	
	$rep->Font();
	$rep->Info($params, $cols, $headers, $aligns);
	$rep->NewPage();    
    $result = get_attendance_log_month_year_wise($employee_id,$month,$year);
    $sno = 1;
	$normal_hours = 0;
	$normal_hours_amt = 0;
	$overtime_hours = 0;
	$overtime_hours_amt = 0;
	$total_hours = 0;
	$total_hours_amt = 0;
	$grand_total = 0;
	$normal_days=0;
	$paid_unpaid_leave=0;
    while ($row = db_fetch($result)) {
// display_error(date('l', strtotime($row['att_date'])))  ;
    	if(check_weekend(date('l', strtotime($row['att_date']))) && $row['overtime_id']==0)
    	{
    		if ($row['overtime_id']==1) {
				$hours =  $row['hours_no'] ;//get_hrs_ot($row['emp_id'],$row['att_date']);
				$overtime_hours += $hours;
				$overtime_hours_amt += str_replace(',','',get_salary_hr($row,$hours,$month,$year_id)) ;
				}

               continue;
    	}
          if(check_leave($row['emp_id'],$row['att_date']) && $row['overtime_id']==0)
          {
          	$paid_unpaid_leave+=1;
          	continue;
          }
            if(check_holiday($row['att_date']) && $row['overtime_id']==0)
            {

				if ($row['overtime_id']==1) {
				$hours =  $row['hours_no'] ;//get_hrs_ot($row['emp_id'],$row['att_date']);
				$overtime_hours += $hours;
				$overtime_hours_amt += str_replace(',','',get_salary_hr($row,$hours,$month,$year_id)) ;
				}

             continue;
            }	
    	$rep->TextCol(0, 1, $sno++);

	$rep->TextCol(1, 2, date('H:i:s',strtotime($row['time'])) );

    			$rep->TextCol(2, 3, date('H:i:s',strtotime($row['time_out'])));
		$rep->DateCol(3, 4, $row['att_date'],true);
		$hours = 0;
		if ($row['overtime_id'] == 0) {
			$hours =  $row['hours_no'] ;//get_hrs($row['emp_id'],$row['att_date']);
    		$normal_hours += $hours; 
    		$normal_hours_amt += get_salary_hr($row,$hours,$month,$year_id);
    		$rep->TextCol(4, 5, number_format($hours,2));
        	$total_hours += $hours; 
        	$normal_days+=1;
         	$rep->TextCol(5, 6, '-');
		}elseif ($row['overtime_id']==1) {
			$hours =  $row['hours_no'] ;//get_hrs_ot($row['emp_id'],$row['att_date']);
			$overtime_hours += $hours;
			$overtime_hours_amt += str_replace(',','',get_salary_hr($row,$hours,$month,$year_id)) ;
			
    	$rep->TextCol(4, 5, number_format($hours,2));
    	$total_hours += $hours; 
    	$rep->TextCol(5, 6, number_format($row['rate'],2));
		}
    	$rep->TextCol(6, 7, get_status_name($row['overtime_id']));
    	$rep->TextCol(7, 8, number_format(get_salary_hr($row,$hours,$month,$year_id),2));
    	$total_hours_amt += get_salary_hr($row,$hours,$month,$year_id);
    
  

    			

    	$rep->NewLine(1);
    }

 if(get_employees($employee_id)['emp_hiredate']!='0000-00-00')
 {

	$weekends = get_weekends_in_month($month,$year,$employee_id);
	$holidays = get_holiday_in_month($month,$year,$employee_id);
	$paid_leave = get_paid_leave($employee_id,$month,$year);
	$un_paid_leave = get_un_paid_leave($employee_id,$month,$year);
	$Work_hours = get_company_pref('payroll_work_hours');
    $Work_days = get_company_pref('payroll_month_work_days'); 

     $gross_salary_paid_leave= ( str_replace(',','',get_gross_salary($employee_id,$month,$year_id)) /  $Work_days )*get_paid_leave($employee_id,$month,$year,1);
     $basic_salary_paid_leave= (get_employees($emp_id)['emp_salary'] /  $Work_days )*get_paid_leave($employee_id,$month,$year,2);
     
	$paid_leave_salary =$gross_salary_paid_leave+$basic_salary_paid_leave;  //str_replace(',', '',  get_paid_leave_salary($employee_id,$month,$year)) ;
	$day_salary= str_replace(',','',get_gross_salary($employee_id,$month,$year_id)) / $Work_days;
	$holidays_salary =  $day_salary*$holidays;
	
	

	$weekends_salary =  $day_salary*$weekends;
	$limit = days_in_month($month,$year);
  $paid_unpaid_leave=$paid_leave+$un_paid_leave;

    if(($weekends+ $holidays+$paid_unpaid_leave+$normal_days)==$limit)
     {
         // payslip calculation default 30 days calculation;
         $day_salary= str_replace(',','',get_gross_salary($employee_id,$month,$year_id)) / $Work_days;
         $normal_days=30-($paid_unpaid_leave+$weekends+$holidays);
         // display_error($weekends."*".$holidays);
         $normal_hours_amt= $total_hours_amt= $day_salary*$normal_days;
         $normal_hours= $Work_hours * $normal_days;

     }  


		if($paid_leave==$limit)
		$paid_leave_salary = $grand_total =get_employees($employee_id)['emp_salary'];
		else
		$grand_total = $total_hours_amt+$holidays_salary+$weekends_salary+$overtime_hours_amt+$paid_leave_salary;

// display_error( $total_hours_amt." + ".$holidays_salary." + ".$weekends_salary." + ".$overtime_hours_amt." + ".$paid_leave_salary);
    $rep->Line($rep->row);
        $rep->NewLine();
    $rep->TextCol(0, 2, 'Basic Salary');

    $rep->TextCol(5, 6, number_format(get_employees($employee_id)['emp_salary'],2) );
        $rep->NewLine();
    $rep->TextCol(0, 2, 'Gross Salary');
    $rep->TextCol(5, 6,get_gross_salary($employee_id,$month,$year_id));
    $rep->NewLine();
    $rep->TextCol(0, 2, 'Normal Time Hrs');
    $rep->TextCol(2, 3, number_format($normal_hours,2));
    $rep->TextCol(5, 6, number_format($normal_hours_amt,2));
    $rep->NewLine();
    $rep->TextCol(0, 2, 'Over Time Hrs');
    $rep->TextCol(2, 3, number_format($overtime_hours,2));
    $rep->TextCol(5, 6, number_format($overtime_hours_amt,2));
    $rep->NewLine();

    $rep->NewLine();
    $rep->TextCol(0, 2, 'Total Weekend');
    $rep->TextCol(2, 3, number_format($weekends,2));
    $rep->TextCol(5, 6, number_format($weekends_salary,2));
    $rep->NewLine();
    $rep->TextCol(0, 2, 'Total Holidays');
    $rep->TextCol(2, 3, number_format($holidays,2));
    $rep->TextCol(5, 6, number_format($holidays_salary,2));
    $rep->NewLine();
    $rep->TextCol(0, 2, 'Paid Leaves');
    $rep->TextCol(2, 3, number_format($paid_leave,2));
    $rep->TextCol(5, 6, number_format($paid_leave_salary,2));
    $rep->NewLine();
    $rep->TextCol(0, 2, 'Grand Total');

    $rep->TextCol(5, 6, number_format($grand_total,2));
    $rep->NewLine();
 }
 else
 {
 	 display_error("Invalid hire date");
     exit();
 }
	$rep->Line($rep->row + 10);


    $res = checking_report($REPORT_ID);
    if(db_num_rows($res) > 0){
       $row = db_fetch($res);
       
		if($row['is_policy_text'] == 1){
			$rep->row = 120;
			$rep->TextColLines(0,8,$row['policy_desc'] , 'center'); 
		}
		if($row['is_policy_image'] == 1){
			$logo = company_path() . "/images/" . $row['filename'];
			$rep->AddImage($logo, $ccol, $rep->row-160, 0, 50);
		}


	        if($row['signature2'] == '' && $row['signature3'] == ''){   
	          	if($orientation == 'P'){
	          		$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(425,30,150,$row['signature1'] , 'center'); 
	          	}else{

	          		$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
	          	    $rep->TextWrap(650,30,150,$row['signature1'] , 'center'); 
	          	}

	        }


	        if($row['signature2'] != '' && $row['signature3'] == ''){
				if($orientation == 'P'){
		            $rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(425,30,150,$row['signature2'] ,  'center');
		        }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
		            $rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

		            $rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
		            $rep->TextWrap(650,30,150,$row['signature2'] ,  'center');
		        }

	        }



	        if($row['signature1'] != '' && $row['signature2'] != '' && $row['signature3'] != ''){
	           if($orientation == 'P'){
					$rep->TextWrap(25,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(25,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(230,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(230,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(425,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(425,30,150,$row['signature3'] ,  'center');
	            }else{

					$rep->TextWrap(45,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(45,30,150,$row['signature1'] ,  'center'); 

					$rep->TextWrap(365,41,150,"______________________________" ,  'center'); 
					$rep->TextWrap(365,30,150,$row['signature2'] ,  'center'); 

					$rep->TextWrap(650,41,150,"_____________________________" ,  'center'); 
					$rep->TextWrap(650,30,150,$row['signature3'] ,  'center');

	            }
	        }
	    }



	$rep->End();
}