<?php

//Author: Ross Addison Version 2.3.21 upgrade to Tom Hallman's 2.3.3
//Website: http://www.bbqq.co.uk
//Email: frontaccounting@bbqq.co.uk
//New features:
//1. Trial check before importing.
//2. Tabular display of journal entries, each journal grouped into  debits and credits using Front Accounting's 'items cart' class.
//3. Importing of bank statements.
//4. Tax type inclusion for VAT registered companies.
//5. Inclusion of transactions automatically in an audit trail.
//6. Display notifications identifying how tables within the database are being affected for a more transparent display to interested programmers.
//7. Additional lookup tools for looking up customer, supplier, company setup information eg. fiscal year, and other tools that users might find useful for their import.
//8. Inclusion of csv examples using the en_GB account structure under folder templates.
//9. See the Spreadsheet_headers file for csv formats.
//10. Import Sales Orders/Invoices

//Module contents
//./Import_transactions/import_transactions.php
//./Import_transactions/template/bank_en_GB.csv                                       .......for bank statement processing......users process bank.csv twice. once with 'deposit processing' and once with 'payment processing'.
//./Import_transactions/template/deposit_en_GB.csv                                    .......for non-bank statement deposit processing...deposit.csv
//./Import_transactions/template/payment_en_GB.csv                                    .......for non-bank statement payment processing...payment.csv
//./Import_transactions/template/journal_en_GB.csv                                    .......for non-bank journal processing.............journal.csv
//./Import_transactions/includes/import_transactions.inc                              .......include file containing functions used here.
//./Import_transactions/includes/import_sales_order_entry.inc                         .......for importing sales orders/invoices
//./Import_transactions/includes/import_sales_cart_class.inc
//./Import_transactions/includes/import_sales_order_ui.inc

$page_security = 'SA_REVACURRENCIES';
$path_to_root = "../..";
include_once ($path_to_root . "/includes/session.inc");
include_once ($path_to_root . "/includes/sysnames.inc"); //referencetype_list_row for determining next reference for source documents
include_once ($path_to_root . "/includes/main.inc"); //function page
include_once ($path_to_root . "/includes/ui.inc");
include_once ($path_to_root . "/includes/ui/items_cart.inc"); //class 'items_cart' gl_items for classic tabular representation of journals
include_once ($path_to_root . "/includes/ui/ui_input.inc");
include_once ($path_to_root . "/includes/db/audit_trail_db.inc"); //add_audit_trail mandatory for all import transactions
include_once ($path_to_root . "/gl/includes/db/gl_db_trans.inc"); // write journal entries; add_gl_tax_details; add_gl_trans
include_once ($path_to_root . "/gl/includes/db/gl_db_bank_trans.inc"); //add_bank_trans
include_once ($path_to_root . "/gl/includes/db/gl_db_bank_accounts.inc"); //get_bank_gl_account
include_once ($path_to_root . "/gl/includes/db/gl_db_accounts.inc"); // gl_account_in_bank_accounts
include_once ($path_to_root . "/gl/includes/gl_db.inc"); //link to other includes
include_once ($path_to_root . "/includes/date_functions.inc"); //sql2date, is_date_in_fiscal_year
include_once ($path_to_root . "/includes/data_checks.inc");
include_once ($path_to_root . "/admin/db/company_db.inc"); //default control accounts
include_once ($path_to_root . "/includes/ui/ui_controls.inc");
include_once ($path_to_root . "/modules/import_transactions/includes/import_transactions.inc"); //functions used
include_once ($path_to_root . "/modules/import_transactions/includes/import_sales_order_entry.inc"); // adaptation of sales_order_entry.php
include_once ($path_to_root . "/modules/import_transactions/includes/import_sales_cart_class.inc"); // adaptation of cart class
include_once ($path_to_root . "/modules/import_transactions/includes/import_sales_order_ui.inc"); // adaptation of sales_order_ui.inc
//include_once($path_to_root . "/gl/includes/ui/gl_journal_ui.inc"); display_import_items adapted from display_ gl_items

add_access_extensions();

//Turn these next two lines on for debugging
// error_reporting(E_ALL);
// ini_set("display_errors", "on");

//Set '$yes' to true if you are testing this module and you do not want to manually(phpmyadmin) delete previous test run records before each test run
//Ensure that your company has no important information in it as these will be deleted by means of all_delete function under import_transactions.inc
//Warning: Most records will be deleted if '$yes' set to true. Default must stay on false for normal operation.
//Recommended: Remove this next line after you are happy with testing.

//-------------------------We Create Function requirment -------------------------------------

function get_paymint_term($paymint_term)
{ 
    if($paymint_term == null)
        return -1;

    $sql = " SELECT * FROM ".TB_PREF."payment_terms";
    $result = db_query($sql);
    while ( $row = db_fetch($result) ) {
        # code...
        if(strtoupper($row['terms']) == strtoupper($paymint_term) )
            return $row['terms_indicator'];

    }
    
   return -1;

}


function get_dimension_id($dimension_id,$dimension2_id ,$line)
{
     $d1 = $d2 = 0;
   if($dimension_id!==0 && $dimension_id!=null)

       {        $sql="SELECT * FROM ".TB_PREF."dimensions WHERE  type_=1";

                  $result = db_query($sql);

                while ($row = db_fetch($result)) {
              
                 //  display_error(strtoupper($row['name']) ." == ". strtoupper($dimension_id));
                    if(strtoupper($row['name']) == strtoupper($dimension_id))
                           $d1=$row['id'];
                    
                            }
             if($d1 == 0)
                 {
                   display_error(_("$line does not have a dimension_id (".$dimension_id.") (line $line in import file '{$_FILES['imp']['name']}')")); 
              // exit();

                    }
        }            
       // display_error($dimension2_id);

    if( $dimension2_id !== 0 && $dimension2_id!=null)
    {
       // display_error($dimension2_id);
      $sql="SELECT * FROM ".TB_PREF."dimensions WHERE type_=2";
      $result = db_query($sql);

    while ($row = db_fetch($result)) {
        // display_error(strtoupper($row['name']) ." == ". strtoupper($dimension2_id));
        if(strtoupper($row['name']) == strtoupper($dimension2_id))
               $d2=$row['id'];
        
       }
           if($d2 == 0 )
           {
       display_error(_("$line does not have a dimension2_id ' ".$dimension2_id." '  (line $line in import file '{$_FILES['imp']['name']}')")); 
        // exit();
          }

    }
       
     return $d1."-".$d2;
}

function customer_exist_name($customer_name,$branch_ref,$line) {
    $cust_id=0;
    $branch_id=0;
    //display_error($customer_name."   ====  ".$branch_ref);
    $sql = "SELECT * FROM ".TB_PREF. "debtors_master";
   
    $result = db_query($sql, _("Could not query debtors master table"));
    
    while ($row = db_fetch($result)) 
    {
        # code...
     //   display_error(strtoupper(str_replace(" ", "",$row['debtor_ref']))." == ".strtoupper(str_replace(" ", "",$customer_name)));
    if(strtoupper(str_replace(" ", "",$row['debtor_ref']))==strtoupper(str_replace(" ", "",$customer_name)))
       $cust_id=$row['debtor_no'];
    }
    if($cust_id!==0)
    {
          $sql = "SELECT * FROM ".TB_PREF."cust_branch where debtor_no = $cust_id";
          $result = db_query($sql, "Can not look up stock_id");
       while ($row=db_fetch($result)) 
         {
          # code...
       if(strtoupper(str_replace(" ", "",$row['branch_ref']))==strtoupper(str_replace(" ", "",$branch_ref)))
         $branch_id=$row['branch_code'];
         }

         if($branch_id==0)
         display_error(_("$line does not exist  customer Branch  (".$branch_ref.") of this customer (".$customer_name.") (line $line in import file '{$_FILES['imp']['name']}')"));   
    
    }
    else
     display_error(_("$line does not exist customer (".$customer_name.") (line $line in import file '{$_FILES['imp']['name']}')"));   
    // display_error($cust_id."-".$branch_id);
    return  $cust_id."-".$branch_id;
}



function get_ship_id($id){
    
     $sql = "SELECT * FROM ".TB_PREF."shippers";
     $result =db_query($sql);
       while ( $row=db_fetch($result) ) 
         {
          # code...
           //  display_error(strtoupper(str_replace(" ", "",$row['shipper_name']))."==".strtoupper(str_replace(" ", "",$id)));
       if(strtoupper(str_replace(" ", "",$row['shipper_name']))==strtoupper(str_replace(" ", "",$id)))
            return $row['shipper_id'];  
       
            }
    return -1;     
   //display_error(_("$line does not exist shipvia (".$id.") (line $line in import file '{$_FILES['imp']['name']}')"));   
}

//--------------------------------------------------------------------------------------



all_delete($yes = false);
$js = "";
if ($SysPrefs->use_popup_windows) 
    $js .= get_js_open_window(800, 500);
$help_context = "Import General Journals | Deposits | Payments | Bank Statements | Sales Orders | Sales Invoices  <a href='spreadsheet_headers.html'>Help: Formats</a>";
page(_($help_context), false, false, "", $js);

global $Refs;
global $Ajax;

$filename = (isset($_GET['filename']) ? $_GET['filename'] : '');
if ($filename != "") {
    initialize_controls();
    $_POST['type']             = ST_JOURNAL;
    $_FILES['imp']['name']     = $filename;
    $_FILES['imp']['tmp_name'] = $filename;
    $_POST['sep']              = ",";
    $_POST['trial']            = false;
}

if ((isset($_POST['type']))) {
    // display_error($_POST['type']);
    $type = $_POST['type'];
    $entry = new items_cart($type);
    init_entry_part_1($entry, $type);
    if (($type > 0) && isset($_POST['stateformat'])) {
        $stateformat = $_POST['stateformat'];
    } else {
        $stateformat = null;
    }
    $errCnt = 0;
    $entryCount = 0;
    $bank_account_gl_code = "";
    $error = false;
    $displayed_at_least_once = false;
    if (isset($_FILES['imp']) && $_FILES['imp']['name'] != '') {
        $filename = $_FILES['imp']['tmp_name'];
        $sep = $_POST['sep'];
        if (isset($_POST['bank_account']) ? $_POST['bank_account'] : "") {
            $bank_account = isset($_POST['bank_account']) ? $_POST['bank_account'] : "";
            $bank_account_gl_code = get_bank_gl_account($bank_account);
        } //gl_db_bank_accounts.inc
        $fp = @fopen($filename, "r");
        $trial = (isset($_POST['trial']) ? $_POST['trial'] : false);
        if (!$fp) {
            display_error(_("Error opening file $filename"));
        } else {
            begin_transaction();
            $curEntryId[ST_JOURNAL]      = get_next_trans_no(ST_JOURNAL);
            $curEntryId[ST_BANKTRANSFER] = get_next_trans_no(ST_BANKTRANSFER);
            $curEntryId[ST_BANKDEPOSIT]  = get_next_trans_no(ST_BANKDEPOSIT);
            $curEntryId[ST_BANKPAYMENT]  = get_next_trans_no(ST_BANKPAYMENT);
            $line = 0;
            $description = "";
            $i = 0;
            $docline = 1;
            $doc_num = 0;
            $firstlinecopied = false;
            $no = 0;
            $total_debit_positive = 0;
            $skippedheader = false;
            $prev_ref = -1;
            $next_ref = -1;
            $prev_date = null;
            $bank_desc = "";
            $ignore = "";
            $debitsEqualcredits = 1;
            $nextdata = null;
            $dim1_ref =0;
            // check_db_has_stock_items(_("There are no inventory items defined in the system."));
            check_db_has_customer_branches(_("There are no customers, or there are no customers with branches. Please define customers and customer branches."));
            set_time_limit(600); // php maximum execution time
            while (($data = $nextdata) || $line == 0) {
                $nextdata = fgetcsv($fp, 4096, $sep);
                if ($data == null) continue;
                if (($line++ == 0) && ($skippedheader == false)) { //display_notification_centered(_("Skipped header. (line $line in import file '{$_FILES['imp']['name']}')"));
                    $skippedheader = true;
                    continue;
                }
                // display_notification_centered(" --------------------------------------------------------------------------------------------Line $line ------------------------------------------------------------------------------------------");
                     

                if ($type == ST_JOURNAL) {
                    list($reference, $date, $memo, $amt, $code_id, $taxtype, $dim1_ref, $dim2_ref, $person_type_id, $person_id, $comments) = array_merge($data, array(""));
                    list($next_ref,,,, $next_code,,,,,) = $nextdata;
                    str_replace('"', "", $memo);
                    str_replace('"', "", $person_id);
                    $memo = $memo . " (";
                    if ($person_id != null)
                    $memo = $memo . " Person: " . $person_id . ", ";
                    $memo = $memo . "Reference: " . $reference . ") ";
                    display_notification_centered($memo);
                    $bank_account_gl_code = $code_id;
                    $bank_account = is_bank_account($code_id);
                    $BranchNo = null;
                    if ($amt > 0)
                        $total_debit_positive += $amt;

                    if ($reference != $next_ref) {
                        // Note: imported journal GL entries also require a journal entry.
                        // If the journal entry is not created, then
                        // a journal transaction entered through FA would have a trans_no
                        // starting from 1, and thus VOID would void the wrong G/L entries.
                        add_journal(ST_JOURNAL, $curEntryId[ST_JOURNAL], $total_debit_positive, $date, get_company_pref('curr_default'), $curEntryId[ST_JOURNAL]);
                        $total_debit_positive = 0;
                    }
                } else if (($type == ST_BANKPAYMENT) && ($stateformat != null))
                //All amounts to the right of amt are ignored since only considering payments which are to the left of deposits on a bank statement.
                {
                    list($reference, $date, $memo, $amt, $ignore, $code_id, $taxtype, $dim1_ref, $dim2_ref, $person_type_id, $person_id, $BranchNo) = $data;
                    str_replace('"', "", $memo);
                    str_replace('"', "", $person_id);
                    display_notification_centered("You are here payment");
                    if ((($ignore == "") || ($ignore == null) || empty($ignore)) && ($amt > 0.01)) {
                    } else {
                        display_notification_centered(_("Ignoring deposit. Use same csv under deposit processing. (line $line in import file '{$_FILES['imp']['name']}')"));
                        $error = false;
                        $prev_ref = $reference;
                        continue;
                    }
                } else if (($type == ST_BANKDEPOSIT) && ($stateformat != null)) {
                    //All amounts to the left of amt are ignored since only considering deposits which are to the left of payments on a bank statement.

                    list($reference, $date, $memo, $ignore, $amt, $code_id, $taxtype, $dim1_ref, $dim2_ref, $person_type_id, $person_id, $BranchNo) = $data;

   //                if($dim1_ref!='' && $dim1_ref!=null){
   //                    $dim_val = get_dimension_id($dim1_ref, $dim2_ref ,$line);
   // //                display_error($dim_val);              
   //                    $val=explode('-',$dim_val);
   //                    if($val[0]!=0)
   //                    {
   //                      $dim1_ref=$val[0];
                       
   //                     if($val[0]!=0)
   //                      $dim2_ref=$val[1];
   //                    }
   //                  }
                    str_replace('"', "", $memo);
                    str_replace('"', "", $person_id);
                    if ((($ignore == "") || ($ignore == null) || empty($ignore)) && ($amt > 0.01)) {
                    } else {
                        display_notification_centered(_("Ignoring payment. Use same csv under payment processing.(line $line in import file '{$_FILES['imp']['name']}')"));
                        $error = false;
                        $prev_ref = $reference;
                        continue;
                    }
                } else if ((($type == ST_BANKDEPOSIT) || ($type == ST_BANKPAYMENT)) && ($stateformat == null))
                    list($reference, $date, $memo, $amt, $code_id, $taxtype, $dim1_ref, $dim2_ref, $person_type_id, $person_id, $BranchNo) = $data;{
                      
                      if($dim1_ref!='' && $dim1_ref!=null){
                      $dim_val = get_dimension_id($dim1_ref, $dim2_ref ,$line);
   //                display_error($dim_val);              
                      $val=explode('-',$dim_val);
                      if($val[0]!=0)
                       $dim1_ref=$val[0];
                    
                    if($val[1]!=0)
                       $dim2_ref=$val[1];
                      
                       
                      
                    }



                    }

                //str_replace('"', "", $memo);
                //str_replace('"', "", $person_id);
                if (($type == ST_SALESORDER) || ($type == ST_SALESINVOICE)) {

                    list($customer_id,$branchNo, $reference, $date, $payment_id, $sales_type_name, $dimension_id, $dimension2_id, $item_code, $item_description, $quantity, $unit, $price, $discountpercentage, $freightcost, $delfrom, $deldate, $delto, $deladdress, $contactphone, $email, $custref, $shipvia, $comments, $exrate) = $data;
                  
           //-------------- this is check paymint term in words/name;--------------------------------  
            
            //---------------------------------------------------------------------------------------

            if((isset($dimension_id) && $dimension_id!=null && $dimension_id!='-') || (isset($dimension2_id) && $dimension2_id!=null && $dimension2_id!='-') )
               {     
   

                      $dim_val = get_dimension_id($dimension_id, $dimension2_id ,$line);
   //                display_error($dim_val);              
                     
                      $val=explode('-',$dim_val);
                      if($val[0]!=0)
                    $dimension_id=$val[0];
                       
                      if($val[1]!=0)
                    $dimension2_id=$val[1];
                      
                     
   
               
               }      
   


     // ---------------------------this is check for paymint term in words---------------------------------------
                   $temp=$payment_id;
                   $payment_id = get_paymint_term($payment_id);
                    if($payment_id == -1)
                    {

                    display_error(_("$line does not have a payment term (".$temp.") (line $line in import file '{$_FILES['imp']['name']}')"));
                    unset($temp);
                    $error = true;
                   }
                    display_notification_centered(_("Processing line $line ($customer_id, $branchNo, $reference, $date, $payment_id, $sales_type_name, $dimension_id, $dimension2_id, $item_code, $item_description, $quantity, $unit, $price, $discountpercentage, $freightcost, $delfrom, $deldate, $delto, $deladdress, $contactphone, $email, $custref, $shipvia, $comments, $exrate) in import file '{$_FILES['imp']['name']}')"));
                    

//------------------------------- check custunmer name or numaric custumaer_id----------------------------------
                    if(is_numeric($customer_id)){

                                         if (!customer_exist($customer_id)) {
                                         display_notification("Customer does not exist in the database");
                                         $error = true;
                                                 }
                          }
                    
                    else{
                                  $val = customer_exist_name($customer_id,$branchNo,$line);
                                  $val=explode("-", $val);
                             if($val[0]!=0 && $val[1]!=0)  
                                  {
                                      $customer_id=$val[0];
                                      $branchNo=$val[1];
                                       // display_error($customer_id."===".$branchNo);

                                  }
                        }

                    //}
           if(isset($shipvia) && $shipvia!=null && $shipvia!='-')

                {                    
                     
                     $shipvia=get_ship_id($shipvia);
                     if($shipvia == -1 )
                    display_error(_("$line does not exist shipvia (".$id.") (line $line in import file '{$_FILES['imp']['name']}')"));   
                }    

                    if (($prev_ref <> $reference)) // reference has changed so new invoice with new lineitem(s)
                    {
                        if ($firstlinecopied == true) // if the reference has changed for line items write the preference reference based document to the cart
                        {
                            $_SESSION['Items']->write(0); //reset the cart for the next set of line items for each reference document.
                            $_SESSION['Items']->clear_items();
                            unset($_SESSION['Items']->line_items);
                            unset($_SESSION['Items']);
                            $firstlinecopied = false;
                        }
                        $docline = 1; //the reference has changed so this will be the first line item.
                        $doc_num++;
                        $_SESSION['Items'] = new import_sales_cart($type, 0, false);
                        $_SESSION['Items']->document_date = $date;
                        $_SESSION['Items']->order_no = $reference; //order_no is the source document's original
                        $com = get_customer_details_to_order($_SESSION['Items'], $customer_id, $branchNo);
                        display_notification_centered($com);
                        if ($com <> "") {
                            display_notification_centered("Error");
                            $error = true;
                        }

                   

                        copy_to_cart($customer_id, $branchNo, $sales_type_name, $reference, $date, $payment_id, $dimension_id, $dimension2_id, $freightcost = 0, $delfrom, $deldate, $delto, $deladdress, $contactphone, $email, $custref, $shipvia, $comments, $exrate = null);
                        $firstlinecopied = true;
                    }
                    if ($prev_ref == $reference) {
                        $docline = $docline + 1;
                        $com = get_customer_details_to_order($_SESSION['Items'], $customer_id, $branchNo);
                        display_notification_centered($com);
                        if ($com <> "") {
                            display_notification_centered("Error");
                            $error = true;
                        }

                        copy_to_cart($customer_id, $branchNo, $sales_type_name, $reference, $date, $payment_id, $dimension_id, $dimension2_id, $freightcost = 0, $delfrom, $deldate, $delto, $deladdress, $contactphone, $email, $custref, $shipvia, $comments, $exrate = null);
                    }
                    import_add_to_order($_SESSION['Items'], $item_code, $quantity, $price, $discountpercentage, $item_description);
                    $_SESSION['Items']->cust_ref = $reference;
                        
                    // display_error($line." = ". $customer_id." = ". $branchNo." = ". $reference." = ". $date." = ". $dimension_id." = ". $dimension2_id." = ". $freightcost ." = ". $delfrom." = ". $deldate." = ". $delto." = ". $deladdress." = ". $contactphone." = ". $email." = ". $custref." = ". $shipvia." = ". $comments." = ". $exrate,$type);
                    // exit(); 
                    if ((!check_import_item_data($line_no = $docline, $item_code, $item_description, $quantity, $unit, $price, $discountpercentage)) ||
                        (!can_process($line, $customer_id, $branchNo, $reference, $date, $dimension_id, $dimension2_id, $freightcost = 0, $delfrom, $deldate, $delto, $deladdress, $contactphone, $email, $custref, $shipvia, $comments, $exrate,$type))) {
                        display_notification_centered("Error");
                        $error = true;
                    }
                }
                if (($prev_ref <> $reference) && ($type < 4)) {
                    init_entry_part_2($entry, $date, $reference);
                }
                if (($type == ST_BANKDEPOSIT) || ($type == ST_BANKPAYMENT) || ($type == ST_JOURNAL)) {
                    list($error, $memo) = check_customer_supplier($code_id, $person_id, $person_type_id, $line, $memo, $error);
                    if (check_code_id($code_id)) {
                    } else {
                        display_notification_centered("Error: Account code $code_id does not exist");
                        $error = true;
                    }
                    $dim1 = get_dimension_id_from_dimref($dim1_ref);
                    if ($dim1_ref != '' && $dim1 == null) {
                        display_error(_("Error: Could not find dimension with dimension reference '$dim1_ref' (line $line in import file '{$_FILES['imp']['name']}')"));
                        $error = true;
                    }
                    $dim2 = get_dimension_id_from_dimref($dim2_ref);
                    if ($dim2_ref != '' && $dim2 == null) {
                        display_error(_("Error: Could not find dimension with dimension reference '$dim2_ref' (line $line in import file '{$_FILES['imp']['name']}')"));
                        $error = true;
                    }
                }

                    
   //                  $dim_val = get_dimension_id($dimension_id, $dimension2_id ,$line);
   // //                display_error($dim_val);              
   //                    $val=explode('-',$dim_val);
   //                    if($val[0]!=0)
   //                    {
   //                      $dimension_id=$val[0];
                       
   //                     if($val[0]!=0)
   //                      $dimension2_id=$val[1];
   //                    }

                           //  }
                      

               

                if ($reference == '') {
                    display_error(_("$line does not have a reference. (line $line in import file '{$_FILES['imp']['name']}')"));
                    $error = true;
                }
                if ((!$Refs->is_new_reference($reference, $type)) && ($reference != $prev_ref)) {
                    display_error(_("Error: Reference from table 'refs': '$reference' is already in use. (line $line in import file '{$_FILES['imp']['name']}')"));
                    $error = true;
                } elseif ((!$Refs->is_new_reference($reference, $type)) && ($reference == $prev_ref)) { //do nothing $Refs->save($type,$line,$reference);

                } elseif (((!$Refs->is_new_reference($reference, $type)) == null) && ($reference != $prev_ref)) {
                 // display_error( $curEntryId[$type]);
                   //$Refs->save($type, $curEntryId[$type], $reference);
                    //save_next_reference($type, $reference);
                }
                if (($type == ST_BANKDEPOSIT) || ($type == ST_BANKPAYMENT) || ($type == ST_JOURNAL)) {
                    $description = get_gl_account_name($code_id);
                }
                //$date = date('Y-m-d',strtotime($date));
                // display_error( $date." = ".$date );
                // exit();
                if (is_date($date) == false) {
                    display_error(_("Error: date '$date' not properly formatted (line $line in import file '{$_FILES['imp']['name']}')"));
                    $error = true;
                }
                display_notification_centered($line . ":" . $bank_account_gl_code);
                //$date = sql2date($date);
                if ((is_date_in_fiscalyear($date)) == false) {
                    display_error(_("Error: Date not within company fiscal year. Make sure date is in dd/mm/yyyy format and your csv years are 4 digits long. Check that current fiscal year is active under Setup..Company Setup"));
                    $error = true;
                }

                // validation for
                if (($type == ST_BANKDEPOSIT) || ($type == ST_BANKPAYMENT) || ($type == ST_JOURNAL)) {
                    $i = journal_display($i, $type, $taxtype, $amt, $entry, $code_id, $dim1, $dim2, $memo, $description, $bank_account_gl_code, $bank_desc);
                }
                if (!$error) {
                    if (($type == ST_JOURNAL)) {
                        if ($bank_account !== false)
                            journal_bank_trans($type, $reference, $date, $bank_account, $bank_account_gl_code, $line, $curEntryId[$type], $dim1, $dim2, $memo, $amt, $taxtype, $person_type_id, $person_id, $BranchNo, $comments, $prev_ref != $reference);
                        else {
                            if (check_tax_appropriate($code_id, $taxtype, $line) == true) {
                                journal_inclusive_tax($type, $reference, $date, $line, $curEntryId[$type], $code_id, $dim1, $dim2, $memo, $amt, $taxtype, $person_type_id, $person_id);
                            }
                        }
                        add_audit_trail($type, $curEntryId[$type], $date);
                    } elseif (($type == ST_BANKDEPOSIT || $type == ST_BANKPAYMENT) && ($amt > 0)) {
                        if (check_tax_appropriate($code_id, $taxtype, $line) == true) {
                          $curEntryId[$type] = get_next_trans_no($type);
                            bank_inclusive_tax($type, $reference, $date, $bank_account, $bank_account_gl_code, $line, $curEntryId[$type], $code_id, $dim1, $dim2, $memo, ($type == ST_BANKDEPOSIT ? $amt : -$amt), $taxtype, $person_type_id, $person_id, $BranchNo);
                        } else {
                            display_notification_centered(_("Warning: Taxtype used with Asset or Liability - $curEntryId[$type], $date, $code_id.(line $line in import file '{$_FILES['imp']['name']}')"));
                        }
                    } elseif (($type == ST_BANKDEPOSIT || $type == ST_BANKPAYMENT) && ($amt < 0)) {
                        display_notification_centered(_("Error: Credit amounts represented by negative amounts being entered. Check csv file is correct.(line $line in import file '{$_FILES['imp']['name']}')"));
                        $error = true;
                    }
                    $entryCount = $entryCount + 1;
                }
              
                if ($error) {
                    $errCnt = $errCnt + 1;
                }
                $error = false;
                $prev_ref = $reference;
                $prev_date = $date;
            } //while

            if (($type == ST_BANKDEPOSIT) || ($type == ST_BANKPAYMENT) || ($type == ST_JOURNAL)) {
                $displayed_at_least_once = display_entries($type, $entry);
                end_row();
                end_table(1);
                div_end();
                if ($displayed_at_least_once == false) //there has been no occurrence of debits equalling credits - at least one journal not properly balanced
                {
                    display_notification_centered(_("Error: Debits do not equal credits."));
                    $errCnt = $errCnt + 1;
                }
            }

            if (($type == ST_SALESORDER) || ($type == ST_SALESINVOICE)) {
                if (($firstlinecopied == true) && ($prev_ref == $reference)) //for the last line item in a csv
                {
                    $_SESSION['Items']->write(0);
                    $_SESSION['Items']->clear_items();
                    unset($_SESSION['Items']->line_items);
                    unset($_SESSION['Items']);
                    $firstlinecopied = false;
                }
            }
            // Commit import to database

            if ($type == ST_JOURNAL) {
                $typeString = "General Journals";
            } elseif ($type == ST_BANKDEPOSIT) {
                $typeString = "Deposits";
            } elseif ($type == ST_BANKPAYMENT) {
                $typeString = "Payments";
            } elseif ($type == ST_SALESORDER) {
                $typeString = "Sales Order csv lines / $doc_num order(s)";
            } elseif ($type == ST_SALESINVOICE) {
                $typeString = "Sales Invoices csv lines / $doc_num invoice(s)";
            }

            if (!$trial) {
                if ($errCnt == 0) {
                    if ($entryCount > 0) {
                        commit_transaction();
                        display_notification_centered(_("$entryCount $typeString have been imported."));
                    } else display_error(_("Import file contained no $typeString."));
                }
            } else {
                if ($errCnt == 0) {
                    if ($entryCount > 0) display_notification_centered(_("$entryCount $typeString would have been successful if imported. Uncheck Trial check before importing."));
                    else display_notification_centered(_("Import file contained no $typeString. Populate file with data before importing."));
                }
                if (($errCnt > 0) && $displayed_at_least_once) display_notification_centered(_("$errCnt error(s) detected. Correct before importing."));
            }
            $errCnt = 0;

        } // if (!$fp)

    } // if (isset($_FILES['imp']) && $_FILES['imp']['name'] != '')
    @fclose($fp);
} // if (isset($_POST['type']))

// User Interface
start_form(true);
div_start('_main_table');
initialize_controls();
start_table(TABLESTYLE2, "width = 95%"); //inner table
$type = show_table_section_import_settings();
if (($type == ST_JOURNAL) || ($type == ST_BANKDEPOSIT) || ($type == ST_BANKPAYMENT)) {
    show_table_section_control_accounts();
}
show_table_section_display($type);
if ((($type == ST_BANKDEPOSIT) || ($type == ST_BANKPAYMENT))) {
    $stateformat = show_table_section_bankstatement_checkbox();
}
show_table_section_csv_separator();
show_table_section_trial_or_final();
end_table(1);
div_end('_main_table');
//submit_center('import', "Process",$echo=true, $title=false, $async=true, $icon=ICON_OK);
// Note: $async='process' is magic for a longer timeout
submit_center('import', "Process", true, false, 'process', ICON_OK);
end_form();
echo '</br>';
end_page();
?>
