<?php

function add_bank($bank,$remarks,$routingcode)
{

	if( check_routing_bank($routingcode,$bank)){

		
		display_error('Routing Code Can Not Be Same');
	}
	else{



	$sql = "INSERT INTO ".TB_PREF."payroll_bank (bank,remarks,routingcode) VALUES (".db_escape($bank).",".db_escape($remarks).",".db_escape($routingcode).")";
   	db_query($sql,"The bank could not be added");
if ($sql != null)
add_audit_trail(ST_PAYROLL_BANK, db_insert_id(), date('d/m/Y'), "Insert");

	}

}

function update_bank($selected_id, $bank,$remarks,$routingcode)
{


	if(check_routing_bank($routingcode,$bank)){

		display_error('Cannot update this routing code because branches dont have same routing code');
	}
	
	else{
	
	$sql = "UPDATE ".TB_PREF."payroll_bank SET bank=".db_escape($bank).",remarks=".db_escape($remarks).",routingcode=".db_escape($routingcode)." WHERE id = ".db_escape($selected_id);
   	db_query($sql,"The bank could not be updated");
	if ($sql != null)
	add_audit_trail(ST_PAYROLL_BANK,$selected_id, date('d/m/Y'), "Insert");

	}
	
}



function delete_bank($selected_id)
{
	$sql="UPDATE ".TB_PREF."payroll_bank SET deleted = 1 WHERE id=".db_escape($selected_id);
	db_query($sql,"could not delete bank");
if ($sql != null)
add_audit_trail(ST_PAYROLL_BANK,$selected_id, date('d/m/Y'), "Delete");

}

function get_banks($show_inactive)
{

	$sql = "SELECT * FROM ".TB_PREF."payroll_bank where deleted = 0";
	if (!$show_inactive) $sql .= " AND !inactive";
	$sql .= " ORDER BY bank ASC";
	return db_query($sql,"could not get bank");
}
function check_bank_db($bank){
 $sql = "SELECT * FROM ".TB_PREF."payroll_bank WHERE deleted = 0 AND UPPER(bank)='$bank'";
	$result = db_query($sql,"could not get bank");
	return db_num_rows($result);
}
function check_bank_id($bank){
 $sql = "SELECT id FROM ".TB_PREF."payroll_bank WHERE deleted = 0 AND UPPER(bank)='$bank'";
	$result = db_query($sql,"could not get bank");
	return db_fetch($result);
}
function get_bank($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."payroll_bank WHERE deleted = 0 AND id=".db_escape($selected_id);
	$result = db_query($sql,"could not get bank");
	return db_fetch($result);
}

function check_routing_bank($routingcode,$bank){

	$sql = "SELECT * FROM ".TB_PREF."payroll_bank WHERE bank = ".db_escape($bank)." AND routingcode = ".db_escape($routingcode)." AND deleted != 1";

	$run = db_query($sql,'');
	$result = db_fetch($run);
	return $result;
	

}



?>