<?php

function check_payslip($emp_id, $month, $year){

$sql = "SELECT * FROM ".TB_PREF."payroll_payslip WHERE deleted = 0 and eid = ".db_escape($emp_id)." AND month = '$month' AND year = '$year'  AND unprocess = 0";

$trans = db_query($sql,"no data return");

return db_num_rows($trans);
}
function check_payslip_data($emp_id, $month, $year){

$sql = "SELECT *,COUNT(*) as count_payslip FROM ".TB_PREF."payroll_payslip WHERE deleted = 0 and employee_id = ".db_escape($emp_id)." AND month = '$month' AND year = '$year'  AND unprocess = 0";

$trans = db_query($sql,"no data return");
return db_fetch($trans);
}

function get_processed_payslip($emp_id,$month,$year=null){
$month = $month;
$sql= "SELECT emp.id
FROM ".TB_PREF."payroll_employee AS emp
WHERE  emp.deleted = 0 AND emp.employee_id = ".db_escape($emp_id)."";
$result = db_query($sql, "no return");

while($row = db_fetch($result)){
$id = $row['id'];

$status = check_payslip($id, $month, $year);

if($status > 0){
$payslip = 'Processed';
}
else if($status == 0){
$payslip = 'Not Processed';
}

return $payslip;
}
}

function allowance_amount($employee_id, $allowance_id){
	// $allowance_id=array();

if ($allowance_id !="") {
	# code...
$ids = join("','",$allowance_id); 
}
else
{
	$ids=0;
}

$sql = " SELECT SUM(amount) AS amount FROM ".TB_PREF."payroll_allowances_deductions WHERE  deleted = 0 AND employee_id = ".db_escape($employee_id)." AND allow_deduct_id IN ('$ids') AND is_allowances  = 1 ";
$result = db_query($sql ,"no");
$row = db_fetch($result);
return $row["amount"];

}
function get_emp_name($id){
	$sql= "Select * from ".TB_PREF."payroll_transaction as t JOIN ".TB_PREF."payroll_employee as e on e.employee_id=t.eid where t.id='$id'" ;
	
	$row = db_query($sql,"");
	$mysql = db_fetch($row);
	return $mysql;
}
function paid_leave_amount($emp_id,$leave_type){

$sql = "SELECT * FROM ".TB_PREF."payroll_all_ded WHERE deleted = 0 AND role=".(int)$leave_type;
$ret = db_query($sql, "could not retrieve leave formula");
$row = db_fetch($ret);
if ($row != false) {
$row['areas'] = explode(';', $row['areas']);
$row['sections'] = explode(';', $row['sections']);
}
return allowance_amount($emp_id,$row['areas']);

}

function policy_amount($emp_id,$policy_type){

$sql = "SELECT * FROM ".TB_PREF."payroll_all_ded WHERE deleted = 0 AND type = 1 AND role=".(int)$policy_type;
$ret = db_query($sql, "could not retrieve leave formula");
$row = db_fetch($ret);
if ($row != false) {
$row['areas'] = explode(';', $row['areas']);
$row['sections'] = explode(';', $row['sections']);
}
return allowance_amount($emp_id,$row['areas']);

}


function check_month($month, $year){

$sql = "SELECT * FROM ".TB_PREF."payroll_payslip WHERE deleted = 0 and month = '$month' AND year = '$year' ";
$trans = db_query($sql,"no data return");
return db_num_rows($trans);
}



/////////////////////////////////////////////////////////
// INSERT PROCESS PAYSLIP 
////////////////////////////////////////////////////////

function add_process_payslip($eid,$basicsalary,$overtime_salary,$month,$year,$otfactor,$workinghrs,$weekend,$totalamount,$overtime_method){

$sql = " INSERT INTO ".TB_PREF."payroll_payslip (eid,basicsalary,overtime_salary,month,year,otfactor,workinghrs,weekend,trans_type,totalamount,allocate,unprocess,overtime_method) VALUES (".db_escape($eid).",".db_escape($basicsalary).",".db_escape($overtime_salary).",".db_escape($month).",".db_escape($year).",".db_escape($otfactor).",".db_escape($workinghrs).",".db_escape($weekend).",'PAYSLIP',".db_escape($totalamount).",".db_escape($totalamount).",0,".db_escape($overtime_method).") ";
db_query($sql, "no data is insert");
$id = mysql_insert_id();
updateloanwhenProcessed($eid,$month,$year,$id);
if ($sql != null)
add_audit_trail(130, $id, date(), "Insert");  
}

function process_allowances_deduction($eid,$payslip_id,$allowance_deduction_id,$is_allowances,$amount,$month,$year){

$sql = " INSERT INTO ".TB_PREF."payslip_all_ded (eid,payslip_id,all_ded,is_allowances,amount,month,year,unprocess) VALUES (".db_escape($eid).",".db_escape($payslip_id).",".db_escape($allowance_deduction_id).",".db_escape($is_allowances).",".db_escape($amount).",".db_escape($month).",".db_escape($year).",0) ";
db_query($sql,"no data in insert");
if ($sql != null)
add_audit_trail(131, mysql_insert_id(), date(), "Insert");  
}
///////////////////////////////////////////////////////




function check_normal_days($total_paid_days, $total_unpaid_days, $normal_days,$d_daysinmonth){
if(($total_paid_days == $d_daysinmonth) || ($total_unpaid_days == $d_daysinmonth)){
$normaldays = 0;
return $normaldays; 
}
else if(($total_paid_days != $d_daysinmonth) || ($total_unpaid_days != $d_daysinmonth)){
$normaldays = $normal_days;
return $normaldays; 
}
else{
return $normal_days;
}
}
function get_month_weekend_holiday($month,$year,$emp_id){
//echo $month;
$last = date2sql(get_current_month_cut_off($month,$year));
// for last cut off it would be one month before
$lyear = $year;
$lmonth = $month -1;
if($lmonth == 0)
{
$lmonth = 12;
$lyear = $year - 1;
}

$first = date2sql(get_last_month_cut_off($lmonth,$lyear));
$chk = get_days_month_forjoindate($month,$year,$emp_id);
if($chk > 0)
	$first = $chk[1];
// echo $last;
// echo $first;
$month_weekend = month_checkweekend($first,$last,$emp_id);
$month_holiday = checkholiday($first,$last);
$total = $month_weekend + $month_holiday;
return $total;
}

function get_month_weekend_holiday_forPayslip($month,$year,$emp_id){
//echo $month;

//$last = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));
$first = date2sql(get_current_month_cut_off($month,$year));
$last  = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));
$month_weekend = month_checkweekend($last,$first,$emp_id);
$month_holiday = checkholiday($last,$first);
$total = $month_weekend + $month_holiday;
return $total;
}


function get_month_weekend_holiday_forProcessedPayslip($month,$year,$emp_id){
//echo $month;
//$last = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));
$first = date2sql(get_current_month_cut_off($month,$year));
$last  = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));

$month_holiday = checkholiday($last,$first,$emp_id);
$total = $month_weekend + $month_holiday;
return $total;
}

function get_month_weekend_forPayslip($month,$year,$emp_id){

//$last = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));
$first = date2sql(get_current_month_cut_off($month,$year));
$last  = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));
$month_weekend = month_checkweekend($last,$first,$emp_id);
$total = $month_weekend;
return $total;
}

function get_month_weekend($month,$year,$emp_id){

$first = date2sql(get_current_month_cut_off($month,$year));
$last  = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));

$month_weekend = month_checkweekend($first,$last,$emp_id);
$total = $month_weekend;
return $total;
}

function get_total_present_day($emp_id ,$month,$year){

$first = date2sql(get_current_month_cut_off($month,$year));
// for last cut off it would be one month before
$lyear = $year;
$lmonth = $month -1;
if($lmonth == 0)
{
$lmonth = 12;
$lyear = $year - 1;
}

$last = date2sql(get_last_month_cut_off($lmonth,$lyear));


$sql1 = "SELECT * FROM ".TB_PREF."payroll_weekend WHERE deleted = 0 and off = 1";
$res = db_query($sql1);
$row = db_fetch($res);

if($row['attendance'] == 1)
{
$sql = "SELECT * FROM `".TB_PREF."payroll_transaction` WHERE deleted = 0 and eid = '$emp_id' AND att_ot_date > '$last' AND att_ot_date <= '$first' AND doc_type = '107' AND over_time = 0 GROUP BY att_ot_date";
$result =db_query($sql , "no data returned");
$myrow = db_num_rows($result);
return $myrow;
}
else
{
$sql = "SELECT * FROM `".TB_PREF."payroll_transaction` WHERE deleted = 0 and eid = '$emp_id' AND att_ot_date > '$last' AND att_ot_date <= '$first' AND doc_type = '107' AND over_time = 0 AND hrs_method = '0' GROUP BY att_ot_date";
$result =db_query($sql , "no data returned");
$myrow = db_num_rows($result);
return $myrow;
}



$sql = "SELECT * FROM `".TB_PREF."payroll_transaction` WHERE deleted = 0 and eid = '$emp_id' AND att_ot_date > '$last' AND att_ot_date <= '$first' AND doc_type = '107' AND over_time = 0 AND hrs_method = '0' GROUP BY att_ot_date";
$result =db_query($sql , "no data returned");
$myrow = db_num_rows($result);
return $myrow;
}

function get_total_present_day_forPayslip($emp_id ,$month,$year){

//$last = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));
$first = date2sql(get_current_month_cut_off($month,$year));
$last  = date('Y-m-d', mktime(0, 0, 0, $month, 1, $year));

$sql1 = "SELECT * FROM ".TB_PREF."payroll_weekend where off = 1";
$res = db_query($sql1);
$row = db_fetch($res);

if($row['attendance'] == 1)
{
$sql = "SELECT * FROM `".TB_PREF."payroll_transaction` WHERE deleted = 0 and eid = ".db_escape($emp_id)." AND att_ot_date >= '$last' AND att_ot_date <= '$first' AND doc_type = '107' AND over_time = 0 GROUP BY att_ot_date";
$result =db_query($sql , "no data returned");
$myrow = db_num_rows($result);
return $myrow;
}
else
{
$sql = "SELECT * FROM `".TB_PREF."payroll_transaction` WHERE deleted = 0 and eid = ".db_escape($emp_id)." AND att_ot_date >= '$last' AND att_ot_date <= '$first' AND doc_type = '107' AND over_time = 0 AND hrs_method=0 GROUP BY att_ot_date";
$result =db_query($sql , "no data returned");
$myrow = db_num_rows($result);
return $myrow;
}

}


function get_employee_info($emp_id){

$sql = " SELECT * FROM ".TB_PREF."payroll_employee WHERE ".TB_PREF."payroll_employee.deleted = 0 AND employee_id = ".db_escape($emp_id)."";


$result = db_query($sql, "no return");
$myrow = db_fetch($result);

$trans = array(

0 => sql2date($myrow['join_date']),
1 => $myrow['basic_salary'],
2 => $myrow['type_of_contract'],
3 => $myrow['first_name'],
4 => $myrow['last_name'],
5 => $myrow['working_hrs'],
6 => $myrow['overtime_method'],
7 => $myrow['overtime'],        
8 => $myrow['employee_id'],       
9 => sql2date($myrow['leavingdate']),  
);
//print_r($trans);
return $trans;

}

function getEID($trans_id)
{
$sql = " SELECT eid FROM ".TB_PREF."payroll_transaction  WHERE deleted = 0 and id = '$trans_id'";
$result = db_query($sql, "no return");
$myrow = db_fetch($result);
return $myrow['eid'];
}

function getattndate($trans_id)
{
$sql = " SELECT att_ot_date FROM ".TB_PREF."payroll_transaction  WHERE deleted = 0 and id = '$trans_id'";
$result = db_query($sql, "no return");
$myrow = db_fetch($result);
return $myrow['att_ot_date']; 
}
//*****************************************
// NOT PROCESS FUNCTION 
//*****************************************
// CHECK  AND GET NOT PROCESS DEDUCTIONS AND SUM OF NOT PROCESS DEDUCTIONS

function check_deductions($employee_id){
$sql = "SELECT  COUNT(id)  FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
WHERE   deleted = 0 AND  is_allowances = 2 AND employee_id = ".db_escape($employee_id)." ";
$result = db_query($sql , "no");
$myrow = db_fetch($result);
return $myrow[0];
}


function get_deductions($employee_id){
$sql = "SELECT ded_all.amount , ".TB_PREF."payroll_deductions.* FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
RIGHT JOIN ".TB_PREF."payroll_deductions ON ".TB_PREF."payroll_deductions.id = ded_all.allow_deduct_id AND ".TB_PREF."payroll_deductions.deleted = 0
WHERE  ".TB_PREF."payroll_deductions.deleted = 0 AND is_allowances = 2 AND employee_id = ".db_escape($employee_id)." ";
return db_query($sql,"no returned");
}
function getsum_deductions($employee_id){
$sql = "SELECT  SUM(ded_all.amount) AS amounts FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
WHERE   deleted = 0 AND  is_allowances = 2 AND employee_id = ".db_escape($employee_id)." ";

return db_query($sql , "no");
}
// CHECK  AND GET PROCESS ALLOWANCES AND SUM OF PROCESS ALLOWANCES

function check_allowances($employee_id){
$sql = " SELECT  COUNT(id) FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
WHERE   deleted = 0 AND  is_allowances = 1 AND employee_id = ".db_escape($employee_id)." ";
$trans = db_query($sql,"no returned");
$myrow = db_fetch($trans);
return $myrow[0];
}
function get_allowances_deduction($employee_id){
	$sql = "SELECT ded_all.amount,ded_all.allow_deduct_id,ded_all.is_allowances , ".TB_PREF."payroll_allowances.* 
FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
RIGHT JOIN ".TB_PREF."payroll_allowances 
	ON ".TB_PREF."payroll_allowances.id = ded_all.allow_deduct_id 
    AND ded_all.deleted = 0 

WHERE ".TB_PREF."payroll_allowances.deleted = 0 AND employee_id = ".db_escape($employee_id)."";

return db_query($sql,"no returned");

}
function get_allowances($employee_id){

$sql = "SELECT ded_all.amount,ded_all.allow_deduct_id , ".TB_PREF."payroll_allowances.* 
FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
RIGHT JOIN ".TB_PREF."payroll_allowances 
	ON ".TB_PREF."payroll_allowances.id = ded_all.allow_deduct_id 
    AND ded_all.deleted = 0 

WHERE ".TB_PREF."payroll_allowances.deleted = 0 AND  is_allowances = 1 AND employee_id = ".db_escape($employee_id)."";

return db_query($sql,"no returned");
}
function getsum_allowances($employee_id){
$sql = "SELECT  SUM(ded_all.amount) AS amounts FROM ".TB_PREF."payroll_allowances_deductions  AS ded_all
WHERE   deleted = 0 AND  is_allowances = 1 AND employee_id = ".db_escape($employee_id)."";
return db_query($sql , "no");

}

// CHECK  AND GET NOT PROCESS TEMPORARY DEDUCTIONS AND SUM OF NOT PROCESS DEDUCTIONS

function check_temporarydeductions($employee_id,$month,$year){
$sql = "SELECT  COUNT(id)  FROM ".TB_PREF."payroll_temporary_allowances_deduction  AS ded_all
WHERE ded_all.deleted = 0 and is_allowances = 2 AND employee_id = ".db_escape($employee_id)." AND MONTH(salary_month) = '$month' AND YEAR(salary_month) = '$year' ";
$result = db_query($sql , "no");
$myrow = db_fetch($result);
return $myrow[0];
}


function get_temporarydeductions($employee_id,$month,$year){
$sql = "SELECT ded_all.amount ,description FROM ".TB_PREF."payroll_temporary_allowances_deduction  AS ded_all
WHERE ded_all.deleted = 0 and is_allowances = 2 AND employee_id = ".db_escape($employee_id)." AND MONTH(salary_month) = '$month' AND YEAR(salary_month) = '$year' ";
return db_query($sql,"no returned");
}
function getsum_temporarydeductions($employee_id,$month,$year){
$sql = "SELECT  SUM(ded_all.amount) AS amounts FROM ".TB_PREF."payroll_temporary_allowances_deduction AS ded_all
WHERE ded_all.deleted = 0 and is_allowances = 2 AND employee_id = ".db_escape($employee_id)." AND MONTH(salary_month) = '$month' AND YEAR(salary_month) = '$year'  ";
$result = db_query($sql , "no");
$myrow = db_fetch($result);

return $myrow["amounts"];
}
// CHECK  AND GET PROCESS TEMPORARY ALLOWANCES AND SUM OF PROCESS ALLOWANCES

function check_temporaryallowances($employee_id,$month,$year){
$sql = " SELECT  COUNT(id) FROM ".TB_PREF."payroll_temporary_allowances_deduction  AS ded_all
WHERE ded_all.deleted = 0 and is_allowances = 1 AND employee_id = ".db_escape($employee_id)." AND MONTH(salary_month) = '$month' AND YEAR(salary_month) = '$year' ";
$trans = db_query($sql,"no returned");
$myrow = db_fetch($trans);
return $myrow[0];
}

function get_temporaryallowances($employee_id,$month,$year){
$sql = "SELECT ded_all.amount , description FROM ".TB_PREF."payroll_temporary_allowances_deduction  AS ded_all
WHERE ded_all.deleted = 0 and is_allowances = 1 AND employee_id = ".db_escape($employee_id)." AND MONTH(salary_month) = '$month' AND YEAR(salary_month) = '$year' ";
return db_query($sql,"no returned");
}
function getsum_temporaryallowances($employee_id,$month,$year){
$sql = "SELECT  SUM(ded_all.amount) AS amounts FROM ".TB_PREF."payroll_temporary_allowances_deduction  AS ded_all
WHERE ded_all.deleted = 0 and is_allowances = 1 AND employee_id = ".db_escape($employee_id)." AND MONTH(salary_month) = '$month' AND YEAR(salary_month) = '$year' ";
$result = db_query($sql , "no");

$myrow = db_fetch($result);

return $myrow["amounts"];
}
function getbank($bankid){
$sql = "SELECT * FROM ".TB_PREF."payroll_bank where deleted = 0 AND id = '$bankid'";
$result = db_query($sql,"no data returned");
$myrow = db_fetch($result);
return $myrow['bank'];
}

function getdept($dept){
$sql = "SELECT * FROM ".TB_PREF."payroll_department where deleted = 0 AND id = '$dept'";
$result = db_query($sql,"no data returned");
$myrow = db_fetch($result);
return $myrow['department'];
}

function getdesig($desig){
$sql = "SELECT * FROM ".TB_PREF."payroll_designation where deleted = 0 AND id = '$desig'";
$result = db_query($sql,"no data returned");
$myrow = db_fetch($result);
return $myrow['designation'];
}

function get_working_hr($eid){

$sql =  " SELECT * FROM ".TB_PREF."payroll_employee WHERE  deleted = 0 AND employee_id = ".db_escape($eid)." ";
$result = db_query($sql,"no"); 
$myrow = db_fetch($result);

return $myrow["working_hrs"];
}

function get_basic_salary($id){
$sql = "SELECT pay.* FROM ".TB_PREF."payroll_employee AS pay
WHERE pay.deleted = 0 AND employee_id =  ".db_escape($id)." ";
$result = db_query($sql , "no result");
$row = db_fetch($result);

return $row["basic_salary"];
}

function get_overtime_salary($id){
$sql = "SELECT pay.* 
       FROM ".TB_PREF."payroll_employee AS pay
        WHERE employee_id =  ".db_escape($id)." ";
 $result = db_query($sql , "no result");
 $row = db_fetch($result);
  return $row["overtime_salary"];
}


function get_last_month_cut_off($month,$year){
$sql = " SELECT cutoffdate FROM ".TB_PREF."payroll_cutoffdate WHERE deleted = 0 AND month = '$month' AND fiscalyear = '$year' "; 
$trans = db_query($sql , 'cannot get cutoffdate');
$num = db_num_rows($trans);
if($num == 0)
{

return sql2date(date('Y-m-d', mktime(0,0,0, $month+1,0,$year)));
}

else
{
$row = db_fetch($trans);

return sql2date($row['cutoffdate']);  
}
}
function get_current_month_cut_off($month,$year){
$sql = " SELECT cutoffdate FROM ".TB_PREF."payroll_cutoffdate WHERE deleted = 0 AND month = '$month' AND fiscalyear = '$year' "; 
$trans = db_query($sql , 'cannot get cutoffdate');
$num = db_num_rows($trans);
if($num == 0)
{
return sql2date(date('Y-m-d', mktime(0, 0, 0, $month+1, 0, $year)));
}
else
{
$row = db_fetch($trans);

return sql2date($row['cutoffdate']);
}
}

function checkholiday($last_cut_off,$current_cut_off){
	$holidays_weekend=0;
$start_date = $last_cut_off;
$end_date = $current_cut_off;
$sql = "SELECT * FROM ".TB_PREF."payroll_holidays WHERE deleted = 0 and date >= '$start_date' AND date <= '$end_date' ";
$result = db_query($sql, "employee query not working");
while($row = db_fetch($result)){
$holiday_weekend = holiday_checkweekend($row['date']);
$holidays_weekend +=  $holiday_weekend;
}
$trans = db_query($sql, "employee query not working");
$total_holidays = db_num_rows($trans) - $holidays_weekend;
return $total_holidays;
}
function holiday_checkweekend($holiday_date){

$start_date = $holiday_date;
$count = 0;
$timestamp = strtotime($start_date);
$day = date('N',  $timestamp);
$sql = "SELECT id FROM ".TB_PREF."payroll_weekend WHERE off = '1' ";
$result = db_query( $sql ,"no");
while( $row = db_fetch($result)){
if ($day == $row['id'])
$count++;
}

$weekend = $count;
return $weekend;

}
function check_allow_normalAtt_onwk($day)
{
$day_of_week = date('N', strtotime($day));
$sql = "SELECT * FROM `0_payroll_weekend` WHERE deleted = 0 and id = '$day_of_week' and attendance = '1'";
$res = db_query($sql,'no record');
if(db_num_rows($res) > 0)
return 1;
else
return 0;
}
function get_attendance1($emp_id,$start_date,$end_date)
{
$sql  = "SELECT att_ot_date FROM `0_payroll_transaction` WHERE deleted = 0 and eid = '$emp_id' AND att_ot_date > '$start_date' AND att_ot_date <= '$end_date' AND doc_type = '107' AND over_time = '0' GROUP BY att_ot_date";


return db_query($sql,'no record'); 
}

function get_weekend_dates($start_date,$end_date,$day)
{
	$wk_dates=array();
for ($i = strtotime($start_date); $i <= strtotime($end_date); $i = strtotime('+1 day', $i)) {
if (date('N', $i) == $day)
{
$weekend_date = date('Y-m-d', $i); //prints the date only if it's a Monday
$wk_dates[] = $weekend_date;
}
}
return $wk_dates;
}

function month_checkweekend($last_cut_off,$current_cut_off,$emp_id=null){

$arr=array();
$month=0;
$id=array();
$start_date = $last_cut_off;
$end_date = $current_cut_off;
$mon = date('m',strtotime($start_date));
$yr = date('Y',strtotime($start_date));
$count = 0;
$count1 = 0;
$j = 0;
$res = get_attendance1($emp_id,$start_date,$end_date);




while($row1 =db_fetch($res)){
$arr[] = $row1[0];

}
$ct = date2sql(get_current_month_cut_off($mon,$yr));
// $chk = get_days_month_forjoindate($month,$year,$emp_id);

// if($chk > 0)
// 	$ct = $chk[1];

if(strtotime($ct) == strtotime($start_date)){
	$start_date = date ("Y-m-d", strtotime("+1 days", strtotime($start_date)));
}


while (strtotime($start_date) <= strtotime($end_date)) {
$timestamp = strtotime($start_date);
$day = date('N',  $timestamp);
$sql = "SELECT id FROM ".TB_PREF."payroll_weekend WHERE deleted = 0 and off = '1' ";
$result = db_query( $sql ,"no");

while( $row = db_fetch($result)){
$id[] = $row['id'];
if ($day == $row['id'])
$count++;
}

$start_date = date ("Y-m-d", strtotime("+1 days", strtotime($start_date)));
}

$id = array_unique($id);
foreach ($id as $value) {
$wk_dates = get_weekend_dates($last_cut_off,$current_cut_off,$value);


foreach ($wk_dates as $value1) {
if(check_allow_normalAtt_onwk($value1) == 1)
{

$count1 = count(array_intersect($arr, $wk_dates));
}   
}

}

$weekend = $count;
$weekend = $weekend - $count1 ;
return $weekend;

}
function checkweekend($last_cut_off,$current_cut_off){

$start_date = date2sql($last_cut_off);
$end_date = date2sql($current_cut_off);
$count = 0;
$start_date = date ("Y-m-d", strtotime("+1 days", strtotime($start_date)));
while (strtotime($start_date) < strtotime($end_date)) {
$timestamp = strtotime($start_date);
$day = date('N',  $timestamp);
$sql = "SELECT id FROM ".TB_PREF."payroll_weekend WHERE deleted = 0 and off = '1' ";
$result = db_query( $sql ,"no");
while( $row = db_fetch($result)){
if ($day == $row['id'])
$count++;
}
/*for($i = 0; $i <= mysql_fetch_row($result); $i++){
if ($day == $row['id'])
$count++;
}*/


$start_date = date ("Y-m-d", strtotime("+1 days", strtotime($start_date)));
}

$weekend = $count;
return $weekend;

}

function getsum($emp_id, $fcdate,$lcdate)
{

$sql = "SELECT SUM(hrs) as hrs FROM ".TB_PREF."payroll_transaction WHERE deleted = 0 and over_time = 1 AND `eid` = '$emp_id' AND att_ot_date > '$lcdate' AND att_ot_date <= '$fcdate' AND doc_type = '107'";

$result = db_query($sql,"No employee were returned");
$myrow = db_fetch($result);
return $myrow["hrs"];

}

function otfac(){

$sql = "SELECT factor FROM ".TB_PREF."0_factor WHERE deleted = 0";
$result = db_query($sql, "employee query not working");
$row = db_fetch_row($result);
return $row[0];
}

function calculate_leave_days($emp_id,$a,$b, $month, $year, $type){

$sql = "SELECT pt.*, tl.* FROM ".TB_PREF."payroll_transaction AS pt
INNER JOIN ".TB_PREF."payroll_types_leave AS tl ON tl.id = pt.leave_type AND tl.status = '$type'
WHERE pt.deleted = 0 and eid = ".db_escape($emp_id)." AND approved = '1'";
// display_error($sql);
 return db_query($sql,"no leave returned");

}
function calculate_leave_days_lastmonthded($emp_id,$a,$b, $month, $year, $type){

$sql = "SELECT pt.*, tl.* FROM ".TB_PREF."payroll_transaction AS pt
INNER JOIN ".TB_PREF."payroll_types_leave AS tl ON tl.id = pt.leave_type AND tl.status = '$type'
AND pt.deleted = 0 and tl.preplannedleaves = 0 WHERE eid = '$emp_id' AND approved = '1'";
return db_query($sql,"no leave returned");
}


function get_PL_forLeave($emp_id,$month, $year, $type,$leaveid=null){

$sql = "SELECT pt.*, tl.* FROM ".TB_PREF."payroll_transaction AS pt
INNER JOIN ".TB_PREF."payroll_types_leave AS tl ON tl.id = '$leaveid' AND tl.status = '$type'
WHERE pt.deleted = 0 and eid = '$emp_id' AND approved = '1' ";
if($leaveid != null)
$sql .= " AND pt.leave_type = '$leaveid'";

return db_query($sql,"no leave returned");
}

function get_payslip_calculation($eid, $month,$year){
$months = $month;
$current_cut_off = get_current_month_cut_off($month,$year);
if($month == 1){
$month = 12;
$last_year = $year - 1;
$last_cut = date('d/m/Y',mktime (0, 0, 0, $month, 25, $last_year));
$last_cut_off = $last_cut;
}
else {
$months = $month;
$last_cut_off = get_last_month_cut_off($months - 1, $year);
}
$start_date = date2sql($last_cut_off);
//$start_date = date ("Y-m-d", strtotime("+ days", strtotime($start_date)));
$end_date = date2sql($current_cut_off);
$normal_days = cal_days_in_month(CAL_GREGORIAN, $months, $year);
$result  = array(
0 => round($normal_days),
1 => $paid_days,
2 => $unpaid_days
);
return $result;

}


function over_time_calculation($eid,$month,$year)
{

//calculate cut off
$currentcf = get_current_month_cut_off($month,$year);

// for last cut off it would be one month before
$lyear = $year;
$lmonth = $month -1;
if($lmonth == 0)
{
$lmonth = 12;
$lyear = $year - 1;
}

$lastcf = get_last_month_cut_off($lmonth,$lyear);
$working_hrs_per_day = get_working_hr($eid);


$a = (strtotime(date2sql($currentcf)) - strtotime(date2sql($lastcf)))/(60*60*24);
$b = checkweekend($lastcf,$currentcf);
$c = checkholiday(date2sql($lastcf),date2sql($currentcf));

$number_of_days = round(((strtotime(date2sql($currentcf)) - strtotime(date2sql($lastcf)))/(60*60*24)) - checkweekend($lastcf,$currentcf) - checkholiday(date2sql($lastcf),date2sql($currentcf)));
$expected_hrs = $working_hrs_per_day * $number_of_days;
//get employee expected working hour
$basic_salary = get_basic_salary($eid);

//get total working hours from transaction payroll using cut off
$twh = getsum1($eid, date2sql($currentcf),date2sql($lastcf)); // total working hours


$factor = otfac();
$othrs = $twh - $expected_hrs;

$data= getOvertimerecord($eid, $month,$year); // total working hours 

$OT_amount = end($data)['totalOt_amount'];
$OT_per_hr = end($data)['totalOthrs'];

if($OT_amount < 0) //To avoid Negative  OT
$OT_amount = 0;
if($othrs < 0)
$othrs = 0;
$result = array(
0 => $working_hrs_per_day,
1 => $basic_salary , 
2 => $start_date, 
3 => $current_cut_off, 
4 => round($number_of_days), 
5 => $expected_hrs,
6 => $OT_per_hr,
7 => $OT_per_hr,
8 => $OT_amount,
9 => $twh,
10 => $a,
11 => $b,
12 => $c,
13 => $currentcf,
14 => $lastcf,
15 => $number_of_days,
16 => $working_hrs_per_day
);
return $result;
}


function over_time_calculation_approved($eid,$month,$year)
{

//calculate cut off
$currentcf = get_current_month_cut_off($month,$year);
// for last cut off it would be one month before
$lyear = $year;
$lmonth = $month -1;
if($lmonth == 0)
{
$lmonth = 12;
$lyear = $year - 1;
}

$lastcf = get_last_month_cut_off($lmonth,$year);

//get employee expected working hour

$working_hrs_per_day = get_working_hr($eid);
$expected_hrs = $working_hrs_per_day * 30;


$basic_salary = get_basic_salary($eid);

//get total working hours from transaction payroll using cut off

$twh = getsum($eid, date2sql($currentcf),date2sql($lastcf)); // total working hours

$data = getOvertimerecord($eid, $month,$year); // total working hours

$OT_amount = end($data)['totalOt_amount'];
$OT_per_hr = end($data)['totalOthrs'];

// $factor = otfac();
	$days_in_a_year = $_SESSION['SysPrefs']->prefs['days_in_a_year'];
// $number_of_days_fiscal_year = $year ? 366 : $days_in_a_year;
// $OT_per_hr = $basic_salary * $factor * (12/$days_in_a_year) * (1/$working_hrs_per_day);
// $OT_amount= $twh * $OT_per_hr; 
if($OT_amount < 0) //To avoid Negative  OT
$OT_amount = 0;

$result = array(
0 => $working_hrs_per_day,
1 => $basic_salary , 
2 => $start_date, 
3 => $current_cut_off, 
4 => round($number_of_days), 
5 => $expected_hrs,
6 => $twh,
7 => $OT_per_hr,
8 => $OT_amount,
9 => $othrs,
10 => $month_weekend,
11 => $month_holiday
);
return $result;
}



function approved_leave($eid,$month,$type)
{

//$type is for paid leave or unpaid leave required

$fiscal_year = get_current_fiscalyear();
$fiscal_year = strtotime($fiscal_year['begin']);
//$fiscal_year = date("Y-m-d", $fiscal_year);
$year = date("Y" , $fiscal_year);
// for leap year 
if( (0 == $year % 4) and (0 != $year % 100) or (0 == $year % 400) )
{
$feb = 29;
}
else
{
$feb = 28; 
}

$from_date = array (date("Y-01-01", $fiscal_year),date("Y-02-01", $fiscal_year),date("Y-03-01", $fiscal_year),date("Y-04-01", $fiscal_year),date("Y-05-01", $fiscal_year),
date("Y-06-01", $fiscal_year),date("Y-07-01", $fiscal_year),date("Y-08-01", $fiscal_year),date("Y-09-01", $fiscal_year),date("Y-10-01", $fiscal_year),date("Y-11-01", $fiscal_year),date("Y-12-01", $fiscal_year) );

$to_date = array (date("Y-01-t", $fiscal_year) ,date("Y-02-$feb", $fiscal_year),date("Y-03-t", $fiscal_year),date("Y-04-t", $fiscal_year),date("Y-05-t", $fiscal_year),
date("Y-06-t", $fiscal_year),date("Y-07-t", $fiscal_year),date("Y-08-t", $fiscal_year),date("Y-09-t", $fiscal_year),date("Y-10-t", $fiscal_year),date("Y-11-t", $fiscal_year),date("Y-12-t", $fiscal_year) );

//$to_date = date("Y-m-t", $month); //first day of month
//$from_date = date("Y-m-01", $month); // last day of month)
//IF ($month+1 = MONTH(app.from_date)=MONTH(app.to_date),SUM(DATEDIFF(app.to_date,app.from_date),'')
//SUM(DATEDIFF(app.to_date,app.from_date)) 
//  SUM(CASE WHEN credit_debit = 'debit' THEN amount END) AS debit_amount
$sql = "SELECT 
SUM(CASE WHEN $month = MONTH(app.from_date) AND $month = MONTH(app.to_date) THEN DATEDIFF(app.to_date,app.from_date)+1 END) AS pay,
SUM(CASE WHEN $month = MONTH(app.from_date) AND $month < MONTH(app.to_date) THEN DATEDIFF(app.to_date,app.from_date)+1 END) AS pay1,
SUM(CASE WHEN $month > MONTH(app.from_date) AND $month = MONTH(app.to_date) THEN DATEDIFF(app.to_date,app.from_date)+1 END) AS pay2,
SUM(CASE WHEN $month > MONTH(app.from_date) AND $month < MONTH(app.to_date) THEN DATEDIFF(app.to_date,app.from_date)+1 END) AS pay3
FROM ".TB_PREF."payroll_transaction AS app
LEFT JOIN ".TB_PREF."payroll_types_leave AS type ON type.id = app.leave_type 
WHERE app.deleted = 0 and app.eid = '$eid' AND app.approved = '$type'";
$result = db_query($sql, "Leave Count is not working");
$row = db_fetch_row($result);
return $row[0]+$row[1]+$row[2]+$row[3];

}

// my new created functions


//to get total number of working hours
function getsum1($emp_id, $fcdate,$lcdate)
{

$sql = "SELECT SUM(hrs) as hrs FROM ".TB_PREF."payroll_transaction WHERE deleted = 0 and `eid` = '$emp_id' AND att_ot_date > '$lcdate' AND att_ot_date <= '$fcdate' AND doc_type = '107'";
$result = db_query($sql,"No employee were returned");
$myrow = db_fetch($result);
return $myrow["hrs"];

}

function isEligableforOvertime($eid)
{

$sql = "SELECT * FROM ".TB_PREF."payroll_employee WHERE deleted = 0 AND id = '$eid'";
$result = db_query($sql,"No employee were returned");
$myrow = db_fetch($result);
return $myrow["overtime"];

}

function getdeductionforViewPlayslip($year,$month,$gsalary,$employee_id)
{
	$days_in_a_year = $_SESSION['SysPrefs']->prefs['days_in_a_year'];
$month = $month - 1;
if($month == 0)
{
$month = 12;
$year = $year - 1;
}

$date_from = date2sql(get_last_month_cut_off($month,$year));

$date_to  = date('Y-m-d', mktime(0, 0, 0, $month+1, 0, $year));

// ***********************
// UN PAID DAYS AMOUNT
// ***********************
// case 1: Start from same  month and may end in same month.   
$unpaid_leave_day = calculate_leave_days($employee_id,$date_from, $date_to, $month, $year, 0);
while($row = db_fetch($unpaid_leave_day)){

if (strtotime($row["from_date"]) >= strtotime($date_from) && strtotime($row["to_date"]) <= strtotime($date_to) && strtotime($row["trans_date"]) > strtotime($date_from) ){
$leave_days = round(((strtotime($row["to_date"]) - strtotime($row["from_date"]))/(60*60*24)) + 1);
$leave_days0 += $leave_days;

}

// case 2:Start from Last month and end in this month. 

else if((strtotime($row["to_date"]) >= strtotime($date_from)  && strtotime($row["to_date"]) <= strtotime($date_to)) && strtotime($row["from_date"]) <= strtotime($date_from)){
$leave_days = round(((strtotime($row["to_date"])-strtotime($date_from))/(60*60*24)) + 1);
$leave_days1 += $leave_days;
}
// case 3: Start from this month and end in next month.  
else if((strtotime($row["from_date"]) >= strtotime($date_from)  && strtotime($row["from_date"]) <= strtotime($date_to)) && strtotime($row["to_date"]) >= strtotime($date_to) && strtotime($row["trans_date"]) > strtotime($date_from) ){
$leave_days = round(((strtotime($date_to)-strtotime($row["from_date"]))/(60*60*24)) + 1);
$leave_days2 += $leave_days;
}
// case 4: Start from some previous month and may end in any future month.   

else if(strtotime($row["from_date"]) <= strtotime($date_from) && strtotime($row["to_date"]) >= strtotime($date_to) && strtotime($row["trans_date"]) > strtotime($date_from) ){
$leave_days = round(((strtotime($date_to)-strtotime($date_from))/(60*60*24)));
$leave_days3 += $leave_days;
}
}

$total_leave_days = round($leave_days0 + $leave_days1 + $leave_days2 + $leave_days3);
$total_deduction = ($gsalary*12/$days_in_a_year) * $total_leave_days; 

$data = array('leave_days0' => $leave_days0,
'leave_days1' => $leave_days1,
'leave_days2' => $leave_days2,
'leave_days3' => $leave_days3,
'date_from' => $date_from,
'date_to' => $date_to,
'total_leave_days' => $total_leave_days,
'total_deduction' => $total_deduction);
return $data;

}

function checkSingleholiday($date){
$sql = "SELECT * FROM ".TB_PREF."payroll_holidays WHERE deleted = 0 AND  date = '$date'";
$result = db_query($sql, "employee query not working");
return db_num_rows($result);
}

function get_overtime_trans($emp_id,$month ,$year){

	 $sql = " SELECT * FROM `0_payroll_transaction`  where Month(att_ot_date) = '$month' AND Year(att_ot_date) = '$year' AND eid = ".db_escape($emp_id)." and deleted=0" ;

  return db_query($sql,"");
     
   
}
function get_factors($ot_factor_id)
{
	 $sql = " SELECT factor FROM `0_factor`  where deleted!=1 AND id = ".db_escape($ot_factor_id)." " ;

  $myrow =  db_query($sql,"");
      $res = db_fetch($myrow);

      return $res['factor'];
}

function getOvertimerecord($emp_id, $month ,$year)
{
		$days_in_a_year = $_SESSION['SysPrefs']->prefs['days_in_a_year'];
  $emp_info = get_employee_info_updated($emp_id);

  $total_amount = $emp_info[8] * 12;
  $amount_per_day = $total_amount / $days_in_a_year; 
  $per_hr = $amount_per_day / $emp_info[5];
  // display_error($per_hr);

  $over_time = get_overtime_trans($emp_id,$month,$year);


  while($row = db_fetch($over_time)){  

 $overtime = get_factors($row['ot_factor_id']) * $per_hr;
     // display_error($overtime); //0.821 * 1.5
     $totalOtrate = $row['hrs'] * $overtime;
     $total_overtime += $totalOtrate; 
  }

 return $total_overtime;

}


function get_num_days($start, $end) {

if($start != '' &&  $start != 0 && $end != '' &&  $end != 0 )
{

$start_ts = strtotime($start);
$end_ts = strtotime($end);
$diff = $end_ts - $start_ts;

return round($diff / 86400) + 1;
}
else
return 0;
}

function get_date_diff($from,$to)
{
$date1 = new DateTime($from);
$date2 = new DateTime($to);
$diff2 = $date2->diff($date1)->format("%a") +1;
return $diff2;
}

function get_days_month_forjoindate($month,$year,$emp_id)
{

$join_date = date2sql(get_employee_info($emp_id)[0]);

$currentcf = date2sql(get_current_month_cut_off($month,$year));

$nmonth = $month - 1;
$nyear = $year;
if($nmonth == 0)
{
$nmonth = 12;
$nyear = $year - 1;
}
$lastcf = date2sql(get_current_month_cut_off($nmonth,$nyear));

if(strtotime($join_date) > strtotime($lastcf))
{ 
$data = array(

0 => round(((strtotime($currentcf) - strtotime($join_date))/(60*60*24))+1), //days in month
1 => $join_date //join date
);
return $data;

}
}
function checkForPrePlannedLeaves($id)
{
$sql = "SELECT * FROM ".TB_PREF."payroll_types_leave WHERE deleted = 0 and id = '$id' AND preplannedleaves = 1";
$res = db_query($sql,'no record');
return db_num_rows($res) > 0 ? 'true' : 'false';
}

?>
