<?php

$page_security = 'SA_LEAVE';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/includes/ui.inc");
include_once($path_to_root ."/payroll/includes/ui_lists/ui_lists.inc");
include_once($path_to_root ."/payroll/includes/db/leave.inc");
include_once($path_to_root ."/includes/types.inc");
page(_($help_context = "Create types of leave"));

simple_page_mode(true);
$previous_page_url = $_SERVER['HTTP_REFERER']; 
if ($previous_page_url != $_SESSION['link_array'] ) {
unset($_SESSION['link_array']);
}
if ($previous_page_url == $_SESSION['link_array'] || !isset($_SESSION['link_array'])  || $_SESSION['link_array']==null ) {
	$_SESSION['link_array'] = explode('=',$previous_page_url);
}
bread_crumb($_SESSION['link_array'],$help_context,$previous_page_url);	
if (check_admin_authentication() != 'admin' || check_admin_authentication()!=true) {
		display_error("You have no Permission to Create Leave.");
		exit;
		}
//update and add function 
function update_leave_data($selected_id)
{

   update_leave($selected_id, $_POST['leave'],$_POST['remarks'],$_POST['status'],$_POST['annualleaveallowed'],$_POST['halfdayleave'],$_POST['carryforwardleave'],$_POST['leavesalaryadvance'],$_POST['preplannedleaves'],$_POST['leave_accrue'],$_POST['group_leave_emp']);
    	$note = _('Selected Leave has been Updated.');
    	return $note;
    		}
 function get_group_name($group_id)
 {
 	$sql = "SELECT group_name From ".TB_PREF."payroll_leave_group WHERE group_id= ".db_escape($group_id)."";
 	$myrow =db_query($sql,"");
 	$result = db_fetch($myrow);
 	return $result['group_name'];
 }
function add_leave_data()
 {
    			
    add_leave($_POST['leave'],$_POST['remarks'],$_POST['status'],$_POST['annualleaveallowed'],$_POST['halfdayleave'],$_POST['carryforwardleave'],$_POST['leavesalaryadvance'],$_POST['preplannedleaves'],$_POST['leave_accrue'],$_POST['group_leave_emp']);
    	$note = _('New leave has been added');
    	return $note;
 }
 //delete leave data 
 function delete_leave_data($selected_id)
{
	$cancel_delete = 0;
if (key_in_foreign_table($selected_id, 'payroll_transaction', 'leave_type'))
	{
		$cancel_delete = 1;
		display_error(_("Cannot Delete this Leave because Leave Application is Applied using this Application."));
	}
	if ($cancel_delete == 0) 
	{
		delete_leave($selected_id);
		display_notification(_('Selected Leave has been Deleted.'));
	}
	$Mode = 'RESET';
}

//check all error before add and update
function check_errors($selected_id)
{
	$input_error = 0;




	
	if (strlen($_POST['leave']) == 0) 
	{
		$input_error = 1;
		display_error(_("The leave cannot be empty."));
		set_focus('leave');
	}
	if ($_POST['group_leave_emp'] ==0) {
		$input_error = 1;
		display_error(_("Select group leave."));
		set_focus('group_leave_emp');
	}
	if($_POST['halfdayleave'] == 1 && $_POST['preplannedleaves']==1)
	{
	$input_error = 1;
	display_error(_("You Cannot insert Half Day Leave and Preplanned Leaves at a time."));
	set_focus('halfdayleave');
	}
  if(!floatval($_POST['annualleaveallowed']) && $_POST['annualleaveallowed'] != "")
  {
  	$input_error = 1;
	display_error(_("Max-Leave Can Only Be Numeric Value."));
	set_focus('halfdayleave');
  }

  if($_POST['annualleaveallowed'] == "")
  {
  	$input_error = 1;
	display_error(_("Max-Leave Cannot Be Empty."));
	set_focus('halfdayleave');
  }
  // if(!floatval($_POST['annualleaveallowed'])){
  //                $input_error = 1;
		// display_error(_("Only Numeric Value"));
		// set_focus('halfdayleave');
  //       }
 if($_POST['status'] == 0 && $_POST['halfdayleave'] == 1){
          $input_error = 1;
		display_error(_("Unpaid Leave cannot be mark as Half Day Leave."));
		set_focus('halfdayleave');
    }
 if($_POST['status'] == 0 && $_POST['carryforwardleave'] == 1){
          $input_error = 1;
		display_error(_("Unpaid Leave cannot be mark as Carry Forward leave."));
		set_focus('halfdayleave');
    }
 if($_POST['status'] == 0 && $_POST['leavesalaryadvance'] == 1){
          $input_error = 1;
		display_error(_("Unpaid Leave cannot be mark as Leave Salary Advance."));
		set_focus('halfdayleave');
    }

$check_leave = check_leave(strtoupper($_POST['leave']));
 
        if ($check_leave > 0 && $Mode == 'ADD_ITEM') 
	{
		$input_error = 1;
		display_error(_("The Leave is already Added."));
		set_focus('leave');
	}
$check_leave_id = check_leave_id(strtoupper($_POST['leave']));
        if ($check_leave > 0 && $Mode == 'UPDATE_ITEM'  && $check_leave_id['id'] != $selected_id) 
	{
		$input_error = 1;
		display_error(_("The Leave is already Added."));
		set_focus('leave');
	}
   if (key_in_foreign_table($selected_id, 'payroll_transaction', 'leave_type'))
	{
		$input_error = 1;
		display_error(_("Cannot Update this Leave because Leave Application is Applied using this Application."));
	}

//Update and Add after checking errors 

	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		$note = update_leave_data($selected_id);
    	} 
    	else 
    	{
 			$note =add_leave_data();
    	}
    
		display_notification($note);
		unset($_POST['leave']);    	
		unset($_POST['status']);    	
		unset($_POST['annualleaveallowed']);    	
		unset($_POST['group_leave_emp']);    	
		unset($_POST['leave_accrue']);    	
		unset($_POST['halfdayleave']);    	
		unset($_POST['carryforwardleave']);   
		unset($_POST['leavesalaryadvance']); 
		unset($_POST['preplannedleaves']);    	
		unset($_POST['remarks']);    	

		$Mode = 'RESET';
	}
}

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
	check_errors($selected_id);
// Delete Leave if it is not applied to any application
if ($Mode == 'Delete')
	delete_leave_data($selected_id);


if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	if ($sav) $_POST['show_inactive'] = 1;
}
//-------------------------------------------------------------------------------------------------

$result = get_leaves(check_value('show_inactive'));

start_form();
start_table(TABLESTYLE, "width=50%");
$th = array(_("ID"), _("Leave"),_("Status"), _("Max-Leave"),_("Group Name"),_("Leave Accrue"),_("Leave Type"),_("Carry Forward Leave"),_("Leave Salary Advance"),_("Pre-Planned Leaves"),"","");
inactive_control_column($th);

table_header($th);
$k = 0; 

while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);
		
	label_cell($myrow["id"]);
	label_cell($myrow["types_leave"]);
	label_cell(($myrow["status"] == '1')?'paid':'unpaid');
 	label_cell($myrow['annual_leave_allowed']);
	label_cell(get_group_name($myrow['group_id']));
	label_cell(($myrow['leave_accrue']==0)?"Yes":"No");
    label_cell(($myrow['halfdayleave'] == 0)?'full day leave':'Half day leave');
	label_cell(($myrow["carryforward"] == '1')?'Yes':'No');
	label_cell(($myrow["leavesalaryadvance"] == '1')?'Yes ': 'No');
	label_cell(($myrow["preplannedleaves"] == '1')?'Yes':'No');

  	inactive_control_cell($myrow["id"], $myrow["inactive"], 'payroll_types_leave', 'id');
 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
}

inactive_control_row($th);
end_table(1);

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{	
 	if ($Mode == 'Edit') {
		
		$myrow = get_leave($selected_id);
		
		$_POST['leave']  = $myrow["types_leave"];
		$_POST['remarks']  = $myrow["remarks"];
		$_POST['status']  = $myrow["status"];
	    $_POST['annualleaveallowed'] = $myrow["annual_leave_allowed"]; 
	    $_POST['group_leave_emp'] = $myrow["group_id"]; 
	    $_POST['halfdayleave'] = $myrow["halfdayleave"]; 
	    $_POST['carryforwardleave'] = $myrow["carryforward"]; 
	    $_POST['leavesalaryadvance'] = $myrow["leavesalaryadvance"]; 
	    $_POST['preplannedleaves'] = $myrow["preplannedleaves"]; 
	    $_POST['leave_accrue'] = $myrow["leave_accrue"]; 
	}
	hidden("selected_id", $selected_id);
	label_row(_("ID"), $myrow["id"]);
} 

text_row_ex(_("Leave:"), 'leave', 30);
leave_paid_status_row(_("Status:"), 'status',null,false);
text_row(_('Max-Leave'),'annualleaveallowed');
group_leave_emp(_("Leave Group :"), 'group_leave_emp',null,false);
leave_accrue_enabled(_("Leave Accrue Enabled:"), 'leave_accrue',null,false);
check_row(_("Half Day Leave"), 'halfdayleave');
check_row(_("Carry Forward Leave"), 'carryforwardleave');
check_row(_("Leave Salary Advance"), 'leavesalaryadvance');
check_row(_("Pre-Planned Leaves"), 'preplannedleaves');
textarea_row(_("Remarks:"), 'remarks', null, 40,4);

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
?>