<?php

$page_security = 'SA_PR_GRADE';
$path_to_root = "../..";
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/includes/ui.inc");
include_once($path_to_root ."/includes/ui/ui_lists.inc");
include_once($path_to_root ."/payroll/includes/ui_lists/ui_lists.inc");
include_once($path_to_root ."/payroll/includes/db/grade_db.inc");
include_once($path_to_root ."/includes/types.inc");
page(_($help_context = "Create Grade"));

simple_page_mode(true);
$previous_page_url = $_SERVER['HTTP_REFERER']; 
bread_crumb($previous_page_url,$help_context);	
if (check_admin_authentication() != 'admin' || check_admin_authentication()!=true) {
		display_error("You Have No Permission to View Grade Page.");
		exit;
		}
if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	$input_error = 0;

	if (strlen($_POST['grade']) == 0) 
	{
		$input_error = 1;
		display_error(_("The Grade Cannot Be Empty."));
		set_focus('grade');
	}
	
	if ($_POST['level'] != '')
	{
		$check = exists_level($_POST['level']);
                $id = exists_id($_POST['level']);		
		if($check > 0 && $id != $selected_id){
			$input_error = 1;
			display_error(_("You Have Already Selected Level. "));
			set_focus('level');
		}
	}
$check_grade = check_grade_db(strtoupper($_POST['grade']));
$check_grade_id = check_grade_id(strtoupper($_POST['grade']));
 
        if ($check_grade > 0 && $Mode == 'ADD_ITEM') 
	{
		$input_error = 1;
		display_error(_("The Grade Categories is Already Added."));
		set_focus('grade');
	}
 if ($check_grade > 0 && $Mode == 'UPDATE_ITEM' && $check_grade_id['id'] != $selected_id) 
	{
		$input_error = 1;
		display_error(_("The Grade Categories is Already Added."));
		set_focus('grade');
	}
	if ($input_error != 1)
	{
    	if ($selected_id != -1) 
    	{
    		update_grade($selected_id, $_POST['grade'],$_POST['remarks'],$_POST['level']);
			$note = _('Selected Grade has been Updated.');
    	} 
    	else 
    	{
    		add_grade($_POST['grade'],$_POST['remarks'],$_POST['level']);
			$note = _('New Grade has been Added.');
    	}
    
		display_notification($note);    	
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete')
{

	$cancel_delete = 0;	
	if (key_in_foreign_table($selected_id, 'payroll_employee', 'grade_id'))
	{
		$cancel_delete = 1;
		display_error(_("Cannot Delete this Grade because Employee have been Created Using This Grade."));
	}
        if (key_in_foreign_table($selected_id, 'payroll_designation', 'grade_id'))
	{
		$cancel_delete = 1;
		display_error(_("Cannot Delete this Grade because Designation have been Created Using This Grade."));
	}

	if ($cancel_delete == 0) 
	{
		delete_grade($selected_id);
		display_notification(_('Selected Grade has been Deleted.'));
	$Mode = 'RESET';
}
}
// if ($Mode == 'Delete')
// {

// 	$cancel_delete = 0;
// 	if ($cancel_delete == 0) 
// 	{
// 		delete_grade($selected_id);
// 		display_notification(_('Selected Grade has been Deleted.'));
// 	}
// 	$Mode = 'RESET';
// } 


if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	if ($sav) $_POST['show_inactive'] = 1;
}
//-------------------------------------------------------------------------------------------------

$result = get_grades(check_value('show_inactive'));

start_form();
start_table(TABLESTYLE, "width=30%");
$th = array(_("ID"), _("Grade"), _("Level"),_("Remarks"), "", "");
inactive_control_column($th);

table_header($th);
$k = 0; 
$serial_no = 1;
while ($myrow = db_fetch($result)) 
{
	
	alt_table_row_color($k);
		
	label_cell($serial_no);
	label_cell($myrow["grade"]);
	label_cell($myrow["level"]);
	label_cell($myrow["remarks"]);
	inactive_control_cell($myrow["id"], $myrow["inactive"], 'payroll_grade', 'id');
 	edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	delete_button_cell("Delete".$myrow["id"], _("Delete"));
	end_row();
$serial_no++;
}

inactive_control_row($th);
end_table(1);

//-------------------------------------------------------------------------------------------------

start_table(TABLESTYLE,"style=''");

if ($selected_id != -1) 
{	
 	if ($Mode == 'Edit') {
		//editing an existing group
		$myrow = get_grade($selected_id);

		$_POST['grade']  = $myrow["grade"];
		$_POST['remarks']  = $myrow["remarks"];
		$_POST['level']  = $myrow["level"];
	}
	hidden("selected_id", $selected_id);
	label_row(_("ID"), $myrow["id"]); //wait
} 

text_cells_ex(_("Grade:"),'grade',30);

level_grade_row(_("Level:"), 'level',null,false);

textarea_row(_("Remarks:"), 'remarks', null, 40,4);

end_table(1);

submit_add_or_update_center($selected_id == -1, '', 'both');

end_form();

end_page();
?>