<?php
/**********************************************
Name: Import Employee Information
***********************************************/
$page_security = 'SA_IMPORT_ATTENDANCE';
$path_to_root="../..";

include($path_to_root . "/includes/session.inc");
add_access_extensions();
include_once($path_to_root . "/includes/ui/attendance_cart.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root ."/payroll/attendance/attendance_func.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
include_once($path_to_root ."/payroll/includes/db/imp_allded_db.inc");

$k=0;
$can_insert = 1; // (0 = N0 1 = YES)


if (isset($_POST['imp_attendance'])) {

	 meta_forward($_SERVER['PHP_SELF'],"imp_all_attendance.php");
}
if (isset($_GET['AddedIM'])) {
	display_notification("Data has been processed Successfully");
	// $_GET['AddedIM']

}
if (isset($_POST['process_attendance']) && $can_insert == 1)
{ 
	$count = $_POST['count'];
	for ($i=0; $i <= $count;$i++)
	{ 
		process_attendance($_POST['eid'.$i],$_POST['over_time'.$i],$_POST['ot_factor'.$i],$_POST['att_ot_date'.$i],$_POST['hrs'.$i],$_POST['dim'.$i],$_POST['remarks'.$i]);
	}
  unset ($_SESSION['attendance_items']);
	 meta_forward($_SERVER['PHP_SELF'],"AddedIM=$count");
	
}

function process_attendance($eid,$over_time,$ot_factor=0,$att_ot_date,$hrs,$dim=0,$remarks)
{
	
	$doc_type = 107;
	 $sql = "INSERT INTO `0_payroll_transaction` (eid,doc_type,over_time,ot_factor_id,att_ot_date,hrs,dim,remarks) VALUES (".db_escape($eid).",".db_escape($doc_type).",".db_escape($over_time).",".db_escape($ot_factor).",".db_escape($att_ot_date).",".db_escape($hrs).",".db_escape($dim).",".db_escape($remarks).")";

	 db_query($sql,'Error');
	 $id = db_insert_id();
	 	if ($sql != null)
			add_audit_trail(107, $id,date('d/m/Y'), "Import");	
}
function check_attendance($eid,$att_ot_date)
{
	$result = get_employee_info($eid);                  
	$join_date = strtotime($result['join_date']);
	$leaving_date = strtotime($result['leavingdate']);
	$attendance_date = strtotime(str_replace('/','-',sql2date($att_ot_date)));

	//for Joining date

	 if ($attendance_date < $join_date) 						//change
	{
		$can_insert = 0;
		$array_result = array('a' => false,'b' => "Attendance date must be greater then joining date!",);
 			return $array_result;
	} 
	else{
			return $array_result = array('a' => true, );
	}  
	             
}
function check_leaving_attendance($eid,$att_ot_date)
{
	$result = get_employee_info($eid);                  
	$join_date = strtotime($result['join_date']);
	$leaving_date = strtotime($result['leavingdate']);
	$attendance_date = strtotime(str_replace('/','-',sql2date($att_ot_date)));
	//for leaving date

	if ($leaving_date != '' && $attendance_date > $leaving_date ) 
	{
		// return $array_result = array('a' => true, );
		$can_insert = 0;
		$array_result = array('a' => false,'b' => "Attendance date must be less then leaving date!",);
 			return $array_result;
	} 
	else{
			return $array_result = array('a' => true, );
	} 
}
function check_overtime($eid,$ot)
{
	if($ot!=0){
	$result = get_employee_info($eid);                  //check overtime eligibale or not 
	if ($result['overtime']!=0) {                      //1 means eligible
	
		return $array_result = array('a' => true, );
			}else
			{	$can_insert = 0;
				$array_result = array('a' => false,'b' => "Employee is not eligible",);
 			return $array_result;}
 			}else
 			{return $array_result = array('a' => true, );}
}
function checking_ovetime_method($eid,$ot,$ot_factor)
{
	$result = get_employee_info($eid);
	$overtime = $result['overtime'];
	$overtime_method = $result['overtime_method'];

	if($ot == 1)
	{
		// if($overtime_method ==1)     //approved
		// { 

		// 	return $array_result = array('a' => true, );
		// }else{

		// 	$can_insert = 0;
		// 		$array_result = array('a' => false,'b' => "The Over time method is not Approved",);
 	// 		return $array_result;
		// }
	
		if($overtime_method ==1)
		{


			if($ot != "" && $ot_factor != 0)
			{
				return $array_result = array('a' => true, );

			}
			elseif($ot == 0 && $ot_factor != 0)    //	elseif($ot == "" && $ot_factor != "")
			{
			
				$can_insert = 0;
				$array_result = array('a' => false,'b' => "Please insert overtime because overtime factor is not Empty",);
 				return $array_result;
			}
			elseif ($ot != "" && $ot_factor == 0) 
			{
					$can_insert = 0;
					$array_result = array('a' => false,'b' => "Please insert overtime factor because overtime is not Empty",);
 					return $array_result;			
			}
			else
			{
				return $array_result = array('a' => true, );
			}
	// 	// 	$can_insert = 0;
	// 	// 		$array_result = array('a' => false,'b' => "Please insert overtime because overtime method is Approved",);
 // 	// 		return $array_result;
	// 	// }else{
	// 	// 	return $array_result = array('a' => true, );
		}
		else
		{


			if($ot_factor != "")
			{

				return $array_result = array('a' => true, 'ot'=>1);

			}
			elseif ($ot != "" && $ot_factor == "") {
					$can_insert = 0;
					$array_result = array('a' => false,'b' => "Please insert overtime factor because overtime is not Empty",);
 					return $array_result;	
			}
			else
			{
				return $array_result = array('a' => true);
			}
		}
	}
	else
	{
		if($overtime_method ==1)
		{

			if($ot != 0 && $ot_factor != 0)    //if($ot != "" && $ot_factor != "")
			{

			
				return $array_result = array('a' => true, );

			}
			elseif($ot == 0 && $ot_factor != 0)
			{
			
				$can_insert = 0;
				$array_result = array('a' => false,'b' => "Please insert overtime because overtime factor is not Empty",);
 				return $array_result;
			}
			elseif ($ot != 0 && $ot_factor == 0)    //elseif ($ot != "" && $ot_factor == "") 
			{

					$can_insert = 0;
					$array_result = array('a' => false,'b' => "Please insert overtime factor because overtime is not Empty",);
 					return $array_result;			
			}
			else
			{

				return $array_result = array('a' => true, );
			}
	// 	// 	$can_insert = 0;
	// 	// 		$array_result = array('a' => false,'b' => "Please insert overtime because overtime method is Approved",);
 // 	// 		return $array_result;
	// 	// }else{
	// 	// 	return $array_result = array('a' => true, );
		}
		else
		{

			if($ot_factor != "")
			{

				return $array_result = array('a' => true, 'ot'=>1);

			}
			elseif ($ot != "" && $ot_factor == "") {
					$can_insert = 0;
					$array_result = array('a' => false,'b' => "Please insert overtime factor because overtime is not Empty",);
 					return $array_result;	
			}
			else
			{

				return $array_result = array('a' => true);
			}
		}

	}
	
}
function check_overtime_availability($eid,$ot,$ot_factor){
	$result = get_employee_info($eid);
	$overtime = $result['overtime'];
	$overtime_method = $result['overtime_method'];

	if ($ot_factor != 0 ) {
		if ($overtime == 1) {
			return $array_result = array('a' => true, );
		}else{
			$can_insert = 0;
				$array_result = array('a' => false,'b' => "You can not insert Overtime method because overtime is not eligible",);
 			return $array_result;

		}
	}
	else
		return $array_result = array('a' => true, );

	// if ($overtime == 1) {    recently comment
	// 	$can_insert = 0;
	// 			$array_result = array('a' => false,'b' => "Please insert overtime method because over time is eligible",);
 // 			return $array_result;
	// }

}

function check_ot_factor($ot_factor,$ot)
{
	if($ot_factor!=''){
	$sql="SELECT count(factor) as count from `0_factor` WHERE factor='$ot_factor'";
		$result = db_query($sql, "Could not search Factor");
 		$row = db_fetch($result);
 		if ($row['count'] == 1) {
 			$array_result = array('a' => true,);
 			return $array_result;
 		}else{
 			if ($ot_factor !=0) {
 				
 			$can_insert = 0;
			$array_result = array('a' => false,'b' => "Over Time factor is not found",);
 			return $array_result;
 			}
 			else
 			{

 				$array_result = array('a' => true,);
 				return $array_result;
 			}
 		}
 	}else{
 		$array_result = array('a' => true,);
 			return $array_result;
 	}
}
function check_dimension($dim)
{
	if($dim !=null )
	{
		$sql2="SELECT name from `0_dimensions` WHERE id='$dim'";
		$result2 = db_query($sql2, "Could not search Dimension");
 		$row2 = db_fetch($result2);

 		if ($row2['name'] !='') 
 			{
 				$array_result = array('a' => true,'b' => $row2['name'],);
 				return $array_result;
 			}
 		else
 			{$can_insert = 0;
 			$array_result = array('a' => false,'b' => "Dimension id not found",);
 			return $array_result;
 			}
 	}
 	else
		{
			$array_result = array('a' => true,'b' => "No Project",);
 				return $array_result;}

}
function check_hours($hrs)
{
	
	if (is_numeric($hrs) && $hrs >= 0) {
		$array_result = array('a' => true,);
 			return $array_result;
	}else
	{
		$can_insert = 0;
 			$array_result = array('a' => false,'b' => "Hours must be positive numbers",);
 			return $array_result;
	}
}
function check_employee($employee_id)
{
	if($employee_id !=null )
	{
	$sql1="SELECT employee_id,first_name from `0_payroll_employee` WHERE employee_id='$employee_id'";

	$result1 = db_query($sql1, "Could not search User");
 	$row1 = db_fetch($result1);
 		if ($row1['employee_id'] != '') 
 			{
 			$array_result = array('a' => true,'b' => $row1['first_name'],);
 			return $array_result;
 			}
 		else
 			{
 				$can_insert = 0;
 				$array_result = array(
			'a' => false,
			'b' => "User id not found",);
 				return $array_result;
 			}
	}	
	else
		{ 
			$can_insert = 0;
			return false;
		}
}


$action = 'import';
if (isset($_GET['action'])) $action = $_GET['action'];
if (isset($_POST['action'])) $action = $_POST['action'];



page(_($help_context="Import Attendance"));
// $previous_page_url = $_SERVER['HTTP_REFERER']; 
// if ($previous_page_url != $_SESSION['link_array'] ) {
// unset($_SESSION['link_array']);
// }
// if ($previous_page_url == $_SESSION['link_array'] || !isset($_SESSION['link_array'])  || $_SESSION['link_array']==null ) {
// 	$_SESSION['link_array'] = explode('=',$previous_page_url);
// }
// bread_crumb1($_SESSION['link_array'],$help_context,$previous_page_url);	

if (check_admin_authentication1() != 'admin' || check_admin_authentication1()!=true) {
		display_error("You have no permission to import Attendance");
		exit;
		}
//----------------------------------------------------------------------------
if (isset($_POST['import']) && !isset($_POST['process_attendance'])) {
	if (isset($_FILES['imp'])  && $_FILES['imp']['name'] != '') 
	{
		$filename = $_FILES['imp']['tmp_name'];
		$sep = ",";
	
		$fp = @fopen($filename, "r");
		if (!$fp)
			die("can not open file $filename");

		$lines = $i = $j = $k = 0;
	
		// Employee ID,Over Time (1/0),Attendance Date (yyy-mm-dd) ...
		while ($data = fgetcsv($fp, 14096, $sep)) {
			if ($lines++ == 0) continue;
			
//retrieving the fields defined in csv format by list from data array  		
list($eid, $over_time,$att_ot_date,$hrs,$dim,$remarks,$ot_factor) = $data;	

if($eid == null)
	{
		$can_insert = 0;
		display_error("Line $lines: Employee ID can not be empty");
	}

if ($k ==0) 
	{
 		$_SESSION['attendance_items'] = new attendance_cart(ST_LOCTRANSFER);

	}
		$_SESSION['attendance_items']->import_to_attendance(count($_SESSION['attendance_items']->line_items),$eid,$att_ot_date, $hrs, $dim, $over_time,$remarks,$ot_factor);

					$k +=1;
			     $i++;
}
	@fclose($fp);

		
	} else
	{
	display_error("No CSV file selected");
	exit;

	} 
}
//---------------------------------------------------------------------------------------
$action ='import';
if ($action == 'import' && !isset($_POST['import']) ) 
	{    
start_form(true);
	start_table(TABLESTYLE2, "width=40%");
	table_section_title("Import Employee Infomation");
	label_row("CSV Import File:", "<input type='file' id='imp' name='imp'>");
	label_row("Download CSV Import File Format:", "<a href='../../payroll/attendance_mark.csv' download>Download </a>");
	end_table(1);
	submit_center('import', "Import CSV File");
end_form();
}

echo "<br>";
echo "<br>";

if (isset($_POST['import'])) {


 start_table(TABLESTYLE2, "width=50%");
	$th = array("S.No",_("Employee ID"),_("Employee Name"),_("Over Time"),_('OverTime Factor'), _("Attendance Data"), 'Hours','Dimension','Remarks','Status');
	table_header($th);
	
start_form();
if (isset($_SESSION['attendance_items'])) {
$count =0;	
$error_count = 0;
$serial_number=2;
foreach ($_SESSION['attendance_items']->line_items as $key => $attendance_item) 
{
	if (check_employee($attendance_item->eid)['a'] != false && check_dimension($attendance_item->dim)['a'] !=false && check_overtime($attendance_item->eid,$attendance_item->ot)['a'] != false && check_attendance($attendance_item->eid,$attendance_item->at_date)['a'] !=false && check_ot_factor($attendance_item->ot_factor,$attendance_item->ot)['a'] != false && check_leaving_attendance($attendance_item->eid,$attendance_item->at_date)['a'] != false && check_hours($attendance_item->hrs)['a'] != false  && checking_ovetime_method($attendance_item->eid,$attendance_item->ot,$attendance_item->ot_factor)['a'] != false && check_overtime_availability($attendance_item->eid,$attendance_item->ot,$attendance_item->ot_factor)['a'] != false) 
	{
		$row=check_employee($attendance_item->eid,$attendance_item->dim);
		$row2=check_dimension($attendance_item->dim);
	start_row();
	label_cells(null,$serial_number);
			hidden('count',$count);
			hidden('eid'.$count, $attendance_item->eid);
if(checking_ovetime_method($attendance_item->eid,$attendance_item->ot,$attendance_item->ot_factor)['ot'] =="")
	{
			hidden('over_time'.$count, $attendance_item->ot);
	}else
	{
		hidden('over_time'.$count,1);
	}		
			hidden('ot_factor'.$count, $attendance_item->ot_factor);
           	hidden('att_ot_date'.$count, $attendance_item->at_date);
           	hidden('hrs'.$count, $attendance_item->hrs);
           	hidden('dim'.$count, $attendance_item->dim);
           	hidden('remarks'.$count, $attendance_item->remarks);


			label_cells(null,$attendance_item->eid);
			label_cells(null,check_employee($attendance_item->eid)['b']);


if(checking_ovetime_method($attendance_item->eid,$attendance_item->ot,$attendance_item->ot_factor)['ot'] =="")
	{
				if ($attendance_item->ot == 0) {
				label_cells(null,"No");
				}else{
				label_cells(null,"Yes");
				}
	}
	else
	{

		if ($attendance_item->ot == 0 && $attendance_item->ot_factor==0) {
				label_cells(null,"No");
				}else{
				label_cells(null,"Yes");
				}

			// label_cells(null,"Yes");
	}



			if ($attendance_item->ot_factor == 0) {
				label_cells(null,"OverTime Factor is Empty");
			}else{
				label_cells(null,$attendance_item->ot_factor);
			}
			
			label_cells(null,$attendance_item->at_date);
			label_cells(null,$attendance_item->hrs);
			label_cells(null,check_dimension($attendance_item->dim)['b']);
			label_cells(null,$attendance_item->remarks);
			label_cells('Success',null,"style='background:#00800033;'");
	end_row();
	$serial_number +=1;
	}
	else
	{
		start_row();
		label_cells(null,$serial_number);
		if (check_employee($attendance_item->eid)['a'] ==false) {
			label_cells(null,check_employee($attendance_item->eid)['b']);
		}if (check_dimension($attendance_item->dim)['a']==false) {
			label_cells(null,check_dimension($attendance_item->dim)['b']);
		}if (check_overtime($attendance_item->eid,$attendance_item->ot)['a']==false) {
			label_cells(null,check_overtime($attendance_item->eid,$attendance_item->ot)['b']);
		}if (check_attendance($attendance_item->eid,$attendance_item->at_date)['a']==false) {
		label_cells(null,check_attendance($attendance_item->eid,$attendance_item->at_date)['b']);
		}if (check_leaving_attendance($attendance_item->eid,$attendance_item->at_date)['a']==false) {label_cells(null,check_leaving_attendance($attendance_item->eid,$attendance_item->at_date)['b']);
		}if (check_ot_factor($attendance_item->ot_factor,$attendance_item->ot)['a']==false) {
			label_cells(null,check_ot_factor($attendance_item->ot_factor,$attendance_item->ot)['b']);
		}if (check_hours($attendance_item->hrs)['a']==false) {
			label_cells(null,check_hours($attendance_item->hrs)['b']);
		}if (checking_ovetime_method($attendance_item->eid,$attendance_item->ot,$attendance_item->ot_factor)['a']==false) {
			label_cells(null,checking_ovetime_method($attendance_item->eid,$attendance_item->ot,$attendance_item->ot_factor)['b']);
		}if (check_overtime_availability($attendance_item->eid,$attendance_item->ot,$attendance_item->ot_factor)['a']==false) {
			label_cells(null,check_overtime_availability($attendance_item->eid,$attendance_item->ot,$attendance_item->ot_factor)['b']);
		}
		end_row();
		$error_count +=1;
		$serial_number +=1;
	}
	$count++;
}

}
submit_cells('imp_attendance', _("Import Attendance"), "colspan=2",_('Import Attendance'), true);
if ($error_count == 0) {
	submit_cells('process_attendance', _("Process Attendance"), "colspan=2",_('Process Attendance'), true);
}

end_form();

	// Show notification after click the import csv file button
	if (isset($_POST['import'])) 
	{
		$successfull=$count-$error_count;
		// display_notification("<b>Data is added Successfully!</b>");
		display_message("<b>Total Records(s)= ".$count." , Valid Records(s)= ".$successfull." , Invalid Record(s)=".$error_count."</b>");
		
		echo "<br>";
		echo "<br>";
	}
}

    end_page();


?>