<?php
/**********************************************
Name: Import Employee Information
***********************************************/
$page_security = 'SA_PR_IMP_ALL_DED';
$path_to_root="../..";

include($path_to_root . "/includes/session.inc");
add_access_extensions();

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/date_functions.inc");
// include_once($path_to_root ."/payroll/includes/db/attendance_db.inc");
include_once($path_to_root . "/inventory/includes/inventory_db.inc");
// include_once($path_to_root . "/inventory/includes/db/items_codes_db.inc");
// include_once($path_to_root . "/dimensions/includes/dimensions_db.inc");
// include_once($path_to_root ."/payroll/includes/db/payroll_calculation_db.inc");
include_once($path_to_root ."/payroll/includes/db/imp_allded_db.inc");
include_once($path_to_root ."/payroll/includes/ui_lists/ui_lists.inc");

// include_once($path_to_root ."/payroll/includes/db/employee.inc");


function get_employee_details($emp_id)
{

                    $sql = "SELECT COUNT(".TB_PREF."payroll_employee.id),".TB_PREF."payroll_employee.* FROM ".TB_PREF."payroll_employee WHERE  deleted = 0 AND payroll_employee_id = '$emp_id'";
			        $result = db_query($sql, "Could not search Employee");
			        $row = db_fetch_row($result);
			        return $row;
}
function download_link($row)
{
  	return button('download'.$row["id"], _("Download"), _("Download"), ICON_DOWN);
}

function get_dim_details($dim_ref)
{

 $sql = "SELECT COUNT(".TB_PREF."dimensions.id), ".TB_PREF."dimensions.* FROM ".TB_PREF."dimensions WHERE reference = '$dim_ref'";
			        $result = db_query($sql, "Could not search Employee");
			        $row = db_fetch_row($result);
			          return $row;
}
$action = 'import';
if (isset($_GET['action'])) $action = $_GET['action'];
if (isset($_POST['action'])) $action = $_POST['action'];



page(_($help_context ="Import Employee Allowance & Deduction"));
$previous_page_url = $_SERVER['HTTP_REFERER']; 
bread_crumb($previous_page_url,$help_context);	

if (check_admin_authentication() != 'admin' || check_admin_authentication()!=true) {
		display_error("You have no Permission to Import all Deduction");
		exit;
		}

if (isset($_POST['import'])) {
	if (isset($_FILES['imp'])      && $_FILES['imp']['name'] != '') {
		$filename = $_FILES['imp']['tmp_name'];
		$sep = ",";

		$fp = @fopen($filename, "r");
		if (!$fp)
			die("can not open file $filename");

		$lines = $i = $j = $k = $b = $u = $p = $pr = $dm_n = 0;
		
		$e_id = $e_title = $e_lname = $e_fname = $e_mart_stat = $e_email = $e_gender = $e_nat = 0;
		$e_dob = $e_religion = $e_passno = $e_passexp = $e_eid = $e_eidexp = $e_labcardno = $e_labcardexp = 0;
		$e_visaexp = $e_drivlic = $e_drivexp = $e_insno = $e_insexp = $e_personalno = $e_workpermit = $e_hmcontadd = 0;
		$e_hmcontcont = $e_uaeadd = $e_uaecont = $e_bankname = $e_branch = $e_acctitle = $e_account = $e_iban = 0;
		$e_desig = $e_dept = $e_grade = $e_basicsal = $e_wphour = $e_eg_for_overtime = $e_jdate = $e_contractType = 0;
		$e_contractdur = $e_contractexp = $e_status = $e_isresigned = $e_leavingdate = $e_totsal = 0;
		// employee id, employee title, lastname, firstname, martial status, gender, ...
		while ($data = fgetcsv($fp, 14096, $sep)) {
			if ($lines++ == 0) continue;
			
//retrieving the fields defined in csv format by list fron data array  		
// echo '</pre>';
// print_r($data);
list($employee_id, $allowance_deduction, $amount, $remarks) = $data;	
			
$can_insert = 1; // (0 = N0 1 = YES)

$current_date = date('Y-m-d');


//Employee id is must in the excel sheet
//echo date2sql($dob).'<br/>';
//echo is_date(date2sql($dob)).'<br/>';


if($employee_id == null)
{
$can_insert = 0;
display_error("Line $lines: Employee id cannot be Empty at line no $lines of Employee $title $Fname $Lname");
}
else
{
	$emp_id = checkEid($employee_id);
	if($emp_id == '' || $emp_id == 0)
	{
	$can_insert = 0;
	display_error("Line $lines: No such Employee ID exist");
	}
}




if($allowance_deduction == null)
{
$can_insert = 0;
display_error("Line $lines: Allowance or Deduction cannot be Empty");
}
else
{
	$chkal = checkifAll(strtoupper($allowance_deduction));
	$chkded = checkifDed(strtoupper($allowance_deduction));

	if($chkal > 0){
		$allowdedId = getALLid(strtoupper($allowance_deduction));
		$is_allowances = 1;
	}
	if($chkded > 0){
		$allowdedId = getDedid(strtoupper($allowance_deduction));
		$is_allowances = 2;	
	}
	if($chkded == 0 && $chkal == 0)
	{
		$can_insert = 0;
		display_error("Line $lines: Allowance or Deduction does not Exist");		
	}


	$check_allowance = check_allowance($allowdedId);
	
	if ($check_allowance)
	{
		$can_insert = 0;
		display_error("Line $lines: Allowance or Deduction is already Exist.");		
		

	}
}


if($amount == null)
{
	$can_insert = 0;
	display_error("Line $lines: Amount cannot be Empty");
}


// Insert Employee record to Databases
if($can_insert == 1)
{



	add_allowance_deds(checkEid($employee_id)['employee_id'],$allowdedId,$amount,$remarks,$is_allowances);


	display_notification("Data is Added Successfully.");
	//$can_insert = 0;
}
else
display_error("Line $lines: Cannot Insert Line");

$i++;


}
		@fclose($fp);

		if ($i+$j > 0) display_notification("$i Allowance & Deduction Entries Added in the System."); 
		

	} else display_error("No CSV file selected");
}
$action ='import';


if ($action == 'import') {
    start_form(true);

    start_table(TABLESTYLE2, "width=40%");

  

    table_section_title("Import Employee Allowance & Deduction");

    label_row("CSV Import File:", "<input type='file' id='imp' name='imp'>");
    label_row("Download CSV Import File Format:", "<a href='../../payroll/allowance_deduction.csv' download>Download </a>");

    end_table(1);

    submit_center('import', "Import CSV File");

  
       end_form();

}

    end_page();
?>