<?php

/*
	Class for supplier/customer payment/credit allocations edition
	and related helpers.
*/
//-----------------------------------------------------------------------------------

class allocation 
{
// display_error(Ss);
	var $trans_no; 
	var $type;
	var $person_id = '';
	var $person_name = '';
	var $person_type;	// PT_SUPPLIER/PT_CUSTOMER
	var $person_curr;
	var $date_;
	var $amount; /*Total amount of the transaction in FX */
	var $currency;

	var $allocs; /*array of transactions allocated to */

	function allocation($type, $trans_no, $person_id = null, $person_type_id=null)
	{
		$this->allocs = array();


		$this->trans_no = $trans_no;
		$this->type = $type;
		if ($person_id)
			$this->set_person($person_id, $person_type_id);

		$this->read($type, $trans_no, $person_id, $person_type_id); // read payment or credit
	}

	function set_person($person_id, $person_type)
	{
		$this->person_id = $person_id;
		$this->person_type = $person_type;
		$this->person_curr = $person_type == PT_SUPPLIER ?
			get_supplier_currency($person_id) : get_customer_currency($person_id);
		return $this->person_curr;
	}

	function add_item($type, $type_no, $date_, $due_date, $amount, $amount_allocated, 
		$current_allocated, $ref,$empname)
	{

// display_error($type.",". $type_no.",". $date_.",". $due_date.",". $amount.",". $amount_allocated.",". 
// 		$current_allocated.",". $ref.",".$empname);
// $amount=10000;
// display_error(floatcmp($amount, 0));
		if (floatcmp($amount, 0))
		{
			$this->allocs[count($this->allocs)] = new allocation_item($type, $type_no, 
				$date_, $due_date, $amount, $amount_allocated, $current_allocated, $ref,$empname);
			return true;
		} 
		else 
		{
			return false;
		}
	}
	
	function update_item($index, $type, $type_no, $date_, $due_date, 
		$amount, $amount_allocated, $current_allocated, $ref,$empname)
	{
		if (floatcmp($amount, 0))
		{
			$this->allocs[$index] = new allocation_item($type, $type_no, 
				$date_, $due_date, $amount, $amount_allocated, $current_allocated, $ref,$empname);
			return true;
		} 
		else 
		{
			return false;
		}
	}
	
	function add_or_update_item($type, $type_no, $date_, $due_date, 
		$amount, $amount_allocated, $current_allocated, $ref,$empname)
	{
		for ($i = 0; $i < count($this->allocs); $i++) 
		{
			$item = $this->allocs[$i];
			if (($item->type == $type) && ($item->type_no == $type_no)) 
			{
				return $this->update_item($i, $type, $type_no, $date_, $due_date, 
					$amount, $amount_allocated, $current_allocated, $ref,$empname);
			}
		}
        return $this->add_item($type, $type_no, $date_, $due_date, 
        	$amount, $amount_allocated, $current_allocated, $ref,$empname);
	}

	//
	//	Read payment or credit current/available allocations to cart.
	//
	// FIXME - read all transactions below twice seems to be suboptimal
	//
	function read($type = null, $trans_no = 0, $person_id=null, $person_type_id=null)
	{
		if ($type !== null) {	// otherwise re-read
			$type = $this->type;
			$trans_no = $this->trans_no;
			if ($trans_no) {
				$trans = $this->person_type == 'Payroll'? get_payroll_trans($trans_no, $type, $person_id): get_payroll_trans($trans_no, $type, $person_id);
				// echo "<pre>";
				// print_r($trans);
				// echo "</pre>";
	
				$this->person_id = $trans[$this->person_type == 'Payroll' ? 'employee_id':'employee_id'];
				$this->person_name = $trans[$this->person_type == 'payroll' ? "first_name":"first_name"];
				$this->date_ = sql2date($trans["trans_date"]);
				$this->bank_amount = @$trans["charges_amount"];
				$this->amount= str_replace(',','',$trans["allocated"]);
			} else
				$this->date_ = Today();
		}
	/* Now populate the array of possible (and previous actual) allocations 
		for this customer/supplier. First get the transactions that have 
		outstanding balances ie Total-alloc >0 */
		$this->allocs = array();

		if ($this->person_id)
		{

		 $trans_items = get_allocatable_to_payroll_transactions($this->trans_no);
		 // print_r(db_fetch($trans_items));
			while ($myrow = db_fetch($trans_items))
			{

                     
				$this->add_item($myrow["trans_type"], $myrow["employee_id"],
					$myrow["month"],
					$myrow["year"],
					$myrow["totalamount"], // trans total
					$myrow["totalamount"]-$myrow["allocate"], // trans total allocated
					0,
					$myrow["id"],
					$myrow["employeename"]); // this allocation
                       
                     
			}
		}
		if ($this->trans_no == 0) return; // this is new payment

	/* Now get trans that might have previously been allocated to by this trans
	NB existing entries where still some of the trans outstanding entered from
	above logic will be overwritten with the prev alloc detail below */

				/* 	$trans_items = get_allocatable_to_payroll_transactions($this->person_id, 
				$this->trans_no, $this->type);

		while ($myrow = db_fetch($trans_items))
		{
               
			$this->add_or_update_item ($myrow["trans_type"], $myrow["eid"],
					$myrow["month"],$myrow["year"],
					$myrow["totalamount"], // trans total
					$myrow["allocate"], // trans total allocated
					$myrow["allocate"],
					$myrow["id"],$myrow["employeename"]);
                 }*/
	}
	//
	//	Update allocations in database.
	//
	function write()
	{


		begin_transaction();

				 	clear_cust_alloctions($this->type, $this->trans_no, $this->date_);
		// now add the new allocations
		$total_allocated = 0;
		$dec = user_price_dec();

		$total_amount = $this->amount;
				 			// display_error($total_amount.dddd);
				// echo "<pre>";
				// print_r($this->allocs);
				// echo "</pre>";

				//  			exit;
		foreach ($this->allocs as $alloc_item)
			{
			if($alloc_item->current_allocated > 0){
                    
                    $amount = round($alloc_item->current_allocated, $dec);

                		
   // if (number_format($alloc_item->current_allocated,2) >= number_format($alloc_item->amount,2))
   //                    {
	 				add_payroll_allocation($this->trans_no,$alloc_item->ref,$amount);

	 				$amount = getAllocatedAmount($alloc_item->ref) - $amount;

	 				update_payslip_allocation($alloc_item->ref,$amount);

				
				// Exchange Variations Joe Hunt 2008-09-20 ////////////////////
				//exchange_variation($this->type, $this->trans_no,
				//	$alloc_item->type, $alloc_item->type_no, $this->date_,
				//	$amount, $this->person_type);

				//////////////////////////////////////////////////////////////
				$total_allocated += $alloc_item->current_allocated;
                                $total_amount = $total_amount - $total_allocated;
                       // }
                    
			
                        // else{
                        //  display_error("No Partial Payment Allowed ".$alloc_item->employee_name);
                        //  }
                  }
		}   /*end of the loop through the array of allocations made */

		$left_to_allocated = $this->amount - $total_allocated;
		 	update_payroll_payment_trans_allocation($this->trans_no,$left_to_allocated);

		commit_transaction();
	}

} 

//-----------------------------------------------------------------------------------

class allocation_item 
{

	var $type;
	var $type_no;
	
	var $date_;
	var $due_date;
	
	var $amount_allocated;
	var $amount;
	var $ref;
	var $employee_name;
	var $current_allocated;
	
	function allocation_item ($type, $type_no, $date_, $due_date, $amount, 
		$amount_allocated, $current_allocated, $ref,$empname)
	{
                $this->ref = $ref;
		$this->type = $type;//trans-type
		$this->type_no = $type_no;//trans_no
		$this->date_ = $date_;
		$this->due_date = $due_date;
		$this->employee_name = $empname;
		$this->amount = $amount;
		$this->amount_allocated = $amount_allocated;
		$this->current_allocated = $current_allocated;
        
	}
}

//--------------------------------------------------------------------------------

function show_allocatable($show_totals) {

	global $systypes_array;
	
    $k = $counter = $total_allocated = 0;

	$cart = $_SESSION['alloc'];

	$supp_ref = in_array($cart->type,'Payroll');
	if (count($cart->allocs)) 
	{

		if ($cart->currency != $cart->person_curr)
			display_heading(sprintf(_("Allocated amounts in %s:"), $cart->person_curr));
		start_table(TABLESTYLE, "width=80%");
   		$th = array(_("Transaction Type"),_("#"), _("Employee-ID"), _("Employee Name"), _("Month"), _("Year"), _("Amount"),
   			_("Other Allocations"), _("Left to Allocate"), _("This Allocation"),'','');

	   	table_header($th);

		foreach ($cart->allocs as $id => $alloc_item)
		{
                      
		    if (floatcmp(abs($alloc_item->amount), $alloc_item->amount_allocated) || !floatcmp(abs($alloc_item->amount), $alloc_item->amount_allocated))
		    {
                   
				alt_table_row_color($k);
    			label_cell($alloc_item->type);
                label_cell($alloc_item->ref);
	   			label_cell($alloc_item->type_no);
		   		label_cell($alloc_item->employee_name);
    			label_cell($alloc_item->date_, "align=right");
    			label_cell($alloc_item->due_date, "align=right");
	    		amount_cell(abs($alloc_item->amount));
				amount_cell($alloc_item->amount_allocated);

		    	$_POST['amount' . $id] = price_format($alloc_item->current_allocated);

	    		$un_allocated = abs(round((abs($alloc_item->amount) - $alloc_item->amount_allocated), 6));
	    		amount_cell($un_allocated, false,'', 'maxval'.$id);
    			amount_cells(null, "amount" . $id);//, input_num('amount' . $id));
				label_cell("<a href='#' name=Alloc$id onclick='allocate_all(this.name.substr(5));return true;'>"
					 . _("All") . "</a>");
				label_cell("<a href='#' name=DeAll$id onclick='allocate_none(this.name.substr(5));return true;'>"
					 . _("None") . "</a>".hidden("un_allocated" . $id, 
					 price_format($un_allocated), false));
				end_row();

   	    		$total_allocated += input_num('amount' . $id);
		   	}

		}
		if ($show_totals) {
    	   	label_row(_("Total Allocated"), price_format($total_allocated),
	    		"colspan=8 align=right", "align=right id='total_allocated'", 3);
/*
			$amount = $_SESSION['alloc']->amount;

			if ($_SESSION['alloc']->type == 'Payroll'
				|| $_SESSION['alloc']->type == ST_SUPPAYMENT
				||  $_SESSION['alloc']->type == ST_BANKPAYMENT)
				$amount = -$amount;
*/
			$amount = abs($cart->amount);

			if (floatcmp($amount, $total_allocated) < 0)
	        {
        		$font1 = "<font color=red>";
        		$font2 = "</font>";
    	    }
	        else
        		$font1 = $font2 = "";
			$left_to_allocate = price_format($amount - $total_allocated);
                         $_GET['amount'] = $left_to_allocate;
	        label_row(_("Left to Allocate"), $font1 . $left_to_allocate . $font2, 
				"colspan=8 align=right", "nowrap align=right id='left_to_allocate'",
				 3);
            
		}
		end_table(1);
	}
	hidden('TotalNumberOfAllocs', count($cart->allocs));
}
//--------------------------------------------------------------------------------

function check_allocations()
{
	global $SysPrefs;

	$total_allocated = 0;

	for ($counter = 0; $counter < get_post("TotalNumberOfAllocs"); $counter++)
	{
		if (!isset($_POST['amount'.$counter])) continue;
		if (!check_num('amount' . $counter, 0))
		{
			display_error(_("The entry for one or more amounts is invalid or negative."));
			set_focus('amount'.$counter);
			return false;
		 }

		  /* Now check to see that the AllocAmt is no greater than the
		 amount left to be allocated against the transaction under review;
		 skip check if no allocation is set to avoid deadlock on mistakenly overallocated transactions*/
		 $allocated = input_num('amount' . $counter);
		 if ($allocated && ($allocated > input_num('un_allocated' . $counter)))
		 {
			display_error(_("At least one transaction is overallocated."));
			set_focus('amount'.$counter);
			return false;
		 }

		 $_SESSION['alloc']->allocs[$counter]->current_allocated = input_num('amount' . $counter);

		 $total_allocated += input_num('amount' . $counter);
	}
/*
	$amount = $_SESSION['alloc']->amount;

	if (in_array($_SESSION['alloc']->type, array(ST_BANKPAYMENT, ST_SUPPCREDIT, ST_SUPPAYMENT)))
		$amount = -$amount;
*/
	$amount = abs($_SESSION['alloc']->amount);

	/*if ($total_allocated - ($amount + input_num('discount'))  > $SysPrefs->allocation_settled_allowance())
	{
		display_error(_("These allocations cannot be processed because the amount allocated is more than the total amount left to allocate."));
		return false;
	}*/

	return true;
}

function getAllocatedAmount($id)
{
	$sql = "SELECT allocate FROM ".TB_PREF."payroll_payslip WHERE deleted = 0 and id = '$id'";

	$res = db_query($sql,'no record');
	$row = db_fetch($res);
	return $row['allocate'];
}
