<?php

// ------------------------------------------------------------------------------

function get_supplier_details_to_order(&$order, $supplier_id)
{
	$sql = "SELECT curr_code, supp_name, tax_group_id, supp.tax_included,supp.charge_group,
			supp.credit_limit - Sum(IFNULL(IF(trans.type=".ST_SUPPCREDIT.", -1, 1) 
				* (ov_amount + ov_gst + ov_discount),0)) as cur_credit,
				terms.terms, terms.days_before_due, terms.day_in_following_month
		FROM ".TB_PREF."suppliers supp
			 LEFT JOIN ".TB_PREF."supp_trans trans ON supp.supplier_id = trans.supplier_id
			 LEFT JOIN ".TB_PREF."payment_terms terms ON supp.payment_terms=terms.terms_indicator
		WHERE supp.supplier_id = ".db_escape($supplier_id)."
		GROUP BY
			  supp.supp_name";

	$result = db_query($sql, "The supplier details could not be retreived");
	$myrow = db_fetch($result);

	$order->credit = $myrow["cur_credit"];
	$order->terms = array( 
		'description' => $myrow['terms'],
		'days_before_due' => $myrow['days_before_due'], 
		'day_in_following_month' => $myrow['day_in_following_month'] );

	$_POST['supplier_id'] = $supplier_id;
	$_POST['supplier_name'] = $myrow["supp_name"];
	$_POST['curr_code'] = $myrow["curr_code"];

	$order->set_supplier($supplier_id, $myrow["supp_name"], $myrow["curr_code"], 
		$myrow["tax_group_id"], $myrow["tax_included"], $myrow['charge_group']);
}

//----------------------------------------------------------------------------------------

function delete_po($po)
{
	global $Refs;

	begin_transaction();
	hook_db_prevoid($po, ST_PURCHORDER);
	$sql = "DELETE FROM ".TB_PREF."purch_orders WHERE order_no=".db_escape($po);
	db_query($sql, "The order header could not be deleted");

	$sql = "DELETE FROM ".TB_PREF."purch_order_details WHERE order_no =".db_escape($po);
	db_query($sql, "The order detail lines could not be deleted");

	$Refs->restore_last(ST_PURCHORDER, $po);
	add_audit_trail(ST_PURCHORDER, $po, Today(), _("Delete Purchase Order"));
	commit_transaction();
}

//----------------------------------------------------------------------------------------

function add_po(&$po_obj)
{
	global $Refs;

	begin_transaction();
	hook_db_prewrite($po_obj, ST_PURCHORDER);

     /*Insert to purchase order header record */
     $sql = "INSERT INTO ".TB_PREF."purch_orders (supplier_id, Comments, ord_date, reference, 
     	requisition_no, into_stock_location, delivery_address, total, tax_included, 
     	prep_amount, charge_group, dimension_id, dimension2_id) VALUES(";
     $sql .= db_escape($po_obj->supplier_id) . "," .
         db_escape($po_obj->Comments) . ",'" .
         date2sql($po_obj->orig_order_date) . "', " .
		 db_escape($po_obj->reference) . ", " .
         db_escape($po_obj->supp_ref) . ", " .
         db_escape($po_obj->Location) . ", " .
         db_escape($po_obj->delivery_address) . ", " .
         db_escape($po_obj->get_trans_total()). ", " .
         db_escape($po_obj->tax_included). ", " .
         db_escape($po_obj->prep_amount). ",".
         db_escape($po_obj->charge_group).",".
         db_escape($po_obj->dimension).",".
         db_escape($po_obj->dimension2).")";

	db_query($sql, "The purchase order header record could not be inserted");

     /*Get the auto increment value of the order number created from the sql above */
     $po_obj->order_no = db_insert_id();

     /*Insert the purchase order detail records */
     foreach ($po_obj->line_items as $line_no => $po_line)
     {
		$sql = "INSERT INTO ".TB_PREF."purch_order_details (order_no, item_code, description, delivery_date,	unit_price,	quantity_ordered, charge_amount, long_description, discount, discount_perc) VALUES (";
		$sql .= $po_obj->order_no . ", " . db_escape($po_line->stock_id). "," .
		db_escape($po_line->item_description). ",'" .
		date2sql($po_line->req_del_date) . "'," .
		db_escape($po_line->price) . ", " .
		db_escape($po_line->quantity). ", ".
		db_escape($po_line->charge).", ".
		db_escape($po_line->long_description).", ".
		db_escape($po_line->discount).", ".
		db_escape($po_line->discount_perc).")";
		db_query($sql, "One of the purchase order detail records could not be inserted");
		$po_obj->line_items[$line_no]->po_detail_rec = db_insert_id();
     }

	$Refs->save(ST_PURCHORDER, $po_obj->order_no, $po_obj->reference);
	if ($po_obj->fixed_asset) {
	 add_audit_trail(ST_PURCHORDER, $po_obj->order_no, $po_obj->orig_order_date, _("Create FA Auto Purchase Order"), $po_obj->get_trans_total());
	}else if ($po_obj->reference == 'auto') {
    add_audit_trail(ST_PURCHORDER, $po_obj->order_no, $po_obj->orig_order_date, _("Create Auto Purchase Order"), $po_obj->get_trans_total());
    }else{

	add_audit_trail(ST_PURCHORDER, $po_obj->order_no, $po_obj->orig_order_date, _("Create New Purchase Order"), $po_obj->get_trans_total());
    }
	hook_db_postwrite($po_obj, ST_PURCHORDER);
	commit_transaction();

	return $po_obj->order_no;
}

//----------------------------------------------------------------------------------------

function update_po(&$po_obj)
{
	begin_transaction();
	hook_db_prewrite($po_obj, ST_PURCHORDER);

    /*Update the purchase order header with any changes */
    $sql = "UPDATE ".TB_PREF."purch_orders SET Comments=" . db_escape($po_obj->Comments) . ",
		requisition_no= ". db_escape( $po_obj->supp_ref). ",
		into_stock_location=" . db_escape($po_obj->Location). ",
		ord_date='" . date2sql($po_obj->orig_order_date) . "',
		delivery_address=" . db_escape($po_obj->delivery_address).",
		total=". db_escape($po_obj->get_trans_total()).",
		prep_amount=". db_escape($po_obj->prep_amount).",
		supplier_id=". db_escape($po_obj->supplier_id).",
		dimension_id=". db_escape($po_obj->dimension).",
		tax_included=". db_escape($po_obj->tax_included);
    $sql .= " WHERE order_no = " . $po_obj->order_no;
	db_query($sql, "The purchase order could not be updated");

	$sql = "DELETE FROM ".TB_PREF."purch_order_details WHERE order_no="
		.db_escape($po_obj->order_no);
	db_query($sql, "could not delete old purch order details");

    /*Now Update the purchase order detail records */
    foreach ($po_obj->line_items as $po_line)
    {
    	$sql = "INSERT INTO ".TB_PREF."purch_order_details (po_detail_item, order_no, item_code, description, delivery_date, unit_price, quantity_ordered, quantity_received, charge_amount, long_description, discount, discount_perc) VALUES ("
			.db_escape($po_line->po_detail_rec ? $po_line->po_detail_rec : 0). ","
			.$po_obj->order_no . ","
			.db_escape($po_line->stock_id). ","
			.db_escape($po_line->item_description). ",'"
			.date2sql($po_line->req_del_date) . "',"
			.db_escape($po_line->price) . ", "
			.db_escape($po_line->quantity) . ", "
			.db_escape($po_line->qty_received) . ", "
			.db_escape($po_line->charge).", "
			.db_escape($po_line->long_description).", "
			.db_escape($po_line->discount).", "
			.db_escape($po_line->discount_perc).")";
		db_query($sql, "One of the purchase order detail records could not be updated");
    }

	reallocate_payments($po_obj->order_no, ST_PURCHORDER, $po_obj->orig_order_date, $po_obj->get_trans_total(), $po_obj->prepayments, $po_obj->supplier_id);

	add_audit_trail($po_obj->trans_type, $po_obj->order_no, Today(), _("Update Purchase Order"), $po_obj->get_trans_total());
	hook_db_postwrite($po_obj, ST_PURCHORDER);
	commit_transaction();

	return $po_obj->order_no;
}

//----------------------------------------------------------------------------------------

function read_po_header($order_no, &$order)
{
    	$sql = "SELECT po.*, po.charge_group AS cg, supplier.*, loc.location_name, po.dimension_id as po_dimension  
		FROM ".TB_PREF."purch_orders po,"
			.TB_PREF."suppliers supplier,"
			.TB_PREF."locations loc
		WHERE po.supplier_id = supplier.supplier_id
		AND loc.loc_code = into_stock_location
		AND po.order_no = ".db_escape($order_no);

   	$result = db_query($sql, "The order cannot be retrieved");

	if (db_num_rows($result) == 1)
	{

      	$myrow = db_fetch($result);

      	$order->trans_type = ST_PURCHORDER;
      	$order->order_no = $order_no;
      	
      	$dropdown_language = $_SESSION['wa_current_user']->dropdown_language; // 2 arabic // 1 English
		if($dropdown_language == 2 && !empty($myrow["supp_name_arabic"]))
		$supp_name = $myrow["supp_name_arabic"];
		else
		$supp_name = $myrow["supp_name"];

      	$order->set_supplier($myrow["supplier_id"], $supp_name, $myrow["curr_code"],
      		$myrow['tax_group_id'], $myrow["tax_included"], $myrow['cg']);

		$order->credit = get_current_supp_credit($order->supplier_id);

		$order->approvedLPO = $myrow["approved"];
      	$order->orig_order_date = sql2date($myrow["ord_date"]);
      	$order->Comments = nl2br($myrow["comments"]);
      	$order->Location = $myrow["into_stock_location"];
      	$order->supp_ref = $myrow["requisition_no"];
      	$order->reference = $myrow["reference"];
      	$order->delivery_address = $myrow["delivery_address"];
      	$order->alloc = $myrow["alloc"];
      	$order->prep_amount = $myrow["prep_amount"];
      	$order->dimension = $myrow["po_dimension"];
      	$order->prepayments = get_payments_for($order_no, ST_PURCHORDER, $myrow["supplier_id"]);

      	return true;
	}

	display_db_error("FATAL : duplicate purchase order found", "", true);
	return false;
}

//----------------------------------------------------------------------------------------

function read_po_items($order_no, &$order, $open_items_only=false)
{
	/*now populate the line po array with the purchase order details records */

	$sql = "SELECT poline.*, units
		FROM ".TB_PREF."purch_order_details poline
			LEFT JOIN ".TB_PREF."stock_master item	ON poline.item_code=item.stock_id
		WHERE order_no =".db_escape($order_no);

    if ($open_items_only)
 		$sql .= " AND (poline.quantity_ordered > poline.quantity_received) ";

	$sql .= " ORDER BY po_detail_item";

	$result = db_query($sql, "The lines on the purchase order cannot be retrieved");

    if (db_num_rows($result) > 0)
    {
		while ($myrow = db_fetch($result))
        {
        	$data = get_purchase_data($order->supplier_id, $myrow['item_code']);
        	if ($data !== false)
        	{
        		if ($data['supplier_description'] != "")
        			$myrow['description'] = $data['supplier_description'];
        	}		
            if (is_null($myrow["units"]))
            {
		       	$units = "";
            }
            else
            {
                $units = $myrow["units"];
            }

            if ($order->add_to_order($order->lines_on_order, $myrow["item_code"],
            	$myrow["quantity_ordered"],$myrow["description"],
            	$myrow["unit_price"],$units, sql2date($myrow["delivery_date"]),
            	$myrow["qty_invoiced"], $myrow["quantity_received"], $myrow['charge_amount'], $myrow['long_description'], $myrow['discount_perc'])) {
				$order->line_items[$order->lines_on_order-1]->po_detail_rec = $myrow["po_detail_item"];
			}
        } /* line po from purchase order details */
    } //end of checks on returned data set
}

//----------------------------------------------------------------------------------------

function read_po($order_no, &$order, $open_items_only=false)
{
	$result = read_po_header($order_no, $order);

	if ($result)
		read_po_items($order_no, $order, $open_items_only);
}

//----------------------------------------------------------------------------------------

function get_po_items($order_no)
{
	$sql = "SELECT item_code, quantity_ordered, quantity_received, qty_invoiced
		FROM ".TB_PREF."purch_order_details
		WHERE order_no=".db_escape($order_no)
		." ORDER BY po_detail_item";

	$result = db_query($sql, "could not query purch order details");
    check_db_error("Could not check that the details of the purchase order had not been changed by another user ", $sql);
    return $result;
}
//----------------------------------------------------------------------------------------

function get_short_info($stock_id)
{
	$sql = "SELECT description, units, mb_flag
		FROM ".TB_PREF."stock_master WHERE stock_id = ".db_escape($stock_id);

	return db_query($sql,"The stock details for " . $stock_id . " could not be retrieved");
}

function get_sql_for_po_search_completed($from, $to, $supplier_id=ALL_TEXT, $location=ALL_TEXT,
	$order_number = '', $stock_id = '', $also_closed=false, $ref=null, $showUnApproved=0, $dimension_id=null)
{
	if($showUnApproved == 0)
		$approved = 1;
	elseif($showUnApproved == 1)
		$approved = 0;

	$sql = "SELECT 
		porder.order_no, 
		porder.reference, 
		supplier.supp_name, 
		location.location_name,
		porder.requisition_no, 
		porder.ord_date, 
		supplier.curr_code, 
		Sum(( line.unit_price*line.quantity_ordered ) - line.discount) AS OrderValue,
		porder.into_stock_location,
		chk.isopen,line.delivery_date,
		line.quantity_received,line.quantity_ordered,
		porder.dimension_id 
		FROM ".TB_PREF."purch_orders as porder
				LEFT JOIN (
					SELECT order_no, SUM(quantity_ordered-quantity_received + quantity_ordered-qty_invoiced) isopen
					FROM ".TB_PREF."purch_order_details
					GROUP BY order_no
				) chk ON chk.order_no=porder.order_no,"
			.TB_PREF."purch_order_details as line, "
			.TB_PREF."suppliers as supplier, "
			.TB_PREF."locations as location
		WHERE porder.order_no = line.order_no
		AND porder.supplier_id = supplier.supplier_id
		AND location.loc_code = porder.into_stock_location ";

	if ($supplier_id != ALL_TEXT)
		$sql .= "AND supplier.supplier_id=".$supplier_id." ";
	if ($ref != null)
   		$sql .= " AND porder.reference LIKE ".db_escape('%' . $ref . '%')." ";
	if ($order_number != "")
	{
		$sql .= "AND porder.order_no LIKE ".db_escape('%'. $order_number . '%');
	}
	else
	{

		$data_after = date2sql($from);
		$date_before = date2sql($to);

		$sql .= " AND porder.ord_date >= '$data_after'";
		$sql .= " AND porder.ord_date <= '$date_before'";

		if ($location != ALL_TEXT)
		{
			$sql .= " AND porder.into_stock_location = ".db_escape($location);
		}
		if ($stock_id !== '')
		{
			$sql .= " AND line.item_code=".db_escape($stock_id);
		}
		if ($supplier_id != ALL_TEXT)
			$sql .= " AND supplier.supplier_id=".db_escape($supplier_id);

	}

	if (!$also_closed)
		$sql .= " AND isopen";
	
	$sql .= " AND porder.approved = ".db_escape($approved);	
	
	if($dimension_id)
		$sql .= " AND porder.dimension_id = ".db_escape($dimension_id);	

	$sql .= "  AND (IF(porder.reference = 'auto',  approve_status = 1, 1 )) ";

	$sql .= " GROUP BY porder.order_no";
	return $sql;
}

function get_sql_for_inventry($from, $to, $Fromlocation=ALL_TEXT, $Tolocation=ALL_TEXT,
	$order_number = '', $stock_id = '' ,$type = '')

{ 
     if($type==ST_LOCTRANSFER)
	 $sql="SELECT sm1.trans_no, sm1.type, sm1.reference, sm1.loc_code ,sm2.loc_code as loc_code2, sm1.tran_date FROM ".TB_PREF."stock_moves sm1 LEFT JOIN ".TB_PREF."stock_moves sm2 on sm2.trans_no=sm1.trans_no AND sm2.stock_id=sm1.stock_id AND sm2.qty>0 WHERE sm1.type IN (16,17) AND sm1.qty<0";
      else
      $sql="SELECT sm1.trans_no, sm1.type, sm1.reference, sm1.loc_code ,null as loc_code2, sm1.tran_date FROM ".TB_PREF."stock_moves sm1 WHERE type=".db_escape($type);

   	if ($order_number != "")
	{
		$sql .= " AND  CONCAT(sm1.trans_no, ' ', sm1.reference) LIKE ".db_escape('%'. $order_number . '%');
		if ($type !== '')
		{
			$sql .= " AND sm1.type=".db_escape($type);
		}
	}
	else
	{

		$data_after = date2sql($from);
		$date_before = date2sql($to);

		$sql .= " AND sm1.tran_date >= '$data_after'";
		$sql .= " AND sm1.tran_date <= '$date_before'";

		if ($Fromlocation != ALL_TEXT)
		{
			$sql .= " AND sm1.loc_code = ".db_escape($Fromlocation);
		}
		if ($Tolocation != ALL_TEXT)
		{
			$sql .= " AND sm2.loc_code = ".db_escape($Tolocation);
		}
		if ($stock_id !== '')
		{
			$sql .= " AND sm1.stock_id=".db_escape($stock_id);

		}
		if ($type !== '')
		{
			$sql .= " AND sm1.type=".db_escape($type);
		}
		// if ($supplier_id != ALL_TEXT)
		// 	$sql .= " AND supplier.supplier_id=".db_escape($supplier_id);

	}


     $sql.=" GROUP by sm1.trans_no ";
   //display_error($sql);
     	return $sql;

}

function get_sql_for_po_search($from, $to, $supplier_id=ALL_TEXT, $location=ALL_TEXT, $order_number='', $stock_id='')
{
	$sql = "SELECT 
		porder.order_no, 
		porder.reference,
		supplier.supp_name, 
		location.location_name,
		porder.requisition_no, 
		porder.ord_date,
		supplier.curr_code,
		Sum(( line.unit_price*line.quantity_ordered ) - line.discount) AS OrderValue,
		Sum(line.delivery_date < '". date2sql(Today()) ."'
		AND (line.quantity_ordered > line.quantity_received)) As OverDue
		FROM ".TB_PREF."purch_orders as porder,"
			.TB_PREF."purch_order_details as line, "
			.TB_PREF."suppliers as supplier, "
			.TB_PREF."locations as location
		WHERE porder.order_no = line.order_no
		AND porder.supplier_id = supplier.supplier_id
		AND location.loc_code = porder.into_stock_location
		AND (line.quantity_ordered > line.quantity_received) ";

	if ($order_number != "")
	{
		$sql .= "AND porder.reference LIKE ".db_escape('%'. $order_number . '%');
	}
	else
	{
		$data_after = date2sql($from);
		$data_before = date2sql($to);

		$sql .= "  AND porder.ord_date >= '$data_after'";
		$sql .= "  AND porder.ord_date <= '$data_before'";

		if ($location != ALL_TEXT)
		{
			$sql .= " AND porder.into_stock_location = ".db_escape($location);
		}

		if ($stock_id != '')
		{
			$sql .= " AND line.item_code=".db_escape($stock_id);
		}
		if ($supplier_id != ALL_TEXT)
			$sql .= " AND supplier.supplier_id=".db_escape($supplier_id);
	} //end not order number selected

	$sql .= " GROUP BY porder.order_no";
	return $sql;
}


function GetPOSumByDimension($dimension_id, $order_no=null){
    $sql = " SELECT SUM(total) as amount FROM ".TB_PREF."purch_orders 
             WHERE dimension_id = ".db_escape($dimension_id)." AND total != 0 ";
    if($order_no)
	    $sql .= " AND order_no != ".db_escape($order_no);
    $result = db_query($sql);
    return db_fetch($result)['amount'];
}


