<?php

function add_requisition($point_of_use, $narrative, $details,$user_id,$user_location)
{
	$sql = "INSERT INTO ".TB_PREF."material_requisition (point_of_use, narrative, details,user_name,user_location) VALUES (".
		db_escape($point_of_use).",".db_escape($narrative).",".db_escape($details).",".db_escape($user_id).",".db_escape($user_location).")";

	db_query($sql, "could not add requisitions");
	add_audit_trail(103, db_insert_id(), Today(), _('MR Request Added'));
}

function update_requisition($selected_id, $point_of_use, $narrative, $details,$user_id,$user_location)
{
	$sql = "UPDATE ".TB_PREF."material_requisition SET point_of_use=".db_escape($point_of_use)
			.", narrative=".db_escape($narrative)
			.", details=".db_escape($details).", 
                            user_name = ".db_escape($user_id).",
                             user_location = ".db_escape($user_location)
			."WHERE material_req_id =".db_escape($selected_id);

	db_query($sql, "could not update Requisition");
add_audit_trail(103, $selected_id,Today(), _('MR Request Updated'));
}

function get_all_requisitions($all=false,$user_name)
{
	$sql = "SELECT * FROM ".TB_PREF."material_requisition WHERE (completed = 0) AND user_name = '$user_name'";
	if (!$all) $sql .= " AND !inactive";

	return db_query($sql, "could not get all requisitions");

}

function get_one_requisition($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."material_requisition WHERE material_req_id =".db_escape($selected_id);

	return db_query($sql, "could not get Requisition");
}

function get_requisition($selected_id)
{
	$sql = "SELECT * FROM ".TB_PREF."material_requisition WHERE material_req_id =".db_escape($selected_id);

	$result = db_query($sql, "could not get Requisition");

	return db_fetch($result);
}

function delete_requisition($selected_id)
{
	$sql="DELETE FROM ".TB_PREF."material_requisition WHERE material_req_id =".db_escape($selected_id);

	db_query($sql, "could not delete Requisition");
add_audit_trail(103, $selected_id,Today(), _('MR Deleted'));
}

function complete_requisition($selected_id)
{
	$sql = "UPDATE ".TB_PREF."material_requisition SET completed =  1 WHERE material_req_id =".db_escape($selected_id);

	db_query($sql, "could not complete Requisition");
	add_audit_trail(103, $selected_id, Today(), _('MR Request Completed'));
}

function generate_po()
{
	$sql = "SELECT ".TB_PREF."generate_po()";

	$result = db_query($sql, "could not process Requisition to Purchase Order");
	$row = db_fetch($result);
	return $row[0] == 'Done';
}

function requisitions_in_details($selected_id)
{
	$sql="SELECT COUNT(*) FROM ".TB_PREF."material_req_details WHERE material_req_id =".db_escape($selected_id);

	$result = db_query($sql, "could not query assets");
	$myrow = db_fetch_row($result);
	return ($myrow[0] > 0); 
}
function get_user_location($id){

$sql  = " SELECT loc.location_name FROM ".TB_PREF."users AS user 
                                   LEFT JOIN ".TB_PREF."locations AS loc ON loc.loc_code = user.user_location
                WHERE user.id = '$id' ";
         $result = db_query($sql, "could not query assets");
	$myrow = db_fetch($result);
	return $myrow['location_name']; 
}

function update_transfer_requision_location($selected_id, $from_location, $from_user, $date, $stock_transfer_id){

	$sql = "UPDATE ".TB_PREF."material_requisition SET from_location=".db_escape($from_location)
			.", from_user = ".db_escape($from_user).", transaction_date = ".db_escape($date).", stock_moves_id = ".db_escape($stock_transfer_id)." WHERE material_req_id =".db_escape($selected_id);

	db_query($sql, "could not update Requisition");
}

?>
