<?php

function write_supp_payment($trans_no, $supplier_id, $bank_account,
	$date_, $ref, $supp_amount, $supp_discount, $memo_, $bank_charge=0, $bank_amount=0, $pdcStatus=null, $pdcDate=null,$against=0, $fixed_asset, $charge_group=0, $dimension=0, $dimension2=0, $party_name=null, $ac_payee=null)
{
	global $Refs;

		if($pdcStatus =='' || $pdcStatus ==null)
		$pdcStatus =0;
	

	
	if($pdcDate !=null)
		$pdcDate =date2sql($pdcDate);

	

	begin_transaction();
	$args = func_get_args(); while (count($args) < 10) $args[] = 0;
	$args = (object)array_combine(array('trans_no', 'supplier_id', 'bank_account', 'date_',
		 'ref', 'bank_amount', 'supp_amount', 'supp_discount', 'memo_', 'bank_charge'), $args);
	$args->trans_no = 0;
	hook_db_prewrite( $args, ST_SUPPAYMENT);

	if ($trans_no != 0) {
	  delete_comments(ST_SUPPAYMENT, $trans_no);
	  void_bank_trans(ST_SUPPAYMENT, $trans_no, true);
	  void_gl_trans(ST_SUPPAYMENT, $trans_no, true);
	  void_cust_allocations(ST_SUPPAYMENT, $trans_no, $date_);
	}

	$bank = get_bank_account($bank_account);

	if (!$bank_amount) 	// auto 
	{
		$rate = get_exchange_rate_from_to(get_supplier_currency($supplier_id),
			$bank['bank_curr_code'], $date_ );
		$bank_amount = $supp_amount/$rate;
	}

	if ($bank['bank_curr_code'] == get_company_currency()) // [0002506]
		$rate = $bank_amount/$supp_amount;
	else
		$rate = 0;

	/* Create a supp_trans entry for the supplier payment */
	$payment_id = write_supp_trans(ST_SUPPAYMENT, 0, $supplier_id, $date_, $date_,
		$ref, "", -$supp_amount, 0, -$supp_discount, "", $rate,0,0,0,$against,0,0, $dimension, $dimension2, $pdcStatus, $pdcDate, $party_name, $ac_payee);

	// Now debit creditors account with payment + discount

	$total = 0;
    $supplier_accounts = get_supplier_accounts($supplier_id);
	$total += add_gl_trans_supplier(ST_SUPPAYMENT, $payment_id, $date_, $supplier_accounts["payable_account"], $dimension, $dimension2,
		$supp_amount + $supp_discount, $supplier_id, "", $rate);

	// Now credit discount received account with discounts
	if ($supp_discount != 0)
	{
		$total += add_gl_trans_supplier(ST_SUPPAYMENT, $payment_id, $date_, $supplier_accounts["payment_discount_account"], $dimension, $dimension2,
			-$supp_discount, $supplier_id, "", $rate);
	}

	if ($bank_charge != 0)
	{
		if($bank['bank_charge_act'])
			$charge_act = $bank['bank_charge_act'];
		else
			$charge_act = get_company_pref('bank_charge_act');
		
		$total += add_gl_trans(ST_SUPPAYMENT, $payment_id, $date_, $charge_act, $dimension, $dimension2, '',
			$bank_charge, $bank['bank_curr_code']);
	}

	$total += add_gl_trans(ST_SUPPAYMENT, $payment_id, $date_, $bank['account_code'], $dimension, $dimension2, '',
		-($bank_amount + $bank_charge), $bank['bank_curr_code'], PT_SUPPLIER, $supplier_id);

	/*Post a balance post if $total != 0 due to variance in AP and bank posted values*/
	if ($total != 0)
	{
		$variance_act = get_company_pref('exchange_diff_act');
		add_gl_trans(ST_SUPPAYMENT, $payment_id, $date_, $variance_act, $dimension, $dimension2, '',
			-$total, null, PT_SUPPLIER,  $supplier_id);
	}
   /*now enter the bank_trans entry */
   	// add_bank_trans(ST_CUSTPAYMENT, $payment_no, $bank_account, $ref,
		// $date_, $bank_amount - $charge, PT_CUSTOMER, $customer_id, null, null, null, null, null, $pdcStatus, $pdcDate);
   	
	add_bank_trans(ST_SUPPAYMENT, $payment_id, $bank_account, $ref,
		$date_, -($bank_amount + $bank_charge), PT_SUPPLIER, $supplier_id, null, null, null, null, null, $pdcStatus, $pdcDate, null, null, $party_name, $ac_payee);

	add_comments(ST_SUPPAYMENT, $payment_id, $date_, $memo_);
// 	display_error($dimension);
// 	display_error($dimension2);
// exit();

	$Refs->save(ST_SUPPAYMENT, $payment_id, $ref);

	$args->trans_no = $payment_id;
	hook_db_postwrite($args, ST_SUPPAYMENT);

	commit_transaction();

	return $payment_id;
}

//------------------------------------------------------------------------------------------------

function void_supp_payment($type, $type_no)
{
	begin_transaction();
	hook_db_prevoid($type, $type_no);

	void_bank_trans($type, $type_no, true);
	void_gl_trans($type, $type_no, true);
	void_supp_allocations($type, $type_no);
	void_supp_trans($type, $type_no);

	commit_transaction();
}


