<?php


function add_supplier($supp_name, $supp_ref, $address, $supp_address, $gst_no,
	$website, $supp_account_no, $bank_account, $credit_limit, $dimension_id, $dimension2_id, 
	$curr_code, $payment_terms, $payable_account, $purchase_account, $payment_discount_account, 
	$notes, $tax_group_id, $tax_included,$supp_name_arabic,$supp_ref_arabic,$designated_zone,
	$charge_group,$cp_acc1='',$cp_acc2='',$cp_acc3='',$cp_acc4='',$cp_acc5='',$cp_acc6='',$cp_acc7='',$cp_acc8='',$cp_acc9='',$cp_acc10=''){
	$sql = "INSERT INTO ".TB_PREF."suppliers (supp_name, supp_ref, address, supp_address, gst_no, website, supp_account_no, bank_account, credit_limit, dimension_id, dimension2_id, curr_code, payment_terms, payable_account, purchase_account, payment_discount_account, notes, tax_group_id, tax_included, supp_name_arabic, supp_ref_arabic, designated_zone, charge_group,cp_acc1,cp_acc2,cp_acc3,cp_acc4,cp_acc5,cp_acc6,cp_acc7,cp_acc8,cp_acc9,cp_acc10)
		VALUES (".db_escape($supp_name). ", "
		.db_escape($supp_ref). ", "
		.db_escape($address) . ", "
		.db_escape($supp_address) . ", "
		.db_escape($gst_no). ", "
		.db_escape($website). ", "
		.db_escape($supp_account_no). ", "
		.db_escape($bank_account). ", "
		.$credit_limit. ", "
		.db_escape($dimension_id). ", "
		.db_escape($dimension2_id). ", "
		.db_escape($curr_code). ", "
		.db_escape($payment_terms). ", "
		.db_escape($payable_account). ", "
		.db_escape($purchase_account). ", "
		.db_escape($payment_discount_account). ", "
		.db_escape($notes). ", "
		.db_escape($tax_group_id). ", "
		.db_escape($tax_included). ", "
		.db_escape($supp_name_arabic). ", "
		.db_escape($supp_ref_arabic). ", "
		.db_escape($designated_zone). ","
		.db_escape($charge_group).","
		.db_escape($cp_acc1). ", "
		.db_escape($cp_acc2). ", "
		.db_escape($cp_acc3). ", "
		.db_escape($cp_acc4). ", "
		.db_escape($cp_acc5). ", "
		.db_escape($cp_acc6). ", "
		.db_escape($cp_acc7). ", "
		.db_escape($cp_acc8). ", "
		.db_escape($cp_acc9). ", "
		.db_escape($cp_acc10). ")";;

	db_query($sql,"The supplier could not be added");

	$sql2 = "SELECT MAX(supplier_id) AS id FROM ".TB_PREF."suppliers";
    $result2 = db_query($sql2);
    $myrow2 = db_fetch($result2);

	add_audit_trail(SM_SUPPLIERS, $myrow2['id'], Today(), _("Add New Supplier"));
	return $myrow2['id'];
}

function update_supplier($supplier_id, $supp_name, $supp_ref, $address, $supp_address, $gst_no, 
	$website, $supp_account_no, $bank_account, $credit_limit, $dimension_id, $dimension2_id, 
	$curr_code, $payment_terms, $payable_account, $purchase_account, $payment_discount_account, 
	$notes, $tax_group_id, $tax_included,$supp_name_arabic,$supp_ref_arabic,$designated_zone, 
	$charge_group,$is_employee=0,$cp_acc1='',$cp_acc2='',$cp_acc3='',$cp_acc4='',$cp_acc5='',$cp_acc6='',$cp_acc7='',$cp_acc8='',$cp_acc9='',$cp_acc10='')
{
	$sql = "UPDATE ".TB_PREF."suppliers SET supp_name=".db_escape($supp_name) . ",
		supp_ref=".db_escape($supp_ref) . ",
		address=".db_escape($address) . ",
		supp_address=".db_escape($supp_address) . ",
		gst_no=".db_escape($gst_no) . ",
		website=".db_escape($website) . ",
		supp_account_no=".db_escape($supp_account_no) . ",
		bank_account=".db_escape($bank_account) . ",
		credit_limit=".$credit_limit . ",
		dimension_id=".db_escape($dimension_id) . ",
		dimension2_id=".db_escape($dimension2_id) . ",
		curr_code=".db_escape($curr_code).",
		payment_terms=".db_escape($payment_terms) . ",
		payable_account=".db_escape($payable_account) . ",
		purchase_account=".db_escape($purchase_account) . ",
		payment_discount_account=".db_escape($payment_discount_account) . ",
		notes=".db_escape($notes) . ",
		tax_group_id=".db_escape($tax_group_id). ",
		tax_included=".db_escape($tax_included).",
		supp_name_arabic=".db_escape($supp_name_arabic).",
		designated_zone=".db_escape($designated_zone).",
		supp_ref_arabic=".db_escape($supp_ref_arabic).",
		charge_group=".db_escape($charge_group).",
		is_employee=".db_escape($is_employee).",
		cp_acc1=".db_escape($cp_acc1).",
		cp_acc2=".db_escape($cp_acc2).",
		cp_acc3=".db_escape($cp_acc3).",
		cp_acc4=".db_escape($cp_acc4).",
		cp_acc5=".db_escape($cp_acc5).",
		cp_acc6=".db_escape($cp_acc6).",
		cp_acc7=".db_escape($cp_acc7).",
		cp_acc8=".db_escape($cp_acc8).",
		cp_acc9=".db_escape($cp_acc9).",
		cp_acc10=".db_escape($cp_acc10)."
		WHERE supplier_id = ".db_escape($supplier_id);

	db_query($sql,"The supplier could not be updated");

    add_audit_trail(SM_SUPPLIERS, $supplier_id, Today(), _("Update Supplier"));
}

function delete_supplier($supplier_id)
{
	$sql="DELETE FROM ".TB_PREF."suppliers WHERE supplier_id=".db_escape($supplier_id);
	db_query($sql,"check failed");

	add_audit_trail(SM_SUPPLIERS, $supplier_id, Today(), _("Delete Supplier"));
}

function get_supplier_details($supplier_id, $to=null, $all=true)
{

	if ($to == null)
		$todate = date("Y-m-d");
	else
		$todate = date2sql($to);
	$past1 = get_company_pref('past_due_days');
	$past2 = 2 * $past1;
	// removed - supp_trans.alloc from all summations

	if ($all)
    	$value = "(trans.ov_amount + trans.ov_gst - trans.ov_discount)";
    else	
    	$value = "IF (trans.type=".ST_SUPPINVOICE." OR trans.type=".ST_BANKDEPOSIT."
  	OR (trans.type=".ST_JOURNAL." AND (trans.ov_amount + trans.ov_gst - trans.ov_discount)>0), 1, -1)*
    		ABS(trans.ov_amount + trans.ov_gst + trans.ov_discount) - trans.alloc)";

	$due = "IF (trans.type=".ST_SUPPINVOICE." OR trans.type=".ST_SUPPCREDIT.",trans.due_date,trans.tran_date)";
    $sql = "SELECT supp.supp_name, supp.curr_code, ".TB_PREF."payment_terms.terms,

		Sum(IFNULL($value,0)) AS Balance,

		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) > 0,$value,0)) AS Due,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) > $past1,$value,0)) AS Overdue1,
		Sum(IF ((TO_DAYS('$todate') - TO_DAYS($due)) > $past2,$value,0)) AS Overdue2,
		supp.credit_limit - Sum(IFNULL(IF(trans.type=".ST_SUPPCREDIT.", -1, 1) 
			* (ov_amount + ov_gst + ov_discount),0)) as cur_credit,
		supp.tax_group_id

		FROM ".TB_PREF."suppliers supp
			 LEFT JOIN ".TB_PREF."supp_trans trans ON supp.supplier_id = trans.supplier_id AND trans.tran_date <= '$todate',
			 ".TB_PREF."payment_terms

		WHERE
			 supp.payment_terms = ".TB_PREF."payment_terms.terms_indicator
			 AND supp.supplier_id = $supplier_id ";
	if (!$all)
		$sql .= "AND ABS(trans.ov_amount + trans.ov_gst + trans.ov_discount) - trans.alloc > ".FLOAT_COMP_DELTA." "; 

	$sql .= " AND (IF(trans.type IN (".ST_BANKPAYMENT.", ".ST_SUPPINVOICE.", ".ST_SUPPAYMENT."), trans.approve_status = 1, trans.approve_status = 0 )) ";

	$sql .= "GROUP BY
			  supp.supp_name,
			  ".TB_PREF."payment_terms.terms,
			  ".TB_PREF."payment_terms.days_before_due,
			  ".TB_PREF."payment_terms.day_in_following_month";
    $result = db_query($sql,"The customer details could not be retrieved");
    $supp = db_fetch($result);

    return $supp;
}

function get_supplier($supplier_id)
{
	$sql = "SELECT * FROM ".TB_PREF."suppliers WHERE supplier_id=".db_escape($supplier_id);

	$result = db_query($sql, "could not get supplier");

	return db_fetch($result);
}

function get_supplier_name($supplier_id)
{
	$sql = "SELECT supp_name AS name FROM ".TB_PREF."suppliers WHERE supplier_id=".db_escape($supplier_id);

	$result = db_query($sql, "could not get supplier");

	$row = db_fetch_row($result);

	return $row[0];
}

function get_supplier_accounts($supplier_id)
{
	$sql = "SELECT payable_account,purchase_account,payment_discount_account FROM ".TB_PREF."suppliers WHERE supplier_id=".db_escape($supplier_id);

	$result = db_query($sql, "could not get supplier");

	return db_fetch($result);
}

function get_supplier_contacts($supplier_id, $action=null)
{
	$results = array();
	$res = get_crm_persons('supplier', $action, $supplier_id);
	while($contact = db_fetch($res))
		$results[] = $contact;

	return $results;
}

function get_current_supp_credit($supplier_id)
{
	$suppdet = get_supplier_details($supplier_id);
	return $suppdet['cur_credit'];

}

function is_new_supplier($id)
{
	$tables = array('supp_trans', 'grn_batch', 'purch_orders', 'purch_data');

	return !key_in_foreign_table($id, $tables, 'supplier_id');
}

function get_supplier_currency($supplier_id)
{
    $sql = "SELECT curr_code FROM ".TB_PREF."suppliers WHERE supplier_id = ".db_escape($supplier_id);

	$result = db_query($sql, "Retreive currency of supplier $supplier_id");

	$myrow=db_fetch_row($result);
	return $myrow[0];
}

function get_suppliers_search($supplier)
{
	global $SysPrefs;

	if (isset($SysPrefs->max_rows_in_search))
		$limit = $SysPrefs->max_rows_in_search;
	else
		$limit = 10;

	$sql = "SELECT supplier_id, supp_name, supp_ref, address, gst_no
		FROM ".TB_PREF."suppliers
		WHERE (supp_name LIKE " . db_escape("%" . $supplier. "%") . " OR 
			supp_ref LIKE " . db_escape("%" . $supplier. "%") . " OR 
			address LIKE " . db_escape("%" . $supplier. "%") . " OR 
			gst_no LIKE " . db_escape("%" . $supplier. "%") . ")
		ORDER BY supp_name LIMIT 0,".(int)($limit);

	return db_query($sql, "Failed in retreiving supplier list.");
}

