<?php

/* Definition of the purch_order class to hold all the information for a purchase order and delivery
*/

class purch_order 
{

	var $trans_type; // order/grn/invoice (direct)
	var $line_items;
	var $curr_code;
	var $supp_ref;
	var $delivery_address;
	var $Comments;
	var $Location;
	var $supplier_id;
	var $supplier_name;
	var $orig_order_date;
	var $due_date;
	var $order_no; /*Only used for modification of existing orders otherwise only established when order committed */
	var $lines_on_order = 0;
	var $credit;
	var $tax_group_id;
	var $tax_group_array = null; // saves db queries
	var $tax_included; // type of prices
	var $terms;
	var $ex_rate;
	var $cash_account;
	var $dimension;
	var	$dimension2;
	var $imported=0;           # use for import & amount 
	var $import_price=0; 
    var $import_gl_account=0;  # use for import amount tax debit this glaccount


	var $reference;
	var $tax_overrides = array();		// array of taxes manually inserted during sales invoice entry (direct invoice)
	
	var $prep_amount = 0; // prepayment required
	var $alloc; // sum of payments allocated
	var $prepayments = array();

	var $fixed_asset = false;
    var $approvedLPO;
    var $against;
    var $attachment;
    var $charge_group;
	var $charges;
	var $charge_num;
    
	function __construct()
	{
		/*Constructor function initialises a new purchase order object */
		$this->line_items = array();
		$this->lines_on_order = $this->order_no = $this->supplier_id = 0;
	}
	
	function set_supplier($supplier_id, $supplier_name, $curr_code, $tax_group_id, 
		$tax_included, $charge_group)
	{
		$this->supplier_id = $supplier_id;
		$this->supplier_name = $supplier_name;
		$this->curr_code = $curr_code;
		$this->tax_group_id = $tax_group_id;
		$this->tax_included = $tax_included;
		$this->tax_group_array = get_tax_group_items_as_array($tax_group_id);
		$this->charge_group = $charge_group;
		$this->charge_num = get_supplier_charges_num($this->charge_group);
		$this->create_charges();
	}
	
	function add_to_order($line_no, $stock_id, $qty, $item_descr, $price, $uom, $req_del_date, $qty_inv, $qty_recd, $charge, $long_desc=null, $discount_perc=null)
	{
		if (isset($qty) && $qty != 0)
		{
			$this->line_items[$line_no] = new po_line_details($line_no, $stock_id, $item_descr, $qty, $price, $uom, $req_del_date, $qty_inv, $qty_recd, 0, $charge, $long_desc, $discount_perc);
			$this->lines_on_order++;
			return 1;
		}
		return 0;
	}

	function create_charges(){
		for($index=1;$index<=$this->charge_num;$index++){
			$this->charges[$index] = new line_charges($this->charge_group, $index);
		}
	}
	function get_charge_amount($price=0,$quantity=0){

		$t_amount = 0;
		for($i=1 ;$i<=$this->charge_num;$i++){
			$t_amount += $this->charges[$i]->cal_charge_amount($price, $quantity);
		}
		return $t_amount;
	}

	function update_order_item($line_no, $qty, $price, $req_del_date, $description="",$charge=0, $long_description=null, $discount_perc=null)
	{
		if ($description != "")
			$this->line_items[$line_no]->item_description = $description;
		$this->line_items[$line_no]->quantity = $qty;
		$this->line_items[$line_no]->price = $price;
		$this->line_items[$line_no]->req_del_date = $req_del_date;
		$this->line_items[$line_no]->item_description = $description;
		$this->line_items[$line_no]->charge = $charge;
		$this->line_items[$line_no]->long_description = $long_description;
		$this->line_items[$line_no]->discount_perc = $discount_perc;
		$this->line_items[$line_no]->discount = ($price*$qty) * ($discount_perc/100);
	}

	function remove_from_order($line_no)
	{
		array_splice($this->line_items, $line_no, 1);
	}
	
	function order_has_items() 
	{
		return count($this->line_items) != 0;
	}
	
	function clear_items() 
	{
    	unset($this->line_items);
		$this->line_items = array();
		
		$this->lines_on_order = 0;  
		$this->order_no = 0;
	}

	
	function any_already_received()
	{
		/* Checks if there have been deliveries or invoiced entered against any of the line items */
		if (count($this->line_items) > 0)
		{
		   	foreach ($this->line_items as $ordered_items) 
		   	{
				if ($ordered_items->qty_received != 0 || $ordered_items->qty_inv != 0)
				{
					return 1;
				}
		   	}
		}
		return 0;
	}

	function some_already_received($line_no)
	{
		/* Checks if there have been deliveries or amounts invoiced against a specific line item */
		if (count($this->line_items) > 0)
		{
		   	if ($this->line_items[$line_no]->qty_received != 0 || 
		   		$this->line_items[$line_no]->qty_inv != 0)
		 	{
				return 1;
		   	}
		}
		return 0;
	}
	
	//
	//	Returns taxes for PO/GRN.
	//	$receival=true in purchase receive context.
	//
	function get_taxes($shipping_cost=null, $receival=false, $override_tax=true)
	{
		$items = array();
		$prices = array();
		if($shipping_cost==null)
			$shipping_cost = 0;//$this->freight_cost;

		foreach ($this->line_items as $ln_itm) {
			$items[] = $ln_itm->stock_id;
			$receiving_qty = ($receival ? $ln_itm->receive_qty : $ln_itm->quantity);
			if($receiving_qty!=0)
    			$prices[] = round(($ln_itm->price * $receiving_qty + $ln_itm->charge - $ln_itm->discount),  user_price_dec());
		}
		$taxes = get_tax_for_items($items, $prices, $shipping_cost,
		  $this->tax_group_id, $this->tax_included,  $this->tax_group_array);

    	// Adjustment for swiss franken, we always have 5 rappen = 1/20 franken
	    if ($this->curr_code == 'CHF') {
			$val = $taxes['1']['Value'];
			$val1 = (floatval((intval(round(($val*20),0)))/20));
			$taxes['1']['Value'] = $val1;
		}
		if($override_tax==true){
    		foreach($this->tax_overrides as $id => $value) // add values entered manually
    		{
    			$taxes[$id]['Override'] = $value;
    		}			    
		}
	
		return $taxes;
	}

	/*
		Returns order value including all taxes
	*/
	function get_trans_total() {
		
		$total = 0;
		$dec = user_price_dec();

		foreach ($this->line_items as $ln_itm) {
			$items[] = $ln_itm->stock_id;
			$value = round(($ln_itm->quantity * $ln_itm->price)+$ln_itm->charge, $dec);
			$prices[] =$value;
			$total += $value;
		}

		if (!$this->tax_included ) {
			$taxes = get_tax_for_items($items, $prices, 0, $this->tax_group_id,
			$this->tax_included,  $this->tax_group_array);

			foreach($taxes as $tax)
				$total += round($tax['Value'], $dec);
		}
		return $total;
	}

	function add_to_attachment_cart($line_no, $file_name, $file_type, $file_path, $attach_title=null){
		$this->line_attachment[$line_no] = new line_attachment($file_name, $file_type, $file_path, $attach_title);
		return true;
	}

	function remove_attachment_from_cart($line_no){
		array_splice($this->line_attachment, $line_no, 1);
	}


} /* end of class defintion */

class po_line_details 
{

	var $line_no;
	var $po_detail_rec;
	var $grn_item_id;
	var $stock_id;
	var $item_description;
	var $price;
	var $units;
	var $req_del_date;
	var $tax_type;
	var $tax_type_name;

	var $quantity;		// current/entry quantity of PO line
	var $qty_inv;	// quantity already invoiced against this line
	var $receive_qty;	// current/entry GRN quantity
	var $qty_received;	// quantity already received against this line

	var $standard_cost;
	var $descr_editable;
	var $charge;
	var $long_description;

	function __construct($line_no, $stock_item, $item_descr, $qty, $prc, $uom, $req_del_date, 
		$qty_inv, $qty_recd, $grn_item_id=0, $charge=0, $long_desc=null, $discount_perc=null)
	{

		/* Constructor function to add a new LineDetail object with passed params */
		$this->line_no = $line_no;
		$this->stock_id = $stock_item;
		$item_row = get_item($stock_item);
		if (!$item_row) 
			return;

		$this->descr_editable = $item_row["editable"];
	// if ($item_descr == null || !$this->descr_editable)
	if ($item_descr == null || $this->descr_editable==1 && $this->descr_editable==0)
		$this->item_description = $item_row["description"];
		else
		$this->item_description = $item_descr;


	

		$this->quantity = $qty;
		$this->req_del_date = $req_del_date;
		$this->price = $prc;
//		$this->units = $uom;
		$this->tax_type = $item_row["tax_type_id"];
		$this->tax_type_name = $item_row["tax_type_name"];
		$this->units = $item_row["units"];
		$this->qty_received = $qty_recd;
		$this->qty_inv = $qty_inv;
		$this->receive_qty = 0;	/*initialise these last two only */
		$this->standard_cost =0;
		$this->charge =$charge;
		$this->grn_item_id = $grn_item_id;
		$this->long_description = $long_desc;
		$this->discount_perc = $discount_perc;
		$this->discount =  ($this->price * $this->quantity) * ($discount_perc/100);
	}
	
	// Deprecated, use with care. If you need line value as it is calculated in invoice, use taxfree_charge_value below.
 	function taxfree_charge_price($po)
	{
		return get_tax_free_price_for_item($this->stock_id, $this->price, 
		  $po->tax_group_id, $po->tax_included, $po->tax_group_array);
	}

	//
	// GRN line tax free value.
	//
	function taxfree_charge_value($po)
	{
		return get_tax_free_price_for_item($this->stock_id, $this->receive_qty*$this->price,
		  $po->tax_group_id, $po->tax_included, $po->tax_group_array);
	}
}
//------------------------------------------------------------------------------------------
class line_charges{
	var $name;
	var $formula;
	var $emath;
	var $impact;
	var $gl_account;
	var $amount;
	var $group_id;

	function __construct($charge_group, $index){
		$sql = "SELECT * FROM ".TB_PREF."supp_charges 
		WHERE group_id=".db_escape($charge_group)." LIMIT ".($index-1).",1";
		$row = db_fetch(db_query($sql));
		$this->name = $row['description'];
		$this->formula = $row['formula'];
		$this->impact  = $row['impact'];
		$this->group_id  = $charge_group;
		$this->gl_account = $row['gl_account'];
		$this->emath = new EvalMath();
		$this->emath->suppress_errors = true;
	}

	function cal_charge_amount($price, $quantity){
		//First define value for the variables
		$this->emath->v['Price'] = $price;
		$this->emath->v['Qty'] = $quantity;
		// Now get a formula string by replacing names of all other formula by thier string
		$math_equation = $this->formula;
		$res = get_supp_charges(0, $this->group_id);
        while($row = db_fetch($res)){
            $math_equation = str_replace($row['description'],"(".$row['formula'].")",$math_equation);
        }
        // Need to do it again incase the formula which is replaced by equation previosuly has another formula in it
        $res = get_supp_charges(0, $this->group_id);
        while($row = db_fetch($res)){
            $math_equation = str_replace($row['description'],"(".$row['formula'].")",$math_equation);
        }
        // Calculate the result
		$value = $this->emath->evaluate($math_equation);
		$this->amount = $value;
		if($this->impact)
			return $value;
		else
			return -1*$value; // Multiply by 1 if impact is zero so we get negtaive value which will be subtracted

	}
}


class line_attachment{

	var $file_name;
	var $file_type;
	var $file_path;
	var $attach_title;

	function __construct($file_name,$file_type,$file_path, $attach_title=null){
		$this->file_name = $file_name;
		$this->file_type = $file_type;
		$this->file_path = $file_path;
		$this->attach_title = $attach_title;

	}

}
