<?php

include_once($path_to_root . "/purchasing/includes/purchasing_db.inc");

//--------------------------------------------------------------------------------------------------

function copy_from_cart()
{
	$cart = &$_SESSION['PO'];

	$_POST['supplier_id'] = $cart->supplier_id;
	$_POST['OrderDate'] = $cart->orig_order_date;
	
	if ($cart->trans_type == ST_SUPPINVOICE){	
        $_POST['due_date'] = $cart->due_date;
        $_POST['imported'] = $cart->imported;
        $_POST['import_price'] = $cart->import_price;
        $_POST['import_gl_account'] = $cart->import_gl_account;
    }
    
    $_POST['supp_ref'] = $cart->supp_ref;
    $_POST['ref'] = $cart->reference;
	$_POST['Comments'] = $cart->Comments;
    $_POST['StkLocation'] = $cart->Location;
    $_POST['delivery_address'] = $cart->delivery_address;
	$_POST['prep_amount'] = price_format($cart->prep_amount);
	$_POST['_ex_rate'] = $cart->ex_rate;
	$_POST['cash_account'] = $cart->cash_account;
    $_POST['dimension'] = $cart->dimension;
    $_POST['dimension2'] = $cart->dimension2;
    foreach($cart->tax_overrides as $id => $value)
	    $_POST['mantax'][$id] = price_format($value);
}


function copy_to_cart()
{
	$cart = &$_SESSION['PO'];
// display_error($_POST['StkLocation']);
// die();
	$cart->supplier_id = $_POST['supplier_id'];	
	$cart->orig_order_date = $_POST['OrderDate'];
	if ($cart->trans_type == ST_SUPPINVOICE)
	{
		$cart->due_date = $_POST['due_date'];
				$cart->imported = $_POST['imported'];
			$cart->import_price = $_POST['import_price'];
			
				$cart->import_gl_account = $_POST['import_gl_account'];
		$cart->cash_account = get_post('cash_account');
	}
	$cart->reference = $_POST['ref'];
	$cart->supp_ref = $_POST['supp_ref'];
	$cart->Comments = $_POST['Comments'];	
	$cart->Location = $_POST['StkLocation'];
	$cart->delivery_address = $_POST['delivery_address'];
   	$cart->dimension = @$_POST['dimension'];
	$cart->dimension2 =  @$_POST['dimension2'];
	$cart->prep_amount = input_num('prep_amount', 0);
	$cart->ex_rate = input_num('_ex_rate', null);

    if (isset($_POST['mantax'])) {
		foreach($_POST['mantax'] as $id => $tax) {
			$cart->tax_overrides[$id] = user_numeric($_POST['mantax'][$id]); }
	}

	// if (isset($_POST['attachment'])) {
	// 	$cart->attachment = $_POST['attachment'];
	// }
}

//---------------------------------------------------------------------------------------------------

function create_new_po($trans_type, $trans_no, $attachment_id=null)
{
	global $Refs;

	if (isset($_SESSION['PO']))
		unset ($_SESSION['PO']->line_items, $_SESSION['PO']);

	$cart = new purch_order;
	$_POST['OrderDate'] = new_doc_date();
	if (!is_date_in_fiscalyear($_POST['OrderDate']))
		$_POST['OrderDate'] = end_fiscalyear();
	$cart->due_date = $cart->orig_order_date = $_POST['OrderDate'];

	$cart->trans_type = $trans_type;
	if($trans_type==ST_PURCHORDER)
		$cart->order_no = $trans_no;
	if (isset($attachment_id)) {
		$cart->attachment = $attachment_id;
	}
	/*read in all the selected order into the Items cart  */
	if ($trans_no) {
		if($trans_type == ST_PURCHORDER){
			read_po($trans_no, $cart);
			$cart->order_no = $trans_no;
		} elseif($trans_type == ST_SUPPINVOICE){
			read_direct_invoice($trans_no, $trans_type, $cart);
		}
	} else
		$cart->reference = $Refs->get_next($trans_type, null,
			array('supplier_id' => $cart->supplier_id, 'date' => get_post('OrderDate')));
	$_SESSION['PO'] = &$cart;
}

//---------------------------------------------------------------------------------------------------

function display_po_header(&$order)
{
	global $Ajax, $Refs;

	$editable = ($order->order_no == 0);

	start_outer_table(TABLESTYLE2, 'width:90% !important ;');

	table_section(1);
    if ($editable)
    {
        if (!isset($_POST['supplier_id']) && (get_global_supplier() != ALL_TEXT))
        	$_POST['supplier_id'] = get_global_supplier();

    	supplier_list_row(_("Supplier:"), 'supplier_id', null, false, true, false, true);
	}
	else
	{
		if($order->approvedLPO==1){
			hidden('supplier_id', $order->supplier_id);
			label_row(_("Supplier:"), $order->supplier_name);
		}else{
	    	supplier_list_row(_("Supplier:"), 'supplier_id', null, false, true, false, true);
		}
    }

	if ($order->supplier_id != get_post('supplier_id',-1)) {
		$old_supp = $order->supplier_id;
		get_supplier_details_to_order($order, $_POST['supplier_id']); 
	    get_duedate_from_terms($order);
		$_POST['due_date'] = $order->due_date;

		// supplier default price update
		foreach ($order->line_items as $line_no=>$item) {
			$line = &$order->line_items[$line_no];
			$line->price =  get_purchase_price ($order->supplier_id, $line->stock_id);
			$line->quantity =
				$line->quantity/get_purchase_conversion_factor ($old_supp, $line->stock_id)
					*get_purchase_conversion_factor ($order->supplier_id, $line->stock_id);
		}
	    $Ajax->activate('items_table');
	    $Ajax->activate('due_date');
	}
	set_global_supplier($_POST['supplier_id']);

	date_row($order->trans_type==ST_PURCHORDER ? _("Order Date:") :
		($order->trans_type==ST_SUPPRECEIVE ? _("Delivery Date:") : _("Invoice Date:")),
		'OrderDate', '', true, 0, 0, 0, null, true);

	if (isset($_POST['_OrderDate_changed'])) {
		$order->orig_order_date = $_POST['OrderDate'];
	    get_duedate_from_terms($order);
	    $_POST['due_date'] = $order->due_date;
		$Ajax->activate('due_date');
	}
	supplier_credit_row($order->supplier_id, $order->credit);

	if (!is_company_currency($order->curr_code))
	{
		label_row(_("Supplier Currency:"), $order->curr_code);
		exchange_rate_display(get_company_currency(), $order->curr_code,
			$_POST['OrderDate']);
	}

    if ($editable)
    {
    	ref_row(_("Reference:"), 'ref', '', null, false, $order->trans_type, array('date'=> @$_POST['OrderDate']));
    }
    else
    {
    	hidden('ref', $order->reference);
    	label_row(_("Reference:"), $order->reference);
    }

	table_section(2);

	if ($order->trans_type==ST_SUPPINVOICE)
		date_row(_("Due Date:"), 'due_date', '', false, 0, 0, 0, null, true);

  	text_row(_("Supplier's Reference:"), 'supp_ref', null, 16, 100);

	if (get_company_pref('use_dimension'))
		dimensions_list_row(_('Site').':', 'dimension', null, true, _('Default'), false, 1);
	if (get_company_pref('use_dimension') == 2)
		dimensions_list_row(_('Project').':', 'dimension2', null, true, _('Default'), false, 2);
	locations_list_row(_("Receive Into:"), 'StkLocation', null, false, true, $order->fixed_asset); 

	table_section(3);

    if (!isset($_POST['StkLocation']) || $_POST['StkLocation'] == "" ||
    	isset($_POST['_StkLocation_update']) || !isset($_POST['delivery_address']) ||
    	$_POST['delivery_address'] == "")
    {
    	/*If this is the first time the form loaded set up defaults */

		$loc_row = get_item_location(get_post('StkLocation'));
        if ($loc_row)
        {
    	  	$_POST['delivery_address'] = $loc_row["delivery_address"];
			$Ajax->activate('delivery_address');
    	  	$_SESSION['PO']->Location = $_POST['StkLocation'];
    	  	$_SESSION['PO']->delivery_address = $_POST['delivery_address'];

        }
        else
        { /*The default location of the user is crook */
    	  	display_error(_("The default stock location set up for this user is not a currently defined stock location. Your system administrator needs to amend your user record."));
        }
    }

	textarea_row(_("Deliver to:"), 'delivery_address', $_POST['delivery_address'], 35, 4);
	
	if ($order->trans_type==ST_SUPPINVOICE)
   check_row(_("Import"). ':', 'imported', null, true,_('For Imported supplies'));
           
            if(@$_POST['imported'])
            {
            	global $Ajax;
	             $Ajax->activate('_page_body');

                    amount_row(_("Import For Personal Use Amount"), 'import_price', null, null, null, $dec2);
          gl_all_accounts_list_row(_("Account:"), 'import_gl_account', null, false, false, _("All Accounts"),true,1);
            }
            else
            {
               global $Ajax;
	             $Ajax->activate('_page_body');

            }
 





div_start('image',null,false);
	table_section(5);
    if (list_updated('stock_id') && file_exists(company_path().'/images/'.item_img_name($_POST['stock_id']).".jpg")) 
	{
// start_table(TABLESTYLE2,'    margin-top: -20px;
//     height: 180px;
//     width: 195px!important;');
	 // 31/08/08 - rand() call is necessary here to avoid caching problems.
		// sssdisplay_error(company_path().'/images/'.item_img_name($_POST['stock_id']));
		$stock_img_link = "<img id='item_img' alt = '[".$_POST['stock_id'].".jpg".
			"]' class='img-thumbnail '  src='".company_path().'/images/'.item_img_name($_POST['stock_id']).
			".jpg?nocache=".rand()."'"."    style='        height: 180px;
    width: 205px;;       margin-top: -22px;  
 ' border='0' onclick='view_img(this)'>";
		$check_remove_image = true;
	label_row("&nbsp;                                   ", $stock_img_link);
		br();
	// end_table();
	} 
	
// close_img()
     div_end();
	
 	end_outer_table(); // outer table
}


//---------------------------------------------------------------------------------------------------
 
function add_attachment_view(&$order){

	start_outer_table(TABLESTYLE2 ,'width:70% !important ;');
	table_section(1);

	div_start('attachment_table'); //Working Here
	start_table(TABLESTYLE, "style='width:100% !important;'");
	$th = array(_("File Attachments"), _(""), _("Title"),  _(""),  _(""));
	table_header($th);

	file_cells(_("Attach Documents"),'attachment');
	text_cells(null, 'attach_title');
	submit_cells('AddAttachment', _("Add Attachment"), "colspan=1 align='left'",
		    _('Add Multiple Attachments'), true);

	if($order->line_attachment){
	$th = array(_("File Name"), _("File Type"),  _(""), _(""), _(""));
	table_header($th);
		foreach($order->line_attachment as $key => $value){
			start_row();
			label_cell($value->file_name);
			label_cell($value->file_type);
			label_cell($value->attach_title);
			delete_button_cell("del_attach".$key, _("Remove Attachment"),
				_('Remove Attachment'));
			end_row();
		}

	}
 
	div_end();
	end_outer_table(1);

}

//---------------------------------------------------------------------------------------------------

function display_po_items(&$order, $editable=true)
{
	global $path_to_root;
	$charges_on_net = get_company_pref('charges_on_net');
    display_heading(_("Order Items"));

    div_start('items_table');
    start_table(TABLESTYLE2, 'width:90% !important ;');


	if(!list_updated('stock_id1')){
	   	$th = array(_("Image"),_("Item Code"), _("Item Description"),_("Long Description"), _("Quantity"),
			_("Received"), _("Unit"), _("Required Delivery Date"), 
			$order->tax_included ? _("Price after Tax") : _("Price before Tax"), 
			_("Amount"), _("Charges"), _("Discount(%)"), _("Line Total"), "");
		if ($order->trans_type != ST_PURCHORDER){
		  //  array_remove_by_value($th, "Discount(%)");
		    array_remove($th, 7);
		}
			
	}
	else{
	   	$th = array(_("Image"),_("Item Code"), _("Item Description"), "",_("Long Description"), _("Quantity"),
			_("Received"), _("Unit"), _("Required Delivery Date"), 
			$order->tax_included ? _("Price after Tax") : _("Price before Tax"), 
			_("Amount"), _("Charges"), _("Discount(%)"), _("Line Total"), "");
		if ($order->trans_type != ST_PURCHORDER){
		  //  array_remove_by_value($th, "Discount(%)");
    		array_remove($th, 8);
		}
			
	}

	//If the the user wants the charge data representation on total instead of line than remove respective header values 
	if($charges_on_net){
		array_remove_by_value($th,"Charges");
		array_remove_by_value($th, "Amount");
	}

	if(count($order->line_items)) $th[] = '';



   	table_header($th);

	$id = find_submit('Edit');
	$total = 0;
	$k = 0;
   	foreach ($order->line_items as $line_no => $po_line){

    	$line_total = round((  $po_line->quantity * $po_line->price   ) - $po_line->discount ,  user_price_dec());
    	if(!$charges_on_net){
    		$line_total = round($line_total+($po_line->charge), user_price_dec());
    	}
    	else{
    		// We will need price sum and quantity sum to show the charges on net
    		$qty_sum += $po_line->quantity;
    		$price_sum += $po_line->price;
    	}

    	if (!$editable || ($id != $line_no)){
    		alt_table_row_color($k);
    		line_item_image($po_line->stock_id,get_purchase_price($order->supplier_id, $po_line->stock_id),$po_line->item_description,0);
        	label_cell($po_line->stock_id);
    		label_cell($po_line->item_description);
    		 if(list_updated('stock_id1')){
    		     label_cell("");
    		 }
            label_cell($po_line->long_description);
        	if ($order->fixed_asset)
    		    label_cell(1);
         	else
            	qty_cell($po_line->quantity, false, get_qty_dec($po_line->stock_id));

            qty_cell($po_line->qty_received, false, get_qty_dec($po_line->stock_id));
    		label_cell($po_line->units);
			if ($order->trans_type == ST_PURCHORDER)
        	    label_cell($po_line->req_del_date);
    		amount_decimal_cell($po_line->price);
// 			if ($order->trans_type == ST_PURCHORDER)
	    		amount_decimal_cell($po_line->discount_perc);
	    		
	    		
    		amount_decimal_cell(($po_line->price*$po_line->quantity) - $po_line->discount  );
           if(!$charges_on_net){
    			label_cell(get_trans_view_str(ST_CHARGES, 
    			$order->charge_group."-".$po_line->quantity."-".$po_line->price."-1", 
    			$po_line->charge<0 ? "(".($po_line->charge*-1).")" : $po_line->charge, 
    			false, '', '', $path_to_root));
            	amount_cell($line_total);
    		}

			if ($editable)
			{
					edit_button_cell("Edit$line_no", _("Edit"),
					  _('Edit document line'));
					delete_button_cell("Delete$line_no", _("Delete"),
						_('Remove line from document'));
			}
		end_row();
		}
		else
		{
			po_item_controls($order, $k, $line_no);
		}
		$total += $line_total;
		$charge_total += $po_line->charge;
    }

	if ($id==-1 && $editable)
		po_item_controls($order, $k);

	$colspan = count($th)-2;
	if (count($order->line_items))
		$colspan--;

	if($charges_on_net){
		$gross_total = $total;
		label_row(_("Gross-total"), price_format($gross_total), "colspan=$colspan align=right",
			"align=left", 2);
		$display_charge_total = $charge_total<0? "(".price_format($charge_total*-1).")":
		price_format($charge_total);
		// As we are sending total quantity in charge modal we need the average price per unit in the modal for proper calculations
		$avg_price = price_format($total/$qty_sum);
		if($charge_total)
			label_row(_("Charge Amount"), 
				get_trans_view_str(ST_CHARGES, $order->charge_group."-".$qty_sum."-".$avg_price."-1", 
    			$charge_total<0 ? "(".($charge_total*-1).")" : $charge_total, false, '', '', 
    			$path_to_root), 
    			"colspan=$colspan align=right","align=left", 2);
		$total = $gross_total+$charge_total; // As charge amount was not added before so adding it now
	}

	$display_sub_total = price_format($total);

	label_row(_("Sub-total"), $display_sub_total, "colspan=$colspan align=right","align=left", 2);

	$taxes = $order->get_taxes(input_num('freight_cost'), false, false);
	
	$tax_total = display_edit_tax_items($taxes, $colspan, $order->tax_included, 2, $order->trans_type==ST_SUPPINVOICE);

	$display_total = price_format(($total + input_num('freight_cost') + $tax_total));

	start_row();
	label_cells(_("Amount Total"), $display_total, "colspan=$colspan align='right'","align='left'");
	$order->trans_type == ST_SUPPINVOICE
	 ? submit_cells('update', _("Update"), "colspan=2 align='center'", _("Refresh"), true)
		: label_cell('', "colspan=2");
	end_row();

	end_table(1);
	div_end();
}

//---------------------------------------------------------------------------------------------------

function display_po_summary(&$po, $is_self=false, $editable=false, $po_internal_view=false)
{
    start_table(TABLESTYLE2, "width='90%'");

    start_row();
    label_cells(_("Reference"), $po->reference, "class='tableheader2'");

    label_cells(_("Supplier"), $po->supplier_name, "class='tableheader2'");
    if($po_internal_view == true)
    label_cells(_(" "), '  ', "");

    label_cells(_("Site"), get_dimension($po->dimension)['name'], "class='tableheader2'");


    if (!is_company_currency($po->curr_code))
    	label_cells(_("Order Currency"), $po->curr_code, "class='tableheader2'");

    if (!$is_self)
    {
    	label_cells(_("Purchase Order"), get_trans_view_str(ST_PURCHORDER, $po->order_no),
    		"class='tableheader2'");
    }
	end_row();
	start_row();
    label_cells(_("Date"), $po->orig_order_date, "class='tableheader2'");

    if ($editable)
    {
        if (!isset($_POST['Location']))
        	$_POST['Location'] = $po->Location;
        label_cell(_("Deliver Into Location"), "class='tableheader2'");
        locations_list_cells(null, 'Location', $_POST['Location']);
    }
    else
    {
    	label_cells(_("Deliver Into Location"), get_location_name($po->Location),
    		"class='tableheader2'");
    }

    if ($po->supp_ref != "")
    	label_cells(_("Supplier's Reference"), $po->supp_ref, "class='tableheader2'");
    end_row();

    if (!$editable)
    	label_row(_("Delivery Address"), $po->delivery_address, "class='tableheader2'",
    		"colspan=9");

	if (!$editable && ($po->prep_amount > 0))
	{
		start_row();
		label_cells(_("Required Pre-Payment"), price_format($po->prep_amount), "class='tableheader2'");
		label_cells(_("Pre-Payments Allocated"), price_format($po->alloc), "class='tableheader2'");
		end_row();
	}

    if ($po->Comments != "")
    	label_row(_("Order Comments"), $po->Comments, "class='tableheader2'",
    		"colspan=9");
    end_table(1);
}

//--------------------------------------------------------------------------------

function po_item_controls(&$order, &$rowcounter, $line_no=-1)
{
   global $Ajax, $SysPrefs, $path_to_root;
   $charges_on_net = get_company_pref('charges_on_net');
	$itm_Name=get_items_name_description(get_post('stock_id1'));
	$check_desc_language = check_description_language($order->line_items[$id]->stock_id); //note: english 1, // arabic 0

	alt_table_row_color($rowcounter);

	$dec2 = 0;
	$id = find_submit('Edit');
	if (($id != -1) && $line_no == $id)
	{

		$_POST['stock_id'] = $order->line_items[$id]->stock_id;
		$dec = get_qty_dec($_POST['stock_id']);
		$_POST['qty'] = qty_format($order->line_items[$id]->quantity, $_POST['stock_id'], $dec);
		$_POST['price'] = price_decimal_format($order->line_items[$id]->price, $dec2);
		$_POST['discount'] = price_decimal_format($order->line_items[$id]->discount_perc, $dec2);
		if ($order->trans_type == ST_PURCHORDER)
			$_POST['req_del_date'] = $order->line_items[$id]->req_del_date;

		$_POST['units'] = $order->line_items[$id]->units;
		$_POST['item_description'] = $order->line_items[$id]->item_description;
		$_POST['charges'] = $order->line_items[$id]->charge;
		$_POST['long_description'] = $order->line_items[$id]->long_description;

		hidden('stock_id', $_POST['stock_id']);
			label_cell(""); 
		label_cell($_POST['stock_id']);

	$itm_Name=get_items_name_description(get_post('stock_id1'));
	$check_desc_language = check_description_language($order->line_items[$id]->stock_id); //note: english 1, // arabic 0

		if ($order->line_items[$id]->descr_editable)
		{
				if($check_desc_language == 0) // for arabic text box
				text_cells_arbic(null, 'item_description', 50, 50 , null,null,null,null,true, 1);
				else// for english text box
				text_cells(null, 'item_description', null, 25, 50,_('Item Name'));
			// textarea_cells(null,'item_description', null, 45, 2. _('Item Name'));

		}
		else 
		{
				if($check_desc_language == 0) // for arabic text box
				text_cells_arbic(null, 'item_description', 50, 50 , $_POST['description'],null,null,null,true, 1);
				else// for english text box
				text_cells(null, 'item_description', $_POST['description'], 25, 50,_('Item Name'));
	        // textarea_cells(null,'item_description', null, 45, 2);
		}
			
                       //hidden('item_description', $_POST['item_description']);
			// text_cells($order->line_items[$id]->item_description); 
		

	    $Ajax->activate('items_table');
		$qty_rcvd = $order->line_items[$id]->qty_received;
	}
	else
	{

		// Manufactured item can be purchased
		label_cell(""); 
		label_cell($_POST['stock_id1'] );// item Code
		hidden('stock_id', $_POST['stock_id1']);
		if (list_updated('stock_id1')) {
			    $Ajax->activate('items_table');
			    $Ajax->activate('image');
			}
					// label_cell("");  

		if ($order->fixed_asset)
		{
			 if (!list_updated('stock_id1')){
		stock_purchasable_fa_list_cells(null, 'stock_id1', null,  _('[Select item]'), true, false, true, $order->line_items);
				// stock_disposable_fa_list_cells(null,'stock_id1', null, _('[Select item]'), true, $order->line_items);
			}else{
			     $check_desc_language = check_description_language(get_post('stock_id1')); //note: english 1, // arabic 0
				
				if($check_desc_language == 0) // for arabic text box
				text_cells_arbic(null, 'stock_name', 50, 200 , $itm_Name['description'],null,null,null,true, 1);
				else// for english text box
				text_cells(null, 'stock_name', $itm_Name['description'], 25, 200,_('Item Name'));
				remove_button_cell("AAA", ("AAA"), ('Cancel'));
			}
		}
		else
		{
		
		if (!list_updated('stock_id1')){
				// sales_items_list_cells(null,'stock_id1', null, false, true, true);
			stock_items_list_cells(null, 'stock_id1', null, false, true, false, true, array('editable' => 30, 'where'=>array("NOT no_purchase")));
			}else{
			$check_desc_language = check_description_language(get_post('stock_id1')); //note: english 1, // arabic 0
				
				if($check_desc_language == 0) // for arabic text box
				text_cells_arbic(null, 'stock_name', 50, 200 , $itm_Name['description'],null,null,null,true, 1);
				else// for english text box
				text_cells(null, 'stock_name', $itm_Name['description'], 25, 200,_('Item Name'));
				remove_button_cell("AAA", ("AAA"), ('Cancel'));
			}

		}
		if (get_post('AAA')){
			     $Ajax->activate('items_table');
		}

		if (list_updated('stock_id1'))
		{
			    $Ajax->activate('price');
			    $Ajax->activate('units');
			    $Ajax->activate('qty');
			    $Ajax->activate('req_del_date');
			    $Ajax->activate('line_total');
			    $Ajax->activate('items_table');
		}
    	$item_info = get_item_edit_info($_POST['stock_id1']);
		$_POST['units'] = $item_info["units"];

   		$dec = $item_info["decimals"];
   		$_POST['qty'] =	number_format2(get_purchase_conversion_factor ($order->supplier_id, $_POST['stock_id']), $dec);
		$_POST['price'] = price_decimal_format(get_purchase_price ($order->supplier_id, $_POST['stock_id']), $dec2);
		if ($order->trans_type == ST_PURCHORDER)
			$_POST['req_del_date'] = add_days(Today(), $SysPrefs->default_receival_required_by());
		$qty_rcvd = '';
	}

    textarea_cells(null, 'long_description');

	if ($order->fixed_asset) {
		label_cell(1, '', 'qty');
		hidden('qty', 1);
	} else
		qty_cells(null, 'qty', null, null, null, $dec);

	qty_cell($qty_rcvd, false, $dec);

	label_cell($_POST['units'], '', 'units');
	if ($order->trans_type == ST_PURCHORDER){
		$last_item_date = ($order->line_items[count($order->line_items)-1]->req_del_date);
		if($last_item_date && $id == -1)
			$_POST['req_del_date'] = $last_item_date;
		date_cells(null, 'req_del_date', '', null, 0, 0, 0);
	}

	if ($qty_rcvd > 0)
	{
   		amount_decimal_cell($_POST['price']);
   		hidden('price', $_POST['price']);
   	}	
   	else	
		amount_cells(null, 'price', null, null, null, $dec2);

	$line_total = round((input_num('qty') * input_num('price')),  user_price_dec());

	if(!(($id != -1) && $line_no == $id)){ // Only do this if not on edit
		$_POST['charges'] = ($_POST['stock_id1']!=null?
					$order->get_charge_amount(input_num('price'),input_num('qty')):0);
		$_POST['charges'] = round2($_POST['charges'], user_price_dec());
	}

// 	if ($order->trans_type == ST_PURCHORDER)
		amount_cells(null, 'discount', input_num('discount'), null, null, $dec2);
	amount_decimal_cell($_POST['price']*$_POST['qty'] - (($_POST['price']*$_POST['qty']) * (input_num('discount')/100) ));
	if(!$charges_on_net){
		// substract charges from line total as user needs to see the total
		$line_total += input_num('charges');

		label_cell(get_trans_view_str(ST_CHARGES, 
    			$order->charge_group."-".$_POST['qty']."-".$_POST['price']."-0", 
    			($_POST['charges']<0? "(".($_POST['charges']*-1).")" : $_POST['charges']), 
    			false, '', '', $path_to_root));
		amount_cell($line_total, false, '','line_total');
	}
	
   	hidden('charges', $_POST['charges']);

	if ($id!=-1)
	{
		button_cell('UpdateLine', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelUpdate', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('line_no', $line_no);
		set_focus('qty');
	}
	else
	{
		// submit_cells('AddItem', _("Add Item"), "colspan=2 align='left'",
		//     _('Add new item to document'), true);
		submit_cells('EnterLine', _("Add Item"), "colspan=2 align='center'",
		    _('Add new item to document'), true);
	}

	end_row();
}

//---------------------------------------------------------------------------------------------------

function display_po_footer(&$trans)
{
	global $Ajax;

start_table(TABLESTYLE2);

if ($trans->trans_type == ST_SUPPINVOICE) {
	cash_accounts_list_row(_("Payment:"), 'cash_account', null, false, _('Delayed'));
} elseif ($trans->trans_type == ST_PURCHORDER)
	amount_row(_("Pre-Payment Required:"), 'prep_amount');

textarea_row(_("Memo:"), 'Comments', null, 70, 4);

end_table();
}
//---------------------------------------------------------------------------------------------------


?>
<style>

#myImg {
    border-radius: 5px;
    cursor: pointer;
    transition: 0.3s;
}

#myImg:hover {opacity: 2;}

/* The Modal (background) */
.modal .modal_n {
    /*display: block;*/

    display: none; /* Hidden by default */
    position: fixed; /* Stay in place */
    z-index: 2; /* Sit on top */
    padding-top: 100px; /* Location of the box */
    left: 0;
    top: 10px;
    width: 100%; /* Full width */
    height: 100%; /* Full height */
    overflow: auto; /* Enable scroll if needed */
    background-color: rgb(0,0,0); /* Fallback color */
    background-color: rgba(0,0,0,0.9); /* Black w/ opacity */
}

/* Modal Content (image) */
.modal-content .modal_m {

    margin: auto;
    display: block;
    width: 50%;
    max-width: 400px;
}

/* Caption of Modal Image */
#caption {
    margin: auto;
    display: block;
    width: 80%;
    max-width: 700px;
    text-align: center;
    color: #ccc;
    padding: 10px 0;
    height: 150px;
}

/* Add Animation */
.modal-content .modal_m, #caption {    
    -webkit-animation-name: zoom;
    -webkit-animation-duration: 0.6s;
    animation-name: zoom;
    animation-duration: 0.6s;
}

@-webkit-keyframes zoom {
    from {-webkit-transform:scale(0)} 
    to {-webkit-transform:scale(1)}
}

@keyframes zoom {
    from {transform:scale(0)} 
    to {transform:scale(1)}
}

/* The Close Button */
.close {
    position: absolute;
    top: 15px;
    right: 35px;
    color: #f1f1f1;
    font-size: 40px;
    font-weight: bold;
    transition: 0.3s;
}

.close:hover,
.close:focus {
    color: #bbb;
    text-decoration: none;
    cursor: pointer;
}

/* 100% Image Width on Smaller Screens */
@media only screen and (max-width: 700px){
    .modal-content .modal_m {
        width: 100%;
    }
}


.zoom {
    /*padding: 50px;*/
    /*background-color: green;*/
    transition: transform .2s;
    width: 200px;
    height: 200px;
    margin: 0 auto;
}

.zoom:hover {
    -ms-transform: scale(1.3);  IE 9 
    -webkit-transform: scale(1.3); /* Safari 3-8 */
    transform: scale(1.3); 
}

#section1{

width:213px;
    /*padding: 0px 0px 0px 4px;*/
    /*margin: -30px 0px 0px 0px;*/
    font-size: 12px !important;
    float: left;
    /*text-decoration: underline;*/
    text-align: -webkit-auto;
    line-height: 20px;

}
#section2{

	width: 348px;
	/*padding: 3px 40px 0px 0px;*/
    /*margin: -30px 0px 0px 0px;*/
    font-size: 12px !important;
    float: left;
    /*text-decoration: underline;*/
    text-align: -webkit-auto;
    line-height: 20px;
    /*box-shadow: -6px 4px 11px -9px*/
        border-left: 2px solid #0e909d;

}
.divider {
  width: 2px;
  margin: 6px 0;
      background: #464c54;
    box-shadow: -5px 0px 0px 1px;
}
.divider h3{
    color: #464c54;
    font-weight: 900;
/*    text-decoration-line: underline;
    text-decoration-style: double;*/

}

</style>