<?php

function display_rfq_header(&$order, $rfq_id)
{
	global $Refs  , $Ajax;
	start_table(TABLESTYLE2, "style='width:50% !important;'"); // outer table

	
	$row = get_purchase_requisition($rfq_id);
	label_cells("MR Request", $rfq_id."   -   ".date('d/m/Y', strtotime($row['application_date'])), "class='tableheader2'");


    label_cells(_("Select a Supplier:") , supplier_list('supplier_id', null, true, true, false, true), "class='tableheader2'");              

	hidden('rfq_id' , $rfq_id);
	end_table(1); // outer table.
}


function display_rfq_items($title, &$order, $rfq_id)
{
	global $path_to_root;

	display_heading($title);
    div_start('items_table');
	
	start_table(TABLESTYLE2, 'width:90% !important;');
	
	$th = array(_("Items Name"), _("Quantity"), "");

	if ( count($order->line_items)) $th[] = '';

	table_header($th);

	$total = 0;
	$k = 0;  //row colour counter
	$id = find_submit('Edit');
	foreach ($order->line_items as $line_no=>$stock_item)
	{
		if($id != $line_no){
			label_cell(get_item($stock_item->rfq_stock)['description']);
			qty_cell($stock_item->qty);
			edit_button_cell("Edit$line_no", _("Edit"),_('Edit document line'));
	 	    delete_button_cell("Delete$line_no", _("Delete"), _('Remove line from document'));
			end_row();
		}else
			adjustment_edit_rfq_controls($order, $rfq_id, $line_no);

		

	}
	if ($id == -1)
		adjustment_edit_rfq_controls($order, $rfq_id);
		
	end_table();
	div_end();
}


function adjustment_edit_rfq_controls(&$order, $rfq_id, $line_no=-1)
{
	global $Ajax;
	start_row();

	$dec2 = 0;
	$id = find_submit('Edit');
	
	if ($line_no!=-1 && $line_no == $id){
		$_POST['stock_id'] = $order->line_items[$id]->rfq_stock;
		$_POST['qty'] = $order->line_items[$id]->qty;
		$Ajax->activate('items_table');

	}
	purchase_req_list_cells(null, 'stock_id', null, true, true, "All Items", $rfq_id);
	
		if(list_updated('stock_id')){
			$_POST['qty'] = get_qty_of_rfq($rfq_id, $_POST['stock_id']);
		}
	if(!isset($_POST['qty'])){
		$_POST['qty'] = 1;
	}
	qty_cells(null, 'qty', $_POST['qty'], null, null, 1);
	if ($id != -1)
	{
		button_cell('UpdateItem', _("Update"),
				_('Confirm changes'), ICON_UPDATE);
		button_cell('CancelItemChanges', _("Cancel"),
				_('Cancel changes'), ICON_CANCEL);
		hidden('LineNo', $line_no);
 		set_focus('qty');
	}
	else
	{
		submit_cells('AddItem', _("Add Item"), "colspan=2",
		    _('Add new item to document'), true);
	}

	end_row();
}


function add_rfq_items(&$items, $rfq_id, $supplier_id){

	$sql = " INSERT INTO ".TB_PREF."rfq (pr_id, supplier_id, date) VALUES('$rfq_id', '$supplier_id', '".date('Y-m-d')."')";
	$res = db_query($sql,"");
	$id = db_insert_id();
	
	add_audit_trail(114, $id, Today(), _('RFQ Sent'));
	
	foreach ($items->line_items as $value) {
		$sql = $sql = " INSERT INTO ".TB_PREF."rfq_details (pr_id, rfq_id, stock_id, qty) VALUES('$rfq_id', '$id', '$value->rfq_stock', '$value->qty') ";
		$res = db_query($sql,"");

	}

}

function check_rfq_sent_to_supplier($pr_id, $supplier_id){
	$sql = " SELECT id FROM  ".TB_PREF."rfq WHERE pr_id = '$pr_id' AND supplier_id = '$supplier_id' ";
	$res = db_query($sql , " ");
	return db_num_rows($res);
}

function get_qty_of_rfq($rfq_id, $stock_id){
	$sql = " SELECT pmr.quantity  FROM ".TB_PREF."purchase_material_req_details AS pmr  WHERE pmr.material_req_id = '$rfq_id' AND pmr.item_code  = '$stock_id' ";
	$result =  db_query($sql);
	// display_error($sql);
	return db_fetch($result)['quantity'];
}

?>