<?php

$page_security = 'SA_SUPPSEARCHCOMPLETE';
$path_to_root="../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Search Purchase Orders"), false, false, "", $js);

//---------------------------------------------------------------------------------------------



function attach($row){
	if(!$_SESSION['wa_current_user']->can_access_page('SA_ATTACHDOCUMENT'))
		return '';
	else
		return pager_link(_("Link Document"), $path_to_root."/admin/attachments.php?filterType=".ST_PURCHORDER."&trans_no=".$row['order_no'], ICON_ATTACH);
}


function trans_view($trans)
{
	global $path_to_root;
	return get_trans_view_str(ST_PURCHORDER, $trans["order_no"], "", false, '', '', $path_to_root); 
}

function edit_link($row) 
{
	global $page_nested;

	if(!$_SESSION["wa_current_user"]->can_access_page('SA_PURCHASEORDERMODIFY')){
		return '';
	}


	return $page_nested || !$row['isopen'] ? '' :
		trans_editor_link(ST_PURCHORDER, $row["order_no"]);
}

function prt_link($row)
{
	return print_document_link($row['order_no'], _("Print"), true, ST_PURCHORDER, ICON_PRINT);
}

if (isset($_GET['order_number']))
{
	$_POST['order_number'] = $_GET['order_number'];
}

function checkOwner($user_id = null)
{
	$sql = " SELECT * FROM ".TB_PREF."users WHERE id = ".db_escape($user_id)." AND owner = ".db_escape(1)." ";
	$run = db_query($sql, "Couldnot run checkowner()");
	$ft = db_fetch($run);
	$numOfRows = db_num_rows($run);
	return $numOfRows;

}
function PurchaseOrderSetApprove($id, $status=1)
{
	$status=1;
  	$sql = "UPDATE ".TB_PREF."purch_orders SET approved = ".db_escape($status)." WHERE order_no=".db_escape($id)."  ";
  	db_query($sql, "Can't change sales quotation approved PurchaseOrderSetApprove function ");
}

function approved_link($row)
{
	 $name = "approved".$row['order_no'];
		$value = $row['approved'] ? 1:0;

	 return checkbox(null, $name,$value , true, _('Approved this quotation'))
	. hidden('last['.$row['order_no'].']', $value, false);
	
}

$id = find_submit('_approved');
if ($id != -1){
	purchaseOrderSetApprove($id, check_value('approved'.$id));
	$Ajax->activate('orders_tbl');
}

//-----------------------------------------------------------------------------------
// Ajax updates
//
if (get_post('SearchOrders')) 
{
	$Ajax->activate('orders_tbl');
} elseif (get_post('_order_number_changed')) 
{
	/*$disable = get_post('order_number') !== '';

	$Ajax->addDisable(true, 'OrdersAfterDate', $disable);
	$Ajax->addDisable(true, 'OrdersToDate', $disable);
	$Ajax->addDisable(true, 'StockLocation', $disable);
	$Ajax->addDisable(true, '_SelectStockFromList_edit', $disable);
	$Ajax->addDisable(true, 'SelectStockFromList', $disable);

	if ($disable) {
		$Ajax->addFocus(true, 'order_number');
	} else
		$Ajax->addFocus(true, 'OrdersAfterDate');

	$Ajax->activate('orders_tbl');*/
}
//---------------------------------------------------------------------------------------------
 div_start('ext_tbl');

start_form();

start_table(TABLESTYLE_NOBORDER);
start_row();
ref_cells(_("#:"), 'order_number', '',null, '', true);
text_cells(_("Ref:"),"reference",null);

// function ref_cells($label, $name, $title=null, $init=null, $params=null, $submit_on_change=false, $type=null, $context=null)
// {
 	date_cells(_("from:"), 'OrdersAfterDate', '', null, -user_transaction_days(),0,0,null,true);
  	date_cells(_("to:"), 'OrdersToDate', '', null, 1,0,0,null,true);


// date_cells(_("from:"), 'OrdersAfterDate', '', null, -user_transaction_days());
// date_cells(_("to:"), 'OrdersToDate');

locations_list_cells(_("into location:"), 'StockLocation', null, true);
end_row();
end_table();

start_table(TABLESTYLE_NOBORDER);
start_row();

stock_items_list_cells(_("for item:"), 'SelectStockFromList', null, true);

if (!$page_nested)
	supplier_list_cells(_("Select a supplier: "), 'supplier_id', null, true, true);

dimensions_list_cells(_('Site:'), 'dimension_id',  null, 'Select Site', null, false, 1, true);


check_cells(_('Also closed:'), 'also_closed', check_value('also_closed'));

$checkowner = checkOwner($_SESSION['wa_current_user']->user);
if($checkowner > 0)
{
	if(isset($_GET['LPOToApprove']))
		$value = 1;
	else
	$value = check_value('show_unapproved');
	check_cells(_("Show Unapproved :"), 'show_unapproved',$value,true);
}
if(isset($_GET['LPOToApprove']))
	$_POST['show_unapproved'] = 1;

if(get_post('show_unapproved') == 1 || get_post('show_unapproved') == 0 )
	$Ajax->activate('ext_tbl');






submit_cells('SearchOrders', _("Search"),'',_('Select documents'), 'default');
//zeeshan Start------------------------------------------------------------------------------------------------------------

if(isset($_POST['order_number']) || isset($_POST['OrdersAfterDate'])  || isset($_POST['OrdersAfterDate']) )
	$Ajax->activate('ext_tbl');


$trans_type=PURINQ;
// function print_pur_dashboard_print($dest=0, $link_text, $also_closed='', $link=true, $trans_type='', 
// 	$icon=false, $class='printlink', $id='',$from='', $to= '', $supplier_id='', $stocklocation='', $order_no='',
// 	$stocklist='')

echo  "<td>". print_pur_dashboard_print( 0, _("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), check_value('also_closed'), true, $trans_type, null, '','', get_post('OrdersAfterDate'),get_post('OrdersToDate'), get_post('supplier_id'), get_post('StockLocation'),
	get_post('order_number'), get_post('SelectStockFromList'), get_post('dimension_id')) ."</td>"; 

echo  "<td>". print_pur_dashboard_print( 1, _("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), check_value('also_closed'), true, $trans_type, null, '','', get_post('OrdersAfterDate'),get_post('OrdersToDate'), get_post('supplier_id'), get_post('StockLocation'),
	get_post('order_number'), get_post('SelectStockFromList'), get_post('dimension_id')) ."</td>"; 

//zeeshan End------------------------------------------------------------------------------------------------------------


end_row();
end_table(1);

//---------------------------------------------------------------------------------------------
function date_format5($row)
{
	return sql2date($row['ord_date']);
}

function check_overdue2($row)
{
    return ((($row['quantity_ordered'] - $row['quantity_received']) > 0 ) && (date("Y-m-d") >  $row['delivery_date']));

}

function ShowSiteName($row){
	if($row['dimension_id'])
		return get_dimension($row['dimension_id'])['name'];
	else return 'N/A';
}

if(get_post('show_unapproved') ==1 || get_post('show_unapproved') =='')
    $Ajax->activate('_page_body');
	

if($_POST['show_unapproved'] > 0)
	display_note(_("<p style='color:green;'>Search All Unapproved Purchase Order.</p>"), 0, 0, "class='overduefg'");
else
	display_note(_("<p style='color:green;'>Search All Purchase Order.</p>"), 0, 0, "class='overduefg'");



$sql = get_sql_for_po_search_completed(get_post('OrdersAfterDate'), get_post('OrdersToDate'),
	get_post('supplier_id'), get_post('StockLocation'), get_post('order_number'),
	get_post('SelectStockFromList'), get_post('also_closed'),get_post('reference'), $_POST['show_unapproved'], get_post('dimension_id'));

$cols = array(
		_("#") => array('fun'=>'trans_view', 'ord'=>'', 'align'=>'left'), 
		_("Reference"), 
		_("Supplier") => array('ord'=>''),
		_("Location"),
		_("Supplier's Reference"), 
		_("Order Date") => array('fun'=>'date_format5', 'align'=>'left' ,'ord'=>'desc'),
		_("Currency") => array('align'=>'left'), 
		_("Order Total") => 'amount',
		_("Site Name") => array('fun'=>'ShowSiteName', 'align'=>'left' ,'ord'=>'desc'),
		array('insert'=>true, 'fun'=>'edit_link'),
		array('insert'=>true, 'fun'=>'prt_link'),
		array('insert'=>true, 'fun'=>'attach'),
);
if($_POST['show_unapproved'] > 0)
	array_append($cols, array( _("Approve") => array('insert'=>true, 'fun'=>'approved_link')));

if (get_post('StockLocation') != ALL_TEXT) {
	$cols[_("Location")] = 'skip';
}

//---------------------------------------------------------------------------------------------------

$table =& new_db_pager('orders_tbl', $sql, $cols);
$table->set_marker('check_overdue2', _("Highlighted items are overdue."));

$table->width = "80%";

display_db_pager($table);

end_form();
end_page();