<?php

$page_security = 'SA_SUPPTRANSINQUIRY';
$path_to_root = "../..";
include_once($path_to_root . "/includes/db_pager.inc");
include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$js = "";
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();
page(_($help_context = "Supplier Inquiry"), isset($_GET['supplier_id']), false, "", $js);

if (isset($_GET['supplier_id'])) {
	echo '<script src="' . $path_to_root . '/themes/'.user_theme(). '/bower_components/bootstrap/dist/js/bootstrap.min.js"></script>';
}
if (isset($_GET['supplier_id'])){
	$_POST['supplier_id'] = $_GET['supplier_id'];
}

if (isset($_GET['FromDate'])){
	$_POST['TransAfterDate'] = $_GET['FromDate'];
}
if (isset($_GET['ToDate'])){
	$_POST['TransToDate'] = $_GET['ToDate'];
}

//------------------------------------------------------------------------------------------------

function display_supplier_summary($supplier_record)
{
	$past1 = get_company_pref('past_due_days');
	$past2 = 2 * $past1;
	$nowdue = "1-" . $past1 . " " . _('Days');
	$pastdue1 = $past1 + 1 . "-" . $past2 . " " . _('Days');
	$pastdue2 = _('Over') . " " . $past2 . " " . _('Days');
	

    start_table(TABLESTYLE2, "width='80%'");
    $th = array(_("Currency"), _("Terms"), _("Current"), $nowdue,
    	$pastdue1, $pastdue2, _("Total Balance"));

	table_header($th,'font-weight:normal');
    start_row();
	label_cell($supplier_record["curr_code"]);
    label_cell($supplier_record["terms"]);
    amount_cell($supplier_record["Balance"] - $supplier_record["Due"]);
    amount_cell($supplier_record["Due"] - $supplier_record["Overdue1"]);
    amount_cell($supplier_record["Overdue1"] - $supplier_record["Overdue2"]);
    amount_cell($supplier_record["Overdue2"]);
    amount_cell($supplier_record["Balance"]);
    end_row();
    end_table(1);
}
//------------------------------------------------------------------------------------------------
function systype_name($dummy, $type)
{
	global $systypes_array;
	return $systypes_array[$type];
}

function trans_view($trans)
{
	global $path_to_root;
	// display_error($_SERVER['REQUEST_URI']);
	// $path_to_root = "..";
	return get_trans_view_str($trans["type"], $trans["trans_no"], "", false, '', '', $path_to_root);
}


function attach($row){
	if(!$_SESSION['wa_current_user']->can_access_page('SA_ATTACHDOCUMENT'))
		return '';
	else
		return pager_link(_("Link Document"), $path_to_root."/admin/attachments.php?filterType=".$row["type"]."&trans_no=".$row["trans_no"], ICON_ATTACH);
}


function due_date($row)
{
	return ($row["type"]== ST_SUPPINVOICE) || ($row["type"]== ST_SUPPCREDIT) ? $row["due_date"] : '';
}

function gl_view($row)
{
	return get_gl_view_str($row["type"], $row["trans_no"]);
}

function credit_link($row)
{
	global $page_nested;

	if(!$_SESSION["wa_current_user"]->can_access_page('SA_SUPPLIERCREDITINOICE')   && $row['type'] == ST_SUPPINVOICE){
		return '';
	}

	if ($page_nested)
		return '';
	return $row['type'] == ST_SUPPINVOICE && $row["TotalAmount"] - $row["Allocated"] > 0 ?
		pager_link(_("Credit This"),
			"/purchasing/supplier_credit.php?New=1&invoice_no=".
			$row['trans_no'], ICON_CREDIT)
			: '';
}

function fmt_amount($row)
{
	$value = $row["TotalAmount"];
	return price_format($value);
}

function prt_link($row)
{
  	if ($row['type'] == ST_SUPPAYMENT || $row['type'] == ST_BANKPAYMENT || $row['type'] == ST_SUPPCREDIT) 
 		return print_document_link($row['trans_no']."-".$row['type'], _("Print Remittance"), true, ST_SUPPAYMENT, ICON_PRINT);
 	elseif ($row['type'] == ST_SUPPINVOICE)
	 	return print_document_link($row['trans_no']."-".$row['type'], _("Print"), true, ST_SUPPINVOICE, ICON_PRINT);	
}

function chq_prt_link($row){
	if ($row['type'] == ST_SUPPAYMENT) 
		return chq_print_document_link($row['trans_no']."-".$row['type'], _("Print Cheque"), true, ST_SUPPAYMENT, ICON_PRINT); 
}

function check_overdue($row)
{
	return $row['OverDue'] == 1
		&& (abs($row["TotalAmount"]) - $row["Allocated"] != 0);
}

function edit_link($row)
{
	global $page_nested;

	if(!$_SESSION["wa_current_user"]->can_access_page('SA_SUPPLIERINVOICEMODIFY') && $row['type'] ==   ST_SUPPINVOICE){
		return '';
	}

	if(!$_SESSION["wa_current_user"]->can_access_page('SA_SUPPLIERCREDITMODIFY')  && $row['type'] ==   ST_SUPPCREDIT){
		return '';
	}

	if ($page_nested)
		return '';
	return trans_editor_link($row['type'], $row['trans_no']);
}
//------------------------------------------------------------------------------------------------
 div_start('ext_tbl');
start_form();

if (!isset($_POST['supplier_id']))
	$_POST['supplier_id'] = get_global_supplier();

// start_table(TABLESTYLE_NOBORDER);
start_table(TABLESTYLE_NOBORDER,"",0,0,0,"style='width:60% !important; max-width:60% !important;'");
start_row();

if (!$page_nested)
	supplier_list_cells(_("Select a Supplier:"), 'supplier_id', null, true, true, false, true);

dimensions_list_cells(_('Site:'), 'dimension_id',  null, 'Select Site', null, false, 1, true);


text_cells(_("Ref:"),"reference",null);
supp_transactions_list_cell("filterType", null, true);

if ($_POST['filterType'] != '2')
{
    start_table(TABLESTYLE_NOBORDER,"",0,0,0,"style='width:50% !important; max-width:50% !important;'");

    start_row();
    
  	date_cells(_("from:"), 'TransAfterDate', '', null, -user_transaction_days(),0,0,null,true);
  	date_cells(_("to:"), 'TransToDate', '', null, 1);
}







// submit_cells('RefreshInquiry', _("Search"),'',_('Refresh Inquiry'), 'default');
submit_cells('SearchOrders', _("Search"),'',_('Refresh Inquiry'), 'default');
//Zee Starting-------------------------------------------------------------------------------------

if(isset($_POST['OrderNumber']) || isset($_POST['TransAfterDate']) )
	$Ajax->activate('ext_tbl');

$trans_type=SUPINQ;
	echo  "<td>". print_pur_supp_inq_dashboard_print( @$doc_no, _("<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"), true, $trans_type, null, '','', get_post('TransAfterDate'),get_post('TransToDate'), get_post('supplier_id') , get_post('filterType'),0, get_post('dimension_id')) ."</td>"; 

$trans_type=SUPINQ;
	echo  "<td>". print_pur_supp_inq_dashboard_print( @$doc_no, _("<img  style='width: 20px;' src =".$path_to_root."/themes/".user_theme()."/images/excel.png>"), true, $trans_type, null, '','', get_post('TransAfterDate'),get_post('TransToDate'), get_post('supplier_id') , get_post('filterType'),1, get_post('dimension_id')) ."</td>"; 

//Zee ending-------------------------------------------------------------------------------------

end_row();
end_table();
set_global_supplier($_POST['supplier_id']);

//------------------------------------------------------------------------------------------------

div_start('totals_tbl');
if ($_POST['supplier_id'] != "" && $_POST['supplier_id'] != ALL_TEXT)
{
	$supplier_record = get_supplier_details(get_post('supplier_id'), get_post('TransToDate'));
    display_supplier_summary($supplier_record);
}
div_end();

if (get_post('SearchOrders') || list_updated('filterType'))
{
	$Ajax->activate('_page_body');
}

//------------------------------------------------------------------------------------------------
function date_format6($row)
{
	return sql2date($row['tran_date']);
}

function date_format7($row)
{
	return sql2date($row['due_date']);
}

function ShowSite($row){
	return $row['dimension_id'] ? get_dimension($row['dimension_id'])['name'] : "N/A";
}

$sql = get_sql_for_supplier_inquiry(get_post('filterType'), get_post('TransAfterDate'), get_post('TransToDate'), get_post('supplier_id'),
	get_post('reference'), get_post('dimension_id'));

$cols = array(
			_("Type") => array('fun'=>'systype_name', 'ord'=>''), 
			_("#") => array('fun'=>'trans_view', 'ord'=>'', 'align'=>'left'), 
			_("Reference"), 
			_("Supplier"),
			_("Supplier's Reference"), 
			_("Date") => array('fun'=>'date_format6', 'align'=>'left' ,'ord'=>'desc'), 
			_("Due Date") => array('fun'=>'date_format7', 'align'=>'left' , 'fun'=>'due_date'), 
			_("Currency") => array('align'=>'center'),
			_("Amount") => array('align'=>'left', 'fun'=>'fmt_amount'), 
			_("Balance") => array('align'=>'left', 'type'=>'amount'),
			_("Site Name") => array('fun'=>'ShowSite'),
			array('insert'=>true, 'fun'=>'gl_view'),
			array('insert'=>true, 'fun'=>'credit_link'),
			array('insert'=>true, 'fun'=>'prt_link'),
            array('insert'=>true, 'fun'=>'chq_prt_link'),
			array('insert'=>true, 'fun'=>'edit_link'),
			array('insert'=>true, 'fun'=>'attach')
			);

if ($_POST['supplier_id'] != ALL_TEXT)
{
	$cols[_("Supplier")] = 'skip';
	$cols[_("Currency")] = 'skip';
}
if ($_POST['filterType'] != '2')
	$cols[_("Balance")] = 'skip';

/*show a table of the transactions returned by the sql */
$table =& new_db_pager('trans_tbl', $sql, $cols);
$table->set_marker('check_overdue', _("Marked items are overdue."));

$table->width = "85%";

display_db_pager($table);

end_form();
end_page();