<?php

$page_security = 'SA_SUPCHARGE';
$path_to_root = "../..";

include($path_to_root . "/includes/db_pager.inc");
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/includes/ui.inc");
include($path_to_root . "/purchasing/includes/db/supcharge.inc");

page(_($help_context = "Charge Group"));

//-----------------------------------------------------------------------------

//Helper functions
function can_process(){
	if($_POST['description'] == null){
		display_error("Description can not be empty");
		return false;
	}
	return true;
}

function can_delete($selected_id){
	if(key_in_foreign_table($selected_id,"suppliers","charge_group") ||
	key_in_foreign_table($selected_id,"purch_orders","charge_group") ||
	key_in_foreign_table($selected_id,"supp_trans","charge_group")){
		return false;
	}
	return true;
}

function edit_link($row){
	return button("Edit".$row["id"],_("Edit"), '', ICON_EDIT);
}

function charge_link($row){
	return pager_link(_("View"), 
			$path_to_root."/purchasing/manage/supp_charges.php?charge_group=".$row['id']);
}

function delete_link($row){
	if(can_delete($row["id"]))
		return button("Delete".$row["id"],_("Delete"), '', ICON_DELETE);
	else
		return "N/A";
}
//---------------------------------------------------------------------------------------------
simple_page_mode(true);

start_form();

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM'){
	if(can_process()){
		if($selected_id){
			$sql = "UPDATE ".TB_PREF."charge_group SET description=".db_escape($_POST['description'])." 
			WHERE id=".db_escape($selected_id);
			$note = "Charge group updated";
		}
		else{
			$sql = "INSERT INTO ".TB_PREF."charge_group (description) 
					VALUES(".db_escape($_POST['description']).")";
			$note = "Charge group Added";
		}
		$res = db_query($sql);
		if($res){
			display_notification($note);
			$Mode = 'RESET';
		}	
	}
} 

if ($Mode == 'Delete'){
	if(can_delete($selected_id)){
		$sql = "UPDATE ".TB_PREF."charge_group SET inactive = ABS(inactive - 1) 
			WHERE id =".db_escape($selected_id);
		db_query($sql);
		del_supp_charges(0,$selected_id);
		display_notification("Charge group deleted");
		$selected_id = -1;
	}
	$Mode = 'RESET';
} 

if ($Mode == 'RESET'){
	unset($_POST);
	$selected_id =-1;
}

if($selected_id){
	$row = get_charge_group($selected_id);
	$_POST['description'] = $row['description'];
	$_POST['selected_id'] = $row['id'];
}
start_table(TABLESTYLE5_BOX,"",0,0,0,null,"30%","3px solid #656E79;");

text_cells_ex(_("Group Name"), 'description', 30,null,null,null,null,null,false,null,5);

hidden('selected_id', $_POST['selected_id']);

end_table();

submit_add_or_update_center(($selected_id == -1 || $selected_id == null), '', 'both');

hidden('selected_id', $_POST['selected_id']);


br();

//-----------------------------------------------------------------------------------------------

$sql = get_sql_charge_group();
$cols = array(
	_("ID"),
	_("Description"),
	_("View Charges")=>array('insert'=>true, 'fun'=>'charge_link'),
	_("Edit")=>array('insert'=>true, 'fun'=>'edit_link'),
	_("Delete")=>array('insert'=>true, 'fun'=>'delete_link'),
	);

$table =& new_db_pager('charge_tbl', $sql, $cols);
display_db_pager($table);

end_form();
end_page();
?>