<?php

$page_security = 'SA_SUPCHARGE';
$path_to_root = "../..";
include($path_to_root . "/purchasing/includes/db/supcharge.inc");
include($path_to_root . "/includes/EvalMath.php");
include($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/gl/includes/db/gl_db_accounts.inc");


page(_($help_context = "Supplier Charges"));

include($path_to_root . "/includes/ui.inc");


// Helper Function
function can_process($selected_id){
	if($_POST['description'] == null){
		display_error("Write a Name for Charge");
		set_focus('description');
		return false;
	}
	return true;
}

function check_charge_in_trans($id){
	if(key_in_foreign_table($id, "purch_orders","charge_group")){
		return false;
	}
	else 
		return true;
}
function form_auth($formula, $charge_group){
	// Get the formula expression
	$expression = $formula->get_equation($charge_group);
	// Using evalmath which is used to evaluate mathametical expressions
	$emath = new EvalMath();
	// Now expression If it returns null than expression is not valid
	$value = $emath->evaluate($expression);
	if($value == "Error"){
		return false;
	}
	return true;
}
//----------------------------------------------------------------------------
if(isset($_POST['resetf'])){
	unset($_SESSION['formula']);
	unset($_POST['f_field']);
	unset($_POST['resetf']);
}
if(!isset($_SESSION['formula'])){
	$formula = new Formula();
	$_SESSION['formula'] = &$formula;
}
if($_GET['charge_group']!=0)
	$_POST['charge_group'] = $_GET['charge_group'];
elseif($_POST['charge_group']!=0)
	$_POST['charge_group'] = $_POST['charge_group'];
// -----------------------------------------------------------------------------
simple_page_mode(true);
// -----------------------------------------------------------------------------
if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM'){

	if(form_auth($_SESSION['formula'], $_POST['charge_group']) && can_process($selected_id)){
		// Replace the variables by a constant
		$note = $_SESSION['formula']->write($_POST['selected_id'], $_POST['description'], $_POST['impact'], 
				$_POST['gl_account'], $_POST['charge_group']);
		display_notification($note);
		$Mode = 'RESET';
	}
} 

if ($Mode == 'Delete'){
	if(!key_in_foreign_table($_POST['charge_group'],"purch_orders","charge_group")){
		del_supp_charges($selected_id);
		$selected_id = -1;
	}

	$Mode = 'RESET';
} 

if ($Mode == 'RESET'){
	unset($_SESSION['formula']);
	$temp = $_POST['charge_group'];
	unset($_POST);
	$_POST['charge_group'] = $temp;
	$formula = new Formula();
	$_SESSION['formula'] = &$formula;
	$selected_id = -1;
}
//-------------------------------------------------------------------------------------------------

start_form();

start_table(TABLESTYLE5_BOX,"",0,0,0,null,"50%","2px solid #2CABE3;");
$th = array(_("ID"), _("Description"), _("Formula"), _("Impact"), _("GL Account Code"), _("GL Account Name"), "","");

table_header($th);
$k = 0;
$result = get_supp_charges(0,$_POST['charge_group']);
while ($myrow = db_fetch($result)){
	
	alt_table_row_color($k);

	label_cell($myrow['id']);
	label_cell($myrow['description']);
	label_cell($myrow['formula'], "width = 150px !important;");
	label_cell($myrow['impact']==0? _("Subtract From Line Total") : _("Add in Line Total"));
	if(!$myrow['gl_account'])
            label_cell("No GL Impact", "colspan=2 align= 'center'");
        else{
            label_cell($myrow['gl_account']);
            label_cell(get_gl_account_name($myrow['gl_account']));
        }
	if(check_charge_in_trans($_POST['charge_group'])){
 		delete_button_cell("Delete".$myrow["id"], _("Delete"));
 		edit_button_cell("Edit".$myrow["id"], _("Edit"));
 	}
 	else{
 		label_cell("");
 		label_cell("");
 	}
	end_row();
}
end_table(1);

//-------------------------------------------------------------------------------------------------
if ($selected_id != -1){
 	if($Mode == 'Edit' && (!list_updated('var')&&!list_updated('charges')&&!list_updated('arith'))){
 		$row = db_fetch(get_supp_charges($selected_id));
 		$_POST['description'] = $row['description'];
 		$_POST['impact'] = $row['impact'];
 		$_SESSION['formula']->update_string($row['formula']);
 		$_POST['f_field'] = $row['formula'];
 		$_POST['selected_id'] = $row['id'];
 		$_POST['gl_account'] = $row['gl_account'];
	}
}
//ADD THE SELECTED VALUE IN FORMULA
if(list_updated('arith')){
	$_SESSION['formula']->store($_POST['arith']);
	$Ajax->activate('_page_body');
}
if(list_updated('charges')){
	$_SESSION['formula']->store($_POST['charges']);
	$Ajax->activate('_page_body');
}
if(list_updated('var')){
	$_SESSION['formula']->store($_POST['var']);
	$Ajax->activate('_page_body');
}
if(isset($_POST['f_field']) && (!list_updated('var')&&!list_updated('charges')&&!list_updated('arith')))
	$_SESSION['formula']->update_string($_POST['f_field']);

$_POST['f_field'] = $_SESSION['formula']->get_string();

if(($selected_id != -1 && $selected_id != null) || check_supp_charges($_POST['charge_group'])<8 && check_charge_in_trans($_POST['charge_group'])){
	
	start_table(TABLESTYLE5_BOX,"",0,0,0,null,"42%","3px solid #656E79;");

	text_cells_ex(_("Charge Name"), 'description', 30,null,null,null,null,null,false,null,5);
	start_row();
	arith_operator_list_cells("Arith Operators", 'arith', null, true);
	charge_list_cells("Charges", 'charges', null, true, $_POST['charge_group']);
	variable_list_cells("Variable", 'var', null, true);
	start_row();
	text_cells_ex(_("Factor"), 'f_field', 100,null,null,null,null,null,true,null,4);
	echo " <td>";
	submit_center_last('resetf', "Reset", _('Reset Formula'), false, false, null, 0, "auto");
	echo " </td>";
	start_row();
	impact_list_cells("Impact on Total", 'impact', null, false, 2);
	gl_all_accounts_list_cells("GL Account", 'gl_account', null, false, false, 
	_("No GL Impact"),false, false, false, 0, 2);

	hidden('selected_id', $_POST['selected_id']);
	hidden('charge_group', $_POST['charge_group']);

	end_table(1);
	
	submit_add_or_update_center(($selected_id == -1 || $selected_id == null), '', 'both');
}
else{
	start_table();
		if(!check_charge_in_trans($_POST['charge_group']))
			label_cell("Transaction Assoicatied,
				You are no longer allowed to create new charges or Edit the available ones. 
				Create new charge groups");
		else
			label_cell("Charge Limit Reached, You are no longer allowed to create new charges, Edit the available ones");
	end_table();
}


end_form();

end_page();
