<?php

$page_security = 'SA_MATERIALREQENTRIES';
$path_to_root = "..";
include($path_to_root . "/includes/session.inc");
add_access_extensions();

page(_($help_context = "Requisitions"));

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/purchasing/includes/db/requisitions_db.inc");
include_once($path_to_root . "/purchasing/includes/db/requisition_details_db.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/includes/ui/ui_lists.inc");
include_once($path_to_root . "/includes/db/inventory_db.inc");
simple_page_mode(true);
//-----------------------------------------------------------------------------------

if(isset($_GET['transfer_id']))
	$_POST['transfer_id'] = $_GET['transfer_id'];


$row =  get_open_requisition($_POST['transfer_id']);
if($row['transfered']== 1){
	display_notification(_("This requisition  is transfered."));
	echo '<ol class="rounded-list">';
	echo '<li>';
	submenu_option(_( "View &Dashboard."), '/purchasing/inquiry/material_requisition_dashboard.php');
	echo '</li></ol>';
	display_footer_exit();
}
else{
if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{

	//initialise no input errors assumed initially before we test
	$input_error = 0;


	if (strlen($_POST['quantity']) == 0) 
	{
		$input_error = 1;
		display_error(_("The quantity of use cannot be empty."));
		set_focus('quantity');
	}
	if(str_replace(",", "", $_POST['quantity']) < 0 || str_replace(",", "", $_POST['quantity']) == '0.00'){
		$input_error = 1;
		display_error("Order quantity must be greater then 0");
		set_focus('quantity');
		exit;


	}
	
	if(get_requisition_detail($selected_id)['order_quantity'] < str_replace(",","",$_POST['quantity'])){
		$input_error = 1;
		display_error("Quantity can not be greater then ordered quantity");
		set_focus('quantity');
		exit;
	}

	if ($input_error != 1) 
	{
    	if ($selected_id != -1) 
    	{
    	    $qty = str_replace(",","",$_POST['quantity']);
    		update_requisition_lpo($selected_id, $_POST['supplier_id'], $qty, input_num('price'));
			display_notification(_('Selected requisition details has been updated.'));
    	} 
    	
		$Mode = 'RESET';
	}
} 

//-----------------------------------------------------------------------------------

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	$transfer_id = $_POST['transfer_id'];
	$_POST['transfer_id'] = $transfer_id;
}

//-----------------------------------------------------------------------------------

function get_loc_code($loc_name){

  $sql = " SELECT loc_code FROM ".TB_PREF."locations WHERE location_name = '$loc_name' ";

  $result = db_query($sql,"no data get");
  $myrow = db_fetch($result);
  return $myrow["loc_code"];
}
function get_loc_name($loc_name){

  $sql = " SELECT location_name FROM ".TB_PREF."locations WHERE loc_code = '$loc_name' ";

  $result = db_query($sql,"no data get");
  $myrow = db_fetch($result);
  return $myrow["location_name"];
}//----------------------------------------------------------------------------------
function get_payroll_trans_prt_str($type, $trans_no, $label="", $icon=false, 
	$class='', $id='')
{

$viewer = "reporting";

	if ($type == ST_PURCHASE)
		$viewer .= "/rep2092.php";

	else
		return null;
if(!is_array($trans_no)) $trans_no = array($trans_no);

  $lbl = $label;
  $preview_str = '';

 foreach($trans_no as $trans) {
	if ($label == "")
		$lbl = $trans;
	if($preview_str!='') $preview_str .= ',';

	$preview_str .= viewer_link($lbl, $viewer."?trans_no=$trans&type=$type", 
		$class, $id, ICON_PRINT);

  }
  return $preview_str;
}

start_form();
start_outer_table(TABLESTYLE2, "width=70%");

table_section(1);
$row = get_open_requisition($_POST['transfer_id']);
	//var_dump($row);
if(get_user($_SESSION['wa_current_user']->user)['location_id']){
	echo "<tr><td>"._("Location From:")." </td><td>  ".get_loc_name(get_user($_SESSION['wa_current_user']->user)['location_id'])."</td></tr>";
	hidden('user_location', get_user($_SESSION['wa_current_user']->user)['location_id']);
}
else{
	locations_list_row(_("Location From:"), 'user_location', null, _('Select Location'), true);
}
echo "<tr><td>"._("Location To: ")." </td><td> ".get_loc_name($row['user_location'])."</td></tr>";

table_section(2);
echo "<tr><td>"._("Reference:")." </td><td>".$row['material_req_id']."</td></tr>";
echo "<tr><td>"._("Date:")." </td><td>". date('d-m-Y', strtotime( $row['application_date'])) ."</td></tr>";
echo "<tr><td>"._("Type:")." </td><td> Material Request</td></tr>";
	
	

end_outer_table(1); // outer table


$result = get_open_requisition_details(get_post('transfer_id'));

start_table(TABLESTYLE, "width=80%");

$th = array(_("RNo."), _("Request Date"),_("Item Code"), _("Item Name"), _("Purpose"), _("Quantity"), "", "");

table_header($th);
$k = 0;
$meta_forword = 0;
$stock_transfer_id = get_next_trans_no(ST_LOCTRANSFER);
while ($myrow = db_fetch($result)) 
{
	alt_table_row_color($k);	
	label_cell($myrow["material_req_detail_id"]);
	label_cell(sql2date($myrow["application_date"]));
	label_cell($myrow["item_code"]);
	label_cell($myrow["description"]);
	label_cell($myrow["purpose"]);
	label_cell($myrow["quantity"]);
	
        
// hidden('selected_id', $myrow["material_req_detail_id"]);
hidden('transfer_id', $_POST['transfer_id']);
 	edit_button_cell("Edit".$myrow['material_req_detail_id'], _("Edit"));
 label_cell(get_payroll_trans_prt_str(ST_PURCHASE, $myrow["material_req_id"], _("Print"), ICON_PRINT));

	end_row();
	if(isset($_POST['Process'])) {
	    $input_error = 0;
    	if($_POST['user_location'] == null){
    		display_error("Please select location from");
    		$input_error = 1;
    	}
    	
    	$qoh = 0;
    	$res = get_item_locations();
    	while($myrow_2 = db_fetch($res)){
    		if($myrow_2['main_store'] == 0)
    			continue;
    		$qoh += get_qoh_on_date($myrow['item_code'], $myrow_2['loc_code']);
    	}
    	$rowS = $qoh;
	    $transfer_id = $_POST['transfer_id'];

    	if($rowS < $myrow['quantity']){
    		display_error("Stock Is Insufficient for ".$myrow["description"]);
    		$input_error = 1;
    	}
	}

}
end_table(1);

if($input_error != 1){
	$result = get_open_requisition_details(get_post('transfer_id'));
	$inc = 1;
	while ($myrow = db_fetch($result)){
		if(isset($_POST['Process'])) {
		    if($inc == 1)
		        generate_transfered($_POST['transfer_id']);
            $inc ++;
			$location_to = $row['user_location'];
		    $location_from =  $_POST['user_location'];

			update_transfer_requision_location($myrow["material_req_id"], $_POST['user_location'], $_SESSION['wa_current_user']->user, date('Y-m-d'), $stock_transfer_id);

			add_stock_move(ST_LOCTRANSFER, $myrow["item_code"], $stock_transfer_id, $location_from,
			sql2date($myrow["application_date"]), $stock_transfer_id, -$myrow["quantity"], 0,2);

			add_stock_move(ST_LOCTRANSFER, $myrow["item_code"], $stock_transfer_id, $location_to,
				sql2date($myrow["application_date"]), $stock_transfer_id, $myrow["quantity"], 0,2);

		    $meta_forword = 1;

		}

	}
}

if($meta_forword == 1)
	meta_forward($_SERVER['PHP_SELF'], "transfer_id=".$_POST['transfer_id']);



//-----------------------------------------------------------------------------------

if ($selected_id != -1 && $input_error == 0) 
{
 	if ($Mode == 'Edit') {
		//editing an existing status code

		$myrow = get_requisition_detail($selected_id);
               
		$_POST['supplier_id']  = $myrow["supplier_id"];
		$_POST['item_code']  = $myrow["item_code"];
		$_POST['quantity']  = $myrow["quantity"];
		$_POST['price']  = $myrow["price"];
	}
	hidden('selected_id', $selected_id);
	start_table(TABLESTYLE2);

	$res = get_item_edit_info(get_post('item_code'));
	$dec =  $res["decimals"] == '' ? 0 : $res["decimals"];
	$units = $res["units"] == '' ? _('kits') : $res["units"];
	label_cell('Item');
	label_cell($_POST['item_code']."-".$res['description']);
	qty_row(_("Order Quantity:"), 'quantity', number_format2(1, $dec), '', $units, $dec);

	end_table(1);

	submit_add_or_update_center($selected_id == -1, '', 'both');
	br();
} 

hidden('transfer_id');
echo "<center>";
submit_cells('Process',_('Transfered'), true, false, true, false);
end_form();

//echo "<div align='center'><a href='requisition_allocations.php?po=yes'>"._("Transfered")."</a></div>\n";
//------------------------------------------------------------------------------------
}
end_page();

?>
