<?php

$path_to_root = "..";
$page_security = 'SA_PURCHASEORDER';
include_once($path_to_root . "/purchasing/includes/db/supcharge.inc");
include_once($path_to_root . "/includes/EvalMath.php");
include_once($path_to_root . "/purchasing/includes/po_class.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/purchasing/includes/db/suppliers_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

set_page_security( @$_SESSION['PO']->trans_type,
	array(	ST_PURCHORDER => 'SA_PURCHASEORDER',
			ST_SUPPRECEIVE => 'SA_GRN',
			ST_SUPPINVOICE => 'SA_SUPPLIERNEWINVOICE'),
	array(	'NewOrder' => 'SA_PURCHASEORDER',
			'ModifyOrderNumber' => 'SA_PURCHASEORDERMODIFY',
			'AddedID' => 'SA_PURCHASEORDER',
			'NewGRN' => 'SA_GRN',
			'AddedGRN' => 'SA_GRN',
			'NewInvoice' => 'SA_SUPPLIERNEWINVOICE',
			'ModifyInvoice' => 'SA_SUPPLIERNEWINVOICE',
			'AddedPI' => 'SA_SUPPLIERNEWINVOICE')
);

$js = '';
if ($SysPrefs->use_popup_windows)
	$js .= get_js_open_window(900, 500);
if (user_use_date_picker())
	$js .= get_js_date_picker();

if (isset($_GET['ModifyOrderNumber']) && is_numeric($_GET['ModifyOrderNumber'])) {

	$_SESSION['page_title'] = _($help_context = "Modify Purchase Order #") . $_GET['ModifyOrderNumber'];
	create_new_po(ST_PURCHORDER, $_GET['ModifyOrderNumber']);
	copy_from_cart();
} elseif (isset($_GET['NewOrder'])) {

	$_SESSION['page_title'] = _($help_context = "Purchase Order Entry");
	create_new_po(ST_PURCHORDER, 0);
	copy_from_cart();
} elseif (isset($_GET['NewGRN'])) {

	$_SESSION['page_title'] = _($help_context = "Direct GRN Entry");
	create_new_po(ST_SUPPRECEIVE, 0,$_GET['attachment']);
	copy_from_cart();
} elseif (isset($_GET['NewInvoice'])) {

	create_new_po(ST_SUPPINVOICE, 0,$_GET['attachment']);
	copy_from_cart();

	if (isset($_GET['FixedAsset'])) {
		$_SESSION['page_title'] = _($help_context = "Fixed Asset Purchase Invoice Entry");
		$_SESSION['PO']->fixed_asset = true;
	} else
		$_SESSION['page_title'] = _($help_context = "Direct Purchase Invoice Entry");	

} elseif (isset($_GET['ModifyInvoice']) && is_numeric($_GET['ModifyInvoice'])) {

	create_new_po(ST_SUPPINVOICE, $_GET['ModifyInvoice'],$_GET['attachment']);

	$allocs = get_payments_for($_GET['ModifyInvoice'], ST_SUPPINVOICE, $_SESSION['PO']->supplier_id); 
	
	$sql = "SELECT * FROM ".TB_PREF."bank_trans as bt 
					LEFT JOIN ".TB_PREF."supp_allocations as alloc
					ON alloc.trans_no_from = bt.trans_no 
					AND alloc.trans_type_from = bt.type 
	WHERE alloc.trans_type_to = ".db_escape(ST_SUPPINVOICE)."
	AND alloc.trans_no_to = ".db_escape($_GET['ModifyInvoice']);
	$bank_account = db_fetch(db_query($sql))['bank_act'];
	
	$_SESSION['PO']->cash_account = $bank_account;



		$po_trans_details = get_invoice_header_details($_GET['ModifyInvoice']);

		if($po_trans_details['po_ref']=='auto'){
			$_SESSION['PO']->void_order_no = $po_trans_details['order_no'];
			$_SESSION['PO']->void_grn_id = $po_trans_details['grn_id'];
		}

	if (isset($_GET['FixedAsset'])) {
		$_SESSION['page_title'] = _($help_context = "Modify Fixed Asset Purchase Invoice");
		$_SESSION['PO']->fixed_asset = true;
	} else
		$_SESSION['page_title'] = _($help_context = "Modify Direct Supplier Invoice");	

		$_SESSION['PO']->trans_type = ST_SUPPINVOICE;
		$_SESSION['PO']->trans_no = $_GET['ModifyInvoice'];

	$result = get_attachmen_by_trans_no($po_trans_details['trans_no'], $_SESSION['PO']->trans_type);
	while($attach = db_fetch($result)){
			$_SESSION['PO']->add_to_attachment_cart(count($_SESSION['PO']->line_attachment),  $attach['filename'], $attach['filetype'], $file_path, $attach['description']);
	}
	
	copy_from_cart();
 }

	



page($_SESSION['page_title'], false, false, "", $js);

if (isset($_GET['ModifyOrderNumber']))
	check_is_editable(ST_PURCHORDER, $_GET['ModifyOrderNumber']);

//---------------------------------------------------------------------------------------------------

check_db_has_suppliers(_("There are no suppliers defined in the system."));

//---------------------------------------------------------------------------------------------------------------

if (isset($_GET['AddedID'])) 
{
	$order_no = $_GET['AddedID'];
	$trans_type = ST_PURCHORDER;	

	if (!isset($_GET['Updated']))
		display_notification_centered(_("Purchase Order has been entered"));
	else
		display_notification_centered(_("Purchase Order has been updated") . " #$order_no");

	echo '<ol class="rounded-list">';
	echo '<li>';
	display_note(get_trans_view_str($trans_type, $order_no, _("&View this order"), false, '', '', $path_to_root, basename($_SERVER['PHP_SELF'])), 0, 1);
echo '</li><li>';
	display_note(print_document_link($order_no, _("&Print This Order"), true, $trans_type), 0, 1);
echo '</li><li>';

	display_note(print_document_link($order_no, _("&Email This Order"), true, $trans_type, false, "printlink", "", 1));
echo '</li><li><span>';

hyperlink_params($path_to_root . "/purchasing/po_receive_items.php", _("&Receive Items on this Purchase Order"), "PONumber=$order_no");

echo '</span></li><li><span>';
  // TODO, for fixed asset
	hyperlink_params($_SERVER['PHP_SELF'], _("Enter &Another Purchase Order"), "NewOrder=yes");
echo '</span></li><li><span>';
	
	hyperlink_no_params($path_to_root."/purchasing/inquiry/po_search.php", _("Select An &Outstanding Purchase Order"));
	
echo '</span></li></ol>';
	display_footer_exit();	

} elseif (isset($_GET['AddedGRN'])) {

	$trans_no = $_GET['AddedGRN'];
	$trans_type = ST_SUPPRECEIVE;

	display_notification_centered(_("Direct GRN has been entered"));
echo '<ol class="rounded-list">';
	echo '<li>';
	display_note(get_trans_view_str($trans_type, $trans_no, _("&View this GRN"), false, '', '', $path_to_root, basename($_SERVER['PHP_SELF'])), 0);
echo '</li><li>';
    $clearing_act = get_company_pref('grn_clearing_act');
	if ($clearing_act)	
		display_note(get_gl_view_str($trans_type, $trans_no, _("View the GL Journal Entries for this Delivery")), 1);
echo '</li><li><span>';
	hyperlink_params("$path_to_root/purchasing/supplier_invoice.php",
		_("Entry purchase &invoice for this receival"), "New=1");
echo '</span></li><li><span>';
	hyperlink_params("$path_to_root/admin/attachments.php", _("Add an Attachment"), 
		"filterType=$trans_type&trans_no=$trans_no");
echo '</span></li><li><span>';

	hyperlink_params($_SERVER['PHP_SELF'], _("Enter &Another GRN"), "NewGRN=Yes");
echo '</span></li></ol>';
	
	display_footer_exit();	

} elseif (isset($_GET['AddedPI'])) {

	$trans_no = $_GET['AddedPI'];
	$trans_type = ST_SUPPINVOICE;
echo '<ol class="rounded-list">';
	echo '<li>';
	display_notification_centered(_("Direct Purchase Invoice has been entered"));
echo '</li><li>';
	display_note(get_trans_view_str($trans_type, $trans_no, _("&View this Invoice"), false, '', '', $path_to_root, basename($_SERVER['PHP_SELF'])), 0);
echo '</li><li><br>';
display_note(print_document_link($trans_no, _("Print Supplier Invoice"), true, $trans_type, false, 'printlink', null, false, null, 'A4'));
echo '</li><li>';
	display_note(get_gl_view_str($trans_type, $trans_no, _("View the GL Journal Entries for this Invoice"), false, '', '', $path_to_root, basename($_SERVER['PHP_SELF'])), 1);
echo '</li><li><span>';
	hyperlink_params("$path_to_root/purchasing/supplier_payment.php", _("Entry supplier &payment for this invoice"),
		"trans_type=$trans_type&PInvoice=".$trans_no);
echo '</span></li><li><span>';
	hyperlink_params("$path_to_root/admin/attachments.php", _("Add an Attachment"), 
		"filterType=$trans_type&trans_no=$trans_no");
echo '</span></li><li><span>';
	hyperlink_params($_SERVER['PHP_SELF'], _("Enter &Another Direct Invoice"), "NewInvoice=Yes");
	echo '</span></li></ol>';
	display_footer_exit();	
}

if ($_SESSION['PO']->fixed_asset)
  check_db_has_purchasable_fixed_assets(_("There are no purchasable fixed assets defined in the system."));
else
  check_db_has_purchasable_items(_("There are no purchasable inventory items defined in the system."));
//--------------------------------------------------------------------------------------------------

function line_start_focus() {
  global 	$Ajax;

  $Ajax->activate('items_table');
   set_focus_for_dropdown('stock_id1');
//   set_focus('_stock_id_edit');
}
if (list_updated('stock_id1')){
	set_focus('stock_name');
}
//--------------------------------------------------------------------------------------------------

function unset_form_variables() {
	unset($_POST['stock_id']);
    unset($_POST['qty']);
    unset($_POST['price']);
    unset($_POST['req_del_date']);
    unset($_POST['long_description']);
    unset($_POST['discount']);
}

//---------------------------------------------------------------------------------------------------

function handle_delete_item($line_no)
{
	$_SESSION['PO']->remove_from_order($line_no);
	//unset_form_variables();
		
    line_start_focus();
}

function check_attachment_type($check_format){


	if (!in_array(substr($check_format,-4), array('.jpg','.JPG','.png','.PNG','.PDF','.pdf','jpeg','JPEG','.msg','.MSG','.xls','.XLS','.csv','.CSV','XLSX','xlsx'))){
			display_error(_('Files formate not supported'));
			return false;
		}

	return true;
}


function check_attachment_exist($file_name){
	$attachmen_area = company_path()."/attachments/".$file_name;
	if(file_exists($attachmen_area)){
		display_error("File Name Already Exist In Attachment Storage.");
		return false;
	}

	$temp_attachment = company_path()."/temp_attachment/".$file_name;
	if(file_exists($temp_attachment)){
		display_error("File Already Selected.");
		return false;
	}

	return true;
}

function handle_new_attachment(){

	$file_name = date('d_m_Y_H_i_s')."_".basename($_FILES["attachment"]["name"]);
	if(!check_attachment_type($file_name))
			return;
	
	if(!check_attachment_exist($file_name))
		return false;

	if (!file_exists(company_path()."/temp_attachment")) {
	    mkdir(company_path()."/temp_attachment", 0777, true);
	}
	move_uploaded_file($_FILES['attachment']['tmp_name'], company_path()."/temp_attachment/".$file_name);
	add_attachment_to_order($_SESSION['Items'], 
	$file_name, 
	$_FILES['attachment']['type'], 
	$_FILES['attachment']['tmp_name'], 
	$_POST['attach_title']);
	unset($_FILES['attachment']);
	unset($_POST['attach_title']);
	page_modified();
}

function handle_delete_attachment($line_no){
	    $_SESSION['PO']->remove_attachment_from_cart($line_no);
}

//---------------------------------------------------------------------------------------------------

function handle_cancel_po()
{
	global $path_to_root;
	
	//need to check that not already dispatched or invoiced by the supplier
	if(($_SESSION['PO']->order_no != 0) && 
		$_SESSION['PO']->any_already_received() == 1)
	{
		display_error(_("This order cannot be cancelled because some of it has already been received.") 
			. "<br>" . _("The line item quantities may be modified to quantities more than already received. prices cannot be altered for lines that have already been received and quantities cannot be reduced below the quantity already received."));
		return;
	}

	$fixed_asset = $_SESSION['PO']->fixed_asset;

	if($_SESSION['PO']->order_no != 0)
		delete_po($_SESSION['PO']->order_no);
	else {
		unset($_SESSION['PO']);

    	if ($fixed_asset)
			meta_forward($path_to_root.'/index.php','application=assets');
		else
			meta_forward($path_to_root.'/index.php','application=AP');
	}

	$_SESSION['PO']->clear_items();
	$_SESSION['PO'] = new purch_order;

	display_notification(_("This purchase order has been cancelled."));

	hyperlink_params($path_to_root . "/purchasing/po_entry_items.php", _("Enter a new purchase order"), "NewOrder=Yes");
	echo "<br>";

	end_page();
	exit;
}

//---------------------------------------------------------------------------------------------------

function check_data($charge=0)
{
	if(!get_post('stock_id_text', true)) {
		display_error( _("Item description cannot be empty."));
		set_focus('stock_id_edit');
		return false;
	}

	$dec = get_qty_dec($_POST['stock_id']);
	$min = 1 / pow(10, $dec);
    if (!check_num('qty',$min))
    {
    	$min = number_format2($min, $dec);
	   	display_error(_("The quantity of the order item must be numeric and not less than ").$min);
		set_focus('qty');
	   	return false;
    }

    if (!check_num('price', 0))
    {
	   	display_error(_("The price entered must be numeric and not less than zero."));
		set_focus('price');
	   	return false;	   
    }
    if ($_SESSION['PO']->trans_type == ST_PURCHORDER && !is_date($_POST['req_del_date'])){
    		display_error(_("The date entered is in an invalid format."));
		set_focus('req_del_date');
   		return false;    	 
    }
    if($charge+(input_num('qty')*input_num('price'))<0){
    	display_error(_("Line Total can not be negative"));
		set_focus('price');
   		return false;    	 
    }
    
    if(input_num('discount') < 0){
    	display_error(_("Entered Discount is Not Valid."));
		set_focus('discount');
   		return false;    	 
    }

    if(input_num('discount') > 100){
    	display_error(_("Discount can not be greater than 100%."));
		set_focus('discount');
   		return false;    	 
    }    
     
    return true;	
}

//---------------------------------------------------------------------------------------------------

function handle_update_item()
{
	$charge= $_SESSION['PO']->get_charge_amount(input_num('price'), input_num('qty'));
	$charge = round2($charge, user_price_dec());
	$allow_update = check_data($charge); 

	if ($allow_update)
	{
		if ($_SESSION['PO']->line_items[$_POST['line_no']]->qty_inv > input_num('qty') ||
			$_SESSION['PO']->line_items[$_POST['line_no']]->qty_received > input_num('qty'))
		{
			display_error(_("You are attempting to make the quantity ordered a quantity less than has already been invoiced or received.  This is prohibited.") .
				"<br>" . _("The quantity received can only be modified by entering a negative receipt and the quantity invoiced can only be reduced by entering a credit note against this item."));
			set_focus('qty');
			return;
		}
	
		$_SESSION['PO']->update_order_item($_POST['line_no'], input_num('qty'), input_num('price'),
  			@$_POST['req_del_date'], $_POST['item_description'], $charge, $_POST['long_description'], input_num('discount'));
		unset_form_variables();
	}	
    line_start_focus();
}

//---------------------------------------------------------------------------------------------------

function handle_add_new_item()
{
	$charge= $_SESSION['PO']->get_charge_amount(input_num('price'), input_num('qty'));
	$charge = round2($charge, user_price_dec());
	$allow_update = check_data($charge);
	
	if ($allow_update == true)
	{ 
		if (count($_SESSION['PO']->line_items) > 0)
		{
		    foreach ($_SESSION['PO']->line_items as $order_item) 
		    {
    			/* do a loop round the items on the order to see that the item
    			is not already on this order */
   			    if (($order_item->stock_id == $_POST['stock_id'])) 
   			    {
					display_warning(_("The selected item is already on this order."));
			    }
		    } /* end of the foreach loop to look for pre-existing items of the same code */
		}

		if ($allow_update == true)
		{
			$result = get_short_info($_POST['stock_id']);

			if (db_num_rows($result) == 0)
			{
				$allow_update = false;
			}

			if ($allow_update)
			{
				$_SESSION['PO']->add_to_order(count($_SESSION['PO']->line_items), $_POST['stock_id'], input_num('qty'), 
					get_post('stock_name'), //$myrow["description"], 
					input_num('price'), '', // $myrow["units"], (retrived in cart)
					$_SESSION['PO']->trans_type == ST_PURCHORDER ? $_POST['req_del_date'] : '', 0, 0, $charge, $_POST['long_description'], input_num('discount'));

				unset_form_variables();
				$_POST['stock_id']	= "";
	   		} 
	   		else 
	   		{
			     display_error(_("The selected item does not exist or it is a kit part and therefore cannot be purchased."));
		   	}

		} /* end of if not already on the order and allow input was true*/
    }
	line_start_focus();
}

//---------------------------------------------------------------------------------------------------

function add_attachment_to_order(&$order, $file_name, $file_type, $file_path, $attach_title=null){
	$_SESSION['PO']->add_to_attachment_cart(count($_SESSION['PO']->line_attachment),  $file_name, $file_type, $file_path, $attach_title);
}


//---------------------------------------------------------------------------------------------------

function can_commit()
{
	if (!get_post('supplier_id')) 
	{
		display_error(_("There is no supplier selected."));
		set_focus('supplier_id');
		return false;
	} 

	if (!is_date($_POST['OrderDate'])) 
	{
		display_error(_("The entered order date is invalid."));
		set_focus('OrderDate');
		return false;
	} 
	if (($_SESSION['PO']->trans_type == ST_SUPPRECEIVE || $_SESSION['PO']->trans_type == ST_SUPPINVOICE) 
		&& !is_date_in_fiscalyear($_POST['OrderDate'])) {
		display_error(_("The entered date is out of fiscal year or is closed for further data entry."));
		set_focus('OrderDate');
		return false;
	}

	if (($_SESSION['PO']->trans_type==ST_SUPPINVOICE) && !is_date($_POST['due_date'])) 
	{
		display_error(_("The entered due date is invalid."));
		set_focus('due_date');
		return false;
	} 

	if (!$_SESSION['PO']->order_no && !$_SESSION['PO']->trans_no) 
	{
    	if (!check_reference(get_post('ref'), $_SESSION['PO']->trans_type))
    	{
			set_focus('ref');
    		return false;
    	}
	}

	if ($_SESSION['PO']->trans_type == ST_SUPPINVOICE && trim(get_post('supp_ref')) == false)
	{
		display_error(_("You must enter a supplier's invoice reference."));
		set_focus('supp_ref');
		return false;
	}
    if (!$_SESSION['PO']->trans_no && $_SESSION['PO']->trans_type==ST_SUPPINVOICE 
 		&& is_reference_already_there($_SESSION['PO']->supplier_id, get_post('supp_ref'), $_SESSION['PO']->order_no))
	{
		display_error(_("This invoice number has already been entered. It cannot be entered again.") . " (" . get_post('supp_ref') . ")");
		set_focus('supp_ref');
		return false;
	}
	if ($_SESSION['PO']->trans_type == ST_PURCHORDER && get_post('delivery_address') == '')
	{
		display_error(_("There is no delivery address specified."));
		set_focus('delivery_address');
		return false;
	} 
	if (get_post('StkLocation') == '')
	{
		display_error(_("There is no location specified to move any items into."));
		set_focus('StkLocation');
		return false;
	} 
	if (!db_has_currency_rates($_SESSION['PO']->curr_code, $_POST['OrderDate'], true))
		return false;
	if ($_SESSION['PO']->order_has_items() == false)
	{
     	display_error (_("The order cannot be placed because there are no lines entered on this order."));
     	return false;
	}
	if (floatcmp(input_num('prep_amount'), $_SESSION['PO']->get_trans_total()) > 0)
	{
		display_error(_("Required prepayment is greater than total invoice value."));
		set_focus('prep_amount');
		return false;
	}
	if($_POST['import_price']>0)
    {
              if(!$_POST['import_gl_account'])
              {

                	display_error(_("Select gl account for import ."));
	    	        set_focus('import_gl_account');
	                exit();
		            return false;
              }

// display_error($_POST['import_price'].">".$_SESSION['PO']->get_trans_total());

	  if(str_replace(',', '', $_POST['import_price'])>$_SESSION['PO']->get_trans_total())
        {
          display_error(_("Import amount can not be greater then invoice amount ."));
		set_focus('import_price');
 
       //display_error($_SESSION['PO']->get_trans_total());
		     exit();
		return false;
        }

     }
    if($_POST['dimension'])
        $dimension_row = get_dimension($_POST['dimension']);
    if($_POST['dimension'] && !$dimension_row['exclude_from_sales']){

        $InvoicesSum = GetInvoiceSumByDimension($_POST['dimension']);
        $PurchsaesSum = GetPOSumByDimension($_POST['dimension'], $_SESSION['PO']->order_no);
        foreach($_SESSION['PO']->line_items as $lines){
            $PurchsaesSum += ($lines->price * $lines->quantity) - $lines->discount;
        }
        if(!$InvoicesSum){
            display_error("No Invoices Created against this dimension");
            return false;
        }else if(!$dimension_row['profit_margin']){
            display_error("No Profit Margin Setted Against Selectged Dimension");
            return false;
        }else if((($PurchsaesSum/$InvoicesSum)*100) > $dimension_row['profit_margin']){
            display_error("Purchases Getting Exceed From Profit Margin.");
            return false;
        }
    }
    

	return true;
}

function handle_commit_order()
{
	$cart = &$_SESSION['PO'];
	if (can_commit()) {
	    
		if($_SESSION['PO']->void_grn_id){
				
			$sql = "DELETE * FROM ".TB_PREF."grn_items WHERE grn_batch_id = ".db_escape($_SESSION['PO']->void_grn_id);
			db_query($sql);

			$sql = "DELETE * FROM ".TB_PREF."grn_batch WHERE id = ".db_escape($_SESSION['PO']->void_grn_id);
			db_query($sql);
	
    		if($_SESSION['PO']->void_order_no)
				delete_po($_SESSION['PO']->void_order_no);
				
		}	    

		copy_to_cart();
		$attachment_id = $cart->attachment;
		// display_error($attachment_id);exit;
		new_doc_date($attachment_id);
		if ($cart->order_no == 0) { // new po/grn/invoice
			$trans_no = add_direct_supp_trans($cart, $cart->trans_no);
			if ($trans_no) {
				unset($_SESSION['PO']);
				if ($cart->trans_type == ST_PURCHORDER){
					approve_direct_po($trans_no);
	 				meta_forward($_SERVER['PHP_SELF'], "AddedID=$trans_no");
				}elseif ($cart->trans_type == ST_SUPPRECEIVE){
					if ($attachment_id > 0) {
						link_document($attachment_id , $trans_no, $cart->trans_type);
					}
					approve_direct_grn($trans_no);
					meta_forward($_SERVER['PHP_SELF'], "AddedGRN=$trans_no");
				}
				else{
					if ($attachment_id > 0) {
						link_document($attachment_id , $trans_no, $cart->trans_type);
					}
					meta_forward($_SERVER['PHP_SELF'], "AddedPI=$trans_no");
				}
			}
		} else { // order modification
			$order_no = update_po($cart);
			unset($_SESSION['PO']);
        	meta_forward($_SERVER['PHP_SELF'], "AddedID=$order_no&Updated=1");	
		}
	}
}
//---------------------------------------------------------------------------------------------------
if (isset($_POST['update'])) {
	copy_to_cart();
	$Ajax->activate('items_table');
}

$id = find_submit('Delete');
if ($id != -1)
	handle_delete_item($id);

if (isset($_POST['Commit']))
{
	handle_commit_order();
}
if (isset($_POST['UpdateLine']))
	handle_update_item();

if (isset($_POST['EnterLine']))
	handle_add_new_item();

if (isset($_POST['CancelOrder'])) 
	handle_cancel_po();

if (isset($_POST['CancelUpdate']))
	unset_form_variables();

if (isset($_POST['CancelUpdate']) || isset($_POST['UpdateLine'])) {
	line_start_focus();
}

if (isset($_POST['AddAttachment']))
	handle_new_attachment();

$id = find_submit('del_attach');
if ($id!=-1)
	handle_delete_attachment($id);


//---------------------------------------------------------------------------------------------------

start_form(true);
		// if ($_SESSION['PO']->trans_type == ST_SUPPINVOICE) {
		// 	if (isset($_GET['attachment'])) {
		// 		hidden('attachment',$_GET['attachment']);
		// 	}
		// }
display_po_header($_SESSION['PO']);
echo "<br>";

if($_SESSION['PO']->trans_type == ST_SUPPINVOICE)
		add_attachment_view($_SESSION['PO']);

display_po_items($_SESSION['PO']);

start_table(TABLESTYLE2,'style=""');


if ($_SESSION['PO']->trans_type == ST_SUPPINVOICE) {
		cash_accounts_list_row(_("Payment:"), 'cash_account', null, true, _('Delayed'));
		if(list_updated('cash_account')){
			global $Ajax;
			$Ajax->activate('balance_row');
		}
		div_start('balance_row');
		bank_balance_row($_POST['cash_account']);
		div_end();
}

textarea_row(_("Memo:"), 'Comments', null, 70, 4);

end_table(1);

div_start('controls', 'items_table');
$process_txt = _("Place Order");
$update_txt = _("Update Order");
$cancel_txt = _("Cancel Order");
if ($_SESSION['PO']->trans_type == ST_SUPPRECEIVE) {
	$process_txt = _("Process GRN");
	$update_txt = _("Update GRN");
	$cancel_txt = _("Cancel GRN");
}	
elseif ($_SESSION['PO']->trans_type == ST_SUPPINVOICE) {
	$process_txt = _("Process Invoice");
	$update_txt = _("Update Invoice");
	$cancel_txt = _("Cancel Invoice");
}	
if ($_SESSION['PO']->order_has_items()) 
{
	if ($_SESSION['PO']->order_no)
		submit_center_first('Commit', $update_txt, '', 'default');
	else
		submit_center_first('Commit', $process_txt, '', 'default');
	submit_center_last('CancelOrder', $cancel_txt); 	
}
else
	submit_center('CancelOrder', $cancel_txt, true, false, 'cancel');
div_end();
//---------------------------------------------------------------------------------------------------
echo '</br>';
end_form();
end_page();
