<?php

$path_to_root = "..";
$page_security = 'SA_PURCHASEREQENTRIES';

include($path_to_root . "/includes/session.inc");
page(_($help_context = "Purchase Requisitions"));

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/purchasing/includes/db/purchase_requisitions_db.inc");
include_once($path_to_root . "/purchasing/includes/db/purchase_requisition_details_db.inc");

include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");


simple_page_mode(true);

if ($Mode=='ADD_ITEM' || $Mode=='UPDATE_ITEM') 
{


	$input_error = 0;
	if($_POST['user_location'] == null){
		display_error("Please select location ");
		$input_error = 1;
	}
	if ($input_error != 1) {
    	if ($selected_id != -1) {
			$_POST['user_name'] = $_SESSION["wa_current_user"]->user;
    		update_purchase_requisition($selected_id, $_POST['point_of_use'], $_POST['narrative'], $_POST['details'],$_POST['user_name'], $_POST['user_location']);
			display_notification(_('Selected requisition has been updated.'));
    	} 
    	else 
    	{
			$_POST['user_name'] = $_SESSION["wa_current_user"]->user;
    		add_purchase_requisition( $_POST['point_of_use'], $_POST['narrative'], $_POST['details'],$_POST['user_name'], $_POST['user_location']);
			display_notification(_('New requisition has been added'));
    	}
    	
		$Mode = 'RESET';
	}
}

function can_delete($selected_id)
{
	if (requisitions_in_purchase_details($selected_id))
	{
		display_error(_("Cannot delete this requisition because details transactions have been created referring to it."));
		return false;
	}
	
	return true;
}

function get_payroll_trans_prt_str($type, $trans_no, $label="", $icon=false, 
	$class='', $id='')
{

	$viewer = "reporting";
	if ($type == ST_PURCHASE)
		$viewer .= "/rep2093.php";
	else
		return null;
	if(!is_array($trans_no)) $trans_no = array($trans_no);
  		$lbl = $label;

  	$preview_str = '';

	foreach($trans_no as $trans) {
		if ($label == "")
			$lbl = $trans;
		if($preview_str!='') $preview_str .= ',';

		$preview_str .= viewer_link($lbl, $viewer."?trans_no=$trans&type=$type", 
		$class, $id, ICON_PRINT);

	}
 	return $preview_str;
} 

//-----------------------------------------------------------------------------------

if ($Mode == 'Delete')
{
	if (can_delete($selected_id))
	{
		delete_purchase_requisition($selected_id);
		display_notification(_('Selected requisition has been deleted'));
	}
	$Mode = 'RESET';
}

if ($Mode == 'RESET')
{
	$selected_id = -1;
	$sav = get_post('show_inactive');
	unset($_POST);
	$_POST['show_inactive'] = $sav;
}

//-----------------------------------------------------------------------------------

$result = get_all_requisitions(check_value('show_inactive'),$_SESSION["wa_current_user"]->user);

start_form();
start_table(TABLESTYLE4, "width=50%");

$th = array(_("RNo. "),_("Application Date"), "", "", _("Details"),"");
inactive_control_column($th);
table_header($th);
$k = 0;
while ($myrow = db_fetch($result)) 
{
	alt_table_row_color($k);	

	label_cell($myrow["material_req_id"]);
	label_cell(sql2date($myrow["application_date"]));

 	edit_button_cell("Edit".$myrow['material_req_id'], _("Edit"));
 	delete_button_cell("Delete".$myrow['material_req_id'], _("Delete"));
	inactive_control_cell($myrow["material_req_id"], $myrow["inactive"], 'material_requisition', 'material_req_id');

	echo "<td><a href='purchase_requisition_details.php?requisitionid=".$myrow['material_req_id']."'>"._("Details")."</a></td>\n";
           label_cell(get_payroll_trans_prt_str(ST_PURCHASE, $myrow["material_req_id"], _("Print"), ICON_PRINT));
	end_row();
}
inactive_control_row($th);
end_table(1);

//-----------------------------------------------------------------------------------

start_table(TABLESTYLE2);

if ($selected_id != -1) 
{
 	if ($Mode == 'Edit') {
		//editing an existing status code
		$myrow = get_purchase_requisition($selected_id);
		$_POST['point_of_use']  = $myrow["point_of_use"];
		$_POST['narrative']  = $myrow["narrative"];
		$_POST['details']  = $myrow["details"];
		$_POST['user_name'] = $myrow["user_name"];
		$_POST['user_location'] = $myrow["user_location"];

	}
	hidden('selected_id', $selected_id);
} 

if($_POST['user_name'] == 0 && $_POST['user_location'] == null){
	$_POST['user_name'] = $_SESSION["wa_current_user"]->name;
}
echo "<tr><td>"._("User Name ")." </td><td>".$_POST['user_name']."</td></tr>";
if(get_user_location($_SESSION["wa_current_user"]->user) != ''){
	echo "<tr><td>User Location </td><td>".get_user_location($_SESSION["wa_current_user"]->user)."</td></tr>";
	hidden('user_location', get_user($_SESSION['wa_current_user']->user)['location_id']);
}else{
	locations_list_row(_("Location:"), 'user_location', null, _('Select Location'), true);
}

textarea_row(_("Details :"), 'details', null, 50, 5);
end_table(1);
submit_add_or_update_center($selected_id == -1, '', 'both');
end_form();

//------------------------------------------------------------------------------------

end_page();

?>