<?php

$page_security = 'SA_RFQSEND';
$path_to_root = "..";

include_once($path_to_root . "/includes/ui/items_cart.inc");

include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/purchasing/includes/db/purchase_requisitions_db.inc");
include_once($path_to_root . "/purchasing/includes/db/purchase_requisition_details_db.inc");
include_once($path_to_root . "/purchasing/includes/ui/send_ref_ui.inc");
include_once($path_to_root . "/purchasing/includes/db/send_ref_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");


$js = "";
if ($use_popup_windows)
	$js .= get_js_open_window(900, 500);
if ($use_date_picker)
	$js .= get_js_date_picker();
page(_($help_context = "Send RFQ"), false, false, "", $js);

if(isset($_GET['processed'])){
	display_notification("RFQ Has been sent");
	display_footer_exit();
}

global $Ajax;

function handle_new_order(){
	if (isset($_SESSION['rfq']))
	{
		$_SESSION['rfq']->clear_items();
		unset ($_SESSION['rfq']);
	}
    $_SESSION['rfq'] = new items_cart(ST_INVADJUST);   
}

function handle_new_item()
{
	if($_POST['stock_id'] == null){
		display_error("Please select item");
		return;
	}elseif(get_post('qty') == null || get_post('qty') == '0.0' || input_num('qty') <= 0){
		display_error('Quantity should be greater than Zero');
		return;
	}elseif ($_SESSION['rfq']->rfq_item($_POST['stock_id'])){
         display_error(_("") . get_item($_POST['stock_id'])['description'] . " " . "This item is already on this document..");
    }else{
		$_SESSION['rfq']->add_to_rfq(count($_SESSION['rfq']->line_items), $_POST['stock_id'], $_POST['qty']); 
		line_start_focus();
	}
}
function handle_update_item(){
	if($_POST['stock_id'] == null){
		display_error("Please select item");
		return;
	}elseif(get_post('qty') == null || get_post('qty') == '0.0' || input_num('qty') <= 0){
		display_error('Quantity should be greater than Zero');
		return;
	}else{
		
		$_SESSION['rfq']->update_to_rfq($_POST['LineNo'], $_POST['stock_id'], $_POST['qty']); 
		line_start_focus();
	}
}
function line_start_focus() {
  global 	$Ajax;

  $Ajax->activate('items_table');
  unset($_POST['stock_id']);
  unset($_POST['qty']);
  set_focus('_stock_id_edit');
}

if(isset($_POST['Process'])){
	$error = 0;
	if($_POST['supplier_id'] == null){
		display_error("Please Select Supplier");
		$error = 1;
		return;
	}
	if(check_rfq_sent_to_supplier($_POST['rfq_id'],$_POST['supplier_id'])){
		display_error("RFQ already sent to selected Supplier");
		$error = 1;
		return;
	}

	if(!$error){
		add_rfq_items($_SESSION['rfq'],$_POST['rfq_id'],$_POST['supplier_id']);
		unset ($_SESSION['rfq']);
		$rfq = $_POST['rfq_id'];
		unset ($_POST);
		unset ($_POST['supplier_id']);
		$_GET['rfq_id'] = $rfq;
		$Ajax->activate('_page_body');
		display_notification("RFQ Has been sent");
		
		// meta_forward($_SERVER['PHP_SELF'],"processed=1");
	}
}


if (isset($_GET['rfq_id'])){
	handle_new_order();
}

if (isset($_POST['AddItem'])){
	handle_new_item();
}
if (isset($_POST['UpdateItem'])){
	handle_update_item();
}
if (isset($_POST['CancelItemChanges'])) {
	line_start_focus();
}


start_form(true);

display_rfq_header($_SESSION['rfq'], $_GET['rfq_id'] ? $_GET['rfq_id'] : $_POST['rfq_id']);
br();
start_outer_table(TABLESTYLE2, 'width:40% !important;', 10);
display_rfq_items(_("RFQ Items"), $_SESSION['rfq'] , $_GET['rfq_id'] ? $_GET['rfq_id'] : $_POST['rfq_id']);
end_outer_table(1, false);

submit_center_first('Process', 'Send RFQ', '', 'default');
echo "</br>";
echo "</br>";
// end_div();
end_form();
end_page();
