<?php

$page_security = 'SA_SUPPLIERQUOTATION';
$path_to_root = "..";


include_once($path_to_root . "/includes/session.inc");

include_once($path_to_root . "/includes/date_functions.inc");
include_once($path_to_root . "/includes/data_checks.inc");
include_once($path_to_root . "/includes/ui.inc");
include_once($path_to_root . "/purchasing/includes/db/purchase_requisitions_db.inc");
include_once($path_to_root . "/purchasing/includes/db/purchase_requisition_details_db.inc");
include_once($path_to_root . "/purchasing/includes/ui/send_ref_ui.inc");
include_once($path_to_root . "/purchasing/includes/db/supplier_quotation_db.inc");
include_once($path_to_root . "/reporting/includes/reporting.inc");

$js = "";
if ($use_popup_windows)
	$js .= get_js_open_window(900, 500);
if ($use_date_picker)
	$js .= get_js_date_picker();
page(_($help_context = "Supplier RFQ"), false, false, "", $js);

global $Ajax;

if(isset($_GET['update'])){
	display_notification("RFQ Has been Updated");
	display_footer_exit();
}

if(list_updated('supplier_id') || list_updated('pr_no'))
	$Ajax->activate('ext_tbl');

if(isset($_POST['UPDATE_ITEM'])){
	$result = get_rfq_details_items($_POST['pr_no'], $_POST['supplier_id']);
	while($row = db_fetch($result)){
		update_rfq_details_price($row['id'], str_replace(',', '', $_POST['price'.$row['id']]));
		$rfq_no = $row['rfq_id'];
	}
	add_audit_trail(114, $rfq_no, Today(), _('Supplier RFQ Updated'));
	unset($_POST);
	display_notification("RFQ Has been Updated");
	$Ajax->activate('_page_body');

	// meta_forward($_SERVER['PHP_SELF'],"update=1");
}

function get_pdf_repory($pr_no, $supplier_id, $label="", $icon=false, $class='', $id='')
{
	$viewer = "reporting/";
	$viewer .= "rep2094.php";

if(!is_array($pr_no)) $pr_no = array($pr_no);

  $lbl = $label;
  $preview_str = '';

 foreach($pr_no as $trans) {
	if ($label == "")
		$lbl = $trans;
	if($preview_str!='') $preview_str .= ',';
	$preview_str .= viewer_link($lbl, $viewer."?pr_no=$trans&supplier_id=$supplier_id", $class, $id, $icon);

  }
  return $preview_str;
}



start_form();
div_start('ext_tbl');
start_table(TABLESTYLE_NOBORDER);

pr_entry_list_cells(_("PR No.:"), 'pr_no', null, true, true);

pr_supplier_list_cells(_("Supplier:"), 'supplier_id', null, true, true, $_POST['pr_no']);

if($_POST['pr_no'] != null && $_POST['supplier_id'] != null){
	label_cell(get_pdf_repory($_POST['pr_no'], $_POST['supplier_id'] ,"<img src =".$path_to_root."/themes/".user_theme()."/images/".ICON_PRINT.">"));
}


end_table();

if($_POST['pr_no'] != null && $_POST['supplier_id'] != null){
	br();
	start_table(TABLESTYLE2);
	$th = array(_("Item Code"), _("Items Name"), _("Quantity"), _("Price"));
	table_header($th);
	$result = get_rfq_details_items($_POST['pr_no'], $_POST['supplier_id']);
	while($row = db_fetch($result)){
		start_row();
		label_cell($row['stock_id']);
		label_cell(get_item($row['stock_id'])['description']);
		label_cell(number_format($row['qty'],2));
		$_POST['price'.$row['id']] = price_format($row['price']);
		amount_cells(null, 'price'.$row['id']);
		end_row();
	}
	end_table();
	br();
	submit_add_or_update_center($selected_id == -1, '', 'both');
}

div_end();

end_form();
end_page();