<?php
$trans_id = $_POST['modal_trans_no'];
$type = $_POST['modal_type'];
$modal_id = $_POST['modal_modal_id'];

$page_security = 'SA_SUPPTRANSVIEW';
$path_to_root = "../..";
include_once($path_to_root . "/includes/EvalMath.php");
include($path_to_root . "/includes/session.inc");

modal_view_start_custom_title($modal_id,"Charge Breakup");

include_once($path_to_root . "/purchasing/includes/purchasing_db.inc");
include_once($path_to_root . "/includes/session.inc");
include_once($path_to_root . "/purchasing/includes/purchasing_ui.inc");
include_once($path_to_root . "/admin/db/tags_db.inc");
include_once($path_to_root . "/purchasing/includes/db/supcharge.inc");

//first we explode the trans_no to get charge group, price and quantity
$trans_id = explode("-", $trans_id);
$charge_group = $trans_id[0];
$qty = $trans_id[1];
$price = $trans_id[2];
$line_added = $trans_id[3];
$emath = new EvalMath();
$emath->v['Qty'] = $qty;
$emath->v['Price'] = $price;

start_table(TABLESTYLE2);

if(!$charge_group){
        display_heading("No charge group selected for this transaction");
        end_table();
        exit();
}

if (!$_SESSION['wa_current_user']->can_access_page('SA_SUPPLIECHARGESTRANSVIEW')) 
{ 
  display_note(_("The security settings on your account do not permit you to access this Page."));
  br(2);
    modal_view_end();
  exit;
}

display_heading("Charge Group Name: ".get_charge_group($charge_group)['description'], 
        'style = "font-size:20px; font-weight:bold; color:#3c8dbc;"');
echo '<br>';
if(!$line_added){
        display_heading("Line Item not yet Added / Updated");
        end_table();
        exit();
}
$th = array(_("ID"),  _("Charge Name"), _("Qty"), _("Price"),_("Formula"), _("Value"), _("GL Code"), 
    _("GL Impact"));
table_header($th);

$charges_res = get_supp_charges(0, $charge_group);

while($charges_row = db_fetch($charges_res)){
        // First get the formula string by replacing other formula if used by the current formula
        $math_equation = $charges_row['formula'];
        $res = get_supp_charges(0, $charge_group);
        while($row = db_fetch($res)){
            $math_equation = str_replace($row['description'],"(".$row['formula'].")",$math_equation);
        }
        // Need to do it again incase the formula which is replaced by equation previosuly has another formula in it
        $res = get_supp_charges(0, $charge_group);
        while($row = db_fetch($res)){
            $math_equation = str_replace($row['description'],"(".$row['formula'].")",$math_equation);
        }
        // Now calculate the amount
        $amount = $emath->evaluate($math_equation);
        if(!$charges_row['impact'])
                $amount = $amount*-1;

        start_row();
        label_cell($charges_row['id']);
        label_cell($charges_row['description']);
        label_cell(($qty? $qty: '0'));
        label_cell($price);
        label_cell($charges_row['formula']);
        amount_decimal_cell($amount, "", null, true);
        if(!$charges_row['gl_account'])
            label_cell("No GL Impact", "colspan=2 align= 'center'");
        else{
            label_cell($charges_row['gl_account']);
            label_cell(get_gl_account_name($charges_row['gl_account']));
        } 
        end_row();
}

end_table();
modal_view_end($trans_id,$type);
?>