<?php
$trans_id = $_POST['modal_trans_no'];
 $type = $_POST['modal_type'];
 $modal_id = $_POST['modal_modal_id'];
 $page_name = $_POST['page_name'];

$page_security = 'SA_SUPPTRANSVIEW';
$path_to_root = "../..";
include($path_to_root . "/purchasing/includes/po_class.inc");
include_once($path_to_root . "/purchasing/includes/db/supcharge.inc");
include_once($path_to_root . "/includes/EvalMath.php");

include($path_to_root . "/includes/session.inc");

$js = "";
if ($use_popup_windows)
  $js .= get_js_open_window(900, 500);
// page(_($help_context = "View Purchase Order Delivery"), true, false, "", $js);
modal_view_start($modal_id,$trans_id,"Purchase Order Delivery #");

include($path_to_root . "/purchasing/includes/purchasing_ui.inc");

if (!isset($trans_id))
{
  die ("<BR>" . _("This page must be called with a Purchase Order Delivery number to review."));
}


if (!$_SESSION['wa_current_user']->can_access_page('SA_SUPPLIERGRNTRANSVIEW')) 
{ 
  display_note(_(" The security settings on your account do not permit you to access this Page."));
  br(2);
    modal_view_end();
  exit;
}

$purchase_order = new purch_order;
read_grn($trans_id, $purchase_order);
$charges_on_net = get_company_pref('charges_on_net');
// display_heading(_("Purchase Order Delivery") . " #" . $trans_id,HEAD_COLOR);
// echo "<BR>";
if($page_name != null)
  display_grn_summary($purchase_order, '../', $page_name);
else  
  display_grn_summary($purchase_order, $path_to_root);

display_heading2(_("Line Details"));

start_table(TABLESTYLE2, "width='90%'");
if($purchase_order->charge_group){
  $th = array(_("Item Code"), _("Item Description"), _("Delivery Date"), _("Quantity"),
    _("Unit"), $charges_on_net ? _("Price") : _("Entered Price"), _("Amount"),_("Total Charge"), 
    _("Invoicing Price"), _("Line Total"), _("Quantity Invoiced"));
  if($charges_on_net){
    array_remove_by_value($th, "Amount");
    array_remove_by_value($th, "Total Charge");
    array_remove_by_value($th, "Invoicing Price");
    $extracols = 0;
  }
  else{
    $extracols = 3;
  }
}
else{
  $th = array(_("Item Code"), _("Item Description"), _("Delivery Date"), _("Quantity"),
    _("Unit"), _("Price"),_("Line Total"), _("Quantity Invoiced"));
  $extracols = 0;
}

table_header($th);

$total = 0;
$k = 0;  //row colour counter
$charge_total= 0;

foreach ($purchase_order->line_items as $stock_item)
{

  $line_total = ( $stock_item->qty_received * $stock_item->price ) - $stock_item->discount;
  if(!$charges_on_net)
    $line_total += $stock_item->charge;
  else
    $charge_total += $stock_item->charge;

  alt_table_row_color($k);

  label_cell($stock_item->stock_id);
  label_cell($stock_item->item_description."\n\n".$stock_item->long_description);
  label_cell($stock_item->req_del_date);#, "nowrap align=right"
  $dec = get_qty_dec($stock_item->stock_id);
  qty_cell($stock_item->qty_received, false, $dec);
  label_cell($stock_item->units);
  amount_decimal_cell($stock_item->price);
  if($purchase_order->charge_group && !$charges_on_net){
    amount_decimal_cell($stock_item->price*$stock_item->quantity);
    label_cell(($stock_item->charge>0? $stock_item->charge: "(".(-1*$stock_item->charge).")"));
    amount_cell($stock_item->price+($stock_item->charge/$stock_item->quantity));
  }
  amount_cell($line_total);
  qty_cell($stock_item->qty_inv, false, $dec);
  end_row();

  $total += $line_total;
}
$colspan = 6+$extracols;
if($charges_on_net){
  label_row(_("Gross Total"), number_format2($total,user_price_dec()),
  "align=right colspan= $colspan", "nowrap align=left", 1);
  label_row(_("Charge Total"), 
    ($charge_total>0? $charge_total: "(".(-1*$charge_total).")"),
  "align=right colspan= $colspan", "nowrap align=left", 1);
   $total += $charge_total;
}

$display_sub_tot = number_format2($total,user_price_dec());
label_row(_("Sub Total"), $display_sub_tot,
  "align=right colspan=$colspan", "nowrap align=left", 1);

$taxes = $purchase_order->get_taxes();
$tax_total = display_edit_tax_items($taxes, $colspan, $purchase_order->tax_included, 1);

$display_total = price_format(($total + $tax_total));

start_row();
label_cells(_("Amount Total"), $display_total, "colspan=$colspan align='right'","align='left'");
label_cell('');
end_row();


end_table(1);

is_voided_display(ST_SUPPRECEIVE, $trans_id, _("This delivery has been voided."));

// end_page(true, false, false, ST_SUPPRECEIVE, $trans_id);
modal_view_end($trans_id,$type,$path_to_root,$page_name);
?>



  