<?php
$trans_id = $_POST['modal_trans_no'];
 $type = $_POST['modal_type'];
 $modal_id = $_POST['modal_modal_id'];
 $page_name = $_POST['page_name'];
?>
<?php
$page_security = 'SA_SUPPTRANSVIEW';
$path_to_root = "../..";
include_once($path_to_root . "/purchasing/includes/db/supcharge.inc");
include($path_to_root . "/purchasing/includes/po_class.inc");
include_once($path_to_root . "/includes/EvalMath.php");
include($path_to_root . "/includes/session.inc");
include($path_to_root . "/purchasing/includes/purchasing_ui.inc");

$js = "";
if ($use_popup_windows)
  $js .= get_js_open_window(900, 500);
// page(_($help_context = "View Purchase Order"), true, false, "", $js);
modal_view_start($modal_id,$trans_id,"Purchase Order #");

if (!$_SESSION['wa_current_user']->can_access_page('SA_PURCHASEORDERTRANSVIEW')) 
{ 
  display_note(_("The security settings on your account do not permit you to access this Page."));
  br(2);
    modal_view_end();
  exit;
}

if (!isset($trans_id))
{
  die ("<br>" . _("This page must be called with a purchase order number to review."));
}

// display_heading(_("Purchase Order") . " #" . $trans_id,HEAD_COLOR);

$purchase_order = new purch_order;

read_po($trans_id, $purchase_order);
$charges_on_net = get_company_pref('charges_on_net');
display_po_summary($purchase_order, true);

start_table(TABLESTYLE, "width=90%", 6);
echo "<tr><td valign=top>"; // outer table

display_heading2(_("Line Details"));

start_table(TABLESTYLE, "colspan=9 width=100%");

if($purchase_order->charge_group){
  $th = array(_("Item Code"), _("Item Description"), _("Quantity"), _("Unit"), 
    $charges_on_net ? _("Price") : _("Entered Price"), _("Amount"), _("Total Charge"), 
    _("Invoicing Price"),_("Line Total"), _("Requested By"), _("Quantity Received"), 
    _("Quantity Invoiced"));
   if($charges_on_net){
    array_remove_by_value($th, "Amount");
    array_remove_by_value($th, "Total Charge");
    array_remove_by_value($th, "Invoicing Price");
    $extracols = 0;
  }
  else{
    $extracols = 3;
  }
}
else{
  $th = array(_("Item Code"), _("Item Description"), _("Quantity"), _("Unit"), _("Price"), 
     _("Discount"), _("Line Total"), _("Requested By"),  _("Quantity Received"), _("Quantity Invoiced"));
  $extracols = 0;
}
table_header($th);
$total = $k = 0;
$overdue_items = false;
$charge_total= 0;

foreach ($purchase_order->line_items as $stock_item)
{

  $line_total = ( $stock_item->quantity * $stock_item->price )- $stock_item->discount;
  if(!$charges_on_net)
    $line_total += $stock_item->charge;
  else
    $charge_total += $stock_item->charge;

  // if overdue and outstanding quantities, then highlight as so
  if (($stock_item->quantity - $stock_item->qty_received > 0) &&
    date1_greater_date2(Today(), $stock_item->req_del_date))
  {
      start_row("class='overduebg'");
      $overdue_items = true;
  }
  else
  {
    alt_table_row_color($k);
  }

  label_cell($stock_item->stock_id);
  label_cell($stock_item->item_description."\n".$stock_item->long_description);
  $dec = get_qty_dec($stock_item->stock_id);
  qty_cell($stock_item->quantity, false, $dec);
  label_cell($stock_item->units);
  amount_decimal_cell($stock_item->price);
  amount_decimal_cell($stock_item->discount);
  if($purchase_order->charge_group && !$charges_on_net){
    amount_cell($stock_item->price*$stock_item->quantity); 
    label_cell(($stock_item->charge>0? $stock_item->charge: "(".(-1*$stock_item->charge).")"));
    amount_cell($stock_item->price+($stock_item->charge/$stock_item->quantity)); 
  }
  amount_cell($line_total);
  label_cell($stock_item->req_del_date);
  qty_cell($stock_item->qty_received, false, $dec);
  qty_cell($stock_item->qty_inv, false, $dec);
  end_row();

  $total += $line_total;
}
$colspan = 6 + $extracols;

if($charges_on_net){
  label_row(_("Gross Total"), number_format2($total,user_price_dec()),
  "align=right colspan= $colspan", "nowrap align=left", 1);
  label_row(_("Charge Total"), 
    ($charge_total>0? $charge_total: "(".(-1*$charge_total).")"),
  "align=right colspan= $colspan", "nowrap align=left", 1);
  $total += $charge_total;
}

$display_sub_tot = number_format2($total,user_price_dec());
label_row(_("Sub Total"), $display_sub_tot,
  "align=right colspan=$colspan", "nowrap align=right",2);

$taxes = $purchase_order->get_taxes();
$tax_total = display_edit_tax_items($taxes, $colspan, $purchase_order->tax_included,2);

$display_total = price_format(($total + $tax_total));

start_row();
label_cells(_("Amount Total"), $display_total, "colspan=$colspan align='right'","align='right'");
label_cell('', "colspan=2");
end_row();

end_table();

if ($overdue_items)
  display_note(_("Marked items are overdue."), 0, 0, "class='overduefg'");

//----------------------------------------------------------------------------------------------------

$k = 0;

$grns_result = get_po_grns($trans_id);

if (db_num_rows($grns_result) > 0)
{

    echo "</td><td valign=top>"; // outer table

    display_heading2(_("Deliveries"));
    start_table(TABLESTYLE);
    $th = array(_("#"), _("Reference"), _("Delivered On"));
    table_header($th);
    while ($myrow = db_fetch($grns_result))
    {
    alt_table_row_color($k);
      if($page_name != null)
        label_cell(get_trans_view_str(ST_SUPPRECEIVE,$myrow["id"], "", false, '', '', '../', $page_name));
      else
        label_cell(get_trans_view_str(ST_SUPPRECEIVE,$myrow["id"], "", false, '', '', $path_to_root));
      label_cell($myrow["reference"]);
      label_cell(sql2date($myrow["delivery_date"]));
            label_cell(sql2date($myrow["delivery_date"]));

      end_row();
    }
    end_table();;
}

$invoice_result = get_po_invoices_credits($trans_id);

$k = 0;

if (db_num_rows($invoice_result) > 0)
{

    echo "</td><td valign=top>"; // outer table

    display_heading2(_("Invoices/Credits"));
    start_table(TABLESTYLE);
    $th = array(_("#"), _("Date"), _("Total"));
    table_header($th);
    while ($myrow = db_fetch($invoice_result))
    {
        if($myrow["Total"]==0) continue;
      alt_table_row_color($k);
       if($page_name != null)
        label_cell(get_trans_view_str($myrow["type"],$myrow["trans_no"], "", false, '', '', '../', $page_name));
      else  
        label_cell(get_trans_view_str($myrow["type"],$myrow["trans_no"], "", false, '', '', $path_to_root));
      
      label_cell(sql2date($myrow["tran_date"]));
      amount_cell($myrow["Total"]);
      end_row();
    }
    end_table();
}

echo "</td></tr>";

end_table(1); // outer table

//----------------------------------------------------------------------------------------------------

// end_page(true, false, false, ST_PURCHORDER, $trans_id);
modal_view_end($trans_id,$type,$path_to_root,$page_name);
?>
