<?php


/**
	Document blueprint use following parameters set in doctext.inc:

	$Addr1,	$Addr2 - address info
	$Payment_Terms - payment terms line
	$Footer - footer texts
	$this->company - company info
	$this->title - report title
	$this->formData - some other info
***/

		$this->row = $this->pageHeight - $this->topMargin;
$lineHeight1 =5;
		$upper = $this->row - 2 * $this->lineHeight;
		$lower = $this->bottomMargin + 8 * $this->lineHeight;
		$iline1 = $upper - 7.5 * $this->lineHeight;
		$iline2 = $iline1 - 8 * $this->lineHeight;
		$iline3 = $iline2 - 1.5 * $lineHeight1;
		$iline4 = $iline3 - 1.5 * $lineHeight1;
                $iline54 = $iline4 - 10 ;
		$iline5 = $iline4 + 10 * $lineHeight1;
		$iline6 = $iline5 - 1.5 * 12;
		$iline7 = $lower;
		$right = $this->pageWidth - $this->rightMargin;
		$width = ($right - $this->leftMargin) / 5;
		$icol = $this->pageWidth / 2;
		$ccol = $this->cols[0] + 4;
		$c2col = $ccol + 60;
		$ccol2 = $icol / 2;
		$mcol = $icol + 8;
		$mcol2 = $this->pageWidth - $ccol2;
		$cols = count($this->cols);
		$this->SetDrawColor(205, 205, 205);
		$this->Line($iline1, 3);
		$this->SetDrawColor(128, 128, 128);
		$this->Line($iline1);
		$this->rectangle($this->leftMargin, $iline5, $right - $this->leftMargin, $iline5 - $iline6, "F", null, array(222, 231, 236));   
		//$this->Line($iline54);
                $this->Line($iline5);
		$this->Line($iline6);
		$this->Line($iline7);
		//$this->LineTo($this->leftMargin, $iline2 ,$this->leftMargin, $iline4);
		$row = $this->leftMargin;
		for ($i = 0; $i < 5; $i++)
		{
			//$this->Line($iline54);
		}
		//$this->LineTo($right, $iline2 ,$right, $iline4);
		$this->LineTo($this->leftMargin, $iline5 ,$this->leftMargin, $iline7);
			
		/*	//$this->LineTo($this->cols[$cols-1] -15, $iline5 ,$this->cols[$cols-1] -15, $iline7);
//$this->LineTo($this->cols[$cols-1] -450, $iline5 ,$this->cols[$cols-1] -450, $iline7);//LINE 1
$this->LineTo($this->cols[$cols-1] -445, $iline5 ,$this->cols[$cols-1] -445, $iline7);//LINE 2
$this->LineTo($this->cols[$cols-1] -410, $iline5 ,$this->cols[$cols-1] -410, $iline7);//LINE 3
//$this->LineTo($this->cols[$cols-1] -205, $iline5 ,$this->cols[$cols-1] -205, $iline7);//LINE 4
//$this->LineTo($this->cols[$cols-1] -180, $iline5 ,$this->cols[$cols-1] -180, $iline7);//LINE 5
$this->LineTo($this->cols[$cols-1] -195, $iline5 ,$this->cols[$cols-1] -195, $iline7);//LINE 6
$this->LineTo($this->cols[$cols-1] -120, $iline5 ,$this->cols[$cols-1] -120, $iline7);//LINE 7
 if($this->formData['status'] == 'Transfered') {           
  $this->LineTo($this->cols[$cols-1] -80, $iline5 ,$this->cols[$cols-1] -80, $iline7);//LINE 8
  $this->LineTo($this->cols[$cols-1] -5, $iline5 ,$this->cols[$cols-1] -5, $iline7);//LINE 8
}*/
		$this->LineTo($right, $iline5 ,$right, $iline7);

		// Company Logo
		$this->NewLine();
		$logo = company_path() . "/images/" . $this->company['coy_logo'];
		if ($this->company['coy_logo'] != '' && file_exists($logo))
		{
			$this->AddImage($logo, $ccol, $this->row, 0, 40);
		}
		else
		{
			$this->fontSize += 4;
			$this->Font('bold');
			$this->Text($ccol, $this->company['coy_name'], $icol);
			$this->Font();
			$this->fontSize -= 4;
		}
		// Document title
		if ($this->l['a_meta_dir'] == 'rtl'){
		  //  $this->NewLine();
		$this->SetTextColor(190, 190, 190);
		$this->fontSize += 10;
		$this->Font('bold');
		$this->TextWrap($mcol-260, $this->row, $this->pageWidth - $this->rightMargin - $mcol - 20, $this->formData['title'], 'right');
		$this->Font();
		$this->fontSize -= 10;
		$this->NewLine();
		$this->SetTextColor(0, 0, 0);
		}else{
		$this->SetTextColor(190, 190, 190);
		$this->fontSize += 10;
		$this->Font('bold');
		$this->TextWrap($mcol, $this->row, $this->pageWidth - $this->rightMargin - $mcol - 20, $this->formData['title'], 'right');
		$this->Font();
		$this->fontSize -= 10;
		$this->NewLine(2);
		$this->fontSize += 8;
		$this->Font('bold');
		//$this->TextWrap($mcol, $this->row, $this->pageWidth - $this->rightMargin - $mcol - 20, _("Form No: FSP09/F01"), 'right');
		$this->Font();
		$this->fontSize -= 8;
		
		$this->SetTextColor(0, 0, 0);
		}
		$adrline = $this->row;

		// Company data
		$this->TextWrapLines($ccol, $icol, $this->company['postal_address']);
		$this->Font('italic');
		if (@$this->company['phone'])
		{
			$this->Text($ccol, _("Phone"), $c2col);
			$this->Text($c2col, $this->company['phone'], $mcol);
			$this->NewLine();
		}
		if (@$this->company['fax'])
		{
			$this->Text($ccol, _("Fax"), $c2col);
			$this->Text($c2col, $this->company['fax'], $mcol);
			$this->NewLine();
		}
		if (@$this->company['email'])
		{
			$this->Text($ccol, _("Email"), $c2col);

			$url = "mailto:" . $this->company['email'];
			$this->SetTextColor(0, 0, 255);
			$this->Text($c2col, $this->company['email'], $mcol);
			$this->SetTextColor(0, 0, 0);
			$this->addLink($url, $c2col, $this->row, $mcol, $this->row + $this->lineHeight);

			$this->NewLine();
		}
		if (@$this->company['gst_no'])
		{
			$this->Text($ccol, _("Our VAT No."), $c2col);
			$this->Text($c2col, $this->company['gst_no'], $mcol);
			$this->NewLine();
		}
		if (@$this->formData['domicile'])
		{
			$this->Text($ccol, _("Domicile"), $c2col);
			$this->Text($c2col, $this->company['domicile'], $mcol);
			$this->NewLine();
		}
		$this->Font();
		$this->row = $adrline;
		$this->NewLine(1);
		$this->Text($mcol + 80, _("Request Date:"));
		$this->Text($mcol + 180, sql2date($this->formData['document_date']));
		$this->NewLine();
		$this->Text($mcol + 80, _("Request#:"));
		$this->Text($mcol + 180, $this->formData['document_number']);
		$this->NewLine();
		$this->Text($mcol + 80, _("Status:"));
        
        if($this->formData['status'] == 'Transfered')
			$this->Text($mcol + 180, _("Transfered"));
        else if($this->formData['status'] == 'Completed')
			$this->Text($mcol + 180, _("Completed"));
        else
			$this->Text($mcol + 180, _("Not Completed"));
		$this->NewLine();
		if($this->formData['status'] == 'Transfered'){
			$this->Text($mcol + 80, _("Transfered Date:"));
			$this->Text($mcol + 180, sql2date($this->formData['transaction_date']));
			$this->NewLine();
			$this->Text($mcol + 80, _("Location Trans. #:"));
			$this->Text($mcol + 180, $this->formData['stock_moves_id']);
		}



		if ($this->pageNumber > 1)
			$this->Text($this->endLine - 20, _("Page") . ' ' . $this->pageNumber);
		$this->row = $iline1 ;
		$this->fontSize -= 0;
		$this->Text($ccol, $Addr1['title'], $icol);
		//$this->Text($mcol, $Addr1['point_of_use']);
		$this->fontSize += 0;

// address1
		$temp = $this->row = $this->row - $this->lineHeight - 4;
        $this->Text($ccol,_("User To:  ").ucfirst(get_user($Addr1['user_name'])['user_id']), $icol);
        $this->NewLine();
        $this->Text($ccol,_("Location To:  ").get_item_location($Addr1['user_location'])['location_name'], $icol);
        $this->NewLine();
        $this->Text($ccol,_("Details:  ").$Addr1['details'], $icol); 


// address2
		$this->row = $temp;
        if($this->formData['status'] == 'Transfered'){
        	$this->Text($mcol+70,_("User From:  ").ucfirst(get_user($Addr2['User_Name'])['user_id']), $icol);
        	$this->NewLine();
        	$this->Text($mcol+70,_("Location From:  ").get_item_location($Addr2['User_Location'])['location_name'], $icol);
        }
		
		$this->TextWrapLines($mcol, $this->rightMargin - $mcol, $Addr2['address']);

		// Auxiliary document information
		$col = $this->leftMargin;
		
	
		// Line headers
		$this->row = $iline5-12;
		$this->Font('bold');
		$count = count($this->headers);
		$this->cols[$count] = $right - 3;
		for ($i = 0; $i < $count; $i++)
			$this->TextCol($i, $i + 1, $this->headers[$i], -2);
		$this->Font();

		// Footer
		$this->Font('italic');
		$this->row = $iline7 - $this->lineHeight - 6;

		foreach ($Footer as $line => $txt)
		{
			if (!is_numeric($line))	// title => link
			{
				$this->fontSize -= 2;
				$this->TextWrap($ccol, $this->row, $right - $ccol, $line, 'C');
				$this->row -= $this->lineHeight;
				$this->SetTextColor(0, 0, 255);
				$this->TextWrap($ccol, $this->row, $right - $ccol, $txt, 'C');
				$this->SetTextColor(0, 0, 0);
				$this->addLink($txt, $ccol, $this->row, $this->pageWidth - $this->rightMargin, $this->row + $this->lineHeight);
				$this->fontSize += 2;
			}
			else
				$this->TextWrap($ccol, $this->row, $right - $ccol, $txt, 'C');
			$this->row -= $this->lineHeight;

		}

		$this->Font();
		$temp = $iline6 - $this->lineHeight - 2;
?>
