<?php

// Link to printing single document with bulk report template file.
// Ex. label_cell(print_document_link($myrow['order_no'], _("Print")), $type);
// or display_note(print_document_link($order_no, _("Print this order")));
// You only need full parameter list for invoices/credit notes

function print_document_access_link($doc_no, $link_text, $link=true, $type_no, 
	$icon=false, $class='printlink', $id='', $email=0, $extra=0, $size='A4', $meta_type= 0,$role=0)
{
	// display_error($role);
	$class='printlink';
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
 
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	switch ($type_no)
	{
    case 1000  :

			$rep = 1000;
			// from, to, email, comments, orientation
			$ar = array(
				'PARAM_0' => $role, 
				'PARAM_1' => 0, 
				'PARAM_2' => 0, 
				'PARAM_3' => $def_orientation
			);
			break;

		
	   
		default:
			return null;
	}
    if ($meta_type != 0)
        meta_print_link($link_text, $rep, $ar, "", $icon, $class, $id);
    else
	    return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

function client_dashboard_print($link_text, $link=true, $trans_type='', 
    $icon=false, $class='printlink', $id='', $cust, $branch, $sales_type, $fromdate, $todate, $dest=0){
        
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$class='printlink';
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	switch ($trans_type){
   		case SM_CUSTOMER :
			$rep = 854;
			$ar = array(
				'PARAM_0' => $dest,
			    'PARAM_1' => $cust,
				'PARAM_2' => $branch, 
				'PARAM_3' => $sales_type,
				'PARAM_4' => $fromdate,
				'PARAM_5' => $todate);
		break;
	}
	return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

function retention_dashboard_print($link_text, $link=true, $trans_type='', 
    $icon=false, $class='printlink', $id='', $cust, $branch, $sales_type, $date, 
	$amount=0, $stock_id=null, $days_before=0, $dest=0){
        
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$class='printlink';
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	switch ($trans_type){
   		case SM_CUSTOMER :
			$rep = 840;
			$ar = array(
				'PARAM_0' => $dest,
			    'PARAM_1' => $cust,
				'PARAM_2' => $branch, 
				'PARAM_3' => $sales_type,
				'PARAM_4' => $date,
				'PARAM_5' => $amount, 
				'PARAM_6' => $stock_id,
				'PARAM_7' => $days_before,

			);
		break;
	}
	return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

function print_sal_dashboard_print($link_text, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $id='',$from = '', $to = '', $stocklist= '', $ref='', $loc='' , $cust_id='', $order_no='', $order_view='',$dest=0  , $ShowUnApprove=null, $dimension_id=null)
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$class='printlink';
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	switch ($trans_type)
	{
	
       case ST_SALESQUOTE :
			$rep = 850;
			$ar = array(
				'PARAM_0' => $dest,
			    'PARAM_1' => $trans_type,
				'PARAM_2' => $from, 
				'PARAM_3' => $to,
				'PARAM_4' => $stocklist,
				'PARAM_5' => $ref,
				'PARAM_6' => $loc,
				'PARAM_7' => $cust_id,
				'PARAM_8' => $order_no,
				'PARAM_9' => $order_view,
				'PARAM_10' => $def_orientation,
				'PARAM_11' => $ShowUnApprove);
			break;

	   case ST_SALESORDER :
			$rep = 850;
			$ar = array(
				'PARAM_0' => $dest,
			    'PARAM_1' => $trans_type,
				'PARAM_2' => $from, 
				'PARAM_3' => $to,
				'PARAM_4' => $stocklist,
				'PARAM_5' => $ref,
				'PARAM_6' => $loc,
				'PARAM_7' => $cust_id,
				'PARAM_8' => $order_no,
				'PARAM_9' => $order_view,
				'PARAM_10' => $def_orientation,
				'PARAM_12' => $dimension_id);
			break;
     //---------------------------------------------------------
	

	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//------------------------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------------------------

//zeeshan-------------------------------------------------------------------------------------------------------------------
function print_cust_inq_dashboard_print($doc_no, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $id='',$from='', $to= '', $cust_id='', $filter='', $destination=0, $dimension_id=null)
{

global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case CUSTINQ :
			$rep = 851;
			$ar = array(
			    'PARAM_0' => $trans_type,
				'PARAM_1' => $from, 
				'PARAM_2' => $to,
				'PARAM_3' => $cust_id,
				'PARAM_4' => $filter,
				'PARAM_5' => $destination,
				'PARAM_6' => $def_orientation,
				'PARAM_7' => $dimension_id);
			break;

 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}
// ====================================

function print_stock_item_report($doc_no, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $id='',$stock_id=null,$show_inactive=null, $destination=0)
{

global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case SM_ITEMSTOCK:
			$rep = 856;
			$ar = array(
			    'PARAM_0' => $trans_type,
				'PARAM_1' => $stock_id, 
				'PARAM_2' => $show_inactive,
				'PARAM_3' => $destination,
			);
			break;

 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}
//------------------------------------------------------------------------------------------------------------------------
function print_pur_dashboard_print($dest=0, $link_text, $also_closed=false, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $id='',$from='', $to= '', $supplier_id='', $stocklocation='', $order_no='',
	$stocklist='', $dimension_id=null)
{


global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case PURINQ :
			$rep = 950;
			$ar = array(
                'PARAM_0' => $dest,
                'PARAM_1' => $also_closed,
			    'PARAM_2' => $trans_type,
                'PARAM_3' => $from, 
                'PARAM_4' => $to,
                'PARAM_5' => $stocklist,
                'PARAM_6' => $supplier_id,
                'PARAM_7' => $stocklocation,
                'PARAM_8' => $order_no,
                'PARAM_9' => $def_orientation,
                'PARAM_10' => $dimension_id);
			break;
		
		case ST_LOCTRANSFER :
			case ST_INVADJUST :
			
			$rep = 953;
			$ar = array(
                'PARAM_0' => $dest,  
                'PARAM_1' => $also_closed, // from location 
			    'PARAM_2' => $trans_type,   //  filter type
                'PARAM_3' => $from,   // from date
                'PARAM_4' => $to,    // todate 
                'PARAM_5' => $supplier_id,  //  items
                'PARAM_6' => $stocklocation,  // to location 
                'PARAM_7' => $order_no,   // order no
                'PARAM_8' => $order_no,
                'PARAM_9' => $def_orientation
            );
			break;

 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

//zeeshan------------------------------------------------------------------------------------------------------------------------
function print_supp_alloc_dashboard_print($dest=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='',$frm='', $to= '', $filter='', $supp_id='', $show_settled='' )
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case SUPPALLOC :
			$rep = 952;
			$ar = array(
                'PARAM_0' => $show_settled,
                'PARAM_1' => $filter,
                'PARAM_2' => $dest,
			    'PARAM_3' => $trans_type,
                'PARAM_4' => $frm, 
                'PARAM_5' => $to,
                'PARAM_6' => $supp_id,
                'PARAM_7' => $def_orientation);
				
					break;
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//zeeshan------------------------------------------------------------------------------------------------------------------------


function print_pur_supp_inq_dashboard_print($doc_no, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $id='',$from='', $to= '', $supplier_id='', $filter, $destination=0, $dimension_id=null)
{


global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case SUPINQ :
			$rep = 951;
			$ar = array(
			    'PARAM_0' => $trans_type,
                'PARAM_1' => $from, 
                'PARAM_2' => $to,
                'PARAM_3' => $supplier_id,
                'PARAM_4' => $filter,
                'PARAM_5' => $destination,
                'PARAM_6' => $def_orientation,
                'PARAM_7' => $dimension_id);
			break;

 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

//----------------------------------------------------------------------------------------------------------------------------

	


function print_stck_mov_dashboard_print($dest=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='',$stock_id='', $aft_date= '', $bef_date='', $stock_loc='' , $type=0  )
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case ITEMMOV :
			$rep = 960;
			$ar = array(
                'PARAM_0' => $stock_loc,
                'PARAM_1' => $dest,
                'PARAM_2' => $trans_type,
                'PARAM_3' => $aft_date,
			    'PARAM_4' => $bef_date,
                'PARAM_5' => $stock_id, 
                'PARAM_6' => $def_orientation,
                'PARAM_7' => $trans_type
                );
				
					break;
		 case FIXEDMOV :
			$rep = 960;
			$ar = array(
                'PARAM_0' => $stock_loc,
                'PARAM_1' => $dest,
                'PARAM_2' => $trans_type,
                'PARAM_3' => $aft_date,
			    'PARAM_4' => $bef_date,
                'PARAM_5' => $stock_id, 
                'PARAM_6' => $def_orientation,
                'PARAM_7' => $trans_type
                );
				
					break;
					
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

//-------------------------------------------------------------------------------------------------------------------

function print_stck_stat_dashboard_print($dest=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='',$stock_id='' )
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case ITEMSTAT :
			$rep = 961;
			$ar = array(
                'PARAM_0' => $stock_id,
                'PARAM_1' => $dest,
                'PARAM_2' => $trans_type,
                'PARAM_3' => $def_orientation);
				
					break;
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}



//-----------------------------------------------------------------------------------------------------------------------

function print_journal_inquiry_dashboard_print($dest=0, $reference=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='', $filter='', $from, $to,  $memo, $also_closed, $user_id='',$efrom=null,$eto=null )

{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
		
       case JOURINQ :
			$rep = 970;
			$ar = array(
                'PARAM_0' => $reference,
                'PARAM_1' => $user_id,
                'PARAM_2' => $also_closed,
                'PARAM_3' => $dest,
                'PARAM_4' => $trans_type,
                'PARAM_5' => $filter,
                'PARAM_6' => $from,
                'PARAM_7' => $to,
                'PARAM_8' => $memo,
				'PARAM_9' => $efrom,
                'PARAM_10' => $eto,
				'PARAM_11' => $def_orientation);
				
					break;
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//------------------------------------------------------------------------------------------------------------------------
//-----------------------------------------------------------------------------------------------------------------------


function print_account_inquiry_dashboard_print($dest=0, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='', $id='', $fromdate, $todate, $trans_no=0, $account, $dimension1, $dimension2, $amount_min=0, $amount_max=0 )

{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
		
       case BANKINQ :
			$rep = 971;
			// from, to, currency, email, comments, orientation
			$ar = array(
                'PARAM_0' => $account,
                'PARAM_1' => $dest,
                'PARAM_2' => $fromdate,
                'PARAM_3' => $todate,
                'PARAM_4' => $trans_no,
                'PARAM_5' => $dimension1,
                'PARAM_6' => $dimension2,
                'PARAM_7' => $amount_min,
                'PARAM_8' => $amount_max,         
				'PARAM_9' => $def_orientation);
				
				break;
 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//------------------------------------------------------------------------------------------------------------------------


function print_bank_dashboard_print($dest=0, $bank_acc, $link_text, $link=true, $trans_type=0, 
	$icon=false, $class='printlink', $id='',$from = '', $to = '')
{


global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);


	switch ($trans_type)
	{
       case BNKINQ :
			$rep = 972;
			$ar = array(
				'PARAM_0' => $dest,
				'PARAM_1' => $from, 
				'PARAM_2' => $to,
				'PARAM_3' => $bank_acc,
			    'PARAM_4' => $trans_type,
				'PARAM_5' => $def_orientation);
			break;

}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//-----------------------zeeshan---------------------------------------------------------------------------------------





function print_tax_dashboard_print($dest=0, $link_text, $link=true, $trans_type=0, 
	$icon=false, $class='printlink', $id='',$from = '', $to = '')
{


global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
// display_error($to);

// display_error($from.'   '.$to);

	switch ($trans_type)
	{
	    
       case TAXINQ :
			$rep = 973;
			$ar = array(
				'PARAM_0' => $dest,
				'PARAM_1' => $from, 
				'PARAM_2' => $to,
			    'PARAM_3' => $trans_type,
				'PARAM_4' => $def_orientation);
			break;
		case 901 :
			$rep = 901;
			$ar = array(
				'PARAM_0' => $from, 
				'PARAM_1' => $to,
				'PARAM_2' => $def_orientation,
				'PARAM_3' => $dest,
				);
			break;
		case 902 :
			$rep = 902;
				$ar = array(
				'PARAM_0' => $from, 
				'PARAM_1' => $to,
				'PARAM_2' => $def_orientation,
				'PARAM_3' => $dest,
				);
			break;
		case 904 :
			$rep = 904;
				$ar = array(
				'PARAM_0' => $from, 
				'PARAM_1' => $to,
				'PARAM_2' => $def_orientation,
				'PARAM_3' => $dest,
				);
			break;
		case 905 :
			$rep = 905;
			$ar = array(
				'PARAM_0' => $from, 
				'PARAM_1' => $to,
				'PARAM_2' => $def_orientation,
				'PARAM_3' => $dest,
				);
			break;

}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//------------------------------------------------------------------------------------------------------------------------

// function pprint_tax_dashboard_print($dest=0, $link_text, $link=true, $trans_type=0, 
// 	$icon=false, $class='printlink', $id='',$dimension1 = '', $dimension2 = '', $from='', $to, $balance)
// {


// global $path_to_root;
// 	include_once($path_to_root . "/includes/types.inc");

// 	$url = $path_to_root.'/reporting/prn_redirect.php?';
// 	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
// // display_error($to);

// display_error($balance);

// 	switch ($trans_type)
// 	{
//        case TRIALINQ :
// 			$rep = 974;
// 			$ar = array(
// 				'PARAM_0' => $dest,
// 				'PARAM_1' => $from, 
// 				'PARAM_2' => $to,
// 			    'PARAM_3' => $trans_type,
// 			    'PARAM_4' => $dimension1,
// 			    'PARAM_5' => $dimension2,
// 			    'PARAM_6' => $balance,
// 			    'PARAM_7' => $def_orientation);
// 			break;

// }
// return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
// }
//-------------------------------------------------------------------------------------------


function print_dim_dashboard_print($dest=0, $opencheck=0, $duecheck=0, $link_text, $link=true, $trans_type=0, 
	$icon=false, $class='printlink', $id='',$from_date = '', $to_date = '', $order_no='', $type_, $dimension_id=null)
{

global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case DIMINQ :
			$rep = 502;
			$ar = array(
				'PARAM_0' => $dimension_id,
				'PARAM_1' => $dimension_id, 
				'PARAM_2' => null,
			    'PARAM_3' => $order_no,
			    'PARAM_4' => $from_date,
			    'PARAM_5' => $to_date,
			    'PARAM_6' => $duecheck,
			    'PARAM_7' => $opencheck,
			);

			break;

}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}
//----------------------------------------------------------------------------------------------------------------

function print_used_dashboard_print($dest=0, $link_text, $link=true, $trans_type=0, 
	$icon=false, $class='printlink', $id='', $stock_id)
{

global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case USEDINQ :
			$rep = 990;
			$ar = array(
				'PARAM_0' => $dest,
				'PARAM_1' => $stock_id,
			    'PARAM_2' => $def_orientation);

			break;

}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}

//----------------------------------------------------------------------------------------------------------

// HRM module link

function Print_site_report_link($doc_no, $link_text, $link=true, $trans_type, 
	$icon=false, $class='printlink', $id='', $email=0, $extra=0, $size='A4',$is_excel=0)
{

global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
		  case	ST_PAYROLL_DASHBOARD :
		  $rep = 1033;
				$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => ($is_excel) ? 1 :0 );

			break;


	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}



function chq_print_document_link($doc_no, $link_text, $link=true, $type_no, 
	$icon=false, $class='printlink', $id='', $email=0, $extra=0, $size='A4', $meta_type= 0,$workorder_id)
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
 
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	switch ($type_no)
	{
		case ST_SUPPAYMENT :
			$rep = 212;
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
			break;
		
		case ST_BANKPAYMENT :
			$rep = 976;
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => '', 
				'PARAM_6' => $def_orientation);
			break;
			
		case ST_BANKTRANSFER :
			$rep = 977;
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => '', 
				'PARAM_6' => $def_orientation);
			break;	
				
		 
		default:
			return null;
	}
    if ($meta_type != 0)
        meta_print_link($link_text, $rep, $ar, "", $icon, $class, $id);
    else
	    return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}



function print_document_link($doc_no, $link_text, $link=true, $type_no, 
	$icon=false, $class='printlink', $id='', $email=0, $extra=0, $size='A4', $meta_type= 0,$workorder_id)
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
 
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	switch ($type_no)
	{
	

	         
	case ST_BAR_CODE :
    case ST_QR_CODE  :

			$rep = 3033;
			// from, to, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => $type_no, 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => '', 
				'PARAM_6' => ($rep == 3033 || $rep == 1071 ) ? '' : $def_orientation);
			if ($rep == 3033 || $rep == 1071 )
				$ar['PARAM_7'] = $def_orientation;
			break;

		
	        case ST_SALESINVOICE1 :
			$rep = 19099;
			$ar = array(
				'PARAM_0' => $doc_no,
				'PARAM_1' => $doc_no,
				'PARAM_2' => '',
				'PARAM_3' => $email,
				'PARAM_4' => 0,
				'PARAM_5' => '',
				'PARAM_6' => $def_orientation);
			break;
	 
	
	        // pk
	case ST_BANKPAYMENT :
			$rep = 974;
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => '', 
				'PARAM_6' => $def_orientation);
			break;
	case ST_BANKDEPOSIT :
			$rep = 975;
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => '', 
				'PARAM_6' => $def_orientation);
			break;
			
	case ST_SUPPINVOICE :	// for supplier invoice
		$rep = 211;
		$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => '', 
				'PARAM_6' => '',
				'PARAM_7' => $def_orientation);
			break;		
	
	
	
	
			case ST_JOURNAL1 :	// For Journal Entry Print
		$rep = 01;
        $ar = array(
            'PARAM_0' => $doc_no, 
            'PARAM_1' => $def_orientation);
    	break;
	
	
	
	
  case ST_SALESQUOTE :
		if($size=='A4')
			$rep = 111;

		if($size=='A5')
			$rep = 1111;

			// from, to, currency, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
			break;

	case 850 :
			$rep = 850;
			// from, to, currency, email, comments, orientation
			$ar = array(
					'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation,
				'PARAM_6' => $view_mode, 
				'PARAM_7' => $stocklist, 
				'PARAM_8' => $orders_AD, 
				'PARAM_9' => $orders_TD, 
				'PARAM_10' => $orders_ref, 
				'PARAM_11' => $stock_loc,
				'PARAM_12' => $cust_id ,
				'PARAM_13' => $trans_type );



			break;

		case ST_SALESORDER :

		if($size=='A4')
			$rep = 109;
		
		if($size=='A5')
			$rep = 1091;

			// from, to, currency, email, quote, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => 0, 
				'PARAM_5' => '',
				'PARAM_6' => $def_orientation);
			break;
		case ST_CUSTDELIVERY :
		if($size=='A4')
			$rep = 119;

		if($size=='A5')
			$rep = 1101;
			// from, to, email, packing slip, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => $email,
				'PARAM_3' => $extra,
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
			break;
        case ST_CUSTDELIVERY :
		case ST_CUSTDELIVERY1 :
		if($size=='A4')
			$rep = 120;

		if($size=='A5')
			$rep = 1101;
			// from, to, email, packing slip, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => $email,
				'PARAM_3' => $extra,
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
		break;	

		case ST_SALESINVOICE : // Sales Invoice
		case ST_CUSTCREDIT : // Customer Credit Note

		if($size=='A4')
			$rep = $type_no==ST_CUSTCREDIT ? 113 : 107;

		if($size=='A5')
			$rep = $type_no==ST_CUSTCREDIT ? 113 : 1071;

			// from, to, currency, email, paylink, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => '', 
				'PARAM_6' => ($rep == 107 || $rep == 1071 ) ? '' : $def_orientation);
			if ($rep == 107 || $rep == 1071 )
				$ar['PARAM_7'] = $def_orientation;
			break;
		case ST_PURCHORDER :
			$rep = 209;
			// from, to, currency, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
			break;


		 case ST_LOCTRANSFER : // Sales Invoice
		case ST_INVADJUST : // Customer Credit Note
		$rep = 1092;
		      	$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => 0, 
				'PARAM_5' => '',
				'PARAM_6' => $def_orientation);
			break;

		case ST_CUSTPAYMENT :
			// from, to, currency, comments, orientation
		if($size=='A4')
			$rep = 112;
		
		if($size=='A5')
			$rep = 1121;
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => '',
				'PARAM_4' => $def_orientation);
			break;
		case ST_SUPPAYMENT :
			$rep = 210;
			// from, to, currency, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => '', 
				'PARAM_3' => $email, 
				'PARAM_4' => '',
				'PARAM_5' => $def_orientation);
			break;
		case ST_WORKORDER :
			$rep = 409;
			// from, to, email, comments, orientation
			$ar = array(
				'PARAM_0' => $doc_no, 
				'PARAM_1' => $doc_no, 
				'PARAM_2' => $email, 
				'PARAM_3' => '', 
				'PARAM_4' => $def_orientation);
			break;
		case ST_WORKORDER_GL :
			$rep = 702;
			// from, to, email, comments, orientation
			$ar = array(
				'PARAM_0' => sql2date($doc_no), 
				'PARAM_1' => sql2date($doc_no), 
				'PARAM_2' => ST_WORKORDER,
				'PARAM_6' => $workorder_id);
			break;
		default:
			return null;
	}
    if ($meta_type != 0)
        meta_print_link($link_text, $rep, $ar, "", $icon, $class, $id);
    else
	    return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


//-----------------------------------------------------------------------------------------------------

function opportunity_inq_dashboard_rep($doc_no, $link_text, $link=true, $trans_type='', 
	$icon=false, $class='printlink', $from='',$to='', $user= '', $opportunity='', $status='',$public='',$closed='', $project ='',$private ='', $destination=0 )
{
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");

	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);

	switch ($trans_type)
	{
       case ST_OPPORTUNITYINQ :
			$rep = 991;
			$ar = array(
			    'PARAM_0' => $doc_no,
				'PARAM_1' => $from, 
				'PARAM_2' => $to,
				'PARAM_3' => $user,
				'PARAM_4' => $opportunity,
				'PARAM_5' => $status,
				'PARAM_6' => $public,
				'PARAM_7' => $closed,	
				'PARAM_8' => $project,
				'PARAM_9' => $private,
				'PARAM_10' => $destination,
				'PARAM_11' => $def_orientation);
			break;

 
	}
return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


function print_crm_buyer_inquriy($link_text, $link=true, $trans_type='', $icon=false, $class='printlink', $id='', $full_name ='', $email = '', 
	$looking_for = 0, $availability_type = 0, $payment_pref = 0, $community_pref="", $phase_pref="", $no_of_br=0, $single_row="", $bank="", 
	$specific_req="", $days=0, $budget=0, $phone="", $dest=0){


	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$class='printlink';
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	
	switch ($trans_type){
       case ST_BUYER :
			$rep = 857;
			$ar = array(
				'PARAM_0' => $dest,
			    'PARAM_1' => $full_name,
				'PARAM_2' => $email, 
				'PARAM_3' => $looking_for,
				'PARAM_4' => $availability_type,
				'PARAM_5' => $payment_pref,
				'PARAM_6' => $community_pref,
				'PARAM_7' => $phase_pref,
				'PARAM_8' => $no_of_br,
				'PARAM_9' => $single_row,
				'PARAM_10' => $bank,
				'PARAM_11' => $specific_req,
				'PARAM_12' => $days,
				'PARAM_13' => $budget,
				'PARAM_14' => $phone);
			break;
	}
	return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}


function print_crm_seller_inquriy($link_text, $link=true, $trans_type='', $icon=false, $class='printlink', $id='', $full_name ='', $email = '', 
	$offer_type = 0, $property_category = 0, $availability_status = 0, $br=0, $community="", $phase="", $location_detail="", $bua="", $plot="", 
	$vaastu_compliant="", $financial_status=0, $mortgage_amount=0, $view="", $rent_amount=0, $expiry_date_from="", $expiry_date_to="", $phone="",
	$dest=0){


	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
	$class='printlink';
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	
	switch ($trans_type){
       case ST_SELLER :
			$rep = 858;
			$ar = array(
				'PARAM_0' => $dest,
			    'PARAM_1' => $full_name,
				'PARAM_2' => $email, 
				'PARAM_3' => $offer_type,
				'PARAM_4' => $property_category,
				'PARAM_5' => $availability_status,
				'PARAM_6' => $br,
				'PARAM_7' => $community,
				'PARAM_8' => $phase,
				'PARAM_9' => $location_detail,
				'PARAM_10' => $bua,
				'PARAM_11' => $plot,
				'PARAM_12' => $vaastu_compliant,
				'PARAM_13' => $financial_status,
				'PARAM_14' => $mortgage_amount,
				'PARAM_15' => $view,
				'PARAM_16' => $rent_amount,
				'PARAM_17' => $expiry_date_from,
				'PARAM_18' => $expiry_date_to,
				'PARAM_19' => $phone);
			break;
	}
	return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}



//-------------------------------------------------------------------------------------------



//
//	Universal link to any kind of report.
//
function print_link($link_text, $rep, $pars = array(), $dir = '', 
	$icon=false, $class='printlink', $id='')
{
	
	global $path_to_root, $SysPrefs;
    //      if($_SESSION['SysPrefs']->prefs['rep_style']=='NEW')
    // 	$url = $dir == '' ?  $path_to_root.'/reporting2/prn_redirect.php?' : $dir; 
    // else
	$url = $dir == '' ?  $path_to_root.'/reporting/prn_redirect.php?' : $dir;

	$id = default_focus($id);
	foreach($pars as $par => $val) {
		$pars[$par] = "$par=".urlencode($val);
	}
	$pars[] = 'REP_ID='.urlencode($rep);
	$url .= implode ('&', $pars);

	if ($class != '')
		$class = $SysPrefs->pdf_debug ? '' : " class='$class'";
	if ($id != '')
		$id = " id='$id'";
	$pars = access_string($link_text);
	if (user_graphic_links() && $icon)
		$pars[0] = set_icon($icon, $pars[0]);
	return "<a target='_blank' href='$url'$id$class $pars[1]>$pars[0]</a>";
}

function meta_print_link($link_text, $rep, $pars = array(), $dir = '', 
	$icon=false, $class='printlink', $id='')
{

	global $path_to_root, $pdf_debug;

	$url = $dir == '' ?  $path_to_root.'/reporting/prn_redirect.php?' : $dir;

	$id = default_focus($id);
	foreach($pars as $par => $val) {
		$pars[$par] = "$par=".urlencode($val);
	}
	$pars[] = 'REP_ID='.urlencode($rep);
	$url .= implode ('&', $pars);

	if ($class != '')
		$class = $pdf_debug ? '' : " class='$class'";
	if ($id != '')
		$id = " id='$id'";
	$pars = access_string($link_text);
	if (user_graphic_links() && $icon)
		$pars[0] = set_icon($icon, $pars[0]);

	// display_error($url.$id.$class. $pars[1]);
	// exit();
	// return '<meta http-equiv="refresh" content="5; URL=javascript:window.open('.$url.$id.$class. $pars[1].',"_parent");">';
	// "<a target='_blank' href='$url'$id$class $pars[1]>$pars[0]</a>"
	// display_error($url);
	// exit();
	echo '<script type="text/javascript">
            open_meta_print("'.$url.'");
        function open_meta_print(url) {
    		window.open(url, "_blank", "toolbar=no,scrollbars=no,resizable=yes,top=130,left=300,width=800,height=500,location=no, title=no");
  		}
        </script>';
	// return print_meta_forward($url);
	// return '<meta http-equiv="refresh" content="5; URL=javascript:window.open(\'http://google.com\',\'_parent\');">';
}

//------------------------------------------------------------------------------------------------------------------------


function parse_notes_params($str, $sep=" ", $delim="#") {
    $str_params = explode($sep, $str);
    $param_array=Array('notes' => '');
    foreach ($str_params AS $str_param) {
        $param_set=explode($delim, trim($str_param));
        $key = (array_key_exists(0, $param_set) ? trim($param_set[0]) : '');
        $val = (array_key_exists(1, $param_set) ? trim($param_set[1]) : '');
        if (strlen($key) > 0 && strlen($val) > 0) {
            $param_array[$key]=$val;
        } else {
            // stop at first missing parameter set
            // break;
            // Collect the rest into notes
            $param_array['notes'] .= (" " .  $str_param);
        }
    }
    $param_array['notes'] = trim($param_array['notes']);
    return $param_array;
}


//-----------------------------------------------------------------------------------------------------------------------
function print_document_access_link2($doc_no, $link_text, $link=true, $type_no, 
	$icon=false, $class='printlink', $id='', $email=0, $extra=0, $size='A4', $meta_type= 0,$role=0, $opportunity_id=0 )
{
	$class='printlink';
	global $path_to_root;
	include_once($path_to_root . "/includes/types.inc");
 
	$url = $path_to_root.'/reporting/prn_redirect.php?';
	$def_orientation = (user_def_print_orientation() == 1 ? 1 : 0);
	switch ($type_no)
	{
    case 10001  :
	
			$rep = 10001;
			// from, to, email, comments, orientation
			$ar = array(
				'PARAM_0' => $role, 
				'PARAM_1' => 0, 
				'PARAM_2' => 0, 
				'PARAM_3' => $def_orientation,
				'PARAM_4' => $opportunity_id
			);
	// display_error($role);
	// exit();
			break;

		
	   
		default:
			return null;
	}
    if ($meta_type != 0)
        meta_print_link($link_text, $rep, $ar, "", $icon, $class, $id);
    else
	    return print_link($link_text, $rep, $ar, "", $icon, $class, $id);
}